<?php
ini_set("session.cookie_lifetime","7200");
ini_set("session.gc_maxlifetime","7200");
session_start();

date_default_timezone_set('America/Lima');
include 'config/db.php';
include 'config/conexion.php';
/*
include 'config/dbsec.php';
include 'config/conexionsec.php';
*/
if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
        }


if ($_SESSION['pzmdpgeneral']==0) {
     header("location: ./denegado.php");
		exit;
        }
        
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}

?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title>Verisure | VeriSmart</title>
        <!-- Tell the browser to be responsive to screen width -->
        <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
        <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" >
        <!-- EMU - ESTILOS PERSONALES -->
        <link rel="stylesheet" href="css/main.css">
        <!-- Bootstrap 3.3.7 -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
        <!-- Font Awesome -->
        <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
        <!-- Ionicons -->
        <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
        <!-- Select2 -->
        <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">

        <!-- Theme style -->
        <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
        <!-- AdminLTE Skins. Choose a skin from the css/skins
             folder instead of downloading all of them to reduce the load. -->
        <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
        
        
        <link rel="stylesheet" href="admin/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
        
        <!-- daterange picker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-daterangepicker/daterangepicker.css">
        <!-- bootstrap datepicker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
        <!-- iCheck for checkboxes and radio inputs -->
        <link rel="stylesheet" href="admin/plugins/iCheck/all.css">
        <!-- Bootstrap Color Picker -->
        <link rel="stylesheet" href="admin/bower_components/bootstrap-colorpicker/dist/css/bootstrap-colorpicker.min.css">
        <!-- Bootstrap time Picker -->
        <link rel="stylesheet" href="admin/plugins/timepicker/bootstrap-timepicker.min.css">
        

        <link href="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.css" rel="stylesheet" type="text/css"/>
        <!-- bootstrap wysihtml5 - text editor -->
        <link rel="stylesheet" href="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.min.css">
        
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>

        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->

        <link href="admin/bower_components/bootstrap-table/dist/bootstrap-table.min.css" rel="stylesheet" type="text/css"/>

        <!-- Google Font -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">

        <!-- Alertifyjs -->
        <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
        <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
        
        <link href="admin/plugins/bootstrap-toggle-master/css/bootstrap-toggle.min.css" rel="stylesheet" type="text/css"/>
        

        <style>

            .modal-header-danger {
                color:#fff;
                background-color: #fb1e1e;              
            }

            .espacio{
                height:10px;
            }

            .espacio2{
                height:15px;
            }

            .thumbnail_style{
                text-align:center;
                border:none;
            }


            .caption h4{
                margin-top: -10px;
                font-size:13px;
                font-weight:  bold;
            }

            .caption p{
                color:#777;
                font-size:13px;
            }

            .caption a{
                color:#777;
                font-size:10px;
            }


            #myWizard2 .form-control{
                border-radius: 4px
            }

            #c-slider{
                margin: auto;
                width: 100%;
                max-width: 900px;
                position: relative;
                overflow: hidden;

            }
            #slider{
                display: flex;
                width: 200%;

            }
            #slider section{
                width: 100%;
            }


            .select2-container--default .select2-selection--single {

                border: 1px solid #d2d6de;
                border-radius: 4px;
                font-size: 16px;
            }

            .btn-nuevo { 
                color: #FFFFFF; 
                background-color: #444444; 
                border-color: #444444; 
            } 

            .btn-nuevo:hover, 
            .btn-nuevo:focus, 
            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                color: #FFFFFF; 
                background-color: #616161;  
                border-color: #444444; 
            } 

            .btn-nuevo:active, 
            .btn-nuevo.active, 
            .open .dropdown-toggle.btn-nuevo { 
                background-image: none; 
            } 

            .btn-nuevo.disabled, 
            .btn-nuevo[disabled], 
            fieldset[disabled] .btn-nuevo, 
            .btn-nuevo.disabled:hover, 
            .btn-nuevo[disabled]:hover, 
            fieldset[disabled] .btn-nuevo:hover, 
            .btn-nuevo.disabled:focus, 
            .btn-nuevo[disabled]:focus, 
            fieldset[disabled] .btn-nuevo:focus, 
            .btn-nuevo.disabled:active, 
            .btn-nuevo[disabled]:active, 
            fieldset[disabled] .btn-nuevo:active, 
            .btn-nuevo.disabled.active, 
            .btn-nuevo[disabled].active, 
            fieldset[disabled] .btn-nuevo.active { 
                background-color: #444444; 
                border-color: #444444; 
            } 

        </style>
        <style>
       .main-header,.main-sidebar,.left-side{position:fixed}
       
      .main-header {
    top: 0;
    right: 0;
    left: 0
}
 .content-wrapper,
 .right-side {
    padding-top: 50px
}

@media (max-width:767px) {
     .content-wrapper,
     .right-side {
        padding-top: 100px
    }
}

.layout-boxed .wrapper {
    max-width: 100%
}

.wrapper {
    overflow: hidden

 .control-sidebar {
    position: fixed;
    height: 100%;
    overflow-y: auto;
    padding-bottom: 50px
}       
        

        

  </style>
        <style>
        html, body { margin: 0; padding: 0; height: 100%; } </style>

        <link rel="stylesheet" href="//code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css">
        <style>


            .ui-autocomplete {
                position: absolute;
                z-index: 1000;
                cursor: default;
                padding: 0;
                margin-top: 2px;
                list-style: none;
                font-size: 11px;
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                background-color: #ffffff;
                border: 1px solid #ccc;
                -webkit-border-radius: 5px;
                -moz-border-radius: 5px;
                border-radius: 5px;
                -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
                box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);

                z-index: 1051 !important;    

            }

  input[type="search"]::-webkit-search-cancel-button {
    -webkit-appearance: searchfield-cancel-button;
  }
  
    
  .pie-title-center {
                display: inline-block;
                position: relative;
                text-align: center;
            }

            .pie-value {
                display: block;
                position: absolute;
                font-size: 25px;
                height: 40px;
                top: 50%;
                left: 0;
                right: 0;
                margin-top: -20px;
                line-height: 40px;
            }
            
                        .label-ico{
                background:#e30613;
                color:#fff;
                padding: 6px 6px 6px;
                font-size:14px;

            }
            .offer-radius{
                border-radius:7px;
            }

        </style>






    </head>


    <body class="sidebar-collapse skin-red sidebar-mini" onload="javascript:mostrarhorareal()">

        <div class="wrapper">
            <!-- Header -->
            <?php include 'admin/header.php'; ?>
            <!-- Left side column. contains the logo and sidebar -->
            <?php
 
            
            $mediodepagos= "active";
            $mdpgeneral="active";

            include 'admin/main-sidebar.php';
            ?>



            <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div style="font-size:180%;"> MEDIO DE PAGOS &nbsp <span style="font-size:80%;color:#DAD8D4"> | &nbsp <span style="font-size:80%;color:#8D8A80"> CONFIGURACIÓN </span></span> </div> 
                <ol class="breadcrumb">
                    <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                    <li><a href="mediosdepagos.php">MDP</a></li>
                    <li class="active">Registro</li>
                </ol>


            </section>

            <!-- Main content -->
            <section class="content">
                
                    <div class="row">
                                   
                    <div class="col-md-12">
                        <div class="box box-danger">
                            <div class="box-header">
                                <div id="contenedor" hidden="hidden"></div>
                                <div class="col-md-9 no-padding-left">
                                    <form name="form-buscar" action="">
                                        
                                        <div class="col-md-3 no-padding-left">
                                            <select class="form-control filtro_url select2"
                                                    style="width: 100%; font-size: 16px;" name="CodigoMdp" id="CodigoMdp" onchange="fun_buscar_url(this.form)">
                                                <option style="display:none;" value="0">--SELECCIONAR URL--</option>
                                                <?php
                                                                try{
                                                                    $sqlURL = "SELECT IdMdp, CodigoMDP FROM tblmdp order by estadoURL";
                                                                    $resultadoURL = $con->query($sqlURL);
                                                                    while ($codigoMDP = $resultadoURL->fetch_assoc()){ ?>
                                                                    <option value="<?php echo $codigoMDP['IdMdp']; ?>"><?php echo $codigoMDP['CodigoMDP']; ?></option>
                                                                <?php }
                                                                } catch (\Exception $e) {
                                                                    echo "Error: " . $e.getMessage();
                                                                }
                                                            ?>
                                            </select>
                                        </div>
                                        
                                        
                                        <div class="col-md-4">
                                            <div class="input-group">
                                                <button type="button" class="btn btn-default pull-right" style="width: 100%; font-size: 16px;" id="daterange-btn">
                                                    <i class="fa fa-calendar"></i> 
                                                    <input type="hidden">
                                                    <span id="daterange-span">FILTRAR POR FECHA DE REGISTRO</span>
                                                    <i class="fa fa-caret-down"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="col-md-9 no-padding-left">
                                    <div class="col-md-9 no-padding-left" style="font-size: 16px; padding-top: 10px;">
                                    Total Registros: &nbsp&nbsp<span id="count"></span>
                                    </div>
                                </div>
                                <!--
                                <table  style="width:90%;">
                                    <tr>
                                        <td style="width: 7%;"><h3 class="box-title">BUSCAR:</h3></td>
                                        <td style="width: 83%;"><div class="input-group input-group-sm" style="width: 200px;">
                                        <input type="search" name="table_buscar" oninput="onFilterChanged(this.value)" class="form-control" placeholder="">
                                            <div class="input-group-btn">
                                            <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
                                            </div>
                                            </div>
                                        </td>
                                    </tr>

                                        <td>Total Registros: <span id="count"></span></td> 
                                    </table>
                                 -->
                               <div class="box-tools pull-right">
                                    <a class="btn btn-default btn-sm"  href="#" style="border-radius: 0px;" onclick="javascript:window.location.reload();"><i class="fa fa-refresh"></i></a>
                                    <button type="submit" class="btn btn-nuevo btn-sm" style="border-radius: 0px;" data-toggle="modal" data-target="#modal-default" id="btn_nuevo_url"><i class="fa fa-plus"></i> NUEVO URL</button>
                                </div>
                            </div>
                            <!-- /.box-header -->

                            <div class="box-body" id="vistaboy">
                                <div id="myGrid"  style="height: 100%" class="ag-theme-fresh"></div>
                                <div  id="ningunresultado"></div>
                               
                            </div>

                            <!-- /.box-body -->

                        </div>
                        <!-- /.box -->
                    </div>

                    </div>
                  
               

            </section>
            <!-- /.content -->
            
           
            <div class="modal fade" id="modal-editarUrl">
                
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h3>EDITAR URL</h3>
                        </div>
                        
                        <div class="modal-body">
                            <form id="actualizarUrl" method="POST">
                                <div class="espacio"></div>
                                <table  cellspacing="0"  style="width:100%;border-collapse: separate;border: #dfdfdf 1px solid;padding: 10px;" >
                                         <tr>
                                            <td style="width:15%;font-size: 12px">URL:</td>
                                            <td colspan="5" style="width:50%">
                                                <textarea class="form-control input-sm" name="lblurle" rows="1" style="resize:none" id="lblurle" placeholder="Ingresar..." disabled></textarea>
                                                <input id="lblidmdpe" name="lblidmdpe" hidden="">
                                            </td>
                                        </tr> 
                                        <tr class="espacio"></tr>

                                                                <tr>
                                                                    <td style="width:15%;font-size: 12px">F. VENCIMIENTO:</td>

                                                                    <td style="width:25%;"><div class="input-group">
                                                                                <div class="input-group-addon input-sm">
                                                                                    <i class="fa fa-calendar"></i>
                                                                                </div>
                                                                                <input type="text" class="form-control pull-right input-sm" id="lblfvencimientoe"  name="lblfvencimientoe" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                                            </div></td>
                                                                    <td style="width:10%"></td>
                                                                    <td style="width:15%;font-size: 12px">H. VENCIMIENTO:</td>
                                                                    <td style="width:2%"></td>
                                                                    <td style="width:25%">
                                                                        <div class="bootstrap-timepicker timepicker">
                                                                             <div class="input-group">
                                                                                 <input type="text" class="form-control input-sm" placeholder="12:00:00" name="lblhvencimientoe" id="lblhvencimientoe" >
                                                                                    <div class="input-group-addon input-sm">
                                                                                        <i class="fa fa-clock-o"></i>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        
                                                                    </td>
                                                                </tr>
                                                                <tr class="espacio"></tr>
                                                                
                                                                            <tr>
                                                                    <td style="width:15%;font-size: 12px">CANT. TRANSACCION:</td>

                                                                    <td style="width:25%"> <input type="text" class="form-control input-sm" name="lblcanttransaccione" id="lblcanttransaccione" onkeypress="return filterFloat(event, this);">

                                                                    </td>
                                                                    <td style="width:10%"></td>
                                                                    <td style="width:15%;font-size: 12px">ESTADO URL:</td>
                                                                    <td style="width:2%"></td>
                                                                    <td style="width:25%">
                                                                        <input type="checkbox" name="lblEditarestadourle" id="lblEditarestadourle" data-width="100">
                                                                        <input type="hidden" name="hidden_lblEditarestadourle" id="hidden_lblEditarestadourle" >
                                                                    </td>
                                                                </tr>

 <tr class="espacio"></tr>
                                                                                                                    <tr>
                                                                    <td style="width:15%;font-size: 12px">AREA:</td>

                                                                    <td style="width:25%">
                                                                        <select class="form-control input-sm" name="lblareae" id="lblareae">
                                                                                <option>Seleccione</option>
                                                                                 <option value="Venta">Venta</option>
                                                                                <option value="Ampliacion">Ampliacion</option>
                                                                            </select>
                                                                    </td>
                                                                    <td style="width:10%"></td>
                                                                    <td style="width:15%;font-size: 12px"></td>
                                                                    <td style="width:2%"></td>
                                                                    <td style="width:25%">
                                                                    </td>
                                                                </tr> 
                                                                 <tr class="espacio"></tr>
                                        
                                        
                                    </table>
                            </form>
                            
                            <div class="espacio"></div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-nuevo" id="Cerrarmodal" data-dismiss="modal">Cerrar</button>
                                <input type="button" name="actualizar_url" id="actualizar_url" value="Actualizar" class="btn btn-danger" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal Opciones -->

            <div class="modal fade" id="modal-default">

                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header modal-header-danger">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h3 id="myModalLabel">REGISTRO DE URL</h3>
                        </div>


                    <div class="modal-body">
                        
                        <form id="frmMDP" method="POST">

                                                            <div class="espacio"></div>


                                                            <table  cellspacing="0"  style="width:100%;border-collapse: separate;border: #dfdfdf 1px solid;padding: 10px;" >

                                                                 <tr>
                                                                    <td style="width:15%;font-size: 12px">URL:</td>

                                                                    <td colspan="5" style="width:50%"><textarea class="form-control input-sm" name="lblurl" rows="1" style="resize:none" id="lblurl" placeholder="Ingresar..."></textarea>
                                                                    </td>
                
                                                                </tr> 
                                                                <tr class="espacio"></tr>
                                                                <tr>
                                                                    <td style="width:15%;font-size: 12px">F. VENCIMIENTO:</td>

                                                                    <td style="width:25%;"><div class="input-group">
                                                                                <div class="input-group-addon input-sm">
                                                                                    <i class="fa fa-calendar"></i>
                                                                                </div>
                                                                                <input type="text" class="form-control pull-right input-sm" id="lblfvencimiento"  name="lblfvencimiento" data-inputmask="'alias': 'dd/mm/yyyy'" data-mask>
                                                                            </div></td>
                                                                    <td style="width:10%"></td>
                                                                    <td style="width:15%;font-size: 12px">H. VENCIMIENTO:</td>
                                                                    <td style="width:2%"></td>
                                                                    <td style="width:25%">
                                                                        <div class="bootstrap-timepicker timepicker">
                                                                             <div class="input-group">
                                                                                 <input type="text" class="form-control input-sm" placeholder="12:00:00" name="lblhvencimiento" id="lblhvencimiento" >
                                                                                    <div class="input-group-addon input-sm">
                                                                                        <i class="fa fa-clock-o"></i>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        
                                                                    </td>
                                                                </tr>
                                                                <tr class="espacio"></tr>
                                                                
                                                                            <tr>
                                                                    <td style="width:15%;font-size: 12px">CANT. TRANSACCION:</td>

                                                                    <td style="width:25%"> <input type="text" class="form-control input-sm" name="lblcanttransaccion" id="lblcanttransaccion" onkeypress="return filterFloat(event, this);">

                                                                    </td>
                                                                    <td style="width:10%"></td>
                                                                    <td style="width:15%;font-size: 12px">ESTADO URL:</td>
                                                                    <td style="width:2%"></td>
                                                                    <td style="width:25%">
                                                                        <input type="checkbox" name="lblestadourl" id="lblestadourl" data-width="100">
                                                                        <input type="hidden" name="hidden_lblestadourl" id="hidden_lblestadourl" value="Inactivo">
                                                                    </td>
                                                                </tr>

 <tr class="espacio"></tr>
                                                                            <tr>
                                                                    <td style="width:15%;font-size: 12px">AREA:</td>

                                                                    <td style="width:25%">
                                                                        <select class="form-control input-sm" name="lblarea" id="lblarea">
                                                                                <option>Seleccione</option>
                                                                                 <option value="Venta">Venta</option>
                                                                                <option value="Ampliacion">Ampliacion</option>
                                                                            </select>
                                                                    </td>
                                                                    <td style="width:10%"></td>
                                                                    <td style="width:15%;font-size: 12px"></td>
                                                                    <td style="width:2%"></td>
                                                                    <td style="width:25%">
                                                                    </td>
                                                                </tr> 
                                                                 <tr class="espacio"></tr>
                                                            </table>


                                                        </form>
                        
                           <div class="modal-footer">
                                        
                                            <button type="button" class="btn btn-nuevo" id="Cerrarmodal" data-dismiss="modal">Cerrar</button>
                                            <a class="btn btn-danger" id="btnGuardarURL" href="#">Guardar</a>
                                            
                            </div>
                                                        

                                     
                        </div>



                    </div>  
                    <!-- /.modal-content -->

                </div>
                <!-- /.modal-dialog -->
            </div>
            <!-- /.modal -->

        </div>
        <!-- /.content-wrapper -->



            <div class="control-sidebar-bg"></div>
        </div>
        <!-- ./wrapper -->


        <!-- jQuery v1.11 -->

        <script src="admin/bower_components/jquery/dist/jquery_v1.11.js" type="text/javascript"></script>
        
        <script src="admin/plugins/bootstrap-toggle-master/js/bootstrap-toggle.min.js"></script>

        <!-- jQuery UI 1.11.4 -->
        <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
        <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
        <script>$.widget.bridge('uibutton', $.ui.button);</script>
        <!-- Bootstrap 3.3.7 -->
        <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
        <!-- Select2 -->
        <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
        <!-- Sparkline -->
        <script src="admin/bower_components/jquery-sparkline/dist/jquery.sparkline.min.js"></script>

        <!-- jQuery Knob Chart -->
        <script src="admin/bower_components/jquery-knob/dist/jquery.knob.min.js"></script> 
        <!-- Bootstrap WYSIHTML5 -->
        <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
        <!-- Slimscroll -->
        <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
        <!-- FastClick -->
        <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
        <!-- AdminLTE App -->
        <script src="admin/dist/js/adminlte.min.js"></script>
        <script src="admin/bower_components/ag-grid-master/dist/ag-grid.min.js" type="text/javascript"></script>
        <!-- InputMask -->
        <script src="admin/plugins/input-mask/jquery.inputmask.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.date.extensions.js"></script>
        <script src="admin/plugins/input-mask/jquery.inputmask.extensions.js"></script>

        <!-- date-range-picker -->
        <script src="admin/bower_components/moment/min/moment.min.js"></script>
        <script src="admin/bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
        <!-- bootstrap datepicker -->
        <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
        <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>
        <!-- bootstrap time picker -->
        <script src="admin/plugins/timepicker/bootstrap-timepicker.min.js"></script>

        <!-- Alertify -->
        <script src="admin/bower_components/alertifyjs/alertify.min.js" type="text/javascript"></script>
        
        <script src="admin/dist/js/pie-chart.js" type="text/javascript"></script>
        
        <!-- MAIN -->
        <script src="js/mediodepago.js" type="text/javascript"></script>

        <script>
        
     
    var columnDefs = [
                {headerName: '',
            field: 'IdMdp',
            width: 51,
            pinned: 'left',
            cellRenderer: function (params) {
                return '<div style="text-align: center;font-size: 1.7rem;"><a class="fa fa-edit edit-url" id="'+ params.value +'" title="Editar MDP" style="text-decoration:none;color:#4c4c4c;">\n\</a></div>'
            }
        },
        
        {headerName: 'CODIGOMDP', field: 'CodigoMDP', width: 150, cellRenderer: function (params) {
                
        return "<div style='text-align: center;height:100px;font-size: 1.5rem;'>" + params.value + "</div>";
                
        }},
        {headerName: 'URL', field: 'URL', width: 500, cellRenderer: function (params) {
                
        return "<div style='text-align: left;font-size: 1.5rem;'>" + params.value + "</div>";
                
        }},
        {headerName: 'FECHA REGISTRO', field: 'FechaHoraREG', width: 200, cellRenderer: function (params) {
                
        return "<div style='text-align: center;font-size: 1.5rem;'>" + params.value + "</div>";
                
        }},
        {headerName: 'FECHA VENCIMIENTO', field: 'FechaVencimiento', width: 200, cellRenderer: function (params) {
                
        return "<div style='text-align: center;font-size: 1.5rem;'>" + params.value + "</div>";
                
        }},
        {headerName: 'HORA VENCIMIENTO', field: 'HoraVencimiento', width: 200, cellRenderer: function (params) {
                
        return "<div style='text-align: center;font-size: 1.5rem;'>" + params.value + "</div>";
                
        }},
        {headerName: 'ESTADO URL', field: 'EstadoURL', width: 150,
          cellRenderer: function (params) {
                if (params.value == 'Activo') {
                    return "<div style='text-align: center;font-size: 1.5rem;'><span class='label label-danger'>"+params.value+"</span></div>";
                } else {
                    return "<div style='text-align: center;font-size: 1.5rem;'><span class='label label-default'>"+params.value+"</span></div>";
                }
            }},
        {headerName: 'GESTOR ORIGEN', field: 'GestorOrigen', width: 150,
            cellRenderer: function (params) {
               return "<div style='text-align: center;font-size: 1.5rem;'>" + params.value + "</div>";
        }},
        {headerName: 'CANTIDAD TRANSACCIONES', field: 'CantidadTransaccion', width: 250,
            cellRenderer: function (params) {
               return "<div style='text-align: center;font-size: 1.5rem;'>" + params.value + "</div>";
        }},
        /*
        {headerName: 'TRANSACCIONES REALIZADAS', field: 'CantTransaccion', width: 250,
            cellRenderer: function (params) {
               return "<div style='text-align: center;font-size: 1.5rem;'>" + params.value + "</div>";
        }},
        */
        {headerName: 'TRANSACCIONES REALIZADAS', field: 'Cant_adv_transaccion', width: 250,
            cellRenderer: function (params) {
                var Cant_adv_transaccion = params.value;
                var arr_cant_adv_transaccion = Cant_adv_transaccion.split("-");
                var resultadoGrid;
                
                if (arr_cant_adv_transaccion[1] == 'Minimo') {
                     resultadoGrid = "<div style='text-align: center;font-size: 1.5rem;width: 20%;/* left: 50%; *//* padding-left: 50px; */background-color: #00a65a;margin-left: 40%;border-radius: 4px;color: white;'><span><!--<i class='fa fa-check'></i>--></span>&nbsp&nbsp" + arr_cant_adv_transaccion[0] + "</div>";
                }else if(arr_cant_adv_transaccion[1] == 'Maximo'){
                     resultadoGrid = "<div style='text-align: center;font-size: 1.5rem;width: 20%;/* left: 50%; *//* padding-left: 50px; */background-color: #d33724;margin-left: 40%;border-radius: 4px;color: white;'><span><!--<i class='fa fa-ban'></i>--></span>&nbsp&nbsp" + arr_cant_adv_transaccion[0] + "</div>";
                }else if(arr_cant_adv_transaccion[1] == 'Medio'){
                     resultadoGrid = "<div style='text-align: center;font-size: 1.5rem;width: 20%;/* left: 50%; *//* padding-left: 50px; */background-color: #f39c12;margin-left: 40%;border-radius: 4px;color: white;'><span><!--<i class='fa fa-warning'></i>--></span>&nbsp&nbsp" + arr_cant_adv_transaccion[0] + "</div>";
                }else {
                     resultadoGrid = "<div style='text-align: center;font-size: 1.5rem;width: 20%;/* left: 50%; *//* padding-left: 50px; */background-color: #ca195a;margin-left: 40%;border-radius: 4px;color: white;'><span><!--<i class='fa fa-info'></i>--></span>&nbsp&nbsp&nbsp" + arr_cant_adv_transaccion[0] + "</div>";
                }

                return resultadoGrid;
                
                
        }},
         {headerName: 'AREA', field: 'Area', width: 150,
            cellRenderer: function (params) {
               return "<div style='text-align: center;font-size: 1.5rem;'>" + params.value + "</div>";
        }}
        
    ];


    var gridOptions = {
        columnDefs: columnDefs,
        onPaginationChanged: onPaginationChanged,
        rowData: null,
        enableFilter: true,
        enableColResize: true,
        localeText: {
            // for filter panel
            page: 'página',
            more: 'Más',
            to: 'a',
            of: 'de',
            next: 'Siguiente',
            last: 'Último',
            first: 'Primero',
            previous: 'Anterior',
            loadingOoo: 'Cargando...',
            // for set filter
            selectAll: 'Seleccionar todo',
            searchOoo: 'Buscando...',
            blanks: 'Espacios en blanco',
            // for number filter and text filter
            filterOoo: 'Filtrar...',
            applyFilter: 'Aplicar Filtro',
            // for number filter
            equals: 'Igual',
            notEqual: 'No es igual',
            lessThanOrEqual: 'Menor o igual',
            greaterThanOrEqual: 'Mayor que o igual',
            inRange: 'En el rango',
            lessThan: 'Menos que',
            greaterThan: 'Mas grande que',
            // for text filter
            contains: 'Contiene',
            startsWith: 'Comienza con',
            endsWith: 'Termina con',
            notContains:'No contiene',
            // the header of the default group column
            group: 'Grupo',
            // tool panel
            columns: 'columnas',
            rowGroupColumns: 'Grupo columnas',
            rowGroupColumnsEmptyMessage: 'No hay resultado',
            valueColumns: 'Columna de valor',
            pivotMode: 'Modo pivote',
            groups: 'grupos',
            values: 'valor',
            pivots: 'pivote',
            valueColumnsEmptyMessage: 'No hay resultado',
            pivotColumnsEmptyMessage: 'No hay resultado',
            // other
            noRowsToShow: '<div class="callout callout-danger">\n\
            <span class="pull-left">\n\
            <img src="admin/dist/img/noresults-img.png" style="width: 70%">\n\
            </span>\n\<h4><i class="fa fa-warning"></i> ¡ADVERTENCIA!</h4>\n\
            <strong>Lo sentimos, pero la búsqueda no devolvió ningún resultado.</strong><br>\n\
            <p>¿Has verificado que hayas ingresado algun registro?, de lo contrario comunicarse con soporteit@verisure.pe</p>\n\
            <br></div>'


            ,
            // enterprise menu
            pinColumn: 'Aclar columna',
            valueAggregation: 'Agregar valor',
            autosizeThiscolumn: 'Auto tamaño esta columna ',
            autosizeAllColumns: 'Auto tamaño todas columnas',
            groupBy: 'Agrupar',
            ungroupBy: 'Agrupar uno',
            resetColumns: 'Restaurar Columnas',
            expandAll: 'expandir todo',
            collapseAll: 'desplegar todo',
            toolPanel: 'Panel de Heramientas',
            export: 'Exportar',
            csvExport: 'Exportar CSV',
            excelExport: 'Exportar Excel',
            // enterprise menu pinning
            pinLeft: 'Anclar a derecha',
            pinRight: 'Anclar a izquierda',
            noPin: 'Desanclar',
            // enterprise menu aggregation and status panel
            sum: 'Sumar',
            min: 'Minimo',
            max: 'Maximo',
            first: 'Primero',
                    last: 'Ultimo',
                    none: 'Nada',
            count: 'Contador',
            average: 'Promedio',
            // standard menu
            copy: 'Copiar',
            copyWithHeaders: 'Copiar Cabecera',
            ctrlC: 'Ctrl+C',
            paste: 'Pegar',
            ctrlV: 'Ctrl+V'
        },
        enableSorting: true
    };
  
    
   function onPaginationChanged(params) {
    
      this.gridRowCount = params.api.paginationGetRowCount();
         $("#count").html(this.gridRowCount);
    }


    function onFilterChanged(value) {
        gridOptions.api.setQuickFilter(value);
    }
    
            
    
    function listar() {

        $.ajax({
            url: 'ajax/findDataMdp.php',
            success: function (data) {

                if (data == 1) {
                    var gridDiv = document.querySelector('#myGrid');
                    new agGrid.Grid(gridDiv, gridOptions);

                    agGrid.simpleHttpRequest({url: 'ajax/selectListarMdp.php'}).then(function (data) {

                        gridOptions.api.setRowData(data);
                    });
                    $('#vistaboy').height(function (index, height) {
                        return $(window).height() * 65 / 100;
                    });
                } else {

                    $("#ningunresultado").html(data);

                    var gridDiv = document.querySelector('#myGrid');
                    new agGrid.Grid(gridDiv, gridOptions);

                    agGrid.simpleHttpRequest({url: 'ajax/selectListarMdp.php'}).then(function (data) {

                    gridOptions.api.setRowData(data);
                    });

                    $('#myGrid').hide("fast");
                }
            }
        });
    }

     var refresh = function () {

        $.ajax({
            url: 'ajax/findDataMdp.php',
            success: function (data) {
                
                console.log(data);

                if (data == 1) {

                    var gridDiv = document.querySelector('#myGrid');
                    agGrid.simpleHttpRequest({url: 'ajax/selectListarMdp.php'}).then(function (data) {
                    gridOptions.api.setRowData(data);
                    });
                    $('#vistaboy').height(function (index, height) {

                        return $(window).height() * 65 / 100;
                    });
                    $("#ningunresultado").hide("fast");
                    $('#myGrid').show(200);
                } else {

                    $("#ningunresultado").html(data);
                    $('#myGrid').hide("fast");

                }
        }
        });

    }
    

    // setup the grid after the page has finished loading
    document.addEventListener('DOMContentLoaded', function () {
        listar();
        
    });

    </script>

    <script>
        $(function () {
            
                        //TOGGLE
            
            $('#frmMDP #lblestadourl').bootstrapToggle({
                      on: 'Activo',
                      off: 'Inactivo',
                    onstyle:'success',
                    offstyle:'danger'
                    });
                    
            $('#lblestadourl').change(function(){
              if($(this).prop('checked')){
                 $('#hidden_lblestadourl').val('Activo');
              }else{
                $('#hidden_lblestadourl').val('Inactivo');
               }
            });
                    
            $('#actualizarUrl #lblEditarestadourle').bootstrapToggle({
                      on: 'Activo',
                      off: 'Inactivo',
                    onstyle:'success',
                    offstyle:'danger'
                });
                
            $('#actualizarUrl #lblEditarestadourle').change(function(){
              if($(this).prop('checked')){
                 $('#hidden_lblEditarestadourle').val('Activo');
              }else{
                $('#hidden_lblEditarestadourle').val('Inactivo');
               }
            });
                    
                    $('#frmMDP #lblestadourl').change(function(){
  if($(this).prop('checked')){
     $('#hidden_lblestadourl').val('Activo');
  }else{
    $('#hidden_lblestadourl').val('Inactivo');
   }
});
                $(document).on('click', '.edit-url', function(){  
           var mdp_id = $(this).attr("id");
           
           $.ajax({  
                url:"ajax/findMDP.php",  
                method:"POST",  
                data:{mdp_id:mdp_id},  
                dataType:"json",  
                success:function(data){
                     $('#lblurle').val(data.URL);
                     $('#lblidmdpe').val(data.IdMdp);
                     $('#lblhvencimientoe').val(data.HoraVencimiento);
                     $('#lblcanttransaccione').val(data.CantidadTransaccion);
                     $('#lblareae').val(data.Area);
                                 $('#lblfvencimientoe').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1
                    }).datepicker("setDate", data.FechaVencimiento);
            
                     
                     if(data.EstadoURL=='Activo'){
                         $("#lblEditarestadourle").prop('checked', true).change();
                     }else{
                         $("#lblEditarestadourle").prop('checked', false).change();
                     }
                     $('#hidden_lblEditarestadourle').val(data.EstadoURL);
                     $('#modal-editarUrl').modal('show');  
                    
                }  
           });  
      });
                    


        });


    </script>

    <script>
        $(document).ready(function () {

            var alterClass = function () {
                var ww = document.body.clientWidth;
                if (ww < 767) {
                    $('body').removeClass('sidebar-collapse');

                } else if (ww >= 768) {
                    $('body').addClass('sidebar-collapse');

                }
            };
            
            //LIMPIAR FORMULARIO DE REGISTRO
            
            $(document).on('click', '#btn_nuevo_url', function(){
                $("#lblurl").val("");
                $("#lblcanttransaccion").val("");
                $('#lblarea').val("");
            });
        
            
            
            $(window).resize(function () {
                alterClass();
            });
            //Fire it when the page first loads:
            alterClass();


            $('#btnGuardarURL').click(function () {
                var gestororigen='<?php echo $matriculausuario;?>';
                var area=$('#lblarea').val();

                if (validaForm()) {
                    // Primero validará el formulario.
                    var datos = $('#frmMDP').serialize();
                    $.ajax({
                        url: 'ajax/findMdp.php',
                        method: "POST",
                        data: "area="+area+"&gestororigen="+gestororigen+"&"+datos,
                        dataType: "json",
                        success: function (data) {
                                if (data.cantidad > 0 && $("#frmMDP #hidden_lblestadourl").val()=='Activo' ) {
                                    
                                    alertify.defaults.theme.ok = "btn btn-nuevo";
                                    alertify.defaults.theme.cancel = "btn btn-danger";
                                    
                                    var lastX,lastY;
                                    alertify.confirm('<span style="color:red"><i class="fa fa-bullhorn"></i></span><strong> IMPORTANTE</strong>', 'Actualmente existe la '+data.CodigoMDP+': </br> '+data.URL+' </br> ¿Deseas continuar de todas formas?', function(){ 
                                        var idmdp=data.IdMdp;
                                        //ACTUALIZAR EL REGISTRO ANTERIOR A INACTIVO
                                        //REGISTRAR NUEVA URL
                                        $.ajax({
                                            type: 'POST',
                                            url: 'ajax/insertMDP.php',
                                            data: 'idmdp='+idmdp+'&'+datos,
                                            success: function (r) {
                                            if (r == 1) {

                                           refresh();
                                           $('#modal-default').modal('hide'); 
                                           alertify.success("Agregado con exito");

                                            } else {
                                            alertify.error("Fallo el server");
                                            } 
                                            }// END SUCCESS
                                        });
        
    }
                , function(){ alertify.error('No se han guardado los cambios')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
        
            lastX = window.scrollX;
        lastY = window.scrollY;
      },
      'onfocus':function(){
        window.scrollTo(lastX, lastY);
      }  }).show(); 
                                    
                                    
                                
                                 } //END IF
                               else {
                                   $.ajax({
                                            type: 'POST',
                                            url: 'ajax/insertMDP.php',
                                            data: datos,
                                            success: function (r) {
                                            if (r == 1) {

                                           refresh();
                                           $('#modal-default').modal('hide'); 
                                           alertify.success("Agregado con exito");
                                            } else {
                                            alertify.error("Fallo el server");
                                            } 
                                            }// END SUCCESS
                                    });
                               }
                        } //END SUCCESS
                    });
                }

            });
            

            
            $('#actualizar_url').click(function () {
                var area=$('#lblareae').val();

                if (validaFormEditar()) {
                    // Primero validará el formulario.
                    var datos = $('#actualizarUrl').serialize();
                    
                    $.ajax({
                        url: 'ajax/findMdp.php',
                        method: "POST",
                        data:"area="+area+"&"+datos,
                        dataType: "json",
                        success: function (data) { console.log(data);
                                if (data.cantidad > 0 && $("#actualizarUrl #hidden_lblEditarestadourle").val()=='Activo'  && data.IdMdp!= $("#actualizarUrl #lblidmdpe").val()) {
                                    
                                    alertify.defaults.theme.ok = "btn btn-nuevo";
                                    alertify.defaults.theme.cancel = "btn btn-danger";

                                    var lastX,lastY;
                                    alertify.confirm('<span style="color:red"><i class="fa fa-bullhorn"></i></span><strong> IMPORTANTE</strong>', 'Actualmente existe la '+data.CodigoMDP+':</br> '+data.URL+' </br> ¿Deseas continuar de todas formas?', function(){ 
                                        var idmdp=data.IdMdp;
                                        //ACTUALIZAR EL REGISTRO ANTERIOR A INACTIVO
                                        
                                        //REGISTRAR NUEVA URL
                                        
                                        $.ajax({
                                            type: 'POST',
                                            url: 'ajax/updateMDP.php',
                                            data: 'idmdp='+idmdp+'&'+datos,
                                            success: function (r) {
                                            if (r == 1) {

                                          refresh();
                                          $('#modal-editarUrl').modal('hide'); 
                                          alertify.success("Modificado con exito");

                                            } else {
                                            alertify.error("Fallo el server");
                                            } 
                                            }// END SUCCESS
                                        });
        
    }
                , function(){ alertify.error('No se han guardado los cambios')}).set({transition:'zoom','labels': {ok:'<i class="fa fa-check"></i> Aceptar', cancel:'<i class="fa fa-remove"></i> Cancelar'},'onshow':function(){
        
            lastX = window.scrollX;
        lastY = window.scrollY;
      },
      'onfocus':function(){
        window.scrollTo(lastX, lastY);
      }  }).show(); 
                                    
                                    
                                
                                 } //END IF
                              else {
                                  $.ajax({
                                            type: 'POST',
                                            url: 'ajax/updateMDP.php',
                                            data: datos,
                                            success: function (r) {
                                            if (r == 1) {

                                          refresh();
                                          $('#modal-editarUrl').modal('hide'); 
                                          alertify.success("Modificado con exito");

                                            } else {
                                            alertify.error("Fallo el server");
                                            } 
                                            }// END SUCCESS
                                    });
                              }
                        } //END SUCCESS
                    });
                }

            });
            
                        
       $('#lblhvencimiento').timepicker({
                    useCurrent: false,
                    format: 'HH:mm',
                    
                    showMeridian: false,
                    showInputs: true,
                    minuteStep: 1
                                                                                
                                                                              });    
                                                                              
       $('#lblhvencimientoe').timepicker({
           
           useCurrent: false,
    format: 'HH:mm',
    
    showMeridian: false,
                                                                                    showInputs: true,
                                                                                     minuteStep: 1
                                                                                  
                                                                              });
                                                                             
                                                                                      
                //Date range as a button
                $('#daterange-btn').daterangepicker(
                  {
                    locale: { 
                        applyLabel: 'OK',
                        cancelLabel: 'LIMPIAR',
                        customRangeLabel: "Personalizado",
                        monthNames: [
                            "Enero",
                            "Febrero",
                            "Marzo",
                            "Abril",
                            "Mayo",
                            "Junio",
                            "Julio",
                            "Agusto",
                            "Septiembre",
                            "Octubre",
                            "Noviembre",
                            "Diciembre"
                        ]
                        },
                        "showDropdowns": true,
                        "alwaysShowCalendars": true,
                        linkedCalendars: false,
                        opens : "right",
                    ranges   : {
                      'Hoy'       : [moment(), moment()],
                      'Ayer'   : [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                      'Ultimos 7 días' : [moment().subtract(6, 'days'), moment()],
                      'Ultimos 30 días': [moment().subtract(29, 'days'), moment()],
                      'Mes actual'  : [moment().startOf('month'), moment().endOf('month')],
                      'Mes pasado'  : [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                    },
                    startDate: moment().subtract(29, 'days'),
                    endDate  : moment()
                  }, function (start, end) {
                    $('#daterange-btn span').html(start.format('YYYY-MM-DD') + '-' + end.format('YYYY-MM-DD'));
                    $('#daterange-span').css({"padding":"0 40px"});
                  })
                  
                  $('#daterange-btn').on('cancel.daterangepicker', function(ev, picker) {
                      //do something, like clearing an input
                      $('#daterange-span').css({"padding":"0"});
                      $('#daterange-span').html("FILTRAR POR FECHA DE REGISTRO");
                      refresh();
                  });
                  
                  $('#daterange-btn').on('apply.daterangepicker', function(ev, picker) {
                      refreshGridxFecha(picker.startDate.format('YYYY-MM-DD'), picker.endDate.format('YYYY-MM-DD'));
                  });
                
            //Initialize Select2 Elements
                                
            $('.select2').select2();
            
            $(".filtro_url").select2({
                placeholder: 'Seleccione URL',
				allowClear: true
			});

            $('#datemask').inputmask('dd/mm/yyyy', {'placeholder': 'dd/mm/yyyy'});

            $('#bodyprincipal').slimScroll({
                height: '250px'
            });
            $('#bodyeditarventa').slimScroll({
                height: '500px'
            });

            $('#d').click(function () {
                
            });
            //Money Euro
            $('[data-mask]').inputmask();
            //Date picker
            
            var date = new Date(); 
            var today = new Date(date.getFullYear(), date.getMonth(), date.getDate());

            $('#lblfvencimiento').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1,
                startDate: today 
            }).datepicker("setDate", new Date());
            
            /*
            $('#lblfvencimientoe').datepicker({
                autoclose: true,
                language: 'es',
                firstDay: 1
            });
            
            */
            //Date picker

        });




        function validaForm() {
            // Campos de texto
            var hoy='<?php echo date("d/m/Y");?>';
            var hoyfechahora = document.getElementById("contenedor").innerText;


            if ($("#frmMDP #lblurl").val() == "") {
                alertify.warning("Por favor ingresar la URL correspondiente");
                $("#frmMDP #lblurl").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            if ($("#frmMDP #lblfvencimiento").val() == "") {
                alertify.warning("Por favor ingresar la Fecha de Vencimiento");
                $("#frmMDP #lblfvencimiento").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            
            if ($("#frmMDP #lblhvencimiento").val() == "") {
                alertify.warning("Por favor ingresar la Hora de Vencimiento");
                $("#frmMDP #lblhvencimiento").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            
            if(Date.parse(toJSDate(hoy+' '+hoyfechahora))>Date.parse(toJSDate($("#frmMDP #lblfvencimiento").val()+" "+$("#frmMDP #lblhvencimiento").val()))){
                        alertify.warning("Por favor ingresar la Hora de Vencimiento valida mayor o igual a "+hoyfechahora);
                $("#frmMDP #lblhvencimiento").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
           return false;
            }
            
            if ($("#frmMDP #lblcanttransaccion").val() == "") {
                alertify.warning("Por favor ingresar la Cantidad de Transaccion");
                $("#frmMDP #lblcanttransaccion").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
                    if ($("#frmMDP #lblcanttransaccion").val() == 0) {
                alertify.warning("Por favor ingresar la Cantidad de Transaccion diferente a 0.");
                $("#frmMDP #lblcanttransaccion").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            
            if ($("#frmMDP #hidden_lblestadourl").val() == "") {
                alertify.warning("Por favor ingresar EstadoURL correcto");
                $("#frmMDP #lblestadourl").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            
            if ($("#frmMDP #lblarea").val() == "" || $("#frmMDP #lblarea").val() == "Seleccione") {
                alertify.warning("Por favor seleccionar Area correcto");
                $("#frmMDP #lblarea").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            return true;
        }
        function validaFormEditar() {
            
            var hoy='<?php echo date("d/m/Y");?>';
            var hoyfechahora = document.getElementById("contenedor").innerText;
            // console.log(toJSDate($("#actualizarUrl #lblfvencimientoe").val()+" "+$("#actualizarUrl #lblhvencimientoe").val()));

            if ($("#actualizarUrl #lblfvencimientoe").val() == "") {
                alertify.warning("Por favor ingresar la Fecha de Vencimiento");
                $("#actualizarUrl #lblfvencimientoe").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }

            if ($("#actualizarUrl #lblhvencimientoe").val() == "") {
                alertify.warning("Por favor ingresar la Hora de Vencimiento");
                $("#actualizarUrl #lblhvencimientoe").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            
            if(validate_fechaMayorQue(hoy,$("#actualizarUrl #lblfvencimientoe").val())){}else{
             alertify.warning("Por favor ingresar la Fecha de Vencimiento valida mayor o igual a "+hoy);
                $("#actualizarUrl #lblfvencimientoe").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
           return false;
        }
        
        if(Date.parse(toJSDate(hoy+' '+hoyfechahora))>Date.parse(toJSDate($("#actualizarUrl #lblfvencimientoe").val()+" "+$("#actualizarUrl #lblhvencimientoe").val()))){
                        alertify.warning("Por favor ingresar la Hora de Vencimiento valida mayor o igual a "+hoyfechahora);
                $("#actualizarUrl #lblhvencimientoe").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
           return false;
        }
        
            if ($("#actualizarUrl #lblcanttransaccione").val() == "") {
                alertify.warning("Por favor ingresar la Cantidad de Transaccion");
                $("#actualizarUrl #lblcanttransaccione").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
                if ($("#actualizarUrl #lblcanttransaccione").val() == 0) {
                alertify.warning("Por favor ingresar la Cantidad de Transaccion diferente a 0.");
                $("#actualizarUrl #lblcanttransaccione").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
        
            
            if ($("#actualizarUrl #hidden_lblEditarestadourle").val() == "") {
                alertify.warning("Por favor ingresar EstadoURL correcto");
                $("#actualizarUrl #hidden_lblEditarestadourle").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            if ($("#actualizarUrl #lblareae").val() == "" || $("#actualizarUrl #lblareae").val() == "Seleccione") {
                alertify.warning("Por favor seleccionar Area correcto");
                $("#actualizarUrl #lblarea").focus();       // Esta función coloca el foco de escritura del usuario en el campo Nombre directamente.
                return false;
            }
            return true;
        }
        
        
        function validate_fechaMayorQue(fechaInicial,fechaFinal)
        {
            valuesStart=fechaInicial.split("/");
            valuesEnd=fechaFinal.split("/");
            
 
            // Verificamos que la fecha no sea posterior a la actual
            var dateStart=new Date(valuesStart[2],(valuesStart[1]-1),valuesStart[0]);
            var dateEnd=new Date(valuesEnd[2],(valuesEnd[1]-1),valuesEnd[0]);
            if(dateStart>dateEnd)
            {
                return 0;
            }
            return 1;
        }
        
        function toJSDate( dateTime ) {

var dateTime = dateTime.split(" ");//dateTime[0] = date, dateTime[1] = time

var date = dateTime[0].split("/");
var time = dateTime[1].split(":");

//(year, month, day, hours, minutes, seconds, milliseconds)
//subtract 1 from month because Jan is 0 and Dec is 11
return new Date(date[2], (date[1]-1), date[0], time[0], time[1], 0, 0);

}

        function filterFloat(evt, input) {
            // Backspace = 8, Enter = 13, ‘0′ = 48, ‘9′ = 57, ‘.’ = 46, ‘-’ = 43
            var key = window.Event ? evt.which : evt.keyCode;
            var chark = String.fromCharCode(key);
            var tempValue = input.value + chark;
            if (key >= 48 && key <= 57) {
                if (filter(tempValue) === false) {
                    return false;
                } else {
                    return true;
                }
            } else {
                if (key == 8 || key == 13 || key == 0) {
                    return true;
                } else if (key == 46) {
                    if (filter(tempValue) === false) {
                        return false;
                    } else {
                        return true;
                    }
                } else {
                    return false;
                }
            }
        }

        function filter(__val__) {
            var preg = /^([0-9]+\.?[0-9]{0,2})$/;
            if (preg.test(__val__) === true) {
                return true;
            } else {
                return false;
            }

        }
        
        function mostrarhorareal(){
var fecha= new Date();
var horas= fecha.getHours();
var minutos = fecha.getMinutes();
var segundos = fecha.getSeconds();
document.getElementById('contenedor').innerHTML=''+horas+':'+minutos+'';
setTimeout('mostrarhorareal()',1000);
}

    </script>
    








    </body>
</html>

