<?php
    session_start();
    if (!isset($_SESSION['user_login_status'])) {
        header("location: ./login/index.php");
		exit;
    }

    date_default_timezone_set('America/Lima');
    
    include 'config/db.php';
    include 'config/conexion.php';

    $fechadiahoy=date("d/m/Y");
    $fechconvercion=date('Y-m-d', strtotime($fechadiahoy));

    $dias=date("d");
    $mes=date("m");
    $ano=date("Y");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verisure | VeriSmart</title>
    
    <link rel="icon" type="image/png" href="admin/dist/img/-apple-touch-icon-144x144.png" />
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap/dist/css/bootstrap.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="admin/bower_components/select2/dist/css/select2.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="admin/bower_components/font-awesome/css/font-awesome.min.css">
    <!-- Ionicons -->
    <link rel="stylesheet" href="admin/bower_components/Ionicons/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="admin/dist/css/AdminLTE.min.css">
    <!-- AdminLTE Skins. Choose a skin from the css/skins
            folder instead of downloading all of them to reduce the load. -->
    <link rel="stylesheet" href="admin/dist/css/skins/_all-skins.min.css">
    <!-- daterange picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-daterangepicker/daterangepicker.css">
    <!-- Date Picker -->
    <link rel="stylesheet" href="admin/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css">
    <link href="admin/bower_components/alertifyjs/css/themes/bootstrap.min.css" rel="stylesheet" type="text/css"/>
    <!-- Alertifyjs -->
    <link href="admin/bower_components/alertifyjs/css/alertify.min.css" rel="stylesheet" type="text/css"/>
    <!-- Google Font -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <!--Hoja de estilos de la pagina dashboard visita *No usuar stilos en la misma pagina-->
    <link rel="stylesheet" href="css/dashboardvisita.css">
    
    <link rel="stylesheet" href="admin/bower_components/datatables.net-bs/css/dataTables.bootstrap.min.css">
    
    <style>
        table tbody tr th{
            text-align: center;
        }
        .tblSubHeader, .Row__titulo{
            text-transform: uppercase;
        }
        
        .ocultar{
            display: none;
        }
        
        .bajo{
            background-color: #e4002b;
            color: white;
        }
        
        .medio{
            background-color: orange;
            color: white;
        }
        
        .alto{
            background-color: green;
            color: white;
        }
        
        .tblfooter{
            background-color: gray;
            color: white;
        }
        
        .big{
            width: 20%;
        }
        
        .mid{
            width: 15%;
        }
        
        .small{
            width: 8%;
        }
        
        .tblheadValue{
            background-color: gray;
            text-align: center;
            color: white;
        }
    </style>
    
    <style>
        .table-sortable th {
          cursor: pointer;
        }
        
        .table-sortable .th-sort-asc::after {
          content: "\25b4";
        }
        
        .table-sortable .th-sort-desc::after {
          content: "\25be";
        }
        
        .table-sortable .th-sort-asc::after,
        .table-sortable .th-sort-desc::after {
          margin-left: 5px;
        }
        
        .table-sortable .th-sort-asc,
        .table-sortable .th-sort-desc {
          background: #A62828;
        }
        
        .sizetr{
            height:3vw!important;
        }
    </style>
</head>
<body class="skin-red sidebar-mini sidebar-collapse">
    <div id="divLoading" style="display: none;">
        <div class="spinner">
            <div class="bounce1"></div>
            <div class="bounce2"></div>
            <div class="bounce3"></div>
        </div>
    </div>
    <div class="wrapper">
        <!-- Header -->
        <?php include 'admin/header.php'; ?>
        <!-- Left side column. contains the logo and sidebar -->
        <?php
            $inicio = "active";
            $dashboardvisitas= "active";
            include 'admin/main-sidebar.php';
        ?>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <div style="font-size:180%;"> DASHBOARD&nbsp <span style="font-size:80%;color:#DAD8D4"> | &nbsp <span style="font-size:80%;color:#8D8A80">REFERIDOS</span></span> </div>              
                <ol class="breadcrumb">
                    <li><a class="text-left"><font color="red">Día: <?php echo $dias."/".$mes."/".$ano;?></font></a></li>
                </ol>
            </section>
            <!-- Main content -->
            <section class="content">
                <div class="box box-danger" >
                    <div class="box-header"> 
                    </div>
                    <div class="box-body">
                        <table class="table table-hover" id="generalReferido">
                            <thead>
                                    
                            </thead>
                            <tbody>
                                
                            </tbody>
                        </table>
                    </div>
                    
                </div>
                
            </section>
            <?php include 'modalpassword.php';?>
            
        </div>
    </div>
    <!-- jQuery 3 -->
    <script src="admin/bower_components/jquery/dist/jquery.min.js"></script>
    <!-- jQuery UI 1.11.4 -->
    <script src="admin/bower_components/jquery-ui/jquery-ui.min.js"></script>
    <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
    <script>
        $.widget.bridge('uibutton', $.ui.button);
    </script>
    <!-- Bootstrap 3.3.7 -->
    <script src="admin/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
    <!-- SELECT 2 -->
    <script src="admin/bower_components/select2/dist/js/select2.full.min.js"></script>
    <!-- date-range-picker -->
    <script src="admin/bower_components/moment/min/moment.min.js"></script>
    <script src="admin/bower_components/bootstrap-daterangepicker/daterangepicker.js"></script>
    <!-- datepicker -->
    <script src="admin/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js"></script>
    <script src="admin/bower_components/bootstrap-datepicker/js/locales/bootstrap-datepicker.es.js"></script>

    <!-- Bootstrap WYSIHTML5 -->
    <script src="admin/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js"></script>
    <!-- Slimscroll -->
    <script src="admin/bower_components/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <!-- FastClick -->
    <script src="admin/bower_components/fastclick/lib/fastclick.js"></script>
    <!-- AdminLTE App -->
    <script src="admin/dist/js/adminlte.min.js"></script>
    <!-- SWEET ALERT -->
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- CHARTS -->
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    
    <script src="admin/bower_components/datatables.net/js/jquery.dataTables.min.js"></script>
    <script src="admin/bower_components/datatables.net-bs/js/dataTables.bootstrap.min.js"></script>
    
    <!-- INICIALIZADORES -->
    <script>
        $('#fechaCotizacion').datepicker({
            autoclose: true,
            language: 'es',
            firstDay: 1
        })
    </script>
    <!-- document ready -->
    <script>
        $(document).ready(() => {
            //GENERAR TABLA DEL DIA
            generarTablaPrincipalHead();
            //generarTablaDiaBody();
        })
    </script>
    <!-- Funciones -->
    <script>
        function generarTablaPrincipalHead(){
            const contenedorPrincipalHead = document.querySelector('#generalReferido thead');
            limpiarHTML(contenedorPrincipalHead);
            //CABECERA DE HORAS
            const row = document.createElement('tr');
            const row2 = document.createElement('tr');
            row.innerHTML = `<th colspan="3"></th>
                             <th colspan="5" class="tblSubHeader text-center">Número de Referidos</th>
                             <th colspan="5" class="tblSubHeader text-center">Número de Referidos (%)</th>
                             <th rowspan="2" class="tblSubHeader text-center">#Referidos</th>
                             <th rowspan="2" class="tblSubHeader text-center">Ref. x Inst.</th>
                `;
            row2.innerHTML = `
                             <th class="tblSubHeader text-center">DC</th>
                             <th class="tblSubHeader text-center">Total Inst.</th>
                             <th class="tblSubHeader text-center">Registradas</th>
                             <th class="tblSubHeader text-center">0</th>
                             <th class="tblSubHeader text-center">1-3</th>
                             <th class="tblSubHeader text-center">4-6</th>
                             <th class="tblSubHeader text-center">7-9</th>
                             <th class="tblSubHeader text-center">10 a +</th>
                             <th class="tblSubHeader text-center">0</th>
                             <th class="tblSubHeader text-center">1-3</th>
                             <th class="tblSubHeader text-center">4-6</th>
                             <th class="tblSubHeader text-center">7-9</th>
                             <th class="tblSubHeader text-center">10 a +</th>
                `;                
            contenedorPrincipalHead.appendChild(row);
            contenedorPrincipalHead.appendChild(row2);
            
        }
        
        function generarTablaDiaBody(){
            const contenedorPrincipalHead = document.querySelector('#generalLeadsDIA tbody');
            limpiarHTML(contenedorPrincipalHead);
            //CABECERA DE HORAS
            const row = document.createElement('tr');
            row.innerHTML += '<th class="tblSubHeader">LEADS</th>';
            
            const rowInternet = document.createElement('tr');
            const rowInbound = document.createElement('tr');
            const rowCorreo = document.createElement('tr');
            rowInternet.innerHTML += '<th class="tblSubHeader">Internet</th>';
            rowInbound.innerHTML += '<th class="tblSubHeader">Inbound</th>';
            rowCorreo.innerHTML += '<th class="tblSubHeader">Correo</th>';
            
            const rowVisitasExpress = document.createElement('tr');
            const rowVisitasTotales = document.createElement('tr');
            rowVisitasExpress.innerHTML += '<th class="tblSubHeader">Visitas Express</th>';
            rowVisitasTotales.innerHTML += '<th class="tblSubHeader">Visitas Totales</th>';
            
            const rowVisitasTotalesInternet = document.createElement('tr');
            rowVisitasTotalesInternet.innerHTML += '<th class="tblSubHeader">Internet</th>';
            
            const rowVisitasTotalesInternetPrimerIntento = document.createElement('tr');
            rowVisitasTotalesInternetPrimerIntento.innerHTML += '<th class="tblSubHeader">Primer intento</th>';
            const rowVisitasTotalesInternetRecovery = document.createElement('tr');
            rowVisitasTotalesInternetRecovery.innerHTML += '<th class="tblSubHeader">Recovery</th>';
            //INBOUND
            const rowVisitasTotalesInbound = document.createElement('tr');
            rowVisitasTotalesInbound.innerHTML += '<th class="tblSubHeader">Inbound</th>';
            
            const rowVisitasTotalesInboundPrimerIntento = document.createElement('tr');
            rowVisitasTotalesInboundPrimerIntento.innerHTML += '<th class="tblSubHeader">Primer intento</th>';
            const rowVisitasTotalesInboundRecovery = document.createElement('tr');
            rowVisitasTotalesInboundRecovery.innerHTML += '<th class="tblSubHeader">Recovery</th>';
            //CORREO
            const rowVisitasTotalesCorreo = document.createElement('tr');
            rowVisitasTotalesCorreo.innerHTML += '<th class="tblSubHeader">Correo</th>';
            
            const rowVisitasTotalesCorreoPrimerIntento = document.createElement('tr');
            rowVisitasTotalesCorreoPrimerIntento.innerHTML += '<th class="tblSubHeader">Primer intento</th>';
            const rowVisitasTotalesCorreoRecovery = document.createElement('tr');
            rowVisitasTotalesCorreoRecovery.innerHTML += '<th class="tblSubHeader">Recovery</th>';
            
            //row en blanco
            const rowEspacio = document.createElement('tr');
            rowEspacio.innerHTML += '<th class=""></th>';
            
            const rowPorcNoContacto = document.createElement('tr');
            rowPorcNoContacto.innerHTML += '<th class="tblSubHeader">% No Contacto</th>';
            const rowPorcNoGestionable = document.createElement('tr');
            rowPorcNoGestionable.innerHTML += '<th class="tblSubHeader">% No Gestionable</th>';
            const rowPorcGestionable = document.createElement('tr');
            rowPorcGestionable.innerHTML += '<th class="tblSubHeader">% Gestionable</th>';
            
            //row en blanco
            const rowEspacio2 = document.createElement('tr');
            rowEspacio2.innerHTML += '<th class=""></th>';
            
            const rowNoContacto = document.createElement('tr');
            rowNoContacto.innerHTML += '<th class="tblSubHeader">No Contacto</th>';
            
            //APAGADO
            const rowNoContactoApagado = document.createElement('tr');
            rowNoContactoApagado.innerHTML += '<th class="">Apagado</th>';
            //contestaCorta
            const rowNoContactoContestaCorta = document.createElement('tr');
            rowNoContactoContestaCorta.innerHTML += '<th class="">ContestaCorta</th>';
            //NOCONTACTO
            const rowNoContactoNoContacto = document.createElement('tr');
            rowNoContactoNoContacto.innerHTML += '<th class="">NoContacto</th>';
        
            
            const rowNoGestionable = document.createElement('tr');
            rowNoGestionable.innerHTML += '<th class="tblSubHeader">No Gestionable</th>';
            //TIPIFICACIONES NO GESTIONABLE
            //APAGADO
            const rowNoGestionableTeleventa = document.createElement('tr');
            rowNoGestionableTeleventa.innerHTML += '<th class="">Televenta</th>';
            //clienteError
            const rowNoGestionableClienteError = document.createElement('tr');
            rowNoGestionableClienteError.innerHTML += '<th class="">ClienteError</th>';
            //Duplicado
            const rowNoGestionableDuplicado = document.createElement('tr');
            rowNoGestionableDuplicado.innerHTML += '<th class="">Duplicado</th>';
            //Inviable
            const rowNoGestionableInviable = document.createElement('tr');
            rowNoGestionableInviable.innerHTML += '<th class="">Inviable</th>';
            //PROV
            const rowNoGestionablePROV = document.createElement('tr');
            rowNoGestionablePROV.innerHTML += '<th class="">PROV</th>';
            //ZSCC
            const rowNoGestionableZSCC = document.createElement('tr');
            rowNoGestionableZSCC.innerHTML += '<th class="">ZSCC</th>';
            //TelefonoError
            const rowNoGestionableTelefonoError = document.createElement('tr');
            rowNoGestionableTelefonoError.innerHTML += '<th class="">TelefonoError</th>';
            //NoCotiz贸
            const rowNoGestionableNoCotizo = document.createElement('tr');
            rowNoGestionableNoCotizo.innerHTML += '<th class="">NoCotizo</th>';
            //ATC
            const rowNoGestionableATC = document.createElement('tr');
            rowNoGestionableATC.innerHTML += '<th class="">ATC</th>';
            //Otros
            const rowNoGestionableOtros = document.createElement('tr');
            rowNoGestionableOtros.innerHTML += '<th class="">Otros</th>';
            //Backoffice
            const rowNoGestionableBackoffice = document.createElement('tr');
            rowNoGestionableBackoffice.innerHTML += '<th class="">Backoffice</th>';
            
            //GESTIONABLE
            const rowGestionable = document.createElement('tr');
            rowGestionable.innerHTML += '<th class="tblSubHeader">Gestionable</th>';
            
            //GESTIONABLE
            const rowGestionableDevolverLlamada = document.createElement('tr');
            rowGestionableDevolverLlamada.innerHTML += '<th class="">DevolverLlamada</th>';
            //GESTIONABLE
            const rowGestionableNoAceptaVisita = document.createElement('tr');
            rowGestionableNoAceptaVisita.innerHTML += '<th class="">NoAceptaVisita</th>';
            //GESTIONABLE
            const rowGestionableVisitaAceptada = document.createElement('tr');
            rowGestionableVisitaAceptada.innerHTML += '<th class="">VisitaAceptada</th>';
            //GESTIONABLE -- VISITA RECONFIRMAR
            const rowGestionableVisitaReconfirmar = document.createElement('tr');
            rowGestionableVisitaReconfirmar.innerHTML += '<th class="">VisitaReconfirmar</th>';
            
            const rowEspacio3 = document.createElement('tr');
            rowEspacio3.innerHTML += '<th class=""></th>';
            //CANAL
            const rowCanal = document.createElement('tr');
            rowCanal.innerHTML += '<th class="tblSubHeader">Canal</th>';
            
            const rowCanalFacebook = document.createElement('tr');
            rowCanalFacebook.innerHTML += '<th class="">Facebook</th>';
            const rowCanalFacebook_LN = document.createElement('tr');
            rowCanalFacebook_LN.innerHTML += '<th class="">FacebookLN</th>';
            const rowCanalAfiliados = document.createElement('tr');
            rowCanalAfiliados.innerHTML += '<th class="">Afiliados</th>';
            const rowCanalDisplay = document.createElement('tr');
            rowCanalDisplay.innerHTML += '<th class="">Display</th>';
            const rowCanalEmail = document.createElement('tr');
            rowCanalEmail.innerHTML += '<th class="">Email</th>';
            const rowCanalGON = document.createElement('tr');
            rowCanalGON.innerHTML += '<th class="">GON</th>';
            const rowCanalSEMMARCA = document.createElement('tr');
            rowCanalSEMMARCA.innerHTML += '<th class="">SEMMARCA</th>';
            const rowCanalSEMGENERICO = document.createElement('tr');
            rowCanalSEMGENERICO.innerHTML += '<th class="">SEMGENERICO</th>';
            const rowCanalSEO = document.createElement('tr');
            rowCanalSEO.innerHTML += '<th class="">SEO</th>';
            const rowCanalINBOUND = document.createElement('tr');
            rowCanalINBOUND.innerHTML += '<th class="">INBOUND</th>';
            
            const fechaCotizacion = moment($('#fechaCotizacion').val(), "DD/MM/YYYY").format("YYYY-MM-DD");
            
            $.ajax({
                type: 'Post',
                url: 'ajax/dataDashboardLeadDia.php',
                data: {fechaCotizacion: fechaCotizacion},
                dataType: 'json',
                success: function(data){
                    console.log(data);
                    
                    let arreglo = data.Leads;
                    let totalDia = 0;
                    
                    let arregloInternet = data.LeadsInternet;
                    let totalDiaInternet = 0;
                    
                    let arregloInbound = data.LeadsInbound;
                    let totalDiaInbound = 0;
                    
                    let arregloCorreo = data.LeadsCorreo;
                    let totalDiaCorreo = 0;
                    
                    let arregloVA = data.LeadsVisitaAceptada;
                    let totalDiaVA = 0;
                    
                    let arregloVAInternet = data.LeadsVisitaAceptadaInternet;
                    let totalDiaVAInternet = 0;
                    
                    let arregloVAInternetPrimerIntento = data.LeadsVisitaAceptadaInternetPrimerIntento;
                    let totalDiaVAInternetPrimerIntento = 0;
                    
                    let arregloVAInternetRecovery = data.LeadsVisitaAceptadaInternetRecovery;
                    let totalDiaVAInternetRecovery = 0;
                    
                    //INBOUND VA
                    let arregloVAInbound = data.LeadsVisitaAceptadaInbound;
                    let totalDiaVAInbound = 0;
                    
                    let arregloVAInboundPrimerIntento = data.LeadsVisitaAceptadaInboundPrimerIntento;
                    let totalDiaVAInboundPrimerIntento = 0;
                    
                    let arregloVAInboundRecovery = data.LeadsVisitaAceptadaInboundRecovery;
                    let totalDiaVAInboundRecovery = 0;
                    
                    //Correo VA
                    let arregloVACorreo = data.LeadsVisitaAceptadaCorreo;
                    let totalDiaVACorreo = 0;
                    
                    let arregloVACorreoPrimerIntento = data.LeadsVisitaAceptadaCorreoPrimerIntento;
                    let totalDiaVACorreoPrimerIntento = 0;
                    
                    let arregloVACorreoRecovery = data.LeadsVisitaAceptadaCorreoRecovery;
                    let totalDiaVACorreoRecovery = 0;
                    
                    let arregloNoContacto = data.LeadsNoContacto;
                    
                    let arregloNCApagado = data.LeadsNoContactoApagado;
                    let totalDiaNCApagado = 0;
                    let arregloNCContestaCorta = data.LeadsNoContactoContestaCorta;
                    let totalDiaNCContestaCorta = 0;
                    let arregloNCNoContacto = data.LeadsNoContactoNoContacto;
                    let totalDiaNCNoContacto = 0;
                    
                    let arregloNoGestionable = data.LeadsNoGestionable;
                    
                    let arregloNoGestionableTeleventa = data.LeadsNoGestionableTeleventa;
                    let arregloNoGestionableClienteError = data.LeadsNoGestionableClienteError;
                    let arregloNoGestionableDuplicado = data.LeadsNoGestionableDuplicado;
                    let arregloNoGestionableInviable = data.LeadsNoGestionableInviable;
                    let arregloNoGestionablePROV = data.LeadsNoGestionablePROV;
                    let arregloNoGestionableZSCC = data.LeadsNoGestionableZSCC;
                    let arregloNoGestionableTelefonoError = data.LeadsNoGestionableTelefonoError;
                    let arregloNoGestionableNoCotizo = data.LeadsNoGestionableNoCotizo;
                    let arregloNoGestionableATC = data.LeadsNoGestionableATC;
                    let arregloNoGestionableOtros = data.LeadsNoGestionableOtros;
                    let arregloNoGestionableBackoffice = data.LeadsNoGestionableBackoffice;
                 
                    let arregloGestionable = data.LeadsGestionable;
                    let arregloGestionableDevolverLlamada = data.LeadsGestionableDevolverLlamada;
                    let arregloGestionableNoAceptaVisita = data.LeadsGestionableNoAceptaVisita;
                    let arregloGestionableVisitaAceptada = data.LeadsGestionableVisitaAceptada;
                    let arregloGestionableVisitaReconfirmar = data.LeadsGestionableVisitaReconfirmar;
                    
                    let arregloCanal = data.LeadsCanal;
                    let arregloCanalFacebook = data.LeadsCanalFacebook;
                    let arregloCanalFacebook_LN = data.LeadsCanalFacebook_LN;
                    let arregloCanalAfiliados = data.LeadsCanalAfiliados;
                    let arregloCanalDisplay = data.LeadsCanalDisplay;
                    let arregloCanalEmail = data.LeadsCanalEmail;
                    let arregloCanalGON = data.LeadsCanalGON;
                    let arregloCanalSEMMARCA = data.LeadsCanalSEMMARCA;
                    let arregloCanalSEMGENERICO = data.LeadsCanalSEMGENERICO;
                    let arregloCanalSEO = data.LeadsCanalSEO;
                    let arregloCanalINBOUND = data.LeadsCanalINBOUND;
                    
                    for (var i = 0; i < 24; i++) {
                        let resultado = arreglo.find( elemento => elemento.hora == i);
                        
                        if(resultado){
                            row.innerHTML += `<th class="tblheadValue">${resultado.Total}</th>`;
                            
                            totalDia += parseInt(resultado.Total);
                            
                        } else {
                            row.innerHTML += `<th class="tblheadValue">0</th>`;
                        }
                        
                        let resultadoInternet = arregloInternet.find( elemento => elemento.hora == i);
                        
                        if(resultadoInternet){
                            rowInternet.innerHTML += `<th>${resultadoInternet.Total}</th>`;
                            
                            totalDiaInternet += parseInt(resultadoInternet.Total);
                            
                        } else {
                            rowInternet.innerHTML += `<th>0</th>`;
                        }
                        
                        let resultadoInbound = arregloInbound.find( elemento => elemento.hora == i);
                        
                        if(resultadoInbound){
                            rowInbound.innerHTML += `<th>${resultadoInbound.Total}</th>`;
                            
                            totalDiaInbound += parseInt(resultadoInbound.Total);
                            
                        } else {
                            rowInbound.innerHTML += `<th>0</th>`;
                        }
                        //FILA CORREO
                        let resultadoCorreo = arregloCorreo.find(elemento => elemento.hora == i);
                        
                        if(resultadoCorreo){
                            rowCorreo.innerHTML += `<th>${resultadoCorreo.Total}</th>`;
                            
                            totalDiaCorreo += parseInt(resultadoCorreo.Total);
                            
                        } else {
                            rowCorreo.innerHTML += `<th>0</th>`;
                        }
                        //FILA VISITA ACEPTADA
                        let resultadoVA = arregloVA.find(elemento => elemento.hora == i);
                        
                        if(resultadoVA){
                            rowVisitasTotales.innerHTML += `<th class="tblheadValue">${resultadoVA.Total}</th>`;
                            
                            totalDiaVA += parseInt(resultadoVA.Total);
                            
                        } else {
                            rowVisitasTotales.innerHTML += `<th class="tblheadValue">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA INTERNET
                        
                        let resultadoVAInternet = arregloVAInternet.find(elemento => elemento.hora == i);
                        
                        if(resultadoVAInternet){
                            rowVisitasTotalesInternet.innerHTML += `<td class="tblBody text-center">${resultadoVAInternet.Total}</td>`;
                            
                            totalDiaVAInternet += parseInt(resultadoVAInternet.Total);
                            
                        } else {
                            rowVisitasTotalesInternet.innerHTML += `<th class="tblBody text-center">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA INTERNET PRIMER INTENTO
                        
                        let resultadoVAInternetPrimerIntento = arregloVAInternetPrimerIntento.find(elemento => elemento.hora == i);
                        
                        if(resultadoVAInternetPrimerIntento){
                            rowVisitasTotalesInternetPrimerIntento.innerHTML += `<td class="text-center">${resultadoVAInternetPrimerIntento.Total}</td>`;
                            
                            totalDiaVAInternetPrimerIntento += parseInt(resultadoVAInternetPrimerIntento.Total);
                            
                        } else {
                            rowVisitasTotalesInternetPrimerIntento.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA INTERNET RECOVERY
                        
                        let resultadoVAInternetRecovery = arregloVAInternetRecovery.find(elemento => elemento.hora == i);
                        
                        if(resultadoVAInternetRecovery){
                            rowVisitasTotalesInternetRecovery.innerHTML += `<td class="text-center">${resultadoVAInternetRecovery.Total}</td>`;
                            
                            totalDiaVAInternetRecovery += parseInt(resultadoVAInternetRecovery.Total);
                            
                        } else {
                            rowVisitasTotalesInternetRecovery.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA Inbound
                        
                        let resultadoVAInbound = arregloVAInbound.find(elemento => elemento.hora == i);
                        
                        if(resultadoVAInbound){
                            rowVisitasTotalesInbound.innerHTML += `<td class="tblBody text-center">${resultadoVAInbound.Total}</td>`;
                            
                            totalDiaVAInbound += parseInt(resultadoVAInbound.Total);
                            
                        } else {
                            rowVisitasTotalesInbound.innerHTML += `<th class="tblBody text-center">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA Inbound PRIMER INTENTO
                        
                        let resultadoVAInboundPrimerIntento = arregloVAInboundPrimerIntento.find(elemento => elemento.hora == i);
                        
                        if(resultadoVAInboundPrimerIntento){
                            rowVisitasTotalesInboundPrimerIntento.innerHTML += `<td class="text-center">${resultadoVAInboundPrimerIntento.Total}</td>`;
                            
                            totalDiaVAInboundPrimerIntento += parseInt(resultadoVAInboundPrimerIntento.Total);
                            
                        } else {
                            rowVisitasTotalesInboundPrimerIntento.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA Inbound RECOVERY
                        
                        let resultadoVAInboundRecovery = arregloVAInboundRecovery.find(elemento => elemento.hora == i);
                        
                        if(resultadoVAInboundRecovery){
                            rowVisitasTotalesInboundRecovery.innerHTML += `<td class="text-center">${resultadoVAInboundRecovery.Total}</td>`;
                            
                            totalDiaVAInboundRecovery += parseInt(resultadoVAInboundRecovery.Total);
                            
                        } else {
                            rowVisitasTotalesInboundRecovery.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA Correo
                        
                        let resultadoVACorreo = arregloVACorreo.find(elemento => elemento.hora == i);
                        
                        if(resultadoVACorreo){
                            rowVisitasTotalesCorreo.innerHTML += `<td class="tblBody text-center">${resultadoVACorreo.Total}</td>`;
                            
                            totalDiaVACorreo += parseInt(resultadoVACorreo.Total);
                            
                        } else {
                            rowVisitasTotalesCorreo.innerHTML += `<th class="tblBody text-center">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA Correo PRIMER INTENTO
                        
                        let resultadoVACorreoPrimerIntento = arregloVACorreoPrimerIntento.find(elemento => elemento.hora == i);
                        
                        if(resultadoVACorreoPrimerIntento){
                            rowVisitasTotalesCorreoPrimerIntento.innerHTML += `<td class="text-center">${resultadoVACorreoPrimerIntento.Total}</td>`;
                            
                            totalDiaVACorreoPrimerIntento += parseInt(resultadoVACorreoPrimerIntento.Total);
                            
                        } else {
                            rowVisitasTotalesCorreoPrimerIntento.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //FILA VISITA ACEPTADA Correo RECOVERY
                        let resultadoVACorreoRecovery = arregloVACorreoRecovery.find(elemento => elemento.hora == i);
                        
                        if(resultadoVACorreoRecovery){
                            rowVisitasTotalesCorreoRecovery.innerHTML += `<td class="text-center">${resultadoVACorreoRecovery.Total}</td>`;
                            
                            totalDiaVACorreoRecovery += parseInt(resultadoVACorreoRecovery.Total);
                            
                        } else {
                            rowVisitasTotalesCorreoRecovery.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //FILA NO CONTACTO, GESTIONABLE, NO GESTIONABLE
                        
                        let resultadoNoContacto = arregloNoContacto.find(elemento => elemento.hora == i);
                        
                        if(resultadoNoContacto){
                            rowPorcNoContacto.innerHTML += `<td class="text-center">${parseFloat((resultadoNoContacto.Total/resultado.Total)*100).toFixed(0)} %</td>`;
                            
                        } else {
                            rowPorcNoContacto.innerHTML += `<th class="text-center">0 %</th>`;
                        }
                        
                        //
                        
                        let resultadoNoGestionable = arregloNoGestionable.find(elemento => elemento.hora == i);
                        
                        if(resultadoNoGestionable){
                            rowPorcNoGestionable.innerHTML += `<td class="text-center">${parseFloat((resultadoNoGestionable.Total/resultado.Total)*100).toFixed(0)} %</td>`;
                            
                        } else {
                            rowPorcNoGestionable.innerHTML += `<th class="text-center">0 %</th>`;
                        }
                        
                        let resultadoGestionable = arregloGestionable.find(elemento => elemento.hora == i);
                        
                        if(resultadoGestionable){
                            rowPorcGestionable.innerHTML += `<td class="text-center">${parseFloat((resultadoGestionable.Total/resultado.Total)*100).toFixed(0)} %</td>`;
                            
                        } else {
                            rowPorcGestionable.innerHTML += `<th class="text-center">0 %</th>`;
                        }
                        
                        //RESULTADOS 
                        
                        if(resultadoNoContacto){
                            rowNoContacto.innerHTML += `<td class="tblBody text-center">${resultadoNoContacto.Total}</td>`;
                            
                        } else {
                            rowNoContacto.innerHTML += `<th class="tblBody  text-center">0 </th>`;
                        }
                        
                        //APAGADO
                        let resultadoNCApagado = arregloNCApagado.find(elemento => elemento.hora == i);
                        
                        if(resultadoNCApagado){
                            rowNoContactoApagado.innerHTML += `<td class="text-center">${resultadoNCApagado.Total}</td>`;
                            
                        } else {
                            rowNoContactoApagado.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //ContestaCorta
                        let resultadoNCContestaCorta = arregloNCContestaCorta.find(elemento => elemento.hora == i);
                        
                        if(resultadoNCContestaCorta){
                            rowNoContactoContestaCorta.innerHTML += `<td class="text-center">${resultadoNCContestaCorta.Total}</td>`;
                            
                        } else {
                            rowNoContactoContestaCorta.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //NoContacto
                        let resultadoNCNoContacto = arregloNCNoContacto.find(elemento => elemento.hora == i);
                        
                        if(resultadoNCNoContacto){
                            rowNoContactoNoContacto.innerHTML += `<td class="text-center">${resultadoNCNoContacto.Total}</td>`;
                            
                        } else {
                            rowNoContactoNoContacto.innerHTML += `<th class="text-center">0</th>`;
                        }
                        
                        //NO GESTIONABLE
                        
                        
                        if(resultadoNoGestionable){
                            rowNoGestionable.innerHTML += `<td class="text-center tblBody ">${resultadoNoGestionable.Total}</td>`;
                            
                        } else {
                            rowNoGestionable.innerHTML += `<th class="text-center tblBody ">0 </th>`;
                        }
                        
                        let resultadoNGTeleventa = arregloNoGestionableTeleventa.find(elemento => elemento.hora == i);
                        if(resultadoNGTeleventa){
                            rowNoGestionableTeleventa.innerHTML += `<td class="text-center">${resultadoNGTeleventa.Total}</td>`;
                            
                        } else {
                            rowNoGestionableTeleventa.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGClienteError = arregloNoGestionableClienteError.find(elemento => elemento.hora == i);
                        if(resultadoNGClienteError){
                            rowNoGestionableClienteError.innerHTML += `<td class="text-center">${resultadoNGClienteError.Total}</td>`;
                            
                        } else {
                            rowNoGestionableClienteError.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGDuplicado = arregloNoGestionableDuplicado.find(elemento => elemento.hora == i);
                        if(resultadoNGDuplicado){
                            rowNoGestionableDuplicado.innerHTML += `<td class="text-center">${resultadoNGDuplicado.Total}</td>`;
                            
                        } else {
                            rowNoGestionableDuplicado.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGInviable = arregloNoGestionableInviable.find(elemento => elemento.hora == i);
                        if(resultadoNGInviable){
                            rowNoGestionableInviable.innerHTML += `<td class="text-center">${resultadoNGInviable.Total}</td>`;
                            
                        } else {
                            rowNoGestionableInviable.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGPROV = arregloNoGestionablePROV.find(elemento => elemento.hora == i);
                        if(resultadoNGPROV){
                            rowNoGestionablePROV.innerHTML += `<td class="text-center">${resultadoNGPROV.Total}</td>`;
                            
                        } else {
                            rowNoGestionablePROV.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGZSCC = arregloNoGestionableZSCC.find(elemento => elemento.hora == i);
                        if(resultadoNGZSCC){
                            rowNoGestionableZSCC.innerHTML += `<td class="text-center">${resultadoNGZSCC.Total}</td>`;
                            
                        } else {
                            rowNoGestionableZSCC.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGTelefonoError = arregloNoGestionableTelefonoError.find(elemento => elemento.hora == i);
                        if(resultadoNGTelefonoError){
                            rowNoGestionableTelefonoError.innerHTML += `<td class="text-center">${resultadoNGTelefonoError.Total}</td>`;
                            
                        } else {
                            rowNoGestionableTelefonoError.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGNoCotizo = arregloNoGestionableNoCotizo.find(elemento => elemento.hora == i);
                        if(resultadoNGNoCotizo){
                            rowNoGestionableNoCotizo.innerHTML += `<td class="text-center">${resultadoNGNoCotizo.Total}</td>`;
                            
                        } else {
                            rowNoGestionableNoCotizo.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGATC = arregloNoGestionableATC.find(elemento => elemento.hora == i);
                        if(resultadoNGATC){
                            rowNoGestionableATC.innerHTML += `<td class="text-center">${resultadoNGATC.Total}</td>`;
                            
                        } else {
                            rowNoGestionableATC.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGOtros = arregloNoGestionableOtros.find(elemento => elemento.hora == i);
                        if(resultadoNGOtros){
                            rowNoGestionableOtros.innerHTML += `<td class="text-center">${resultadoNGOtros.Total}</td>`;
                            
                        } else {
                            rowNoGestionableOtros.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoNGBackoffice = arregloNoGestionableBackoffice.find(elemento => elemento.hora == i);
                        if(resultadoNGBackoffice){
                            rowNoGestionableBackoffice.innerHTML += `<td class="text-center">${resultadoNGBackoffice.Total}</td>`;
                            
                        } else {
                            rowNoGestionableBackoffice.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        if(resultadoGestionable){
                            rowGestionable.innerHTML += `<td class="text-center tblBody ">${resultadoGestionable.Total}</td>`;
                            
                        } else {
                            rowGestionable.innerHTML += `<th class="text-center tblBody ">0 </th>`;
                        }
                        
                        let resultadoGestionableDevolverLlamada = arregloGestionableDevolverLlamada.find(elemento => elemento.hora == i);
                        if(resultadoGestionableDevolverLlamada){
                            rowGestionableDevolverLlamada.innerHTML += `<td class="text-center">${resultadoGestionableDevolverLlamada.Total}</td>`;
                        } else {
                            rowGestionableDevolverLlamada.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoGestionableNoAceptaVisita = arregloGestionableNoAceptaVisita.find(elemento => elemento.hora == i);
                        if(resultadoGestionableNoAceptaVisita){
                            rowGestionableNoAceptaVisita.innerHTML += `<td class="text-center">${resultadoGestionableNoAceptaVisita.Total}</td>`;
                        } else {
                            rowGestionableNoAceptaVisita.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        let resultadoGestionableVisitaAceptada = arregloGestionableVisitaAceptada.find(elemento => elemento.hora == i);
                        if(resultadoGestionableVisitaAceptada){
                            rowGestionableVisitaAceptada.innerHTML += `<td class="text-center">${resultadoGestionableVisitaAceptada.Total}</td>`;
                        } else {
                            rowGestionableVisitaAceptada.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        
                        let resultadoGestionableVisitaReconfirmar = arregloGestionableVisitaReconfirmar.find(elemento => elemento.hora == i);
                        if(resultadoGestionableVisitaReconfirmar){
                            rowGestionableVisitaReconfirmar.innerHTML += `<td class="text-center">${resultadoGestionableVisitaReconfirmar.Total}</td>`;
                        } else {
                            rowGestionableVisitaReconfirmar.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        //CANAL
                        let resultadoCanal = arregloCanal.find(elemento => elemento.hora == i);
                        if(resultadoCanal){
                            rowCanal.innerHTML += `<td class="text-center">${resultadoCanal.Total}</td>`;
                        } else {
                            rowCanal.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        //CANAL
                        let resultadoCanalFacebook = arregloCanalFacebook.find(elemento => elemento.hora == i);
                        if(resultadoCanalFacebook){
                            rowCanalFacebook.innerHTML += `<td class="text-center">${resultadoCanalFacebook.Total}</td>`;
                        } else {
                            rowCanalFacebook.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                        //CANAL
                        let resultadoCanalFacebook_LN= arregloCanalFacebook_LN.find(elemento => elemento.hora == i);
                        if(resultadoCanalFacebook_LN){
                            rowCanalFacebook_LN.innerHTML += `<td class="text-center">${resultadoCanalFacebook_LN.Total}</td>`;
                        } else {
                            rowCanalFacebook_LN.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        //CANAL
                        let resultadoCanalAfiliados = arregloCanalAfiliados.find(elemento => elemento.hora == i);
                        if(resultadoCanalAfiliados){
                            rowCanalAfiliados.innerHTML += `<td class="text-center">${resultadoCanalAfiliados.Total}</td>`;
                        } else {
                            rowCanalAfiliados.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        //CANAL
                        let resultadoCanalDisplay = arregloCanalDisplay.find(elemento => elemento.hora == i);
                        if(resultadoCanalDisplay){
                            rowCanalDisplay.innerHTML += `<td class="text-center">${resultadoCanalDisplay.Total}</td>`;
                        } else {
                            rowCanalDisplay.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        //CANAL
                        let resultadoCanalEmail = arregloCanalEmail.find(elemento => elemento.hora == i);
                        if(resultadoCanalEmail){
                            rowCanalEmail.innerHTML += `<td class="text-center">${resultadoCanalEmail.Total}</td>`;
                        } else {
                            rowCanalEmail.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        //CANAL
                        let resultadoCanalGON = arregloCanalGON.find(elemento => elemento.hora == i);
                        if(resultadoCanalGON){
                            rowCanalGON.innerHTML += `<td class="text-center">${resultadoCanalGON.Total}</td>`;
                        } else {
                            rowCanalGON.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        //CANAL
                        let resultadoCanalSEMMARCA = arregloCanalSEMMARCA.find(elemento => elemento.hora == i);
                        if(resultadoCanalSEMMARCA){
                            rowCanalSEMMARCA.innerHTML += `<td class="text-center">${resultadoCanalSEMMARCA.Total}</td>`;
                        } else {
                            rowCanalSEMMARCA.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        //CANAL
                        let resultadoCanalSEMGENERICO = arregloCanalSEMGENERICO.find(elemento => elemento.hora == i);
                        if(resultadoCanalSEMGENERICO){
                            rowCanalSEMGENERICO.innerHTML += `<td class="text-center">${resultadoCanalSEMGENERICO.Total}</td>`;
                        } else {
                            rowCanalSEMGENERICO.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        //CANAL
                        let resultadoCanalSEO = arregloCanalSEO.find(elemento => elemento.hora == i);
                        if(resultadoCanalSEO){
                            rowCanalSEO.innerHTML += `<td class="text-center">${resultadoCanalSEO.Total}</td>`;
                        } else {
                            rowCanalSEO.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        //CANAL
                        let resultadoCanalINBOUND = arregloCanalINBOUND.find(elemento => elemento.hora == i);
                        if(resultadoCanalINBOUND){
                            rowCanalINBOUND.innerHTML += `<td class="text-center">${resultadoCanalINBOUND.Total}</td>`;
                        } else {
                            rowCanalINBOUND.innerHTML += `<th class="text-center">0 </th>`;
                        }
                        
                    }
                    
                    //AGREGAR TOTALES Y PORCENTAJES
                    row.innerHTML += `<th class="tblheadValue">${totalDia}</th>`;
                    
                    rowInternet.innerHTML += `<th>${totalDiaInternet}</th>`;
                    if(totalDia > 0){
                        rowInternet.innerHTML += `<th>${parseFloat((totalDiaInternet/totalDia)*100).toFixed(2)}</th>`;
                    } else {
                        rowInternet.innerHTML += `<th>0.00</th>`;
                    }
                        rowInbound.innerHTML += `<th>${totalDiaInbound}</th>`;
                    if(totalDia > 0){
                        rowInbound.innerHTML += `<th>${parseFloat((totalDiaInbound/totalDia)*100).toFixed(2)}</th>`;
                    } else {
                        rowInternet.innerHTML += `<th>0.00</th>`;
                    }
                    rowCorreo.innerHTML += `<th>${totalDiaCorreo}</th>`;
                    if(totalDia > 0){
                    rowCorreo.innerHTML += `<th>${parseFloat((totalDiaCorreo/totalDia)*100).toFixed(2)}</th>`;
                    } else {
                        rowInternet.innerHTML += `<th>0.00</th>`;
                    }
                    
                    rowVisitasTotales.innerHTML += `<th class="tblheadValue">${totalDiaVA}</th>`;
                    
                    rowVisitasTotalesInternet.innerHTML += `<th class="tblBody text-center">${totalDiaVAInternet}</th>`;
                    rowVisitasTotalesInternet.innerHTML += `<th class="tblBody text-center">${parseFloat((totalDiaVAInternet/totalDiaVA)*100).toFixed(2)}</th>`;
                    
                    rowVisitasTotalesInternetPrimerIntento.innerHTML += `<th class="text-center">${totalDiaVAInternetPrimerIntento}</th>`;
                    rowVisitasTotalesInternetPrimerIntento.innerHTML += `<th class="text-center">${parseFloat((totalDiaVAInternetPrimerIntento/totalDiaVAInternet)*100).toFixed(2)}</th>`;
                    
                    rowVisitasTotalesInternetRecovery.innerHTML += `<th class="text-center">${totalDiaVAInternetRecovery}</th>`;
                    rowVisitasTotalesInternetRecovery.innerHTML += `<th class="text-center">${parseFloat((totalDiaVAInternetRecovery/totalDiaVAInternet)*100).toFixed(2)}</th>`;
                    
                    //INBOUND
                    rowVisitasTotalesInbound.innerHTML += `<th class="tblBody text-center">${totalDiaVAInbound}</th>`;
                    rowVisitasTotalesInbound.innerHTML += `<th class="tblBody text-center">${parseFloat((totalDiaVAInbound/totalDiaVA)*100).toFixed(2)}</th>`;
                    
                    rowVisitasTotalesInboundPrimerIntento.innerHTML += `<th>${totalDiaVAInboundPrimerIntento}</th>`;
                    rowVisitasTotalesInboundPrimerIntento.innerHTML += `<th>${parseFloat((totalDiaVAInboundPrimerIntento/totalDiaVAInbound)*100).toFixed(2)}</th>`;
                    
                    rowVisitasTotalesInboundRecovery.innerHTML += `<th>${totalDiaVAInboundRecovery}</th>`;
                    rowVisitasTotalesInboundRecovery.innerHTML += `<th>${parseFloat((totalDiaVAInboundRecovery/totalDiaVAInbound)*100).toFixed(2)}</th>`;
                    
                    //Correo
                    rowVisitasTotalesCorreo.innerHTML += `<th class="tblBody text-center">${totalDiaVACorreo}</th>`;
                    if(totalDiaVA > 0){
                    rowVisitasTotalesCorreo.innerHTML += `<th class="tblBody text-center">${parseFloat((totalDiaVACorreo/totalDiaVA)*100).toFixed(2)}</th>`;
                    } else {
                        rowVisitasTotalesCorreo.innerHTML += `<th class="tblBody text-center">0.00</th>`;
                    }
                    rowVisitasTotalesCorreoPrimerIntento.innerHTML += `<th>${totalDiaVACorreoPrimerIntento}</th>`;
                    if(totalDiaVACorreo > 0){
                    rowVisitasTotalesCorreoPrimerIntento.innerHTML += `<th>${parseFloat((totalDiaVACorreoPrimerIntento/totalDiaVACorreo)*100).toFixed(2)}</th>`;
                    } else {
                        rowVisitasTotalesCorreoPrimerIntento.innerHTML += `<th>0.00</th>`;
                    }
                    rowVisitasTotalesCorreoRecovery.innerHTML += `<th>${totalDiaVACorreoRecovery}</th>`;
                    if(totalDiaVACorreo > 0){
                        rowVisitasTotalesCorreoRecovery.innerHTML += `<th>${parseFloat((totalDiaVACorreoRecovery/totalDiaVACorreo)*100).toFixed(2)}</th>`;
                    } else {
                        rowVisitasTotalesCorreoRecovery.innerHTML += `<th>0.00</th>`;
                    }
                }
            })
            
            contenedorPrincipalHead.appendChild(row);
            contenedorPrincipalHead.appendChild(rowInternet);
            contenedorPrincipalHead.appendChild(rowInbound);
            contenedorPrincipalHead.appendChild(rowCorreo);
            contenedorPrincipalHead.appendChild(rowVisitasExpress);
            contenedorPrincipalHead.appendChild(rowVisitasTotales);
            contenedorPrincipalHead.appendChild(rowVisitasTotalesInternet);
            contenedorPrincipalHead.appendChild(rowVisitasTotalesInternetPrimerIntento);
            contenedorPrincipalHead.appendChild(rowVisitasTotalesInternetRecovery);
            contenedorPrincipalHead.appendChild(rowVisitasTotalesInbound);
            contenedorPrincipalHead.appendChild(rowVisitasTotalesInboundPrimerIntento);
            contenedorPrincipalHead.appendChild(rowVisitasTotalesInboundRecovery);
            contenedorPrincipalHead.appendChild(rowVisitasTotalesCorreo);
            contenedorPrincipalHead.appendChild(rowVisitasTotalesCorreoPrimerIntento);
            contenedorPrincipalHead.appendChild(rowVisitasTotalesCorreoRecovery);
            contenedorPrincipalHead.appendChild(rowEspacio);
            contenedorPrincipalHead.appendChild(rowPorcNoContacto);
            contenedorPrincipalHead.appendChild(rowPorcNoGestionable);
            contenedorPrincipalHead.appendChild(rowPorcGestionable);
            contenedorPrincipalHead.appendChild(rowEspacio2);
            contenedorPrincipalHead.appendChild(rowNoContacto);
            contenedorPrincipalHead.appendChild(rowNoContactoApagado);
            contenedorPrincipalHead.appendChild(rowNoContactoContestaCorta);
            contenedorPrincipalHead.appendChild(rowNoContactoNoContacto);
            contenedorPrincipalHead.appendChild(rowNoGestionable);
            contenedorPrincipalHead.appendChild(rowNoGestionableTeleventa);
            contenedorPrincipalHead.appendChild(rowNoGestionableClienteError);
            contenedorPrincipalHead.appendChild(rowNoGestionableDuplicado);
            contenedorPrincipalHead.appendChild(rowNoGestionableInviable);
            contenedorPrincipalHead.appendChild(rowNoGestionablePROV);
            contenedorPrincipalHead.appendChild(rowNoGestionableZSCC);
            contenedorPrincipalHead.appendChild(rowNoGestionableTelefonoError);
            contenedorPrincipalHead.appendChild(rowNoGestionableNoCotizo);
            contenedorPrincipalHead.appendChild(rowNoGestionableATC);
            contenedorPrincipalHead.appendChild(rowNoGestionableOtros);
            contenedorPrincipalHead.appendChild(rowNoGestionableBackoffice);
            contenedorPrincipalHead.appendChild(rowGestionable);
            contenedorPrincipalHead.appendChild(rowGestionableDevolverLlamada);
            contenedorPrincipalHead.appendChild(rowGestionableNoAceptaVisita);
            contenedorPrincipalHead.appendChild(rowGestionableVisitaAceptada);
            contenedorPrincipalHead.appendChild(rowGestionableVisitaReconfirmar);
            contenedorPrincipalHead.appendChild(rowEspacio3);
            contenedorPrincipalHead.appendChild(rowCanal);
            contenedorPrincipalHead.appendChild(rowCanalFacebook);
            contenedorPrincipalHead.appendChild(rowCanalFacebook_LN);
            contenedorPrincipalHead.appendChild(rowCanalAfiliados);
            contenedorPrincipalHead.appendChild(rowCanalDisplay);
            contenedorPrincipalHead.appendChild(rowCanalEmail);
            contenedorPrincipalHead.appendChild(rowCanalGON);
            contenedorPrincipalHead.appendChild(rowCanalSEMMARCA);
            contenedorPrincipalHead.appendChild(rowCanalSEMGENERICO);
            contenedorPrincipalHead.appendChild(rowCanalSEO);
            contenedorPrincipalHead.appendChild(rowCanalINBOUND);
            console.log(contenedorPrincipalHead);
            
        }
        
        function limpiarHTML(cont) {
            //forma recomendada
            while (cont.firstChild) {
                cont.removeChild(cont.firstChild);
            }
        }
    </script>
    
</body>
</html>