<?php
header("Content-Type: text/html;charset=utf-8");
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}

require '../config/db.php';
require '../config/conexion.php';
require_once '../helper/helper_validacion.php';

$fecharegistro = date("Y-m-d H:i:s");

$usuarioreg = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$usuarioreg = htmlspecialchars($usuarioreg);

//VALIDAR

$hidden_checki = sanitizaCampo($_POST['hidden_checki'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$hidden_checki = htmlspecialchars($hidden_checki);

$arraySelect = array();

$selectrows = sanitizaCampo($_POST['selectrows'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$selectrows = htmlspecialchars($selectrows);

$arraySelect = explode ( ',', $selectrows );

//LOG DE SEGURIDAD Y TRANSACCION
include 'log/insertLog.php';
include 'log/insertLogTeleventa.php';

$arrayActual = consultaHabilitarTV($selectrows);

if($hidden_checki=='NSP'){
    //$resultadoventa=mysqli_query($con,"UPDATE tblventa v SET v.TCGestor=NULL WHERE v.IdVenta in (".$selectrows.")");    
}else{
    
        if(!empty($arraySelect)){
        $resultadoventa=0;
        
        foreach ($arraySelect as $key => $value) {
        
            $queryVenta = "UPDATE tblventa v SET v.HabilitadoTV=? WHERE v.IdVenta=?";
            
            try{
                $stmt = $con->prepare($queryVenta);
                $stmt->bind_param('si',$hidden_checki,$selectrows);
                $stmt->execute();
                $resultadoventa += $stmt->affected_rows;
                $stmt->close();
            } catch (\Exception $e) {
                $resultadoventa = 'error';
            }          
            
        }

        if($resultadoventa>0){
            $idLogSeg = StmtInsertarLogSeguridad_General('Modificar', $fecharegistro,$selectrows,'SelectedIds');
            insertHabilitarTV($idLogSeg, $arrayActual);
            die(json_encode(array('respuesta' => 'exito', 'id_registro' => '')));  
        }else{
            die(json_encode(array('respuesta' => 'error')));
        }
    
    }else{
        die(json_encode(array('respuesta' => 'error')));
    }

}