<?php
header("Content-Type: text/html;charset=utf-8");
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}

require '../config/db.php';
require '../config/conexion.php';
include '../helper/helper_validacion.php';


$fecharegistro = date("Y-m-d H:i:s");

//VALIDAR
$IdVenta=sanitizaCampo($_POST['IdVenta'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$Matricula = sanitizaCampo($_POST['Matricula'], 'sanitizestring|scapestring|htmlspecialchars',$con);

$respuesta = actualizarDatos($Matricula,$IdVenta);
echo json_encode($respuesta);

function actualizarDatos($Matricula,$IdVenta){
    
    global $con;
    
        try{
            $stmt = $con->prepare("UPDATE tblventa SET TCGestor=? WHERE IdVenta = ?");
            $stmt->bind_param('si', $Matricula, $IdVenta);
            $stmt->execute();
            
            $rows = $stmt->affected_rows;
            
            if($rows > 0){
                $respuesta[] = array(
                        'respuesta' => 'exito',
                        'id' => $IdVenta
                    );
                    
            } else {
                $respuesta[] = array(
                    'respuesta' => 'sincambios',
                    'id' => $IdVenta,
                    'error' => $con->error,
                );
            }
            $stmt->close();
            
        } catch (\Exception $e) {
            $respuesta[] = array(
                'respuesta' => 'error',
                'mensaje' => $e
            );
        }
        
  
    return $respuesta;
        
    }    
    
    
    
