<?php

require '../config/db.php';
require '../config/conexion.php';
include '../helper/helper_validacion.php';


date_default_timezone_set('America/Lima');

$fecharegistro = date("Y-m-d H:i:s");

$reset=sanitizaCampo($_POST['npassword'],'sanitizestring|scapestring|htmlspecialchars',$con);
$repertirreset=sanitizaCampo($_POST['rpassword'],'sanitizestring|scapestring|htmlspecialchars',$con);
$idsu=sanitizaCampo($_POST['u'],'sanitizeint|scapestring|htmlspecialchars',$con);

    try{

        $stmt = $con->prepare( "SELECT us.Usuario,us.Password FROM dbUSUARIO.tblusuario us WHERE us.IdUsuario=?");
        $stmt->bind_param('i', $idsu);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($usuariocambio,$pass_hash);
        $stmt->fetch();
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }



if (password_verify($reset, $pass_hash)){
   echo 2; 
}else{

            $REMOTE_ADDR=$_SERVER['REMOTE_ADDR'];
            $REQUEST_URI=$_SERVER['REQUEST_URI'].'=>IdUsuario='.$idsu;
            $Acceso='Modificar';
            $HTTP_USER_AGENT=$_SERVER['HTTP_USER_AGENT'];
            
            try {
                    
              $stmtLog = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
              $stmtLog->bind_param('ssssss', $REMOTE_ADDR, $usuariocambio, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
              $stmtLog->execute();
              
              $idLogSeg = $con->insert_id;
              
              $stmtLog->close();
              
            } catch (\Exception $e) {
              echo $e->getMessage();
            } 

$user_password_hash=password_hash($reset,PASSWORD_DEFAULT);


  try{
        $sqlpassword = $con->prepare("UPDATE dbUSUARIO.tblusuario u SET u.Password=?,u.FechaHoraMODIF=? WHERE u.IdUsuario=?");
        $sqlpassword->bind_param('ssi', $user_password_hash,$fecharegistro,$idsu);
        $sqlpassword->execute();
        $respuesta = $sqlpassword->affected_rows;
        $sqlpassword->close();
    } catch (\Exception $e) {
        $respuesta = 0;
    } 


echo $respuesta; 
}

