<?php

require_once 'vendor/autoload.php';
include('../is_logged.php');

require_once '../../config/db.php';
require_once '../../config/conexion.php';
require_once '../../helper/helper_validacion.php';

set_time_limit(0);

$dbConf = new \SpoutExample\DBConf();
$reportCreator = new \SpoutExample\ReportCreator($dbConf);

//LIBRERIA DE EXPORTACION
// $idVenta = sanitizaCampo($_GET['IdVenta'],'sanitizeint|scapestring|htmlspecialchars|stringtonull',$con);
// $idVenta = htmlspecialchars($idVenta);


$outputPath = 'out/ProspectoRP.csv';

// Create output folder if needed
$outputFolder = dirname($outputPath);
if (!file_exists($outputFolder)) {
   mkdir($outputFolder);
}

$startTime = microtime(true);

// Generate the report from the data present in the DB
$reportCreator
//    ->setFetchRowsInBatch(500)
    ->setFetchRowsOneByOne()
//    ->setFetchAllRowsAtOnce()
    ->setWriterType(\SpoutExample\ReportWriter\WriterType::SPOUT)
//    ->setWriterType(\SpoutExample\ReportWriter\WriterType::PHP_EXCEL)
    ->fetchDataAndCreateReport_ProspectoRP($outputPath);

// Display some stats
$timeElapsed = round(microtime(true) - $startTime, 2);
$memoryPeak = round(memory_get_peak_usage(true) / 1024 / 1024, 2);


if(!empty($reportCreator->getFetchMethodName())){
   $fileName = basename('ProspectoRP.csv');
    $filePath = $outputPath;
    if(!empty($fileName) && file_exists($filePath)){
        // Define headers
        header("Cache-Control: public");
        header("Content-Description: File Transfer");
        header("Content-Disposition: attachment; filename=$fileName");
        header("Content-Type: application/csv");
        header("Content-Transfer-Encoding: binary");
        
        // Read the file
        readfile($filePath);
        
        unlink($filePath);
        exit;
    }else{
        echo 'The file does not exist.';
    } 
}


