<?php
    include('is_logged.php');
    date_default_timezone_set('America/Lima');
    //Funciones para codificar al momento de grabar en Mysql
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }
    
    require_once '../config/db.php';
    require_once '../config/conexion.php';
    
    include_once 'log/insertLog.php';
    include_once 'log/insertLogLead.php';
    include_once 'funciones/Televenta_transferenciaLead.php';
    
    //TRAER VARIABLES POST
    
    $matriculaAgente = $_POST['matriculaAgente'];
    //OBTENER IDUSUARIO DEL AGENTE
    $idUsuario = obtenerIdUsuario($matriculaAgente);
    
    $gestion = $_POST['gestion'];
    
    $nombres = $_POST['nombres'];
    $apellidos = $_POST['apellidos'];
    $telefono = $_POST['telefono'];
    $telefono2 = $_POST['telefono2']; //SEGUNDO TELEFONO OPCIONAL
    $origen = trim($_POST['origen']);
    $leadid =stringtonull($_POST['leadid']);
    $opennumber =stringtonull($_POST['opennumber']);
    
    $Departamental = $_POST['Departamental'];
    $Provincial = $_POST['Provincial'];
    $Distrital = $_POST['Distrital'];
    $CodigoUbigeo=$_POST['CodigoUbigeo'];
    
    $observaciones = $_POST['observaciones'];
    $segmento = $_POST['segmento'];
    $nlocales = $_POST['nlocales'];
    
    $npiso=$_POST['npiso'];
    if($npiso==""){
        $npiso=null;
    }
    $tiposegmento=$_POST['tiposegmento'];  
    if($tiposegmento==""){
        $tiposegmento=null;
    }
    
    if($nlocales >= 5){
        $ggcc = 'SI';
    } else {
        $ggcc = null;
    }
        
    $ndocumento = $_POST['ndocumento'];
    $tipoDocumento = convertirtipoDocumentoEquifax($_POST['tipoDocumentoLead']);
    
    $direccionCliente = $_POST['direccionCliente'];
    $IdDireccion = $_POST['IdDireccion'];
    $idResultadoScoring = $_POST['idResultadoScoring'];
    
    //$duplicado = consultarTelefono($telefono, $telefono2);
    
    $campaña = $_POST['campaña'];
    
    $contacto = $_POST['contacto'];
    
    
    $gestionable = $_POST['gestionable'];
    $tipificacion = $_POST['tipificacion'];
    $tipocamara= $_POST['tipocamara'];
    
    $fecharegistro = date("Y-m-d H:i:s");
    
    $fechahoraCotizacion = $_POST['fechahoraCotizacion'];
    $fechahoraCotizacion =  date("Y-m-d H:i:s", strtotime(str_replace('/', '-', $fechahoraCotizacion)));
    
    //TRASNFERENCIA A TELEVENTA
    $gestorTV = $_POST['gestorTV'];
    $tipotransf = $_POST['tipotransf'];
    $observaciontransf = $_POST['observaciontransf'];
    
    if($tipificacion == 'televenta'){
        if($tipotransf=='EnLinea'){
             $estado = 'Transferido';
             $fechaAsignacion = date("Y-m-d H:i:s");
         }else{
             $estado = null;
             $fechaAsignacion = null;
         }
        
    } else{
        $estado = null;
        $fechaAsignacion = null;
    }
    
    $vueltasRemarketing=0;
    
      $visePiso=$_POST['visePiso'];
    if($visePiso==""){
        $visePiso=null;
    }        
    $rubroNeg=$_POST['rubroNeg'];
    if($rubroNeg==""){
        $rubroNeg=null;
    }          
    $puertaCalle=$_POST['puertaCalle'];
    if($puertaCalle==""){
        $puertaCalle=null;
    }         
    $nobleParedes=$_POST['nobleParedes'];
    if($nobleParedes==""){
        $nobleParedes=null;
    }         
    $nobleTecho=$_POST['nobleTecho'];
    if($nobleTecho==""){
        $nobleTecho=null;
    }         
    $mcuadrados=$_POST['mcuadrados'];
    if($mcuadrados==""){
        $mcuadrados=null;
    }          
    $motivoInteres=$_POST['motivoInteres'];
    if($motivoInteres==""){
        $motivoInteres=null;
    }         
    $conSistema=$_POST['conSistema'];
    if($conSistema==""){
        $conSistema=null;
    }        
    $empresaSistema=$_POST['empresaSistema'];
    if($empresaSistema==""){
        $empresaSistema=null;
    }        
    $bancarizado=$_POST['bancarizado'];
    if($bancarizado==""){
        $bancarizado=null;
    }

    $equipo=htmlspecialchars($_POST['equipo']);
    if($equipo==""){
        $equipo=null;
    }
    
    
    try {
        $stmt = $con->prepare("INSERT INTO tblLeadCC(IdUsuario, FechaHoraReg, Gestion, Nombres, Apellidos, Telefono, Telefono2, Origen, LeadID, Departamento, Provincia, Distrito,CodigoUbigeo, Observaciones, Segmento, NLocales, NDocumento, FechaHoraCotizacion, IdDireccion, IdScoring, Campaña, ResultadoGestion, GestorTV, EstadoLead, FechaHoraAsignacion, TipoTransferencia, DireccionLead,ObsTransferencia,VueltasRemarketing,NPiso,TipoSegmento,Contactado,visePiso,rubroNeg,puertaCalle,nobleParedes,nobleTecho,metros,motivoInteres,conSistema,empresaSistema,bancarizado,Equipo,OPENumber) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('issssssssssssssissiissssssssiisssssssdssssss', $idUsuario, $fecharegistro, $gestion, $nombres, $apellidos, $telefono, $telefono2, $origen, $leadid, $Departamental, $Provincial, $Distrital,$CodigoUbigeo, $observaciones, $segmento, $nlocales, $ndocumento, $fechahoraCotizacion, $IdDireccion, $idResultadoScoring, $campaña, $tipificacion, $gestorTV, $estado, $fechaAsignacion, $tipotransf, $direccionCliente,$observaciontransf,$vueltasRemarketing,$npiso,$tiposegmento,$contacto,$visePiso,$rubroNeg,$puertaCalle,$nobleParedes,$nobleTecho,$mcuadrados,$motivoInteres,$conSistema,$empresaSistema,$bancarizado,$equipo,$opennumber);
        $stmt->execute();
        
        $IdLeadCC = $con->insert_id;
        
        if($IdLeadCC > 0){
            //INSERTAR LEAD SEGURIDAD
            $IdLogSeg_Lead = StmtInsertarLogSeguridad_General('Registrar', $fecharegistro, $IdLeadCC, 'Lead');
            insertLogLeadTransac_RegLead($IdLogSeg_Lead, $IdLeadCC);
            
            $IdLeadGestion = insertarGestion($IdLeadCC);
            
            if($IdLeadGestion > 0){
                
                $datosResultado = consultarDatos($IdLeadGestion);
                
                if($tipificacion == 'televenta'){
                    
                    //GENERAR DATOS DEL CLIENTE
                    // -- PRIMERO SE DEBE GENERAR EL IDGEOGRAFICO DEL CLIENTE
                    $idGeografico = generarIdGeografico($CodigoUbigeo);
                    
                    if($idGeografico == 'error'){
                        $respuesta = array(
                            'respuesta' => 'error',
                            'distrital' => $Distrital,
                            'detalle' => 'No se pudo encontrar el idGeografico para realizar la transferencia. Comuniquese con soporte.'
                        );
                        echo json_encode($respuesta);
                        exit();
                    }
                    
                    // -- REGISTRAR ID DOCUMENTO --
                    $idDocTV = registrarDocumento($tipoDocumento, $ndocumento);
                    
                    $NombreCompleto = $nombres.' '.$apellidos;
                    
                    $idCli = registrarCliente($idGeografico, $NombreCompleto, $telefono, $segmento, $idDocTV,$npiso,$tiposegmento);
                    
                    //DATOS DEL GESTOR DE TELEVENTA
                    
                    $datosGestorTV = consultaDatosGestor($gestorTV);
                    
                    //GENERAR VENTA
                    
                    $IdVenta = generarVenta($idCli, $datosGestorTV, $segmento, $gestorTV,$matriculaAgente);
                    
                    $respuesta = array(
                            'respuesta' => 'exito',
                            'idLeadCC' => $IdLeadCC,
                            'idLeadGestion' => $IdLeadGestion,
                            'datosResultadoGestion' => $datosResultado,
                            'tipificacion' => $tipificacion,
                            'GestorTV' => $datosGestorTV,
                            'idCli' => $idCli,
                            'IdVenta' => $IdVenta
                        );

                } else {
                
                    $respuesta = array(
                            'respuesta' => 'exito',
                            'idLeadCC' => $IdLeadCC,
                            'idLeadGestion' => $IdLeadGestion,
                            'datosResultadoGestion' => $datosResultado,
                            'tipificacion' => $tipificacion
                        );
                    
                }
            }
        } else {
            $respuesta = array(
                'respuesta' => 'error',
                'detalle' => $stmt->error
            );
        }
        
    } catch (\Exception $e) {
        $respuesta = array(
            'respuesta' => 'error'
        );
    }
    
    echo json_encode($respuesta);
    
    function obtenerIdUsuario($matriculaAgente){
        global $con;
        
        $sql = "SELECT IdUsuario FROM dbUSUARIO.tblusuario WHERE Matricula = '".$matriculaAgente."'";
        $resultado = $con->query($sql);
        
        $dataUsuario = mysqli_fetch_assoc($resultado);
        $idUsuario=$dataUsuario['IdUsuario'];
        
        return $idUsuario;
        
    }
    
    function insertarGestion($IdLeadCC){
        global $con;
        global $fecharegistro;
        global $idUsuario;
        global $observaciones;
        global $contacto;
        global $tipificacion;
        global $gestionable;
        global $tipocamara;
        
        //MOTIVO ES LO MISMO QUE SUBTIPIFICACION
        $subTipificacion = $_POST['motivo'];
        
        $vueltas = $_POST['vueltas'];
        $vueltas++;
        
        if(!empty($_POST['fechahoraRellamada'])){
            $fechahoraRellamada = $_POST['fechahoraRellamada'];
            $fechahoraRellamada =  date("Y-m-d H:i:s", strtotime(str_replace('/', '-', $fechahoraRellamada)));
        } else {
            $fechahoraRellamada = null;
        }
        //FALTA SUBTIPIFICACION

        try {
            $stmt = $con->prepare("INSERT INTO tblGestionLead (IdLead, IdUsuario, FechaHoraReg, Vueltas, ResultadoGestion, SubTipificacion, Observaciones, FechaHoraRellamada, Contacto, Gestionable,TipoCamara) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)");
            $stmt->bind_param('iisisssssss', $IdLeadCC, $idUsuario, $fecharegistro, $vueltas, $tipificacion, $subTipificacion, $observaciones, $fechahoraRellamada, $contacto, $gestionable,$tipocamara);
            $stmt->execute();
            
            $respuesta = $con->insert_id;
            
        } catch (\Exception $e) {
            $respuesta = 'error';
        }
        
        return $respuesta;
    }
    
    function consultarDatos($IdLeadGestion){
        global $con;
        
        $sql = "SELECT * FROM tblGestionLead WHERE IdGestionLead = '".$IdLeadGestion."'";
        $resultado = $con->query($sql);
        
        while ($fila = $resultado->fetch_assoc()){
            $respuesta = $fila;
        }
        
        return $respuesta;
    }
    
    function consultarTelefono($telefono, $telefono2){
        global $con;
        if($telefono != '' || $telefono != ''){
            $sql = "SELECT * FROM tblLeadCC WHERE Telefono = '".$telefono."' OR Telefono2 ='".$telefono2."'";
            $resultado = $con->query($sql);
            
            $row_cnt = $resultado->num_rows;
            
            if($row_cnt> 0){
                $respuesta = 'SI';
            } else {
                $respuesta = 'NO';
            }
        }
        
        return $respuesta;
    }
    
 function stringtonull($val){
        
        if ($val == '' || empty($val)){
            $resultado = NULL;
        }
        else if(!isset($val)){
            $resultado = NULL;
        }
        else {
            $resultado = $val;
        }
        
        return $resultado;
    }

    
    function convertirtipoDocumentoEquifax($tipoDocumento){
        $tipodocumentoconvertido=NULL;
        if($tipoDocumento==1){
            $tipodocumentoconvertido='DNI';
        }else if($tipoDocumento==6){
            $tipodocumentoconvertido='RUC';
        }else if($tipoDocumento==3){
            $tipodocumentoconvertido='CE';
        }else{
            $tipodocumentoconvertido='';
        }
        return $tipodocumentoconvertido;
    }
        
    