<?php

    require_once '../config/db.php';
    require_once '../config/conexion.php';
    require_once '../helper/helper_validacion.php';

    date_default_timezone_set('America/Lima');
    
    $fileContent = $_FILES['inputRemarketing'];
    $fileContent = file_get_contents($fileContent['tmp_name']);
    
    $fileContent = explode("\n", $fileContent);
    $fileContent = array_filter($fileContent);
    
    foreach ($fileContent as $fila){
        $leads[] = explode(",", $fila);
    }
    
    if(count($leads) > 1){
        $i =0;
        foreach ($leads as $data){
            if($i > 0){
                if(true){
                    $respuesta = actualizarDatos($data);
                    
                    $resultadoFinal[] = $respuesta;

                } else {
                    $respuesta = array(
                        'respuesta' => 'error',
                    );
                    
                    die($respuesta);
                }
            }
            $i++; 
        }       
    } else {
        $respuesta = array(
            respuesta => 'Sindatos'
        );
        
        die($respuesta);
    }
    
    echo json_encode(array('respuesta'=>'procesado','totalprocesado'=>count($resultadoFinal)),JSON_UNESCAPED_UNICODE);
    
    // echo json_encode($resultadoFinal, JSON_UNESCAPED_UNICODE);
    
    function actualizarDatos($data){
        global $con;
        
        $idLead = sanitizaCampo($data[0], 'sanitizeint|scapestring|htmlspecialchars',$con);
        $remarketing = sanitizaCampo($data[1], 'sanitizestring|scapestring|htmlspecialchars',$con);
        $visibilidad = sanitizaCampo($data[2], 'sanitizestring|scapestring|htmlspecialchars',$con);
        $basermkt = sanitizaCampo($data[3], 'sanitizestring|scapestring|htmlspecialchars',$con);
        $fecharegistro = date("Y-m-d H:i:s");
        
        if($remarketing=='NO'){
            $fecharegistro=NULL;
        }
        
        if($visibilidad=='' || empty($visibilidad)){
            $visibilidad=NULL;
        }
        if($basermkt=='' || empty($basermkt)){
            $basermkt=NULL;
        }    
        
        try{
            $stmt = $con->prepare("UPDATE tblLeadCC SET Remarketing=?, FechaHoraRemarketing=?,Visibilidad=?,BaseRMKT=? WHERE IdLeadCC = ?");
            $stmt->bind_param('ssssi', $remarketing, $fecharegistro,$visibilidad,$basermkt, $idLead);
            $stmt->execute();
            
            $rows = $stmt->affected_rows;
            
            if($rows > 0){
                $respuesta = array(
                        'respuesta' => 'exito',
                        'id' => $idLead,
                        'data' => $data
                    );
                    
            } else {
                $respuesta = array(
                    'respuesta' => 'sincambios',
                    'id' => $idLead,
                    'error' => $con->error,
                );
            }
            $stmt->close();
            
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error',
                'mensaje' => $e,
                'data' => $data
            );
        }
        
        return $respuesta;
        
    }
    
    
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
        
    }
    
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }