<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
require_once '../helper/helper_validacion.php';

 if(isset($_POST["jefid"]))  
 {  
    $IdTmpJefatura = sanitizaCampo($_POST["jefid"], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $query = $con->prepare("SELECT j.IdTmpJefatura as id_registro, CONCAT(CAST(j.FechaInicio AS CHAR), '-', CAST(j.FechaFinal AS CHAR)) AS FECHA_ACTUAL,j.FechaInicio,j.FechaFinal from dbVENTAS.tbltmpjefaturas j where j.IdTmpJefatura=?");  
    $query->bind_param('i',$IdTmpJefatura);
    $query->execute();
    $query->store_result();
    $query->bind_result(
        $id_registroRow,
        $FECHA_ACTUALRow,
        $FechaInicioRow,
        $FechaFinalRow
        );
    $numrows=  $query->num_rows;
    
    $return_arr = array();
    if($numrows > 0){
        while($query->fetch()){

            array_push($return_arr,array_map("utf8_encode",$row_array));
            $return_arr= array_map("utf8_encode",[
                                    'id_registro' => $id_registroRow,
                                    'FECHA_ACTUAL' => $FECHA_ACTUALRow,
                                    'FechaInicio' => $FechaInicioRow,
                                    'FechaFinal' => $FechaFinalRow
                ]);
        }
    }
    echo json_encode($return_arr);
 }  

$query->close();