<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
//LOG
require_once 'log/insertLog.php';
//LIBRERIA DE EXPORTACION
require_once 'libreria/Spout/Autoloader/autoload.php';

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

$fileName = 'Ventas.csv';

$writer = WriterEntityFactory::createCSVWriter();

$writer->openToBrowser($fileName);

$head = array('IdVenta','IdUsuario',
'IdCliente',
'Matricula',
'Comercial',
'CC',
'JefeVenta',
'CategoriaVenta',
'TipoVenta',
'Segmento',
'NProspecto',
'NContrato',
'PrecioKit',
'TotalExtra',
'IngresoKIT',
'IngresoExtras',
'IngresoTotal',
'EstadoVenta',
'ExtraAutorizado',
'MesesAutorizado',
'N590',
'FormaPago',
'PAI',
'ResumenVenta',
'FechaHoraREG',
'EstadoVisita',
'FechaVisita',
'HoraVisita',
'FVencimientoVisita',
'GestorMKT',
'OrigenVisita',
'ComentarioVisita',
'GestorOrigen',
'IdGeografico',
'NombApellido',
'Telefonouno',
'Telefonodos',
'Correo',
'Direccion',
'Distrito',
'Provincia',
'CCOriginal',
'IMP',
'ContactadoCO',
'MesVisita',
'VTAConfirmadaCO',
'FechaInst',
'HoraInst',
'InstaladoX',
'MatriculaTec',
'IdProspectoRP',
'FechaFacturacion',
'TipoKIT',
'CantidadExtras',
'TipoKITOriginal',
'ClosingPack',
'PrecioEspecial',
'CantidadExtrasOriginal',
'ScoringRP',
'PerfilScoring',
'CategoriaPrecio',
'dsctCuota',
'CantidadRegalo',
'TotalCuotaMonitoreo',
'TipoCamaraKit',
'Renove',
'RCompetencia',
'RVencimiento',
'TipoCierre',
'Zona',
'Seccion',
'ZonaVerisure',
'SeccionVerisure'
);
$rowFromValues = WriterEntityFactory::createRowFromArray($head);
$writer->addRow($rowFromValues);

date_default_timezone_set('America/Lima');

$fecharegistro=date("Y-m-d H:i:s");

$result_exec = StmtInsertarLogSeguridad_General('Exportar', $fecharegistro, '', '');

$query="SELECT 
v.IdVenta,
v.IdUsuario,
v.IdCliente,
v.Matricula,
v.Comercial,
v.CC,
v.JefeVenta,
v.CategoriaVenta,
v.TipoVenta,
v.Segmento,
v.NProspecto,
v.NContrato,
v.PrecioKit,
v.TotalExtra,
v.IngresoKIT,
v.IngresoExtras,
v.IngresoTotal,
v.EstadoVenta,
v.ExtraAutorizado,
v.MesesAutorizado,
v.N590,
v.FormaPago,
v.PAI,
v.ResumenVenta,
v.FechaHoraREG,
v.EstadoVisita,
v.FechaVisita,
v.HoraVisita,
v.FVencimientoVisita,
v.GestorMKT,
v.OrigenVisita,
v.ComentarioVisita,
v.GestorOrigen,
c.IdGeografico,
c.NombApellido,
c.Telefonouno,
c.Telefonodos,
c.Correo,
c.Direccion,
g.Distrito,
g.Provincia,
v.CCOriginal,
v.IMP,
v.ContactadoCO,
v.MesVisita,
v.VTAConfirmadaCO,
a.FechaInst,
a.HoraInst,
a.InstaladoX,
a.MatriculaTec,
v.IdProspectoRP,
f.FechaFacturacion,
v.TipoKIT,
v.CantidadExtras,
v.TipoKITOriginal,
v.ClosingPack,
v.PrecioEspecial,
v.CantidadExtrasOriginal,
v.ScoringRP,
v.PerfilScoring,
v.CategoriaPrecio,
v.dsctCuota,
v.CantidadRegalo,
v.TotalCuotaMonitoreo,
v.TipoCamaraKit,
v.Renove,
v.RCompetencia,
v.RVencimiento,
cv.TipoCierre,
c.objGeofinder,
c.objZonificacion
FROM dbVENTAS.tblventa v INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
INNER JOIN dbVENTAS.tblagenda a on a.IdVenta=v.IdVenta
INNER JOIN dbVENTAS.tblfacturacion f on f.IdVenta=v.IdVenta
LEFT JOIN dbVENTAS.tblcertificacionventa cv on cv.IdCertVenta=v.IdCertVenta
WHERE (v.N590 = 'Dec-2023' or v.N590 = 'Jan-2024' or v.N590 = 'Feb-2024' or v.N590 = 'Mar-2024' or v.N590 = 'Apr-2024' or v.N590 = 'May-2024')";
/*ID(124429) desde 2021-12 hacia adelante*/
/*ID(155343) desde 2022-05-01 hacia adelante*/
/*ID(184997) desde 2022-10-01 hacia adelante*/
/*ID(83335) desde 2021-01-01 hacia adelante*/

$result = $con->query($query);
//Contador para reccorer cada fila del resultado.
$i=0;

while ($Venta = $result->fetch_assoc()){

    $arreglo[] = $Venta;
    
    if($Venta['objGeofinder'] != '' || $Venta['objGeofinder'] != null){
        $objGeofinder = json_decode($Venta['objGeofinder'], true);
        
        if($objGeofinder['zonas'] == ''){
            $zona = '';
            $microzona = '';
        } else {
            $zonas = $objGeofinder['zonas'];
            
            if(count($zonas) == 1){
                $zona = $zonas[0]['valor']; 
                $microzona= '';
            }
            else if(count($zonas) == 2){
                $zona = $zonas[0]['valor'];
                $microzona=$zonas[1]['valor'];
                
                $microzona = convertirMicrozona($microzona);
            }
        }
        
        $arreglo[$i]['zona'] = $zona;
        $arreglo[$i]['Seccion'] = $microzona;
        
        unset($arreglo[$i]['objGeofinder']);
    }
    
    if($Venta['objZonificacion'] != '' || $Venta['objZonificacion'] != null){
        $objZonificacion = json_decode($Venta['objZonificacion'], true);
        $zonaVerisure = $objZonificacion['Zona'];
        $microzonaVerisure=$objZonificacion['Microzona'];
        
        $arreglo[$i]['zonaVerisure'] = $zonaVerisure;
        $arreglo[$i]['microzonaVerisure'] = $microzonaVerisure;
        
        unset($arreglo[$i]['objZonificacion']);
        
    }
    
    $i++;

}

for($i=0; $i<count($arreglo); $i++){
    $rowData = WriterEntityFactory::createRowFromArray($arreglo[$i]);
    $writer->addRow($rowData);
}

$result->close();

$writer->close();

$con->close();

function convertirMicrozona($microzona){
        $nuevaMicrozona = '';
        
        if(strpos($microzona, '-')){
            
            $arrayMicrozona = explode("-", $microzona);
            
            $ubigeo = $arrayMicrozona[0];
            
            $correlativo = '';
            
            $arregloUbigeos = array('150132',
                                '150133',
                                '130101',
                                '130104',
                                '130105',
                                '130111',
                                '130103',
                                '130106',
                                '130107',
                                '130109',
                                '130102',
                                '200101',
                                '200104',
                                '200105',
                                '200107',
                                '200108',
                                '200109',
                                '200110',
                                '200111',
                                '200114',
                                '200115',
                                '040122',
                                '040117',
                                '040112',
                                '040129',
                                '040128',
                                '040104',
                                '040103',
                                '040126',
                                '040101',
                                '040111',
                                '040116',
                                '040107',
                                '040109',
                                '040110',
                                '040123',
                                '040124',
                                '040102',
                                '040120',
                                '040118',
                                '040108',
                                '040125',
                                '040121',
                                '040114',
                                '040113',
                                '040119',
                                '040105',
                                '040106');
                                
            //var_dump($arregloUbigeos);
            
            //exit();
                                
            if (in_array($ubigeo, $arregloUbigeos)) {
                $correlativo = $arrayMicrozona[1];
                
                $correlativo = substr($correlativo, 1, 4);
                
                $nuevaMicrozona = $ubigeo.$correlativo;
                
                
                
            } else{
                $correlativo = $arrayMicrozona[1];
                
                $correlativo = substr($correlativo, 2, 4);
                
                $nuevaMicrozona = $ubigeo.$correlativo;
                
            }
            
            return $nuevaMicrozona;
            
            //return true;    
        } else{
            //return false;
        }
    }

?>
