<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
//LIBRERIA DE EXPORTACION
require_once 'libreria/Spout/Autoloader/autoload.php';

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

$fileName = 'CheckOUT.csv';

$writer = WriterEntityFactory::createCSVWriter();

$writer->openToBrowser($fileName);


// Cabecera actual
$head_actual = array(
    'ID Venta',
    'Nro. Prospecto',
    'Matricula',
    'Comercial',
    'CC Original',
    'Mes Visita',
    'Fecha Visita'
    //'¿Quién realizó la llamada de posicionamiento?',
    //'¿Se vendió?',
    //'Si no se vendió, ¿cuál fue el motivo principal?',
    //'Si cliente contrató con la competencia, ¿con cuál empresa?',
    //'¿Se encontraban los decisores?',
    //'¿Qué se le cotizó al cliente?',
    //'¿Con quién se realizó la llamada pared?',
    //'Acompañamiento en la Visita. ¿Quién asisitó a la visita?',
    //'¿Cuál fue el último precio que se le brindó al cliente?',
    //'¿Fue zona de robo?',
    //'¿Cuántos referidos RP se consiguió en la visita?',
    //'Observaciones',
    //'Fecha de Registro'
);

// Cabecera nueva
$head_nueva = array(
    '¿Se realiza llamada de posicionamiento?',
    '¿Quién realizó la llamada de posicionamiento?',
    'Estado de la Visita',
    'No Atendida - Motivo',
    'No Atendida - Descripción del motivo',
    'Atendida No Vendida - Si no se vendió, ¿cuál fue el motivo principal?',
    'Atendida No Vendida - Descripción del motivo',
    'Atendida No Vendida - ¿Realizste estudio de seguridad?',
    'Atendida No Vendida - ¿Realizaste Demo (botón SOS)?',
    'Atendida No Vendida - ¿Realizaste llamada pared?',
    'Atendida No Vendida - ¿Con quién se realizó la llamada pared?',
    'Atendida No Vendida - ¿Con quién asiste a la visita?',
    'Atendida No Vendida - ¿Cuál fue el último precio que se le brindó al cliente?',
    'Atendida No Vendida - ¿Fue zona de robo?',
    'Atendida No Vendida - ¿Conseguiste referidos?',
    'Atendida Vendida - ¿Realizste estudio de seguridad?',
    'Atendida Vendida - ¿Realizaste Demo (botón SOS)?',
    'Atendida Vendida - ¿Realizaste llamada pared?',
    'Atendida Vendida - ¿Con quién se realizó la llamada pared?',
    'Atendida Vendida - ¿Con quién asiste a la visita?',
    'Atendida Vendida - ¿A que precio se vendió?',
    'Atendida Vendida - ¿Fue zona de robo?',
    'Atendida Vendida - ¿Conseguiste referidos?',
    'Atendida Vendida - ¿Haz realizado la instalación?',
    'Atendida Vendida - Descripción del motivo'
    // 'Observaciones'
);


// Añadir la cabecera al archivo CSV

$rowFromValues = $writer->addRow(WriterEntityFactory::createRowFromArray(array_merge($head_actual, $head_nueva)));


date_default_timezone_set('America/Lima');

$fecharegistro=date("Y-m-d H:i:s");


/***************Parametros*****************/
// Validar que se hayan proporcionado los parámetros startDate y endDate
if(isset($_GET['startDate']) && isset($_GET['endDate'])) {
    // Obtener y sanitizar los valores de los parámetros startDate y endDate
    $startDate = filter_input(INPUT_GET, 'startDate', FILTER_SANITIZE_STRING);
    $endDate = filter_input(INPUT_GET, 'endDate', FILTER_SANITIZE_STRING);
    
    // Obtener los valores seleccionados del parámetro dcCheckOut
    $dcCheckOut = isset($_GET['dcCheckOut']) ? $_GET['dcCheckOut'] : array();

    // Validar que los valores no estén vacíos
    if($startDate !== "" && $endDate !== "" && strtotime($startDate) < strtotime($endDate)) {
        // Los parámetros son válidos, puedes continuar con tu lógica
        $query="SELECT
                v.IdVenta,
                hv.InfoCheckOut,
                v.Matricula,
                v.Comercial,
                v.CCOriginal,
                v.MesVisita,
                v.FechaVisita,
                hv.FechaHoraREG,
                v.NProspecto
                FROM
                    dbVENTAS.tblventa v
                INNER JOIN
                    dbVENTAS.tblhistorialcheckout hv
                    ON v.IdVenta = hv.IdVenta
                
                WHERE
                    v.FechaVisita >= '$startDate'
                    AND v.FechaVisita <= '$endDate'
                ";

                
            // Agregar la cláusula IN solo si dcCheckOut no está vacío
            if(!empty($dcCheckOut)) {
                // $dcCheckOutString = implode("','", $dcCheckOutArray);
                $query .= " AND v.CCOriginal IN ($dcCheckOut)";
            }
            
            $query .= " ORDER BY v.IdVenta ASC";
        
    } else {
        $query="SELECT
                v.IdVenta,
                hv.InfoCheckOut,
                v.Matricula,
                v.Comercial,
                v.CCOriginal,
                v.MesVisita,
                v.FechaVisita,
                hv.FechaHoraREG,
                v.NProspecto
                FROM
                    dbVENTAS.tblventa v
                INNER JOIN
                    dbVENTAS.tblhistorialcheckout hv
                    ON v.IdVenta = hv.IdVenta
                INNER JOIN (
                    SELECT
                        IdVenta,
                        MAX(FechaHoraREG) AS MaxFechaHoraREG
                    FROM
                        dbVENTAS.tblhistorialcheckout
                    GROUP BY
                        IdVenta
                ) hv_max ON hv.IdVenta = hv_max.IdVenta AND hv.FechaHoraREG = hv_max.MaxFechaHoraREG
                ORDER BY v.IdVenta ASC";
    }
} else {
    $query="SELECT
            v.IdVenta,
            hv.InfoCheckOut,
            v.Matricula,
            v.Comercial,
            v.CCOriginal,
            v.MesVisita,
            v.FechaVisita,
            hv.FechaHoraREG,
            v.NProspecto
            FROM
                dbVENTAS.tblventa v
            INNER JOIN
                dbVENTAS.tblhistorialcheckout hv
                ON v.IdVenta = hv.IdVenta
            INNER JOIN (
                SELECT
                    IdVenta,
                    MAX(FechaHoraREG) AS MaxFechaHoraREG
                FROM
                    dbVENTAS.tblhistorialcheckout
                GROUP BY
                    IdVenta
            ) hv_max ON hv.IdVenta = hv_max.IdVenta AND hv.FechaHoraREG = hv_max.MaxFechaHoraREG
                ORDER BY v.IdVenta ASC";
}


/************Fin Parametros********************/

// $query="SELECT 
// v.IdVenta,
// v.InfoCheckOut,
// v.Matricula,
// v.Comercial,
// v.FechaHoraREG
// FROM dbVENTAS.tblventa v
// ORDER BY v.IdVenta ASC";
/*
WHERE v.TipoVenta='RE' AND CC IN (150, 151, 152, 153, 154, 155, 156, 157 ,158, 159) AND v.FechaHoraREG >= '2021-02-19'*/

$result = $con->query($query);
$arreglo = [];
//Contador para reccorer cada fila del resultado.
$i=0;



while ($Venta = $result->fetch_assoc()){
    
    //$arreglo[] = $Venta;

    // if(($Venta['InfoCheckOut'] != '' || $Venta['InfoCheckOut'] != null) && isset($Venta['InfoCheckOut'])){
        
       

        // $Decisores = "";
        $CotizoCliente = "";
        $LlamadaPared = "";
        $AcompanamientoVisita = "";
        $UltimoPrecio = "";
        $ZonaRobo = "";
        $ReferidosRP = "";
        $ObservacionesCheckout = "";
        $LlamadaPosicionamiento="";
        $Sevendio="";
        $MotivoPrincipal="";
        $Empresa="";
        $Decisores="";
        $CotizoCliente="";
        $LlamadaPared="";
        $AcompanamientoVisita="";
        $UltimoPrecio="";
        $ZonaRobo="";
        $ReferidosRP="";
        $ObservacionesCheckout="";
        
        $cboLlamadaPosicionamiento="";
        $lblllamadaposicionamiento="";
        $cboEstadoVisita="";
        $cboMotivoNoAtendida="";
        $lblObservacionesNoAtendida="";
        $cboMotivoAtendidaNoVendida="";
        $lblObservacionesAtendidaNoVendida="";
        $cboEstudioSeguridad="";
        $cboDemoBoton="";
        $cboLlamadaParedCondicional="";
        $noVendidaLlamadaPared="";
        $noVendidaAcompanamientoVisita="";
        $noVendidaUltimoPrecio="";
        $noVendidaZonaRobo="";
        $cboConseguisteReferido="";
        $cboVendidaEstudioSeguridad="";
        $cboVendidaDemoBoton="";
        $cboVendidaLlamadaParedCondicional="";
        $cboVendidaLlamadaPared="";
        $cboVendidaAcompanamientoVisita="";
        $lblVendidaUltimoPrecio="";
        $cboVendidaZonaRobo="";
        $cboVendidaConseguisteReferido="";
        $cboVendidaRealizoInstalacion="";
        $lblObservacionesAtendida="";
        
        $InfoCheckOut = json_decode($Venta['InfoCheckOut'], true);
        
       
        if(isset($InfoCheckOut['NroProspecto'])){
            $nroProspecto = $InfoCheckOut['NroProspecto'];
        }
        
        if(isset($InfoCheckOut['cboLlamadaPosicionamiento'])){
            $cboLlamadaPosicionamiento = $InfoCheckOut['cboLlamadaPosicionamiento'];
        }
        
        if(isset($InfoCheckOut['lblllamadaposicionamiento'])){
            $Llamadaposicionamiento = $InfoCheckOut['lblllamadaposicionamiento'];
        }
        
        if(isset($InfoCheckOut['cboEstadoVisita'])){
            $cboEstadoVisita = $InfoCheckOut['cboEstadoVisita'];
        }
        
        if(isset($InfoCheckOut['cboMotivoNoAtendida'])){
            $cboMotivoNoAtendida = $InfoCheckOut['cboMotivoNoAtendida'];
        }
        
        if(isset($InfoCheckOut['lblObservacionesNoAtendida'])){
            $lblObservacionesNoAtendida = $InfoCheckOut['lblObservacionesNoAtendida'];
        }
        
        if(isset($InfoCheckOut['cboMotivoAtendidaNoVendida'])){
            $cboMotivoAtendidaNoVendida = $InfoCheckOut['cboMotivoAtendidaNoVendida'];
        }
        
        if(isset($InfoCheckOut['lblObservacionesAtendidaNoVendida'])){
            $lblObservacionesAtendidaNoVendida = $InfoCheckOut['lblObservacionesAtendidaNoVendida'];
        }
        
        if(isset($InfoCheckOut['cboEstudioSeguridad'])){
            $cboEstudioSeguridad = $InfoCheckOut['cboEstudioSeguridad'];
        }
        
        if(isset($InfoCheckOut['cboDemoBoton'])){
            $cboDemoBoton = $InfoCheckOut['cboDemoBoton'];
        }
        
        if(isset($InfoCheckOut['cboLlamadaParedCondicional'])){
            $cboLlamadaParedCondicional = $InfoCheckOut['cboLlamadaParedCondicional'];
        }
        
        if(isset($InfoCheckOut['noVendidaLlamadaPared'])){
            $noVendidaLlamadaPared = $InfoCheckOut['noVendidaLlamadaPared'];
        }
        
        if(isset($InfoCheckOut['noVendidaAcompanamientoVisita'])){
            $noVendidaAcompanamientoVisita = $InfoCheckOut['noVendidaAcompanamientoVisita'];
        }
        
        if(isset($InfoCheckOut['noVendidaUltimoPrecio'])){
            $noVendidaUltimoPrecio = $InfoCheckOut['noVendidaUltimoPrecio'];
        }
        
        if(isset($InfoCheckOut['noVendidaZonaRobo'])){
            $noVendidaZonaRobo = $InfoCheckOut['noVendidaZonaRobo'];
        }
        
        if(isset($InfoCheckOut['cboConseguisteReferido'])){
            $cboConseguisteReferido = $InfoCheckOut['cboConseguisteReferido'];
        }
        
        if(isset($InfoCheckOut['cboVendidaEstudioSeguridad'])){
            $cboVendidaEstudioSeguridad = $InfoCheckOut['cboVendidaEstudioSeguridad'];
        }
        
        if(isset($InfoCheckOut['cboVendidaDemoBoton'])){
            $cboVendidaDemoBoton = $InfoCheckOut['cboVendidaDemoBoton'];
        }
        
        if(isset($InfoCheckOut['cboVendidaLlamadaParedCondicional'])){
            $cboVendidaLlamadaParedCondicional = $InfoCheckOut['cboVendidaLlamadaParedCondicional'];
        }
        
        if(isset($InfoCheckOut['cboVendidaLlamadaPared'])){
            $cboVendidaLlamadaPared = $InfoCheckOut['cboVendidaLlamadaPared'];
        }
        
        if(isset($InfoCheckOut['cboVendidaAcompanamientoVisita'])){
            $cboVendidaAcompanamientoVisita = $InfoCheckOut['cboVendidaAcompanamientoVisita'];
        }
        
        if(isset($InfoCheckOut['lblVendidaUltimoPrecio'])){
            $lblVendidaUltimoPrecio = $InfoCheckOut['lblVendidaUltimoPrecio'];
        }
        
        if(isset($InfoCheckOut['cboVendidaZonaRobo'])){
            $cboVendidaZonaRobo = $InfoCheckOut['cboVendidaZonaRobo'];
        }
        
        if(isset($InfoCheckOut['cboVendidaConseguisteReferido'])){
            $cboVendidaConseguisteReferido = $InfoCheckOut['cboVendidaConseguisteReferido'];
        }
        
        if(isset($InfoCheckOut['cboVendidaRealizoInstalacion'])){
            $cboVendidaRealizoInstalacion = $InfoCheckOut['cboVendidaRealizoInstalacion'];
        }
        
        if(isset($InfoCheckOut['lblObservacionesAtendida'])){
            $lblObservacionesAtendida = $InfoCheckOut['lblObservacionesAtendida'];
        }
        
        if(isset($InfoCheckOut['lblObservacionesCheckout'])){
            $lblObservacionesCheckOut = $InfoCheckOut['lblObservacionesCheckout'];
        }
        
       /*************** Data Antigua*****************/
       
        if(isset($InfoCheckOut['lblllamadaposicionamiento'])){
            $lblllamadaPosicionamiento = $InfoCheckOut['lblllamadaposicionamiento'];
        }
        
        if($InfoCheckOut['cboSeVendio'] != ''){
            $Sevendio = $InfoCheckOut['cboSeVendio'];
        }
        
        if($Sevendio == 'Si'){
            $MotivoPrincipal = '';
        } else {
            if($InfoCheckOut['cboMotivoPrincipal'] != ''){
                $MotivoPrincipal = $InfoCheckOut['cboMotivoPrincipal'];
            }
        }
        
        if($MotivoPrincipal == 'Competencia'){
            $Empresa = $InfoCheckOut['cboEmpresa'];
        } else {
            $Empresa = '';
        }
        
        if($InfoCheckOut['cboDecisores'] != ''){
            $Decisores = $InfoCheckOut['cboDecisores'];
        }
        
        if($InfoCheckOut['cboCotizoCliente'] != ''){
            $CotizoCliente = $InfoCheckOut['cboCotizoCliente'];
        }
        
        if($InfoCheckOut['cboLlamadaPared'] != ''){
            $LlamadaPared = $InfoCheckOut['cboLlamadaPared'];
        }
        
        if($InfoCheckOut['cboAcompanamientoVisita'] != ''){
            $AcompanamientoVisita = $InfoCheckOut['cboAcompanamientoVisita'];
        }
        
        if($InfoCheckOut['lblUltimoPrecio'] != ''){
            $UltimoPrecio = $InfoCheckOut['lblUltimoPrecio'];
        }
        
        if($InfoCheckOut['cboZonaRobo'] != ''){
            $ZonaRobo = $InfoCheckOut['cboZonaRobo'];
        }
        
        if($InfoCheckOut['lblReferidosRP'] != ''){
            $ReferidosRP = $InfoCheckOut['lblReferidosRP'];
        }
        
        if($InfoCheckOut['lblObservacionesCheckOut'] != ''){
            $ObservacionesCheckout = $InfoCheckOut['lblObservacionesCheckOut'];
        }

       /***********Fin Data Antigua********************/
       
       /********* CABECERA ACTUAL *********/
       
        $arreglo[$i]['IdVenta'] = $Venta['IdVenta'];
        $arreglo[$i]['NroProspecto'] = $Venta['NProspecto'];
        $arreglo[$i]['Matricula'] = $Venta['Matricula'];
        $arreglo[$i]['Comercial'] = $Venta['Comercial'];
        $arreglo[$i]['CCOriginal'] = $Venta['CCOriginal'];
        $arreglo[$i]['MesVisita'] = $Venta['MesVisita'];
        $arreglo[$i]['FechaVisita'] = $Venta['FechaVisita'];

                
        // $arreglo[$i]['lblllamadaPosicionamiento'] = $lblllamadaPosicionamiento;
        // $arreglo[$i]['Sevendio'] = $Sevendio;
        // $arreglo[$i]['MotivoPrincipal'] = $MotivoPrincipal;
        // $arreglo[$i]['Empresa'] = $Empresa;
        // $arreglo[$i]['Decisores'] = $Decisores;
        // $arreglo[$i]['CotizoCliente'] = $CotizoCliente;
        // $arreglo[$i]['LlamadaPared'] = $LlamadaPared;
        // $arreglo[$i]['AcompanamientoVisita'] = $AcompanamientoVisita;
        // $arreglo[$i]['UltimoPrecio'] = $UltimoPrecio;
        // $arreglo[$i]['ZonaRobo'] = $ZonaRobo;
        // $arreglo[$i]['ReferidosRP'] = $ReferidosRP;
        // $arreglo[$i]['ObservacionesCheckout'] = $ObservacionesCheckout;
        // $arreglo[$i]['FechaRegistro'] = $Venta['FechaHoraREG']; 
        
        /********* FIN CABECERA *********/
        
        $arreglo[$i]['cboLlamadaPosicionamiento'] = $cboLlamadaPosicionamiento; //¿Se realiza llamada de posicionamiento?//
        $arreglo[$i]['lblllamadaposicionamiento'] = $Llamadaposicionamiento; //¿Quién realizó la llamada de posicionamiento?//
        $arreglo[$i]['cboEstadoVisita'] = $cboEstadoVisita; //Estado de la visita //
        
        $arreglo[$i]['cboMotivoNoAtendida'] = $cboMotivoNoAtendida; //No Atendida - Motivo //
        $arreglo[$i]['lblObservacionesNoAtendida'] = $lblObservacionesNoAtendida; //No Atendida - Descripción del motivo adicional por el cual no se atendió//
        
        $arreglo[$i]['cboMotivoAtendidaNoVendida'] = $cboMotivoAtendidaNoVendida; //Atendida No vendida - Si no se vendió, ¿cuál fue el motivo principal?//
        $arreglo[$i]['lblObservacionesAtendidaNoVendida'] = $lblObservacionesAtendidaNoVendida; //Atendida No vendida - Descripción del motivo adicional por el cual no se atendió//
        $arreglo[$i]['cboEstudioSeguridad'] = $cboEstudioSeguridad; //Atendida No vendida - ¿Realizste estudio de seguridad?//
        $arreglo[$i]['cboDemoBoton'] = $cboDemoBoton; //Atendida No vendida - ¿Realizaste Demo (botón SOS)?//
        $arreglo[$i]['cboLlamadaParedCondicional'] = $cboLlamadaParedCondicional; //Atendida No vendida - ¿Realizaste llamada pared? //
        $arreglo[$i]['noVendidaLlamadaPared'] = $noVendidaLlamadaPared; //Atendida No vendida - ¿Con quién se realizó la llamada pared? //
        $arreglo[$i]['noVendidaAcompanamientoVisita'] = $noVendidaAcompanamientoVisita; //Atendida No vendida - Acompañamiento en la Visita. ¿Con quién asiste a la visita? //
        $arreglo[$i]['noVendidaUltimoPrecio'] = $noVendidaUltimoPrecio; //Atendida No vendida - ¿Cuál fue el último precio que se le brindó al cliente?//
        $arreglo[$i]['noVendidaZonaRobo'] = $noVendidaZonaRobo; //Atendida No vendida - ¿Fue zona de robo?//
        $arreglo[$i]['cboConseguisteReferido'] = $cboConseguisteReferido; //Atendida No vendida - ¿Conseguiste referidos? //
        
        $arreglo[$i]['cboVendidaEstudioSeguridad'] = $cboVendidaEstudioSeguridad; //Atendida Vendida - ¿Realizste estudio de seguridad?//
        $arreglo[$i]['cboVendidaDemoBoton'] = $cboVendidaDemoBoton; // Atendida Vendida - ¿Realizaste Demo (botón SOS)? //
        $arreglo[$i]['cboVendidaLlamadaParedCondicional'] = $cboVendidaLlamadaParedCondicional; //Atendida Vendida - ¿Realizaste llamada pared? //
        $arreglo[$i]['cboVendidaLlamadaPared'] = $cboVendidaLlamadaPared; //Atendida Vendida - ¿Con quién se realizó la llamada pared? //
        $arreglo[$i]['cboVendidaAcompanamientoVisita'] = $cboVendidaAcompanamientoVisita; //Atendida Vendida - Acompañamiento en la Visita. ¿Con quién asiste a la visita? //
        $arreglo[$i]['lblVendidaUltimoPrecio'] = $lblVendidaUltimoPrecio; //Atendida Vendida - ¿A que precio se vendió? //
        $arreglo[$i]['cboVendidaZonaRobo'] = $cboVendidaZonaRobo; //Atendida Vendida - ¿Fue zona de robo? //
        $arreglo[$i]['cboVendidaConseguisteReferido'] = $cboVendidaConseguisteReferido; //Atendida Vendida - ¿Conseguiste referidos? //
        $arreglo[$i]['cboVendidaRealizoInstalacion'] = $cboVendidaRealizoInstalacion; //Atendida Vendida - ¿Haz realizado la instalación? //
        $arreglo[$i]['lblObservacionesAtendida'] = $lblObservacionesAtendida; //Atendida Vendida - Descripción del motivo por el cual no se Instalo //
        
        // $arreglo[$i]['lblObservacionesCheckOut'] = $lblObservacionesCheckOut; //Observaciones
        
        // // Cabecera nueva
        // $arreglo[$i]['Sevendio'] = $Sevendio;
        // $arreglo[$i]['MotivoPrincipal'] = $MotivoPrincipal;
        // $arreglo[$i]['Empresa'] = $Empresa;
        // $arreglo[$i]['Decisores'] = $Decisores;
        // $arreglo[$i]['CotizoCliente'] = $CotizoCliente;
        // $arreglo[$i]['LlamadaPared'] = $LlamadaPared;
        // $arreglo[$i]['AcompanamientoVisita'] = $AcompanamientoVisita;
        // $arreglo[$i]['UltimoPrecio'] = $UltimoPrecio;
        // $arreglo[$i]['ZonaRobo'] = $ZonaRobo;
        // $arreglo[$i]['ReferidosRP'] = $ReferidosRP;
        // $arreglo[$i]['ObservacionesCheckout'] = $ObservacionesCheckout;
        // $arreglo[$i]['FechaRegistro'] = $Venta['FechaHoraREG'];
        
        $rowData = WriterEntityFactory::createRowFromArray($arreglo[$i]);
        $writer->addRow($rowData);
        
        $i++;    
    // }
        
}
// var_dump($arreglo);exit();

// for($i=0; $i<count($arreglo); $i++){
//     $rowData = WriterEntityFactory::createRowFromArray($arreglo[$i]);
//     $writer->addRow($rowData);
// }

$result->close();

$writer->close();

$con->close();

?>
