<?php

require_once '../config/db.php';
require_once '../config/conexion.php';

$json = file_get_contents('php://input');
$data = json_decode($json);

if(isset($data->lblMesVisita)){
    $mesVisita = $data->lblMesVisita;
} else {
    $mesVisita= 'Jun-2021';
}

//TOTAL VISITAS PARA REGIONES
$totalVisitasLima = 0;
$totalVisitasProvincia = 0;


$arregloDatos = array(
        array('Id' => 'Lima', 'Totales' => array()),
        array('Id' => 'Provincias', 'Totales' =>array())
    );
    
//VISITAS POR PROVINCIA
//$arregloVisitasProvincia = listarVisitasProvincia($mesVisita);

$arregloVisitasDistrito = listarVisitasDistritos($mesVisita);

$arregloVisitasGeoDistrito = consultaVisitasGeoDistrito($mesVisita);

$arregloVisitasGeoDistritoxCC = consultaVisitasGeoDistritoxCC($mesVisita);

$arregloVisitasGeoExacta = consultaVisitasGeoExacta($mesVisita);

$arregloVisitasGeoAproximada = consultaVisitasGeoAproximada($mesVisita);

$arregloVisitasCheckIN = arrayCheckIN($mesVisita);

//AGREGAR TOTAL VISITAS AL ARREGLO PRINCIPAL

foreach ($arregloVisitasDistrito as $clave => $valor){
    if($valor['Provincia'] == 'Lima' || $valor['Provincia'] == 'Callao'){
        $arregloDatos[0]['Distritos'][] = array(
                        'Distrito' => $valor['Distrito'],
                        'TotalVisitas' => $valor['TotalVisitas'],
                        'TotalVisitasGeo' => 0,
                        'TotalVisitasGeoCC' => 0,
                        'TotalVisitasGeoExacta' => 0,
                        'TotalVisitasGeoAproximada' => 0,
                        'PorcVisitasGeo'  => '0.00',
                        'PorcVisitasGeoCC' => '0.00',
                        'PorcVisitasGeoExacta' => '0.00',
                        'PorcVisitasGeoAprox' => '0.00',
                        'PorcCheckInAutomatico' => 0,
                        'PorcCheckInManual' => 0,
                        'PorcCheckInFueraFecha' => 0
                    );
        
        $totalVisitasLima += $valor['TotalVisitas'];
    } else{
        $arregloDatos[1]['Distritos'][] = array(
                        'Distrito' => $valor['Distrito'],
                        'TotalVisitas' => $valor['TotalVisitas'],
                        'TotalVisitasGeo' => 0,
                        'TotalVisitasGeoCC' => 0,
                        'TotalVisitasGeoExacta' => 0,
                        'TotalVisitasGeoAproximada' => 0,
                        'PorcVisitasGeo'  => 0,
                        'PorcVisitasGeoCC' => 0,
                        'PorcVisitasGeoExacta' => 0,
                        'PorcVisitasGeoAprox' => 0,
                        'PorcCheckInAutomatico' => 0,
                        'PorcCheckInManual' => 0,
                        'PorcCheckInFueraFecha' => 0
                    );
        $totalVisitasProvincia += $valor['TotalVisitas'];
    }
}

//LIMA
$arregloDatos[0]['Totales']['TotalVisitas'] = $totalVisitasLima;

//PROVINCIAS
$arregloDatos[1]['Totales']['TotalVisitas'] = $totalVisitasProvincia;

agregarDatos($arregloVisitasGeoDistrito, 'TotalVisitasGeo');
agregarDatos($arregloVisitasGeoDistritoxCC, 'TotalVisitasGeoCC');
agregarDatos($arregloVisitasGeoExacta, 'TotalVisitasGeoExacta');
agregarDatos($arregloVisitasGeoAproximada, 'TotalVisitasGeoAproximada');
//CheckIN
agregarDatos($arregloVisitasCheckIN, 'CheckIN');

echo json_encode($arregloDatos);

function agregarDatos($arreglo, $titulo){
    
    global $arregloDatos;
    
    //RECORRE EL ARREGLO DE DATOS QUE CONTIENE EL ID, TOTALES Y DISTRITOS
    foreach($arregloDatos as $clave => $valor){
        if($titulo == 'TotalVisitasGeo'){
            $TotalVisitasGeo = 0;
        }
        if($titulo == 'TotalVisitasGeoCC'){
            $TotalVisitasGeoCC = 0;
        }
        if($titulo == 'TotalVisitasGeoExacta'){
            $TotalVisitasGeoExacta = 0;
        }
        if($titulo == 'TotalVisitasGeoAproximada'){
            $TotalVisitasGeoAproximada = 0;
        }
        
        if($titulo == 'CheckIN'){
            
            $TotalCheckIN = 0;
            $TotalCheckINAutomatico = 0;
            $TotalCheckINManual = 0;
            $TotalCheckINFueraFecha = 0;
            
            $PorcCheckINAutomatico = '0.00';
            $PorcCheckINManual = '0.00';
            $PorcCheckINFueraFecha = '0.00';
            
        }

        //RECORRE EL ARREGLO DE DISTRITOS QUE SE AÑADIO ANTES.
        foreach($arregloDatos[$clave]['Distritos'] as $claveDistrito => $valorDistrito ){
            
            //RECORRE EL ARREGLO ENVIADO COMO PARAMETRO PARA AGREGAR A CADA DISTRITO EL DATO INDICADO
            foreach($arreglo as $claveNuevo => $valorNuevo){
                if(!isset($valorNuevo['CANTIDAD'])){
                    $arregloDatos[$clave]['Distritos'][$claveDistrito][$titulo] = 0;
                }
                
                //SI EL DISTRITO DEL ARREGLO DE DATOS ES IGUAL DISTRITO DEL ARREGLO DEL PARAMETRO INGRESA
                if($valorDistrito['Distrito'] == $valorNuevo['Distrito']){
                    
                    $arregloDatos[$clave]['Distritos'][$claveDistrito][$titulo] = $valorNuevo['CANTIDAD'];
                    
                    //$arregloDatos[$clave]['Distritos'][$claveDistrito]['PorcVisitasGeoAprox'] = '0.00';
                    //$arregloDatos[$clave]['Distritos'][$claveDistrito]['PorcVisitasGeoExacta'] = '0.00';
                    
                    if($titulo == 'TotalVisitasGeo'){
                        $arregloDatos[$clave]['Distritos'][$claveDistrito]['PorcVisitasGeo'] = porcentaje($arregloDatos[$clave]['Distritos'][$claveDistrito]['TotalVisitasGeo'], $arregloDatos[$clave]['Distritos'][$claveDistrito]['TotalVisitas']);
                        
                        if($valorNuevo['DIRBUSQUEDA'] != 0){
                            $TotalVisitasGeo += $arregloDatos[$clave]['Distritos'][$claveDistrito]['TotalVisitasGeo'];
                        }

                        //AGREGAR EL VALOR AL ARREGLO
                        $arregloDatos[$clave]['Totales']['TotalVisitasGeo'] = $TotalVisitasGeo;
                    }
                    if($titulo == 'TotalVisitasGeoCC'){
                        $arregloDatos[$clave]['Distritos'][$claveDistrito]['PorcVisitasGeoCC'] = porcentaje($arregloDatos[$clave]['Distritos'][$claveDistrito]['TotalVisitasGeoCC'], $arregloDatos[$clave]['Distritos'][$claveDistrito]['TotalVisitas']);
                    
                        $TotalVisitasGeoCC += $arregloDatos[$clave]['Distritos'][$claveDistrito]['TotalVisitasGeoCC'];
                        
                        //AGREGAR EL VALOR AL ARREGLO
                        $arregloDatos[$clave]['Totales']['TotalVisitasGeoCC'] = $TotalVisitasGeoCC;
                    }
                    if($titulo == 'TotalVisitasGeoExacta'){
                        
                        $arregloDatos[$clave]['Distritos'][$claveDistrito]['PorcVisitasGeoExacta'] = porcentaje($arregloDatos[$clave]['Distritos'][$claveDistrito]['TotalVisitasGeoExacta'], $arregloDatos[$clave]['Distritos'][$claveDistrito]['TotalVisitasGeoCC']);
                        
                        $TotalVisitasGeoExacta += $arregloDatos[$clave]['Distritos'][$claveDistrito]['TotalVisitasGeoExacta'];
                        
                        $arregloDatos[$clave]['Totales']['TotalVisitasGeoExacta'] = $TotalVisitasGeoExacta;
                    }
                    if($titulo == 'TotalVisitasGeoAproximada'){
                        
                        $arregloDatos[$clave]['Distritos'][$claveDistrito]['PorcVisitasGeoAprox'] = porcentaje($arregloDatos[$clave]['Distritos'][$claveDistrito]['TotalVisitasGeoAproximada'], $arregloDatos[$clave]['Distritos'][$claveDistrito]['TotalVisitasGeoCC']);
                        
                        $TotalVisitasGeoAproximada += $arregloDatos[$clave]['Distritos'][$claveDistrito]['TotalVisitasGeoAproximada'];
                        
                        $arregloDatos[$clave]['Totales']['TotalVisitasGeoAproximada'] = $TotalVisitasGeoAproximada;
                    }
                    if($titulo == 'CheckIN'){
                        $arregloDatos[$clave]['Distritos'][$claveDistrito]['Automatico'] = $valorNuevo['Automatico'];
                        $arregloDatos[$clave]['Distritos'][$claveDistrito]['Manual'] = $valorNuevo['Manual'];
                        $arregloDatos[$clave]['Distritos'][$claveDistrito]['FueraFecha'] = $valorNuevo['FueraFecha'];
                        
                        $arregloDatos[$clave]['Distritos'][$claveDistrito]['PorcCheckInAutomatico'] = porcentaje($valorNuevo['Automatico'], $valorNuevo['CANTIDAD']);
                        $arregloDatos[$clave]['Distritos'][$claveDistrito]['PorcCheckInManual'] = porcentaje($valorNuevo['Manual'], $valorNuevo['CANTIDAD']);
                        $arregloDatos[$clave]['Distritos'][$claveDistrito]['PorcCheckInFueraFecha'] = porcentaje($valorNuevo['FueraFecha'], $valorNuevo['CANTIDAD']);
                        
                        $TotalCheckIN += $valorNuevo['CANTIDAD'];
                        $TotalCheckINAutomatico += $valorNuevo['Automatico'];
                        $TotalCheckINManual += $valorNuevo['Manual'];
                        $TotalCheckINFueraFecha += $valorNuevo['FueraFecha'];
                        
                        
                    }
                } 
                
            }
            
            
        }
        
        if($titulo == 'TotalVisitasGeo'){
            $arregloDatos[$clave]['Totales']['PorcVistasGeo'] = porcentaje($arregloDatos[$clave]['Totales']['TotalVisitasGeo'], $arregloDatos[$clave]['Totales']['TotalVisitas']);
        }
        if($titulo == 'TotalVisitasGeoCC'){
            $arregloDatos[$clave]['Totales']['PorcVistasGeoCC'] = porcentaje($arregloDatos[$clave]['Totales']['TotalVisitasGeoCC'], $arregloDatos[$clave]['Totales']['TotalVisitas']);
        }
        if($titulo == 'TotalVisitasGeoExacta'){
            $arregloDatos[$clave]['Totales']['PorcVistasGeoExacta'] = porcentaje($arregloDatos[$clave]['Totales']['TotalVisitasGeoExacta'], $arregloDatos[$clave]['Totales']['TotalVisitasGeoCC']);
        }
        if($titulo == 'TotalVisitasGeoAproximada'){
            $arregloDatos[$clave]['Totales']['PorcVistasGeoAproximada'] = porcentaje($arregloDatos[$clave]['Totales']['TotalVisitasGeoAproximada'], $arregloDatos[$clave]['Totales']['TotalVisitasGeoCC']);
        }
        if($titulo == 'CheckIN'){
            $arregloDatos[$clave]['Totales']['TotalCheckIN'] = $TotalCheckIN;
            $arregloDatos[$clave]['Totales']['TotalCheckINAutomatico'] = $TotalCheckINAutomatico;
            $arregloDatos[$clave]['Totales']['TotalCheckINManual'] = $TotalCheckINManual;
            $arregloDatos[$clave]['Totales']['TotalCheckINFueraFecha'] = $TotalCheckINFueraFecha;
            
            $arregloDatos[$clave]['Totales']['PorcCheckINAutomatico'] = porcentaje($TotalCheckINAutomatico, $TotalCheckIN);
            $arregloDatos[$clave]['Totales']['PorcCheckINManual'] = porcentaje($TotalCheckINManual, $TotalCheckIN);
            $arregloDatos[$clave]['Totales']['PorcCheckINFueraFecha'] = porcentaje($TotalCheckINFueraFecha, $TotalCheckIN);
        }
        //CHECKIN
    
    }
    
    
}

function listarVisitasProvincia($mesVisita){
    global $con;
    
    $sql = "SELECT DISTINCT g.Provincia, count(*) 'TotalVisitas'
        FROM tblventa v
        INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
        INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE v.mesVisita = '".$mesVisita."'
        AND v.TipoVenta='RE' 
        AND CCOriginal NOT IN (512, 511)
        GROUP BY g.Provincia
        order by TotalVisitas DESC";
        
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    if($row_cnt > 0){
        while($data = $resultado->fetch_assoc()){
            $arregloResultado[] = $data;
        } 
    } else {
        $arregloResultado = '';
    }
    
    return $arregloResultado;
}

function listarVisitasDistritos($mesVisita){
    
    global $con;
    
    $sql = "SELECT g.Provincia, g.Distrito, count(*) 'TotalVisitas'
    FROM tblventa v
    INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
    INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
    WHERE v.mesVisita = '".$mesVisita."'
    AND v.TipoVenta='RE' AND CCOriginal NOT IN (512, 511)
    GROUP BY g.Distrito
    ORDER BY g.Provincia, g.Distrito ASC";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    if($row_cnt > 0){
        while($data = $resultado->fetch_assoc()){
            $arregloResultado[] = $data;
        } 
    } else {
        $arregloResultado = '';
    }
    
    return $arregloResultado;
    
}

function consultaVisitasGeoDistrito($mesVisita){
    global $con;
    
    $sql = "SELECT g.Distrito, CASE c.objGeofinder WHEN '' THEN FALSE ELSE TRUE END AS DIRBUSQUEDA,  COUNT(*) CANTIDAD
            FROM dbVENTAS.tblventa v
            INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
            INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
            WHERE v.mesVisita = '".$mesVisita."' 
            AND v.TipoVenta='RE' 
            AND CCOriginal NOT IN (512, 511)
            GROUP BY g.Distrito, DIRBUSQUEDA";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    if($row_cnt > 0){
        while($data = $resultado->fetch_assoc()){
            $arregloResultado[] = $data;
        } 
    } else {
        $arregloResultado = '';
    }
    
    return $arregloResultado;
          
}

function consultaVisitasGeoDistritoxCC($mesVisita){
    global $con;
    
    $sql = "SELECT g.Distrito, CASE c.IdDireccion WHEN 0 THEN FALSE WHEN '' THEN FALSE WHEN null then false ELSE TRUE END AS DireccionesCC, count(*) as CANTIDAD
    FROM tblventa v
    INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
    INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
    WHERE v.mesVisita = '".$mesVisita."'
    AND v.TipoVenta='RE' 
    AND CCOriginal NOT IN (512, 511)
    AND IdDireccion NOT IN (0)
    GROUP BY g.Distrito, DireccionesCC";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    if($row_cnt > 0){
        while($data = $resultado->fetch_assoc()){
            $arregloResultado[] = $data;
        } 
    } else {
        $arregloResultado = '';
    }
    
    return $arregloResultado;
    
    
}

function porcentaje($parte, $total){
    if($total > 0 && $parte >= 0){
        return number_format(round(($parte/$total)*100, 2), 2);
    } else {
        return 0;
    }
}

function consultaVisitasGeoExacta($mesVisita){
    global $con;
    
    $sql = "SELECT g.Distrito, count(*) as CANTIDAD
        FROM tblventa v
        INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
        INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE v.mesVisita = '".$mesVisita."'
        AND v.TipoVenta='RE' 
        AND CCOriginal NOT IN (512, 511)
        AND c.TipoDireccion = 'Exacta'
        AND c.IdDireccion <> 0
        GROUP BY g.Distrito";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    if($row_cnt > 0){
        while($data = $resultado->fetch_assoc()){
            $arregloResultado[] = $data;
        } 
    } else {
        $arregloResultado = '';
    }
    
    return $arregloResultado;
    
}

function consultaVisitasGeoAproximada($mesVisita){
    global $con;
    
    $sql = "SELECT g.Distrito, count(*) as CANTIDAD
        FROM tblventa v
        INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
        INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
        WHERE v.mesVisita = '".$mesVisita."'
        AND v.TipoVenta='RE' 
        AND CCOriginal NOT IN (512, 511)
        AND c.TipoDireccion = 'Aproximada'
        AND c.IdDireccion <> 0
        GROUP BY g.Distrito";
    $resultado = $con->query($sql);
    $row_cnt = $resultado->num_rows;
    
    if($row_cnt > 0){
        while($data = $resultado->fetch_assoc()){
            $arregloResultado[] = $data;
        } 
    } else {
        $arregloResultado = '';
    }
    
    return $arregloResultado;
    
}

function arrayCheckIN($mesVisita){
    global $con;
    
    $query = "  SELECT g.Distrito, v.InfoCheckIn
            FROM tblventa v
            INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
            INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
            WHERE v.mesVisita = '".$mesVisita."'
            AND v.TipoVenta='RE' 
            AND CCOriginal NOT IN (512, 511)
            AND Checkin = 'SI'
            AND InfoCheckIn IS NOT NULL
            ORDER BY g.Distrito";
            
    $result = $con->query($query);
    
    $distritoAux = '';

    while ($data = $result->fetch_assoc()){
        
        $distrito = $data['Distrito'];
        
    
        if($distrito != $distritoAux){
            $i = 1;
            
            $Manual = 0;
            $Automatico = 0;
            $FueraFecha = 0;
            
            $InfoCheckIn = json_decode($data['InfoCheckIn'], true);
            
            if($InfoCheckIn['Tipo'] == 'Manual'){$Manual = 1;}
            else if($InfoCheckIn['Tipo'] == 'Automatico'){$Automatico = 1;}
            else {$FueraFecha = 1;}
            
            $array[$data['Distrito']] = array(
                                            'Distrito' => $data['Distrito'],
                                            'CANTIDAD' => $i,
                                            'Manual' => $Manual,
                                            'Automatico' => $Automatico,
                                            'FueraFecha' => $FueraFecha
                                        ); 
        } else {
            $i++;
            
            $InfoCheckIn = json_decode($data['InfoCheckIn'], true);
            
            if($InfoCheckIn['Tipo'] == 'Manual'){$Manual++;}
            else if($InfoCheckIn['Tipo'] == 'Automatico'){$Automatico++;}
            else {$FueraFecha++;}
            
            $array[$data['Distrito']] = array(
                                            'Distrito' => $data['Distrito'],
                                            'CANTIDAD' => $i,
                                            'Manual' => $Manual,
                                            'Automatico' => $Automatico,
                                            'FueraFecha' => $FueraFecha
                                        ); 
        }
        
        //$array[] = $data;
        
        $distritoAux = $data['Distrito'];    
    }
    
    return $array;
}

