<?php
header("Content-Type: text/html;charset=utf-8");
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}

require '../config/db.php';
require '../config/conexion.php';
require_once '../helper/helper_validacion.php';

$fecharegistro = date("Y-m-d H:i:s");

$usuarioreg = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$usuarioreg = htmlspecialchars($usuarioreg);

//VALIDAR
$cboGestorTV = sanitizaCampo($_POST['cboGestorTV'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$cboGestorTV = htmlspecialchars($cboGestorTV);

$arraySelect = array();

$selectrows = sanitizaCampo($_POST['selectrows'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$selectrows = htmlspecialchars($selectrows);

$arraySelect = explode ( ',', $selectrows ); 

//LOG DE SEGURIDAD Y TRANSACCION
include 'log/insertLog.php';
include 'log/insertLogTeleventa.php';

$datosLead = consultaDatosGestor($cboGestorTV);


$IdUsuario=intval($datosLead[0]['IdUsuario']);
// var_dump($IdUsuario);exit;
$Matricula=$datosLead[0]['Matricula'];
$Comercial=$datosLead[0]['Comercial'];

$arrayActual = consultaGestorTVLEAD($selectrows);

if($cboGestorTV=='NSP'){
    //$resultadoventa=mysqli_query($con,"UPDATE tblventa v SET v.TCGestor=NULL WHERE v.IdVenta in (".$selectrows.")");    
}else{
    
    if(!empty($arraySelect)){

        foreach ($arraySelect as $key => $value) {

            updatetvAsignarLead($cboGestorTV,$IdUsuario,$Matricula,$Comercial,$fecharegistro,$value);
            updatetvAsignarLeadCC($cboGestorTV,$IdUsuario,$Matricula,$Comercial,$fecharegistro,$value);
                
        }
            
        die(json_encode(array('respuesta' => 'exito', 'id_registro' => '')));    
    }else{
        die(json_encode(array('respuesta' => 'error')));
    }
    
}



function updatetvAsignarLead($cboGestorTV,$IdUsuario,$Matricula,$Comercial,$fecharegistro,$selectrows){
    global $con;    
            $resultadoventa=$con->prepare("UPDATE tblventa v SET v.TCGestor=?,v.IdUsuario=? ,v.Matricula=? ,v.Comercial=? ,v.FechaHoraREG=? WHERE v.IdLead=? "); 
            $resultadoventa->bind_param('sisssi',$cboGestorTV,$IdUsuario,$Matricula,$Comercial,$fecharegistro,$selectrows);
            $resultadoventa->execute();
            $resultadoventa->close();
    
}

function updatetvAsignarLeadCC($cboGestorTV,$IdUsuario,$Matricula,$Comercial,$fecharegistro,$selectrows){
    global $con;    
            $resultadoventa=$con->prepare("UPDATE tblLeadCC l SET l.GestorTV =?,l.FechaHoraAsignacion=?,l.EstadoLead ='Transferido' WHERE l.IdLeadCC =? "); 
            $resultadoventa->bind_param('ssi',$cboGestorTV,$fecharegistro,$selectrows);
            $resultadoventa->execute();
            $resultadoventa->close();
    
}

function consultaDatosGestor($Gestor){
    global $con;

    try{
        $stmt = $con->prepare( "SELECT u.IdUsuario,u.Matricula,CONCAT(u.Nombres,' ',u.Apellidos) Comercial FROM dbUSUARIO.tblusuario u WHERE u.Matricula = ?");
        $stmt->bind_param('s', $Gestor);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdUsuario,$Matricula,$Comercial);
        $data = [];        
        while ($stmt->fetch()){
        $data[] = array_map("utf8_encode",['IdUsuario'=>$IdUsuario, 'Matricula'=>$Matricula,'Comercial'=>$Comercial]);            
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

    return $data;
}



