<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require '../config/db.php';
require '../config/conexion.php';
include '../helper/helper_validacion.php';

//AGREGAR FUNCIONES LOG
include 'log/insertLog.php';
include 'log/insertLogAgenda.php';
include 'log/insertLogAgendaAmp.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

$gestor = sanitizaCampo($_POST['gestor'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$gestor = htmlspecialchars($gestor);

$fecharegistroagenda = date("Y-m-d H:i:s");
$fecharegistroventa = date("Y-m-d H:i:s");

$idamp = sanitizaCampo($_POST['idAmpl'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$idamp = htmlspecialchars($idamp);

$idagenda = sanitizaCampo($_POST['lblidagenda'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$idagenda = htmlspecialchars($idagenda);

$estadoamp = sanitizaCampo($_POST['cboEstadoAmpliacion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$estadoamp = htmlspecialchars($estadoamp);

$nmatenimiento = sanitizaCampo($_POST['lblNMantenimiento'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$nmatenimiento = htmlspecialchars($nmatenimiento);

//$FechaAgendamiento=date("Y-m-d");
//$FechaAmpliacion=date("Y-m-d");

//ARRAY DE DATOS DE LA TABLA AGENDA
$resultadoAgenda = consultaAgendaMod_Amp($idamp);
//ARRAY DE DATOS DE LA TABLA Ampliacion
$resultadoAgendaAmp = consultaAgendaAmp($idamp);
//ACTUALIZA AGENDA Y RETORNA EL NUMERO DE FILAS AFECTADAS
$resultadoagenda = actualizarAgenda($idamp);
//ACTUALIZA VENTA Y RETORNA EL NUMERO DE FILAS AFECTADAS
$resultadoamp = actualizarAMP($idamp);


if ($resultadoagenda > 0 && $resultadoamp>0) {
    
    //INSERTA LOG HISTORIO DE AGENDA
   // $sqlagendahist=mysqli_query($con,"INSERT INTO dbVENTAS.tblagendahist(IdAgenda, IdAmp, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,Repercusion,RepercusionCosto, MotivoInviable, MotivoCancelada,GestorAgenda,EstadoAmp) VALUES ('$idagenda','$idamp','$instaladox','$tecnico','$comentarioagenda','$fecharegistroagenda','$repercucion','$costo','$inviable','$cancelado','$gestor','$estadoamp')");    
    
    ingresarhistAgenda($idamp);
    
    
    //INSERTA LOG DE SEGURIDAD
    // $result_exec= $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES ('".$_SERVER['REMOTE_ADDR']."','".$_SESSION['usuariosesion']."','".$fecharegistroventa."','".$_SERVER['REQUEST_URI'].'=>IdAmp='.$idamp."','Modificar','".$_SERVER['HTTP_USER_AGENT']."')");
    // $idLogSeg = $con->insert_id;
    
    
    $Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
    $Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $Url = sanitizaCampo($_SERVER['REQUEST_URI'].'=>IdAmp='.$idamp, 'sanitizeurl|scapestring|htmlspecialchars',$con);
    if(!empty($Url)){
    	$UrlLog = $Url.'=>IdAmp='.$idamp;
    }
    $Modificar = 'Modificar';
    $Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                    
    try{
    	$result_exec= $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
    	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fecharegistroventa,$UrlLog,$Modificar,$Navegador);
    	$result_exec->execute();
    	$idLogSeg = $con->insert_id;
    	$result_exec->close();
    } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
    }
    
    //INSERTA LOG TRANSACCIONAL DE TABLA AMPLIACION
    insertLogAgendaAmp($idLogSeg, $resultadoAgendaAmp);
    //INSERTA LOG TRANSACCIONAL DE TABLA AGENDA
    insertLogAgendaMod_Amp($idLogSeg, $resultadoAgenda);
    
    echo 1;
    
}
else if ($resultadoagenda == 0 && $resultadoamp>0){
   
    //INSERTA LOG DE SEGURIDAD
    
    // $result_exec= mysqli_query($con,"INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES ('".$_SERVER['REMOTE_ADDR']."','".$_SESSION['usuariosesion']."','".$fecharegistroventa."','".$_SERVER['REQUEST_URI'].'=>IdAmp='.$idamp."','Modificar','".$_SERVER['HTTP_USER_AGENT']."')");
    // $idLogSeg = $con->insert_id;
    
    $Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
    $Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $Url = sanitizaCampo($_SERVER['REQUEST_URI'].'=>IdAmp='.$idamp, 'sanitizeurl|scapestring|htmlspecialchars',$con);
    if(!empty($Url)){
    	$UrlLog = $Url.'=>IdAmp='.$idamp;
    }
    $Modificar = 'Modificar';
    $Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                    
    try{
    	$result_exec= $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
    	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fecharegistroventa,$UrlLog,$Modificar,$Navegador);
    	$result_exec->execute();
    	$idLogSeg = $con->insert_id;
    	$result_exec->close();
    } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
    }
    
    //INSERTA LOG TRANSACCIONAL DE TABLA AMPLIACION
    insertLogAgendaAmp($idLogSeg, $resultadoAgendaAmp);
    
    echo 1;
}
else if ($resultadoagenda >0 && $resultadoamp==0){
    //$sqlagendahist=mysqli_query($con,"INSERT INTO dbVENTAS.tblagendahist(IdAgenda, IdAmp, InstaladoX, MatriculaTec, Comentario, FechaHoraREG,Repercusion,RepercusionCosto, MotivoInviable, MotivoCancelada,GestorAgenda,EstadoAmp) VALUES ('$idagenda','$idamp','$instaladox','$tecnico','$comentarioagenda','$fecharegistroagenda','$repercucion','$costo','$inviable','$cancelado','$gestor','$estadoamp')");    
    ingresarhistAgenda($idamp);
    //INSERTA LOG DE SEGURIDAD
    
    // $result_exec= mysqli_query($con,"INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES ('".$_SERVER['REMOTE_ADDR']."','".$_SESSION['usuariosesion']."','".$fecharegistroventa."','".$_SERVER['REQUEST_URI'].'=>IdAmp='.$idamp."','Modificar','".$_SERVER['HTTP_USER_AGENT']."')");
    // $idLogSeg = $con->insert_id;
    
    $Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
    $Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
    $Url = sanitizaCampo($_SERVER['REQUEST_URI'].'=>IdAmp='.$idamp, 'sanitizeurl|scapestring|htmlspecialchars',$con);
    if(!empty($Url)){
    	$UrlLog = $Url.'=>IdAmp='.$idamp;
    }
    $Modificar = 'Modificar';
    $Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                    
    try{
    	$result_exec= $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
    	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fecharegistroventa,$UrlLog,$Modificar,$Navegador);
    	$result_exec->execute();
    	$idLogSeg = $con->insert_id;
    	$result_exec->close();
    } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
    }
    
    //INSERTA LOG TRANSACCIONAL DE TABLA AGENDA
    insertLogAgendaMod_Amp($idLogSeg, $resultadoAgenda);
    
    echo 1;
}
else if ($resultadoagenda==0 && $resultadoamp==0){
    echo 0;
}
else {
    echo -1;
}

function actualizarAMP($idamp){
    
    global $con;
    
    global $estadoamp;
    global $FechaAgendamiento;
    global $FechaAmpliacion;
    global $FechaAgendamientoValoracion;
    

    
    if($estadoamp=='AgendadaTEC'){
        if ($FechaAgendamiento == ''){
            $FechaAgendamiento=date("Y-m-d");
        }else{
            $FechaAgendamiento=$FechaAgendamiento;
            
        }
        
        $FechaAmpliacion=NULL;
    }

    else if($estadoamp=='Instalada'){
        if ($FechaAmpliacion == ''){
            $FechaAmpliacion=date("Y-m-d");
        }else{
            $FechaAmpliacion=$FechaAmpliacion;
            
        }
        
    }
    else if($estadoamp=='VAsignadaTEC'){
        if ($FechaAgendamientoValoracion == ''){
            $FechaAgendamientoValoracion=date("Y-m-d");
        }else{
            $FechaAgendamientoValoracion=$FechaAgendamientoValoracion;
            
        }
        
    }
    else{
        $FechaAgendamiento=NULL;
        $FechaAmpliacion=NULL;
        if ($FechaAgendamientoValoracion == ''){
            $FechaAgendamientoValoracion=NULL;
        }else{
            $FechaAgendamientoValoracion=$FechaAgendamientoValoracion;
        }
        
    }
    
    try{
        
        $stmt = $con->prepare("UPDATE dbVENTAS.tblampliacion SET FechaAmpliacion=? WHERE IdAmp=?");
        $stmt->bind_param('si',$FechaAmpliacion,$idamp);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function actualizarAgenda($idamp){
    
    global $con;
    
    global $gestor;
    global $nmatenimiento;
    
    
    try{
        
        $stmt = $con->prepare("UPDATE dbVENTAS.tblagenda SET GestorAgenda=?,NMantenimiento=? WHERE IdAmp=?");
        $stmt->bind_param('ssi', $gestor,$nmatenimiento,$idamp);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}

function ingresarhistAgenda($idamp){
    
    global $con;
    
    global $fechagrabar;
    global $horagrabar;
    global $instaladox;
    global $tecnico;
    global $comentarioagenda;
    global $fecharegistroagenda;
    global $inviable;
    global $cancelado;
    global $repercucion;
    global $costo;
    global $gestor;
    global $estadoamp;
    global $idagenda;
    global $nmatenimiento;
        //Camara Externa
    global $lblfvisitaTec;
    global $lblhvisitaTEC;
    global $lblAsignadoTEC;
    global $lblNMantenimientoV;
    
       try{
            $stmt = $con->prepare("INSERT INTO dbVENTAS.tblagendahist(IdAgenda, IdAmp, FechaInst, HoraInst, InstaladoX, MatriculaTec, Comentario, FechaHoraREG, Repercusion, RepercusionCosto, MotivoInviable, MotivoCancelada, GestorAgenda,EstadoAmp, NMantenimiento,AsignadoTEC,FechaVisitaTEC,HoraVisitaTEC,NMantenimientoVTEC) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?)");
            $stmt->bind_param('iisssssssssssssssss', $idagenda, $idamp, $fechagrabar, $horagrabar, $instaladox, $tecnico, $comentarioagenda,$fecharegistroagenda,$repercucion ,$costo,$inviable, $cancelado, $gestor,$estadoamp,$nmatenimiento,$lblAsignadoTEC,$lblfvisitaTec,$lblhvisitaTEC,$lblNMantenimientoV);
            $stmt->execute();
        
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
    
}


