<?php
    date_default_timezone_set('America/Lima');
    //Funciones para codificar al momento de grabar en Mysql
    function myUrlEncode($string) {
        $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
        $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
        return str_replace($entities, $replacements, urlencode($string));
    }
    function format_date_dd_mm_Y($date){
        return date('d/m/Y', strtotime($date));
    }
    function format_date_Y_mm_dd($date){
        return date('Y-m-d', strtotime($date));
    }
    
    require_once '../config/db.php';
    require_once '../config/conexion.php';
    
    include_once 'Correo/correoNotificacionLeadGestionRemarketing.php';
    include_once 'funciones/Televenta_transferenciaLead.php';
    
    mysqli_set_charset($con, 'utf8');
    
    $fecharegistro = date("Y-m-d H:i:s");
    
    $IdLeadCC = $_POST['IdLeadCC'];
    $UltimaGestion = $_POST['UltimaGestion'];
    $modalContacto = $_POST['modalContacto'];
    //FALTA GESTIONABLE
    $modalGestionable = $_POST['modalGestionable'];
    $modalTipificacion = $_POST['modalTipificacion'];
    $modalMotivo = $_POST['modalMotivo'];
    
    if(!empty($_POST['modalFechahoraRellamada'])){
        $modalFechahoraRellamada = $_POST['modalFechahoraRellamada'];
        $modalFechahoraRellamada =  date("Y-m-d H:i:s", strtotime(str_replace('/', '-', $modalFechahoraRellamada)));
    } else {
        $modalFechahoraRellamada = null;
    }
    
    $modalTransferenciaTipotransf = $_POST['modalTransferenciaTipotransf'];
    $modalGestortv = $_POST['modalGestortv'];
    $modalTransferenciaObservaciontransf = $_POST['modalTransferenciaObservaciontransf'];
    
    $matriculaAgente = $_POST['matriculaAgente'];
    $Agente = $_POST['Agente'];
    $matriculaSupervisor = $_POST['matriculaSupervisor'];
    $Supervisor = $_POST['Supervisor'];
    
    $CodigoUbigeo = $_POST['CodigoUbigeo'];
    $ndocumento = $_POST['ndocumento'];
    $tipoDocumento = convertirtipoDocumentoEquifax($_POST['tipoDocumentoLead']);
    $nombres = $_POST['nombres'];
    $apellidos = $_POST['apellidos'];
    $telefono = $_POST['telefono'];
    $segmento = $_POST['segmento'];
    
    try {
        $stmt = $con->prepare("UPDATE tblGestionLead 
                                SET Contacto = ?,
                                    Gestionable = ?,
                                    ResultadoGestion = ?,
                                    SubTipificacion = ?,
                                    FechaHoraRellamada = ?,
                                    FechaHoraModificacion=?,
                                    UsuModifica=?
                                WHERE IdGestionLead =?");
        $stmt->bind_param('sssssssi',$modalContacto, $modalGestionable, $modalTipificacion, $modalMotivo, $modalFechahoraRellamada, $fecharegistro, $matriculaSupervisor, $UltimaGestion);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        if($respuesta > 0 ){
            
            $respuestaLead = actualizarLead($IdLeadCC);
            
            if($respuestaLead == 'exito'){
                
                if($modalTipificacion == 'televenta'){
                    //GENERAR DATOS DEL CLIENTE
                    // -- PRIMERO SE DEBE GENERAR EL IDGEOGRAFICO DEL CLIENTE
                     $idGeografico = generarIdGeografico($CodigoUbigeo);
                    
                    // -- REGISTRAR ID DOCUMENTO --
                    $idDocTV = registrarDocumento($tipoDocumento, $ndocumento);
                    
                    $NombreCompleto = $nombres.' '.$apellidos;
                    
                    $idCli = registrarCliente($idGeografico, $NombreCompleto, $telefono, $segmento, $idDocTV);
                    //DATOS DEL GESTOR DE TELEVENTA
                    
                    $datosGestorTV = consultaDatosGestor($modalGestortv);
                    //GENERAR VENTA
                    
                    $IdVenta = generarVenta($idCli, $datosGestorTV, $segmento, $modalGestortv, $matriculaAgente);
                    
                    $resultado = array(
                        'respuesta' => 'exito',
                        'respuestaLead' => 'exito',
                        'idCli' => $idCli,
                        'IdVenta' => $IdVenta,
                        'tipificacion' => $modalTipificacion
                    ); 
                } else {
                     $resultado = array('respuesta' => 'exito', 'respuestaLead' => 'exito');
                }
                 
                correoNotificacionCorreccionGestion($IdLeadCC);
                
            } else {
                $resultado = array('respuesta' => 'exito', 'respuestaLead' => 'error');
            }
   
        }
            
    } catch (\Exception $e) {
        $resultado = array('respuesta' => 'error', 'mensaje' => $e);
    }
    
    echo json_encode($resultado);

    function actualizarLead($IdLeadCC){
        
        global $con;
        global $modalTipificacion;
        
        try {
            $stmt = $con->prepare("UPDATE  tblLeadCC
                                    SET ResultadoGestion = ?
                                    WHERE IdLeadCC = ?");
            $stmt->bind_param('si', $modalTipificacion, $IdLeadCC);
            $stmt->execute();
            
            $respuesta = $stmt->affected_rows;
            
            if($respuesta > 0 ){
            
                $resultado = 'exito';
            } else {
                $resultado = 'error';
            }
            
            $stmt->close();
                
        } catch (\Exception $e) {
            $resultado = 'error';
        }
        
        return $resultado;
        
    }
    
    function convertirtipoDocumentoEquifax($tipoDocumento){
        $tipodocumentoconvertido=NULL;
        if($tipoDocumento==1){
            $tipodocumentoconvertido='DNI';
        }else if($tipoDocumento==6){
            $tipodocumentoconvertido='RUC';
        }else if($tipoDocumento==3){
            $tipodocumentoconvertido='CE';
        }else{
            $tipodocumentoconvertido='';
        }
        return $tipodocumentoconvertido;
    }
    


?>