<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}


$ingresokit=0;
$ingresoextras=0;
$ingresototal=0;

require '../config/db.php';
require '../config/conexion.php';
include '../helper/helper_validacion.php';

//AGREGAR FUNCIONES LOG
include 'log/insertLog.php'; //INSERTAR LOG
include 'log/insertLogFacturacionAmp.php'; //FUNCIONES FACT TABLA VENT
include 'log/insertLogFacturacion.php'; //FUNCIONES FACT TABLA FACT
include 'log/insertLogCliente.php'; //FUNCIONES FACT TABLA CLI

$fecharegistroagenda = date("Y-m-d H:i:s");
$fecharegistrofacturacion = date("Y-m-d H:i:s");
$fecharegistroventa = date("Y-m-d H:i:s");
$fecharegistro=date("Y-m-d H:i:s");

$gestor = sanitizaCampo($_POST['gestor'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$gestor = htmlspecialchars($gestor);

$estadoamp = sanitizaCampo($_POST['cboEstadoAmpliacion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$estadoamp = htmlspecialchars($estadoamp);

$idamp = sanitizaCampo($_POST['idAmpl'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$idamp = htmlspecialchars($idamp);

// $nmatenimiento=$_POST['lblNMantenimiento'];


//Facturacion
// $gestorupselling = $_POST['lblasignado'];

$fecharecpciondoc = sanitizaCampo($_POST['lblfecharecpciondoc'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$fecharecpciondoc = htmlspecialchars($fecharecpciondoc);

$fechafacturacion = sanitizaCampo($_POST['lblfechafacturacion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$fechafacturacion = htmlspecialchars($fechafacturacion);

$fechaconvertrecpciondoc=  myUrlEncode($fecharecpciondoc);
$fechagrabarrecpciondoc=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertrecpciondoc));

$fechaconvertfacturacion=  myUrlEncode($fechafacturacion);
$fechagrabarfacturacion= format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfacturacion));

//FORMATO COMPARAR FECHAS
if($fechafacturacion != ''){
    $fechacomparafacturacion = $fechagrabarrecpciondoc;
} else {
    $fechacomparafacturacion = '';
}
//FECHA COMPARAR FECHAS
if($fecharecpciondoc != ''){
    $fechacompararecpciondoc = $fechagrabarrecpciondoc;
} else {
    $fechacomparafacturacion = '';
}

 //Facturacion
$motivoincidencia = sanitizaCampo($_POST['lblmotivoincidencia'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$motivoincidencia = htmlspecialchars($motivoincidencia);

$factdocoriginal = sanitizaCampo($_POST['lblfactdocoriginal'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$factdocoriginal = htmlspecialchars($factdocoriginal);

$factsegmentacion = sanitizaCampo($_POST['lblfactsegmentacion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$factsegmentacion = htmlspecialchars($factsegmentacion);

$factpago = sanitizaCampo($_POST['lblfactpago'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$factpago = htmlspecialchars($factpago);

$factautoriza = sanitizaCampo($_POST['lblfactautoriza'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$factautoriza = htmlspecialchars($factautoriza);

$factdni = sanitizaCampo($_POST['lblfactdni'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$factdni = htmlspecialchars($factdni); 

$factelementosctops = sanitizaCampo($_POST['lblfactelementosctops'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$factelementosctops = htmlspecialchars($factelementosctops); 

$factdocpai = sanitizaCampo($_POST['lblfactdocpai'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$factdocpai = htmlspecialchars($factdocpai); 

$factfaltadoc = sanitizaCampo($_POST['lblfactfaltadoc'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$factfaltadoc = htmlspecialchars($factfaltadoc);

$factrehacercto = sanitizaCampo($_POST['lblfactrehacercto'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$factrehacercto = htmlspecialchars($factrehacercto);

$factafiliacion = sanitizaCampo($_POST['lblfactafiliacion'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$factafiliacion = htmlspecialchars($factafiliacion);

$factprospecto_nroguia = sanitizaCampo($_POST['lblfactprospecto_nroguia'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$factprospecto_nroguia = htmlspecialchars($factprospecto_nroguia);

$factfuerahora = sanitizaCampo($_POST['lblfactfuerahora'], 'sanitizestring|scapestring|htmlspecialchars',$con);
$factfuerahora = htmlspecialchars($factfuerahora);

// if($PAI=="PAI 30x36"){

// $ingresokit=round((($preciokit+1080)/1.18),2);
// $ingresoextras=round(($totalextra/1.18),2);
// $ingresototal=($ingresokit+$ingresoextras);

// }else{

// $ingresokit=round((($preciokit)/1.18),2);
// $ingresoextras=round(($totalextra/1.18),2);
// $ingresototal=($ingresokit+$ingresoextras);

// }



//FUNCION QUE DEVUELVE ARRAY DE AMPLIACON
// $resultadoFactuVen = consultaFacturacionAmp($idventa);

//FUNCION QUE DEVUELVE ARRAY DE DATOS DE FACTURACION EN TABLA FACTURACION
// $resultadoFacturacion = consultaFacturacionMod_Amp($idventa);

$resultadoamp = actualizarAMP($idamp);

if(empty($fecharecpciondoc) && empty($fechafacturacion) ){
    $sqlfacturacion= $con->prepare("UPDATE dbVENTAS.tblfacturacion f SET f.MotivoIncidencia=?,f.DOCOriginal=?,f.Segmentacion=?,f.Pago=?,f.Autoriza=?,f.DNI=?,f.ElementosCTOPS=?,f.DOCPAI=?,f.FaltaDOC=?,f.RehacerCTO=?,f.Afiliacion=?,f.Prospecto_NroGuia=?,f.FueraHora=? WHERE f.IdAmp=?");
    $sqlfacturacion->bind_param('sssssssssssssi',$motivoincidencia,$factdocoriginal,$factsegmentacion,$factpago,$factautoriza,$factdni,$factelementosctops,$factdocpai,$factfaltadoc,$factrehacercto,$factafiliacion,$factprospecto_nroguia,$factfuerahora,$idamp);
    $sqlfacturacion->execute();
    $affectedrowFact = $sqlfacturacion->affected_rows;
}
else if(empty($fechafacturacion)){
    $sqlfacturacion= $con->prepare("UPDATE dbVENTAS.tblfacturacion f SET f.MotivoIncidencia=?,f.FechaRecepcionDOC=?,f.DOCOriginal=?,f.Segmentacion=?,f.Pago=?,f.Autoriza=?,f.DNI=?,f.ElementosCTOPS=?,f.DOCPAI=?,f.FaltaDOC=?,f.RehacerCTO=?,f.Afiliacion=?,f.Prospecto_NroGuia=?,f.FueraHora=? WHERE f.IdAmp=?");
    $sqlfacturacion->bind_param('ssssssssssssssi',$motivoincidencia,$fechagrabarrecpciondoc,$factdocoriginal,$factsegmentacion,$factpago,$factautoriza,$factdni,$factelementosctops,$factdocpai,$factfaltadoc,$factrehacercto,$factafiliacion,$factprospecto_nroguia,$factfuerahora,$idamp);
    $sqlfacturacion->execute();
    
    $affectedrowFact = $sqlfacturacion->affected_rows;
}
else if(empty($fecharecpciondoc)){
    $sqlfacturacion= $con->prepare("UPDATE dbVENTAS.tblfacturacion f SET f.MotivoIncidencia=?,f.FechaFacturacion=?,f.DOCOriginal=?,f.Segmentacion=?,f.Pago=?,f.Autoriza=?,f.DNI=?,f.ElementosCTOPS=?,f.DOCPAI=?,f.FaltaDOC=?,f.RehacerCTO=?,f.Afiliacion=?,f.Prospecto_NroGuia=?,f.FueraHora=? WHERE f.IdAmp=?");
    $sqlfacturacion->bind_param('ssssssssssssssi',$motivoincidencia,$fechagrabarfacturacion,$factdocoriginal,$factsegmentacion,$factpago,$factautoriza,$factdni,$factelementosctops,$factdocpai,$factfaltadoc,$factrehacercto,$factafiliacion,$factprospecto_nroguia,$factfuerahora,$idamp);
    $sqlfacturacion->execute();
    
    $affectedrowFact = $sqlfacturacion->affected_rows;
}
else{
    $sqlfacturacion= $con->prepare("UPDATE dbVENTAS.tblfacturacion f SET f.MotivoIncidencia=?,f.FechaRecepcionDOC=?,f.FechaFacturacion=?,f.DOCOriginal=?,f.Segmentacion=?,f.Pago=?,f.Autoriza=?,f.DNI=?,f.ElementosCTOPS=?,f.DOCPAI=?,f.FaltaDOC=?,f.RehacerCTO=?,f.Afiliacion=?,f.Prospecto_NroGuia=?,f.FueraHora=? WHERE f.IdAmp=?");
    $sqlfacturacion->bind_param('sssssssssssssssi',$motivoincidencia,$fechagrabarrecpciondoc,$fechagrabarfacturacion,$factdocoriginal,$factsegmentacion,$factpago,$factautoriza,$factdni,$factelementosctops,$factdocpai,$factfaltadoc,$factrehacercto,$factafiliacion,$factprospecto_nroguia,$factfuerahora,$idamp);
    $sqlfacturacion->execute();
    
    $affectedrowFact = $sqlfacturacion->affected_rows;
}


$Ip = sanitizaCampo($_SERVER['REMOTE_ADDR'], 'sanitizeip|scapestring|htmlspecialchars',$con);
$Usuario = sanitizaCampo($_SESSION['usuariosesion'], 'sanitizeint|scapestring|htmlspecialchars',$con);
$Url = sanitizaCampo($_SERVER['REQUEST_URI'].'=>IdVenta='.$idventa, 'sanitizeurl|scapestring|htmlspecialchars',$con);
if(!empty($Url)){
	$UrlLog = $Url.'=>IdVenta='.$idventa;
}
$Modificar = 'Modificar';
$Navegador = sanitizaCampo($_SERVER['HTTP_USER_AGENT'], 'sanitizeint|scapestring|htmlspecialchars',$con);
                
try{
	$result_exec= $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
	$result_exec->bind_param('ssssss',$Ip,$Usuario,$fecharegistro,$UrlLog,$Modificar,$Navegador);
	$result_exec->execute();
	$idLogSeg = $con->insert_id;
	$result_exec->close();
} catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
}

// if ($resultadoamp > 0) {
//     insertLogFacturacionAmp($idLogSeg, $resultadoFactuVen);
// }
// if ($affectedrowFact > 0 ){
//     insertLogFacturacionMod_Amp($idLogSeg, $resultadoFacturacion);
// }

// unset($resultadoFactuVen);
// unset($resultadoFacturacion);

// echo $sqlfacturacion;
echo $affectedrowFact;



function actualizarAMP($idamp){
    
    global $con;
    
    global $estadoamp;
    
    try{
        
        $stmt = $con->prepare("UPDATE dbVENTAS.tblampliacion SET EstadoAmp= ? WHERE IdAmp=?");
        $stmt->bind_param('si', $estadoamp, $idamp);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
        $stmt->close();
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
    
}


