<?php
include('is_logged.php');
date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require '../config/db.php';
require '../config/conexion.php';

$FechaPendValoracion=date("Y-m-d");
//DATOS COTIZACION
$IdCotizacion = htmlspecialchars($_POST['IdCotizacion']);
$IdCodDetInstCamaraCopia = htmlspecialchars($_POST['IdCodDetInstCamara']);
$TotalPrecio=htmlspecialchars($_POST['TotalPrecio']);
$TotalUnidad=htmlspecialchars($_POST['TotalUnidad']);

$sql_venta = mysqli_query($con, "SELECT IdCotizacion, Iditem, Unidades, PrecioCotDetalle, TipoPrecio, DsctoCta, Subtotal, Subtotal_cuotaMes, DetReq 
FROM tblcotizaciondetalle WHERE IdCotDet  = ?");

    	try{       
            $stmt = $con->prepare($sql_venta);
            $stmt->bind_param('i', $IdCodDetInstCamaraCopia);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($IdCotizacion,$Iditem, $Unidades, $PrecioCotDetalle, $TipoPrecio, $DsctoCta, $Subtotal, $Subtotal_cuotaMes, $DetReq);
    
        } catch(PDOException $e) {
            echo "Error: " . $e->getMessage();
        }

        $IdCotizacionDetalle = insertCotizacionDetalle($IdCotizacion);
        if ($IdCotizacionDetalle > 0 ){
            
            if  (actualizarCotizacion($IdCotizacion) >= 0){
                /*
                $ruta="../images/".$IdCotizacionOriginal;
                $destino="../images/".$IdCotizacion;
                if (!file_exists($destino)){
				    mkdir($destino, 0755);
			    }
                $archivos= glob($ruta.'*.*');
                 
                foreach ($archivos as $archivo){
                $archivo_copiar= str_replace($ruta, $destino, $archivo);
                copy($archivo, $archivo_copiar);
                }
                */
                
                $resultado = array(
                    'respuesta' => 'Exito',
                    'tipo' => 'Insertar',
                    'IdCotDetalle' => $IdCotizacionDetalle
                );
            } else {
                $resultado = array(
                    'respuesta' => 'Error'
                );     
            }
            
        } else {
            $resultado = array(
                'respuesta' => 'Error'
            );     
        } 

function insertCotizacionDetalle($IdCotizacion){
    
    global $con;
    
    $Iditem = 31;
    $Unidades = 1;
    global $PrecioCotDetalle;
    $TipoPrecio = 'CATALOGO';
    $DsctoCta = 1.00;
    $Subtotal_cuotaMes = 0.0000;
    global $DetReq;
    
    try{
        $stmt = $con->prepare("INSERT INTO tblcotizaciondetalle(IdCotizacion, Iditem, Unidades, PrecioCotDetalle, TipoPrecio, DsctoCta, Subtotal, Subtotal_cuotaMes, DetReq)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param('iiidsddds', $IdCotizacion, $Iditem, $Unidades, $PrecioCotDetalle, $TipoPrecio, $DsctoCta, $PrecioCotDetalle, $Subtotal_cuotaMes, $DetReq);
        $stmt->execute();
        
        $respuesta = $con->insert_id;
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;

}

function actualizarCotizacion($IdCotizacion){
    global $con;
    
    global $TotalUnidad;
    global $TotalPrecio;
    
    try{
        $stmt = $con->prepare("UPDATE tblcotizacion SET TotalUnidad=?, TotalPrecio=? WHERE IdCotizacion=?");
        $stmt->bind_param('idi', $TotalUnidad, $TotalPrecio, $IdCotizacion);
        $stmt->execute();
        
        $respuesta = $stmt->affected_rows;
        
    } catch (\Exception $e) {
        $respuesta = 'error';
    }
    
    return $respuesta;
}