<?php
include('is_logged.php');
require_once '../config/db.php';
require_once '../config/conexion.php';

$arreglo=NULL;

if (isset($_POST['url'])) {
$url=$_POST['url'];
$url=htmlspecialchars($url);
}else{
$url="";   
}

if (isset($_POST['marca'])) {
$marca=$_POST['marca'];
$marca=htmlspecialchars($marca);
}else{
$marca="";    
}

if (isset($_POST['ccmdp'])) {
$cc=$_POST['ccmdp'];
$cc=htmlspecialchars($cc);
}else{
$cc=""; 
}

$sWhere = "";
$mensaje="";
$types="";
$param=[];
$contador=0;
if($url != "" && $url!="0"){

    $sWhere.= " and m.CodigoMDP = ?";
    $types.="s";
    array_push($param,$url);
    
    $mensaje.=" con la URL seleccionada ".$url;
    $contador++;
}
if($marca !=""){

    $arrayValoresMarca = array(); 
    $arrayValoresMarca=explode(',',$marca);
    
    $clauseMarca = implode(',', array_fill(0, count($arrayValoresMarca), '?')); //create 3 question marks
    $types.= str_repeat('s', count($arrayValoresMarca)); //create 3 ints for bind_param
    
    $param=array_merge($param,$arrayValoresMarca);
    
    $sWhere .= " and t.TarjetaMarca in ($clauseMarca)";
    $mensaje.=" con marca de ".$marca;
    $contador++;
    
}
if($cc != ""){

    $arrayValoresCC = array();
    $arrayValoresCC=explode(',',$cc);
        
    $clauseCc = implode(',', array_fill(0, count($arrayValoresCC), '?')); //create 3 question marks
    $types.= str_repeat('s', count($arrayValoresCC)); //create 3 ints for bind_param
    
    $param=array_merge($param,$arrayValoresCC);
    
    $sWhere .= " and u.CC in ($clauseCc)";
    $mensaje.=" con CC de ".$cc;
    $contador++;
}

    try{
        $sWhere .= " order by t.fechaHoraREG DESC";
        
        $sentencia="select t.IdTransaccion, 
        t.FechaHoraREG,
        u.CC,
        t.GestorOrigen,
        t.TipoPago,
        t.CorreoBilling,
        t.TarjetaMarca,
        v.NContrato,
        v.NProspecto,
        m.URL,
        m.CodigoMDP,
        (v.Preciokit+v.TotalExtra) MontoTotal
        from tbltransaccion t
        INNER JOIN tblventa v on t.IdVenta=v.IdVenta
        INNER JOIN tblmdp m ON t.IdMdp=m.IdMdp
        INNER JOIN dbUSUARIO.tblusuario u on u.Matricula=t.GestorOrigen
        where 1 $sWhere";
        
        $stmt = $con->prepare( $sentencia);
        if($contador>0){
        $stmt->bind_param($types, ...$param);            
        }
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdTransaccion,
            $FechaHoraREG,
            $CC,
            $GestorOrigen,
            $TipoPago,
            $CorreoBilling,
            $TarjetaMarca,
            $NContrato,
            $NProspecto,
            $URL,
            $CodigoMDP,
            $MontoTotal);
        $json = [];
        
        if($stmt->num_rows>0){
        
            while ($stmt->fetch()){
            $json[] = array_map("utf8_encode",[
                'IdTransaccion'=>$IdTransaccion,
                'FechaHoraREG'=>$FechaHoraREG,
                'CC'=>$CC,
                'GestorOrigen'=>$GestorOrigen,
                'TipoPago'=>$TipoPago,
                'CorreoBilling'=>$CorreoBilling,
                'TarjetaMarca'=>$TarjetaMarca,
                'NContrato'=>$NContrato,
                'NProspecto'=>$NProspecto,
                'URL'=>$URL,
                'CodigoMDP'=>$CodigoMDP,
                'MontoTotal'=>$MontoTotal
                ]);            
    	    }
        }

        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }

echo json_encode($json); 

