<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

$matriculauser=sanitizaCampo($_GET['matriculauser'],'sanitizestring|scapestring|htmlspecialchars',$con);
$matriculauser = htmlspecialchars($matriculauser);

$permisouser=sanitizaCampo($_GET['permisouser'],'sanitizestring|scapestring|htmlspecialchars',$con);
$permisouser = htmlspecialchars($permisouser);

$arreglo=NULL;


if($permisouser=="GestorAMP"){
    $query=$con->prepare("SELECT
am.IdAmp,
am.NAviso,
a.NMantenimiento,
DATE_FORMAT(am.FechaHoraREG, '%Y-%m-%d %r') FechaHoraREG,
am.UsuarioREG,
am.GestorUpselling,
am.Canal,
am.EstadoAmp,
am.Campana,
am.ComentarioAmp,
am.MesAmp,
a.FechaInst,
a.HoraInst,
c.NombApellido Cliente,
c.NCliente,
g.Distrito,
g.Provincia,
am.Tecnico
FROM dbVENTAS.tblampliacion am
INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=am.IdCliente
INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
LEFT JOIN dbVENTAS.tblagenda a ON am.IdAmp = a.IdAmp
where am.GestorUpselling=?
ORDER BY  am.FechaHoraREG DESC");
$query->bind_param('s',$matriculauser);
$query->execute();
$query->store_result();
$query->bind_result(
        $IdAmpRow,
        $NAvisoRow,
        $NMantenimientoRow,
        $FechaHoraREGRow,
        $UsuarioREGRow,
        $GestorUpsellingRow,
        $CanalRow,
        $EstadoAmpRow,
        $CampanaRow,
        $ComentarioAmpRow,
        $MesAmpRow,
        $FechaInstRow,
        $HoraInstRow,
        $ClienteRow,
        $NClienteRow,
        $DistritoRow,
        $ProvinciaRow,
        $TecnicoRow
    );
    
    if($query->num_rows <= 0){
    die("Error");
    }else{
        $return_arr = array();
        while($query->fetch()){
         $row_array['IdAmp'] =$IdAmpRow;
         $row_array['NAviso'] =$NAvisoRow;
         $row_array['NMantenimiento'] =$NMantenimientoRow;
         $row_array['FechaHoraREG'] =$FechaHoraREGRow;
         $row_array['UsuarioREG'] =$UsuarioREGRow;
         $row_array['GestorUpselling'] =$GestorUpsellingRow;
         $row_array['Canal'] =$CanalRow;
         $row_array['EstadoAmp'] =$EstadoAmpRow;
         $row_array['Campana'] =$CampanaRow;
         $row_array['ComentarioAmp'] =$ComentarioAmpRow;
         $row_array['MesAmp'] =$MesAmpRow;
         $row_array['FechaInst'] =$FechaInstRow;
         $row_array['HoraInst'] =$HoraInstRow;
         $row_array['Cliente'] =$ClienteRow;
         $row_array['NCliente'] =$NClienteRow;
         $row_array['Distrito'] =$DistritoRow;
         $row_array['Provincia'] =$ProvinciaRow;
         $row_array['Tecnico'] =$TecnicoRow;
        
         array_push($return_arr,array_map("utf8_encode",$row_array)); //o este
        }
        echo json_encode($return_arr);
    
    
    }
    
    $query->close();
}
else{
$query=$con->prepare("SELECT
am.IdAmp,
am.NAviso,
a.NMantenimiento,
DATE_FORMAT(am.FechaHoraREG, '%Y-%m-%d %r') FechaHoraREG,
am.UsuarioREG,
am.GestorUpselling,
am.Canal,
am.EstadoAmp,
am.Campana,
am.ComentarioAmp,
am.MesAmp,
a.FechaInst,
a.HoraInst,
c.NombApellido Cliente,
c.NCliente,
g.Distrito,
g.Provincia,
am.Tecnico
FROM dbVENTAS.tblampliacion am
INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=am.IdCliente
INNER JOIN dbVENTAS.tblgeografico g on g.IdGeografico=c.IdGeografico
LEFT JOIN dbVENTAS.tblagenda a ON am.IdAmp = a.IdAmp
where am.Canal<>'Cotizacion'
ORDER BY  am.FechaHoraREG DESC");

$query->execute();
$query->store_result();
$query->bind_result(
        $IdAmpRow,
        $NAvisoRow,
        $NMantenimientoRow,
        $FechaHoraREGRow,
        $UsuarioREGRow,
        $GestorUpsellingRow,
        $CanalRow,
        $EstadoAmpRow,
        $CampanaRow,
        $ComentarioAmpRow,
        $MesAmpRow,
        $FechaInstRow,
        $HoraInstRow,
        $ClienteRow,
        $NClienteRow,
        $DistritoRow,
        $ProvinciaRow,
        $TecnicoRow
    );

    if($query->num_rows <= 0){
    die("Error");
    }else{
        $return_arr = array();
        while($query->fetch()){
         $row_array['IdAmp'] =$IdAmpRow;
         $row_array['NAviso'] =$NAvisoRow;
         $row_array['NMantenimiento'] =$NMantenimientoRow;
         $row_array['FechaHoraREG'] =$FechaHoraREGRow;
         $row_array['UsuarioREG'] =$UsuarioREGRow;
         $row_array['GestorUpselling'] =$GestorUpsellingRow;
         $row_array['Canal'] =$CanalRow;
         $row_array['EstadoAmp'] =$EstadoAmpRow;
         $row_array['Campana'] =$CampanaRow;
         $row_array['ComentarioAmp'] =$ComentarioAmpRow;
         $row_array['MesAmp'] =$MesAmpRow;
         $row_array['FechaInst'] =$FechaInstRow;
         $row_array['HoraInst'] =$HoraInstRow;
         $row_array['Cliente'] =$ClienteRow;
         $row_array['NCliente'] =$NClienteRow;
         $row_array['Distrito'] =$DistritoRow;
         $row_array['Provincia'] =$ProvinciaRow;
         $row_array['Tecnico'] =$TecnicoRow;
        
         array_push($return_arr,array_map("utf8_encode",$row_array)); //o este
        }
        echo json_encode($return_arr);
    
    
    }
    
    $query->close();
}




