<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';
include '../helper/helper_validacion.php';

$q=NULL;

if (isset($_GET['q'])) {
    $q=sanitizaCampo($_GET['q'],'sanitizestring|scapestring|htmlspecialchars',$con);
}



    try{
        $q = "%{$q}%";
        $stmt = $con->prepare( "SELECT g.IdGeografico,g.Distrito,g.Provincia FROM dbVENTAS.tblgeografico g WHERE g.Estado='Activo' and g.Distrito LIKE ?");
        $stmt->bind_param('s', $q);
        $stmt->execute();
        $stmt->store_result();
        $stmt->bind_result($IdGeografico,$Distrito,$Provincia);
        $json = [];        
        while ($stmt->fetch()){
        $json[] = array_map("utf8_encode",['id'=>$IdGeografico, 'text'=>$Distrito." - ".$Provincia]);         
	    }
	    
        $stmt->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }



echo json_encode($json);


