<?php

include('is_logged.php');

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date)
{
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date)
{
    return date('Y-m-d', strtotime($date));
}

require_once '../config/db.php';
require_once '../config/conexion.php';

$fecha_inicio = htmlspecialchars($_POST['fecha_registro_inicio']);
$fecha_formateada_inicio = date('Y-m-d', strtotime($fecha_inicio));
$fecha_fin = htmlspecialchars($_POST['fecha_registro_fin']);
$fecha_formateada_fin = date('Y-m-d', strtotime($fecha_fin));
$id = htmlspecialchars($_POST['id_registro']);
$lblcondicion=htmlspecialchars($_POST['registro']);

$fecharegistro = date('Y-m-d H:i:s', time());


if($lblcondicion=="Actualizar")
{

try {
        
  $stmt = $con->prepare("UPDATE dbVENTAS.tbltmpjefaturas j SET j.FechaInicio=?, j.FechaFinal=? WHERE j.IdTmpJefatura = ?");
  $stmt->bind_param('ssi', $fecha_formateada_inicio,$fecha_formateada_fin,$id);
  $stmt->execute();
  $stmt->close();
  
} catch (\Exception $e) {
  echo $e->getMessage();
}

$REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
$usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
$REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI']);
$Acceso='Modificar';
$HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);

try {
        
  $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
  $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
  $stmt->execute();
  $stmt->close();
  
} catch (\Exception $e) {
  echo $e->getMessage();
}


echo 1;

}else if($lblcondicion=="Registrar")
{

try {
        
  $stmt = $con->prepare("INSERT INTO tbltmpjefaturas(FechaInicio, FechaFinal, FechaHoraREG) VALUES (?,?,?)");
  $stmt->bind_param('sss', $fecha_formateada_inicio,$fecha_formateada_fin,$fecharegistro);
  $stmt->execute();
  $stmt->close();
  
} catch (\Exception $e) {
  echo $e->getMessage();
}


$REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
$usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
$REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI']);
$Acceso='Registrar';
$HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);

try {
        
  $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
  $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
  $stmt->execute();
  $stmt->close();
  
} catch (\Exception $e) {
  echo $e->getMessage();
}


echo 2;

}



