<?php

include('is_logged.php');

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}

require_once '../config/db.php';
require_once '../config/conexion.php';
//LOG TRANSACCION
include 'log/insertLogCliente.php';
include 'log/insertLog.php';
include 'log/insertLogFacturacion.php'; //LOG FACTURACION
include 'log/insertLogAgenda.php'; //LOG AGENDA
include 'log/insertLogVisita.php';
include 'Correo/correoNotificacionCheckIn.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

$gestorbackoffice=htmlspecialchars($_POST['gestorbackoffice']);

$matricula=htmlspecialchars($_POST['lblmatricula']);
$nombcomercial=htmlspecialchars($_POST['lblnombcomercial']);
$dc=htmlspecialchars($_POST['lbldc']);
$jefeventa=htmlspecialchars($_POST['lbljefeventa']);
$estadovisita=htmlspecialchars($_POST['lblestadovisita']);
$estadoventa=htmlspecialchars($_POST['lblestadoventa']);
$tipoventa=htmlspecialchars($_POST['lbltipoventa']);
$segmento=htmlspecialchars($_POST['lblsegmento']);
$asignadopor=htmlspecialchars($_POST['lblasignado']);
$nprospecto=htmlspecialchars($_POST['lblnprospecto']);
$origen=htmlspecialchars($_POST['lblorigen']);
$mesvisita=htmlspecialchars($_POST['lblmesvisita']);
$leadid=htmlspecialchars($_POST['lblleadid']);

$fvencimiento=htmlspecialchars($_POST['lblfvencimiento']);
$fvisita=htmlspecialchars($_POST['lblfvisita']);
$hvisita=htmlspecialchars($_POST['lblhvisita']);

//MODIFICACION EMU 16.05 
if(isset($_POST['ValFObras'])){
    $fobras=htmlspecialchars($_POST['ValFObras']);
} else {
    $fobras='NO';
}
//MODIFICACION EMU 21.05
if(isset($_POST['lblFVisitaReal'])){
    $fvisitaobras=htmlspecialchars($_POST['lblFVisitaReal']);
    if ($fvisitaobras==''){
        $queryFechaVisita = NULL;    
    } else {
        $fechaconvertfvisitaobras = myUrlEncode($fvisitaobras);
        $fechagrabarfvisitaobras = format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfvisitaobras));
        $queryFechaVisita = $fechagrabarfvisitaobras;
    }
} else {
    $fvisitaobras='';
    $fechaconvertfvisitaobras = '';
    $fechagrabarfvisitaobras = '';
    $queryFechaVisita = NULL;
}

$fechaconvertvencimiento=  myUrlEncode($fvencimiento);
$fechagrabarvencimiento=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertvencimiento));
$fechaconvertfvisita=  myUrlEncode($fvisita);
$fechagrabarfvisita=  format_date_Y_mm_dd(str_replace('/', '-', $fechaconvertfvisita));

$horaconvertvisita=  myUrlEncode($hvisita);
$horagrabarvisita=  date("H:i", strtotime(str_replace("+"," ",$horaconvertvisita)));

$nombcliente=htmlspecialchars($_POST['lblnombcliente']);
$correo=htmlspecialchars($_POST['lblcorreo']);
$direccion=htmlspecialchars($_POST['lbldireccion']);
$interior=htmlspecialchars($_POST['lblinterior']); //NUEVO CAMPO 10-2020
$referencia=htmlspecialchars($_POST['lblreferencia']); //NUEVO CAMPO 10-2020
$distrito=htmlspecialchars($_POST['lbldistrito']);
$telefonouno=htmlspecialchars($_POST['lblmovil']);
$telefonodos=htmlspecialchars($_POST['lblfijo']);
$idusuario=htmlspecialchars($_POST['lblidusuario']);
$comentariovisita=htmlspecialchars($_POST['lblcomentariovisita']);
//$nif=$_POST['lblnif'];

if (isset($_POST['objGeofinder'])){
    $objGeofinder = $_POST['objGeofinder'];
} else {
    $objGeofinder = null;
}

//ZONFICACION
$idZonificacion = $_POST['idZonificacion'];
$objZonificacionVerisure = $_POST['objZonificacionVerisure'];
$lbldireccionAprox = htmlspecialchars($_POST['lbldireccionAprox']);
$lbltipoDireccion = htmlspecialchars($_POST['lbltipoDireccion']);
$lblIdDireccion = htmlspecialchars($_POST['lblIdDireccion']);

$txtMotivoDelegacion = htmlspecialchars($_POST['txtMotivoDelegacion']);
$lbldcobjzonificacion = $_POST['lbldcobjzonificacion'];

//FUNCION DE DOCUMENTO
 $tipodoc=htmlspecialchars($_POST['lbltipodoc']);
 $documento=htmlspecialchars($_POST['lbldocumento']);
//CONSULTA SCORING
if (isset($_POST['lblIdConsultaScoring'])){
    $IdConsultaScoring=$_POST['lblIdConsultaScoring'];
    $PerfilScoring=$_POST['lblperfilscoring'];
    $Accion=$_POST['lblaccion'];
} else {
    $IdConsultaScoring = NULL;
    $PerfilScoring =  NULL;
    $Accion = NULL;
}

//CALIDAD DE LA DIRECCION
$CalidadGeo = $_POST['CalidadGeo'];

$GestionOrigen = 'VENTA';
$fecharegistroagenda = date("Y-m-d H:i:s");
$fecharegistrofacturacion = date("Y-m-d H:i:s");
$fecharegistroventa = date("Y-m-d H:i:s");

//QUERY PARA VALIDAR QUE EL NPROSPECTO NO EXISTE

   try{
        $stmtValP = $con->prepare( "SELECT 1 FROM dbVENTAS.tblventa v WHERE v.NProspecto= ?");
        $stmtValP->bind_param('i', $nprospecto);
        $stmtValP->execute();
        $stmtValP->store_result();
        $stmtValP->bind_result($num);
        $numrows=$stmtValP->num_rows;
        $stmtValP->fetch();       
        $stmtValP->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }  


if($numrows>0){
    die('3'); //EXISTE UN REGISTRO CON ESE NUMERO DE PROSPECTO 
} else {
    
    actualizarCalidadGeo($CalidadGeo);
    
    $IdDocVisita = insertarDocumento();
    
    $arrayCliente = consultaClienteI();
    
    $idCli = insertarCliente();
    
    $arrayVenta=consultaVisitaI();
    
    $VAsignada='VAsignada';

   try{
        $stmtValV = $con->prepare( "INSERT INTO dbVENTAS.tblventa(IdUsuario,IdCliente,Matricula,Comercial,CC,JefeVenta,CategoriaVenta,TipoVenta,Segmento,NProspecto,EstadoVenta,FechaHoraREG,EstadoVisita,FechaVisita,HoraVisita,FVencimientoVisita,GestorMKT,OrigenVisita,ComentarioVisita,GestorOrigen,CCOriginal,MesVisita,LeadID, FObras, FVisitaObras,IdConsultaScoring,PerfilScoring,Accion, MotivoDifDelegacion) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?, ?,?,?,?)");
        $stmtValV->bind_param('iississsssssssssssssissssisss', $idusuario,$idCli,$matricula,$nombcomercial,$dc,$jefeventa,$VAsignada,$tipoventa,$segmento,$nprospecto,$estadoventa,$fecharegistroventa,$estadovisita,$fechagrabarfvisita,$horagrabarvisita,$fechagrabarvencimiento,$asignadopor,$origen,$comentariovisita,$gestorbackoffice,$dc,$mesvisita,$leadid,$fobras, $queryFechaVisita, $IdConsultaScoring, $PerfilScoring, $Accion, $txtMotivoDelegacion);
        $stmtValV->execute();
        $idVen = $con->insert_id;       
        $stmtValV->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }   
    
    
// REGISTRO EN TABLA AGENDA
        $arrayAgenda=consultaAgendaI();
           try{
                $stmtAgenda = $con->prepare( "INSERT INTO dbVENTAS.tblagenda(IdVenta,FechaHoraREG, GestionOrigen) VALUES (?,?, ?)");
                $stmtAgenda->bind_param('iss', $idVen,$fecharegistroagenda,$GestionOrigen);
                $stmtAgenda->execute();
                $stmtAgenda->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            }             

//REGISTRO EN TABLA FACTURACION
          $arrayFactu=consultaFacturacionI(); 
           try{
                $stmtFact = $con->prepare( "INSERT INTO dbVENTAS.tblfacturacion(IdVenta, FechaHoraREG, GestionOrigen) VALUES (?,?,?)");
                $stmtFact->bind_param('iss', $idVen,$fecharegistrofacturacion,$GestionOrigen);
                $stmtFact->execute();
                $stmtFact->close();
        
            } catch(PDOException $e) {
                echo "Error: " . $e->getMessage();
            } 
    
        $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
        $usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
        $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI'].'=>IdVenta='.$idVen);
        $Acceso='Registrar';
        $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
        
        try {
                
          $stmtLog = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
          $stmtLog->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
          $stmtLog->execute();
          $idLogSeg = $con->insert_id;
          $stmtLog->close();
          
        } catch (\Exception $e) {
          echo $e->getMessage();
        }

    insertarLogI($idLogSeg, $arrayCliente);
    insertarLogVisitaI_PRUEBA($idLogSeg, $arrayVenta);
    insertLogAgendaI($idLogSeg, $arrayAgenda);
    insertLogFacutracionI($idLogSeg, $arrayFactu);
    echo 1;
        
}

//CORREO DUPLICIDAD RP Y RE

$buscarnumero=$telefonouno;
$contador=0;




    try{
        $stmtDupl = $con->prepare( "SELECT * FROM (SELECT v.IdVenta ID,v.FechaHoraREG,v.Matricula,v.Comercial,v.CC,v.NProspecto,v.TipoVenta,c.Telefonouno,c.Telefonodos,'Visita' OrigenVista FROM tblventa v 
        INNER JOIN tblcliente c on c.IdCliente=v.IdCliente
        WHERE (v.TipoVenta='RE' and v.CCOriginal!='511' and v.CCOriginal!='512')
        and (v.EstadoVenta='PendienteData' or v.EstadoVenta='PendienteAgenda' or v.EstadoVenta='AgendadaTEC' or v.EstadoVenta='AgendadaDEL' or v.EstadoVenta='NoVendida' or v.EstadoVenta='Cancelada' or v.EstadoVenta='Inviable' or v.EstadoVenta='Ilocalizable' or v.EstadoVenta='VAsignada') 
        and DATEDIFF(curdate(), v.FechaHoraREG) <=105 and
        (c.Telefonouno=? or c.Telefonodos=?)
        UNION
        SELECT v.IdVenta ID,v.FechaHoraREG,v.Matricula,v.Comercial,v.CC,v.NProspecto,v.TipoVenta,c.Telefonouno,c.Telefonodos,'Televenta' FROM tblventa v 
        INNER JOIN tblcliente c on c.IdCliente=v.IdCliente
        WHERE v.TipoVenta='RE' and v.TCTipoVenta='TeleVenta'
        and (v.EstadoVenta='' or v.EstadoVenta='PendienteData' or v.EstadoVenta='PendienteAgenda' or v.EstadoVenta='AgendadaTEC' or v.EstadoVenta='AgendadaDEL' or v.EstadoVenta='NoVendida' or v.EstadoVenta='Cancelada' or v.EstadoVenta='Inviable' or v.EstadoVenta='Ilocalizable' or v.EstadoVenta='VAsignada') 
        and DATEDIFF(curdate(), v.FechaHoraREG) <=105 and
        (c.Telefonouno=? or c.Telefonodos=?)
        UNION
        SELECT v.IdVenta,v.FechaHoraREG,v.Matricula,v.Comercial,v.CC,v.NProspecto,v.TipoVenta,c.Telefonouno,c.Telefonodos,'Venta' FROM tblventa v 
        INNER JOIN tblcliente c on c.IdCliente=v.IdCliente
        WHERE (v.TipoVenta='RP' OR v.TipoVenta='RPPR' OR v.TipoVenta='RPPA')   
        and (v.EstadoVenta='PendienteData' or v.EstadoVenta='PendienteAgenda' or v.EstadoVenta='AgendadaTEC' or v.EstadoVenta='AgendadaDEL' or v.EstadoVenta='NoVendida' or v.EstadoVenta='Cancelada' or v.EstadoVenta='Inviable' or v.EstadoVenta='Ilocalizable' or v.EstadoVenta='VAsignada') 
        and DATEDIFF(curdate(), v.FechaHoraREG) <=105 and
        (c.Telefonouno=? or c.Telefonodos=?)
        UNION
        SELECT p.IdProspectoRP,p.FechaHoraREG,p.Matricula,p.Comercial,p.CC,p.NProspecto,p.TipoVenta,c1.Telefonouno,c1.Telefonodos,'ProspectoRP' FROM tblprospectorp p 
        INNER JOIN tblcliente c1 on c1.IdCliente=p.IdCliente
        WHERE (p.TipoVenta='RP' OR p.TipoVenta='RPPR' OR p.TipoVenta='RPPA') 
        and p.EstadoProspecto='ProspectoRP' 
        and DATEDIFF(curdate(), p.FechaHoraREG) <=105 and
        (c1.Telefonouno=? or c1.Telefonodos=?)) t
        ORDER BY t.FechaHoraREG DESC");
        $stmtDupl->bind_param('ssssssss', $buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero,$buscarnumero);
        $stmtDupl->execute();
        $stmtDupl->store_result();
        $stmtDupl->bind_result($ID,
            $FechaHoraREG_D,
            $Matricula_D,
            $Comercial_D,
            $CC_D,
            $NProspecto_D,
            $TipoVenta_D,
            $Telefonouno_D,
            $Telefonodos_D,
            $OrigenVista_D);
        $num_rows=$stmtDupl->num_rows;
  if($num_rows>0){

    try{
        $stmtMat = $con->prepare( "SELECT u.Matricula,CONCAT(u.Nombres,' ', u.Apellidos) Usuario,u.CC FROM dbUSUARIO.tblusuario u WHERE u.Matricula=?");
        $stmtMat->bind_param('s', $matricula);
        $stmtMat->execute();
        $stmtMat->store_result();
        $stmtMat->bind_result($MatriculaCorreo,$UsuarioCorreo,$CCCorreo);
	    $stmtMat->fetch();
        $stmtMat->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
            
      
      
    $correo_administrativo="lorena.pardo@verisure.pe";
    $correo_administrativo1="josel.rodriguez@securitasdirect.es";
    $correo_administrativo2="backoffice@verisure.pe";
    $correo_administrativo3="diego.delabarra@verisure.pe";
    
    $para = ''.$correo_administrativo1.", ".$correo_administrativo2.", ".$correo_administrativo3.'';

    $titulo = "NOTIFICACION DE DUPLICIDAD";

  $mensaje ='
    <html>
    
    <head>
    
    <style>
     @font-face
    	{font-family:Helvetica;
    	panose-1:2 11 6 4 2 2 2 2 2 4;
    	mso-font-charset:0;
    	mso-generic-font-family:swiss;
    	mso-font-pitch:variable;
    	mso-font-signature:-536859905 -1073711037 9 0 511 0;}
    
          
     p.MsoNormal, li.MsoNormal, div.MsoNormal
    	{mso-style-unhide:no;
    	mso-style-qformat:yes;
            mso-style-parent:"";
    	margin:0cm;
    	margin-bottom:.0001pt;
    	mso-pagination:widow-orphan;
    	font-size:12.0pt;
    	font-family:"Times New Roman","serif";
    	mso-fareast-font-family:Calibri;
    	mso-fareast-theme-font:minor-latin;}
    h3
    	{mso-style-priority:9;
    	mso-style-unhide:no;
    	mso-style-qformat:yes;
    	mso-style-link:"Título 3 Car";
    	mso-margin-top-alt:auto;
    	margin-right:0cm;
    	mso-margin-bottom-alt:auto;
    	margin-left:0cm;
    	mso-pagination:widow-orphan;
    	mso-outline-level:3;
    	font-size:13.5pt;
    	font-family:"Times New Roman","serif";
    	mso-fareast-font-family:Calibri;
    	mso-fareast-theme-font:minor-latin;}
    a:link, span.MsoHyperlink
    	{mso-style-noshow:yes;
    	mso-style-priority:99;
    	color:blue;
    	text-decoration:underline;
    	text-underline:single;}
        a:visited, span.MsoHyperlinkFollowed
    	{mso-style-noshow:yes;
    	mso-style-priority:99;
    	color:purple;
    	text-decoration:underline;
    	text-underline:single;}
    span.Ttulo3Car
    	{mso-style-name:"Título 3 Car";
    	mso-style-noshow:yes;
    	mso-style-priority:9;
    	mso-style-unhide:no;
    	mso-style-locked:yes;
    	mso-style-link:"Título 3";
    	mso-ansi-font-size:12.0pt;
    	mso-bidi-font-size:12.0pt;
    	font-family:"Calibri Light","sans-serif";
    	mso-ascii-font-family:"Calibri Light";
    	mso-ascii-theme-font:major-latin;
    	mso-fareast-font-family:"Helvetica";
    	mso-fareast-theme-font:major-fareast;
    	mso-hansi-font-family:"Calibri Light";
    	mso-hansi-theme-font:major-latin;
    	mso-bidi-font-family:"Times New Roman";
    	mso-bidi-theme-font:major-bidi;
    	color:#1F4D78;
    	mso-themecolor:accent1;
    	mso-themeshade:127;}
    .MsoChpDefault
    	{mso-style-type:export-only;
    	mso-default-props:yes;
    	font-size:10.0pt;
    	mso-ansi-font-size:10.0pt;
    	mso-bidi-font-size:10.0pt;}
    @page WordSection1
    	{size:612.0pt 792.0pt;
    	margin:70.85pt 3.0cm 70.85pt 3.0cm;
    	mso-header-margin:36.0pt;
    	mso-footer-margin:36.0pt;
    	mso-paper-source:0;}
    div.WordSection1
    	{page:WordSection1;}
    
    </style>
    </head>
    
    <body bgcolor="#F2F2F2" lang=ES-PE link=blue vlink=purple style="tab-interval:35.4pt">
    <div class=WordSection1>


    <p class=MsoNormal><o:p>&nbsp;</o:p></p>
    
    <div align=center>
    
    <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width="100%"
     style="width:100.0%;background:#F2F2F2;border-collapse:collapse;mso-yfti-tbllook:
     1184;mso-padding-alt:0cm 0cm 0cm 0cm">
     <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
      <td width="100%" valign=top style="width:100.0%;padding:15.0pt 15.0pt 15.0pt 15.0pt">
      <div align=center>
      <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=600
       style="width:650.0pt;border-collapse:collapse;mso-yfti-tbllook:1184;
       mso-padding-alt:0cm 0cm 0cm 0cm">
       <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes">
        <td valign=top style="padding:0cm 0cm 0cm 0cm">
        <div align=center>
        <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=600
         style="width:650.0pt;background:white;border-collapse:collapse;mso-yfti-tbllook:
         1184;mso-padding-alt:0cm 0cm 0cm 0cm">
         <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
          <td valign=top style="border-top:solid #D8D8D8 4.5pt;border-left:none;
          border-bottom:none;border-right:none;padding:6.75pt 0cm 0cm 0cm">
          <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
           width="100%" style="width:100.0%;border-collapse:collapse;mso-yfti-tbllook:
           1184;mso-padding-alt:0cm 0cm 0cm 0cm">
           <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
            <td valign=top style="padding:6.75pt 6.75pt 6.75pt 6.75pt">
            <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
             align=center width="100%" style="width:100.0%;border-collapse:collapse;
             mso-yfti-tbllook:1184;mso-table-lspace:2.25pt;mso-table-rspace:2.25pt;
             mso-table-anchor-vertical:paragraph;mso-table-anchor-horizontal:column;
             mso-table-left:left;mso-padding-alt:0cm 0cm 0cm 0cm">
             <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:
              yes">
              <td valign=top style="padding:0cm 6.75pt 0cm 6.75pt">
              <p class=MsoNormal><span><img
              width=118 height=73 id="_x0000_i1025"
              src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png"
              alt="Logo Verisure Peru"><o:p></o:p></span></p>
              </td>
             </tr>
            </table>
            </td>
           </tr>
          </table>
          </td>
         </tr>
        </table>
        </div>
        </td>
       </tr>
       <tr style="mso-yfti-irow:1;mso-yfti-lastrow:yes">
        <td valign=top style="padding:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
        -webkit-text-size-adjust: 100%">
        <div align=center>
        <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0 width=600
         style="width:650.0pt;background:white;border-collapse:collapse;mso-yfti-tbllook:
         1184;mso-padding-alt:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
         -webkit-text-size-adjust: 100%;min-width: 100%" id=templateHeader>
         <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
          <td valign=top style="padding:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
          -webkit-text-size-adjust: 100%;min-width: 100%">
          <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
           width="100%" style="width:100.0%;border-collapse:collapse;mso-yfti-tbllook:
           1184;mso-padding-alt:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
           -webkit-text-size-adjust: 100%;min-width: 100%">
           <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
            <td valign=top style="padding:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%">
            <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
             width="100%" style="width:100.0%;background:#F2F2F2;border-collapse:
             collapse;mso-yfti-tbllook:1184;mso-padding-alt:0cm 0cm 0cm 0cm;
             -ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%"
             id=bodyTable>
             <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:
              yes">
              <td valign=top style="padding:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
              -webkit-text-size-adjust: 100%">
              <div align=center>
              <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
               width=600 style="width:650.0pt;background:#DC0000;border-collapse:
               collapse;mso-yfti-tbllook:1184;mso-padding-alt:0cm 0cm 0cm 0cm;
               -ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%"
               id=emailContainer>
               <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:
                yes">
                <td valign=top style="padding:3.0pt 3.0pt 3.0pt 3.0pt;-ms-text-size-adjust: 100%;
                -webkit-text-size-adjust: 100%">
                <h3 align=center style="text-align:center"><span style="font-family:
                Helvetica,sans-serif;
                color:white">NOTIFICACI&Oacute;N VERISMART<o:p></o:p></span></h3>
                </td>
               </tr>
              </table>
              </div>
              </td>
             </tr>
            </table>
            </td>
           </tr>
          </table>
          <p class=MsoNormal><span style="
          display:none;mso-hide:all"><o:p>&nbsp;</o:p></span></p>
          <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
           width="100%" style="width:100.0%;border-collapse:collapse;mso-yfti-tbllook:
           1184;mso-padding-alt:0cm 0cm 0cm 0cm;min-width: 100%;-ms-text-size-adjust: 100%;
           -webkit-text-size-adjust: 100%">
           <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:yes">
            <td valign=top style="padding:6.75pt 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%">
            <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
             align=left width="100%" style="width:100.0%;border-collapse:collapse;
             mso-yfti-tbllook:1184;margin-left:-2.25pt;margin-right:-2.25pt;
             mso-table-anchor-vertical:paragraph;mso-table-anchor-horizontal:column;
             mso-table-left:left;mso-padding-alt:0cm 0cm 0cm 0cm;-ms-text-size-adjust: 100%;
             -webkit-text-size-adjust: 100%">
             <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:
              yes">
              <td width=600 valign=top style="width:650.0pt;padding:0cm 0cm 0cm 0cm;
              -ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
              <table class=MsoNormalTable border=0 cellspacing=0 cellpadding=0
               align=left width="100%" style="width:100.0%;border-collapse:collapse;
               mso-yfti-tbllook:1184;mso-table-lspace:2.25pt;mso-table-rspace:2.25pt;
               mso-table-anchor-vertical:paragraph;mso-table-anchor-horizontal:
               column;mso-table-left:left;mso-padding-alt:0cm 0cm 0cm 0cm;
               -ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
               <tr style="mso-yfti-irow:0;mso-yfti-firstrow:yes;mso-yfti-lastrow:
                yes">
                <td valign=top style="padding:0cm 13.5pt 6.75pt 13.5pt;max-width: 100%;
                min-width: 100%;-ms-text-size-adjust: 100%;-webkit-text-size-adjust: 100%">
                <p class=MsoNormal style="mso-margin-top-alt:auto;mso-margin-bottom-alt:
                auto;line-height:150%">
                 <strong>
                    <span style="font-size:11.0pt;
                line-height:150%;font-family:Helvetica,sans-serif;color:#606060">Estimado(s) Sr(es) </span>
                </strong>
             
                    <br>
                    
              
                     <span style="font-size:9.0pt;
                line-height:150%;font-family:Helvetica,sans-serif;color:#606060">Se detalla la informacion sobre los PROSPECTOS/VISITAS asociadas al n&#250;mero <strong>'.$buscarnumero.'</strong> ingresado por:</span>
               <br>
               <br>
               <table cellspacing="0" border="1" align="center" bordercolor="#ddd" style="width: 45%; text-align: left; font-size: 10pt;">
                                                         <tr>
                                <th style="width: 10%;font-size:9.0pt;line-height:150%;font-family:
                Helvetica,sans-serif;color:#606060; text-align: center;">MATRICULA</th>
                                    <th style="width: 30%;font-size:9.0pt;line-height:150%;font-family:
                Helvetica,sans-serif;color:#606060; text-align: center;">COMERCIAL</th>
                                   <th style="width: 5%;font-size:9.0pt;line-height:150%;font-family:
                Helvetica,sans-serif;color:#606060; text-align: center;">CC</th>
                                </tr>
                                <tr>
                                
                  <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;
                color:#606060">'.$matricula.'</td>
                   <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;
                color:#606060">'.$UsuarioCorreo.'</td>
                  <td  style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;
                color:#606060">'.$CCCorreo.'</td>

                </tr>
                                
                  </table>
               
              <br>
        
                        <strong><span style="font-size:9.0pt;line-height:150%;font-family:
                Helvetica,sans-serif;color:#606060">Total de registros ('.$num_rows.'):</span></strong>
              <br>
             <br>
               
              <table cellspacing="0" border="1" align="center" bordercolor="#ddd" style="width: 95%; text-align: left; font-size: 10pt;">
                                                         <tr>
                               <th style="width: 5%;font-size:9.0pt;line-height:150%;font-family:
                Helvetica,sans-serif;color:#606060; text-align: center;">N&#176; ID</th>
                                    <th style="width: 9.5%;font-size:9.0pt;line-height:150%;font-family:
                Helvetica,sans-serif;color:#606060; text-align: center;">N&#176; PROSPECTO</th>
                                   <th style="width: 14%;font-size:9.0pt;line-height:150%;font-family:
                Helvetica,sans-serif;color:#606060; text-align: center;">FECHA REGISTRO</th>
                                    <th style="width: 9.5%;font-size:9.0pt;line-height:150%;font-family:
                Helvetica,sans-serif;color:#606060; text-align: center;">MATRICULA</th>
                                    <th style="width: 18.5%;font-size:9.0pt;line-height:150%;font-family:
                Helvetica,sans-serif;color:#606060; text-align: center;">COMERCIAL</th>
                
                                                <th style="width: 5%;font-size:9.0pt;line-height:150%;font-family:
                Helvetica,sans-serif;color:#606060; text-align: center;">CC</th>
                                   <th style="width: 5%;font-size:9.0pt;line-height:150%;font-family:
                Helvetica,sans-serif;color:#606060; text-align: center;">TIPO VENTA</th>
                                    <th style="width:9.5%;font-size:9.0pt;line-height:150%;font-family:
                Helvetica,sans-serif;color:#606060; text-align: center;">TELEFONO UNO</th>
                                    <th style="width: 9.5%;font-size:9.0pt;line-height:150%;font-family:
                Helvetica,sans-serif;color:#606060; text-align: center;">TELEFONO DOS</th>
                                                <th style="width:9.5%;font-size:9.0pt;line-height:150%;font-family:
                Helvetica,sans-serif;color:#606060; text-align: center;">ORIGEN VISTA</th>
                            <th style="width:5%;font-size:8.0pt;line-height:150%;font-family:
                Helvetica,sans-serif;color:#606060; text-align: center;"></th>
                                </tr>
                               ';
 
    while($stmtDupl->fetch()){
        $contador++;
            if($contador==1){
                $Nu='<span style="font-family:Helvetica,sans-serif;background-color: #d9534f;display: inline;
                        padding: .2em .6em .3em;
                        font-size: 95%;
                        font-weight: 700;
                        line-height: 1;
                        color: #fff;
                        text-align: center;
                        white-space: nowrap;
                        vertical-align: baseline;
                        border-radius: .25em;">Nuevo</span>';
            }else{
                $Nu='-';
            }
    $mensaje.='
         <tr>
            <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$ID.'</td>
            <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$NProspecto_D.'</td>
            <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$FechaHoraREG_D.'</td>
            <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$Matricula_D.'</td>
            <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$Comercial_D.'</td>
            <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$CC_D.'</td>
            <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$TipoVenta_D.'</td>
            <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$Telefonouno_D.'</td>
            <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$Telefonodos_D.'</td>
            <td style="text-align: center;font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$OrigenVista_D.'</td>
            <td style="text-align: center;font-size:8.0pt;line-height:150%;font-family:Helvetica,sans-serif;color:#606060">'.$Nu.'</td>
         </tr>';
        
    }
    
      $mensaje.='
     </table>
     
     <br> 
     <span
                style="font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;
                color:#606060">
    Por seguridad, Verisure Per&#250; te informa:</span>
              <br>
              
              <div style="text-align: justify">
               <span
                style="font-size:9.0pt;line-height:150%;font-family:Helvetica,sans-serif;
                color:#606060">
    Este correo electr&#243;nico contiene informaci&#243;n legal confidencial y privilegiada. Si Usted no es el destinatario a quien se desea enviar este mensaje, tendr&#225; prohibido darlo a conocer a persona alguna, as&#237; como a reproducirlo o copiarlo. Si recibe este mensaje por error, favor de notificarlo al remitente de inmediato y desecharlo de su sistema..
               </span>
                  </div>
              <br>         
      
                <br>
                <strong>
                <span style="font-size:10.5pt;line-height:150%;font-family:Trebuchet MS,Helvetica,sans-serif;
                color:#ff0033">Verisure Per&uacute; SAC.</span></strong><br>
                <span style="font-size:8.5pt;line-height:150%;font-family:Trebuchet MS,Helvetica,sans-serif;
                      color:#606060">Av. Primavera 1050,Of.401 Santiago de Surco<br>
                15037,Lima, Per&uacute;</span></p>
                </td>
               </tr>
              </table>
              </td>
             </tr>
            </table>
            </td>
           </tr>
          </table>
          </td>
         </tr>
        </table>
        </div>
        </td>
       </tr>
      </table>
      </div>
      </td>
     </tr>
    </table>
    
    </div>
    
    <p class=MsoNormal><span ><o:p>&nbsp;</o:p></span></p>
    
    </div>
    
    </body>
    
    </html>';

    //para el envío en formato HTML 
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=utf-8\r\n";
    
    //dirección del remitente 
        $headers .= "From: VERISMART - Verisure Perú <notificacion.verismart@verismart.com.pe>\r\n";
    
    //dirección de respuesta, si queremos que sea distinta que la del remitente 
        $headers .= "Reply-To: notificacion.verismart@verisure.pe\r\n";
    
    //ruta del mensaje desde origen a destino 
        $headers .= "Return-path: notificacion.verismart@verismart.com.pe\r\n";
    
    //direcciones que recibián copia 
        $headers .= "Cc: notificacion.verismart@verisure.pe\r\n";
    
    //direcciones que recibirán copia oculta 
    //$headers .= "Bcc: joecnan14@gmail.com\r\n";  
    
    
    mail($para, $titulo, $mensaje, $headers);
    
  }
	    
        $stmtDupl->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }


//CORREO CONFIRMACION DE VISITA RE

if ($idVen == ""){
} else {
    $sqltimename = "SET lc_time_names = 'es_ES'";
    $set_time_names=$con->query($sqltimename);

    $sqlCorreoConfirmacion = "SELECT 
                            v.Matricula MatriculaComercial, 
                            v.Comercial, 
                            v.CC Delegacion, 
                            u.Manager MatriculaJefeVenta, 
                            u.Correo CorreoComercial, 
                            u.IdPerfil PerfilComercial,
                            u.Categoria CategoriaComercial,
                            CONCAT(m.Nombres,' ',m.Apellidos) NombJefeVenta, 
                            m.Correo CorreoJefeVenta, 
                            CONCAT(del.Nombres,' ',del.Apellidos) NombDelegado, 
                            del.Correo CorreoDelegado, 
                            v.EstadoVisita, 
                            v.EstadoVenta, 
                            v.TipoVenta, 
                            v.Segmento, 
                            v.NProspecto, 
                            v.N590, 
                            v.FechaVisita, 
                            v.HoraVisita, 
                            v.FObras,
                            v.FVisitaObras,
                            DATE_FORMAT(v.FVisitaObras, '%W %d/%m' ) FechaVisitaObrasDia,
                            DATE_FORMAT(FechaVisita, '%W %d/%m') FechaVisitaDia, 
                            v.FVencimientoVisita, 
                            v.OrigenVisita, 
                            v.ComentarioVisita, 
                            v.GestorOrigen,
                            v.MesVisita, 
                            v.LeadID,
                            v.GestorMKT,
                            CONCAT(mkt.Nombres,' ',mkt.Apellidos) NombGestorMKT,
                            mkt.Correo CorreoOperador,
                            c.IdCliente, 
                            c.NombApellido NombCliente, 
                            c.Telefonouno T1Cliente, 
                            c.Telefonodos T2Cliente, 
                            c.Correo CorreoCliente, 
                            c.Direccion DirCliente,
                            c.Referencia RefCliente,
                            g.Distrito DistCliente, 
                            g.Provincia ProvCliente,
                            c.Interior IntCliente
                            FROM tblventa v
                            INNER JOIN dbUSUARIO.tblusuario u ON v.IdUsuario = u.IdUsuario
                            INNER JOIN dbUSUARIO.tblusuario m ON u.Manager = m.Matricula
                            INNER JOIN dbUSUARIO.tblusuario del ON m.Manager = del.Matricula
                            INNER JOIN dbUSUARIO.tblusuario mkt ON v.GestorMKT = mkt.Matricula
                            INNER JOIN dbUSUARIO.tblusuario ori ON v.GestorOrigen = ori.Matricula
                            INNER JOIN tblcliente c ON v.IdCliente = c.IdCliente
                            INNER JOIN tblgeografico g ON c.IdGeografico = g.IdGeografico
                            WHERE v.IdVenta = '".$idVen."'";
    
    $resultadoCorreoConfirmacion = $con->query($sqlCorreoConfirmacion);

    while($CorreoConfirmacion = $resultadoCorreoConfirmacion->fetch_assoc()){
        $NProspecto = $CorreoConfirmacion['NProspecto'];
        $MatriculaComercialCorreo = $CorreoConfirmacion['MatriculaComercial'];
        $ComercialCorreo = $CorreoConfirmacion['Comercial'];
        $DelegacionCorreo = $CorreoConfirmacion['Delegacion'];
        $MatriculaJefeVentaCorreo = $CorreoConfirmacion['MatriculaJefeVenta'];
        $CorreoComercialCorreo = $CorreoConfirmacion['CorreoComercial'];
        $NombJefeVentaCorreo = $CorreoConfirmacion['NombJefeVenta'];
        $CorreoJefeVentaCorreo = $CorreoConfirmacion['CorreoJefeVenta'];
        $NombDelegadoCorreo = $CorreoConfirmacion['NombDelegado'];
        $CorreoDelegadoCorreo = $CorreoConfirmacion['CorreoDelegado'];
        $EstadoVisitaCorreo = $CorreoConfirmacion['EstadoVisita'];
        $EstadoVentaCorreo =  $CorreoConfirmacion['EstadoVenta'];
        $TipoVentaCorreo = $CorreoConfirmacion['TipoVenta'];
        $SegmentoCorreo = $CorreoConfirmacion['Segmento'];
        $NProspectoCorreo = $CorreoConfirmacion['NProspecto'];
        $N590Correo = $CorreoConfirmacion['N590'];
        $FechaVisitaCorreo = $CorreoConfirmacion['FechaVisita'];
        $HoraVisitaCorreo = $CorreoConfirmacion['HoraVisita'];
        $fobras = $CorreoConfirmacion['FObras'];
        $FVisitaObrasCorreo = $CorreoConfirmacion['FVisitaObras']; //FECHAVISITAOBRA - FORMAR NORMAL
        $FechaVisitaObrasDiaCorreo = $CorreoConfirmacion['FechaVisitaObrasDia']; //FECHAVISITAOBRADIA - FORMATO CON DIA
        $FechaVisitaObrasDiaCorreo = utf8_encode($FechaVisitaObrasDiaCorreo); //CAMBIO A UTF8
        $FechaVisitaDiaCorreo = $CorreoConfirmacion['FechaVisitaDia'];
        $FechaVisitaDiaCorreo = utf8_encode($FechaVisitaDiaCorreo); //CAMBIO A UTF8
        $FVencimientoVisitaCorreo = $CorreoConfirmacion['FVencimientoVisita'];
        $OrigenVisitaCorreo = $CorreoConfirmacion['OrigenVisita'];
        $ComentarioVisitaCorreo = $CorreoConfirmacion['ComentarioVisita'];
        $CorreoOperadorCorreo = $CorreoConfirmacion['CorreoOperador'];
        $GestorMKTCorreo = $CorreoConfirmacion['GestorMKT'];
        $NombGestorMKTCorreo = $CorreoConfirmacion['NombGestorMKT'];
        $MesVisitaCorreo = $CorreoConfirmacion['MesVisita'];
        $LeadIDCorreo = $CorreoConfirmacion['LeadID'];
        $IdClienteCorreo = $CorreoConfirmacion['IdCliente'];
        $NombClienteCorreo = $CorreoConfirmacion['NombCliente'];
        $T1ClienteCorreo = $CorreoConfirmacion['T1Cliente'];
        $T2ClienteCorreo = $CorreoConfirmacion['T2Cliente'];
        $CorreoClienteCorreo = $CorreoConfirmacion['CorreoCliente'];
        $DirClienteCorreo = $CorreoConfirmacion['DirCliente'];
        $DistClienteCorreo = $CorreoConfirmacion['DistCliente'];
        $ProvClienteCorreo = $CorreoConfirmacion['ProvCliente'];
        $RefClienteCorreo = $CorreoConfirmacion['RefCliente'];
        $IntClienteCorreo = $CorreoConfirmacion['IntCliente'];
        
        $PerfilComercialCorreo = $CorreoConfirmacion['PerfilComercial'];
        $CategoriaComercialCorreo = $CorreoConfirmacion['CategoriaComercial']; 
    }

    if($fobras=="SI"){
        $hfobras='<span style="color:red">SI</span>';
        $DescripFechaVisita = $FechaVisitaObrasDiaCorreo.' a las '.$HoraVisitaCorreo.' (Visita se considera con fecha en obras para el '.$FechaVisitaCorreo.')';
    }else{
        $hfobras='NO';
        $DescripFechaVisita= $FechaVisitaDiaCorreo.' a las '.$HoraVisitaCorreo.'';
    }

    
    $correo_prueba="enzoianfranco.mere@verisure.pe,joseenrique.nanquen@verisure.pe";
    
    //ESTRUCTURA DEL CORREO ACTUALIZADO
    //DELEGADO
    
    if($PerfilComercialCorreo == 17){
        
        if($CategoriaComercialCorreo == 'N1' || $CategoriaComercialCorreo == 'N2' || $CategoriaComercialCorreo == 'N3' || $CategoriaComercialCorreo == 'JE' 
        || $CategoriaComercialCorreo == 'VET' || $CategoriaComercialCorreo == 'COACH' || $CategoriaComercialCorreo == 'MST'){
            $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
            $correoAdministrativo2=$CorreoJefeVentaCorreo; //JEFE
            $correoAdministrativo3=$CorreoDelegadoCorreo; //DELEGADO
        } else if ($CategoriaComercialCorreo == 'DEL'){
            $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
            $correoAdministrativo2=$CorreoJefeVentaCorreo; //JEFE
            $correoAdministrativo3=''; //DELEGADO
        } else if ($CategoriaComercialCorreo == 'GERENTE TERRITORIAL') {
            $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
            $correoAdministrativo2=''; //JEFE
            $correoAdministrativo3=''; //DELEGADO
        } else {
            $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
            $correoAdministrativo2=''; //JEFE
            $correoAdministrativo3=''; //DELEGADO
        }
    } else if ($PerfilComercialCorreo == 38){
        $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
    } else {
        $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
    }
    
    //COPIA CORREO A LOS TERRITORIALES
    
        if($DelegacionCorreo == 150 || $DelegacionCorreo == 100 ||  $DelegacionCorreo == 152||$DelegacionCorreo == 157 || $DelegacionCorreo == 159  || $DelegacionCorreo == 251 || $DelegacionCorreo == 252){
            $correoAdministrativo4="renzobranchi.branez@verisure.pe";
        } else if ($DelegacionCorreo == 151 || $DelegacionCorreo == 200  || $DelegacionCorreo == 154 || $DelegacionCorreo == 156 || $DelegacionCorreo == 120 || $DelegacionCorreo == 121 || $DelegacionCorreo == 140 || $DelegacionCorreo == 141 || $DelegacionCorreo == 20){
            $correoAdministrativo4="joseenrique.nanquen@verisure.pe";
        } else if ($DelegacionCorreo == 40 || $DelegacionCorreo == 41 || $DelegacionCorreo == 153 || $DelegacionCorreo == 155  || $DelegacionCorreo == 158 || $DelegacionCorreo == 250 || $DelegacionCorreo == 80){
            $correoAdministrativo4="monicamaria.sanchez@verisure.pe";
        }
    
    $copia1 = "CHRISTIAN.GUTIERREZ@VERISURE.PE";
    $copia2 = "SHIRLEY.CUADRA@VERISURE.PE";
    $copia3 = "MADELEYNE.MUNAYCO@VERISURE.PE";
    $copia4 = "diego.delabarra@verisure.pe";
    
    $paraCorreoVisita = '' . $correoAdministrativo1 . ',' .$correoAdministrativo2. ',' .$correoAdministrativo3. ',' .$correoAdministrativo4.' ';
    
    if ($TipoVentaCorreo === 'RE'){
        $tituloCorreoVisita = "OPORTUNIDAD DE VENTA VISITA RE - ".$NProspectoCorreo." ";
        
        $mensajeCorreoVisita ='
    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml">
     
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      <title>A Simple Responsive HTML Email</title>
      <style type="text/css">
      body {margin: 0; padding: 0; min-width: 100%!important;}
      img {height: auto;}
      .content {width: 100%; max-width: 600px;}
      .header {padding: 5px 20px 5px 20px;}
      .innerpadding {padding: 20px 30px 15px 30px;}
      .borderbottom {border-bottom: 1px solid #f2eeed;}
      .subhead {font-size: 15px; color: #ffffff; font-family: sans-serif; letter-spacing: 10px;}
      .h1 {font-family: sans-serif;color: #ffffff;font-size:23px; line-height: 38px; font-weight: bold;}
      .h2 {color: #000000; font-family: sans-serif;padding: 0 0 15px 0; font-size: 24px; line-height: 28px; font-weight: bold;}
      .h3 {color: #000000; font-family: sans-serif;font-size: 14px; line-height: 22px; font-weight: bold;}
      .h4 {color: #000000;font-family: sans-serif;font-size: 16px; line-height: 30px; font-weight: bold;}
      .bodycopy {color: #000000; font-family: sans-serif;font-size: 14px; line-height: 22px;}
      .button {text-align: center; font-size: 18px; font-family: sans-serif; font-weight: bold; padding: 0 30px 0 30px;}
      .button a {color: #ffffff; text-decoration: none;}
      .footer {padding: 20px 30px 15px 30px;}
      .footercopy {font-family: sans-serif; font-size: 14px; color: #ffffff;}
      .footercopy a {color: #ffffff; text-decoration: underline;}
      .coldiv115{width: 115px;};
      .coldiv380{width: 380px;};
    
      @media only screen and (max-width: 550px), screen and (max-device-width: 550px) {
      body[yahoo] .hide {display: none!important;}
      body[yahoo] .buttonwrapper {background-color: transparent!important;}
      body[yahoo] .button {padding: 0px!important;}
      body[yahoo] .button a {background-color: #e05443; padding: 15px 15px 13px!important;}
      body[yahoo] .unsubscribe {display: block; margin-top: 20px; padding: 10px 50px; background: #2f3942; border-radius: 5px; text-decoration: none!important; font-weight: bold;}
      }
    
      </style>
    </head>
    
    <body yahoo bgcolor="#f2f2f2">
    <table width="100%" bgcolor="#f2f2f2" border="0" cellpadding="0" cellspacing="0">
    <tr>
      <td>
        <!--[if (gte mso 9)|(IE)]>
          <table width="600" align="center" cellpadding="0" cellspacing="0" border="0">
            <tr>
              <td>
        <![endif]-->     
        <table bgcolor="#ffffff" class="content" align="center" cellpadding="0" cellspacing="0" border="0">
          <tr>
            <td bgcolor="#ffffff" class="header">
              <table width="70" align="center" border="0" cellpadding="0" cellspacing="0">  
                <tr>
                  <td height="70" style="padding: 0 20px 20px 0;">
                    <img class="fix"  src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png" border="0" alt="" />
                  </td>
                </tr>
              </table>
            </td>
          </tr>
          
          
          <tr>
            <td bgcolor="#3a65ff" class="header">
              
              <!--[if (gte mso 9)|(IE)]>
                <table width="425" align="center" cellpadding="0" cellspacing="0" border="0">
                  <tr>
                    <td>
              <![endif]-->
              <table class="col425" align="center" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 425px;">  
                <tr>
                  <td height="70">
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                      <tr>
                        <td class="h1" align="center" style="padding: 0 0 0 0;">
                          OPORTUNIDAD DE VENTA RE- '.$NProspectoCorreo.'
                        </td>
                      </tr>
                    </table>
                  </td>
                </tr>
              </table>
              <!--[if (gte mso 9)|(IE)]>
                    </td>
                  </tr>
              </table>
              <![endif]-->
            </td>
          </tr>
          
          <tr>
            <td class="innerpadding borderbottom">
              <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td class="h2">
                    Estimado(s) Sr(es) '.strtoupper($ComercialCorreo).'
                  </td>
                </tr>
                <tr>
                    <td class="bodycopy">
                        <h4 style="font-weight: normal">Envío los datos de una RE para el <span style="font-weight: bold;">'.$DescripFechaVisita.'</span></h4>
                        <h4 style="font-weight: normal">Enviar la ubicación al WHATSAPP CEL. <span style="font-weight: bold;">942474698</span> indicando:</h4>
                        <ul>
                            <ol>
                                <li>Ubicación de la visita.</li>
                                <li>El número de prospecto dentro del día que se agendó la visita.</li>
                                <li>Informar el estado final de la visita (Vendida o No Vendido).</li>
                            </ol>
                        </ul>
                    </td>
                </tr>
              </table>
            </td>
          </tr>
          
           <tr>
            <td class="innerpadding borderbottom">
              <table  width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td class="h4" bgcolor="#dddddd" align="center" style="padding: 0 0px 0px 0;">
                    INFORMACIÓN DE LA VISITA
                  </td>
                </tr>
              </table>
                
              <table align="left" border="0" cellpadding="0" cellspacing="0">
                <tr>
                  <td class="h3" width="145" style="padding: 5px 0px 0px 0;">
                    CLIENTE:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. strtoupper($NombClienteCorreo).'
                  </td>
                </tr>
                <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    DIRECCIÓN:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. strtoupper($DirClienteCorreo).'
                  </td>
                </tr>
                <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    INTERIOR:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. strtoupper($IntClienteCorreo).'
                  </td>
                </tr>
                <tr>
                    <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                        REFERENCIA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. strtoupper($RefClienteCorreo).'
                  </td>
                </tr>
                 <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    DISTRITO:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '. strtoupper($DistClienteCorreo).'
                  </td>
                </tr>
                 <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    PROVINCIA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '. strtoupper($ProvClienteCorreo).'
                  </td>
                </tr>
                <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    TELEFONO UNO:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. $T1ClienteCorreo.'
                  </td>
                </tr>
                 <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    TELEFONO DOS:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '. $T2ClienteCorreo.'
                  </td>
                </tr>
                <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    CORREO:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '. strtoupper($CorreoClienteCorreo).'
                  </td>
                </tr>
                <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    FECHA VISITA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. $FechaVisitaCorreo.'
                  </td>
                </tr>
                <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    HORA VISITA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. $HoraVisitaCorreo.'
                  </td>
                </tr>
                <tr>
                    <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    FECHA OBRAS:
                    </td>
                    <td class="bodycopy" width="350" style="padding: 0 0px 0px 0; font-weight: bold;">
                    '.$hfobras.' 
                    </td>
                </tr>
                 <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    COMENTARIO VISITA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '. strtoupper($ComentarioVisitaCorreo).'
                  </td>
                </tr>
                
              </table>
             
            </td>
          </tr>
    
          <tr>
            <td class="innerpadding borderbottom">
              <table bgcolor="#dddddd" width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td class="h4" align="center"  style="padding: 0 0px 0px 0;">
                    INFORMACIÓN DEL PROSPECTO
                  </td>
                </tr>
              </table>
                
              <table align="left" border="0" cellpadding="0" cellspacing="0">  
                <tr>
                  <td class="h3" width="145" style="padding: 5px 0px 0px 0;">
                    MATRICULA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 5px 0px 0px 0;">
                    '. $MatriculaComercialCorreo.'
                  </td>
                </tr>
                 <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    COMERCIAL:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '.strtoupper($ComercialCorreo).'
                  </td>
                </tr>
                
                <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    DELEGACIÓN:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '. $DelegacionCorreo.'
                  </td>
                </tr>
                 <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    JEFE VENTA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '. strtoupper($MatriculaJefeVentaCorreo).'
                  </td>
                </tr>
                <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    ESTADO VISITA:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                    '.strtoupper($EstadoVisitaCorreo).'
                  </td>
                </tr>
                 <tr>
                  <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    RECURSO:
                  </td>
                  <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     RE
                  </td>
                </tr>
                <tr>
                    <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                    GESTOR RE:
                    </td>
                    <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                     '.$GestorMKTCorreo.' - '.$NombGestorMKTCorreo.'
                  </td>
                </tr>
    
              </table>
             
            </td>
          </tr>
          
          <tr>
            <td class="footer" bgcolor="#44525f">
              <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                  <td align="center" class="footercopy">
                     2018 &reg; Verisure Perú SAC<br/>
                     Av. Primavera 1050 – Oficina 401<br/> 
                     Santiago de Surco – Urbanización Chacarilla del Estanque<br/>
                     Lima – Perú
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        </table>
        <!--[if (gte mso 9)|(IE)]>
              </td>
            </tr>
        </table>
        <![endif]-->
        </td>
      </tr>
    </table>
    
    
    </body>
    </html>
    ';
    }
    else if ($TipoVentaCorreo === 'RPMKT'){
        $tituloCorreoVisita = "OPORTUNIDAD DE VENTA VISITA RPMKT - ".$NProspectoCorreo." ";
        
        $mensajeCorreoVisita ='
            <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
            <html xmlns="http://www.w3.org/1999/xhtml">
             
            <head>
              <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
              <title>A Simple Responsive HTML Email</title>
              <style type="text/css">
              body {margin: 0; padding: 0; min-width: 100%!important;}
              img {height: auto;}
              .content {width: 100%; max-width: 600px;}
              .header {padding: 5px 20px 5px 20px;}
              .innerpadding {padding: 20px 30px 15px 30px;}
              .borderbottom {border-bottom: 1px solid #f2eeed;}
              .subhead {font-size: 15px; color: #ffffff; font-family: sans-serif; letter-spacing: 10px;}
              .h1 {font-family: sans-serif;color: #ffffff;font-size:23px; line-height: 38px; font-weight: bold;}
              .h2 {color: #000000; font-family: sans-serif;padding: 0 0 15px 0; font-size: 24px; line-height: 28px; font-weight: bold;}
              .h3 {color: #000000; font-family: sans-serif;font-size: 14px; line-height: 22px; font-weight: bold;}
              .h4 {color: #000000;font-family: sans-serif;font-size: 16px; line-height: 30px; font-weight: bold;}
              .bodycopy {color: #000000; font-family: sans-serif;font-size: 14px; line-height: 22px;}
              .button {text-align: center; font-size: 18px; font-family: sans-serif; font-weight: bold; padding: 0 30px 0 30px;}
              .button a {color: #ffffff; text-decoration: none;}
              .footer {padding: 20px 30px 15px 30px;}
              .footercopy {font-family: sans-serif; font-size: 14px; color: #ffffff;}
              .footercopy a {color: #ffffff; text-decoration: underline;}
              .coldiv115{width: 115px;};
              .coldiv380{width: 380px;};
            
              @media only screen and (max-width: 550px), screen and (max-device-width: 550px) {
              body[yahoo] .hide {display: none!important;}
              body[yahoo] .buttonwrapper {background-color: transparent!important;}
              body[yahoo] .button {padding: 0px!important;}
              body[yahoo] .button a {background-color: #e05443; padding: 15px 15px 13px!important;}
              body[yahoo] .unsubscribe {display: block; margin-top: 20px; padding: 10px 50px; background: #2f3942; border-radius: 5px; text-decoration: none!important; font-weight: bold;}
              }
            
            
              </style>
            </head>
            
            <body yahoo bgcolor="#f2f2f2">
            <table width="100%" bgcolor="#f2f2f2" border="0" cellpadding="0" cellspacing="0">
            <tr>
              <td>
                <!--[if (gte mso 9)|(IE)]>
                  <table width="600" align="center" cellpadding="0" cellspacing="0" border="0">
                    <tr>
                      <td>
                <![endif]-->     
                <table bgcolor="#ffffff" class="content" align="center" cellpadding="0" cellspacing="0" border="0">
                  <tr>
                    <td bgcolor="#ffffff" class="header">
                      <table width="70" align="center" border="0" cellpadding="0" cellspacing="0">  
                        <tr>
                          <td height="70" style="padding: 0 20px 20px 0;">
                            <img class="fix"  src="https://www.verismart.com.pe/verismart/admin/dist/img/logo_nuevo_rojo.png" border="0" alt="" />
                          </td>
                        </tr>
                      </table>
                    </td>
                  </tr>
                  
                  
                  <tr>
                    <td bgcolor="#dc0000" class="header">
                      
                      <!--[if (gte mso 9)|(IE)]>
                        <table width="425" align="center" cellpadding="0" cellspacing="0" border="0">
                          <tr>
                            <td>
                      <![endif]-->
                      <table class="col425" align="center" border="0" cellpadding="0" cellspacing="0" style="width: 100%; max-width: 425px;">  
                        <tr>
                          <td height="70">
                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                              <tr>
                                <td class="h1" align="center" style="padding: 0 0 0 0;">
                                  OPORTUNIDAD DE VENTA RPMKT- '.$NProspectoCorreo.'
                                </td>
                              </tr>
                            </table>
                          </td>
                        </tr>
                      </table>
                      <!--[if (gte mso 9)|(IE)]>
                            </td>
                          </tr>
                      </table>
                      <![endif]-->
                    </td>
                  </tr>
                  
                  <tr>
                    <td class="innerpadding borderbottom">
                      <table width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                          <td class="h2">
                            Estimado(s) Sr(es) '.strtoupper($ComercialCorreo).'
                          </td>
                        </tr>
                        <tr>
                            <td class="bodycopy">
                                <h4 style="font-weight: normal">Envío los datos de una RPTMK para el <span style="font-weight: bold;">'.$FechaVisitaCorreo.' a las '.$HoraVisitaCorreo.'</span></h4>
                                <h4 style="font-weight: normal">Enviar la ubicación al WHATSAPP CEL. <span style="font-weight: bold;">942488070</span> indicando:</h4>
                                <ul>
                                    <ol>
                                        <li>El número de prospecto dentro del día que se agendó la visita.</li>
                                        <li>Informar el estado final de la visita (Vendida o No Vendido).</li>
                                    </ol>
                                </ul>
                            </td>
                        </tr>
                      </table>
                    </td>
                  </tr>
                  
                   <tr>
                    <td class="innerpadding borderbottom">
                      <table  width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                          <td class="h4" bgcolor="#dddddd" align="center" style="padding: 0 0px 0px 0;">
                            INFORMACIÓN DE LA VISITA
                          </td>
                        </tr>
                      </table>
                        
                      <table align="left" border="0" cellpadding="0" cellspacing="0">
                        <tr>
                          <td class="h3" width="145" style="padding: 5px 0px 0px 0;">
                            CLIENTE:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. strtoupper($NombClienteCorreo).'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            DIRECCIÓN:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. strtoupper($DirClienteCorreo).'
                          </td>
                        </tr>
                        <tr>
                            <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                                REFERENCIA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. strtoupper($RefClienteCorreo).'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            DISTRITO:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($DistClienteCorreo).'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            PROVINCIA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($ProvClienteCorreo).'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            TELEFONO UNO:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. $T1ClienteCorreo.'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            TELEFONO DOS:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. $T2ClienteCorreo.'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            CORREO:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($CorreoClienteCorreo).'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            FECHA VISITA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. $FechaVisitaCorreo.'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            HORA VISITA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. $HoraVisitaCorreo.'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            COMENTARIO VISITA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($ComentarioVisitaCorreo).'
                          </td>
                        </tr>
                        
                      </table>
                     
                    </td>
                  </tr>
            
                  <tr>
                    <td class="innerpadding borderbottom">
                      <table bgcolor="#dddddd" width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                          <td class="h4" align="center"  style="padding: 0 0px 0px 0;">
                            INFORMACIÓN DEL PROSPECTO
                          </td>
                        </tr>
                      </table>
                        
                      <table align="left" border="0" cellpadding="0" cellspacing="0">  
                        <tr>
                          <td class="h3" width="145" style="padding: 5px 0px 0px 0;">
                            MATRICULA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 5px 0px 0px 0;">
                            '. $MatriculaComercialCorreo.'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            COMERCIAL:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. strtoupper($ComercialCorreo).'
                          </td>
                        </tr>
                        
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            DELEGACIÓN:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '. $DelegacionCorreo.'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            JEFE VENTA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             '. $NombJefeVentaCorreo.'
                          </td>
                        </tr>
                        <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            ESTADO VISITA:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                            '.$EstadoVisitaCorreo.'
                          </td>
                        </tr>
                         <tr>
                          <td class="h3" width="145" style="padding: 0 0px 0px 0;">
                            RECURSO:
                          </td>
                          <td class="bodycopy" width="350" style="padding: 0 0px 0px 0;">
                             RPMKT
                          </td>
                        </tr>
                      </table>
                     
                    </td>
                  </tr>
                  <tr>
                    <td class="footer" bgcolor="#44525f">
                      <table width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                          <td align="center" class="footercopy">
                             2019 &reg; Verisure Perú SAC<br/>
                             Av. Primavera 1050 – Oficina 401<br/> 
                             Santiago de Surco – Urbanización Chacarilla del Estanque<br/>
                             Lima – Perú
                          </td>
                        </tr>
                      </table>
                    </td>
                  </tr>
                </table>
                <!--[if (gte mso 9)|(IE)]>
                      </td>
                    </tr>
                </table>
                <![endif]-->
                </td>
              </tr>
            </table>
            
            
            </body>
            </html>
            ';
    }

    //para el envío en formato HTML 
    $headersCorreoVisita = "MIME-Version: 1.0\r\n";
    $headersCorreoVisita .= "Content-type: text/html; charset=utf-8\r\n";
    
    //dirección del remitente 
        $headersCorreoVisita .= "From: Sistema de Ventas Verismart - Verisure Perú <backoffice@verismart.com.pe>\r\n";
    
    //dirección de respuesta, si queremos que sea distinta que la del remitente 
        $headersCorreoVisita .= "Reply-To: backoffice@verisure.pe\r\n";
    
    //ruta del mensaje desde origen a destino 
        $headersCorreoVisita .= "Return-path: backoffice@verismart.com.pe\r\n";
    
    //direcciones que recibián copia
       $headersCorreoVisita .= "Cc: ".$copia1.",".$copia2.",".$copia3.",".$copia4."\r\n";
    
    //direcciones que recibirán copia oculta 
      $headersCorreoVisita .= "Bcc: ".$correo_prueba."\r\n"; 


    //mail($paraCorreoVisita, $tituloCorreoVisita, $mensajeCorreoVisita, $headersCorreoVisita);

    //INTEGRACION CON MASTERBASE PARA CORREO DE ASIGNACION

    $ObjCorreoAsignacion=EnvioCorreoAsignacion($idVen,$nprospecto,$tipoventa);
    insertarLogCorreo($idVen);
} //END IF

    //CORREO DIFERENTE DELEGACION CC Y ZONIFACION
    if($dc != '100' && $dc != '140'){
        if($tipoventa == 'RE'){
            if($lbldcobjzonificacion != $dc && !($lbldcobjzonificacion == '' || $lbldcobjzonificacion == null)){
                enviarCorreoDifDelegacion();
            }
        }
    }

    //INSERTAR HISTORIAL DE REASIGNACION SECURITY CHECK
   
    if ($idVen == ""){
        
    }else{
        if(isset($matricula)){
            $categoriamatricula=consultarCategoriaMatricula($matricula);
            if($categoriamatricula!="DEL" && ($dc==150 || $dc==156 || $dc==200 || $dc==157)){
                $AsignacionPlantilla="Apertura";
                $ObjCorreoM=EnvioCorreoSecurityCheck($matricula,$correo);
                //$ObjCorreoM=NULL;
            }else{
                $ObjCorreoM=NULL;   
                $AsignacionPlantilla=NULL;
            }
            
            insertarReasignacion($idVen);
        }

    }
    
    function insertarCliente(){
        
        global $con;
        
        global $distrito;
        global $nombcliente;
        global $telefonouno;
        global $telefonodos;
        global $correo;
        global $direccion;
        global $segmento;
        global $IdDocVisita;
        global $objGeofinder;
        global $referencia;
        global $nif;
        global $interior;
        global $idZonificacion;
        global $objZonificacionVerisure;
        global $lbldireccionAprox;
        global $lbltipoDireccion;
        global $lblIdDireccion;
        
        $telefonodos = stringtonull($telefonodos);
        
        try {
            
            $stmt = $con->prepare("INSERT INTO dbVENTAS.tblcliente(IdGeografico, NombApellido, Telefonouno, Telefonodos, Correo, Direccion,Segmento,IdDocVisita, objGeofinder, Referencia, NIF, Interior, IdZonificacion, objZonificacion, DireccionAprox, TipoDireccion, IdDireccion) VALUES(?, ?, ?, ?, ?, ?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ");
            $stmt->bind_param('issssssissssisssi',  $distrito, $nombcliente, $telefonouno, $telefonodos, $correo, $direccion,$segmento,$IdDocVisita, $objGeofinder, $referencia, $nif, $interior, $idZonificacion, $objZonificacionVerisure, $lbldireccionAprox, $lbltipoDireccion, $lblIdDireccion);
            $stmt->execute();
            
            $respuesta = $con->insert_id;
    
            $stmt->close();
            
        } catch (\Exception $e) {
            $respuesta = 'error';
        }
        
        return $respuesta;
    }

    function stringtonull($val){
        
        if ($val == '' || empty($val)){
            $resultado = NULL;
        }
        else if(!isset($val)){
            $resultado = NULL;
        }
        else {
            $resultado = $val;
        }
        
        return $resultado;
    }

    function insertarDocumento(){
        global $con;
    
        global $tipodoc, $documento, $fecharegistroventa;
            try {
        
              $stmt = $con->prepare("INSERT INTO dbVENTAS.tbldocumento(TipoDocumento, Documento, FechaHoraREG) VALUES(?, ?, ?)");
              $stmt->bind_param('sss', $tipodoc,$documento,$fecharegistroventa);
                $stmt->execute();
                $respuesta = $con->insert_id;
                $stmt->close();
            } catch (\Exception $e) {
                $respuesta = array(
                    'respuesta' => 'error'
                );
            }
        
            return $respuesta;
    
    }

    function actualizarCalidadGeo($CalidadGeo){
        global $con;
        global $lblIdDireccion;
        
        try {
            $stmt = $con->prepare("UPDATE tbltmpdirecciones SET CalidadGeo=? WHERE IdDireccion=?");
            $stmt->bind_param('si', $CalidadGeo, $lblIdDireccion);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
        
        //return $respuesta;
    }

    //Funcion de Security Check
    function consultarCategoriaMatricula($matricula){
        global $con;
        
        $sql = "SELECT Categoria FROM dbUSUARIO.tblusuario WHERE Matricula= '".$matricula."'";
        $resultado = $con->query($sql);
        
        while($data = $resultado->fetch_assoc()){
            $categoriamatricula = $data['Categoria'];
        }
        
        return $categoriamatricula;
        
    }
    
    //PRIMERA ASIGNACION DE LA VISITA
    function insertarReasignacion($idventa){
        global $con;
    
        global $matricula, $categoriamatricula,$fecharegistroventa, $dc,$ObjCorreoM,$AsignacionPlantilla;
        $estadoasignacion='Apertura'; 
        
        try {
    
          $stmt = $con->prepare("INSERT INTO dbVENTAS.tblreasignacion(IdVenta,Matricula, Categoria, FechaAsignacion,CC,EstadoAsignacion,ObjCorreoM,AsignacionPlantilla) VALUES(?,?, ?, ?,?,?,?,?)");
          $stmt->bind_param('isssisss', $idventa,$matricula,$categoriamatricula,$fecharegistroventa,$dc,$estadoasignacion,$ObjCorreoM,$AsignacionPlantilla);
            $stmt->execute();
            $respuesta = $con->insert_id;
            $stmt->close();
        } catch (\Exception $e) {
            $respuesta = array(
                'respuesta' => 'error'
            );
        }
    
        return $respuesta;
    
    }

    function EnvioCorreoSecurityCheck($matriculaespecialista,$correocliente){
        $opts = array(
        'http'=>array(
        'method'=>"GET",
        'header'=>"User-Agent: api script\r\n"
        ));
        
        $context = stream_context_create($opts);
        
                
        $curl = curl_init();
        
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => 'Verisure Visitas',
            'From' => 'visitas@verisure.pe',
            'To' => 
            array (
              'Email' => 
              array (
                0 => $correocliente,
              )
            ),
            'Cc' => 
            array (
              'Email' => 
              array (
                0 => '',
              )
            ),
            'Bcc' => 
            array (
              'Email' => 
              array (
                0 => 'm.valenciaz@verisure.pe',
                1 => 'joseenrique.nanquen@verisure.pe',
              )
            ),
            'Message' => 
            array (
              'Subject' => '¡Hola! Ya tienes asignado al especialista de seguridad que te atenderá.',
              'Classification' => 'C',
              'Body' => 
              array (
                'Format' => 'html',
                'Value' => file_get_contents("https://www.verismart.com.pe/verismart/plantilla_securty_check_apertura.php?Matricula=$matriculaespecialista",false,$context),
              )
            ),
            'Options' => 
            array (
              'OpenTracking' => 'true',
              'ClickTracking' => 'true',
              'TextHtmlTracking' => 'true',
              'AutoTextBody' => 'false',
            )
          )
        );
        
        $dataSC_string = json_encode($dataSC);
        
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 60,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => $dataSC_string,
          CURLOPT_HTTPHEADER => array(
            "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
            "cache-control: no-cache",
            "content-type: application/json"
          ),
        ));
        
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
          return "cURL Error #:" . $err;
        } else {
          return $response;
        }
            
    
    }

    function EnvioCorreoAsignacion($idventa,$nprospecto,$tipoventa){
        
        //ESTRUCTURA DEL CORREO ACTUALIZADO
        //DELEGADO
        
        global $PerfilComercialCorreo;
        global $CategoriaComercialCorreo;
        
        global $CorreoComercialCorreo;
        global $CorreoJefeVentaCorreo;
        global $CorreoDelegadoCorreo;
        global $DelegacionCorreo;
        
        
        if($PerfilComercialCorreo == 17){
            
            if($CategoriaComercialCorreo == 'N1' || $CategoriaComercialCorreo == 'N2' || $CategoriaComercialCorreo == 'N3' || $CategoriaComercialCorreo == 'JE' 
            || $CategoriaComercialCorreo == 'VET' || $CategoriaComercialCorreo == 'COACH' || $CategoriaComercialCorreo == 'MST'){
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=$CorreoJefeVentaCorreo; //JEFE
                $correoAdministrativo3=$CorreoDelegadoCorreo; //DELEGADO
            } else if ($CategoriaComercialCorreo == 'DEL'){
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=$CorreoJefeVentaCorreo; //JEFE
                $correoAdministrativo3=''; //DELEGADO
            } else if ($CategoriaComercialCorreo == 'GERENTE TERRITORIAL') {
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=''; //JEFE
                $correoAdministrativo3=''; //DELEGADO
            } else {
                $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
                $correoAdministrativo2=''; //JEFE
                $correoAdministrativo3=''; //DELEGADO
            }
        } else if ($PerfilComercialCorreo == 38){
            $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
        } else {
            $correoAdministrativo1=$CorreoComercialCorreo; //ESPECIALISTA
        }
        
        //COPIA CORREO A LOS TERRITORIALES
    
        if($DelegacionCorreo == 150 || $DelegacionCorreo == 100 ||  $DelegacionCorreo == 152||$DelegacionCorreo == 157 || $DelegacionCorreo == 159  || $DelegacionCorreo == 251 || $DelegacionCorreo == 252){
            $correoAdministrativo4="renzobranchi.branez@verisure.pe";
        } else if ($DelegacionCorreo == 151 || $DelegacionCorreo == 200  || $DelegacionCorreo == 154 || $DelegacionCorreo == 156 || $DelegacionCorreo == 120 || $DelegacionCorreo == 121 || $DelegacionCorreo == 140 || $DelegacionCorreo == 141 || $DelegacionCorreo == 20){
            $correoAdministrativo4="joseenrique.nanquen@verisure.pe";
        } else if ($DelegacionCorreo == 40 || $DelegacionCorreo == 41 || $DelegacionCorreo == 153 || $DelegacionCorreo == 155  || $DelegacionCorreo == 158 || $DelegacionCorreo == 250 || $DelegacionCorreo == 80){
            $correoAdministrativo4="monicamaria.sanchez@verisure.pe";
        }
        
        
        //$correoAdministrativo4="backoffice@verisure.pe";
        
        $copia1 = "CHRISTIAN.GUTIERREZ@VERISURE.PE";
        $copia2 = "SHIRLEY.CUADRA@VERISURE.PE";
        $copia3 = "MADELEYNE.MUNAYCO@VERISURE.PE";
        $copia4 = "diego.delabarra@verisure.pe";

        
        $titulo="";
        if($tipoventa === 'RE'){
            $titulo="OPORTUNIDAD DE VENTA VISITA RE - ".$nprospecto." ";
        }else if($tipoventa === 'RPMKT'){
            $titulo = "OPORTUNIDAD DE VENTA VISITA RPMKT - ".$nprospecto." ";
        }else if($tipoventa === 'REGGCC'){
            $titulo = "OPORTUNIDAD DE VENTA VISITA REGGCC - ".$nprospecto." ";
        }else{
            $titulo=""; 
        }
        
        $opts = array(
        'http'=>array(
        'method'=>"GET",
        'header'=>"User-Agent: api script\r\n"
        ));
        $context = stream_context_create($opts);

        $curl = curl_init();
    
        $dataSC= array (
          'GeneralData' => 
          array (
            'FromName' => 'Sistema de Ventas Verismart - Verisure Perú',
            'From' => 'backoffice@verisure.pe',
            'To' => 
            array (
              'Email' => 
              array (
                    0 => $correoAdministrativo1,
                    1 => $correoAdministrativo2,
                    2 => $correoAdministrativo3,
                    3 => $correoAdministrativo4,
              )
            ),
            'Cc' => 
            array (
              'Email' => 
              array (
                0 => $copia1,
                1 => $copia2,
                2 => $copia3,
                3 => $copia4,
              )
            ),
            'Bcc' => 
            array (
              'Email' => 
              array (
                0 => 'joseenrique.nanquen@verisure.pe',
              )
            ),
            'Message' => 
            array (
              'Subject' => $titulo,
              'Classification' => 'C',
              'Body' => 
              array (
                'Format' => 'html',
                'Value' => file_get_contents("https://www.verismart.com.pe/verismart/plantilla_asignacion_visita.php?idventa=$idventa",false,$context),
                
              )
            ),
            'Options' => 
            array (
              'OpenTracking' => 'true',
              'ClickTracking' => 'true',
              'TextHtmlTracking' => 'true',
              'AutoTextBody' => 'false',
            )
          )
        );
    
        $dataSC_string = json_encode($dataSC);
        
        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api2023.masterbase.com/UniqueMail/v3/verisuremktpe",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => $dataSC_string,
          CURLOPT_HTTPHEADER => array(
            "authorization: Basic U2VjdXJpdHlfY2hlY2s6Njc1NC1TQDlxYTAjZDZVN2MzdzU=",
            "cache-control: no-cache",
            "content-type: application/json"
          ),
        ));
    
        $response = curl_exec($curl);
        $err = curl_error($curl);
        
        curl_close($curl);
        
        if ($err) {
          return "cURL Error #:" . $err;
        } else {
          return $response;
        }    
    
    }
    
    function insertarLogCorreo($idventa){
        global $con;
    
        global $ObjCorreoAsignacion,$fecharegistroventa;
         
            try {
        
              $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog_correo(IdVenta,ObjTransaccion,FechaHoraREG) VALUES(?,?,?)");
              $stmt->bind_param('iss', $idventa,$ObjCorreoAsignacion,$fecharegistroventa);
                $stmt->execute();
                $respuesta = $con->insert_id;
                $stmt->close();
            } catch (\Exception $e) {
                $respuesta = array(
                    'respuesta' => 'error'
                );
            }
        
            return $respuesta;
    
    }


$resultado->close();



