<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';


date_default_timezone_set('America/Lima');


  try{

        $stmtventa = $con->prepare( "SELECT h.IdHistorialAnulaciones,
        a.FechaHoraREG,
        h.FechaHoraREG,
    	v.GestorMKT,
    	CONCAT(mk.Nombres,' ',mk.Apellidos) Operador,
        h.MatriculaUsuario,
    	CONCAT(bo.Nombres,' ',bo.Apellidos) OperadorBO,
    	DATE_FORMAT(v.FechaVisita,'%d/%m/%Y') FechaVisita,
        h.EstadoVisita,
        h.Detalle,
        h.Comentarios,
        v.NProspecto,
        c.Telefonouno,
        v.CCOriginal
        FROM dbVENTAS.tblhistorialanulaciones h
        INNER JOIN dbVENTAS.tblagenda a on h.IdVenta = a.IdVenta
        INNER JOIN dbVENTAS.tblventa v ON v.IdVenta = h.IdVenta
        INNER JOIN dbUSUARIO.tblusuario u on v.IdUsuario=u.IdUsuario 
        INNER JOIN dbVENTAS.tblcliente c on c.IdCliente=v.IdCliente
        INNER JOIN dbUSUARIO.tblusuario bo on h.MatriculaUsuario = bo.Matricula
        LEFT JOIN dbUSUARIO.tblusuario mk on mk.Matricula=v.GestorMKT");
        
        $stmtventa->execute();
        $stmtventa->store_result();
        $stmtventa->bind_result($IdHistorialAnulaciones,
            $FechaRegistroVisita,
            $FechaRegistro,
            $GestorMKT,
            $Operador,
            $GestorOrigen,
            $OperadorBo,
            $FechaVisita,
            $EstadoVisita,
            $Detalle,
            $Comentarios,
            $NProspecto,
            $Telefonouno,
            $CCOriginal);
        $venta = [];        
        while ($stmtventa->fetch()){
        $venta[] = array_map("utf8_encode",['IdHistorialAnulaciones' => $IdHistorialAnulaciones,
'FechaRegistroVisita' => $FechaRegistroVisita,
'FechaRegistroAnulacion' => $FechaRegistro,
'GestorMKT'=>$GestorMKT,
'Operador'=>$Operador,
'GestorBo'=>$GestorOrigen,
'OperadorBO'=>$OperadorBo,
'FechaVisita'=>$FechaVisita,
'EstadoVisita'=>$EstadoVisita,
'Detalle'=>$Detalle,
'Comentarios'=>utf8_decode($Comentarios),
'NProspecto'=>$NProspecto,
'Telefono'=>$Telefonouno,
'CCOriginal'=>$CCOriginal
]);            
	    }
	    
        $stmtventa->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
header('Content-Type: application/csv; charset=iso-8859-1');
header('Content-Disposition: attachment; filename=Anulaciones.csv');
$output = fopen('php://output', 'w');
fputcsv($output, array('IdHistorialAnulaciones',
'FechaRegistroVisita',
'FechaRegistro',
'GestorMKT',
'Operador',
'GestorBo',
'OperadorBO',
'FechaVisita',
'EstadoVisita',
'Detalle',
'Comentarios',
'NProspecto',
'Telefono',
'CCOriginal'
));

if (count($venta) > 0) {
    foreach ($venta as $row) {
        fputcsv($output, $row);
    }
}
