<?php

include('is_logged.php');

require_once '../config/db.php';
require_once '../config/conexion.php';

//include_once '../config/dbsec.php';
//include_once '../config/conexionsec.php';

date_default_timezone_set('America/Lima');


$fecharegistro=date("Y-m-d H:i:s");


        $REMOTE_ADDR=htmlspecialchars($_SERVER['REMOTE_ADDR']);
        $usuariosesion=htmlspecialchars($_SESSION['usuariosesion']);
        $REQUEST_URI=htmlspecialchars($_SERVER['REQUEST_URI']);
        $Acceso='Exportar';
        $HTTP_USER_AGENT=htmlspecialchars($_SERVER['HTTP_USER_AGENT']);
        
        try {
                
          $stmt = $con->prepare("INSERT INTO dbACTIVIDADES.tbllog(ip,usuario,fechahorareg,url,accion,navegador) VALUES (?,?,?,?,?,?)");
          $stmt->bind_param('ssssss', $REMOTE_ADDR, $usuariosesion, $fecharegistro, $REQUEST_URI, $Acceso, $HTTP_USER_AGENT);
          $stmt->execute();
          $stmt->close();
          
        } catch (\Exception $e) {
          echo $e->getMessage();
        }
        
 try{

        $stmtventa = $con->prepare("SELECT IdUsuario, Matricula, Nombres, Apellidos, Cargo, Categoria, CC, LN, Manager, Usuario, FechaIngreso, Estado, Foto FROM dbUSUARIO.tblusuario 
WHERE (CC='150' or  CC='151' or CC='152' or CC='153' or CC='154' or CC='155' or CC='120' or CC='40' or CC='41' or CC='200' or CC='156' or CC='157' or CC='158' or CC='159' or CC='100' or CC='140'
OR CC='121' OR CC='250' OR CC='251' OR CC='80' OR CC='141' OR CC='42' OR CC='252' OR CC='20') and Estado = 'Activo' Order by CC DESC");
        $stmtventa->execute();
        $stmtventa->store_result();
        $stmtventa->bind_result($IdUsuario, $Matricula, $Nombres, $Apellidos, $Cargo, $Categoria, $CC, $LN, $Manager, $Usuario, $FechaIngreso, $Estado, $Foto);
        $venta = [];        
        while ($stmtventa->fetch()){
                    
                    $tieneFoto = 'NO';
                    
                    if($Foto != ''){
                        $tieneFoto = 'SI';          
                    }
                    
        $venta[] = array_map("utf8_encode",[
                        'IdUsuario'=>$IdUsuario,
                        'Matricula'=>$Matricula,
                        'Nombres'=>$Nombres,
                        'Apellidos'=>$Apellidos,
                        'Cargo'=>$Cargo,
                        'Categoria'=>$Categoria,
                        'CC'=>$CC,
                        'LN'=>$LN,
                        'Manager'=>$Manager,
                        'Usuario'=>$Usuario,
                        'FechaIngreso'=>$FechaIngreso,
                        'Estado'=>$Estado,
                        'Foto'=>$Foto,
                        'TieneFoto' => $tieneFoto
]);            
	    }
	    
        $stmtventa->close();

    } catch(PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
 

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename=Estructura.csv');
$output = fopen('php://output', 'w');
fputcsv($output, array(                        'IdUsuario',
                        'Matricula',
                        'Nombres',
                        'Apellidos',
                        'Cargo',
                        'Categoria',
                        'CC',
                        'LN',
                        'Manager',
                        'Usuario',
                        'FechaIngreso',
                        'Estado',
                        'Foto',
                        'TieneFoto' 
));

if (count($venta) > 0) {
    foreach ($venta as $row) {
        fputcsv($output, $row);
    }
}
