<?php

require_once '../config/db.php';
require_once '../config/conexion.php';

$json = file_get_contents('php://input');
$data = json_decode($json);

$fechadiahoy= $data->mesfactufoto;
//$fechadiahoy= "Aug-2020";

$delegaciones = array(
    //TERR CENTRO - R.BRAÑEZ
        array('Id' =>150, 'Titulo'=>'SURCO', 'Delegado'=>'B. MURGA'),
        array('Id' =>156, 'Titulo'=>'LIMA OESTE', 'Delegado'=>'L.HURTADO'),
        array('Id' =>157, 'Titulo'=>'LA MOLINA', 'Delegado'=>'J. UGAZ'),
        array('Id' =>159, 'Titulo'=>'LINCE', 'Delegado'=>'J. GOICOCHEA'),
        array('Id' =>252, 'Titulo'=>'JESUS MARIA', 'Delegado'=>'M. ESPINOZA'),
        array('Id' =>153, 'Titulo'=>'LIMA CENTRO', 'Delegado'=>'J. ALCANTARA'), 
    //TERR LIMA SUR - C.CUNEO    
        array('Id' =>151, 'Titulo'=>'LIMA SUR', 'Delegado'=>'J. MARMOLEJO'),
        array('Id' =>152, 'Titulo'=>'LIMA ESTE', 'Delegado'=>'C. CUNEO'), 
        array('Id' =>100, 'Titulo'=>'ICA', 'Delegado'=>'C. HUAZO'),
    //TERR PERÚ NORTE: J. ROJAS
        array('Id' =>120, 'Titulo'=>'TRUJILLO', 'Delegado'=>'J. ROJAS'),
        array('Id' =>121, 'Titulo'=>'TRUJILLO SUR', 'Delegado'=>'A. LAZARO'),
        array('Id' =>140, 'Titulo'=>'CHICLAYO', 'Delegado'=>'A. SOTOMAYOR'),
    //TERR LIMA OESTE - M.SÁNCHEZ
        array('Id' =>154, 'Titulo'=>'MIRAFLORES', 'Delegado'=>'H. VIGO'),         
        array('Id' =>155, 'Titulo'=>'LIMA NORTE', 'Delegado'=>'O. MEIGGS'),
        array('Id' =>158, 'Titulo'=>'LOS OLIVOS', 'Delegado'=>'J. BARNUEVO'),        
        array('Id' =>200, 'Titulo'=>'PIURA', 'Delegado'=>'M. CASTILLO'),        
    //TERR PERÚ SUR: D. ADELL
        array('Id' =>40, 'Titulo'=>'AREQUIPA SUR', 'Delegado'=>'D. ADELL'),
        array('Id' =>41, 'Titulo'=>'AREQUIPA NORTE', 'Delegado'=>'C. MOSCOSO'),
        array('Id' =>80, 'Titulo'=>'CUSCO', 'Delegado'=>'J. CHAU'),
    array('Id' =>999, 'Titulo'=>'TOTAL FIELD', 'Delegado'=>''),    
        
        array('Id' =>511, 'Titulo'=>'TELECIERRE', 'Delegado'=>'TELECIERRE'), 
        array('Id' =>512, 'Titulo'=>'TELEVENTA', 'Delegado'=>'TELEVENTA'),
        array('Id' =>599, 'Titulo'=>'FORMACION', 'Delegado'=>'FORMACION'),    
        array('Id' =>500, 'Titulo'=>'CENTRAL', 'Delegado'=>'CENTRAL'),
        array('Id' =>513, 'Titulo'=>'GGCC', 'Delegado'=>'GGCC'),
);


//var_dump($delegaciones);

$arregloDatos = array();
$totalBU=0;
$totalInstaladas=0;
$totalNoDoc=0;
$totalSinDoc=0;
$totalIncidencia=0;
$totalFacturada=0;
$totalDocEnviada=0;
$totalIncigest=0;
$totalPorFacturar=0;
$totalProxMes=0;
$totalInstalacionesrealizadas=0;
$totalDiasSinDoc=0;
$totalDiasResol=0;


$totalBUFIELD=0;
$totalInstaladasFIELD=0;
$totalNoDocFIELD=0;
$totalSinDocFIELD=0;
$totalIncidenciaFIELD=0;
$totalFacturadaFIELD=0;
$totalDocEnviadaFIELD=0;
$totalIncigestFIELD=0;
$totalPorFacturarFIELD=0;
$totalProxMesFIELD=0;
$totalInstalacionesrealizadasFIELD=0;
$totalDiasSinDocFIELD=0;
$totalDiasResolFIELD=0;


$arregloBU=consultaBU();
$arregloInstaladas=consultaInstaladas();
$arregloNoDoc=consultaNoDoc();
$arregloIncidencia=consultaIncidencia();
$arregloFacturada=consultaFacturada();
$arregloDocEnviada=consultaDocEnviada();
$arregloIncigest=consultaIncigest();
$arregloPorFacturar=consultaPorFacturar();
$arregloProxMes=consultaProxMes();
$arregloDiasSinDoc=consultaCantidadDiasSinDoc();
$arregloDiasResol=consultaCantidadDiasResol();

for($i=0; $i<count($delegaciones); $i++){
    
$delegacion = $delegaciones[$i]['Id'];
$cantidadBU = cantidadFact($delegacion, $arregloBU);
$cantidadInstaladas=cantidadFact($delegacion, $arregloInstaladas);
$cantidadNoDoc=cantidadFact($delegacion, $arregloNoDoc);
$cantidadIncidencia=cantidadFact($delegacion, $arregloIncidencia);
$cantidadFacturada=cantidadFact($delegacion, $arregloFacturada);
$cantidadDocEnviada=cantidadFact($delegacion, $arregloDocEnviada);
$cantidadIncigest=cantidadFact($delegacion, $arregloIncigest);
$cantidadPorFacturar=cantidadFact($delegacion, $arregloPorFacturar);
$cantidadProxMes=cantidadFact($delegacion, $arregloProxMes);
$cantidadInstalacionesrealizadas=($cantidadInstaladas+$cantidadNoDoc+$cantidadIncidencia+$cantidadFacturada);
$cantidadSinDoc=($cantidadInstaladas+$cantidadNoDoc);
$porcentajeSinDoc=porcentaje($cantidadSinDoc, $cantidadInstalacionesrealizadas);
$porcentajeIncidencia=porcentaje($cantidadIncidencia, $cantidadInstalacionesrealizadas);
$porcentajeFacturada=porcentaje($cantidadFacturada, $cantidadInstalacionesrealizadas);
$porcentajeFacturadaVsBU=porcentaje($cantidadFacturada, $cantidadBU);
$porcentajeEntregado=porcentaje(($cantidadFacturada+$cantidadIncidencia), $cantidadInstalacionesrealizadas);
$cantidadDiasSinDoc=cantidadFact($delegacion, $arregloDiasSinDoc);
$cantidadDiasResol=cantidadFact($delegacion, $arregloDiasResol);
//


if($delegacion==150 || $delegacion==151 || $delegacion==152 || $delegacion==153 || $delegacion==154 || $delegacion==155 || $delegacion==156 || $delegacion==120 || $delegacion==140  || $delegacion==100 || $delegacion==200 || $delegacion==41 || $delegacion==42 || $delegacion==40 || $delegacion==157 || $delegacion==158 || $delegacion==159 || $delegacion==121 || $delegacion==250 || $delegacion==251 || $delegacion==252 || $delegacion==141 || $delegacion==80 || $delegacion==20){
$totalBUFIELD+=$cantidadBU;
$totalInstaladasFIELD+=$cantidadInstaladas;
$totalNoDocFIELD+=$cantidadNoDoc;
$totalIncidenciaFIELD+=$cantidadIncidencia;
$totalFacturadaFIELD+=$cantidadFacturada;
$totalDocEnviadaFIELD+=$cantidadDocEnviada;
$totalIncigestFIELD+=$cantidadIncigest;
$totalPorFacturarFIELD+=$cantidadPorFacturar;
$totalProxMesFIELD+=$cantidadProxMes;
$totalDiasSinDocFIELD+=$cantidadDiasSinDoc;
$totalDiasResolFIELD+=$cantidadDiasResol;
}

$totalBU+=$cantidadBU;
$totalInstaladas+=$cantidadInstaladas;
$totalNoDoc+=$cantidadNoDoc;
$totalIncidencia+=$cantidadIncidencia;
$totalFacturada+=$cantidadFacturada;
$totalDocEnviada+=$cantidadDocEnviada;
$totalIncigest+=$cantidadIncigest;
$totalPorFacturar+=$cantidadPorFacturar;
$totalProxMes+=$cantidadProxMes;
$totalDiasSinDoc+=$cantidadDiasSinDoc;
$totalDiasResol+=$cantidadDiasResol;

if($delegacion==999){

$totalInstalacionesrealizadasFIELD=($totalInstaladasFIELD+$totalNoDocFIELD+$totalIncidenciaFIELD+$totalFacturadaFIELD);
$totalSinDocFIELD+=($totalInstaladasFIELD+$totalNoDocFIELD);
$porcentajeSinfotoFIELD=porcentaje($totalInstaladasFIELD, $totalInstalacionesrealizadasFIELD);
$porcentajeNodocFIELD=porcentaje($totalNoDocFIELD, $totalInstalacionesrealizadasFIELD);
$porcentajeSinDocFIELD=porcentaje($totalSinDocFIELD, $totalInstalacionesrealizadasFIELD);
$porcentajeIncidenciaFIELD=porcentaje($totalIncidenciaFIELD, $totalInstalacionesrealizadasFIELD);
$porcentajeFacturadaFIELD=porcentaje($totalFacturadaFIELD, $totalInstalacionesrealizadasFIELD);
$porcentajeFacturadaVsBUFIELD=porcentaje($totalFacturadaFIELD, $totalBUFIELD);
$porcentajeEntregadoFIELD=porcentaje(($totalFacturadaFIELD+$totalIncidenciaFIELD), $totalInstalacionesrealizadasFIELD);

//Cantidad de Delegaciones FIELD (22)
$totalDiasSinDocFIELD=media($totalDiasSinDocFIELD, 22);
$totalDiasResolFIELD=media($totalDiasResolFIELD, 22);
    
 $arregloDatos[$i] = array(
'Delegacion' => $delegaciones[$i],
'FactuBU'=>$totalBUFIELD,
'FactuInstalacionesrealizadas'=>$totalInstalacionesrealizadasFIELD,
'FactuInstaladas'=>$totalInstaladasFIELD,
'FactuNoDoc'=>$totalNoDocFIELD,
'FactuIncidencia'=>$totalIncidenciaFIELD,
'FactuFacturada'=>$totalFacturadaFIELD,
'FactuDocEnviada'=>$totalDocEnviadaFIELD,
'FactuIncigest'=>$totalIncigestFIELD,
'FactuPorFacturar'=>$totalPorFacturarFIELD,
'FactuProxMes'=>$totalProxMesFIELD,
'FactuPorcentajeSinfoto'=>$porcentajeSinfotoFIELD,
'FactuPorcentajeNodoc'=>$porcentajeNodocFIELD,
'FactuPorcentajeIncidencia'=>$porcentajeIncidenciaFIELD,
'FactuPorcentajeFacturada'=>$porcentajeFacturadaFIELD,
'FactuPorcentajeFacturadaVsBU'=>$porcentajeFacturadaVsBUFIELD,
'FactuPorcentajeEntregado'=>$porcentajeEntregadoFIELD,
'FactuPorcentajeSinDoc'=>$porcentajeSinDocFIELD,
'FactuSinDoc'=>$totalSinDocFIELD,
'FactuDiasSinDoc'=>round($totalDiasSinDocFIELD),
'FactuDiasResol'=>round($totalDiasResolFIELD)
        );
}else{
   
    
    $arregloDatos[$i] = array(
'Delegacion' => $delegaciones[$i],
'FactuBU'=>$cantidadBU,
'FactuInstalacionesrealizadas'=>$cantidadInstalacionesrealizadas,
'FactuInstaladas'=>$cantidadInstaladas,
'FactuNoDoc'=>$cantidadNoDoc,
'FactuIncidencia'=>$cantidadIncidencia,
'FactuFacturada'=>$cantidadFacturada,
'FactuDocEnviada'=>$cantidadDocEnviada,
'FactuIncigest'=>$cantidadIncigest,
'FactuPorFacturar'=>$cantidadPorFacturar,
'FactuProxMes'=>$cantidadProxMes,
'FactuPorcentajeSinfoto'=>0,
'FactuPorcentajeNodoc'=>0,
'FactuPorcentajeIncidencia'=>$porcentajeIncidencia,
'FactuPorcentajeFacturada'=>$porcentajeFacturada,
'FactuPorcentajeFacturadaVsBU'=>$porcentajeFacturadaVsBU,
'FactuPorcentajeEntregado'=>$porcentajeEntregado,
'FactuPorcentajeSinDoc'=>$porcentajeSinDoc,
'FactuSinDoc'=>$cantidadSinDoc,
'FactuDiasSinDoc'=>round($cantidadDiasSinDoc),
'FactuDiasResol'=>round($cantidadDiasResol)
        );

    
}

}

$totalInstalacionesrealizadas=($totalInstaladas+$totalNoDoc+$totalIncidencia+$totalFacturada);
$totalSinDoc=($totalInstaladas+$totalNoDoc);
$porcentajetotalSinfoto=porcentaje($totalInstaladas, $totalInstalacionesrealizadas);
$porcentajetotalNodoc=porcentaje($totalNoDoc, $totalInstalacionesrealizadas);
$porcentajetotalSinDoc=porcentaje($totalSinDoc, $totalInstalacionesrealizadas);
$porcentajetotalIncidencia=porcentaje($totalIncidencia, $totalInstalacionesrealizadas);
$porcentajetotalFacturada=porcentaje($totalFacturada, $totalInstalacionesrealizadas);
$porcentajetotalFacturadaVsBU=porcentaje($totalFacturada, $totalBU);
$porcentajetotalEntregado=porcentaje(($totalFacturada+$totalIncidencia), $totalInstalacionesrealizadas);

//Cantidad de Delegaciones (25)
$totalDiasSinDoc=media($totalDiasSinDoc, 25);
$totalDiasResol=media($totalDiasResol, 25);

$arregloDatos['Totales'] = array(
'totalBU'=>$totalBU,
'totalInstalacionesrealizadas'=>$totalInstalacionesrealizadas,
'totalInstaladas'=>$totalInstaladas,
'totalNoDoc'=>$totalNoDoc,
'totalIncidencia'=>$totalIncidencia,
'totalFacturada'=>$totalFacturada,
'totalDocEnviada'=>$totalDocEnviada,
'totalIncigest'=>$totalIncigest,
'totalPorFacturar'=>$totalPorFacturar,
'totalProxMes'=>$totalProxMes,
'totalPorcentajeSinfoto'=>$porcentajetotalSinfoto,
'totalPorcentajeNodoc'=>$porcentajetotalNodoc,
'totalPorcentajeIncidencia'=>$porcentajetotalIncidencia,
'totalPorcentajeFacturada'=>$porcentajetotalFacturada,
'totalPorcentajeFacturadaVsBU'=>$porcentajetotalFacturadaVsBU,
'totalPorcentajeEntregado'=>$porcentajetotalEntregado,
'totalPorcentajeSinDoc'=>$porcentajetotalSinDoc,
'totalSinDoc'=>$totalSinDoc,
'totalDiasSinDoc'=>round($totalDiasSinDoc),
'totalDiasResol'=>round($totalDiasResol)
);

echo json_encode($arregloDatos);

function consultaBU(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT tp.BU150,tp.BU151,tp.BU152,tp.BU153,tp.BU154,tp.BU155,tp.BU156,tp.BU120,tp.BU40,tp.BU41,tp.BU42,tp.BU200,tp.BU511,tp.BU512,tp.BU500,tp.BU599,tp.BU157,tp.BU158,tp.BU159,tp.BU100,tp.BU513,tp.BU140,tp.BU121,tp.BU250,tp.BU251,tp.BU141,tp.BU80,tp.BU252,tp.BU20 FROM dbVENTAS.tbltmpdashboard tp WHERE tp.N590='".$fechadiahoy."'  order by tp.IdTmp desc limit 0,1";
    $resultado = $con->query($sql);
    while($venta = $resultado->fetch_assoc()){
        $data =[
            ["CC"=>150,"Total"=>$venta['BU150']],
            ["CC"=>151,"Total"=>$venta['BU151']],
            ["CC"=>152,"Total"=>$venta['BU152']],
            ["CC"=>153,"Total"=>$venta['BU153']],
            ["CC"=>154,"Total"=>$venta['BU154']],
            ["CC"=>155,"Total"=>$venta['BU155']],
            ["CC"=>156,"Total"=>$venta['BU156']],
            ["CC"=>120,"Total"=>$venta['BU120']],
            ["CC"=>40,"Total"=>$venta['BU40']],
            ["CC"=>41,"Total"=>$venta['BU41']],
            ["CC"=>42,"Total"=>$venta['BU42']],
            ["CC"=>200,"Total"=>$venta['BU200']],
            ["CC"=>511,"Total"=>$venta['BU511']],
            ["CC"=>512,"Total"=>$venta['BU512']],
            ["CC"=>500,"Total"=>$venta['BU500']],
            ["CC"=>599,"Total"=>$venta['BU599']],
            ["CC"=>157,"Total"=>$venta['BU157']],
            ["CC"=>158,"Total"=>$venta['BU158']],
            ["CC"=>159,"Total"=>$venta['BU159']],
            ["CC"=>100,"Total"=>$venta['BU100']],
            ["CC"=>513,"Total"=>$venta['BU513']],
            ["CC"=>121,"Total"=>$venta['BU121']],
            ["CC"=>250,"Total"=>$venta['BU250']],
            ["CC"=>251,"Total"=>$venta['BU251']],
            ["CC"=>140,"Total"=>$venta['BU140']],
            ["CC"=>141,"Total"=>$venta['BU141']],
            ["CC"=>80,"Total"=>$venta['BU80']],
            ["CC"=>252,"Total"=>$venta['BU252']],
            ["CC"=>20,"Total"=>$venta['BU20']]
            ];
    }
    return $data;
}



function consultaInstaladas(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT v.CC,count(v.IdVenta) as Total FROM tblventa v WHERE v.N590='".$fechadiahoy."' and (v.Estadoventa='Instalada' OR v.EstadoVenta = 'InstaladaDEL' OR v.EstadoVenta = 'IncidenciaAuditoria' OR v.EstadoVenta = 'InstaladaTEC') GROUP BY v.CC";
    $resultado = $con->query($sql);
    while($factu = $resultado->fetch_assoc()){
        $data[] = $factu;
    }
    return $data;
}
function consultaNoDoc(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT v.CC,count(v.IdVenta) as Total FROM tblventa v WHERE v.N590='".$fechadiahoy."' and (v.Estadoventa='NoDoc' or v.Estadoventa='DocEnvi') GROUP BY v.CC";
    $resultado = $con->query($sql);
    while($factu = $resultado->fetch_assoc()){
        $data[] = $factu;
    }
    return $data;
}
function consultaIncidencia(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT v.CC,count(v.IdVenta) as Total FROM tblventa v WHERE v.N590='".$fechadiahoy."' and (v.Estadoventa='Incidencia' or v.Estadoventa='IncidenciaGestValija' or v.Estadoventa='IncidenciaGestCorreo') GROUP BY v.CC";
    $resultado = $con->query($sql);
    while($factu = $resultado->fetch_assoc()){
        $data[] = $factu;
    }
    return $data;
}
function consultaFacturada(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT v.CC,count(v.IdVenta) as Total FROM tblventa v WHERE v.N590='".$fechadiahoy."' and (v.Estadoventa='Facturada' or v.Estadoventa='PorFacturar') GROUP BY v.CC";
    $resultado = $con->query($sql);
    while($factu = $resultado->fetch_assoc()){
        $data[] = $factu;
    }
    return $data;
}
function consultaDocEnviada(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT v.CC,count(v.IdVenta) as Total FROM tblventa v WHERE v.N590='".$fechadiahoy."' and v.Estadoventa='DocEnvi' GROUP BY v.CC";
    $resultado = $con->query($sql);
    while($factu = $resultado->fetch_assoc()){
        $data[] = $factu;
    }
    return $data;
}

function consultaIncigest(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT v.CC,count(v.IdVenta) as Total FROM tblventa v WHERE v.N590='".$fechadiahoy."' and (v.Estadoventa='IncidenciaGestValija' or v.Estadoventa='IncidenciaGestCorreo') GROUP BY v.CC";
    $resultado = $con->query($sql);
    while($factu = $resultado->fetch_assoc()){
        $data[] = $factu;
    }
    return $data;
}
function consultaPorFacturar(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT v.CC,count(v.IdVenta) as Total FROM tblventa v WHERE v.N590='".$fechadiahoy."' and  v.Estadoventa='PorFacturar' GROUP BY v.CC";
    $resultado = $con->query($sql);
    while($factu = $resultado->fetch_assoc()){
        $data[] = $factu;
    }
    return $data;
}
function consultaProxMes(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT v.CC,count(v.IdVenta) as Total FROM tblventa v WHERE IMP='SI' and v.N590=DATE_FORMAT(DATE_ADD( STR_TO_DATE('".$fechadiahoy."','%b-%Y')+1, INTERVAL 1 MONTH ),'%b-%Y') and (v.EstadoVenta='Incidencia' or v.EstadoVenta='IncidenciaGestValija' or v.EstadoVenta='IncidenciaGestCorreo' or v.EstadoVenta='Instalada' OR v.EstadoVenta = 'IncidenciaAuditoria' OR v.EstadoVenta = 'InstaladaTEC' OR v.EstadoVenta = 'InstaladaDEL' or v.EstadoVenta='NoDoc' or v.EstadoVenta='DocEnvi') GROUP BY v.CC";
    $resultado = $con->query($sql);
    while($factu = $resultado->fetch_assoc()){
        $data[] = $factu;
    }
    return $data;
}

function consultaCantidadDiasSinDoc(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT v.CC,AVG(DATEDIFF(CURRENT_DATE,a.FechaInst)) as Total FROM tblventa v INNER JOIN tblagenda a on a.IdVenta=v.IdVenta WHERE v.N590='".$fechadiahoy."' and (v.Estadoventa='Instalada' OR v.EstadoVenta = 'InstaladaDEL' OR v.EstadoVenta = 'IncidenciaAuditoria' OR v.EstadoVenta = 'InstaladaTEC' OR v.Estadoventa='NoDoc' or v.Estadoventa='DocEnvi') GROUP BY v.CC";
    $resultado = $con->query($sql);
    while($factu = $resultado->fetch_assoc()){
        $data[] = $factu;
    }
    return $data;
}

function consultaCantidadDiasResol(){
    global $con;
    global $fechadiahoy;
    $sql="SELECT v.CC,AVG(DATEDIFF(CURRENT_DATE,a.FechaInst)) as Total FROM tblventa v INNER JOIN tblagenda a on a.IdVenta=v.IdVenta WHERE v.N590='".$fechadiahoy."' and (v.Estadoventa='Incidencia' or v.Estadoventa='IncidenciaGestValija' or v.Estadoventa='IncidenciaGestCorreo') GROUP BY v.CC";
    $resultado = $con->query($sql);
    while($factu = $resultado->fetch_assoc()){
        $data[] = $factu;
    }
    return $data;
}


function cantidadFact($delegacion, $arregloFactuTotales){
    //echo json_encode($arregloFactuTotales);
    $cantFactu = 0;
    for($i=0; $i<count($arregloFactuTotales); $i++){
        if ($delegacion == $arregloFactuTotales[$i]['CC']){
            //echo $arregloFactuTotales[$i]['visitas'];
            $cantFactu =  $arregloFactuTotales[$i]['Total'];
            break;
        } 
    }
    return $cantFactu;
}

function porcentaje($parte, $total){
    if($total > 0){
        return round(($parte/$total)*100);
    } else {
        return 0;
    }
    
}

function media($parte, $total){
    if($total > 0){
        return round($parte/$total);
    } else {
        return 0;
    }
    
}


?>