<?php
require dirname(__DIR__).'/ajax/is_logged.php';
require dirname(__DIR__).'/Connection/Conection.php';
require dirname(__DIR__).'/Model/ConexionGuia.php';

date_default_timezone_set('America/Lima');
//Funciones para codificar al momento de grabar en Mysql
function myUrlEncode($string) {
    $entities = array('%21', '%2A', '%27', '%28', '%29', '%3B', '%3A', '%40', '%26', '%3D', '%2B', '%24', '%2C', '%2F', '%3F', '%25', '%23', '%5B', '%5D');
    $replacements = array('!', '*', "'", "(", ")", ";", ":", "@", "&", "=", "+", "$", ",", "/", "?", "%", "#", "[", "]");
    return str_replace($entities, $replacements, urlencode($string));
}
function format_date_dd_mm_Y($date){
    return date('d/m/Y', strtotime($date));
}
function format_date_Y_mm_dd($date){
    return date('Y-m-d', strtotime($date));
}


if (isset($_POST['function']) && !empty($_POST['function'])) {

    $function = json_decode($_POST['function']);

    switch ($function->array) {
        case 'array1':
            $consulta= new Guia;
            $consulta->ListarGuiaAnulacion();
            break;
        case 'array2':
            $consulta= new Guia;
            $consulta->IngresarGuia();
            break;
        case 'array3':
            $consulta= new Guia;
            $consulta->UpdateMasivoGuia();
            break;             
        case 'array4':
            $consulta = new Guia;
            $consulta->ListarGuiaImportacion();
            break;
        // case 'array4':
        //     $consulta = new TVReferidos;
        //     $consulta->ObtenerTelefono();
        //     break;            
        // case 'array5':
        //     $consulta = new TVReferidos;
        //     $consulta->ObtenerDatosUsuario();
        //     break;
        // case 'array6':
        //     $consulta = new TVReferidos;
        //     $consulta->ActualizarClienteProspecto();
        //     break;            
        default:
            echo "Error no se encontro la data";
            break;
    }

}



class Guia
{
    public function ListarGuiaAnulacion()
    {

        $function = json_decode($_POST['function']);

        $conexion = new ConexionGuia();
        
        $datos=$conexion->ListarGuiaAnulacion($function);

        print_r(json_encode($datos)); 
        

    }
    
    public function ListarGuiaImportacion()
    {

        $function = json_decode($_POST['function']);

        $conexion = new ConexionGuia();
        
        $datos=$conexion->ListarGuiaImportacion($function);

        print_r(json_encode($datos)); 
        

    }
    
    public function IngresarGuia(){
        
        $function = json_decode($_POST['function']);
        
        
        
        $nguia=htmlspecialchars($function->nguia);
        $matriculasolicitante=htmlspecialchars($function->matriculasolicitante);
        $motivoanulacion=htmlspecialchars($function->motivoanulacion);
        $fechasolicitud=date('Y-m-d H:i:s');
        
        $contrato=htmlspecialchars($function->contrato);
        $estado='Pendiente';

        $conexion = new ConexionGuia();
        
        
        $resultadoinsert=$conexion->insertarGuia($fechasolicitud, $matriculasolicitante, $nguia, $motivoanulacion, $contrato, $estado);
        if ($resultadoinsert > 0){
            $respuesta = array ('respuesta'=>'exito');
        }else{
            $respuesta = array ('respuesta'=>'error');
        }
        
        print_r(json_encode($respuesta));
        
    }
    public function UpdateMasivoGuia(){
         $function = json_decode($_POST['function']);

        $cboEstado= htmlspecialchars($function->cboEstado);
        $selectrows = htmlspecialchars($function->selectrows);
        $arraySelect = explode (',', $selectrows);
         
        $conexion = new ConexionGuia();

        if(!empty($arraySelect)){
            $resultadoventa=0;
            
            foreach ($arraySelect as $key => $value) {
                
                $resultadoventa+=$conexion->actualizarGuiaMasiva($value,$cboEstado);
            
            }
    
            if($resultadoventa>0){
                die(json_encode(array('respuesta' => 'exito', 'id_registro' => '')));  
            }else{
                die(json_encode(array('respuesta' => 'error')));
            }
        
        }else{
            die(json_encode(array('respuesta' => 'error')));
        }

         
         
    }    

}


?>