
const tableTipologia = new DataTable('#tblTipologia');
const tableBanco = new DataTable('#tblBancos');
const tableFormasPago = new DataTable('#tblFormasPago');
const tableModalidadPago = new DataTable('#tblModalidadPago');
const tableCuentaContable = new DataTable('#tblCuentaContable');
const tableCategoriasCuentaContable = new DataTable('#tblCategoriasCuentaContable');
const tableSubcategoriasCuentaContable = new DataTable('#tblSubcategoriasCuentaContable');
const tableUsuariosAccesoProveedor = new DataTable("#tblUsuariosAccesoProveedor");

const tableRequerimientos = new DataTable('#tblRequerimientos');
const tableMotivosRequerimiento = new DataTable('#tblMotivosRequerimiento');
const tablePeticiones = new DataTable('#tblPeticiones', {
    responsive: true,
    columnDefs: [
        { width: '50px', targets: 0 },
        { responsivePriority: 1, targets: 0 },
        { responsivePriority: 2, targets: 1 },
        { width: '50px', targets: 10 },
        { responsivePriority: 1, targets: 10 }
    ]
});

const tableResponsablesEstructuraDepartamental = new DataTable('#tblResponsablesEstructuraDepartamental', {
    order: [[3, 'asc'], [2, 'asc'], [1, 'asc']],
    paging: false
});

let pondImportarGuiaRemision;
let pondPDFProveedor;

$(function () {
    FilePond.registerPlugin(FilePondPluginFileValidateType);
    
});

/* FUNCIONES GENERALES */

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES GUÍA REMISIÓN */

/* ------------------------------- */

$(document).on('submit', '.formularioImportarGuiaRemision', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondImportarGuiaRemision.getFiles();
    
    if (pondFiles.length === 0) {
        Swal.fire({
            text: "Debe adjuntar la plantilla a subir.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('itemsFile', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('click', '#btnExportarGuiaRemision', function() {
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    window.open(baseUrl+"/exportar-guia-remision/",'_blank');
    
    Swal.close();
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES ANULACIONES  */

/* ------------------------------- */

$(document).on('click', '#btnSolicitarAnulacionGuiaRemision', function(event) {
    let modal = $(this).data("bs-target");
    
    $("#cboMotivoAnulacion_sagr").select2({
        dropdownParent: $('#modal-solicitar-anulacion .modal-body')
    });
    
    $(modal).modal("show");
});

/* ------------------------------- */

$('#chkAnulacionTotalPagina').on('change', function() {
    var isChecked = $(this).prop('checked');
    
    // Marca o desmarca todos los checkboxes en la columna (sólo visibles)
    $('#tblAnulacionesGuiaRemision tbody input:checkbox').each(function() {
        if ($(this).closest('tr').is(':visible')) {  // Solo afecta a las filas visibles
            $(this).prop('checked', isChecked);
        }
    });
});

/* ------------------------------- */

// Función para actualizar el estado del checkbox principal
function actualizarEstadoCheckboxCabeceraAnulacionGuiaRemision() {
    var allChecked = true;
    
    // Recorremos todas las filas visibles de la página actual
    $('#tblAnulacionesGuiaRemision').DataTable().rows({ page: 'current' }).every(function() {
        var row = this.node();
        // Recorre los checkboxes de la fila actual
        $(row).find('input.chkAnulacionMasivaGR').each(function() {
            if (!$(this).prop('checked')) {
                allChecked = false;
            }
        });
    });
    
    // Si todos los checkboxes visibles están seleccionados, marca el checkbox de la cabecera, si no, desmárcalo
    $('#chkAnulacionTotalPagina').prop('checked', allChecked);
}

/* ------------------------------- */

// Evento cuando se selecciona o deselecciona un checkbox en una fila
$('#tblAnulacionesGuiaRemision tbody').on('change', 'input.chkAnulacionMasivaGR', function() {
    // Si alguno de los checkboxes en las filas visibles no está seleccionado, desmarcar el checkbox de la cabecera
    actualizarEstadoCheckboxCabeceraAnulacionGuiaRemision();
});

/* ------------------------------- */

// Escuchamos el evento 'draw' que se dispara cada vez que se redibuja la tabla
$('#tblAnulacionesGuiaRemision').on('draw.dt', function() {
    // Actualizamos el estado del checkbox principal después de cada redibujo
    actualizarEstadoCheckboxCabeceraAnulacionGuiaRemision();
});

/* ------------------------------- */

$(document).on('click', '#btnCambioEstadoMasivoAnulaciones', function(event) {
    let modal = $(this).data("bs-target");
    $("#ctnGuiasAnular").empty();
    
    var anulacionesSeleccionados = $('.chkAnulacionMasivaGR:checked');
    
    if (anulacionesSeleccionados.length > 0) {
        
        $("#cboEstado_cemagr").select2({
            dropdownParent: $('#modal-estado-anulaciones .modal-body')
        });
        
        var inputSeleccionados = '';
        var dataGuiaSeleccionados = [];
        
        // Recorremos todos los checkboxes seleccionados
        anulacionesSeleccionados.each(function() {
            // Agregamos el valor de 'data-guia' de cada checkbox seleccionado al array
            dataGuiaSeleccionados.push($(this).data('guia'));
            inputSeleccionados += '<input type="hidden" name="solicitudesAnulacion[]" value="'+$(this).val()+'">';
        });
        
        // Unimos los valores de 'data-guia' en un string separado por comas
        var listadoGuiasAnuladas = dataGuiaSeleccionados.join(" | ");
        
        $("#ctnGuiasAnular").html(inputSeleccionados + listadoGuiasAnuladas);
        
        $(modal).modal("show");
    } else {
        // Si no hay checkboxes seleccionados, mostramos un alert
        Swal.fire({
            title: 'No hay anulaciones seleccionadas.',
            icon: 'warning',
            showCancelButton: false,
            confirmButtonColor: '#008F39',
            confirmButtonText: 'OK'
        });
    }
    
});

/* ------------------------------- */

$(document).on('click', '#exportarOrdenCompra', function(event) {
    let fechaInicio = $("#fechaInicio").val();
    let fechaFin = $("#fechaFin").val();
    
    if(fechaInicio == '')
    {
        Swal.fire({
            html: 'Debe seleccionar una fecha de inicio.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(fechaFin == '')
    {
        Swal.fire({
            html: 'Debe seleccionar una fecha de fin.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else 
    {
        window.open(baseUrl+"/exportar-orden-compra/"+fechaInicio+"/"+fechaFin,'_blank');
    }
    
});

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES BANCO */

/* ------------------------------- */

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES REFERIDOS */

function recargarTipoReferido(Tipo)
{
    //Recargamos Informaci贸n General
    $('#txtTipoReferido_ic').val(Tipo);
    
}

/* ------------------------------- */
function agregarReferido()
{
    var random = generarRandom(5);
    
    var auxPrimerNombre     = $("#auxPrimerNombre").val();
    var auxPrimerApellido   = $("#auxPrimerApellido").val();
    var auxTelefono         = $("#auxTelefono").val();
    var auxSegmento         = $('#auxSegmento option:selected').val();
    var auxComentario       = $("#auxComentario").val();
    
    
    if(auxPrimerNombre == '')
    {
        Swal.fire({
            html: 'Debe ingresar los nombres.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(auxPrimerApellido == '')
    {
        Swal.fire({
            html: 'Debe ingresar los apellidos.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(auxTelefono == '')
    {
        Swal.fire({
            html: 'Debe ingresar el t茅lefono.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(auxSegmento == '')
    {
        Swal.fire({
            html: 'Debe ingresar segmento.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else 
    {
        
        
        let contenedor = `<div class="row col-12 m-0 my-2 p-0 border-sistema-2px" id="iRef${random}" style="border-radius: 10px;">
    		<div class="col-1 m-0 p-2 d-flex align-items-center justify-content-center">
    			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico('iRef${random}');" data-tooltip="tooltip" aria-label="Eliminar Referido">
                    <i class="mdi mdi-trash-can" style="font-size: 15px; color: #FFF"></i>
                </button>
    		</div>        
    		<div class="col-2 m-0 p-2">
    			<div>
    			    <input type="hidden" name="correlativo[]" value="`+random+`">
    				<input type="text" class="form-control campoReadOnly" value="`+auxPrimerNombre+`" name="auxPrimerNombreiRef[${random}]" readonly>
    			</div>
    		</div>
    		<div class="col-2 m-0 p-2">
    			<div>
    				<input type="text" class="form-control campoReadOnly" data-random="`+random+`" value="`+auxPrimerApellido+`" name="auxPrimerApellidoiRef[${random}]" readonly>
    			</div>
    		</div>
    		<div class="col-2 m-0 p-2">
    		    <input type="text" class="form-control campoReadOnly" data-random="`+random+`" value="`+auxTelefono+`" name="auxTelefonoiRef[${random}]" readonly>
    		</div>
    		<div class="col-2 m-0 p-2">
    		    <input type="text" class="form-control campoReadOnly" data-random="`+random+`" value="`+auxSegmento+`" name="auxSegmentoiRef[${random}]" readonly>
    		</div>
    		<div class="col-3 m-0 p-2 d-flex align-items-center justify-content-center">
    			<textarea type="text" class="form-control campoReadOnly" data-random="`+random+`" rows="1" name="auxComentarioiRef[${random}]" readonly>`+auxComentario+`</textarea>
    		</div>
    	</div>`;
    
        $("#ctnDetalleiRef").append(contenedor);
        
        $("#auxPrimerNombre").val("");
        $("#auxPrimerApellido").val("");
        $("#auxTelefono").val("");
        $("#auxSegmento").val("");
        $("#auxComentario").val("");
        
        
    }
}
/* ------------------------------- */
$(document).on('submit', '.formularioRegistrarReferido', function(event) {
    
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    var formData = new FormData(this);
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        dataType: 'json',
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            if(response.popup)
            {
                Swal.fire({
                    text: response.mensaje1,
                    icon: 'warning',
                    showCancelButton: false,
                    cancelButtonText: 'No',
                    confirmButtonColor: '#282e38',
                    confirmButtonText: 'OK'
                });
            }
            else
            {
                formulario.find('.respuesta').html(response.mensaje1);
            }
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: 'No tienes los permisos requeridos. Por favor, ponte en contacto con desarrollo@verisure.pe',
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    return false;
    
    
});
/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */
