<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
                                <button type="button" class="btn bg-sistema color-white px-2 py-1 mx-1" id="btnGuardarComprobantesValidados">
                                    <i class="mdi mdi-content-save me-1" style="font-size: 14px;"></i>Guardar
                                </button>
								<a href="<?= $baseUrl.'/'.$previo ?>" class="btn px-2 py-0 d-flex justify-content-end align-items-center" style="background-color: red;">
								    <i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i>
								</a>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblComprobantesOrdenCompraPendientesValidacion" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Nro OC</th>
										<th class="text-center align-middle">Proveedor</th>
										<th class="text-center align-middle">Concepto</th>
										<th class="text-center align-middle">Monto Total</th>
										<th class="text-center align-middle">Comprobante</th>
										<th class="text-center align-middle">Fecha de Subida</th>
										<th class="text-center align-middle">¿Válido?</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($comprobantes as $items)
									{ 
									    $fechaCreacion = ($items['FechaCrea'] != '' && $items['FechaCrea'] != null ? $items['FechaCrea'] : $items['FechaCreaProveedor'] );
									?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDOrdenCompra'] ?></td>
										<td class="text-center align-middle"><?= $items['Proveedor'] ?></td>
										<td class="text-center align-middle"><?= $items['Concepto'] ?></td>
										<td class="text-center align-middle"><?= $moneda[$items['TipoMoneda']]['SIMBOLO'].' '.$items['Total'] ?></td>
										<td class="text-center align-middle">
										    <!--<button type="button" class="btn btn-success btn-label waves-effect waves-light"><i class="ri-check-double-line label-icon align-middle fs-16 me-2"></i> Success</button>-->
										    <a class='btn bg-secondary btn-label waves-effect waves-light border-0 mx-1 texto-indicador' style="color: #FFF" href='<?= $ficheroProveedor.'/public/files/OrdenCompra/Comprobantes/'.date("Y", strtotime($fechaCreacion)).'/'.date("m", strtotime($fechaCreacion)).'/OC'.$items["IDOrdenCompra"].'-'.$items["IDComprobanteOC"].'.'.$items["Extension"] ?>' download='<?= $items["NombreComprobante"].".".$items["Extension"] ?>'>
    									        <i class="mdi mdi-tray-arrow-down label-icon align-middle me-1" style="font-size: 14px;"></i><?= $items["NombreComprobante"] ?>
    									    </a>
										</td>
										<td class="text-center align-middle"><span class="d-none"><?= date("YmdHis", strtotime($fechaCreacion)) ?></span><?= date("Y-m-d", strtotime($fechaCreacion)) ?></td>
										<td class="text-center align-middle">
                                            <div class="hstack gap-2 flex-wrap justify-content-center">
                                                <input type="radio" class="btn-check" name="<?= $items['IDComprobanteOC'] ?>" id="success-outlined<?= $items['IDComprobanteOC'] ?>" value="Y" <?= $items['ComprobanteValido'] == "Y" ? "checked" : "" ?> >
                                                <label class="btn btn-outline-success" for="success-outlined<?= $items['IDComprobanteOC'] ?>">Si</label>
                                            
                                                <input type="radio" class="btn-check" name="<?= $items['IDComprobanteOC'] ?>" id="danger-outlined<?= $items['IDComprobanteOC'] ?>" value="N" <?= $items['ComprobanteValido'] == "N" ? "checked" : "" ?>>
                                                <label class="btn btn-outline-danger" for="danger-outlined<?= $items['IDComprobanteOC'] ?>">No</label>
                                            </div>
										    <!--<button type="button" class="btn bg-warning color-white px-2 py-1 mx-1 validar-comprobante-oc" data-bs-target="#validarComprobanteOC" data-comprobante="<?= $items['IDComprobanteOC'] ?>" data-oc ="<?= $items['IDOrdenCompra'] ?>">-->
              <!--                  				<i class="mdi mdi-clock-outline me-1" style="font-size: 14px;"></i>Pendiente-->
              <!--                  			</button>-->
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<!-- Modal Adjuntar Validación -->
<div class="modal fade zoomIn" id="validarComprobanteOC" data-bs-backdrop="static" role="dialog" aria-labelledby="examplevalidarComprobanteOC" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplevalidarComprobanteOC">Validar Comprobante de OC</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formValidarComprobante" class="formulario" action="<?= $baseUrl ?>/validacion-comprobante-oc" method="POST" enctype="multipart/form-data" autocomplete="off" accept-charset="utf-8">
				
				<div class="modal-body pb-0">
				    <input type="hidden" id="txtIDOrdenCompra_vcoc" name="txtIDOrdenCompra_vcoc">
				    <input type="hidden" id="txtIDComprobanteOC_vcoc" name="txtIDComprobanteOC_vcoc">
					<h3 class="mb-3">Orden de Compra</h3>
    			    <div class="row m-0 p-0 mb-3">
    					<div class="col-xxl-8 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtNroOrdenCompra" class="form-label color-sistema">Nro Orden de Compra</label>
    							<input type="text" class="form-control color-sistema border-sistema-2px" id="txtNroOrdenCompra" name="txtNroOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-12 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtConceptoOrdenCompra" class="form-label">Concepto</label>
    							<input type="text" class="form-control" id="txtConceptoOrdenCompra" name="txtConceptoOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-12 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtProveedorOrdenCompra" class="form-label">Proveedor</label>
    							<input type="text" class="form-control" id="txtProveedorOrdenCompra" name="txtProveedorOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-6 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtFechaEmisionOrdenCompra" class="form-label">Fecha Emisión</label>
    							<input type="date" class="form-control" id="txtFechaEmisionOrdenCompra" name="txtFechaEmisionOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-6 col-md-12 col-12 mb-3">
    					    <label for="txtMontoTotalOrdenCompra" class="form-label">Monto Total</label>
    						<div class="input-group">
                                <span class="input-group-text" id="spnSimboloMontoOrdenCompra">S/</span>
                                <input type="number" step="0.01" class="form-control" placeholder="Monto Total" id="txtMontoTotalOrdenCompra" name="txtMontoTotalOrdenCompra" aria-label="Monto Total" aria-describedby="basic-addon1" disabled>
                            </div>
    					</div>
    				</div>
    				<hr>
    				<div class="col-xxl-12 col-md-12 col-12 d-flex justify-content-between align-items-center">
        				<h3 class="m-0">Comprobante</h3>
    					<div class="d-flex justify-content-center m-0">
    					    <a class='btn bg-secondary btn-label waves-effect waves-light border-0 mx-1 texto-indicador' style="color: #FFF" id="btnDescargarComprobanteOC" href='' download=''>
    					        <i class="mdi mdi-tray-arrow-down label-icon align-middle me-1" style="font-size: 14px;"></i>Descargar Comprobante
    					    </a>
    					</div>
    				</div>
    				<hr>
    				<h3 class="mb-3">Validación</h3>
					<div class="col-12 col-md-12 justify-content-end mb-3">
						<div class="col-xxl-12 col-md-12 col-12 border-sistema-2px p-2 d-flex justify-content-between align-items-center" style="border-radius: 5px;">
						    <h5 class="color-sistema m-0" for="chkComprobanteValido_vcoc">¿Comprobante Válido?</h5>
						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkComprobanteValido_vcoc">
								<input class="form-check-input form-check-input-sistema" type="checkbox" role="switch" name="chkComprobanteValido_vcoc" id="chkComprobanteValido_vcoc">
								<label class="form-check-label m-0" for="chkComprobanteValido_vcoc"></label>
							</div>
						</div>
					</div>
    				<div class="col-12 mb-0 d-flex justify-content-center mb-3">
                        <div class="col-12 form-group">
                            <label for="txtObservacion_vcoc">Observaciones</label>
                            <textarea class="form-control" id="txtObservacion_vcoc" name="txtObservacion_vcoc" placeholder="Ingrese observaciones" rows="4"></textarea>
                        </div>
                    </div>
    				<hr class="m-0">
    				<span class="row col-12 m-0 py-2 justify-content-center respuesta"></span>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-content-save me-2 color-white" style="font-size: 14px;"></i>Registrar Validación</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>