<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<div class="row">
                <div class="col-lg-12">
                    <div class="card mt-n4 mx-n4 mb-n5">
                        <div class="bg-sistema-50 color-white">
                            <div class="card-body pb-4 mb-5">
                                <div class="row">
                                    <div class="col-md">
                                        <div class="row align-items-center px-3">
                                            <div class="col-md">
                                                <h4 class="fw-semibold color-white" id="ticket-title">#<?= $ordenCompra['IDOrdenCompra'] ?> - <?= $ordenCompra['Concepto'] ?></h4>
                                                <div class="hstack gap-3 flex-wrap">
                                                    <div class="text-muted color-white">Fecha de Pedido : <span class="fw-medium"><?= date("d-m-Y", strtotime($ordenCompra['FechaPedido'])) ?></span></div>
                                                    <div class="vr"></div>
                                                </div>
                                            </div>
                                            <!--end col-->
                                        </div>
                                        <!--end row-->
                                    </div>
                                    <!--end col-->
                                    <div class="col-md-auto mt-md-0 mt-4 d-flex justify-content-end align-items-center">
                                        <div class="hstack gap-1 flex-wrap">
                                            <!--<button type="button" class="btn bg-crea px-2 py-1">-->
                                            <!--    <i class="" style="font-size: 24px; color: #FFF"></i>-->
                                            <!--</button>-->
                                            <?php
                                            if(in_array("ADCOOC", $permisos) && empty($comprobantes))
                                            {
                                            ?>
                                            <button type="button" class="btn bg-success color-white px-2 py-1 mx-1" data-bs-target="#adjuntarFacturasOC" data-oc="<?= $ordenCompra['IDOrdenCompra'] ?>" id="btnAdjuntarComprobantesOC">
                								<i class="mdi mdi-plus-circle m-0" style="font-size: 24px;"></i>
                							</button>
                                            <?php
                                            }
                                            
                                            if(in_array("APCOOC", $permisos))
                                            {
                                            ?>
                                            <button type="button" class="btn bg-sistema color-white px-2 py-1 mx-1" id="btnGuardarComprobantesValidados">
                                                <i class="mdi mdi-content-save m-0" style="font-size: 24px;"></i>
                                            </button>
                                            <?php
                                            }
                                            ?>
                                            <a href="<?= $baseUrl.'/'.$previo ?>" class="btn bg-red-verisure-50 color-white px-2 py-1 mx-1" data-tooltip="tooltip" title="Volver">
                                                <i class="mdi mdi-arrow-left-circle color-white" style="font-size: 24px;"></i>
                                            </a>
                                        </div>
                                    </div>
                                    <!--end col-->
                                </div>
                                <!--end row-->
                            </div><!-- end card body -->
                        </div>
                    </div><!-- end card -->
                </div><!-- end col -->
            </div><!-- end row -->

            <div class="row">
                <div class="col-xxl-8">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Comprobantes</h5>
                        </div>
                        <div class="row card-body m-0 p-0">
                            <?php 
							foreach($comprobantes as $items)
							{ 
							    $fechaCreacion = ($items['FechaCrea'] != '' && $items['FechaCrea'] != null ? $items['FechaCrea'] : $items['FechaCreaProveedor'] );
							?>
							<div class="col-6 p-3">
                                <div class="card border-sistema-25">
                                    <div class="card-header">
                                        <h5 class="card-title mb-0 fw-bold"><?= strtoupper($items['Extension']) ?></h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="col-xxl-12">
                                            <h5 class="mb-3"><?= $items['Creador'] ?></h5>
                                            <div class="border rounded border-dashed p-2 <?= ($items['ComprobanteValido'] == "Y" ? "bg-green-25" : ($items['ComprobanteValido'] == "N" ? "bg-red-25" : "bg-orange-25")) ?>">
                                                <div class="d-flex align-items-center">
                                                    <div class="flex-shrink-0 me-3">
                                                        <div class="avatar-sm">
                                                            <div class="avatar-title bg-light text-secondary rounded fs-24">
                                                                <i class="<?= $items['Extension'] == "xml" ? "mdi mdi-xml" : "mdi mdi-file-pdf-box" ?>"></i>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="flex-grow-1 overflow-hidden">
                                                        <h5 class="fs-13 mb-1"><a class="fw-bold text-body text-truncate d-block" href="<?= base_url().'/public/files/OrdenCompra/Comprobantes/'.date("Y", strtotime($fechaCreacion)).'/'.date("m", strtotime($fechaCreacion)).'/OC'.$items["IDOrdenCompra"].'-'.$items["IDComprobanteOC"].'.'.$items["Extension"] ?>" download='<?= $items["Nombre"].".".$items["Extension"] ?>'><?= $items['Nombre'].'.'.$items['Extension'] ?></a></h5>
                                                        <div><?= date("Y-m-d", strtotime($fechaCreacion)) ?></div>
                                                    </div>
                                                    <div class="flex-shrink-0 ms-2">
                                                        <div class="d-flex gap-1">
                                                            <a class="btn btn-icon bg-white color-black text-muted btn-sm fs-18" href="<?= base_url().'/public/files/OrdenCompra/Comprobantes/'.date("Y", strtotime($fechaCreacion)).'/'.date("m", strtotime($fechaCreacion)).'/OC'.$items["IDOrdenCompra"].'-'.$items["IDComprobanteOC"].'.'.$items["Extension"] ?>" download='<?= $items["Nombre"].".".$items["Extension"] ?>'>
                                                                <i class="ri-download-2-line"></i>
                                                            </a>
                                                            <button type="button" class="btn btn-icon bg-white text-muted btn-sm fs-18" style="cursor: default;">
                                                                <i class="<?= $items['ComprobanteValido'] == "Y" ? "mdi mdi-check-bold color-green" : ($items['ComprobanteValido'] == "N" ? "mdi mdi-minus-thick color-red" : "mdi mdi-clock-outline color-orange") ?>"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <div class="d-flex">
                                            <?php
                                            if($items['ComprobanteValido'] == "Y")
                                            {
                                            ?>
                                            <div class="flex-grow-1 d-flex align-items-center">
                                                <h6 class="mb-0 color-green"><?= $items['Validador'] ?></h6>
                                            </div>
                                            <!--<button type="button" class="btn btn-icon bg-white text-muted btn-sm fs-18" style="cursor: default;">-->
                                            <!--    <i class="<?= $items['ComprobanteValido'] == "Y" ? "mdi mdi-check-bold color-green" : ($items['ComprobanteValido'] == "N" ? "mdi mdi-minus-thick color-red" : "mdi mdi-clock-outline color-orange") ?>"></i>-->
                                            <!--</button>-->
                                            <h6 class="flex-shrink-0 text-success mb-0"><?= date("Y-m-d", strtotime($items['FechaValidacion'])) ?></h6>
                                            <?php
                                            }
                                            else if($items['ComprobanteValido'] == "N")
                                            {
                                            ?>
                                            <div class="flex-grow-1 d-flex align-items-center">
                                                <h6 class="mb-0 color-red"><?= $items['Validador'] ?></h6>
                                            </div>
                                            <h6 class="flex-shrink-0 color-red mb-0"><?= date("Y-m-d", strtotime($items['FechaValidacion'])) ?></h6>
                                            <!--<button type="button" class="btn btn-icon bg-white text-muted btn-sm fs-18" style="cursor: default;" id="btnReemplazar()">-->
                                            <!--    <i class="mdi mdi-file-replace"></i>-->
                                            <!--</button>-->
                                            <!--<h6 class="flex-shrink-0 text-danger mb-0"><?= date("Y-m-d", strtotime($items['FechaValidacion'])) ?></h6>-->
                                            <?php
                                            }
                                            else
                                            {
                                            ?>
                                            <div class="flex-grow-1 d-flex align-items-center">
                                                <h6 class="mb-0 color-orange">¿Válido?</h6>
                                            </div>
                                            <div class="ctnValidacionComprobante flex-shrink-0 mb-0 justify-content-center">
                                                <input type="radio" class="btn-check" name="<?= $items['IDComprobanteOC'] ?>" id="success-outlined<?= $items['IDComprobanteOC'] ?>" value="Y" <?= $items['ComprobanteValido'] == "Y" ? "checked" : "" ?> >
                                                <label class="btn btn-icon btn-outline-success m-0" for="success-outlined<?= $items['IDComprobanteOC'] ?>">Si</label>
                                            
                                                <input type="radio" class="btn-check" name="<?= $items['IDComprobanteOC'] ?>" id="danger-outlined<?= $items['IDComprobanteOC'] ?>" value="N" <?= $items['ComprobanteValido'] == "N" ? "checked" : "" ?>>
                                                <label class="btn btn-icon btn-outline-danger m-0" for="danger-outlined<?= $items['IDComprobanteOC'] ?>">No</label>
                                            </div>
                                            <!--<h6 class="flex-shrink-0 color-orange mb-0"><i class="mdi mdi-timer-sand"></i></h6>-->
                                            <!--<button type="button" class="btn btn-icon bg-white text-muted btn-sm fs-18" style="cursor: default;">-->
                                            <!--    <i class="mdi mdi-timer-sand"></i>-->
                                            <!--</button>-->
                                            <!--<h6 class="flex-shrink-0 text-danger mb-0"><?= date("Y-m-d", strtotime($items['FechaValidacion'])) ?></h6>-->
                                            <?php
                                            }
                                            ?>
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
							<?php 
							}
							?>
                        </div>
                    </div>
                </div>
                <!--end col-->
                <div class="col-xxl-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Orden de Compra</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive table-card">
                                <table class="table table-borderless align-middle mb-0">
                                    <tbody>
                                        <tr>
                                            <td class="fw-medium">Orden de Compra</td>
                                            <td>#<?= $ordenCompra['IDOrdenCompra'] ?></td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Concepto</td>
                                            <td id="t-client" class="d-flex align-items-center">
                                                <?= $ordenCompra['Concepto'] ?>
                                            </td>
                                        </tr>
                                        <tr class="">
                                            <td class="fw-medium">CC</td>
                                            <td><?= $ordenCompra['CC'] ?></td>
                                        </tr>
                                        <tr class="">
                                            <td class="fw-medium">LN</td>
                                            <td><?= $ordenCompra['LN'] ?></td>
                                        </tr>
                                        <tr class="">
                                            <td class="fw-medium">Dirección</td>
                                            <td><?= $ordenCompra['Direccion'] ?></td>
                                        </tr>
                                        <tr class="">
                                            <td class="fw-medium">Área</td>
                                            <td><?= $ordenCompra['Area'] ?></td>
                                        </tr>
                                        <tr class="">
                                            <td class="fw-medium">Subárea</td>
                                            <td><?= $ordenCompra['Subarea'] ?></td>
                                        </tr>
                                        <tr class="">
                                            <td class="fw-medium">Nro Factura</td>
                                            <td><?= $ordenCompra['NroFactura'] ?></td>
                                        </tr>
                                        <tr class="">
                                            <td class="fw-medium">Fecha Emisión Factura</td>
                                            <td><?= $ordenCompra['FechaEmisionFactura'] != '' && $ordenCompra['FechaEmisionFactura'] != null ? date("Y-m-d", strtotime($ordenCompra['FechaEmisionFactura'])) : "" ?></td>
                                        </tr>
                                        <tr class="">
                                            <td class="fw-medium">Moneda</td>
                                            <td><?= $ordenCompra['TipoMoneda'] != '' && $ordenCompra['TipoMoneda'] != null ? $moneda[$ordenCompra['TipoMoneda']]['NOMBRE'].' ('.$moneda[$ordenCompra['TipoMoneda']]['SIMBOLO'].')' : '' ?></td>
                                        </tr>
                                        <tr class="">
                                            <td class="fw-medium">Total</td>
                                            <td><?= $ordenCompra['Total'] ?></td>
                                        </tr>
                                        <tr class="">
                                            <td class="fw-medium">Cuenta Contable</td>
                                            <td><?= $ordenCompra['CodigoCuentaContable'].' | '.$ordenCompra['CuentaContable'].' '.$ordenCompra['Categoria'].' '.$ordenCompra['Subcategoria'] ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!--end card-body-->
                    </div>
                    <!--end card-->
                </div>
                <!--end col-->
            </div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<!-- Modal Adjuntar Comprobante XML -->
<!--<div class="modal fade zoomIn" id="reemplazarComprobantexml" data-bs-backdrop="static" role="dialog" aria-labelledby="examplereemplazarComprobantexml" aria-hidden="true">-->
<!--	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">-->
<!--		<div class="modal-content" style="border: none;">-->
<!--			<div class="modal-header bg-sistema p-3">-->
<!--				<h5 class="modal-title color-white" id="examplereemplazarComprobantexml">Adjuntar XML</h5>-->
<!--				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>-->
<!--			</div>-->
<!--			<form id="formReemplazarComprobanteXML" class="formularioReemplazarComprobanteXML" action="<?= $baseUrl ?>/reemplazar-comprobante-orden-compra" method="POST" enctype="multipart/form-data" autocomplete="off" accept-charset="utf-8">-->
				
<!--				<div class="row modal-body">-->
<!--				    <input type="hidden" class="txtIDComprobanteOC_rfoc" id="txtIDComprobanteOC_rfoc" name="txtIDComprobanteOC_rfoc">-->
					
<!--    				<h3 class="mb-3">Comprobantes</h3>-->
<!--    				<div class="col-xxl-12 col-lg-12 d-flex justify-content-center">-->
<!--                        <div class="col-8 card card-height-100 border-sistema-2px px-3">-->
<!--                            <div class="card-header align-items-center d-flex">-->
<!--                                <h4 class="card-title mb-0 flex-grow-1 text-center">XML</h4>-->
<!--                            </div><!-- end card header -->-->
<!--                            <hr class="m-0 p-0">-->
<!--                            <div class="card-body p-0 m-0 pt-3 d-flex justify-content-center">-->
<!--                                <div class="col-12 m-0 p-0">-->
<!--        					        <input type="file" id="txtXMLOC_poc" class="filepond" name="txtXMLOC_poc" data-max-file-size="100MB" data-max-files="1" />-->
<!--        					    </div>-->
<!--                            </div><!-- end cardbody -->-->
<!--                        </div><!-- end card -->-->
<!--                    </div>-->
<!--    				<hr class="m-0">-->
<!--    				<span class="row col-12 m-0 py-2 justify-content-center respuesta"></span>-->
<!--				</div>-->
<!--				<div class="modal-footer">-->
<!--					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>-->
<!--					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-file-upload me-2 color-white" style="font-size: 14px;"></i>Importar</button>-->
<!--				</div>-->
<!--			</form>-->
<!--		</div>-->
<!--	</div>-->
<!--</div>-->

<!-- Modal Adjuntar Comprobante PDF -->
<!--<div class="modal fade zoomIn" id="reemplazarComprobantepdf" data-bs-backdrop="static" role="dialog" aria-labelledby="examplereemplazarComprobantepdf" aria-hidden="true">-->
<!--	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">-->
<!--		<div class="modal-content" style="border: none;">-->
<!--			<div class="modal-header bg-sistema p-3">-->
<!--				<h5 class="modal-title color-white" id="examplereemplazarComprobantepdf">Adjuntar PDF</h5>-->
<!--				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>-->
<!--			</div>-->
<!--			<form id="formReemplazarComprobantePDF" class="formularioReemplazarComprobantePDF" action="<?= $baseUrl ?>/reemplazar-comprobante-orden-compra" method="POST" enctype="multipart/form-data" autocomplete="off" accept-charset="utf-8">-->
				
<!--				<div class="row modal-body">-->
<!--				    <input type="hidden" class="txtIDComprobanteOC_rfoc" id="txtIDComprobanteOC_rfoc" name="txtIDComprobanteOC_rfoc">-->
					
<!--    				<h3 class="mb-3">Comprobantes</h3>-->
<!--    				<div class="col-xxl-12 col-lg-12 d-flex justify-content-center">-->
<!--                        <div class="card card-height-100 border-sistema-2px px-3">-->
<!--                            <div class="card-header align-items-center d-flex">-->
<!--                                <h4 class="card-title mb-0 flex-grow-1 text-center">PDF</h4>-->
<!--                            </div><!-- end card header -->-->
<!--                            <hr class="m-0 p-0">-->
<!--                            <div class="card-body p-0 m-0 pt-3 d-flex justify-content-center">-->
<!--                                <div class="col-12 m-0 p-0">-->
<!--        					        <input type="file" id="txtPDFOC_poc" class="filepond" name="txtPDFOC_poc" data-max-file-size="100MB" data-max-files="1" />-->
<!--        					    </div>-->
<!--                            </div><!-- end cardbody -->-->
<!--                        </div><!-- end card -->-->
<!--                    </div>-->
<!--    				<hr class="m-0">-->
<!--    				<span class="row col-12 m-0 py-2 justify-content-center respuesta"></span>-->
<!--				</div>-->
<!--				<div class="modal-footer">-->
<!--					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>-->
<!--					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-file-upload me-2 color-white" style="font-size: 14px;"></i>Importar</button>-->
<!--				</div>-->
<!--			</form>-->
<!--		</div>-->
<!--	</div>-->
<!--</div>-->

<!-- Modal Adjuntar Validación -->
<div class="modal fade zoomIn" id="adjuntarFacturasOC" data-bs-backdrop="static" role="dialog" aria-labelledby="exampleadjuntarFacturasOC" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleadjuntarFacturasOC">Adjuntar Factura</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formAdjuntarFacturaOC" class="formularioAdjuntarFacturaOC" action="<?= $baseUrl ?>/adjuntar-factura-orden-compra" method="POST" enctype="multipart/form-data" autocomplete="off" accept-charset="utf-8">
				
				<div class="row modal-body">
				    <input type="hidden" id="txtIDOrdenCompra_rfoc" name="txtIDOrdenCompra_rfoc">
					<!--<h3 class="mb-3">Orden de Compra</h3>-->
    			    <!--<div class="row m-0 mb-3">-->
    					<div class="col-xxl-8 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtNroOrdenCompra" class="form-label" style="color: #0A497B;">Nro Orden de Compra</label>
    							<input type="text" class="form-control" style="color: #0A497B; border-color: #0A497B;" id="txtNroOrdenCompra" name="txtNroOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-12 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtConceptoOrdenCompra" class="form-label">Concepto</label>
    							<input type="text" class="form-control" id="txtConceptoOrdenCompra" name="txtConceptoOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-12 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtProveedorOrdenCompra" class="form-label">Proveedor</label>
    							<input type="text" class="form-control" id="txtProveedorOrdenCompra" name="txtProveedorOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-6 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtFechaEmisionOrdenCompra" class="form-label">Fecha Emisión</label>
    							<input type="date" class="form-control" id="txtFechaEmisionOrdenCompra" name="txtFechaEmisionOrdenCompra" disabled>
    						</div>
    					</div>
    					<div class="col-xxl-6 col-md-12 col-12 mb-3">
    					    <label for="txtMontoTotalOrdenCompra" class="form-label">Monto Total</label>
    						<div class="input-group">
                                <span class="input-group-text" id="spnSimboloMontoOrdenCompra">S/</span>
                                <input type="number" step="0.01" class="form-control" placeholder="Monto Total" id="txtMontoTotalOrdenCompra" name="txtMontoTotalOrdenCompra" aria-label="Monto Total" aria-describedby="basic-addon1" disabled>
                            </div>
    					</div>
    				<!--</div>-->
    				<hr>
    				<h3 class="mb-3">Comprobantes</h3>
    				<div class="col-xxl-6 col-lg-6">
                        <div class="card card-height-100 border-sistema-2px px-3">
                            <div class="card-header align-items-center d-flex">
                                <h4 class="card-title mb-0 flex-grow-1 text-center">XML</h4>
                            </div><!-- end card header -->
                            <hr class="m-0 p-0">
                            <div class="card-body p-0 m-0 pt-3 d-flex justify-content-center">
                                <div class="col-12 m-0 p-0">
        					        <input type="file" id="txtXMLOC_poc" class="filepond" name="txtXMLOC_poc" data-max-file-size="100MB" data-max-files="1" />
        					    </div>
                            </div><!-- end cardbody -->
                        </div><!-- end card -->
                    </div>
    				<div class="col-xxl-6 col-lg-6">
                        <div class="card card-height-100 border-sistema-2px px-3">
                            <div class="card-header align-items-center d-flex">
                                <h4 class="card-title mb-0 flex-grow-1 text-center">PDF</h4>
                            </div><!-- end card header -->
                            <hr class="m-0 p-0">
                            <div class="card-body p-0 m-0 pt-3 d-flex justify-content-center">
                                <div class="col-12 m-0 p-0">
        					        <input type="file" id="txtPDFOC_poc" class="filepond" name="txtPDFOC_poc" data-max-file-size="100MB" data-max-files="1" />
        					    </div>
                            </div><!-- end cardbody -->
                        </div><!-- end card -->
                    </div>
    				<hr class="m-0">
    				<span class="row col-12 m-0 py-2 justify-content-center respuesta"></span>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-file-upload me-2 color-white" style="font-size: 14px;"></i>Importar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<?= $this->section('js'); ?>
<script>
	$(function () {
		pondXMLProveedor = FilePond.create(
            document.querySelector("#txtXMLOC_poc"), {
                labelIdle: 'Arrastre y suelte el XML asociado a la OC o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/xml', 'application/xml'],
                onaddfile: (file) => {
                    // Validación manual por extensión
                    const allowedExtensions = /(\.xml)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser XML.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondXMLProveedor.removeFile(file.id);
                        return false; // Detener el envío del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
		pondPDFProveedor = FilePond.create(
            document.querySelector("#txtPDFOC_poc"), {
                labelIdle: 'Arrastre y suelte el PDF asociado a la OC o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['application/pdf'],
                onaddfile: (file) => {
                    // Validación manual por extensión
                    const allowedExtensions = /(\.pdf)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser PDF.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondPDFProveedor.removeFile(file.id);
                        return false; // Detener el envíodel archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
	});
</script>
<?php $this->endSection(); ?>
<?php $this->endSection(); ?>