<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- Main content -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<section class="content">
                	<div class="container">
                		<div class="row justify-content-center">
                			<div class="col-12">
                				<form class="formularioGuia" action="<?= $baseUrl ?>/registrar-guia-remision" method="POST">
                					<span class="respuesta"></span>
                					<div class="card border" style="border-top: 3px red solid!important;">
                						<div class="card-header">
                                            <div class="d-flex align-items-center">
                                                <div class="flex-grow-1">
                                                    <h6 class="card-title mb-0">SOLICITANTE</h6>
                                                </div>
                                                <div class="flex-shrink-0">
                                                    <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                                        <li class="list-inline-item">
                                                            <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseSolicitanteGGR" role="button" aria-expanded="true" aria-controls="collapseSolicitanteGGR">
                                                                <i class="mdi mdi-plus align-middle plus"></i>
                                                                <i class="mdi mdi-minus align-middle minus"></i>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                						<div class="card-body collapse show" id="collapseSolicitanteGGR">
                							<div class="form-group row my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">Matrícula del solicitante<span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9">
                									<input type="text" class="form-control rounded-0" id="matricula" name="matricula" placeholder="Matrícula del solicitante" value="<?= $matriculaLog ?>" disabled>
                								</div>
                							</div>
                							<div class="form-group row nombresReceptor d-none my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">Nombres y Apellidos Receptor<span class="text-danger"></span></label>
                								<div class="col-12 col-lg-9">
                									<input type="text" class="form-control rounded-0" id="nombreApellidoReceptor" name="nombreApellidoReceptor" placeholder="">
                								</div>
                							</div>
                							<div class="form-group row my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">Tipo de traslado<span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9">
                									<select class="custom-select rounded-0 selectTraslado" id="tipotraslado" name="tipotraslado">
                										<option value="">Seleccione una opción</option>
                									</select>
                									<input type="hidden" id="MotivoTraslado" name="MotivoTraslado">
                									<input type="hidden" id="DesMotivoTras" name="DesMotivoTras">
                								</div>
                							</div>
                
                							<div class="form-group row my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">Correo de envío <span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9">
            										<input type="email" class="form-control rounded-0" name="correo[]">
            									</div>
                							</div>
                							<div class="form-group row my-3">
                								<div class="col-12 d-flex justify-content-end">
                									<button type="button" class="btn btn-danger" id="btn_agregar" style="border-radius: 40px;">
                									    <i class="mdi mdi-email me-2" style="font-size: 14px;"></i> Agregar Correos
                									</button>
                								</div>
                							</div>
                							<div class="divagregar my-2">
                								
                							</div>
                						</div>
                					</div>
                					<div class="card border" style="border-top: 3px red solid!important;">
                						<div class="card-header">
                							<div class="d-flex align-items-center">
                                                <div class="flex-grow-1">
                                                    <h6 class="card-title mb-0">DESTINO</h6>
                                                </div>
                                                <div class="flex-shrink-0">
                                                    <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                                        <li class="list-inline-item">
                                                            <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseDestinoGGR" role="button" aria-expanded="true" aria-controls="collapseDestinoGGR">
                                                                <i class="mdi mdi-plus align-middle plus"></i>
                                                                <i class="mdi mdi-minus align-middle minus"></i>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                						</div>
                						<div class="card-body collapse show" id="collapseDestinoGGR">
                							<div class="form-group row my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">Fecha de traslado<span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9">
                									<input type="date" class="form-control" id="fechadetraslado" name="fechadetraslado" min="<?php echo date('Y-m-d'); ?>">
                								</div>
                							</div>
                							<div class="card border" style="border-top: 3px red solid!important;">
                								<div class="card-header">
                									<div class="d-flex align-items-center">
                                                        <div class="flex-grow-1">
                                                            <h6 class="card-title mb-0">Punto de partida</h6>
                                                            <h3 class="card-title" id="spanpuntopartida"></h3>
                                                        </div>
                                                        <div class="flex-shrink-0">
                                                            <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                                                <li class="list-inline-item">
                                                                    <a class="align-middle minimize-card collapsed" data-bs-toggle="collapse" href="#collapsePuntoPartidaGGR" role="button" aria-expanded="false" aria-controls="collapsePuntoPartidaGGR">
                                                                        <i class="mdi mdi-plus align-middle plus"></i>
                                                                        <i class="mdi mdi-minus align-middle minus"></i>
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                								</div>
                								<div class="card-body collapse" id="collapsePuntoPartidaGGR">
                									<div class="form-group row my-3">
                										<label for="nombres" class="col-lg-3 fw-bold">Punto de partida<span class="text-danger">*</span></label>
                										<div class="col-12 col-lg-9">
                											<input type="text" class="form-control" id="puntopartida" name="puntopartida" placeholder="Av primavera 1050 santiago de Surco">
                											<input type="hidden" id="idpuntopartida" name="idpuntopartida">
                											<input type="hidden" id="codigoubigeopuntopartida" name="codigoubigeopuntopartida">
                											<input type="hidden" id="codigosunatpartida" name="codigosunatpartida">
                										</div>
                									</div>
                									<div class="form-group row my-3">
                										<label for="nombres" class="col-lg-3 fw-bold">Departamento partida</label>
                										<div class="col-12 col-lg-9">
                											<select class="custom-select rounded-0 select2bs4" id="departamentopartida" name="departamentopartida">
                											</select>
                										</div>
                									</div>
                									<div class="form-group row my-3">
                										<label for="nombres" class="col-lg-3 fw-bold">Provincia partida</label>
                										<div class="col-12 col-lg-9">
                											<select class="custom-select rounded-0 select2bs4" id="provinciapartida" name="provinciapartida">
                											</select>
                										</div>
                									</div>
                									<div class="form-group row my-3">
                										<label for="nombres" class="col-lg-3 fw-bold">Distrito partida</label>
                										<div class="col-12 col-lg-9">
                											<select class="custom-select rounded-0 select2bs4" id="distritopartida" name="distritopartida">
                											</select>
                										</div>
                									</div>
                									
                									<div class="form-group row _delegacionpartida my-3">
                										<label for="nombres" class="col-lg-3 fw-bold">Delegación partida</label>
                										<div class="col-12 col-lg-9">
                											<select class="custom-select rounded-0 select2bs4" id="delegacionpartida" name="delegacionpartida">
                												<option value="">Seleccione una opción</option>
                											</select>
                										</div>
                									</div>									
                								</div>
                							</div>
                
                							<div class="card border _reposicion" style="border-top: 3px red solid!important;">
                								<div class="card-header">
                									<div class="d-flex align-items-center">
                                                        <div class="flex-grow-1">
                                                            <h6 class="card-title mb-0">Punto de llegada</h6>
                                                            <h3 class="card-title" id="spanpuntollegada"></h3>
                                                        </div>
                                                        <div class="flex-shrink-0">
                                                            <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                                                <li class="list-inline-item">
                                                                    <a class="align-middle minimize-card collapsed" data-bs-toggle="collapse" href="#collapsePuntoLlegadaGGR" role="button" aria-expanded="false" aria-controls="collapsePuntoLlegadaGGR">
                                                                        <i class="mdi mdi-plus align-middle plus"></i>
                                                                        <i class="mdi mdi-minus align-middle minus"></i>
                                                                    </a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                								</div>
                								<div class="card-body collapse" id="collapsePuntoLlegadaGGR">
                									<div class="form-group row my-3">
                										<label for="nombres" class="col-lg-3 fw-bold">Punto de llegada<span class="text-danger">*</span></label>
                										<div class="col-12 col-lg-9">
                											<input type="text" class="form-control rounded-0" id="puntollegada" name="puntollegada" placeholder="Av primavera 1050 santiago de Surco">
                											<input type="hidden" id="idpuntollegada" name="idpuntollegada">
                											<input type="hidden" id="codigoubigeopuntollegada" name="codigoubigeopuntollegada">
                											<input type="hidden" id="codigosunatllegada" name="codigosunatllegada">
                
                										</div>
                									</div>
                									<div class="form-group row my-3">
                										<label for="nombres" class="col-lg-3 fw-bold">Departamento llegada</label>
                										<div class="col-12 col-lg-9">
                											<select class="custom-select rounded-0 select2bs4" id="departamentollegada" name="departamentollegada">
                											</select>
                										</div>
                									</div>
                									<div class="form-group row my-3">
                										<label for="nombres" class="col-lg-3 fw-bold">Provincia llegada</label>
                										<div class="col-12 col-lg-9">
                											<select class="custom-select rounded-0 select2bs4" id="provinciallegada" name="provinciallegada">
                											</select>
                										</div>
                									</div>
                									<div class="form-group row my-3">
                										<label for="nombres" class="col-lg-3 fw-bold">Distrito llegada</label>
                										<div class="col-12 col-lg-9">
                											<select class="custom-select rounded-0 select2bs4" id="distritollegada" name="distritollegada">
                											</select>
                										</div>
                									</div>
                									<div class="form-group row _delegacionllegada my-3">
                										<label for="nombres" class="col-lg-3 fw-bold">Delegación llegada</label>
                										<div class="col-12 col-lg-9">
                											<select class="custom-select rounded-0 select2bs4" id="delegacionllegada" name="delegacionllegada">
                												<option value="">Seleccione una opción</option>
                											</select>
                										</div>
                									</div>
                								</div>
                							</div>
                							<div class="form-group row my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">Apellido/Nombre o Razón Social<span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9">
                									<input type="text" class="form-control rounded-0" id="cliente" name="cliente" placeholder="">
                								</div>
                							</div>
                							<div class="form-group row my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">Tipo Documento<span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9">
                									<select class="custom-select rounded-0 select2bs4" id="tipodocumento" name="tipodocumento">
                										<option value="">Seleccione una opción</option>
                									</select>
                								</div>
                							</div>
                							<div class="form-group row my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">Documento<span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9">
                									<input type="text" class="form-control rounded-0" id="documento" name="documento" placeholder="">
                								</div>
                							</div>
                							<div class="form-group row _contrato my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">N° Contrato</label>
                								<div class="col-12 col-lg-9">
                									<input type="text" class="form-control rounded-0" id="contrato" name="contrato" maxlength="7" placeholder="">
                								</div>
                							</div>
                							<div class="form-group row my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">Observación</label>
                								<div class="col-12 col-lg-9">
                									<input type="text" class="form-control rounded-0" id="observacion" name="observacion" placeholder="">
                								</div>
                							</div>
                						</div>
                					</div>
                					<div class="card border" style="border-top: 3px red solid!important;">
                						<div class="card-header">
                						    <div class="d-flex align-items-center">
                                                <div class="flex-grow-1">
                                                    <h6 class="card-title mb-0">DATOS DEL TRANSPORTISTA</h6>
                                                </div>
                                                <div class="flex-shrink-0">
                                                    <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                                        <li class="list-inline-item">
                                                            <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseTransportistaGGR" role="button" aria-expanded="true" aria-controls="collapseTransportistaGGR">
                                                                <i class="mdi mdi-plus align-middle plus"></i>
                                                                <i class="mdi mdi-minus align-middle minus"></i>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                						</div>
                						<div class="card-body collapse show" id="collapseTransportistaGGR">
                
                							<div class="form-group row my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">N° de placa<span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9">
                									<input type="text" class="form-control rounded-0" id="nplaca" name="nplaca" placeholder="">
                								</div>
                							</div>
                							<div class="form-group row my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">Tipo Documento Conductor<span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9">
                									<select class="custom-select rounded-0 select2bs4" id="tipodocumentoconductor" name="tipodocumentoconductor">
                										<option value="">Seleccione una opción</option>
                									</select>
                								</div>
                							</div>
                							<div class="form-group row my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">Documento Conductor<span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9">
                									<input type="text" class="form-control rounded-0" id="documentoconductor" name="documentoconductor" placeholder="">
                								</div>
                							</div>
                							<div class="form-group row my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">Nombre Conductor<span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9">
                									<input type="text" class="form-control rounded-0" id="v" name="nombreconductor" placeholder="">
                								</div>
                							</div>
                							<div class="form-group row my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">Apellido Conductor<span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9">
                									<input type="text" class="form-control rounded-0" id="apellidoconductor" name="apellidoconductor" placeholder="">
                								</div>
                							</div>
                							<div class="form-group row my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">Licencia de Conducir<span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9">
                									<input type="text" class="form-control rounded-0" id="numlicencia" name="numlicencia" placeholder="">
                								</div>
                							</div>
                						</div>
                					</div>
                					<div class="card border" style="border-top: 3px red solid!important;">
                						<div class="card-header">
                						    <div class="d-flex align-items-center">
                                                <div class="flex-grow-1">
                                                    <h6 class="card-title mb-0">BIENES A TRASLADAR</h6>
                                                </div>
                                                <div class="flex-shrink-0">
                                                    <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                                        <li class="list-inline-item">
                                                            <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseBienesGGR" role="button" aria-expanded="true" aria-controls="collapseBienesGGR">
                                                                <i class="mdi mdi-plus align-middle plus"></i>
                                                                <i class="mdi mdi-minus align-middle minus"></i>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                						</div>
                						<div class="card-body collapse show" id="collapseBienesGGR">
                							<div class="form-group row my-3">
                								<label for="nombres" class="col-lg-3 fw-bold">Item <span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9 d-flex justify-content-end">
                									<button type="button" class="btn btn-danger mx-1" id="btnModalProductosC" style="border-radius: 40px;">
                										<i class="mdi mdi-cart-plus me-2" style="font-size: 14px;"></i> Añadir
                									</button>
                									<!-- Botón de importar archivo Excel -->
                									<?php
                									if(in_array("IMITGR", $permisos))
                									{
                									?>
                									<button type="button" class="btn btn-info mx-1 d-flex align-items-center" id="btnImportarExcel" style="border-radius: 40px;">
                										<i class="mdi mdi-database-import-outline me-2" style="font-size: 16px;"></i> Importar Items
                									</button>
                									<?php
                									}
                									?>
                								</div>
                							</div>
                							<div class="form-group row my-3 mx-2">
                								<div class="col-md-12 table-responsive p-0">
                									<table class="table table-hover text-nowrap" id="tbdatos">
                										<thead>
                											<tr>
                												<th>#</th>
                												<th>CodProducto</th>
                												<th>Descripcion</th>
                												<th>Cantidad</th>
                												<th>Opciones</th>
                											</tr>
                										</thead>
                										<tbody>
                										</tbody>
                									</table>
                								</div>
                							</div>
                							<div class="form-group row d-none">
                								<div class="col-lg-12 col-xs-12">
                									<ul class="products-list product-list-in-box" id="divdatos">
                
                									</ul>
                								</div>
                							</div>
                							<input type="hidden" id="lbljsonofrecido" name="lbljsonofrecido">
                							<div class="form-group row">
                								<label for="nombres" class="col-lg-3 col-form-label">Unidad de medida de peso bruto<span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9">
                									<input type="text" class="form-control rounded-0" id="unidadmedida" name="unidadmedida" value="KGM" placeholder="" readonly>
                								</div>
                							</div>
                							<div class="form-group row">
                								<label for="nombres" class="col-lg-3 col-form-label">Peso bruto total de carga<span class="text-danger">*</span></label>
                								<div class="col-12 col-lg-9">
                									<input type="text" class="form-control rounded-0" id="PesoBrutoTotal" name="PesoBrutoTotal" placeholder="" readonly>
                								</div>
                							</div>
                						</div>
                						<div class="card-footer">
                							<div class="d-flex justify-content-end">
                								<button type="submit" id="btnEnviar" class="btn btn-success"><span class="mdi mdi-content-save me-1" style="font-size: 14px;"></span>Generar guia</button>
                							</div>
                						</div>
                					</div>
                
                				</form>
                			</div>
                			<!-- /.col -->
                		</div>
                		<!-- /.row -->
                	</div>
                	<!-- /.container-fluid -->
                </section>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<!-- /.content -->

<!-- MODAL PRODUCTOS -->

<div class="modal fade zoomIn" id="modal_productosC" tabindex="-1" role="dialog" aria-labelledby="examplemodal_productosC" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h4 class="modal-title color-white" id="examplemodal_productosC">AÑADIR ITEM</h4>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="form-group row my-3">
					<label for="nombres" class="col-lg-3 fw-bold">Elemento<span class="text-danger">*</span></label>
					<div class="col-12 col-lg-9">
						<select class="form-control selectItem input-sm" name="elemento" id="elemento" style="width: 100%;">
						</select>
					</div>
				</div>
				<div class="form-group row my-3">
					<label for="nombres" class="col-lg-3 fw-bold">Cantidad <span class="text-danger">*</span></label>
					<div class="col-12 col-lg-9">
						<input type="text" class="form-control rounded-0" id="cantidad" name="cantidad" placeholder="Cantidad">

					</div>
				</div>
				<div class="form-group row d-none">
					<label for="nombres" class="col-lg-3 col-form-label">Peso <span class="text-danger">*</span></label>
					<div class="col-12 col-lg-9">
						<input type="text" class="form-control rounded-0" id="peso" name="peso" placeholder="Peso" readonly>

					</div>
				</div>
			</div>
			<div class="modal-footer justify-content-between">
				<button type="button" class="btn bg-danger color-white" data-dismiss="modal"><i class="mdi mdi-close me-2" style="font-size: 14px;"></i>Cerrar</button>
				<button type="button" class="btn bg-success color-white" id="btnAgregar" name="btnAgregar"><i class="mdi mdi-plus me-2" style="font-size: 14px;"></i>Agregar</button>
				<button type="button" class="btn bg-warning color-white" id="btnEditar" name="btnEditar"><i class="mdi mdi-pencil me-2" style="font-size: 14px;"></i>Editar</button>
			</div>
		</div>
		<!-- /.modal-content -->
	</div>
	<!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<?= $this->section('js'); ?>
<script>

    $(function () {
        
        var arregloDatos = [];
        
        /* SELECTTRASLADO */
        
        $('.selectTraslado').select2({
            // minimumInputLength: 1,
            placeholder: 'Seleccione Tipo Traslado',
            allowClear: true,
            language: {
                errorLoading: function() {
                    return "La carga falló";
                },
                noResults: function() {
                    return "No hay resultado";
                },
                searching: function() {
                    return "Buscando..";
                }
            },
            ajax: {
                url: baseUrl + '/listado-tipo-traslado-busqueda',
                dataType: 'json',
                type: "POST",
                delay: 250,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function(data) {
                    return {
                        results: data
                    };
                },
                cache: true
            }
        });
        
        $('.selectTraslado').on('select2:select', function (e) {
            var data = e.params.data;
			   //  var cboTipoPrecio=$('#cboTipoPrecio option:selected').val();
            $("#MotivoTraslado").val(data.codigoSunatTrama);
            $("#DesMotivoTras").val(data.DescripcionTrama);
        });
        
        $('#tipotraslado').change(function () {
            var tipotraslado = $(this).val();
            console.log(tipotraslado);
            var nombresReceptorElement = $('.nombresReceptor');
            nombresReceptorElement.addClass('d-none');
        
            if (tipotraslado == 6 || tipotraslado == 7) {
                $('._delegacionllegada').removeClass('d-none');
                $('._reposicion').removeClass('d-none');//grupo de punto de llegada
                $('._contrato').addClass('d-none');//contrato no visible
                $('._delegacionpartida').removeClass('d-none'); 
                
                $('#delegacionpartida').val('');
                $('#delegacionllegada').val('');
                $('#cliente').val('');
                $('#tipodocumento').val('');
                $('#documento').val('');
                $('#contrato').val('');
                
                if(tipotraslado == 6){
                    if (nombresReceptorElement.hasClass('d-none')) {
                        nombresReceptorElement.removeClass('d-none');
                    }else{
                        $('#nombreApellidoReceptor').val();
                    }
                }
                
            }else if (tipotraslado == 5) {
                $('._delegacionllegada').addClass('d-none');
                $('._reposicion').removeClass('d-none');//grupo de punto de llegada
                $('._contrato').addClass('d-none');//contrato no visible
                $('._delegacionpartida').removeClass('d-none'); 
                $('#delegacionpartida').val('');
                $('#delegacionllegada').val('');
                $('#cliente').val('');
                $('#tipodocumento').val('');
                $('#documento').val('');
                $('#contrato').val('');        
        
            } else if (tipotraslado == 1) {
                $('._reposicion').addClass('d-none');
                $('._contrato').addClass('d-none');//contrato no visible
                $('._delegacionllegada').removeClass('d-none');
                $('._delegacionpartida').removeClass('d-none');        
                $('#cliente').val('VERISURE PERU S.A.C.');
                $('#tipodocumento').val('6').trigger('change');
                $('#documento').val('20549068201');
                
                if (nombresReceptorElement.hasClass('d-none')) {
                        nombresReceptorElement.removeClass('d-none');
                }else{
                        $('#nombreApellidoReceptor').val();
                }
        
                //Limpio valores
                $('#puntollegada').val('');
                $('#idpuntollegada').val('');
                $('#codigoubigeopuntollegada').val('');
                
                $('#departamentollegada').val('').trigger('change');
                $('#provinciallegada').val('').trigger('change');
                $('#distritollegada').val('').trigger('change');
                $('#delegacionllegada').val('').trigger('change');
                $('#contrato').val('');
                
        
            } else if (tipotraslado == 4) {
                $('._reposicion').removeClass('d-none');
                $('._contrato').removeClass('d-none');
                $('#cliente').val('VERISURE PERU S.A.C.');
                // $('#tipodocumento').val('6');
                $('#tipodocumento').val('6').trigger('change');
                $('#documento').val('20549068201');
                $('._delegacionpartida').addClass('d-none');
                $('._delegacionllegada').removeClass('d-none');
                $('#delegacionpartida').val('');
                $('#delegacionllegada').val('');
                $('#contrato').val('');
        
            } else {
                $('._delegacionllegada').addClass('d-none');
                $('._delegacionpartida').removeClass('d-none');
                $('._reposicion').removeClass('d-none');
                $('._contrato').removeClass('d-none');
                $('#delegacionpartida').val('');
                $('#delegacionllegada').val('');
                $('#cliente').val('');
                $('#tipodocumento').val('');
                $('#documento').val('');
                $('#contrato').val('');
            }
        });
        
        /************************************/
        
        /* BOTÓN AGREGAR CORREO DE ENVÍO */
        
        $(document).on('click', '#btn_agregar', function (e) {
            
            var random = generarRandom(5);
    
            var fila = `<div class="form-group row my-3" id="correoAdicionalGuiaRemision${random}">
            <div class="col-lg-3"></div>
            <div class="input-group col-12 col-lg-9">
                <input type="email" class="form-control rounded-0" name="correo[]">
                <div class="input-group-append">
                <span onclick="return eliminarBloqueDinamico('correoAdicionalGuiaRemision${random}');" class="input-group-text"><i class="mdi mdi-delete" style="font-size: 18px; color: red;"></i></span>
                </div>
            </div>
            </div>`;
            $(".divagregar").append(fila);
            
        });
        
        /************************************/
        
        /* LISTADOS PUNTO DE PARTIDA|LLEGADA - DEPARTAMENTO - PROVINCIA - DISTRITO - DELEGACIONES */
        
        $('#puntopartida').on('click', function() {
            $(this).autocomplete("search", "");
        }).autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: baseUrl + '/listado-direccion-busqueda',
                    dataType: "json",
                    type: "POST",
                    data: {
                        term: request.term,
                    },
                    success: function (data) {
                        response(data);
                    }
                });
            },
            minLength: 0,
            select: function (event, ui) {
                event.preventDefault();
                $('#puntopartida').val(ui.item.label);
                $('#idpuntopartida').val(ui.item.value);
                $('#codigoubigeopuntopartida').val(ui.item.ubigeo);
                $('#codigosunatpartida').val(ui.item.codigoSunat);
                selectRegionDepartamentos("departamentopartida", "TOTAL", ui.item.id_dep_inei, "");
                selectRegionProvincia("provinciapartida", ui.item.id_dep_inei, ui.item.id_prov_inei, "");
                selectRegionDistrito("distritopartida", ui.item.id_prov_inei, ui.item.id_distrito, "");
                // autocompleteUbigeo('departamentopartida', 'provinciapartida', 'distritopartida', ui.item.id_dep_inei, ui.item.id_prov_inei, ui.item.id_distrito);
            }
        });
        
        selectRegionDepartamentos("departamentopartida", "TOTAL", "", "");
        
        $('#provinciapartida').select2({
            
        });
        
        $('#distritopartida').select2({
            
        });
        
        $(document).on('change', '#departamentopartida', function() {
            var idDepartamento = $(this).val();
            
            $("#provinciapartida").empty();
            $("#distritopartida").empty();
            
            selectRegionProvincia('provinciapartida', idDepartamento, '', '');
        });
        
        $(document).on('change', '#provinciapartida', function() {
            var idProvincia = $(this).val();
            
            $("#distritopartida").empty();
            
            selectRegionDistrito('distritopartida', idProvincia, '', '');
        });

        selectCCDelegacionesEstructura("delegacionpartida", "", "");
        
        $('#puntollegada').on('click', function() {
            $(this).autocomplete("search", "");
        }).autocomplete({
            source: function (request, response) {
                $.ajax({
                    url: baseUrl + '/listado-direccion-busqueda',
                    dataType: "json",
                    type: "POST",
                    data: {
                        term: request.term,
                    },
                    success: function (data) {
                        response(data);
                    }
                });
            },
            minLength: 0,
            select: function (event, ui) {
                event.preventDefault();
                $('#puntollegada').val(ui.item.label);
                $('#idpuntollegada').val(ui.item.value);
                $('#codigoubigeopuntollegada').val(ui.item.ubigeo);
                $('#codigosunatllegada').val(ui.item.codigoSunat);
                selectRegionDepartamentos("departamentollegada", "TOTAL", ui.item.id_dep_inei, "");
                selectRegionProvincia("provinciallegada", ui.item.id_dep_inei, ui.item.id_prov_inei, "");
                selectRegionDistrito("distritollegada", ui.item.id_prov_inei, ui.item.id_distrito, "");
                // autocompleteUbigeo('departamentollegada', 'provinciallegada', 'distritollegada', ui.item.id_dep_inei, ui.item.id_prov_inei, ui.item.id_distrito);
        
                // $("#departamentollegada").trigger('change');
                // provincia.find('option').remove();
                // provincia.append('<option value="">Seleccione</option>');        
            }
        });
        
        $('#puntollegada').change(function () {
            $('#spanpuntollegada').text($(this).val());
        });
        $('#puntopartida').change(function () {
            $('#spanpuntopartida').text($(this).val());
        });
        
        selectRegionDepartamentos("departamentollegada", "TOTAL", "", "");
        
        $('#provinciallegada').select2({
            
        });
        
        $('#distritollegada').select2({
            
        });
        
        $(document).on('change', '#departamentollegada', function() {
            var idDepartamento = $(this).val();
            
            $("#provinciallegada").empty();
            $("#distritollegada").empty();
            
            selectRegionProvincia('provinciallegada', idDepartamento, '', '');
        });
        
        $(document).on('change', '#provinciallegada', function() {
            var idProvincia = $(this).val();
            
            $("#distritollegada").empty();
            
            selectRegionDistrito('distritollegada', idProvincia, '', '');
        });

        selectCCDelegacionesEstructura("delegacionllegada", "", "");

        /************************************/
        
        /* SELECT TIPO DE DOCUMENTO */
        
        selectTipoDocumentoCodigoSunat("tipodocumento", "", "");
        selectTipoDocumentoCodigoSunat("tipodocumentoconductor", "", "");
        
        /************************************/
        
        /* MODAL ITEMS */
        
        $('#btnModalProductosC').on('click', function () {

            $('#modal_productosC').modal('show');
            $('#btnEditar').hide();
            $('#btnAgregar').show();
        
            $('#elemento').val('').trigger('change');
            $('#cantidad').val('');
            $('#peso').val('');
            
            $('#elemento').removeAttr("disabled");
        });
        
        $('.selectItem').select2({
            placeholder: 'Seleccione Item',
            allowClear: true,
            dropdownParent: $('#modal_productosC .modal-body'),
            // minimumInputLength: 2,
            language: {
               errorLoading: function() {
                  return "La carga falló";
               },
               noResults: function() {
                  return "No hay resultado";
               },
               searching: function() {
                  return "Buscando..";
               },
               inputTooShort: function() {
                   return "Escribir minimo 2 caracteres";
               }                
            },
            ajax: {
                url: baseUrl + '/listado-item-tipo-traslado-busqueda',
                dataType: 'json',
                delay: 250,
                type: "POST",
                data: function (params) {
                     return {
                       term: params.term,
                       tipotraslado: $("#tipotraslado").val(),
                       codigosunatpartida : $('#codigosunatpartida').length > 0 ? $('#codigosunatpartida').val() : '',
                       departamentopartida : $('#departamentopartida').length > 0 ? $('#departamentopartida').val() : ''
                     };
               },               
               processResults: function(data) {
                  return {
                     results: data
                  };
               },
               cache: true
            }
        });
        
//         var arregloItemSeleccionado=[];

// 		$('.selectItem').on('select2:unselecting', function (e) {
// 		    arregloItemSeleccionado=[];
// 		    console.log('unselecting');
		   
// 		});			

		$('.selectItem').on('select2:select', function (e) {
		    var data = e.params.data;
		    $("#peso").val(data.peso);
		});
		
		const contenedorNuevosDatosItem = document.querySelector('#divdatos');
        const contenedorNuevosDatos = document.querySelector('#tbdatos tbody');
        
        function datosHTMLN() 
        {
            limpiarHTML(contenedorNuevosDatosItem);
            limpiarHTML(contenedorNuevosDatos);
        
            let resumen = '';
            let total = 0;
            let totalcantidad = 0;
            let totalCuota = 0;
            let fila = 1;
        
            let pesobruto = 0;
        
            let myJsonString = JSON.stringify(arregloDatos);
        
            arregloDatos.forEach(
                datos => {
                    console.log(datos);
                    const {
                        IdItem,
                        IdItemAsociado,
                        DescripcionAsociado,
                        CodProducto,
                        Descripcion,
                        Cantidad,
                        CantidadUnidad,
                        Peso,
                        PesoTotalItem
                    } = datos;
        
                    const row = document.createElement('tr');
                    row.innerHTML = `
                                    <td data-label="#">${fila}</td>
                                    <td data-label="CodProducto">${CodProducto}</td>
                                    <td data-label="Descripcion">${Descripcion}</td>
                                    <td data-label="Cantidad">${Cantidad}</td>
                                    <td data-label="Opciones | Asociado" class="d-flex justify-content-end">`+( IdItemAsociado ? DescripcionAsociado : `<button type="button" class="borrar-producto badge bg-danger border-0 p-2 mx-1" data-id="${IdItem}" text-id="${Descripcion}"><i class="mdi mdi-delete align-bottom" style="font-size: 20px; color: #FFF;"></i></button> <button type="button" class="editar-producto badge bg-warning border-0 p-2 mx-1" data-id="${IdItem}" text-id="${Descripcion}"><i class='mdi mdi-pencil align-bottom' style='font-size: 20px; color: #FFF;'></i></button>` )+ `</td>`;
                    contenedorNuevosDatos.appendChild(row);
        
                    pesobruto += parseFloat(PesoTotalItem);
        
                    console.log(arregloDatos.length);
        
                    fila++;
        
                })
        
            $('#PesoBrutoTotal').val(pesobruto);
            $('#lbljsonofrecido').val(myJsonString);
        
        }
        
        function limpiarHTML(cont) 
        {
            //forma recomendada
            while (cont.firstChild) {
                cont.removeChild(cont.firstChild);
            }
        
            $('#txtResumen').val('');
            $('#txtCantidad').val('');
            $('#txtTotal').val('');
            $('#txtJson').val('');
        }
        
        $('#btnAgregar').on('click', function (e) 
        {
            e.preventDefault();
        
            const Producto = $('#elemento option:selected');
            const Cantidad = parseInt($('#cantidad').val());
            const Peso = parseFloat($('#peso').val());
            var tipoTraslado = $('#tipotraslado').val();
        
            if (Producto.val() != '' && Cantidad != '' && Cantidad > 0) {
                if (arregloDatos.find(item => item.IdItem === Producto.val())) {
                    Swal.fire('Error', 'Elemento ya ingresado', 'error');
                    return;
                }
        
                // Agregar el nuevo elemento a arregloDatos
                var idItem = Producto.val();
                let PesoTotalItem = Peso * Cantidad;
                let dataToAdd = {
                    IdItem: idItem,
                    CodProducto: Producto.text().split('-')[0],
                    Descripcion: Producto.text().split('-')[1],
                    Cantidad: Cantidad,
                    Peso: Peso,
                    PesoTotalItem: PesoTotalItem
                };
        
                arregloDatos.push(dataToAdd);
        
                // Verificar si el elemento agregado requiere información adicional
                if (idItem != '' && tipoTraslado == 2) {
                    
                    $.ajax({
                        async:false,
                        url: baseUrl + '/listado-item-incluye-pilas',
                        dataType: "json",
                        type: "POST",
                        data: { 
                            idItem: idItem,
                            tipoTraslado: tipoTraslado 
                        },
                        success: function (data) { 
                            console.log(Object.keys(data).length);
                            if (Object.keys(data).length > 0) {
                                // Agregar la información adicional al elemento en arregloDatos
                                let dataToAddPil = {
                                    IdItem: data.id,
                                    IdItemAsociado: idItem,
                                    DescripcionAsociado: Producto.text(),
                                    CodProducto: data.text.split('-')[0],
                                    Descripcion: data.text.split('-')[1],
                                    Cantidad: Cantidad*data.cantidadPila,
                                    CantidadUnidad: data.cantidadPila,
                                    Peso: data.peso,
                                    PesoTotalItem: Cantidad*data.cantidadPila*data.peso
                                };
        
                                arregloDatos.push(dataToAddPil);
                            }
                        },
                        error: function (xhr, status, error) {
                            Swal.fire({
                                title: 'Ha ocurrido un error interno',
                                text: error,
                                icon: 'error',
                                showCancelButton: false,
                                confirmButtonColor: '#E4002B',
                                confirmButtonText: 'Confirmar'
                            });
                        }
                    });
                }
                
                $('#modal_productosC').modal('hide');
                // console.log(arregloDatos);
                datosHTMLN();
            } else {
                Swal.fire('Error', 'Debe seleccionar un elemento y especificar una cantidad válida', 'error');
            }
        });
        
        $('#btnEditar').on('click', function(e) 
        {
            e.preventDefault();
        
            const Producto = $('#elemento option:selected');
            const CantidadEdit = parseInt($('#cantidad').val());
            const PesoEdit = parseFloat($('#peso').val());
            
          if (Producto.val() != '' && CantidadEdit != '' && CantidadEdit > 0) {
                //GENERAR CODIGO DE ITEM PARA LA TABLA
                let totalFilas = arregloDatos.length + 1;
                let IdItem = Producto.val();
                let auxProducto = Producto.text();
                let arr = auxProducto.split('-');
                let Codigo = arr[0];
                let Descripcion = arr[1];
                let PesoTotalItem = (CantidadEdit * PesoEdit);
        
                let data = {
                    IdItem: IdItem,
                    CodProducto: Codigo,
                    Descripcion: Descripcion,
                    Cantidad: CantidadEdit,
                    Peso: PesoEdit,
                    PesoTotalItem: PesoTotalItem
                }
                
                // Actualizamos el objeto que tiene el mismo IdItem
                arregloDatos = arregloDatos.map(datos => datos.IdItem === data.IdItem ? data : datos)
                
                // Actualizamos los objetos que tienen un IdItemAsociado igual al IdItem
                arregloDatos = arregloDatos.map(datos => {
                    if (datos.IdItemAsociado === IdItem) {
                        return {
                            ...datos, // Conserva los campos previos
                            Cantidad: datos.CantidadUnidad*CantidadEdit,
                            PesoTotalItem: datos.CantidadUnidad * CantidadEdit * datos.Peso
                        };
                    }
                    return datos; // Si no coincide, lo dejamos igual
                });
                
                datosHTMLN();
                
                $('#modal_productosC').modal('hide');
            } 
            else 
            {
                Swal.fire(
                    'Error',
                    'Debe seleccionar un elemento y especificar una cantidad válida',
                    'error'
                )
            }
            
        })

        /************************************/
        
        /* TABLA ITEMS */
        $('#tbdatos').on("click", ".borrar-producto", function(e) {
            e.preventDefault();
        
            const Producto = e.currentTarget.getAttribute('data-id');  // `e.currentTarget` apunta al botón completo
            const txtProducto = e.currentTarget.getAttribute('text-id');
            
            arregloDatos = arregloDatos.filter(datos => datos.IdItem != Producto);
            arregloDatos = arregloDatos.filter(datos => datos.IdItemAsociado != Producto);
            
            datosHTMLN();
        });
        
        $('#tbdatos').on("click", ".editar-producto", function(e) {
            e.preventDefault();
        
            $('#btnEditar').show();
            $('#btnAgregar').hide();
            const Producto = e.currentTarget.getAttribute('data-id');
            const txtProducto = e.currentTarget.getAttribute('text-id');
            
            let datosencontrados;
            datosencontrados = arregloDatos.find(datos => datos.IdItem === Producto);
            
            //Edita del arreglo de articulosCarrito por el data-id
    // $('#elemento').select2();
            $("#elemento").select2("trigger", "select", {data: { id: datosencontrados.IdItem ,text: datosencontrados.CodProducto + " - " + datosencontrados.Descripcion }});
            // $('#elemento').val(datosencontrados.IdItem).trigger('change');
            $('#cantidad').val(datosencontrados.Cantidad);
            $('#peso').val(datosencontrados.Peso);     
            $('#elemento').attr("disabled", "disabled");
            
            $('#modal_productosC').modal('show');
        });
        
        // $('#tbdatos').on("click", function(e) 
        // {
        //     // e.preventDefault();
            
        //     if (e.target.classList.contains('borrar-producto')) {
        //         const Producto = e.target.getAttribute('data-id');
        //         const txtProducto = e.target.getAttribute('text-id');
        //         //Elimina del arreglo de articulosCarrito por el data-id
        //         console.log(arregloDatos);
        //         arregloDatos = arregloDatos.filter(datos => datos.IdItem != Producto);
        //         arregloDatos = arregloDatos.filter(datos => datos.IdItemAsociado != Producto);
        //         datosHTMLN();
        //         console.log(arregloDatos);
        //     }
        
        //     if (e.target.classList.contains('editar-producto')) {
        //         $('#btnEditar').show();
        //         $('#btnAgregar').hide();
        //         const Producto = e.target.getAttribute('data-id');
        //         const txtProducto = e.target.getAttribute('text-id');
        
        //         let datosencontrados;
        //         datosencontrados = arregloDatos.find(datos => datos.IdItem === Producto);
        //         console.log(datosencontrados);
        
        //         //Edita del arreglo de articulosCarrito por el data-id
        
        //         $('#elemento').val(datosencontrados.IdItem).trigger('change');
        //         $('#cantidad').val(datosencontrados.Cantidad);
        //         $('#peso').val(datosencontrados.Peso);         
        
        //         $('#modal_productosC').modal('show');
        
        //     }
        // });
        
        /************************************/
        
        /* IMPORTAR ITEM EXCEL */
        
        $('#btnImportarExcel').on('click', function() {
            // Crea un input de tipo file oculto
            var input = document.createElement('input');
            input.type = 'file';
        
            // Escucha el evento change del input file
            input.onchange = function(event) {
        
                var file = event.target.files[0];
                var formData = new FormData();
                var repetidos = false;
        
                formData.append("itemsFile", file); //agregar variables al controlador
                
                $.ajax({
                    url: baseUrl + '/importar-items-guia-remision',
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    cache: false,
                    processData: false,
                    dataType: 'json',
                    success: function (response) {
                        
                        if(response.error)
                        {
                            $('.respuesta_global').html(response.mensaje);
                        }
                        else
                        {
                            console.log(response);
                            response.forEach(
                                datos => {
                                    console.log(datos);
                                    const {
                                        id,
                                        text,
                                        peso,
                                        cantidaditems
                                    } = datos;
                                    
                                const existeId = arregloDatos.some(item => item.IdItem === id);
                                
                                if (existeId) {
                                    // Si el id ya existe, se cambia parametro repetidos a true para devolver mensaje.
                                    repetidos = true;
                                    return; // Salir de la función para evitar el push
                                }
                                
                                let dataToAddPil = {
                                    IdItem: id,
                                    CodProducto: text.split('-')[0],
                                    Descripcion: text.split('-')[1],
                                    Cantidad: cantidaditems,
                                    Peso: peso,
                                    PesoTotalItem: cantidaditems*peso
                                };
                                
                                
                                arregloDatos.push(dataToAddPil);
                    
                            });
                            
                            if(repetidos)
                            {
                                Swal.fire({
                                    text: "Algunos items importados se encuentran repetidos.",
                                    icon: 'warning',
                                    showCancelButton: false,
                                    confirmButtonColor: '#E4002B',
                                    confirmButtonText: 'Confirmar'
                                });
                            }
                            
                            datosHTMLN();
                        }
                    },
                    error: function (xhr, status, error) {   
                       Swal.fire({
                            title: 'Ha ocurrido un error interno',
                            text: error,
                            icon: 'error',
                            showCancelButton: false,
                            confirmButtonColor: '#E4002B',
                            confirmButtonText: 'Confirmar'
                        });
                    }
                });
                return false;
            };
        
            // Dispara el clic en el input file
            input.click();
        });
        
        /************************************/
        
        /* CONTENIDO ADICIONAL */
        
        $('#fechadetraslado').on('input', function() {
            //console.log($('#fechadetraslado').val()+'T12:30:00');
            var fechaSeleccionada = new Date($('#fechadetraslado').val()+'T23:59:00');
            var fechaActual = new Date();
            console.log(fechaSeleccionada);
            console.log(fechaActual);
            if ($('#fechadetraslado').val().length === 10) {
                if (fechaSeleccionada < fechaActual) {
                // alert('No puedes seleccionar una fecha anterior a la actual.');
                $('#fechadetraslado').val(''); // Limpiar el campo si la fecha es anterior
                }
            }
        });
        
        $("input[name='contrato']").keydown(function(e){
          if(e.keyCode == 32){
            return false;
          }
        });
        
        $("input[name='contrato']").on('input', function() {
          $(this).val($(this).val().replace(/[^0-9]/g, ''));
        });
        
        /************************************/
        
        /* ENVÍO DE FORMULARIO */
        
        $(document).on('submit', '.formularioGuia', function () {
            //$.blockUI({css: {border: 'none', overflow: 'hidden !important', padding: '15px', backgroundColor: '#000', '-webkit-border-radius': '10px', '-moz-border-radius': '10px', opacity: .5, color: '#fff'}});
            var formulario = $(this);
            var metodoEnvio = formulario.attr('method');
        
            formulario.find(':button[type=submit]').prop('disabled', true);
            formulario.find('.spin-loading').removeClass('d-none');
        
            $.ajax({
                url: formulario.attr('action'),
                type: metodoEnvio,
                data: formulario.serialize(),
                data: new FormData(this),
                contentType: false,
                cache: false,
                processData: false,
                dataType: 'json',
                success: function (response) {
                    //$.unblockUI({});
                    // formulario.find('.respuesta').html(response);
        
                    console.log(response);
        
                    if(response['status']){
                        var xmlDoc = $.parseXML(response['respuestaxml']);
        
                        // Obtener los elementos deseados
                        var resultCode = $(xmlDoc).find("ResultCode").text();
                        var resultMessage = $(xmlDoc).find("ResultMessage").text();
            
                        // Mostrar los valores obtenidos
                        console.log("Result Code:", resultCode);
                        console.log("Result Message:", resultMessage);
            
                        Swal.fire({
                            title: resultMessage + ', Num.Serie:'+response['serie'],
                            showDenyButton: false,
                            showCancelButton: false,
                            confirmButtonText: 'Ok',
                            denyButtonText: `Don't save`,
                          }).then((result) => {
                            /* Read more about isConfirmed, isDenied below */
                            if (result.isConfirmed) {
                                parent.location.reload();
                            } 
                          })
                    }else{
                        formulario.find('.respuesta').html(response['mensaje']);
                    }
        
                    
        
                    setTimeout(() => {
                        formulario.find(':button[type=submit]').prop('disabled', false);
                        formulario.find('.spin-loading').addClass('d-none');
                    }, 1000);
                },
                error: function () {
                    //$.unblockUI({});
        
                    setTimeout(() => {
                        formulario.find('.spin-loading').addClass('d-none');
                        formulario.find(':button[type=submit]').prop('disabled', false);
                    }, 1000);
                    alert('Ha ocurrido un error interno.');
                }
            });
            return false;
        });


    });
    
</script>
<?php $this->endSection(); ?>


<?php $this->endSection(); ?>