<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("EXGREM", $permisos)) 
								{
								?>
    							<!--<button type="button" class="btn bg-warning d-flex mx-1 color-white" data-bs-toggle="modal" data-bs-target="#modal-exportar-guia-remision">-->
    							<!--	<i class="mdi mdi-file-download me-1" style="font-size: 14px;"></i> Exportar-->
    							<!--</button>-->
    							<?php
    							}
    							
								if (in_array("IMGREM", $permisos)) 
								{
								?>
								<button type="button" class="btn bg-success d-flex mx-1 color-white" data-bs-toggle="modal" data-bs-target="#modal-importar-guia-remision" id="btnImportarGuiaRemision">
    								<i class="mdi mdi-database-import-outline me-1" style="font-size: 14px;"></i> Importar
    							</button>
    							<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblGuiaRemision" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<!-- IMPORTAR EXCEL -->
<div class="modal fade zoomIn" id="modal-importar-guia-remision" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalImportarGuiaRemision" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h4 class="modal-title color-white" id="exampleModalImportarGuiaRemision">Importar Guías de Remisión</h4>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioImportarGuiaRemision" id="formImportarGuiaRemision" autocomplete="off" action="<?= $baseUrl ?>/importar-guias-remision" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<ol>
						    <li>Información de columna [Item]: Colocar el código del item a subir.</li>
						    <li>Información de columna [Delegacion]: Colocar SOLO el CC de la delegación.</li>
						    <li>Información de columna [Matricula]: Colocar una matrícula válida o [GE, EXTERNO]. Se validará la existencia del mismo.</li>
						    <li>Información de columna [Quantity]: Colocar una cantidad válida (mayor a cero).</li>
						    <li>Información de columna [Doc_Llegada]: Solo utilizado si [Matricula] es EXTERNO. Se coloca el ID del Proveedor Externo.</li>
						    <li>Información de columna [PuntoLlegada]: Colocar el código de base de datos de la dirección.</li>
						    <li>Información de columna [N_Placa]: Colocar la placa del vehículo del transportista.</li>
						    <li>Información de columna [Doc_Conductor]: Colocar el número de documento del transportista.</li>
						    <li>Información de columna [Nombre_Conductor]: Colocar el nombre del transportista.</li>
						    <li>Información de columna [Apellido_Conductor]: Colocar el apellido del transportista.</li>
						    <li>Información de columna [Brevete]: Colocar el brevete del transportista.</li>
						    <li>Información de columna [Observaciones]: Colocar observaciones de la guía.</li>
						</ol>
					</div>
    				<hr>
    				<h4 class="mb-3">Plantillas:</h4>
					<div class="row col-12 m-0 p-0">
					    <div class="col-lg-12 col-12 d-flex justify-content-center align-items-center">
					        <!--<a class='btn btn-success border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/plantilla csv linea.csv' ?>' download='Plantilla CSV Línea'>Descargar Plantilla</a>-->
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea descargar la <strong class="fw-medium">Plantilla de Importación de Guía de Remisión</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <a class="text-body" href='<?= base_url().'/public/docs/Plantillas/plantilla csv guia remision.csv' ?>' download='Plantilla CSV Guía de Remisión'>Descargar Plantilla <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                    </div>
                                </div>
                            </div>
					    </div>
					</div>
    				<hr>
    				<h4 class="mb-3">Importar archivo:</h4>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-7 m-0 p-0">
					        <input type="file" id="fileImportarGuiaRemision" class="filepond" name="fileImportarGuiaRemision" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
					<!--<div class="mb-3">-->
					<!--	<label for="fileCSVLinea" class="form-label">Seleccione CSV:</label>-->
					<!--	<input class="form-control" type="file" id="fileCSVLinea" name="fileCSVLinea">-->
					<!--</div>-->
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger d-flex justify-content-center" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn btn-success d-flex justify-content-center"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE GUÍA DE REMISIÓN***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblGuiaRemision').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/guiaRemisionServerside",
						type: 'GET'
					},
					"columns": [
						{"title": "# Guía", "data": "nguia", "class": "text-center", "searchable": true },
						{"title": "Fecha de Registro", "data": "fecharegistro", "class": "text-center", "searchable": true },
						{"title": "Descripción Trama", "data": "DescripcionTrama", "class": "text-center", "searchable": true },
						{"title": "Matrícula", "data": "matricula", "class": "text-center", "searchable": true },
						{"title": "Documento Conductor", "data": "documentoconductor", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Nombre Conductor", "data": "NombreCompletoConductor", "class": "text-center", "searchable": true },
						{"title": "Brevete Conductor", "data": "numlicencia", "class": "text-center", "searchable": true },
						{"title": "Peso Bruto", "data": "PesoBrutoTotal", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Contrato", "data": "contrato", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Anulación", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],

					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[1, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE GUÍA DE REMISIÓN****/
		
        pondImportarGuiaRemision = FilePond.create(
            document.querySelector("#fileImportarGuiaRemision"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/csv'],
                onaddfile: (file) => {
                    // Validación manual por extensión
                    const allowedExtensions = /(\.xml)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser CSV.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondImportarGuiaRemision.removeFile(file.id);
                        return false; // Detener el envío del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );

	});
</script>
<?php $this->endSection(); ?>

<?php $this->endSection(); ?>