<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("ESANMA", $permisos)) 
								{
								?>
    							<button type="button" class="btn bg-primary d-flex mx-1 color-white" data-bs-target="#modal-estado-anulaciones" id="btnCambioEstadoMasivoAnulaciones">
    								<i class="mdi mdi-update me-1" style="font-size: 14px;"></i> Cambio de Estado
    							</button>
    							<?php
    							}
    							
								if (in_array("EXANGR", $permisos)) 
								{
								?>
    							<button type="button" class="btn bg-warning d-flex mx-1 color-white" data-bs-toggle="modal" data-bs-target="#modal-exportar-guia-remision">
    								<i class="mdi mdi-file-download me-1" style="font-size: 14px;"></i> Exportar
    							</button>
    							<?php
    							}
    							
								if (in_array("SANUGR", $permisos)) 
								{
								?>
    							<button type="button" class="btn bg-success d-flex mx-1 color-white" data-bs-target="#modal-solicitar-anulacion" id="btnSolicitarAnulacionGuiaRemision">
    								<i class="mdi mdi-cancel me-1" style="font-size: 14px;"></i> Solicitar Anulación
    							</button>
    							<?php
    							}
								?>
								<button type="button" class="btn bg-sistema color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblAnulacionesGuiaRemision" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">
										    <div class="d-flex justify-content-center align-items-center">
										        Selección
    										    <center class="content-center ms-3" style="position: relative; height: 40px;">
                                                    <input type="checkbox" id="chkAnulacionTotalPagina" name="chkAnulacionTotalPagina" class="chk-basico chk-aprobar">
                                                    <label for="chkAnulacionTotalPagina"></label>
                                    			</center>
										    </div>
										</th>
										<th class="text-center align-middle">Fecha Solicitud</th>
										<th class="text-center align-middle">Matrícula Solicitante</th>
										<th class="text-center align-middle">N° Guía</th>
										<th class="text-center align-middle">Motivo Anulación</th>
										<th class="text-center align-middle">Contrato</th>
										<th class="text-center align-middle">Estado</th>
									</tr>
								</thead>
								<tbody>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-sistema bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <div data-simplebar="init" class="h-100 simplebar-scrollable-y">
            <div class="simplebar-wrapper" style="margin: 0px;">
                <div class="simplebar-height-auto-observer-wrapper">
                    <div class="simplebar-height-auto-observer">
                        
                    </div>
                </div>
                <div class="simplebar-mask">
                    <div class="simplebar-offset" style="right: 0px; bottom: 0px;">
                        <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">
                            <div class="simplebar-content" style="padding: 0px;">
                                <div id="ctnFiltro" class="p-3">
                        			<div class="col-12 col-md-12 p-0 my-3">
                        				<div class="col-xxl-12 col-md-12 col-12 border-sistema-2px p-2 my-2 d-flex justify-content-between align-items-center" style="border-radius: 7px;">
                        				    <h5 class="color-sistema m-0">Estados</h5>
                        				    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkTodoEstadosAnulacionFiltro_i">
                        						<input class="form-check-input form-check-input-sistema" type="checkbox" role="switch" name="chkTodoEstadosAnulacionFiltro_i" id="chkTodoEstadosAnulacionFiltro_i">
                        						<label class="form-check-label m-0" for="chkTodoEstadosAnulacionFiltro_i"></label>
                        					</div>
                        				</div>
                        				<div class="row col-xxl-12 col-md-12 col-12 p-0 m-0 my-2">
                        					<div class="col-6 m-0 p-0">
                        					    <div class="form-check form-switch form-switch-lg">
                        							<input class="form-check-input chkFiltroAnulacionesGuiaRemision" type="checkbox" role="switch" name="estados[]" id="chkFiltroPendiente" value="Pendiente" checked>
                        							<label class="form-check-label" for="chkFiltroPendiente">Pendiente</label>
                        						</div>
                        					</div>
                        					<div class="col-6 m-0 p-0">
                        					    <div class="form-check form-switch form-switch-lg">
                        							<input class="form-check-input chkFiltroAnulacionesGuiaRemision" type="checkbox" role="switch" name="estados[]" id="chkFiltroProceso" value="En proceso">
                        							<label class="form-check-label" for="chkFiltroProceso">En Proceso</label>
                        						</div>
                        					</div>
                        					<div class="col-6 m-0 p-0">
                        					    <div class="form-check form-switch form-switch-lg">
                        							<input class="form-check-input chkFiltroAnulacionesGuiaRemision" type="checkbox" role="switch" name="estados[]" id="chkFiltroProcesado" value="Procesado">
                        							<label class="form-check-label" for="chkFiltroProcesado">Procesado</label>
                        						</div>
                        					</div>
                        					<div class="col-6 m-0 p-0">
                        					    <div class="form-check form-switch form-switch-lg">
                        							<input class="form-check-input chkFiltroAnulacionesGuiaRemision" type="checkbox" role="switch" name="estados[]" id="chkFiltroCancelado" value="Cancelado">
                        							<label class="form-check-label" for="chkFiltroCancelado">Cancelado</label>
                        						</div>
                        					</div>
                        				</div>
                        			</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">
                    
                </div>
            </div>
            <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">
                <div class="simplebar-scrollbar" style="width: 0px; display: none;">
                    
                </div>
            </div>
            <div class="simplebar-track simplebar-vertical" style="visibility: visible;">
                <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">
                    
                </div>
            </div>
        </div>
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- CAMBIAR ESTADO SOLICITUD ANULACIÓN -->
<div class="modal fade zoomIn" id="modal-estado-anulaciones" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalCambioEstadoAnulaciones" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h4 class="modal-title color-white" id="exampleModalCambioEstadoAnulaciones">Cambio de Estado Anulaciones</h4>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formCambioEstadoAnulaciones" autocomplete="off" action="<?= $baseUrl ?>/cambiar-estado-masivo-anulacion" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="alert border-0 alert-success w-auto text-center" role="alert">
                        ¿Estas seguro que deseas <strong>CAMBIAR DE ESTADO</strong> a las siguientes anulaciones de la guía de remisión?
                    </div>
                    <div class="p-3 text-center my-2 border-sistema-2px" style="border-radius: 10px;" id="ctnGuiasAnular"></div>
                    <div class="row m-0 mt-2 p-3 " >
                        <div class="col-lg-3 d-flex align-items-center">
                            <label class="m-0 fw-bold" for="cboEstado_cemagr">Estado</label>
                        </div>
                        <div class="col-lg-9">
                            <select class="form-select" id="cboEstado_cemagr" name="cboEstado_cemagr">
                                <option value="" selected>Seleccione una opción</option>
                                <option value="Pendiente">Pendiente</option>
                                <option value="En Proceso">En Proceso</option>
                                <option value="Procesado">Procesado</option>
                                <option value="Cancelado">Cancelado</option>
                            </select>
                        </div>
                    </div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger d-flex justify-content-center" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn btn-success d-flex justify-content-center"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- SOLICITAR ANULACIÓN GUÍA REMISIÓN -->
<div class="modal fade zoomIn" id="modal-solicitar-anulacion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleModalSolicitarAnulacion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h4 class="modal-title color-white" id="exampleModalSolicitarAnulacion">Solicitar Anulación</h4>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formCambioEstadoAnulaciones" autocomplete="off" action="<?= $baseUrl ?>/solicitar-anulacion-guia-remision" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
                    <div class="row m-0 p-0 py-2" >
                        <div class="col-lg-3 d-flex align-items-center">
                            <label class="m-0 fw-bold" for="txtNroGuia_sagr">Nro Guía</label>
                        </div>
                        <div class="col-lg-9">
                            <!--<input type="text" class="form-control" id="txtNroGuia_sagr" name="txtNroGuia_sagr" placeholder="Ingrese el Nro de guía">-->
                            <div class="input-group">
                                <input type="text" class="form-control" id="txtNroGuia_sagr" name="txtNroGuia_sagr" placeholder="Ingrese el Nro de guía">
                                <button class="btn bg-celeste-75 color-white" type="button"><span class="mdi mdi-file-search-outline" style="font-size: 18px;"></span></button>
                            </div>
                        </div>
                    </div>
                    <div class="row m-0 p-0 py-2" >
                        <div class="col-lg-3 d-flex align-items-center">
                            <label class="m-0 fw-bold" for="cboMotivoAnulacion_sagr">Motivo anulación:</label>
                        </div>
                        <div class="col-lg-9">
                            <select class="form-select" id="cboMotivoAnulacion_sagr" name="cboMotivoAnulacion_sagr">
                                <option value="" selected>Seleccione una opción</option>
                                <option value="Error en datos">Error en datos</option>
                                <option value="Duplicado">Duplicado</option>
                                <option value="Prueba">Prueba</option>
                                <option value="Otros">Otros</option>
                            </select>
                        </div>
                    </div>
                    <div class="row m-0 p-0 py-2" >
                        <div class="col-lg-3 d-flex align-items-center">
                            <label class="m-0 fw-bold" for="txtContrato_sagr">Contrato</label>
                        </div>
                        <div class="col-lg-9">
                            <input type="text" class="form-control" id="txtContrato_sagr" name="txtContrato_sagr" readonly>
                        </div>
                    </div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger d-flex justify-content-center" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn btn-success d-flex justify-content-center"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Solicitar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<?= $this->section('js'); ?>
<script>

	$(function () {
	    setTimeout(function() {
            var boton = document.getElementById('btnBuscarFiltros');
            // Simular el clic en el botón
            boton.click();
        }, 100);
		//FILTROS
		$('#chkTodoEstadosAnulacionFiltro_i').change(function() {
            $('.chkFiltroAnulacionesGuiaRemision').prop('checked', this.checked);
        });

        // Desactivar el toggle si algún checkbox es desmarcado
        $('.chkFiltroAnulacionesGuiaRemision').change(function() {
            if (!this.checked) {
                $('#chkTodoEstadosAnulacionFiltro_i').prop('checked', false);
            }
            // Si todos los checkboxes están marcados, activar el toggle
            if ($('.chkFiltroAnulacionesGuiaRemision:checked').length === $('.chkFiltroAnulacionesGuiaRemision').length) {
                $('#chkTodoEstadosAnulacionFiltro_i').prop('checked', true);
            }
        });
        
        $("#btnLimpiar").click(function() {
            $('#chkTodoEstadosAnulacionFiltro_i').prop('checked', false);
            $('.chkFiltroAnulacionesGuiaRemision').prop('checked', false);
        });
        
        $(document).on('click', "#btnBuscarFiltros", function(e) 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
            
            var estados = [];
            
            $('.chkFiltroAnulacionesGuiaRemision:checked').each(function() {
                estados.push($(this).val()); // Agregar el valor al array
            });
            
            $('#tblAnulacionesGuiaRemision').DataTable().destroy();
            
            $("#tblAnulacionesGuiaRemision").DataTable({
                "ajax": {
                    "url": baseUrl + "/recargar-anulaciones-guia-remision",
                    "type": "POST",
                    "data": {
                        "estados"       : estados
                    },
                    "error": function (xhr, error, thrown) {
                        Swal.close();
                        Swal.fire({
                            title: 'Ha ocurrido un error interno',
                            text: thrown.message,
                            icon: 'error',
                            showCancelButton: false,
                            confirmButtonColor: '#E4002B',
                            confirmButtonText: 'Confirmar'
                        });
                    }
                },
                columnDefs: [
                    { className: "text-center align-middle", targets: "_all" }
                ],
                columns: [
                   { data: 'seleccion', "orderable": false },
                   { data: 'fecha', "orderable": true },
                   { data: 'matricula', "orderable": true },
                   { data: 'guia', "orderable": true },
                   { data: 'motivo', "orderable": true },
                   { data: 'contrato', "orderable": true },
                   { data: 'estado', "orderable": true }
                ],
                order: [[1, 'desc']]
            });
            
            $("#btnCerrarFiltros").click();
            Swal.close();
        });
        
        $('#txtNroGuia_sagr').on('click', function() {
            // $(this).val('');
            // $(this).autocomplete("search", "");
        }).autocomplete({
            appendTo: "#modal-solicitar-anulacion",
            source: function (request, response) {
                $.ajax({
                    url: baseUrl + '/listado-numero-guia-remision',
                    dataType: "json",
                    type: "POST",
                    data: {
                        term: request.term,
                    },
                    success: function (data) {
                        response(data);
                    }
                });
            },
            minLength: 6,
            select: function (event, ui) {
                event.preventDefault();
                $('#txtNroGuia_sagr').val(ui.item.nroguia);
                
                if(ui.item.contrato != '' && ui.item.contrato != null)
                {
                    $('#txtContrato_sagr').val(ui.item.contrato);
                    $('#txtContrato_sagr').prop("readonly", "readonly");
                }
                else
                {
                    $('#txtContrato_sagr').val("");
                    $('#txtContrato_sagr').removeAttr("readonly");
                }
                
            }
        });
	});
</script>
<?php $this->endSection(); ?>

<?php $this->endSection(); ?>