<?php namespace App\Models;

use CodeIgniter\Model;

class TipoTrasladoModel extends Model 
{
    protected $DBGroup          = 'guiaremision';
    protected $table            = 'tipo_traslado';
    protected $primaryKey       = 'id_tipo_traslado';
    protected $allowedFields    = ['id_tipo_traslado','tipotrasladoVerisure','tipotrasladoSunat','serie','fecha_registro','eliminacion_logica', 'codigoSunatTrama', 'DescripcionTrama'];
    
    public function listadoTipoTrasladoBusqueda($array)
    {
        $this->select('tipo_traslado.id_tipo_traslado,
            tipo_traslado.tipotrasladoVerisure,
            tipo_traslado.tipotrasladoSunat,
            tipo_traslado.serie,
            tipo_traslado.fecha_registro,
            tipo_traslado.eliminacion_logica,
            tipo_traslado.codigoSunatTrama,
            tipo_traslado.DescripcionTrama');
            
        if(isset($array["variable"]) && !empty($array["variable"]))
        {
            $this->groupStart(); // Inicia un grupo de condiciones
                $this->orLike("tipo_traslado.tipotrasladoVerisure", $array["variable"]);
                // $this->orLike("proveedor.RUC", $array["variable"]);
                // $this->orLike("proveedor.Contacto", $array["variable"]);
                // $this->orLike("proveedor.Direccion", $array["variable"]);
            $this->groupEnd();
        }
        
        if(isset($array['eliminacion_logica']) && $array['eliminacion_logica'] != '')
        {
            $this->where("tipo_traslado.eliminacion_logica", $array['eliminacion_logica']);
        }
        
        $datos = $this->findAll();
        return $datos;
    }
    
}