<?php namespace App\Models;

use CodeIgniter\Model;

class ItemTipoTrasladoModel extends Model 
{
    protected $DBGroup          = 'guiaremision';
    protected $table            = 'item_tipo_traslado';
    protected $primaryKey       = 'id_item';
    protected $allowedFields    = ['id_item', 'id_tipo_traslado', 'UsuarioRegistra', 'FechaRegistra'];
    protected $useAutoIncrement = false;
    protected $useSoftDeletes   = false;
    
    public function listadoItemTipoTrasladoBusqueda($array)
    {
        $this->select('item_tipo_traslado.id_item,
            item.coditem,
            item.descripcion,
            item.peso');
            
        $this->join('item', 'item_tipo_traslado.id_item = item.id_item', 'left');
        
        if(isset($array["variable"]) && $array["variable"] != '' && $array["variable"] != null)
        {
            $this->groupStart(); // Inicia un grupo de condiciones
                $this->orLike("item.coditem", $array["variable"]);
                $this->orLike("item.descripcion", $array["variable"]);
            $this->groupEnd();
        }
        
        if(!empty($array))
        {
            if(isset($array['Eliminacion']) && $array['Eliminacion'] != '' && $array['Eliminacion'] != null)
            {
                $this->where("item.eliminacion_logica", $array['Eliminacion']);
            }
            
            if(isset($array['TipoTraslado']) && $array['TipoTraslado'] != '' && $array['TipoTraslado'] != null)
            {
                $this->where("item_tipo_traslado.id_tipo_traslado", $array['TipoTraslado']);
                
                if($array['TipoTraslado'] == 2)
                {
                    if(isset($array['DepartamentoPartida']) && $array['DepartamentoPartida'] == 15)
                    {
                        $this->whereNotIn("item.coditem", array("PEF3GFM"));
                    }
                    else if(empty($array['DepartamentoPartida']))
                    {
                        $this->whereNotIn("item.coditem", array("PEF3GFM", "PEF3GLTE"));
                    }
                }
            }
        }
        
        $datos = $this->findAll();
        return $datos;
    }
}
