<?php namespace App\Models;

use CodeIgniter\Model;

class ItemModel extends Model 
{
    protected $DBGroup          = 'guiaremision';
    protected $table            = 'item';
    protected $primaryKey       = 'id_item';
    protected $allowedFields    = ['id_item', 'coditem', 'descripcion', 'id_categoria_item', 'fechahoraregistro', 'eliminacion_logica', 'peso', 'Reposicion_de_Stock', 'Venta_Nueva', 'Ampliacion', 'Desmontaje', 'Reparacion_de_Equipo', 'Abastecimiento', 'Cese_de_Personal'];
    protected $useAutoIncrement = false;
    protected $useSoftDeletes   = false;
    
    public function obtenerItem($array)
    {
        $this->select('item.id_item,
            item.coditem,
            item.descripcion,
            item.peso');
            
        // if(isset($array["variable"]) && $array["variable"] != '' && $array["variable"] != null)
        // {
        //     $this->groupStart(); // Inicia un grupo de condiciones
        //         $this->orLike("item.coditem", $array["variable"]);
        //         $this->orLike("item.descripcion", $array["variable"]);
        //     $this->groupEnd();
        // }
        
        if(!empty($array))
        {
            if(isset($array['Eliminacion']) && $array['Eliminacion'] != '' && $array['Eliminacion'] != null)
            {
                $this->where("item.eliminacion_logica", $array['Eliminacion']);
            }
            
            if(isset($array['idPila']) && $array['idPila'] != '' && $array['idPila'] != null)
            {
                $this->where("item.coditem", $array['idPila']);
            }
        }
        
        $datos = $this->first();
        return $datos;
    }
}
