<?php namespace App\Models;

use CodeIgniter\Model;

class GuiaRemisionModel extends Model 
{
    protected $DBGroup          = 'guiaremision';
    protected $table            = 'guia';
    protected $primaryKey       = 'id_guia';
    protected $allowedFields    = ['id_guia', 'nguia', 'fecharegistro','matricula', 'tipotraslado', 'codigoSunatTrama', 'DescripcionTrama', 'correo', 'fechadetraslado', 'puntopartida', 'idpuntopartida', 'codigoubigeopuntopartida', 'puntollegada', 'idpuntollegada', 'codigoubigeopuntollegada', 'cliente', 'tipodocumento', 'documento', 'contrato', 'nplaca', 'tipodocumentoconductor', 'documentoconductor', 'nombreconductor', 'apellidoconductor', 'numlicencia', 'lbljsonofrecido', 'unidadmedida', 'PesoBrutoTotal', 'nombreReceptor', 'delegacionpartida', 'delegacionllegada', 'distritopartida', 'distritollegada', 'departamentopartida', 'departamentollegada', 'codigosunatpartida', 'codigosunatllegada', 'observacion', 'contrato_presente', 'idusuario_creador', 'tipo_creacion'];
    
    public function listaGeneralGuiaRemision($get, $adicionales)
    {
        /*
        * ----------------------------
        * VALORES ESTÁTICOS A UTILIZAR
        * ----------------------------
        */
    
        // $this->globales = new Globales();
        
        $fields = array(
            0 => 'guia.nguia', 
            1 => 'guia.fecharegistro', 
            2 => 'guia.DescripcionTrama', 
            3 => 'guia.matricula', 
            4 => 'guia.documentoconductor', 
            5 => 'CONCAT(guia.nombreconductor, " ", guia.apellidoconductor)', 
            6 => 'guia.numlicencia', 
            7 => 'guia.PesoBrutoTotal',
            8 => 'guia.contrato');
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS total");
        $totalQuery = $this->get();
        $totalRecords = $totalQuery->getRow()->total;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY
        * ----------------------------
        */
        
        $this->select('guia.nguia,
            guia.fecharegistro,
            guia.DescripcionTrama,
            guia.matricula,
            guia.documentoconductor,
            CONCAT(guia.nombreconductor, " ", guia.apellidoconductor) AS NombreCompletoConductor,
            guia.numlicencia,
            guia.PesoBrutoTotal,
            guia.contrato');
            
        // $this->join('ordencompra_responsables', 'ordencompra.IDOrdenCompra = ordencompra_responsables.IDOrdenCompra', 'left');
        
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * PARA OBTENER EL NÚMERO TOTAL DE REGISTROS FILTRADOS (NUEVO)
        * ----------------------------
        */
        
        $this->select("COUNT(*) AS filtered");
        $filteredQuery = $this->get();
        if ($filteredQuery === false) {
            // echo $this->getLastQuery();
            // return [];
            $filteredRecords = $totalRecords;
        }
        
        $filteredRecords = $filteredQuery->getRow()->filtered;
        
        /*
        * ----------------------------
        * ARMADO DE VALORES QUERY (NUEVAMENTE PARA ENVIAR LA DATA)
        * ----------------------------
        */
        
        $this->select('guia.nguia,
            guia.fecharegistro,
            guia.DescripcionTrama,
            guia.matricula,
            guia.documentoconductor,
            CONCAT(guia.nombreconductor, " ", guia.apellidoconductor) AS NombreCompletoConductor,
            guia.numlicencia,
            guia.PesoBrutoTotal,
            guia.contrato');
            
        /*
        * ----------------------------
        * ARMADO DE CONDICIONES QUERY
        * ----------------------------
        */
        
        if ($get['search']['value'] != "") 
        {
            $this->groupStart(); // Inicia un grupo de condiciones
            
            foreach ($get['columns'] as $k => $column) 
            {
                if(array_key_exists($k, $fields))
                {
                    $this->orLike($fields[$k], $get['search']['value']);
                }
            }
            
            $this->groupEnd(); // Finaliza el grupo de condiciones
        }
        
        /*
        * ----------------------------
        * ORDENAMIENTO DE QUERY
        * ----------------------------
        */
        
        foreach ($get['order'] as $order) 
        {
            if(array_key_exists($order['column'], $fields))
            {
                $this->orderBy($fields[$order['column']], $order['dir']);
            }
        }
        
        /*
        * ----------------------------
        * EJECUTAR CONSULTA, LIMITAR CANTIDAD DE RESULTADOS DE QUERY Y DEVOLVER VALORES
        * ----------------------------
        */
        
        /* Despues de Codeiginiter 4.5.4*/
        $result = $this->findAll($get['length'], $get['start']);
        
        /*
        * ----------------------------
        * DEVOLVER RESULTADOS Y LOS DATOS DE PAGINACIÓN
        * ----------------------------
        */
        
        return [
            'draw' => $get['draw'], // Número de la petición para sincronizar
            'recordsTotal' => $totalRecords, // Total de registros sin filtrar
            'recordsFiltered' => $filteredRecords, // Total de registros después de aplicar filtros
            'data' => $result // Los datos actuales para mostrar
        ];
    }
    
    public function listadoNumeroGuiaRemisionSinAnulacion($array)
    {
        $this->select('guia.nguia,
            guia.contrato');
        
        $this->join('anulacion', 'guia.nguia = anulacion.nguia', 'left');
        
        $this->where('anulacion.id IS NULL');
        
        if(!empty($array))
        {
            if(isset($array['variable']) && $array['variable'] != '' && $array['variable'] != null)
            {
                $this->like('guia.nguia', $array['variable']);
            }
        }
        
        $datos = $this->findAll();
        return $datos;
    }
}