<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class Referidos extends BaseController
{
	public function __construct(){
	    $this->referidoColaborador  = new \App\Models\ReferidoColaboradorModel();
        $this->venta                = new \App\Models\VentaModel();
        $this->agenda               = new \App\Models\AgendaModel();
        $this->facturacion          = new \App\Models\FacturacionModel();
        $this->referido             = new \App\Models\ReferidoModel();
        $this->cliente              = new \App\Models\ClienteModel();
        $this->leadModelo           = new \App\Models\LeadModel();
        
        $this->correoStatusReferido = new \App\Models\CorreoStatusReferidosModel();
	}

    /**************************** SUPERCOLABORADOR ****************************/
    
	public function viewSupercolaborador()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $data = array (
				'session'                   => 'on',
				'titulo'                    => 'Supercolaborador | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Supercolaborador',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Supercolaborador",
				'subtitulo'                 => 'Supercolaboradorl'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('referidos/supercolaborador',$data);		
        } else {
            return view('errors/500');
        }
	}
	
	public function registrarReferidoSupercolaborador()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
	    $msjError               = TRUE;
        $telefonouno            = $this->request->getPost('telefono1');
        $segmento               = $this->request->getPost('segmento');
        $nombcliente            = $this->request->getPost('nombre_y_apellido_ref');
        $matriculacolaborador   = $this->items['matriculaLog'];
        $nombrecolaborador      = ucwords(mb_strtolower($this->items['nombres'].' '.$this->items['apellidos']));
        
        //Variables estaticas de ventas
        $ingresokit         = 0;
        $ingresoextras      = 0;
        $ingresototal       = 0;
        $matriculausuario   = $matriculacolaborador;
        $categoria          = NULL;
        $TCTipoVenta        = 'Televenta';
        $tipotvz            = 'ReferidoColaborador';
        $matricula          = 'MGR511';
        $nombcomercial      = 'ALEJANDRO DEL SANTE';
        $dc                 = '511';
        $jefeventa          = 'MGR511';
        $idusuario          = 3676;
        $tipoventa          = 'RE';
        $asignado           = 'SI3872';
        $estadoventa        = NULL;
        $direccion          = NULL;
        $distrito           = 0;
        $nprospecto         = NULL;
        $mesesautorizados   = 0;
        $preciokit          = 0;
        $totalextra         = 0;
        $extraautorizado    = NULL;
        $formadepago        = NULL;
        $n590               = NULL;
        $PAI                = NULL;
        $leadid             = NULL;
        $estadotelecierre   = NULL;

        $fecharegistroagenda = date("Y-m-d H:i:s");
        $fecharegistrofacturacion = date("Y-m-d H:i:s");
        $fecharegistroventa = date("Y-m-d H:i:s");

        $GestionOrigen  = 'VENTA';

        $telefonodos    = NULL;
        $correo         = NULL;
        $resumenventa   = NULL;
        $mesteleventa   = date("M-Y");
        $prioridad      = "Alta";
        $HabilitadoTV   = "SI";
        
        $origen = 'REFERIDO COLABORADOR';

        $error = '';
        $error .= $this->complementos->validaCampo($telefonouno, 'required|trim|numeric|minlength[7]|maxlength[9]', 'Telefono');
        $error .= $this->complementos->validaCampo($segmento, 'required|trim|name|minlength[1]|maxlength[100]', 'Segmento');
        $error .= $this->complementos->validaCampo($nombcliente, 'required|trim|name|minlength[1]|maxlength[100]', 'Cliente');
        $error .= $this->complementos->validaCampo($matriculacolaborador, 'required|trim|alphanumeric|minlength[1]|maxlength[6]', 'Matrícula');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            exit;
        }

	    /*
        * ----------------------------
        * ARMAR Y REGISTRAR NUEVO CLIENTE
        * ----------------------------
        */
        
        $dataC = array(
            'IdGeografico'  => $distrito,
            'NombApellido'  => $nombcliente,
            'Telefonouno'   => $telefonouno,
            'Correo'        => $correo,
            'Direccion'     => $direccion,
            'Segmento'      => $segmento
        );

        $lastIdC = $this->cliente->insert($dataC, TRUE);

        if ($lastIdC !== FALSE) {
            
    	    /*
            * ----------------------------
            * ARMAR Y REGISTRAR NUEVA VENTA
            * ----------------------------
            */
            
            $dataV = array(
                'IdUsuario'                 =>$idusuario,
                'IdCliente'                 =>$lastIdC,
                'Matricula'                 =>$matricula,
                'Comercial'                 =>$nombcomercial,
                'CC'                        =>$dc,
                'JefeVenta'                 =>$jefeventa,
                'CategoriaVenta'            =>$categoria,
                'TipoVenta'                 =>$tipoventa,
                'Segmento'                  =>$segmento,
                'NProspectoCC'              =>$nprospecto,
                'PrecioKit'                 =>$preciokit,
                'TotalExtra'                =>$totalextra,
                'IngresoKIT'                =>$ingresokit,
                'IngresoExtras'             =>$ingresoextras,
                'IngresoTotal'              =>$ingresototal,
                'EstadoVenta'               =>$estadoventa,
                'ExtraAutorizado'           =>$extraautorizado,
                'MesesAutorizado'           =>$mesesautorizados,
                'N590'                      =>$n590,
                'FormaPago'                 =>$formadepago,
                'PAI'                       =>$PAI,
                'ResumenVenta'              =>$resumenventa,
                'FechaHoraREG'              =>$fecharegistroventa,
                'GestorOrigen'              =>$matriculausuario,
                'CCOriginal'                =>$dc,
                'PrecioKITOriginal'         =>$preciokit,
                'TotalExtraOriginal'        =>$totalextra,
                'ExtraAutorizadoOriginal'   =>$extraautorizado,
                'MesesAutorizadoOriginal'   =>$mesesautorizados,
                'FormaPagoOriginal'         =>$formadepago,
                'PAIOriginal'               =>$PAI,
                'ResumenVentaOriginal'      =>$resumenventa,
                'TCTipoVenta'               =>$TCTipoVenta,
                'TCGestor'                  =>$matricula,
                'EstadoTelecierre'          =>$estadotelecierre,
                'TipoTV'                    =>$tipotvz,
                'GestorMKT'                 =>$asignado,
                'MesTeleventa'              =>$mesteleventa,
                'LeadID'                    =>$leadid,
                'Prioridad'                 =>$prioridad,
                'HabilitadoTV'              => $HabilitadoTV,
                'OrigenVisita'              =>$origen,
                'FechaHoraTransferenciaTC'  =>$fecharegistroventa,
                'MotivoTransferencia'       =>'ReferidoColaborador'
            );
            
            $lastIdV = $this->venta->insert($dataV, TRUE);

            if ($lastIdV !== FALSE) {
                
        	    /*
                * ----------------------------
                * ARMAR Y REGISTRAR NUEVA AGENDA
                * ----------------------------
                */
                
                $dataA = array(
                    'IdVenta'       => $lastIdV,
                    'FechaHoraREG'  => $fecharegistroagenda,
                    'GestionOrigen' => $GestionOrigen
                );
                $lastIdA = $this->agenda->insert($dataA, TRUE);
                
        	    /*
                * ----------------------------
                * ARMAR Y REGISTRAR NUEVA FACTURACIÓN
                * ----------------------------
                */
                
                $dataF = array(
                    'IdVenta'       => $lastIdV,
                    'FechaHoraREG'  => $fecharegistrofacturacion,
                    'GestionOrigen' => $GestionOrigen
                );
                $lastIdF = $this->facturacion->insert($dataF, TRUE);                

        	    /*
                * ----------------------------
                * ARMAR Y REGISTRAR NUEVO REFERIDO COLABORADOR
                * ----------------------------
                */
                
                $dataR = array(
                    'Matricula'         => $matriculacolaborador,
                    'Telefono'          => $telefonouno,
                    'Cliente'           => strtoupper($nombcliente),
                    'Segmento'          => $segmento,
                    'Estado'            => 'Transferido',
                    'FechaHoraREG'      => date("Y-m-d H:i:s"),
                    'IdVenta'           => $lastIdV,
                    'NombreColaborador' =>$nombrecolaborador
                );
                $lastIdR = $this->referidoColaborador->insert($dataR, TRUE);

                if ($lastIdR !== FALSE) {
                    // EnvioCorreoMasterbase($nombcliente,$segmento,$nombrecolaborador,$matriculacolaborador);
                    
        		    /*
                    * ----------------------------
                    * ENVIO DE CORREO INFORMANDO SOBRE REFERIDO
                    * ----------------------------
                    */
                    
                    $arrayCuerpo = array(
                        'NombreCliente'         => mb_strtoupper($nombcliente) ,
                        'MatriculaColaborador'  => mb_strtoupper($matriculacolaborador) ,
                        'NombreColaborador'     => $nombrecolaborador,
                        'Segmento'              => ($segmento=='RES'?'RESIDENCIAL':'NEGOCIO')
                    );
            
                    $cuerpo = $this->plantillasCorreo->cuerpoConfirmacionReferidoColaborador($arrayCuerpo);
                    
                    $asunto='CREACION DE REFERIDO';
                    
                    $configCorreo = array(
                        "NOMBRE_ORIGEN" => "Verisure Perú",
                        "CORREO_ORIGEN" => 'certificaciondelaventa@verisure.pe',
                        "CORREOS_DESTINOS" => array('joseenrique.nanquen@verisure.pe'),
                        "CORREOS_COPIA" => array(),
                        "CORREOS_OCULTO" => array('josejesus.cuadros@verisure.pe'),
                        "ASUNTO" => $asunto,
                        "MENSAJE" => $cuerpo
                    );
            
                    $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
                    
                    $dataCorreo = array(
                        "IDReferencia"      => $lastIdR,
                        "TablaReferencia"   => "tblreferidocolaborador",
                        "Momento"           => "REGISTRO SUPERCOLABORADOR",
                        "Response"          => $estadoCorreo['RESPUESTA'],
                        "Error"             => $estadoCorreo['ERROR'],
                        'UsuarioCrea'       => $this->items['id'],
                        'FechaCrea'         => $fechaActual,    
                        'Localhost'         => $this->request->getIPAddress()
                    );
        
                    $this->correoStatusReferido->insert($dataCorreo, TRUE);
                    
                    $message = sprintf($this->mensajeError->msg502, strtoupper($nombcliente));
                    echo "<script> Swal.fire({
                          title: 'Hemos registrado los datos de forma correcta, ¡gracias!',
                              icon: 'success',
                              confirmButtonText: 'Salir',
                              confirmButtonColor: '#00a37d',
                            })</script>";
                    // echo $this->alertas->alertaExito($message);
                    echo $this->alertas->refrescar(3);
                }
            }
        }
	}
	
	/**************************************************************************/
	
    /****************************** REFERIDO ATC ******************************/
    
	public function viewReferidoATC()
	{
	    if (isset($this->items['id'])) 
        {
			$data = array (
				'session'                   => 'on',
				'titulo'                    => 'Alarma Adicional | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Alarma Adicional',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Alarma Adicional",
				'subtitulo'                 => 'Alarma Adicional'
			);
			
			$data = array_merge($data, $this->items);
			
			return view('referidos/referidos_atc',$data);			
		} 
		else 
		{
		    return view('errors/500');
		}
	}
	
	public function registrarReferido()
    {
        
        if(!$this->session->get('sesionUsuario')['accesoTmpId']) {
            
            $error = "<li>No tienes los permisos requeridos. Por favor, ponte en contacto con desarrollo@verisure.pe</li>";
            $this->respuestaErronea($error);
        }

        $fechaActual            = date("Y-m-d H:i:s");
        $tipoReferido           = $this->request->getPost('txtTipoReferido_ic');
        $matriculausuario       = $this->session->get('sesionUsuario')['accesoTmpMatricula'];
        $nombresapellidosUsuario=trim($this->session->get('sesionUsuario')['accesoTmpNombres'].' '.$this->session->get('sesionUsuario')['accesoTmpApellidos']);
        
        $error = '';
        
        $error .= $this->complementos->validaCampo($tipoReferido, 'required|trim|minlength[1]|maxlength[255]', 'TipoReferido');
        
  
        if ($tipoReferido == "ClienteATC") {
            
            $origen = 'MAX_2daAlarma_Cliente';
            $gestion="transferencias_atc";
    
            $nombreCliente      = $this->request->getPost('txtnombreCliente_ic');
            $apellidoCliente    = $this->request->getPost('txtapellidoCiente_ic');
            $telefonoCliente    = $this->request->getPost('txttelefonoCliente_ic');
            $segmentoCliente    = $this->request->getPost('txtsegmentoCliente_ic');
            $comentarioCliente  = trim($this->request->getPost('txtcomentarioCliente_ic'));
            
            $error .= $this->complementos->validaCampo($nombreCliente, 'required|trim|minlength[1]|maxlength[50]', 'Nombre Cliente');
            $error .= $this->complementos->validaCampo($apellidoCliente, 'required|trim|minlength[1]|maxlength[50]', 'Apellido Cliente');
            $error .= $this->complementos->validaCampo($telefonoCliente, 'required|trim|minlength[8]|maxlength[9]', 'Telefono');
            $error .= $this->complementos->validaCampo($segmentoCliente, 'required|trim|minlength[3]|maxlength[20]', 'Segmento');
            $error .= $this->complementos->validaCampo($comentarioCliente, 'trim|minlength[1]|maxlength[255]', 'Comentario Cliente');


            if ($error != '') {
                $this->respuestaErronea($error);
            }


            $dataL = array(
                'IdUsuario'             => 945, //Usuario de matricula: MKTTEST
                'FechaHoraReg'          => $fechaActual,
                'FechaHoraCotizacion'   => $fechaActual,
                'Gestion'               => $gestion,
                'Nombres'               =>$nombreCliente,
                'Apellidos'             =>$apellidoCliente,
                'Telefono'              => $telefonoCliente,
                'Origen'                => $origen,
                'Observaciones'         => $comentarioCliente,
                'Segmento'              => $segmentoCliente,
                'Vueltas'               => 0
            );

            $lastLead=$this->leadModelo->insert($dataL, TRUE);
            
            if ($lastLead !== FALSE) {

                $lastIdR = $this->insertReferido($matriculausuario, $telefonoCliente, $nombreCliente, $apellidoCliente, $segmentoCliente, $fechaActual, $lastLead, $nombresapellidosUsuario, $tipoReferido, $comentarioCliente,'');
                
                if ($lastIdR !== FALSE) {
                    $formattedLeadID = 'LeadMAX' . str_pad($lastIdR, 9, '0', STR_PAD_LEFT);
                    
                    $data = array(
                        'LeadID' => $formattedLeadID // Asignar el LeadID formateado
                    );
    
    
                    $this->leadModelo->update([$lastLead], $data);
                    $this->respuestaExitosa();
                }
            }

        } else {

            $origen                 = 'MAX_2daAlarma_ReferidoCliente';
            $gestion                = "transferencias_atc";            
            $motivotransferencia    = "ReferidoClienteATC";
            
            $nombreRefiereCliente   = $this->request->getPost('txtnombreCliente_ir');
            $apellidoRefiereCliente = $this->request->getPost('txtapellidoCliente_ir');
            $referidos              = $this->request->getPost('correlativo');
            $auxPrimerNombre        = $this->request->getPost('auxPrimerNombreiRef');
            $auxPrimerApellido      = $this->request->getPost('auxPrimerApellidoiRef');
            $auxTelefono            = $this->request->getPost('auxTelefonoiRef');
            $auxSegmento            = $this->request->getPost('auxSegmentoiRef');
            $auxComentario          = $this->request->getPost('auxComentarioiRef');
            
            $nombreapellidoRefiereCliente=trim($nombreRefiereCliente.' '.$apellidoRefiereCliente);
                
     		$error .= $this->complementos->validaCampo($nombreRefiereCliente, 'required|trim|minlength[1]|maxlength[50]', 'Nombre del Cliente Refiere');
    		$error .= $this->complementos->validaCampo($apellidoRefiereCliente, 'required|trim|minlength[1]|maxlength[50]', 'Apellido del Cliente Refiere');
    		
            if(empty($referidos)){
                $error .= "<li>No hay Referidos agregados!!.</li>";
            }
            
            
            if ($error != '') {
                $this->respuestaErronea($error);
            }
            


            $dataDetalle = array();
    
            foreach($referidos as $key)
            {

                $nombreCliente = $auxPrimerNombre[$key];
                $apellidoCliente = $auxPrimerApellido[$key];
                $telefonoCliente = $auxTelefono[$key];
                $segmentoCliente = $auxSegmento[$key];
                $comentarioCliente = $auxComentario[$key];                


                $dataL = array(
                    'IdUsuario'     => 945, //Usuario de matricula: MKTTEST
                    'FechaHoraReg'  => $fechaActual,
                    'FechaHoraCotizacion'=> $fechaActual,
                    'Gestion'       => $gestion,
                    'Nombres'       =>$nombreCliente,
                    'Apellidos'     =>$apellidoCliente,
                    'Telefono'      => $telefonoCliente,
                    'Origen'        => $origen,
                    'Observaciones' => $comentarioCliente,
                    'Segmento'      => $segmentoCliente,
                    'Vueltas'       => 0
                );
    
                $lastLead=$this->leadModelo->insert($dataL, TRUE);
                
                if ($lastLead != FALSE) {
    
                    $lastIdR = $this->insertReferido($matriculausuario, $telefonoCliente, $nombreCliente, $apellidoCliente, $segmentoCliente, $fechaActual, $lastLead, $nombresapellidosUsuario, $tipoReferido, $comentarioCliente,$nombreapellidoRefiereCliente);
                    if ($lastIdR != FALSE) {
    
                        $formattedLeadID = 'LeadMAX' . str_pad($lastIdR, 9, '0', STR_PAD_LEFT);
                        $data = array(
                            'LeadID'        => $formattedLeadID // Asignar el LeadID formateado
                        );
                    
                        $this->leadModelo->update([$lastLead], $data);
                        
                        $dataDetalle[] = array (
                            'IdReferido'    => $lastIdR
                        ); 
        
                    }
                }


            }
            
            if(count($dataDetalle)>0){
                $this->respuestaExitosa();               
                
            }else{
                $error = "<li>No se guardo ningun registro, ponte en contacto con desarrollo@verisure.pe</li>";
                $this->respuestaErronea($error);                
            }
                        
            
            
            
        }
        
    }
    
    private function respuestaErronea($error)
    {
        $message = sprintf($this->mensajeError->msg201, $error);
        $resultado = array(
            'ejecucion'  => false,
            'popup' => false,
            'mensaje1'  => (string) $this->alertas->alertaError($message),
            'mensaje2'  => (string) ""
        );
        echo json_encode($resultado);
        exit;
    }
    
    private function insertReferido($matriculausuario, $telefono, $nombre, $apellido, $segmento, $fechaActual, $lastIdLead, $nombresapellidosUsuario, $tipoReferido, $comentario,$nombreapellidoRefiereCliente)
    {
        $dataR = array(
                'Matricula'  => $matriculausuario,
                'Telefono'   => $telefono,
                'Cliente' => trim($nombre.' '.$apellido),
                'Segmento'  => $segmento,
                'Estado' => 'Transferido',
                'FechaHoraREG'  => $fechaActual,
                'IdLead'  => $lastIdLead, 
                'NombreColaborador'  => $nombresapellidosUsuario,
                'TipoReferido'  => $tipoReferido,
                'Comentario'  => $comentario,
                'RefiereCliente'=>$nombreapellidoRefiereCliente
        );

        return $this->referido->insert($dataR, TRUE);
    }
    
    private function respuestaExitosa()
    {
        $resultado = array(
            'ejecucion'  => true,
            'popup' => false,
            'mensaje1'  => (string) "<script> Swal.fire({
                title: 'Hemos registrado los datos de forma correcta, ¡gracias!',
                icon: 'success',
                confirmButtonText: 'Salir',
                confirmButtonColor: '#00a37d',
            })</script>". $this->alertas->refrescar(2),
            'mensaje2'  => (string) ""
        );
        echo json_encode($resultado);
        exit();
    }   


	/**************************************************************************/
	
    /*********************** REGIÓN PROVINCIA *********************************/
    
	/**************************************************************************/
	
    /************************ REGIÓN DISTRITO *********************************/
    
	/**************************************************************************/
	
    /**************************** MONEDAS *************************************/
    
	/**************************************************************************/
	
    /***************************** TIPOS DOCUMENTO ****************************/
    
	/**************************************************************************/
	
    /************************** ESTRUCTURA DIRECCIÓN **************************/
    
	/**************************************************************************/
	
    /**************************** ESTRUCTURA ÁREAS ****************************/
    
	/**************************************************************************/
	
    /*************************** ESTRUCTURA SUBÁREAS **************************/
    
	/**************************************************************************/
	
    /******************* ESTRUCTURA SUBÁREAS - DELEGACIONES *******************/
    
	/**************************************************************************/
	
    /************************* ESTRUCTURA DELEGACIONES ************************/
    
	/**************************************************************************/
	
    /************************* ESTRUCTURA DEPARTAMENTAL ************************/
    
	/**************************************************************************/
	
    /******************************** USUARIOS ********************************/
    
	/**************************************************************************/
	
	
}