<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

use Box\Spout\Writer\Common\Creator\WriterEntityFactory;
use Box\Spout\Common\Entity\Row;

class GuiaRemision extends BaseController
{
	public function __construct(){
	    $this->usuarios = new \App\Models\UsuarioModel();
	    $this->direcciones = new \App\Models\DireccionModel();
	    
        $this->estructuraDelegaciones = new \App\Models\EstructuraDelegacionModel();
        
        $this->regionDistrito = new \App\Models\RegionDistritoModel();
        
	    $this->item = new \App\Models\ItemModel();
        $this->tipoTraslado = new \App\Models\TipoTrasladoModel();
	    $this->itemTipoTraslado = new \App\Models\ItemTipoTrasladoModel();
	    
	    $this->guiaRemision = new \App\Models\GuiaRemisionModel();
	    $this->guiaRemisionEnvio = new \App\Models\GuiaRemisionEnvioModel();
	    $this->guiaRemisionAnulacion = new \App\Models\GuiaRemisionAnulacionModel();
	    
	    //Temporal
	    $this->proveedor = new \App\Models\temporales\ProveedorModel();
	}

    /****************************** GENERAR GUÍA ******************************/
    
    public function nuevaGuiaRemision()
    {
	    if (isset($this->items['id'])) 
    	{
    	    $data = array (
				'session'                   => 'on',
				'titulo'                    => 'Generar Guía de Remisión | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Generar Guía de Remisión',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Generar Guía de Remisión",
				'subtitulo'                 => 'Generar Guía de Remisión',
				'elementos'                 => array()
			);
			
			$data = array_merge($data, $this->items);
			
			return view('guia_remision/nueva_guia_remision',$data);		
        } else {
            return view('errors/500');
        }
    }
    
	public function importarItemsGuiaRemision()
	{
	    /*
        * ----------------------------
        * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
        * ----------------------------
        */
        
        $csv = $this->request->getFile("itemsFile");

		/*
        * ----------------------------
        * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
        * ----------------------------
        */
        
        if (! $csv->isValid()) {
            $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
			echo $this->alertas->alertaError($message);
			exit;
        }
        

        /** ----------------------------
        * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
        * ----------------------------
        */
        
        $validationRule = [
            'itemsFile' => [
                'mime_in[itemsFile,text/csv,text/plain,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/msexcel,application/xls,application/x-xls]',
                'ext_in[itemsFile,csv,xlsx,xls]'
            ],
        ];

        if (! $this->validate($validationRule)) {
            $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
			echo $this->alertas->alertaError($message);
			exit;
        }

		/*
        * ----------------------------
        * VALIDAR SEPARADOR CSV
        * ----------------------------
        */
		$numeroColumnas = 2; //numero de columnas en el archivo
		$separadorCSV = $this->complementos->validarSeparadorCSV($csv, $numeroColumnas);
        
        if (!$separadorCSV) {
            $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
			echo $this->alertas->alertaError($message);
			exit;
        }

        /*
        * ----------------------------
        * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
        * ----------------------------
        */
        
        //Declaramos variables
        $fila = 0;
        $filasError = array();
        $ejecutarInsert = true;
        //Abrimos el archivo
        $handle = fopen($csv, "r");
        $codigosExistentes = array();

        //Recorremos las filas del CSV
        while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
        {
            $fila++;

            if($fila>1)
            {
                $data = array_map("utf8_encode", $data);
                //Asignamos valores de CSV a variables locales

                $coditem = $data[0];
                
                $cantidad = $data[1];

                //Validamos existencia de Item:
                $datoscodItem = $this->item->where("coditem",trim($coditem))->first();
                if(empty($datoscodItem))
                {
                    $filasError[$fila]['coditem'] = "coditem [".$coditem."] NO EXISTENTE";
                    $ejecutarInsert = false;
                }
                
                if(array_key_exists($coditem, $codigosExistentes))
                {
                    $filasError[$fila]['coditem'] = "coditem [".$coditem."] YA FUE AGREGADO EN LA FILA [".$codigosExistentes[$coditem]."]";
                    $ejecutarInsert = false;
                }
                
                //Validamos Cantidad:
                
                if(empty($cantidad))
                {
                    $filasError[$fila]['Cantidad'] = "LA CANTIDAD NO DEBE ESTAR VACÍA Y DEBE SER MAYOR A 0";
                    $ejecutarInsert = false;
                }
                else if(!is_numeric($cantidad))
                {
                    $filasError[$fila]['Cantidad'] = "LA CANTIDAD NO ES UN NÚMERO VÁLIDO";
                    $ejecutarInsert = false;
                }
                else if($cantidad <= 0)
                {
                    $filasError[$fila]['Cantidad'] = "LA CANTIDAD DEBE SER MAYOR A 0";
                    $ejecutarInsert = false;
                }
                
                $codigosExistentes[$coditem] = $fila;
            }
        }

        fclose($handle);
        
        if(!$ejecutarInsert)
        {
            $raiz = 'public/';
            $nombre = 'error.txt';
            $file = 'public/error.txt';
            
            if (file_exists($file)) {
                unlink($file);
            }
            
            $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
            #  Se establecen los datos que va a conterner el archivo
            foreach($filasError as $key=>$value)
            {
                fwrite($txt, "FILA: ".$key."\n");
                foreach($value as $celda=>$error)
                {
                    fwrite($txt, $celda.": ".$error."\n");
                }
            }
            #  Se hace el ciere para no sobre escribir datos 
            fclose($txt);

//             $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
//             $salida1 = $this->alertas->alertaError($message);
//             $salida2 = $this->alertas->descargaArchivoTXT($nombre);
// 			echo $salida1.$salida2;
			//echo $salida1;
            
            $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
            $salida1 = $this->alertas->alertaError($message);
            $salida2 = $this->alertas->descargaArchivoTXT($nombre);

            $resultado = array(
    			'error'     => true,
    			'mensaje'   => (string) $salida1.$salida2
    		);
    		
			echo json_encode($resultado);
            
			exit;
        }


		/*
        * ----------------------------
        * RECORRER ARCHIVO Y EJECUTAR INSERTS
        * ----------------------------
        */
            
        $filainsert = 0;
        //Abrimos el archivo
        $handleItems = fopen($csv, "r");
		$resultado = [];
        //Recorremos las filas del CSV
        while (($data = fgetcsv($handleItems, 0, $separadorCSV)) !== FALSE)
        {
            $data = array_map("utf8_encode", $data);
            $filainsert++;
            if($filainsert > 1)
            {
				// $whereItem = array(
				// 	'eliminacion_logica' => 1,
				// 	'coditem'=> '7002'
				// ); 

				$whereItem = array(
					'eliminacion_logica' => 1,
					'coditem' => trim($data[0]) //coditem
				);
				$listaItem = $this->item->where("coditem",trim($data[0]))->first(); 
				$cantidad = $data[1];
				$resultado[] = array(
							'id' => (string) $listaItem['id_item'],
							'text' => (string) $listaItem['coditem'] . '-' . $listaItem['descripcion'],
							'peso' => (string) $listaItem['peso'],
							'cantidaditems' => $cantidad
				);
				
			}
		}

		echo json_encode($resultado);
	}
	
	public function registrarGuiaRemision()
	{
	    $fechaActual = date("Y-m-d H:i:s");
	    
	    $msjError = TRUE;
		$matricula = $this->items['matriculaLog'];
		$tipotraslado = $this->request->getPost('tipotraslado');
		$codigoSunatTrama = $this->request->getPost('MotivoTraslado');
		$DescripcionTrama = $this->request->getPost('DesMotivoTras');
		$correoreceptor = $this->request->getPost('correo');
		$fechadetraslado = $this->request->getPost('fechadetraslado');
		$puntopartida = $this->request->getPost('puntopartida');
		$idpuntopartida = $this->request->getPost('idpuntopartida');
		$codigoubigeopuntopartida = $this->request->getPost('codigoubigeopuntopartida');
		$puntollegada = $this->request->getPost('puntollegada');
		$idpuntollegada = $this->request->getPost('idpuntollegada');
		$codigoubigeopuntollegada = $this->request->getPost('codigoubigeopuntollegada');
		$cliente = $this->request->getPost('cliente');
		$tipodocumento = $this->request->getPost('tipodocumento');
		$documento = $this->request->getPost('documento');
		$contrato = $this->request->getPost('contrato');
		$nplaca = $this->request->getPost('nplaca');
		$tipodocumentoconductor = $this->request->getPost('tipodocumentoconductor');
		$documentoconductor = $this->request->getPost('documentoconductor');
		$nombreconductor = $this->request->getPost('nombreconductor');
		$apellidoconductor = $this->request->getPost('apellidoconductor');
		$numlicencia = $this->request->getPost('numlicencia');
		$lbljsonofrecido = $this->request->getPost('lbljsonofrecido');
		$unidadmedida = $this->request->getPost('unidadmedida');
		$PesoBrutoTotal = $this->request->getPost('PesoBrutoTotal');
		$nombreReceptor = $this->request->getPost('nombreApellidoReceptor');
		
        if($lbljsonofrecido!="")
        {
            $lbljsonofrecido = json_decode($lbljsonofrecido, true);
        }
        else
        {
            $lbljsonofrecido=array();
        }

		$delegacionpartida = $this->request->getPost('delegacionpartida');
		$delegacionllegada = $this->request->getPost('delegacionllegada');
		$observacion = $this->request->getPost('observacion');

		$distritopartida = $this->request->getPost('distritopartida');
		$distritollegada = $this->request->getPost('distritollegada');
		$departamentopartida = $this->request->getPost('departamentopartida');
		$departamentollegada = $this->request->getPost('departamentollegada');
		
		$codigosunatpartida = $this->request->getPost('codigosunatpartida');
		$codigosunatllegada = $this->request->getPost('codigosunatllegada');
		
		$error = '';
		$error .= $this->complementos->validaCampo($matricula, 'required|trim|minlength[6]|maxlength[7]', 'Matricula');
		$error .= $this->complementos->validaCampo($tipotraslado, 'required|trim|minlength[1]|maxlength[7]', 'Tipo Traslado');
		
		/* NUEVAS CONDICIONES*/
		$error .= $this->complementos->validaCampo($cliente, 'required|trim|minlength[3]|maxlength[255]', 'Nombre Cliente');
		$error .= $this->complementos->validaCampo($tipodocumento, 'required|trim|minlength[1]|maxlength[4]', 'Tipo Documento');
		
		if($tipodocumento==1)
		{
		    $error .= $this->complementos->validaCampo($documento, 'required|trim|minlength[8]|maxlength[8]', 'Documento');    
		}
		else if($tipodocumento==6)
		{
		    $error .= $this->complementos->validaCampo($documento, 'required|trim|minlength[11]|maxlength[11]', 'Documento');
		}
		else if($tipodocumento==4 || $tipodocumento==7)
		{
		    $error .= $this->complementos->validaCampo($documento, 'required|trim|minlength[9]|maxlength[12]', 'Documento');    
		}
		
		if (is_array($correoreceptor)) 
		{
            $correoreceptor_filtrado = array_filter($correoreceptor, function($valor) {
                return $valor !== "" && $valor !== 0 && $valor !== null;
            });
    
            // Define un array con los valores no válidos que deseas eliminar
            $valores_a_eliminar = array("", 0, null);
            
            // Realiza la diferencia entre el array original y el array filtrado
            $correo = array_diff($correoreceptor, $valores_a_eliminar);
            
            if (count($correo) == 0) 
            {
                $error .= '<li>Completar campos de <b><small>Correos de envío</small></b></li>';
            } 
            else 
            {
                for ($i = 0; $i < count($correo); $i++) 
                {
				    $error .= $this->complementos->validaCampo($correo[$i], 'required|trim|email|minlength[1]|maxlength[50]', $correo[$i]);
				}
			}
		}

		$error .= $this->complementos->validaCampo($fechadetraslado, 'required|trim|minlength[1]|maxlength[20]', 'Fecha Traslado');

        //VALIDAR PUNTO DE PARTIDA Y DESTINO
        if($tipotraslado==1)
        {
            $error .= $this->complementos->validaCampo($puntopartida, 'required|trim', 'Punto de Partida');
            $error .= $this->complementos->validaCampo($distritopartida, 'required|trim', 'Distrito de Partida');
            $error .= $this->complementos->validaCampo($departamentopartida, 'required|trim', 'Departamento de Partida');
            $error .= $this->complementos->validaCampo($delegacionpartida, 'required|trim', 'Delegacion de Partida');
        }
        else if($tipotraslado==2 || $tipotraslado==3 || $tipotraslado==8 || $tipotraslado==9)
        {
            $error .= $this->complementos->validaCampo($puntopartida, 'required|trim', 'Punto de Partida');
            $error .= $this->complementos->validaCampo($distritopartida, 'required|trim', 'Distrito de Partida');
            $error .= $this->complementos->validaCampo($departamentopartida, 'required|trim', 'Departamento de Partida');
            $error .= $this->complementos->validaCampo($delegacionpartida, 'required|trim', 'Delegacion de Partida');
            
            $error .= $this->complementos->validaCampo($puntollegada, 'required|trim', 'Punto de Llegada');
            $error .= $this->complementos->validaCampo($distritollegada, 'required|trim', 'Distrito de Llegada');
            $error .= $this->complementos->validaCampo($departamentollegada, 'required|trim', 'Departamento de Llegada');
            
            if($tipotraslado==3 || $tipotraslado==8 || $tipotraslado==9){
                $error .= $this->complementos->validaCampo($contrato, 'required|trim|minlength[7]|maxlength[7]', 'Contrato');
            }
    
        }
        else if($tipotraslado==4)
        {
            $error .= $this->complementos->validaCampo($puntopartida, 'required|trim', 'Punto de Partida');
            $error .= $this->complementos->validaCampo($distritopartida, 'required|trim', 'Distrito de Partida');
            $error .= $this->complementos->validaCampo($departamentopartida, 'required|trim', 'Departamento de Partida');

            $error .= $this->complementos->validaCampo($puntollegada, 'required|trim', 'Punto de Llegada');
            $error .= $this->complementos->validaCampo($distritollegada, 'required|trim', 'Distrito de Llegada');
            $error .= $this->complementos->validaCampo($departamentollegada, 'required|trim', 'Departamento de Llegada');
            $error .= $this->complementos->validaCampo($delegacionllegada, 'required|trim', 'Delegacion de Llegada');
            
            $error .= $this->complementos->validaCampo($contrato, 'required|trim|minlength[7]|maxlength[7]', 'Contrato');
        }
        else if($tipotraslado==5)
        {
            $error .= $this->complementos->validaCampo($puntopartida, 'required|trim', 'Punto de Partida');
            $error .= $this->complementos->validaCampo($distritopartida, 'required|trim', 'Distrito de Partida');
            $error .= $this->complementos->validaCampo($departamentopartida, 'required|trim', 'Departamento de Partida');

            $error .= $this->complementos->validaCampo($puntollegada, 'required|trim', 'Punto de Llegada');
            $error .= $this->complementos->validaCampo($distritollegada, 'required|trim', 'Distrito de Llegada');
            $error .= $this->complementos->validaCampo($departamentollegada, 'required|trim', 'Departamento de Llegada');
                                                
        }
        else if($tipotraslado==6 || $tipotraslado==7)
        {
            $error .= $this->complementos->validaCampo($puntopartida, 'required|trim', 'Punto de Partida');
            $error .= $this->complementos->validaCampo($distritopartida, 'required|trim', 'Distrito de Partida');
            $error .= $this->complementos->validaCampo($departamentopartida, 'required|trim', 'Departamento de Partida');
            $error .= $this->complementos->validaCampo($delegacionpartida, 'required|trim', 'Delegacion de Partida');

            $error .= $this->complementos->validaCampo($puntollegada, 'required|trim', 'Punto de Llegada');
            $error .= $this->complementos->validaCampo($distritollegada, 'required|trim', 'Distrito de Llegada');
            $error .= $this->complementos->validaCampo($departamentollegada, 'required|trim', 'Departamento de Llegada');
            $error .= $this->complementos->validaCampo($delegacionllegada, 'required|trim', 'Delegacion de Llegada');
                                                
        }
        
        //VALIDAR DATOS DEL CONDUCTOR
        $error .= $this->complementos->validaCampo($nplaca, 'required|trim|minlength[6]|maxlength[6]', 'Placa');
        $error .= $this->complementos->validaCampo($tipodocumentoconductor, 'required|trim|minlength[1]|maxlength[7]', 'Tipo de Documento del Conductor');
        $error .= $this->complementos->validaCampo($documentoconductor, 'required|trim', 'Documento del Conductor');

		if($tipodocumentoconductor==1)
		{
		    $error .= $this->complementos->validaCampo($documentoconductor, 'required|trim|minlength[8]|maxlength[8]', 'Documento del Conductor');
		}
		else if($tipodocumentoconductor==6)
		{
		    $error .= $this->complementos->validaCampo($documentoconductor, 'required|trim|minlength[11]|maxlength[11]', 'Documento del Conductor');
		}
		else if($tipodocumentoconductor==4 || $tipodocumentoconductor==7)
		{
		    $error .= $this->complementos->validaCampo($documentoconductor, 'required|trim|minlength[9]|maxlength[12]', 'Documento del Conductor');
		}        
        
        $error .= $this->complementos->validaCampo($nombreconductor, 'required|trim|minlength[2]|maxlength[50]', 'Nombre del Conductor');
        $error .= $this->complementos->validaCampo($apellidoconductor, 'required|trim|minlength[2]|maxlength[50]', 'Apellido del Conductor');
        $error .= $this->complementos->validaCampo($numlicencia, 'required|trim|minlength[9]|maxlength[10]', 'N° Licencia del Conductor');
        $error .= $this->complementos->validaCampo($observacion, 'trim|minlength[3]|maxlength[100]', 'Observacion');
        
        //VALIDAR DATOS ITEM
	    if (count($lbljsonofrecido) == 0) 
	    {
			$error .= '<li>Completar campos de <b><small>ITEM</small></b></li>';
		}
        
        $error .= $this->complementos->validaCampo($unidadmedida, 'required|trim', 'Unidad Medida');
        $error .= $this->complementos->validaCampo($PesoBrutoTotal, 'required|trim', 'Peso Bruto');

		if ($error != '') 
		{			
			$message = sprintf($this->mensajeError->msg201, $error);
			$resultado = array(
				'mensaje' => $this->alertas->alertaError($message),
				'status' => false
			);
			echo json_encode($resultado);
			exit();
		}
		
		$serie="";

		$dataInsercionGuia = array(
            'fecharegistro'=> date("Y-m-d H:i:s")
		);
		
		$lastIdGuia = $this->guiaRemision->insert($dataInsercionGuia, TRUE);
        
		if ($lastIdGuia === FALSE) 
		{
			$resultado = array(
				'mensaje' => $this->alertas->alertaError('Error al generar N°Serie'),
				'status' => false
			);
			echo json_encode($resultado);
			exit();
		}
		
		$serie = 'T001-'.$lastIdGuia;
		    
	    $dataSerie = array(
			'nguia' => $serie,
            'matricula' => $matricula,
            'tipotraslado' => $tipotraslado,
            'codigoSunatTrama' => $codigoSunatTrama,
            'DescripcionTrama' => $DescripcionTrama,
            'correo' => json_encode($correo),
            'fechadetraslado' => $fechadetraslado,
            'puntopartida' => $puntopartida,
            'idpuntopartida' => $idpuntopartida,
            'codigoubigeopuntopartida' => $codigoubigeopuntopartida,
            'puntollegada' => $puntollegada,
            'idpuntollegada' => $idpuntollegada,
            'codigoubigeopuntollegada' => $codigoubigeopuntollegada,
            'cliente' => $cliente,
            'tipodocumento' => $tipodocumento,
            'documento' => $documento,
            'contrato' => $contrato,
            'nplaca' => $nplaca,
            'tipodocumentoconductor' => $tipodocumentoconductor,
            'documentoconductor' => $documentoconductor,
            'nombreconductor' => $nombreconductor,
            'apellidoconductor' => $apellidoconductor,
            'numlicencia' => $numlicencia,
            'lbljsonofrecido' => json_encode($lbljsonofrecido),
            'unidadmedida' => $unidadmedida,
            'PesoBrutoTotal' => $PesoBrutoTotal,
            'nombreReceptor' => $nombreReceptor,
            'delegacionpartida' => $delegacionpartida,
            'delegacionllegada' => $delegacionllegada,
            'distritopartida' => $distritopartida,
            'distritollegada' => $distritollegada,
            'departamentopartida' => $departamentopartida,
            'departamentollegada' => $departamentollegada,
            'codigosunatpartida' => $codigosunatpartida,
            'codigosunatllegada' => $codigosunatllegada,
            'observacion' => $observacion,
            'idusuario_creador' => $this->items['id'],
            'tipo_creacion' => 0
	    );
	    
	    $updateId = $this->guiaRemision->update([$lastIdGuia], $dataSerie);
	    
		//GENERAR TXT Y ZIP PARA ENVIAR BASE64 A SERES Y GUARDAR ESTATUS EN BASE DE DATOS

        if(!empty($distritopartida))
        {
            $informacionRegionPartida = $this->regionDistrito->obtenerRegionxIDDistrito($distritopartida);
        }
        else
        {
            $informacionRegionPartida = array();
        }
        
        if(!empty($distritollegada))
        {
            $informacionRegionLlegada = $this->regionDistrito->obtenerRegionxIDDistrito($distritollegada);
        }
        else
        {
            $informacionRegionLlegada = array();
        }
        
        $informacionRegionPartida["codigoSunat"] = $codigosunatpartida;
        $informacionRegionLlegada["codigoSunat"] = $codigosunatllegada;
        
        $correo[] = 'guiaselectronicas@verisure.pe';
        $correo[] = 'cynthia.fabian@verisure.pe';

	    $arraySeres = array(
	        "Serie"                     => $serie,
            "Contrato"                  => $contrato,
            "Cliente"                   => $cliente,
            "TipoDocumento"             => $tipodocumento,
            "Documento"                 => $documento,
            "CodigoSunatTrama"          => $codigoSunatTrama,
            "DescripcionTrama"          => $DescripcionTrama,
            "PesoBrutoTotal"            => $PesoBrutoTotal,
            "FechaTraslado"             => $fechadetraslado,
            "InformacionPartida"        => $informacionRegionPartida,
            "PuntoPartida"              => $puntopartida,
            "InformacionLlegada"        => $informacionRegionLlegada,
            "PuntoLlegada"              => $puntollegada,
            "TipoTraslado"              => $tipotraslado,
            "PlacaVehicular"            => $nplaca,
            "TipoDocumentoConductor"    => $tipodocumentoconductor,
            "DocumentoConductor"        => $documentoconductor,
            "NombreConductor"           => $nombreconductor,
            "ApellidoConductor"         => $apellidoconductor,
            "NumeroLicencia"            => $numlicencia,
            "Items"                     => $lbljsonofrecido,
            "CorreosFijos"              => $correo,
            "Matricula"                 => $matricula,
            "NombreReceptor"            => $nombreReceptor,
            "DelegacionPartida"         => $delegacionpartida,
            "DelegacionLlegada"         => $delegacionllegada,
            "Observacion01"             => $observacion,
            "Observacion02"             => ""

	    );
	
	    $base64 = $this->complementos->generarTXTSeres($arraySeres);
	    // $responseSeres = $this->complementos->enviarTXTSeres(array('base64'=>$base64));
	    $responseSeres = "";
	    
        $dataResultado = array(
            'id_guia'           => $lastIdGuia,
            'respuestaxml'      => $responseSeres,
    		'base64'            => $base64,
    		'TipoRegistro'      => "INDIVIDUAL",
    		'UsuarioRegistra'   => $this->items['id'],
    		'FechaRegistra'     => $fechaActual,
    		'Localhost'         => $this->request->getIPAddress()
        );
        
        $this->guiaRemisionEnvio->insert($dataResultado, TRUE);
        
		$resultado = array(
			'respuestaxml' => $responseSeres,
			'serie' => $serie,
			'status' => true
		);

		echo json_encode($resultado);

		exit();
	}

	/**************************************************************************/
	
    /**************************** GUÍA DE REMISIÓN ****************************/
    
	public function listarGuiaRemision()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $data = array (
				'session'                   => 'on',
				'titulo'                    => 'Guía de Remisión | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Guía de Remisión',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Guía de Remisión",
				'subtitulo'                 => 'Guía de Remisión',
				'elementos'                 => array()
			);
			
			$data = array_merge($data, $this->items);
			
			return view('guia_remision/listar_guia_remision',$data);		
        } else {
            return view('errors/500');
        }
	}
	
	public function guiaRemisionServerside()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $adicionales = array(
                "IDPerfil"  => $this->items['idPerfil'],
                "IDUsuario" => $this->items['id']
            );
            
            /* LISTAR ORDEN DE COMPRA */
            $dataServerside = $this->guiaRemision->listaGeneralGuiaRemision($this->request->getGet(), $adicionales);
            
            foreach($dataServerside["data"] as $key=>$value)
            {
                
                $acciones = "";
                $acciones .= "<div class='dropdown d-inline-block'>
    				<button class='btn btn-soft-secondary btn-sm dropdown' type='button' data-bs-toggle='dropdown' aria-expanded='false'>
    				<i class='ri-more-fill align-middle'></i>
    				</button>
    				<ul class='dropdown-menu dropdown-menu-end'>";
    					if (in_array("UPDOCO", $this->items['permisos'])) 
            			{
            			$acciones .= "<li>
            				<a href='".base_url()."/editar-orden-compra/".$value['oc']."' class='dropdown-item'>
            					<i class='ri-pencil-fill align-bottom me-2 text-muted'></i> Editar
            				</a>
            			</li>";
            			}
            			
    				$acciones .= "</ul>
    			</div>";
                
                $dataServerside["data"][$key]['acciones'] = $acciones;
            }
            
            $datos = [
                'draw'              => $dataServerside['draw'],
                'data'              => $dataServerside['data'],
                'recordsTotal'      => $dataServerside['recordsTotal'],
                'recordsFiltered'   => (int) $dataServerside['recordsFiltered']
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
    	}
    	else 
    	{
            $datos = [
                'draw'              => 1,
                'data'              => array(),
                'recordsTotal'      => 0,
                'recordsFiltered'   => (int) 0
            ];
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
        }
	}
	
	public function importarCSVGuiasRemision()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $fechaActual = date("Y-m-d H:i:s");
    	    
    	    /*
            * ----------------------------
            * DECLARAR Y ASIGNAR VARIABLE A ARCHIVO OBTENIDO
            * ----------------------------
            */
            
            $csv            = $this->request->getFile("itemsFile");
            $usuarioSession = $this->items['id'];
    
    		/*
            * ----------------------------
            * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
            * ----------------------------
            */
            
            if (! $csv->isValid()) {
                $message = sprintf($this->mensajeError->msg201, $csv->getErrorString().'-'.$csv->getError());
    			echo $this->alertas->alertaError($message);
    			exit;
            }
            
    
            /** ----------------------------
            * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
            * ----------------------------
            */
            
            // $validationRule = [
            //     'itemsFile' => [
            //         'mime_in[itemsFile,text/csv,text/plain,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/msexcel,application/xls,application/x-xls]',
            //         'ext_in[itemsFile,csv,xlsx,xls]'
            //     ],
            // ];
            
            $validationRule = [
                'itemsFile' => [
                    'mime_in[itemsFile,text/csv,text/plain]',
                    'ext_in[itemsFile,csv]'
                ],
            ];
    
            if (! $this->validate($validationRule)) {
                $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
    			echo $this->alertas->alertaError($message);
    			exit;
            }
    
    		/*
            * ----------------------------
            * VALIDAR SEPARADOR CSV
            * ----------------------------
            */
    		$numeroColumnas = 12; //numero de columnas en el archivo
    		$separadorCSV = $this->complementos->validarSeparadorCSV($csv, $numeroColumnas);
            
            if (!$separadorCSV) {
                $message = sprintf($this->mensajeError->msg201, "No se encontró separador de CSV autorizado. Debe usar coma (,) o punto y coma (;) y eliminar celdas vacías a la derecha de la última columna.");
    			echo $this->alertas->alertaError($message);
    			exit;
            }

            /*
            * ----------------------------
            * RECORRER ARCHIVO Y VALIDAR DATOS CORRECTOS
            * ----------------------------
            */
            
            //Declaramos variables
            $fila = 0;
            $filasError = array();
            $ejecutarInsert = true;
            
            //Abrimos el archivo
            $handle = fopen($csv, "r");
    
            //Recorremos las filas del CSV
            // while (($data = fgetcsv($handle, 0, ",", ";")) !== FALSE)
            while (($data = fgetcsv($handle, 0, $separadorCSV)) !== FALSE)
            {
                $fila++;
    
                if($fila>1)
                {
                    $data = array_map("utf8_encode", $data);
                    //Asignamos valores de CSV a variables locales
    
    				$coditem                = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
    				$delegacion             = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                    $matricula              = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                    $cantidad               = (int) trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                    $docLlegada             = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
    				$puntoLlegada           = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
    				$numeroPlaca            = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
    				$documentoConductor     = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
    				$nombreConductor        = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
    				$apellidoConductor      = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
    				$brevete                = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
    				$observacion2           = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
    
                    //Validamos existencia de ITEM:
                   
                    if(empty($coditem))
                    {
                        $filasError[$fila]['Item'] = "La columna Item no puede estar vacío.";
                        $ejecutarInsert = false;
                    }
                    else
                    {
                        $whereItems = array(
                			'coditem' => trim($coditem)
                		);
                		
                        $datoscodItem = $this->item->where($whereItems)->findAll();
                     
                        if(empty($datoscodItem))
                        { 
                            $filasError[$fila]['Item'] = "El Item [".$coditem."] no se encuentra registrado en la base de datos.";
                            $ejecutarInsert = false;
                        }
                    }
                    
                    //Validamos existencia de DELEGACION:
                    
                    if(empty($delegacion))
                    {
                        $filasError[$fila]['delegacion'] = "La columna Delegacion no puede estar vacío.";
                        $ejecutarInsert = false;
                    }
                    else
                    {
                        $arrayCC = array();
            
                        $listadocc = $this->estructuraDelegaciones->listadoCCDelegacionesEstructura($arrayCC);
                        
                        $cc = array_column($listadocc, "CC");
                        
                        if(!in_array($delegacion, $cc))
                        {
                            $filasError[$fila]['Delegacion'] = "La Delegación [".$delegacion."] no existe.";
                            $ejecutarInsert = false;
                        }
                    }
    
                    //Validamos existencia de MATRICULA:
                    
                    if(empty($matricula))
                    {
                        $filasError[$fila]['Matricula'] = "La columna Matrícula no puede estar vacío.";
                        $ejecutarInsert = false;
                    }
                    else
                    {
                        $whereUsuario = array(
                            "Matricula" => $matricula
                        );
                        
                        $usuario = $this->usuarios->where($whereUsuario)->findAll();
                        
                        //Solo acepta GE, EXTERNO y matriculas registradas 
                        if(!(in_array($matricula, array("GE", "EXTERNO")) || !empty($usuario)))
                        {
                            $filasError[$fila]['Matricula'] = "La Matrícula solo acepta los valores [GE, EXTERNO] o una matrícula válida.";
                            $ejecutarInsert = false;
                        }
                    }
                    
                    //Validamos existencia de Cantidad:
                    
                    if(empty($cantidad))
                    {
                        $filasError[$fila]['Quantity'] = "La columna Cantidad no puede estar vacía.";
                        $ejecutarInsert = false;
                    }
                    else if(!is_numeric($cantidad) )
                    {
                        $filasError[$fila]['Quantity'] = "La columna Cantidad solo admite valores numéricos.";
                        $ejecutarInsert = false;
                    }
                    else if($cantidad <= 0)
                    {
                        $filasError[$fila]['Quantity'] = "La columna Cantidad solo admite valores enteros positivos (mayor a cero).";
                        $ejecutarInsert = false;
                    }
    
                    //Validamos existencia de Doc_Llegada
                    
                    if(!empty($matricula) && $matricula == "EXTERNO")
                    {
                        if(empty($docLlegada))
                        {
                            $filasError[$fila]['Doc_Llegada'] = "La columna Doc_Llegada no puede estar vacía si la columna Matricula es [EXTERNO].";
                            $ejecutarInsert = false;
                        }
                        else
                        {
                            $proveedor = $this->proveedor->where('idProveedor',$docLlegada)->first();
                            
                            if(empty($proveedor))
                            {
                                $filasError[$fila]['Doc_Llegada'] = "Doc_Llegada no se encuentra registrado en la base de datos.";
                                $ejecutarInsert = false;
                            }
                        }
                    }
                    
                    //Validamos existencia de Punto de Llegada
                    
                    if(!empty($puntoLlegada))
                    {
                        $direccion = $this->direcciones->where("id_direccion", $puntoLlegada)->first();
                        
                        if(empty($direccion))
                        {
                            $filasError[$fila]['PuntoLlegada'] = "El PuntoLlegada no se encuentra registrado en la base de datos.";
                            $ejecutarInsert = false;
                        }
                    }
                        
                    //Validamos existencia de NÚMERO DE PLACA:

    				if(!empty($numeroPlaca))
                    {
                        if(strlen($numeroPlaca) != 6){
                            $filasError[$fila]['N_Placa'] = "La columna N_Placa debe contar con 6 digitos alfanuméricos.";
                            $ejecutarInsert = false;
                        }
                    }
                    
                    //Validamos existencia de BREVETE:
                    
                    if(!empty($brevete))
                    {
                        if(strlen($brevete) != 9){
                            $filasError[$fila]['Brevete'] = "El Brevete debe contar con 9 digitos alfanuméricos.";
                            $ejecutarInsert = false;
                        }
                    }
                }
            } 
    
            fclose($handle);
            
            if(!$ejecutarInsert)
            {
                $raiz = 'public/';
                $nombre = 'error.txt';
                $file = 'public/error.txt';
                if (file_exists($file)) {
                    unlink($file);
                }
                $txt= fopen($file, 'a') or die ('Problemas al crear el archivo');
                #  Se establecen los datos que va a conterner el archivo
                foreach($filasError as $key=>$value)
                {
                    fwrite($txt, "FILA: ".$key."\n");
                    foreach($value as $celda=>$error)
                    {
                        fwrite($txt, $celda.": ".$error."\n");
                    }
                }
                #  Se hace el ciere para no sobre escribir datos 
                fclose($txt);
                
                $message = sprintf($this->mensajeError->msg201, "Se detectaron diversas inconsistencias.");
                $salida1 = $this->alertas->alertaError($message);
                $salida2 = $this->alertas->descargaArchivoTXT($nombre);
                echo $salida1.$salida2;
                exit;
            }
    
    		/*
            * ----------------------------
            * RECORRER ARCHIVO Y EJECUTAR INSERTS
            * ----------------------------
            */ 
      
    
            $filainsert = 0;
            //Abrimos el archivo
            $handleItems = fopen($csv, "r"); 
    		$resultado = [];
            //Recorremos las filas del CSV
            // while (($data = fgetcsv($handle, 0, ",", ";")) !== FALSE) 
            while (($data = fgetcsv($handleItems, 0, $separadorCSV)) !== FALSE)
            { 
                $data = array_map("utf8_encode", $data);
                $filainsert++;
                if($filainsert > 1)
                {
    				$coditem = trim($data[0]," \t\n\r\0\x0B\xc2\xa0");
    				$delegacion = trim($data[1]," \t\n\r\0\x0B\xc2\xa0");
                    $matricula = trim($data[2]," \t\n\r\0\x0B\xc2\xa0");
                    $cantidad = (int) trim($data[3]," \t\n\r\0\x0B\xc2\xa0");
                    $docLlegada = trim($data[4]," \t\n\r\0\x0B\xc2\xa0");
    				$puntoLlegada = trim($data[5]," \t\n\r\0\x0B\xc2\xa0");
    				$numeroPlaca = trim($data[6]," \t\n\r\0\x0B\xc2\xa0");
    				$documentoConductor = trim($data[7]," \t\n\r\0\x0B\xc2\xa0");
    				$nombreConductor = trim($data[8]," \t\n\r\0\x0B\xc2\xa0");
    				$apellidoConductor = trim($data[9]," \t\n\r\0\x0B\xc2\xa0");
    				$brevete = trim($data[10]," \t\n\r\0\x0B\xc2\xa0");
    				$observacionTecnico = trim($data[11]," \t\n\r\0\x0B\xc2\xa0");
    
    				// Obtener información adicional de cada coditem
    				$listaItem = $this->item->where("coditem", $coditem)->first();
    
    				// Agregar los items a un array asociativo con la matricula como clave
    				if (!isset($itemsPorMatricula[$matricula.'-'.$delegacion.'-'.$docLlegada.'-'.$puntoLlegada])) {
    					$itemsPorMatricula[$matricula.'-'.$delegacion.'-'.$docLlegada.'-'.$puntoLlegada] = [];
    
    				}
    
    				$itemsPorMatricula[$matricula.'-'.$delegacion.'-'.$docLlegada.'-'.$puntoLlegada]['items'][] = array(
    					'IdItem' => (string) $listaItem['id_item'],
    					'CodProducto' => (string) $listaItem['coditem'], 
    					'Descripcion' => (string) $listaItem['descripcion'],
    					'Cantidad'	=> (int) $cantidad,
    					'PesoTotalItem' => $cantidad * $listaItem['peso']
    				);
    
    				if (!empty($delegacion)) {
    					$itemsPorMatricula[$matricula.'-'.$delegacion.'-'.$docLlegada.'-'.$puntoLlegada]['delegacion'] = $delegacion;
    				}
    
    				if (!empty($matricula)) {
    					$itemsPorMatricula[$matricula.'-'.$delegacion.'-'.$docLlegada.'-'.$puntoLlegada]['Matricula'] = $matricula;
    				}
    
    				if (!empty($docLlegada)) {
    					$itemsPorMatricula[$matricula.'-'.$delegacion.'-'.$docLlegada.'-'.$puntoLlegada]['docLlegada'] = $docLlegada;
    				}
    
    				if (!empty($puntoLlegada)) {
    					$itemsPorMatricula[$matricula.'-'.$delegacion.'-'.$docLlegada.'-'.$puntoLlegada]['puntollegada'] = $puntoLlegada;
    				}				
    
    				if (!empty($numeroPlaca)) {
    					$itemsPorMatricula[$matricula.'-'.$delegacion.'-'.$docLlegada.'-'.$puntoLlegada]['numeroPlaca'] = $numeroPlaca;
    				}
    
    				if (!empty($documentoConductor)) {
    					$itemsPorMatricula[$matricula.'-'.$delegacion.'-'.$docLlegada.'-'.$puntoLlegada]['documentoConductor'] = $documentoConductor;
    				}
    
    				if (!empty($nombreConductor)) {
    					$itemsPorMatricula[$matricula.'-'.$delegacion.'-'.$docLlegada.'-'.$puntoLlegada]['nombreConductor'] = $nombreConductor;
    				}
    
    				if (!empty($apellidoConductor)) {
    					$itemsPorMatricula[$matricula.'-'.$delegacion.'-'.$docLlegada.'-'.$puntoLlegada]['apellidoConductor'] = $apellidoConductor;
    				}
    
    				if (!empty($brevete)) {
    					$itemsPorMatricula[$matricula.'-'.$delegacion.'-'.$docLlegada.'-'.$puntoLlegada]['brevete'] = $brevete;
    				}
    				
    				$itemsPorMatricula[$matricula.'-'.$delegacion.'-'.$docLlegada.'-'.$puntoLlegada]['observacionTecnico'] = $observacionTecnico;
    				
    			}
    		}
    		
    		$noCreados = 0;
    		$creados = 0;
    
    		foreach ($itemsPorMatricula as $matriculas => $items) 
    		{  
    			$sumaPesos = array_sum(array_column($items['items'], 'PesoTotalItem'));
    		
    // 			$datosMatricula = $this->itemModelo->dataMatricula($items['Matricula']);
                $datosMatricula = $this->usuarios->buscarUsuarioXmatricula($items['Matricula']);
    				
    			if(!empty($items['puntollegada'])){ // Abastecimiento
    			    $tipotraslado = 6;
        			$codigoSunatTrama = '04';
        			$DescripcionTrama = 'Traslado entre establecimientos de la misma empresa';
                    
                    $idpuntollegada = $items['puntollegada']; // 0
                    // $dataLlegada = $this->dataPartidaYLlegada($items['puntollegada']);
                    $dataLlegada = $this->direcciones->obtenerDireccion($items['puntollegada']);
    
        			$codigoubigeopuntollegada   = $dataLlegada['cod_ubigeo']; // falta meter data del excel 
        			$distritollegada            = $dataLlegada['id_distrito'];
        			$departamentollegada        = $dataLlegada['id_dep_inei'];	
        			$codigosunatllegada         = $dataLlegada['codigoSunat'];
        			$observacion                = $dataLlegada['desc_dep_inei']; //cambiar a provincia
        			$puntoDeLlegada             = $dataLlegada['Direccion'];
        			
        			/*********************/
        // 			$datosUsuarioSession = $this->itemModelo->dataUsuarioSession($usuarioSession); 
        			
        // 			$correo = $datosUsuarioSession[0]['Correo']; //Remplazando el correo de la persona en session
                    $correo             = $this->items['correoElectronico'];
    			    $correoJson         = json_encode(array($correo));
    			    $documentoconductor = $items['documentoConductor']; //$datosMatricula[0]['NumeroDoc'];// con matricula
        			$nombreconductor    = $items['nombreConductor'];//data del archivo
        			$apellidoconductor  = $items['apellidoConductor'];//data del archivo
        			$numlicencia        = $items['brevete']; //data del archivo
        			$numeroPlaca        = $items['numeroPlaca']; //data del archivo
        			$delegacionllegada  = $items['delegacion']; //data del archivo
        			
        // 			if($items['Matricula']=='GE'){
        // 			    $nombreReceptor = 'VERISURE - '.$dataLlegada[0]['desc_dep_inei'];
        // 			}else{
        // 			    if($items['docLlegada']==''){
        // 			        $nombreReceptor = $items['Matricula'].' - '.$datosMatricula[0]['Nombres'].' '.$datosMatricula[0]['Apellidos'];
        // 			    }else{
        // 			        $idProveedor = $items['docLlegada'];
        			        
        // 			        $whereProveedor = array(
        //     					'idProveedor' => $idProveedor
        //     				);
        //     				$dataProveedor = $this->proveedorModelo
        //     								->where($whereProveedor)
        //     								->first();
        			        
        // 			        $nombreReceptor = $datosProveedor[0]['razon_social'].' - '.$datosProveedor[0]['ruc'];
        // 			    }
        			    
        // 			}
        			
        			if($items['Matricula']=='GE')
        			{
        			    $nombreReceptor = 'VERISURE - '.$dataLlegada['desc_dep_inei'];
        			}
        			else if($items['Matricula']=='EXTERNO')
        			{
        			    $idProveedor = $items['docLlegada'];
        			    
        				$dataProveedor = $this->proveedor->where('idProveedor',$idProveedor)->first();
    			        
    			        $nombreReceptor = $datosProveedor['razon_social'].' - '.$datosProveedor['ruc'];
        			}
        			else
        			{
        			    $nombreReceptor = $items['Matricula'].' - '.$datosMatricula['Nombres'].' '.$datosMatricula['Apellidos'];
        			}
        			
                }else{ // Itinerante
                    $tipotraslado = 1;
        			$codigoSunatTrama = '18';
        			$DescripcionTrama = 'Traslado emisor itinerante CP';
    
        			$idpuntollegada = ''; // 0
        			$codigoubigeopuntollegada = ''; // falta meter data del excel 
        			$distritollegada = '';
        			$departamentollegada = '';	
        			$codigosunatllegada = '';
        			$observacion = '';
        			$puntoDeLlegada='';
        			
        			$dataLlegada = array();
        			
        			$dataLlegada['cod_ubigeo'] = ""; // falta meter data del excel 
        			$dataLlegada['id_distrito'] = "";
        			$dataLlegada['id_dep_inei'] = "";	
        			$dataLlegada['codigoSunat'] = "";
        			$dataLlegada['desc_ubigeo_inei'] = "";
        			$dataLlegada['desc_dep_inei'] = ""; //cambiar a provincia
        			$dataLlegada['Direccion'] = "";
        			
        			/*********************/
        			$correo             = $datosMatricula['Correo'];
    			    $correoJson         = json_encode(array($datosMatricula['Correo']));
    			    $documentoconductor = $datosMatricula['NumeroDoc']; //$datosMatricula[0]['NumeroDoc'];// con matricula
    			    $nombreconductor    = $datosMatricula['Nombres'];//$datosMatricula[0]['Nombres']; // con matricula
    			    $apellidoconductor  = $datosMatricula['Apellidos'];//$datosMatricula[0]['Apellidos']; // con matricula
    			    $numlicencia        = $datosMatricula['brevete']; //$datosMatricula[0]['brevete']; // falta traer data de la matricula 
    			    $numeroPlaca        = $datosMatricula['numero_placa'];
    			    $delegacionllegada  = $datosMatricula['CC'];
    			    $nombreReceptor     = $nombreconductor.' '.$apellidoconductor;
                }
    			
    			$fecharegistro = date('Y-m-d H:i:s');
    			$fechadetraslado = date('Y-m-d');
    			$puntopartida = 'CAL.LOS GORRIONES NRO. 226 URB. LA CAMPIÑA'; //siempre sera
    			$idpuntopartida = 9; //$dataPartida[0]['id_direccion']; //id_direccion
    			
    // 			$dataPartida = $this->dataPartidaYLlegada($idpuntopartida);
    			$dataPartida = $this->direcciones->obtenerDireccion($idpuntopartida);
    
    			$codigoubigeopuntopartida   = $dataPartida['cod_ubigeo']; //cod_ubigeo
    			$distritopartida            = $dataPartida['id_distrito']; // id_distrito
    			$departamentopartida        = $dataPartida['id_dep_inei']; // id_dep_inei
    			$delegacionpartida          = 910;
    			$codigosunatpartida         = $dataPartida['codigoSunat'];
    			
    			if(isset($items['docLlegada']) && !empty($items['docLlegada']))
    			{
    			    $idProveedor = $items['docLlegada'];
    				
    				$dataProveedor = $this->proveedor->where('idProveedor',$idProveedor)->first();				
    								
    				$cliente        = $dataProveedor['razon_social']; // doc_llegada y si esta vacio la celda sera VERISURE PERU S.A.C. por defecto
    				$tipodocumento  = 6;
    				$documento      = $dataProveedor['ruc'];
    			}
    			else
    			{
    			    $cliente        = 'VERISURE PERU S.A.C.'; // doc_llegada y si esta vacio la celda sera VERISURE PERU S.A.C. por defecto
    				$tipodocumento  = 6;
    				$documento      = 20549068201;
    			}
    
    			if($items['observacionTecnico']=='')
    			{
    			    $observacion2 = '';
    			}
    			else
    			{
    			    $observacion2 = $items['observacionTecnico'];
    			}
    
    			$tipodocumentoconductor = 1;
    			$lbljsonofrecido        = json_encode($items['items']);
    			$unidadmedida           = 'KGM';
    			$PesoBrutoTotal         = $sumaPesos;
    			$contrato_presente      = 1;
    			$contrato               = '';
                $idUsuarioCreador       = $usuarioSession;
                $tipoCreacion           = 1;
    			$dataLinea = [
    				'fecharegistro' => $fecharegistro,
    				'matricula' => $items['Matricula'],
    				'tipotraslado' => $tipotraslado,
    				'codigoSunatTrama' => $codigoSunatTrama,
    				'DescripcionTrama' => $DescripcionTrama,
    				'correo' => $correoJson,
    				'fechadetraslado' => $fechadetraslado,
    				'puntopartida' => $puntopartida,
    				'idpuntopartida' => $idpuntopartida,
    				'codigoubigeopuntopartida' => $codigoubigeopuntopartida,
    				'puntollegada' => $puntoDeLlegada,
    				'idpuntollegada' => $idpuntollegada,
    				'codigoubigeopuntollegada' => $codigoubigeopuntollegada,
    				'cliente' => $cliente,
    				'tipodocumento' => $tipodocumento,
    				'documento' => $documento,
    				'nplaca' => $numeroPlaca,
    				'tipodocumentoconductor' => $tipodocumentoconductor,
    				'documentoconductor' => $documentoconductor,
    				'nombreconductor' => $nombreconductor,
    				'apellidoconductor' => $apellidoconductor,
    				'numlicencia' => $numlicencia,
    				'lbljsonofrecido' => $lbljsonofrecido, // Aquí se coloca el JSON de los items
    				'unidadmedida' => $unidadmedida,
    				'PesoBrutoTotal' => $PesoBrutoTotal,
    				'nombreReceptor' => $nombreReceptor,
    				'delegacionpartida' => $delegacionpartida,
    				'delegacionllegada' => $delegacionllegada,
    				'distritopartida' => $distritopartida,
    				'distritollegada' => $distritollegada,
    				'departamentopartida' => $departamentopartida,
    				'departamentollegada' => $departamentollegada,
    				'codigosunatpartida' => $codigosunatpartida,
    				'codigosunatllegada' => $codigosunatllegada,
    				'contrato_presente' => $contrato_presente,
    				'observacion' => $observacion,
    				'idusuario_creador' => $idUsuarioCreador,
    				'tipo_creacion' => $tipoCreacion
    			];
    
    			$serie="";
    
    			$lastIdGuia = $this->guiaRemision->insert($dataLinea, TRUE);
    
    			if ($lastIdGuia !== FALSE) 
    			{
    			    // ACTUALIZAR LA SERIE DE LA GUÍA INSERTADA
    			    
    				$serie = 'T001-'.$lastIdGuia;
    
    				$dataSerie = [
    					'nguia' => $serie
    				];
    				
    				$updateId = $this->guiaRemision->update([$lastIdGuia], $dataSerie);
    				
    				//GENERAR TXT Y ZIP PARA ENVIAR BASE64 A SERES Y GUARDAR ESTATUS EN BASE DE DATOS
    
				    $correosFijos = array('guiaselectronicas@verisure.pe','cynthia.fabian@verisure.pe','placido.curilopez@verisure.pe','joseenrique.nanquen@verisure.pe');
				    
				    $arraySeres = array(
				        "Serie"                     => $serie,
                        "Contrato"                  => $contrato,
                        "Cliente"                   => $cliente,
                        "TipoDocumento"             => $tipodocumento,
                        "Documento"                 => $documento,
                        "CodigoSunatTrama"          => $codigoSunatTrama,
                        "DescripcionTrama"          => $DescripcionTrama,
                        "PesoBrutoTotal"            => $PesoBrutoTotal,
                        "FechaTraslado"             => $fechadetraslado,
                        "InformacionPartida"        => $dataPartida,
                        "PuntoPartida"              => $puntopartida,
                        "InformacionLlegada"        => $dataLlegada,
                        "PuntoLlegada"              => $puntoDeLlegada,
                        "TipoTraslado"              => $tipotraslado,
                        "PlacaVehicular"            => $numeroPlaca,
                        "TipoDocumentoConductor"    => $tipodocumentoconductor,
                        "DocumentoConductor"        => $documentoconductor,
                        "NombreConductor"           => $nombreconductor,
                        "ApellidoConductor"         => $apellidoconductor,
                        "NumeroLicencia"            => $numlicencia,
                        "Items"                     => $items['items'],
                        "CorreosFijos"              => $correosFijos,
                        "Matricula"                 => $items['Matricula'],
                        "NombreReceptor"            => $nombreReceptor,
                        "DelegacionPartida"         => $delegacionpartida,
                        "DelegacionLlegada"         => $delegacionllegada,
                        "Observacion01"             => $observacion,
                        "Observacion02"             => $observacion2

				    );
				
				    $base64 = $this->complementos->generarTXTSeres($arraySeres);
				    // $responseSeres = $this->complementos->enviarTXTSeres(array('base64'=>$base64));
				    $responseSeres = "";
				    
                    $dataResultado = array(
                        'id_guia'           => $lastIdGuia,
                        'respuestaxml'      => $responseSeres,
                		'base64'            => $base64,
                		'TipoRegistro'      => "MASIVO",
                		'UsuarioRegistra'   => $this->items['id'],
                		'FechaRegistra'     => $fechaActual,
                		'Localhost'         => $this->request->getIPAddress()
                    );
                    
                    $this->guiaRemisionEnvio->insert($dataResultado, TRUE);
                    
                    $creados++;
    			}
    			else
    			{
    			    $noCreados++;
    			}
    		}
    		
    		if($creados == count($itemsPorMatricula))
    		{
    		    $message = sprintf($this->mensajeError->msg201, "Se gestionaron ".$creados." guías de remisión.");
                echo $this->alertas->alertaExito($message);
                echo $this->alertas->refrescar(1);
                EXIT;
    		}
    		else if($noCreados == count($itemsPorMatricula))
    		{
    		    $message = sprintf($this->mensajeError->msg201, "Ninguna guía de remisión ha sido gestionada. Inténtelo nuevamente luego.");
                echo $this->alertas->alertaError($message);
                EXIT;
    		}
    		else
    		{
    		    $message = sprintf($this->mensajeError->msg201, "Se gestionaron ".$creados." guías. No se pudieron gestionar ".$noCreados.". Inténtelo nuevamente.");
                echo $this->alertas->alertaPeligro($message);
                EXIT;
    		}
    	}
    	else 
    	{
            $message = sprintf($this->mensajeError->msg201, "No hay sesión iniciada. Actualice la página e intente nuevamente.");
            echo $this->alertas->alertaError($message);
            EXIT;
        }
	}
	
	public function listadoNumeroGuiaRemision()
	{
	    if (isset($this->items['id'])) 
    	{
    	    $elemento = $this->request->getPost('term');
        	
        	if(isset($elemento['term']))
        	{
            	$array = array(
            	    "variable"  => $elemento['term']
            	);
        	}
        	else
        	{
        	    $array = array(
            	    "variable"  => $elemento
            	);
        	}
        	
            $listado = $this->guiaRemision->listadoNumeroGuiaRemisionSinAnulacion($array);
            
            $elementos=array();
    
            if (!empty($listado)) 
            {
                foreach ($listado as $items) {
                    $elementos[] = array(
                        'id'        => (string) $items['nguia'],
             	        'label'     => (string) $items['nguia'],
                        'contrato'  => (string) $items['contrato'],
                        'nroguia'   => (string) $items['nguia']
                    );
                }
            }
    
            echo json_encode($elementos);
    	} 
    	else 
    	{
            $elementos=array();
			echo json_encode($elementos);
        }
	}
	
	/**************************************************************************/
	
    /******************************* ANULACIONES ******************************/
    
    public function listarAnulacionesGuiaRemision()
    {
        if (isset($this->items['id'])) 
    	{
    	    $data = array (
				'session'                   => 'on',
				'titulo'                    => 'Anulaciones de Guía de Remisión | Verisure',
				'breadcrumb'                => $this->items['modulo'],
				'breadcrumb_alias'          => 'Anulaciones de Guía de Remisión',
                // 'previo'                => 'listar-proveedores',
				'elementoSeleccionadoModulo'=> "Anulaciones de Guía de Remisión",
				'subtitulo'                 => 'Anulaciones de Guía de Remisión',
				'elementos'                 => array()
			);
			
			$data = array_merge($data, $this->items);
			
			return view('guia_remision/anulacion_guia_remision',$data);		
        } else {
            return view('errors/500');
        }
    }
    
	public function recargarAnulacionesGuiaRemision()
	{
	    if (isset($this->items['id'])) 
    	{
            $estados    = $this->request->getPost('estados');
            
            if($estados == NULL)
            {
                $estados = array('');
            }
            
    	    $resultado['data'] = array();
    	    
            $totalAnulacion = $this->guiaRemisionAnulacion->whereIn("estado", $estados)->findAll();
            
            foreach($totalAnulacion as $key=>$item)
            {
                $seleccion = '<center class="content-center" style="position: relative; height: 40px;">'
                    .'<input type="checkbox" id="chkAnulacion'.$item['id'].'" name="chkAnulacionGR[]" class="chkAnulacionMasivaGR chk-basico" data-guia="'.$item['nguia'].'" value="'.$item['id'].'" >'
                    .'<label for="chkAnulacion'.$item['id'].'"></label>'
    			.'</center>';
                
                $resultado['data'][$key] = array(
                    'seleccion' => (string) $seleccion,
                    'fecha'     => (string) "<span class='d-none'>".date("Ymd", strtotime($item['fechasolicitud']))."</span>".date("d-m-Y", strtotime($item['fechasolicitud'])),
    				'matricula' => (string) $item['matriculasolicitante'],
    				'guia'      => (string) $item['nguia'],
                    'motivo'    => (string) $item['motivoanulacion'],
    				'contrato'  => (string) $item['contrato'],
    				'estado'    => (string) $item['estado']
    			);
            }
            
    		/*
             * ----------------------------
             * DATOS DE AJAX PRE PROCESADOS
             * ----------------------------
             */
    
    		echo json_encode($resultado, JSON_NUMERIC_CHECK);
    	}
    	else 
    	{
            $resultado = array();
            
            echo json_encode($datos, JSON_NUMERIC_CHECK);
        }
	}
	
	public function modificarEstadoMasivoAnulacionGuiaRemision()
	{
	    $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $solicitudes = $this->request->getPost('solicitudesAnulacion');
        $estado = $this->request->getPost('cboEstado_cemagr');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($estado, 'required|trim', 'Estado');
        
        if(!isset($solicitudes) || count($solicitudes) <= 0)
        {
            $error .= "<li>Debe seleccionar una solicitud de anulación como mínimo.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */
        
        $dataUpdate = array();
        
        for($i = 0; $i < count($solicitudes); $i++)
        {
            $dataUpdate[] = array (
                'id'           => $solicitudes[$i], 
                'estado'        => $estado           
            );
        }

        $lastId = $this->guiaRemisionAnulacion->updateBatch($dataUpdate, 'id');

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg201, "Se actualizaron los registros solicitados");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
		else
		{
		    $message = sprintf($this->mensajeError->msg201, "No se pudieron actualizar los registros solicitados. Inténtelo luego.");
			echo $this->alertas->alertaError($message);
		}
	}
	/**************************************************************************/
	
    /***************************** TIPO TRASLADO ******************************/
    
	public function listadoTipoTrasladoBusqueda()
	{
        if (isset($this->items['id'])) 
    	{
    	    $elemento = $this->request->getPost('term');
        	
        	$array = array(
        	    "variable"              => isset($elemento['term']) ? $elemento['term'] : "",
        	    "eliminacion_logica"    => "1"
        	);
        	
            $listado = $this->tipoTraslado->listadoTipoTrasladoBusqueda($array);
            
            $elementos=array();
    
            if (!empty($listado)) 
            {
                foreach ($listado as $items) {
                    $elementos[] = array(
                        'id'                => (string) $items['id_tipo_traslado'],
                        'text'              => (string) $items['tipotrasladoVerisure'],
        				'codigoSunatTrama'  => (string) $items['codigoSunatTrama'],
        				'DescripcionTrama'  => (string) $items['DescripcionTrama']
                    );
                }
            }
    
            echo json_encode($elementos);
    	} 
    	else 
    	{
            $elementos=array();
			echo json_encode($elementos);
        }
	}
	
	public function listadoItemTipoTrasladoBusqueda()
	{
        if (isset($this->items['id'])) 
    	{
    	    $elemento               = $this->request->getPost('term');
    	    $tipotraslado           = $this->request->getPost('tipotraslado');
    		$codigosunatpartida     = $this->request->getPost('codigosunatpartida');
    		$departamentopartida    = $this->request->getPost('departamentopartida');
    		
    		$array = array(
    		    "variable"              => $elemento,
    		    "TipoTraslado"          => $tipotraslado,
    		    "CodigoSunat"           => $codigosunatpartida,
    		    "DepartamentoPartida"   => $departamentopartida,
    		    "Eliminacion"           => 1
    		);
    		
    		$listado = $this->itemTipoTraslado->listadoItemTipoTrasladoBusqueda($array);
    		
            $itemTraslado=array();
    
            if (!empty($listado)) 
            {
                foreach ($listado as $items) {
                    $itemTraslado[] = array(
                        'id'    => (string) $items['id_item'],
                        'text'  => (string) $items['coditem'] . '-' . $items['descripcion'],
        				'peso'  => (string) $items['peso']
                    );
                }
            }
            
            echo json_encode($itemTraslado);
    	} 
    	else 
    	{
            $itemTraslado=array();
			echo json_encode($itemTraslado);
        }
	}
	
	/**************************************************************************/
	
    /********************************** PILAS *********************************/
    
    public function listadoItemIncluyePilas()
	{
        if (isset($this->items['id'])) 
    	{
    	    $idItem         = $this->request->getPost('idItem');
    	    $tipotraslado   = $this->request->getPost('tipoTraslado');
    	    
    	    $pilas = array();
        	    
    	    if($tipotraslado == 2)
    	    {
        	    //IdItem elemento => codItem pila asociada
        	    $arrayItemPila      = array(54 => 7014, 58 => 7014, 65 => 7014, 66 => 7014, 59 => 7008, 60 => 7008, 63 => 7006, 62 => 7002, 64 => 7002, 377 => 7008);
        	    
        	    //IdItem elemento => cantidad pila uso
        	    $arrayCantidadPila  = array(54 => 4, 58 => 6, 65 => 4, 66 => 3, 59 => 1, 60 => 1, 63 => 2, 62 => 1, 64 => 1, 377 => 1);
    	    }
    	    else
    	    {
    	        $arrayItemPila = array();
    	        $arrayCantidadPila = array();
    	    }
    	    
    	    if(isset($arrayItemPila[$idItem]))
    	    {
        		$array = array(
        		    "Eliminacion"   => 1,
        		    "idPila"        => isset($arrayItemPila[$idItem]) ? $arrayItemPila[$idItem] : "0"
        		);
        		
        		$elemento = $this->item->obtenerItem($array);
        		
                if (!empty($elemento)) 
                {
                    $pilas = array(
                        'id'    => (string) $elemento['id_item'],
                        'text'  => (string) $elemento['coditem'] . '-' . $elemento['descripcion'],
        				'peso'  => (string) $elemento['peso'],
        				'cantidadPila' => (string) isset($arrayCantidadPila[$idItem]) ? $arrayCantidadPila[$idItem] : 0
                    );
                }
    	    }
    	    
            echo json_encode($pilas);
    	} 
    	else 
    	{
            $pilas=array();
			echo json_encode($pilas);
        }
	}
	
	/**************************************************************************/
	
    /**************************** MONEDAS *************************************/
    
	/**************************************************************************/
	
    /***************************** TIPOS DOCUMENTO ****************************/
    
	/**************************************************************************/
	
    /************************** ESTRUCTURA DIRECCIÓN **************************/
    
	/**************************************************************************/
	
    /**************************** ESTRUCTURA ÁREAS ****************************/
    
	/**************************************************************************/
	
    /*************************** ESTRUCTURA SUBÁREAS **************************/
    
	/**************************************************************************/
	
    /******************* ESTRUCTURA SUBÁREAS - DELEGACIONES *******************/
    
	/**************************************************************************/
	
    /************************* ESTRUCTURA DELEGACIONES ************************/
    
	/**************************************************************************/
	
    /************************* ESTRUCTURA DEPARTAMENTAL ************************/
    
	/**************************************************************************/
	
    /******************************** USUARIOS ********************************/
    
	/**************************************************************************/
	
	
}