let pondImportarCSVLinea;
let pondImportarCSVHardware;
let pondGestionHardwareNavision;
let pondImportarCSVTarjetaAcceso;
let pondValidacionKardexAccesorioIT;
let pondCSVAsignacion;
let pondAdjuntoAsignacion;
let pondAdjuntoDevolucion;
let pondDenunciaDevolucion;
let pondAdjuntoReposicion;
let pondDenunciaSolicitudReposicion;
let pondImportarCSVKitDemo;

let graficaAsignacionPendienteFirmaCreacion = null;
let graficaDetalleAsignacionPendienteFirmaCreacion = null;
let graficaAsignacionPendienteFirmaActivo = null;
let graficaDetalleAsignacionPendienteFirmaActivo = null;
let graficaPendientesValidar = null;
const initialDataQuill = {
  about: [
    {
      insert:
        'Ingrese el texto requerido aquí.\n',
    },
  ],
};

$(function () 
{
    FilePond.registerPlugin(
        FilePondPluginFileValidateType,    // Validación de extensión
        FilePondPluginImagePreview,        // Previsualización de imágenes
        FilePondPluginImageExifOrientation // Orientación EXIF de imágenes
    );
    
    document.querySelectorAll('.modal').forEach(function(modal) {
        modal.addEventListener('hidden.bs.modal', function() {
            document.body.style.paddingRight = '0px'; // Reseteamos el padding al cerrarse cualquier modal
        });
    });
    
    var elementoLegal = document.getElementById('txtTextoLegal_i');

    if (elementoLegal) {
      // El elemento existe, entonces inicializamos Quill
      var quillTextoLegal = new Quill('#txtTextoLegal_i', {
        theme: 'snow'
      });
    }
    
});

$(document).on('keyup blur change', '.validarNextTab', function(event) 
{
    var completo = true;
    
    $('.validarNextTab').each(function() {
        var valor = $(this).val(); // Obtener el texto del elemento
        if(valor == '')
        {
            completo = false;
        }
    });
    
    //VALIDACIÓN PARA ASIGNACIONES
    if( ($('#txtTipoAsignado').length && $('#txtTipoAsignado').val()=='') || ($('#txtUsuarioAsignacion').length && $('#txtUsuarioAsignacion').val()==''))
    {
        completo = false;
    }
    
    //VALIDACIÓN PARA NUEVA PAQUETERÍA
    // if( ($('#txtDireccion_np').length && $('#txtDireccion_np').val() =='' ) || 
    //     ($('#txtArea_np').length && $('#txtArea_np').val() =='' ) || 
    //     ($('#txtSubarea_np').length && $('#txtSubarea_np').val() =='' ) || 
    //     ($('#txtDelegacionSubarea_np').length && $('#txtDelegacionSubarea_np').val() =='' ) || 
    //     ($('#txtDireccionDestinatario_np').length && $('#txtDireccionDestinatario_np').val() =='' ))
    // {
    //     completo = false;
    //     console.log("falta algún select");
    // }
    
    if(completo)
    {
        $('#btnNextTab').removeAttr("disabled");
    }
    else
    {
        $('#btnNextTab').attr("disabled","disabled");
    }
});

/* FUNCIONES GENERALES */

function selectCategorias(elemento, idSeleccionado, modal)
{
    $.post(baseUrl + '/obtener-categorias', 
    {}, 
    function(response) 
    {
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
            
            $("#"+elemento).append('\
                <option value="">Por favor, vuelva a iniciar sesión.</td>\n\
            ');
        } 
        else if (response.descripcion === 0) 
        {
            // Swal.fire({
            //     title: 'No se encontró la información solicitada',
            //     icon: 'warning',
            //     showCancelButton: false,
            //     confirmButtonColor: '#282E38',
            //     confirmButtonText: 'Confirmar'
            // });
            $("#"+elemento).append('\
                <option value="">No se encontró la información solicitada</td>\n\
            ');
        } 
        else 
        {
            var categorias = $.parseJSON(response.listadoCategorias);

            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            
            for(var i = 0; i < categorias.length; i++)
            {
                $("#"+elemento).append('\
                    <option value="' + categorias[i].id + '" '+(idSeleccionado == categorias[i].id ? 'selected' : '')+'>' + categorias[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectTipos(elemento, idCategoria, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-tipos', 
    {
        idCategoria : idCategoria
    }, 
    function(response) 
    {
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
            
            $("#"+elemento).append('\
                <option value="">Por favor, vuelva a iniciar sesión.</td>\n\
            ');
        } 
        else if (response.descripcion === 0) 
        {
            // Swal.fire({
            //     title: 'No se encontró la información solicitada',
            //     icon: 'warning',
            //     showCancelButton: false,
            //     confirmButtonColor: '#282E38',
            //     confirmButtonText: 'Confirmar'
            // });
            $("#"+elemento).append('\
                <option value="">No se encontró la información solicitada</td>\n\
            ');
        } 
        else 
        {
            var tipos = $.parseJSON(response.listadoTipos);
            
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            
            for(var i = 0; i < tipos.length; i++)
            {
                $("#"+elemento).append('\
                    <option value="' + tipos[i].id + '" '+(idSeleccionado == tipos[i].id ? 'selected' : '' )+'>' + tipos[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectSubtipos(elemento, idTipo, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-subtipos', 
    {         
        idTipo : idTipo
    }, 
    function(response) 
    {
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
            
            $("#"+elemento).append('\
                <option value="">Por favor, vuelva a iniciar sesión.</td>\n\
            ');
        } 
        else if (response.descripcion === 0) 
        {
            // Swal.fire({
            //     title: 'No se encontró la información solicitada',
            //     icon: 'warning',
            //     showCancelButton: false,
            //     confirmButtonColor: '#282E38',
            //     confirmButtonText: 'Confirmar'
            // });
            $("#"+elemento).append('\
                <option value="">No se encontró la información solicitada</td>\n\
            ');
        } 
        else 
        {
            var subtipos = $.parseJSON(response.listadoSubtipos);
            
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            
            for(var i = 0; i < subtipos.length; i++)
            {
                $("#"+elemento).append('\
                    <option value="' + subtipos[i].id + '" '+(idSeleccionado == subtipos[i].id ? 'selected' : '' )+'>' + subtipos[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
}

function selectMarcas(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-marcas', 
    {}, 
    function(response) 
    {
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
            
            $("#"+elemento).append('\
                <option value="">Por favor, vuelva a iniciar sesión.</td>\n\
            ');
        } 
        else if (response.descripcion === 0) 
        {
            // Swal.fire({
            //     title: 'No se encontró la información solicitada',
            //     icon: 'warning',
            //     showCancelButton: false,
            //     confirmButtonColor: '#282E38',
            //     confirmButtonText: 'Confirmar'
            // });
            $("#"+elemento).append('\
                <option value="">No se encontró la información solicitada</td>\n\
            ');
        } 
        else 
        {
            var marcas = $.parseJSON(response.listadoMarcas);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < marcas.length; i++){
                $("#"+elemento).append('\
                    <option value="' + marcas[i].id + '" '+(idSeleccionado == marcas[i].id ? 'selected' : '')+'>' + marcas[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectDispositivos(elemento, idMarca, idSeleccionado, categoria, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-dispositivos', 
    {
        idMarca : idMarca,
        categoria : categoria
    }, 
    function(response) 
    {
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
            
            $("#"+elemento).append('\
                <option value="">Por favor, vuelva a iniciar sesión.</td>\n\
            ');
        } 
        else if (response.descripcion === 0) 
        {
            // Swal.fire({
            //     title: 'No se encontró la información solicitada',
            //     icon: 'warning',
            //     showCancelButton: false,
            //     confirmButtonColor: '#282E38',
            //     confirmButtonText: 'Confirmar'
            // });
            $("#"+elemento).append('\
                <option value="">No se encontró la información solicitada</td>\n\
            ');
        } 
        else 
        {
            var dispositivos = $.parseJSON(response.listadoDispositivos);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < dispositivos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + dispositivos[i].id + '" '+(idSeleccionado == dispositivos[i].id ? 'selected' : '' )+'>' + dispositivos[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectOperadores(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-operadores', 
    {}, 
    function(response) 
    {
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
            
            $("#"+elemento).append('\
                <option value="">Por favor, vuelva a iniciar sesión.</td>\n\
            ');
        } 
        else if (response.descripcion === 0) 
        {
            // Swal.fire({
            //     title: 'No se encontró la información solicitada',
            //     icon: 'warning',
            //     showCancelButton: false,
            //     confirmButtonColor: '#282E38',
            //     confirmButtonText: 'Confirmar'
            // });
            $("#"+elemento).append('\
                <option value="">No se encontró la información solicitada</td>\n\
            ');
        } 
        else 
        {
            var operadores = $.parseJSON(response.listadoOperadores);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < operadores.length; i++){
                $("#"+elemento).append('\
                    <option value="' + operadores[i].id + '" '+(idSeleccionado == operadores[i].id ? 'selected' : '')+'>' + operadores[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectPlanes(elemento, idOperador, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-planes', 
    {
        idOperador : idOperador
    }, 
    function(response) 
    {
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
            
            $("#"+elemento).append('\
                <option value="">Por favor, vuelva a iniciar sesión.</td>\n\
            ');
        } 
        else if (response.descripcion === 0) 
        {
            // Swal.fire({
            //     title: 'No se encontró la información solicitada',
            //     icon: 'warning',
            //     showCancelButton: false,
            //     confirmButtonColor: '#282E38',
            //     confirmButtonText: 'Confirmar'
            // });
            $("#"+elemento).append('\
                <option value="">No se encontró la información solicitada</td>\n\
            ');
        } 
        else 
        {
            var planes = $.parseJSON(response.listadoPlanes);
            
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
                
            for(var i = 0; i < planes.length; i++){
                $("#"+elemento).append('\
                    <option value="' + planes[i].id + '" '+(idSeleccionado == planes[i].id ? 'selected' : '' )+'>' + planes[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectEstadosMovil(elemento,idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-estados-movil', 
    {}, 
    function(response) 
    {
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
            
            $("#"+elemento).append('\
                <option value="">Por favor, vuelva a iniciar sesión.</td>\n\
            ');
        } 
        else if (response.descripcion === 0) 
        {
            // Swal.fire({
            //     title: 'No se encontró la información solicitada',
            //     icon: 'warning',
            //     showCancelButton: false,
            //     confirmButtonColor: '#282E38',
            //     confirmButtonText: 'Confirmar'
            // });
            $("#"+elemento).append('\
                <option value="">No se encontró la información solicitada</td>\n\
            ');
        } 
        else 
        {
            var estados = $.parseJSON(response.listadoEstados);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < estados.length; i++){
                $("#"+elemento).append('\
                    <option value="' + estados[i].id + '" '+(idSeleccionado == estados[i].id ? 'selected' : '')+'>' + estados[i].estado +'</td>\n\
                ');
            }
        }
    }, 'json');

    
    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectMotivosEstadoMovil(elemento, estado, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-motivos-estado-movil', 
    {
        estado : estado
    }, 
    function(response) 
    {
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
            
            $("#"+elemento).append('\
                <option value="">Por favor, vuelva a iniciar sesión.</td>\n\
            ');
        } 
        else if (response.descripcion === 0) 
        {
            // Swal.fire({
            //     title: 'No se encontró la información solicitada',
            //     icon: 'warning',
            //     showCancelButton: false,
            //     confirmButtonColor: '#282E38',
            //     confirmButtonText: 'Confirmar'
            // });
            $("#"+elemento).append('\
                <option value="">No se encontró la información solicitada</td>\n\
            ');
        } 
        else 
        {
            var motivos = $.parseJSON(response.listadoMotivos);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < motivos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + motivos[i].id + '" '+(idSeleccionado == motivos[i].id ? 'selected' : '' )+'>' + motivos[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');
    
    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectEstadosLinea(elemento,idSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/obtener-estados-linea', 
    {
        
    }, 
    function(response) 
    {
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
            
            $("#"+elemento).append('\
                <option value="">Por favor, vuelva a iniciar sesión.</td>\n\
            ');
        } 
        else if (response.descripcion === 0) 
        {
            // Swal.fire({
            //     title: 'No se encontró la información solicitada',
            //     icon: 'warning',
            //     showCancelButton: false,
            //     confirmButtonColor: '#282E38',
            //     confirmButtonText: 'Confirmar'
            // });
            $("#"+elemento).append('\
                <option value="">No se encontró la información solicitada</td>\n\
            ');
        } 
        else 
        {
            var estados = $.parseJSON(response.listadoEstados);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < estados.length; i++){
                $("#"+elemento).append('\
                    <option value="' + estados[i].id + '" '+(idSeleccionado == estados[i].id ? 'selected' : '')+'>' + estados[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectMotivosEstadoLinea(elemento, estado, idSeleccionado,modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/obtener-motivos-estado-linea', 
    {
        estado : estado
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var motivos = $.parseJSON(response.listadoMotivos);
            $("#"+elemento).append('\
                    <option value="">Seleccione una opción</td>\n\
                ');
            for(var i = 0; i < motivos.length; i++){
                $("#"+elemento).append('\
                    <option value="' + motivos[i].id + '" '+(idSeleccionado == motivos[i].id ? 'selected' : '' )+'>' + motivos[i].motivo +'</td>\n\
                ');
            }
        }
    }, 'json');

    $('#'+elemento).select2({
        dropdownParent: $('#'+modal+' .modal-body')
    });
}

function selectElementoDemo(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-elementos-demo', 
    {
    }, 
    function(response) 
    {
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
            
            $("#"+elemento).append('\
                <option value="">Por favor, vuelva a iniciar sesión.</td>\n\
            ');
        } 
        else if (response.descripcion === 0) 
        {
            // Swal.fire({
            //     title: 'No se encontró la información solicitada',
            //     icon: 'warning',
            //     showCancelButton: false,
            //     confirmButtonColor: '#282E38',
            //     confirmButtonText: 'Confirmar'
            // });
            $("#"+elemento).append('\
                <option value="">No se encontró la información solicitada</td>\n\
            ');
        } 
        else 
        {
            var elementosDemo = $.parseJSON(response.listadoElementosDemo);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < elementosDemo.length; i++)
            {
                $("#"+elemento).append('\
                    <option value="' + elementosDemo[i].id + '" '+(idSeleccionado == elementosDemo[i].id ? 'selected' : '')+'>' + elementosDemo[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== "")
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
    
}

function selectAccesorioIT(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    
    $.post(baseUrl + '/listado-accesorios-it', 
    {
    }, 
    function(response) {
        if (response.descripcion === 0) {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else 
        {
            var accesorios = $.parseJSON(response.listadoAccesoriosIT);
            
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            
            for(var i = 0; i < accesorios.length; i++){
                $("#"+elemento).append('\
                    <option value="' + accesorios[i].id + '" '+(idSeleccionado == accesorios[i].id ? 'selected' : '')+'>' + accesorios[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== '')
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
}

function selectElementoTrabajo(elemento, idSeleccionado, modal)
{
    $('#'+elemento).empty();
    $.post(baseUrl + '/listado-elementos-trabajo', 
    {
    }, 
    function(response) {
        if (response.descripcion === 0) {
            //alert("Ocurrió un error al obtener los datos.");
        } else {
            var elementosTrabajo = $.parseJSON(response.listadoElementosTrabajo);
            $("#"+elemento).append('\
                <option value="">Seleccione una opción</td>\n\
            ');
            for(var i = 0; i < elementosTrabajo.length; i++){
                $("#"+elemento).append('\
                    <option value="' + elementosTrabajo[i].id + '" '+(idSeleccionado == elementosTrabajo[i].id ? 'selected' : '')+'>' + elementosTrabajo[i].text +'</td>\n\
                ');
            }
        }
    }, 'json');

    if(modal !== '')
    {
        $('#'+elemento).select2({
            dropdownParent: $('#'+modal+' .modal-body')
        });
    }
    else
    {
        $('#'+elemento).select2({
            
        });
    }
}

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES MARCAS */

/* ------------------------------- */

function agregarDispositivo(contenedorElementos)
{
    var random = generarRandom(5);
    
    var modelo          = $("#modeloDispositivo").val();
    var categoria       = $("#categoriaDispositivo").val();
    var tipo            = $("#tipoDispositivo").val();
    var subtipo         = $("#subtipoDispositivo").val();
    var descontinuado   = $("#descontinuadoDispositivo").prop('checked');
    
    var lblCategoria    = $('select[id="categoriaDispositivo"] option:selected').text();
    var lblTipo         = $('select[id="tipoDispositivo"] option:selected').text();
    var lblSubtipo      = $('select[id="subtipoDispositivo"] option:selected').text();
    
    if(modelo == '')
    {
        Swal.fire({
            title: "¡Advertencia!",
            text: "Debe ingresar el Modelo a guardar.",
            icon: "warning",
            showConfirmButton: true,
            confirmButtonColor: "#636465",
            confirmButtonText: "Entendido"
        });
    }
    else if(categoria == '')
    {
        console.log("no hay categoria");
        Swal.fire({
            title: 'Advertencia',
            text: 'Debe seleccionar una categoría.',
            icon: 'warning',
            showConfirmButton: true,
            confirmButtonColor: '#636465',
            confirmButtonText: 'Entendido'
        });
    }
    else if(tipo == '')
    {
        Swal.fire({
            title: 'Advertencia',
            text: 'Debe seleccionar un tipo.',
            icon: 'warning',
            showConfirmButton: true,
            confirmButtonColor: '#636465',
            confirmButtonText: 'Entendido'
        });
    }
    else if(subtipo == '')
    {
        Swal.fire({
            title: 'Advertencia',
            text: 'Debe seleccionar un subtipo.',
            icon: 'warning',
            showConfirmButton: true,
            confirmButtonColor: '#636465',
            confirmButtonText: 'Entendido'
        });
    }
    else
    {
        let contenedor = `<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="modeloDispositivo${random}" style="border-radius: 10px;">
    		<div class="col-xxl-12 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Modelo:</label>
    			    <input type="hidden" name="modelo[${random}]" value="`+modelo+`">
    				<input type="text" class="form-control" value="`+modelo+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-4 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Categoría:</label>
    			    <input type="hidden" name="categoria[${random}]" value="`+categoria+`">
    				<input type="text" class="form-control" value="`+lblCategoria+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-4 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Tipo:</label>
    			    <input type="hidden" name="tipo[${random}]" value="`+tipo+`">
    				<input type="text" class="form-control" value="`+lblTipo+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-4 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Subtipo:</label>
    			    <input type="hidden" name="subtipo[${random}]" value="`+subtipo+`">
    				<input type="text" class="form-control" value="`+lblSubtipo+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-10 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Descontinuado:</label>
    			    <input type="hidden" name="descontinuado[${random}]" value="`+(descontinuado === true ? "Y" : "N")+`">
    				<input type="text" class="form-control" value="`+(descontinuado === true ? "SI" : "NO")+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
    			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico('modeloDispositivo${random}');" data-tooltip="tooltip" aria-label="Eliminar Modalidad de Pago">
                    <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                </button>
    		</div>
    	</div>`;
    
        $("#"+contenedorElementos).append(contenedor);
        
        $("#modeloDispositivo").val("");
        $("#categoriaDispositivo").val("").trigger('change');
        $("#tipoDispositivo").val("").trigger('change');
        $("#subtipoDispositivo").val("").trigger('change');
        $("#descontinuadoDispositivo").prop('checked', false);
    }
}

/* ------------------------------- */

$(document).on('click', '.datos-marca', function(e) 
{
    var idMarca     = $(this).data('id');
    var accion      = $(this).data('accion');
    var modal       = $(this).data('bs-target');
    var formulario  = $(this).data('form');
    
    $('#btnEjecutarMarca').addClass("d-none");
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    
    $(formulario + ' input[type=text]').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    $.post(baseUrl + '/obtener-datos-marca', 
    {         
        idMarca : idMarca
    }, 
    function(response) 
    {
        Swal.close();
        
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else 
        {
            if(accion == 'ver')
            {
                $('#exampleinformacionMarca').text("Información de marca");
                $('#formInformacionMarca').attr('action', '');

                $('#txtMarca_i').attr("disabled","disabled");
            }
            else
            {
                $('#exampleinformacionMarca').text("Actualizar marca");
                $('#formInformacionMarca').attr('action', baseUrl + '/actualizar-marca/' + idMarca);

                $('#txtMarca_i').removeAttr("disabled");
                
                $('#btnEjecutarMarca').removeClass("d-none");
            }

            $('#txtIDMarca_i').val(response.idmarca);
            $('#txtMarca_i').val(response.marca);
            
            $(modal).modal("show");
        }
    }, 'json'); 
    
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-marca', function() {
    var idMarca = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la marca?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {

            var motivo = result.value;
            var parametros = {
                "idMarca" : idMarca,
                "estado" : estado,
                "motivo" : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-marca',
                type: "POST",
                data: parametros,
                beforeSend: function() 
                {
                    Swal.fire({
                        html: 'Un momento por favor...',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                },
                success: function(response) 
                {
                    Swal.close();
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown)
                {
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES DISPOSITIVOS */

/* ------------------------------- */

$(document).on('change', '#txtCategoriaDispositivo_i', function() 
{
    var modal = $(this).attr("data-modal");
    var idCategoria = $(this).val();
    
    $("#txtTipo_i").empty();
    $("#txtSubtipo_i").empty();
    
    selectTipos('txtTipo_i', idCategoria, '', modal);
});

/* ------------------------------- */

$(document).on('change', '#txtTipo_i', function() 
{
    var modal = $(this).attr("data-modal");
    var idTipo = $(this).val();
    
    $("#txtSubtipo_i").empty();
    
    selectSubtipos('txtSubtipo_i', idTipo, '', modal);
});

/* ------------------------------- */

$(document).on('click', '.datos-dispositivo', function(e) 
{
    var idDispositivo   = $(this).data('id');
    var idMarca         = $(this).data('marca');
    var accion          = $(this).data('accion');
    var modal           = $(this).data('bs-target');
    var formulario      = $(this).data('form');
    
    $('#btnEjecutarDispositivo').addClass("d-none");
    
    $(formulario + ' input[type=checkbox]').attr("disabled","disabled");
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' select').attr("disabled","disabled");
    
    $(formulario + ' input[type=checkbox]').prop("checked", false);
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' .select2-dinamico').empty();
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == 'crear')
    {
        Swal.close();
        
        selectCategorias("txtCategoriaDispositivo_i",'', modal.substring(1));
        selectMarcas("txtIDMarca_i",idMarca,modal.substring(1));

        $('#exampleinformacionDispositivo').text("Crear dispositivo");
        $('#formInformacionDispositivo').attr('action', baseUrl + '/registrar-dispositivo');
        $('#btnEjecutarDispositivo').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Guardar');
        $('#btnEjecutarDispositivo').removeClass("d-none");
        
        $(formulario + ' input[type=checkbox]').removeAttr("disabled");
        $(formulario + ' input[type=text]').removeAttr("disabled");
        $(formulario + ' select').removeAttr("disabled");
        
        if(idMarca != "TOTAL")
        {
            $('#txtIDMarca_i').next('.select2').addClass('select2-container--locked');
        }
        
		$('#txtTipo_i').select2({
            dropdownParent: $(modal + ' .modal-body')
        });
        
        $('#txtSubtipo_i').select2({
            dropdownParent: $(modal + ' .modal-body')
        });
        
        $(modal).modal("show");
    }
    else 
    {
        $.post(baseUrl + '/obtener-datos-dispositivo', 
        {         
            idDispositivo : idDispositivo
        }, 
        function(response) 
        {
            Swal.close();
        
            if (response.sesion === 0) 
            {
                Swal.fire({
                    title: 'Por favor, vuelva a iniciar sesión.',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionDispositivo').text("Información de dispositivo");
                    $('#btnEjecutarDispositivo').addClass("d-none");
                    $('#formInformacionDispositivo').attr('action', '');

                    $(formulario + ' input[type=checkbox]').attr("disabled","disabled");
                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' select').attr("disabled","disabled");
                    
                }
                else
                {
                    $('#exampleinformacionDispositivo').text("Actualizar dispositivo");
                    $('#formInformacionDispositivo').attr('action', baseUrl + '/actualizar-dispositivo/' + idDispositivo);
                    $('#btnEjecutarDispositivo').removeClass("d-none");
                    $('#btnEjecutarDispositivo').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Actualizar');

                    $(formulario + ' input[type=checkbox]').removeAttr("disabled");
                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' select').removeAttr("disabled");
                    
                }
                
                selectMarcas("txtIDMarca_i", response.idmarca, modal.substring(1));
                $('#txtIDMarca_i').attr("disabled", "disabled");
                
                $('#txtIDDispositivo_i').val(response.iddispositivo);
                $('#txtModelo_i').val(response.modelo);
                
                selectCategorias("txtCategoriaDispositivo_i", response.idcategoria, modal.substring(1));
                selectTipos("txtTipo_i",response.idcategoria, response.idtipo, modal.substring(1));
                selectSubtipos("txtSubtipo_i",response.idtipo, response.idsubtipo, modal.substring(1));
                
                if(response.descontinuado == "Y")
                {
                    $("#chkModeloDescontinuado_i").prop("checked", true);
                }
                else
                {
                    $("#chkModeloDescontinuado_i").prop("checked", false);
                }
                
                $(modal).modal("show");
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-dispositivo', function() 
{
    var idDispositivo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el dispositivo?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {

            var motivo = result.value;
            var parametros = {
                "idDispositivo" : idDispositivo,
                "estado" : estado,
                "motivo" : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-dispositivo',
                type: "POST",
                data: parametros,
                beforeSend: function() 
                {
                    Swal.fire({
                        html: 'Un momento por favor...',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                },
                success: function(response) 
                {
                    Swal.close();
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown)
                {
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES OPERADORES */

/* ------------------------------- */

function agregarPlan(contenedorElementos)
{
    var random = generarRandom(5);
    
    var planVerisure        = $("#txtPlanVerisure_ro").val();
    var planOperador        = $("#txtPlanOperador_ro").val();
    var precioPlan          = $("#txtPrecioPlan_ro").val();
    var porcentajeDescuento = $("#txtPorcentajeDescuento_ro").val();
    var precioFinal         = $("#txtPrecioFinal_ro").val();
    var observacion         = $("#txtObservacionPlan_ro").val();
    var capacidadDescarga   = $("#txtCapacidadDescarga_ro").val();
    
    if(planVerisure == '')
    {
        Swal.fire({
            title: "¡Advertencia!",
            text: "Debe ingresar el Plan Verisure a guardar.",
            icon: "warning",
            showConfirmButton: true,
            confirmButtonColor: "#636465",
            confirmButtonText: "Entendido"
        });
    }
    else if(planOperador == '')
    {
        console.log("no hay categoria");
        Swal.fire({
            title: 'Advertencia',
            text: 'Debe ingresar el Plan Operador a guardar.',
            icon: 'warning',
            showConfirmButton: true,
            confirmButtonColor: '#636465',
            confirmButtonText: 'Entendido'
        });
    }
    else if(precioPlan == '')
    {
        Swal.fire({
            title: 'Advertencia',
            text: 'Debe ingresar el Precio del Plan a guardar.',
            icon: 'warning',
            showConfirmButton: true,
            confirmButtonColor: '#636465',
            confirmButtonText: 'Entendido'
        });
    }
    else if(porcentajeDescuento == '')
    {
        Swal.fire({
            title: 'Advertencia',
            text: 'Debe ingresar el Porcentaje de Descuento a guardar.',
            icon: 'warning',
            showConfirmButton: true,
            confirmButtonColor: '#636465',
            confirmButtonText: 'Entendido'
        });
    }
    else if(porcentajeDescuento < 0 || porcentajeDescuento > 100)
    {
        Swal.fire({
            title: 'Advertencia',
            text: 'El porcentaje de descuento debe ser mayor o igual a 0 y menor o igual a 100.',
            icon: 'warning',
            showConfirmButton: true,
            confirmButtonColor: '#636465',
            confirmButtonText: 'Entendido'
        });
    }
    else if(precioFinal == '')
    {
        Swal.fire({
            title: 'Advertencia',
            text: 'Debe ingresar el Precio Final a guardar.',
            icon: 'warning',
            showConfirmButton: true,
            confirmButtonColor: '#636465',
            confirmButtonText: 'Entendido'
        });
    }
    else if(capacidadDescarga == '')
    {
        Swal.fire({
            title: 'Advertencia',
            text: 'Debe ingresar la Capacidad de Descarga a guardar.',
            icon: 'warning',
            showConfirmButton: true,
            confirmButtonColor: '#636465',
            confirmButtonText: 'Entendido'
        });
    }
    else
    {
        let contenedor = `<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="planOperador${random}" style="border-radius: 10px;">
    		<div class="col-xxl-6 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Plan Verisure:</label>
    			    <input type="hidden" name="planverisure[${random}]" value="`+planVerisure+`">
    				<input type="text" class="form-control" value="`+planVerisure+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-6 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Plan Operador:</label>
    			    <input type="hidden" name="planoperador[${random}]" value="`+planOperador+`">
    				<input type="text" class="form-control" value="`+planOperador+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-4 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Precio Plan:</label>
    			    <input type="hidden" name="precioplan[${random}]" value="`+precioPlan+`">
    				<input type="text" class="form-control" value="S/. `+precioPlan+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-4 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Porcentaje Descuento:</label>
    			    <input type="hidden" name="porcentajedescuento[${random}]" value="`+porcentajeDescuento+`">
    				<input type="text" class="form-control" value="`+porcentajeDescuento+` %" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-4 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Precio Final:</label>
    			    <input type="hidden" name="preciofinal[${random}]" value="`+precioFinal+`">
    				<input type="text" class="form-control" value="S/. `+precioFinal+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-12 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Observación:</label>
    			    <input type="hidden" name="observacion[${random}]" value="`+observacion+`">
    				<textarea class="form-control" disabled>`+observacion+`</textarea>
    			</div>
    		</div>
    		<div class="col-xxl-10 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Capacidad de Descarga:</label>
    			    <input type="hidden" name="capacidaddescarga[${random}]" value="`+capacidadDescarga+`">
    				<input type="text" class="form-control" value="`+capacidadDescarga+` GB" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
    			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico('planOperador${random}');" data-tooltip="tooltip" aria-label="Eliminar Plan Operador">
                    <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                </button>
    		</div>
    	</div>`;
    
        $("#"+contenedorElementos).append(contenedor);
        
        $("#txtPlanVerisure_ro").val("");
        $("#txtPlanOperador_ro").val("");
        $("#txtPrecioPlan_ro").val("");
        $("#txtPorcentajeDescuento_ro").val("");
        $("#txtPrecioFinal_ro").val("");
        $("#txtObservacionPlan_ro").val("");
        $("#txtCapacidadDescarga_ro").val("");
    }
}

/* ------------------------------- */

$(document).on('click', '.datos-operador', function(e) 
{
    var idOperador  = $(this).data('id');
    var accion      = $(this).data('accion');
    var modal       = $(this).data('bs-target');
    var formulario  = $(this).data('form');
    
    $('#btnEjecutarOperador').addClass("d-none");
    
    $(formulario + ' textarea').attr("disabled","disabled");
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    
    $(formulario + ' textarea').text("");
    $(formulario + ' input[type=text]').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    $.post(baseUrl + '/obtener-datos-operador', 
    {         
        idOperador : idOperador
    }, 
    function(response) 
    {
        Swal.close();
    
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else 
        {
            if(accion == 'ver')
            {
                $('#exampleinformacionOperador').text("Información de Operador");
                $('#btnEjecutarOperador').addClass("d-none");
                $('#formInformacionOperador').attr('action', '');
                
                $(formulario + ' textarea').attr("disabled","disabled");
                $(formulario + ' input[type=text]').attr("disabled","disabled");
            }
            else
            {
                $('#exampleinformacionOperador').text("Actualizar Operador");
                $('#formInformacionOperador').attr('action', baseUrl + '/actualizar-operador/' + idOperador);
                $('#btnEjecutarOperador').removeClass("d-none");
                $('#btnEjecutarOperador').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Actualizar');
                
                $(formulario + ' textarea').removeAttr("disabled");
                $(formulario + ' input[type=text]').removeAttr("disabled");
            }

            $('#txtIDOperador_i').val(response.idoperador);
            $('#txtOperador_i').val(response.operador);
            $('#txtObservacion_i').val(response.observacion);
            
            $(modal).modal("show");
        }
    }, 'json'); 
    
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-operador', function() 
{
    var idOperador = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el operador?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) 
        {
            var motivo = result.value;
            var parametros = {
                "idOperador" : idOperador,
                "estado" : estado,
                "motivo" : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-operador',
                type: "POST",
                data: parametros,
                beforeSend: function() 
                {
                    Swal.fire({
                        html: 'Un momento por favor...',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                },
                success: function(response) 
                {
                    Swal.close();
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown)
                {
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES PLANES */

/* ------------------------------- */

$(document).on('click', '.datos-plan', function(e) 
{
    var idPlan      = $(this).data('id');
    var idOperador  = $(this).data('operador');
    var accion      = $(this).data('accion');
    var modal       = $(this).data('bs-target');
    var formulario  = $(this).data('form');
    
    $('#btnEjecutarPlan').addClass("d-none");
    
    $(formulario + ' input[type=number]').attr("disabled","disabled");
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' textarea').attr("disabled","disabled");
    $(formulario + ' select').attr("disabled","disabled");
    
    $(formulario + ' input[type=number]').val("");
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' textarea').val("");
    $(formulario + ' .select2-dinamico').empty();
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    if(accion == 'crear')
    {
        Swal.close();

        $('#exampleinformacionPlan').text("Crear plan");
        $('#formInformacionPlan').attr('action', baseUrl + '/registrar-plan');
        $('#btnEjecutarPlan').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Guardar');
        $('#btnEjecutarPlan').removeClass("d-none");
        
        $(formulario + ' input[type=number]').removeAttr("disabled");
        $(formulario + ' input[type=text]').removeAttr("disabled");
        $(formulario + ' textarea').removeAttr("disabled");
        $(formulario + ' select').removeAttr("disabled");
        
        selectOperadores("txtIDOperador_i", idOperador, modal.substring(1));

        if(idOperador != "TOTAL")
        {
            console.log("asasddasdas");
            $('#txtIDOperador_i').next('.select2').addClass('select2-container--locked');
        }
        
        $(modal).modal("show");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-plan', 
        {         
            idPlan : idPlan
        }, 
        function(response) 
        {
            Swal.close();
        
            if (response.sesion === 0) 
            {
                Swal.fire({
                    title: 'Por favor, vuelva a iniciar sesión.',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionPlan').text("Información de plan");
                    $('#btnEjecutarPlan').addClass("d-none");
                    $('#formInformacionPlan').attr('action', '');

                    $(formulario + ' input[type=number]').attr("disabled","disabled");
                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' textarea').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionPlan').text("Actualizar plan");
                    $('#formInformacionPlan').attr('action', baseUrl + '/actualizar-plan/' + idPlan);
                    $('#btnEjecutarPlan').removeClass("d-none");
                    $('#btnEjecutarPlan').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Actualizar');

                    $(formulario + ' input[type=number]').removeAttr("disabled");
                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' textarea').removeAttr("disabled");
                }
                
                selectOperadores("txtIDOperador_i", response.idoperador, modal.substring(1));
                $('#txtIDOperador_i').attr("disabled", "disabled");

                $('#txtIDPlan_i').val(response.idplan);
                $('#txtPlan_i').val(response.plan);
                $('#txtPlanOperador_i').val(response.planoperador);
                $('#txtPrecioPlan_i').val(response.precioplan);
                $('#txtPorcentDescuento_i').val(response.descuento);
                $('#txtPrecioFinal_i').val(response.preciofinal);
                $('#txtCapacidadDescarga_i').val(response.capacidad);
                $('#txtObservacion_i').val(response.observacion);
                
                $(modal).modal("show");
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-plan', function() 
{
    var idPlan = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el plan?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {

            var motivo = result.value;
            var parametros = {
                "idPlan" : idPlan,
                "estado" : estado,
                "motivo" : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-plan',
                type: "POST",
                data: parametros,
                beforeSend: function() 
                {
                    Swal.fire({
                        html: 'Un momento por favor...',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                },
                success: function(response) 
                {
                    Swal.close();
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown)
                {
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES ELEMENTOS DEMO */

/* ------------------------------- */

$(document).on('click', '.datos-elemento-demo', function(e) 
{
    var idElementoDemo  = $(this).data('id');
    var accion          = $(this).data('accion');    
    var modal           = $(this).data('bs-target');
    var formulario      = $(this).data('form');
    
    $('#btnEjecutarElementoDemo').addClass("d-none");
    
    $(formulario + ' input[type=number]').attr("disabled","disabled");
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' textarea').attr("disabled","disabled");
    
    $(formulario + ' input[type=number]').val("");
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' textarea').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    if(accion == 'crear')
    {
        Swal.close();

        $('#exampleinformacionElementoDemo').text("Registrar Elemento Demo");
        $('#formInformacionElementoDemo').attr('action', baseUrl + '/registrar-elemento-demo');
        $('#btnEjecutarElementoDemo').removeClass("d-none");
        $('#btnEjecutarElementoDemo').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Guardar');

        $(formulario + ' input[type=number]').removeAttr("disabled");
        $(formulario + ' input[type=text]').removeAttr("disabled");
        $(formulario + ' textarea').removeAttr("disabled");
        
        $(modal).modal("show");
        
        $('#txtSKUElementoDemo_i').focus();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-elemento-demo', 
        {         
            idElementoDemo : idElementoDemo
        }, 
        function(response) 
        {
            Swal.close();
            
            if (response.sesion === 0) 
            {
                Swal.fire({
                    title: 'Por favor, vuelva a iniciar sesión.',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionElementoDemo').text("Información del Elemento Demo");
                    $('#btnEjecutarElementoDemo').addClass("d-none");
                    $('#formInformacionElementoDemo').attr('action', '');

                    $(formulario + ' input[type=number]').attr("disabled","disabled");
                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' textarea').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionElementoDemo').text("Actualizar Elemento Demo");
                    $('#formInformacionElementoDemo').attr('action', baseUrl + '/actualizar-elemento-demo/' + idElementoDemo);
                    $('#btnEjecutarElementoDemo').removeClass("d-none");
                    $('#btnEjecutarElementoDemo').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Actualizar');

                    $(formulario + ' input[type=number]').removeAttr("disabled");
                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' textarea').removeAttr("disabled");
                }

                $('#txtIDElementoDemo_i').val(response.idelementodemo);
                $('#txtSKUElementoDemo_i').val(response.sku);
                $('#txtNombreElementoDemo_i').val(response.detalle);
                $('#txtObservacionElementoDemo_i').val(response.observacion);
                $('#txtPrecioReposicionElementoDemo_i').val(response.precio);
                
                $(modal).modal("show");
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-elemento-demo', function() 
{
    var idElementoDemo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el elemento seleccionado?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idElementoDemo"    : idElementoDemo,
                "estado"            : estado,
                "motivo"            : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-elemento-demo',
                type: "POST",
                data: parametros,
                beforeSend: function() 
                {
                    Swal.fire({
                        html: 'Un momento por favor...',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                },
                success: function(response) 
                {
                    Swal.close();
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown)
                {
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES ELEMENTOS DE TRABAJO */

/* ------------------------------- */

$(document).on('click', '.datos-elemento-trabajo', function(e) 
{
    var idElementoTrabajo   = $(this).data('id');
    var accion              = $(this).data('accion');
    var formulario          = $(this).data('form');
    var modal               = $(this).data('bs-target');
    
    $('#btnEjecutarElementoTrabajo').addClass("d-none");
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' input[type=number]').attr("disabled","disabled");
    $(formulario + ' select').attr("disabled","disabled");
    $(formulario + ' textarea').attr("disabled","disabled");
    
    $(formulario + ' input[type=number]').val(0);
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' select').val("").trigger('change');
    $(formulario + ' textarea').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
            
    if(accion == 'crear')
    {
        $('#exampleinformacionElementoTrabajo').text("Registrar Elemento de Trabajo");
        $(formulario).attr('action', baseUrl + '/registrar-elemento-trabajo');
        $('#btnEjecutarElementoTrabajo').removeClass("d-none");
        $('#btnEjecutarElementoTrabajo').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Guardar');
        
        $(formulario + ' input[type=text]').removeAttr("disabled");
        $(formulario + ' input[type=number]').removeAttr("disabled");
        $(formulario + ' select').removeAttr("disabled");
        $(formulario + ' textarea').removeAttr("disabled");
        
        selectMoneda("cboMonedaElementoTrabajo_i", "", modal.substring(1));
        
        $(modal).modal("show");

        Swal.close();
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-elemento-trabajo', 
        {         
            idElementoTrabajo : idElementoTrabajo
        }, 
        function(response) 
        {
            Swal.close();
        
            if (response.sesion === 0) 
            {
                Swal.fire({
                    title: 'Por favor, vuelva a iniciar sesión.',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionElementoTrabajo').text("Ver Elemento de Trabajo");
                    $('#btnEjecutarElementoTrabajo').addClass("d-none");
                    $(formulario).attr('action', '');
                    
                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' input[type=number]').attr("disabled","disabled");
                    $(formulario + ' select').attr("disabled","disabled");
                    $(formulario + ' textarea').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionElementoTrabajo').text("Actualizar Elemento de Trabajo");
                    $(formulario).attr('action', baseUrl + '/actualizar-elemento-trabajo/' + idElementoTrabajo);
                    $('#btnEjecutarElementoTrabajo').removeClass("d-none");
                    $('#btnEjecutarElementoTrabajo').html('<i class="mdi mdi-content-save me-2 color-white" style="font-size: 14px;"></i>Actualizar');

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' input[type=number]').removeAttr("disabled");
                    $(formulario + ' select').removeAttr("disabled");
                    $(formulario + ' textarea').removeAttr("disabled");
                    $('#txtCantidadElementoTrabajo_i').attr("disabled","disabled");
                }
                
                $('#txtIDElementoTrabajo_i').val(response.idelemento);
                $('#txtSKUElementoTrabajo_i').val(response.sku);
                $('#txtNombreElementoTrabajo_i').val(response.nombre);
                $('#cboClasificacionElementoTrabajo_i').val(response.clasificacion).trigger('change');
                selectMoneda("cboMonedaElementoTrabajo_i", response.moneda, modal.substring(1));
                $('#txtPrecioElementoTrabajo_i').val(response.precio);
                $('#txtObservacionElementoTrabajo_i').val(response.observacion);
                $('#txtCantidadElementoTrabajo_i').val(response.cantidad);
                
                $(modal).modal("show");
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-elemento-trabajo', function() 
{
    var idElementoTrabajo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el elemento seleccionado?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idElementoTrabajo" : idElementoTrabajo,
                "estado"            : estado,
                "motivo"            : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-elemento-trabajo',
                type: "POST",
                data: parametros,
                beforeSend: function() 
                {
                    Swal.fire({
                        html: 'Un momento por favor...',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                },
                success: function(response) 
                {
                    Swal.close();
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown)
                {
                    Swal.close();
            
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES MOVIL */

/* ------------------------------- */

$(document).on('change', '#txtMarca_i', function() {
    var idMarca = $(this).val();
    var modal=$(this).data('modal');
    var categoria = $(this).data("categoria");
    
    $("#txtModeloComercial_i").empty();
    selectDispositivos('txtModeloComercial_i', idMarca, '', categoria, modal.substring(1));
});

/* ------------------------------- */

$(document).on('change', '#txtEstadoMovil_i', function() {
    var idEstado = $(this).val();
    var modal=$(this).data('modal');
    
    $("#txtMotivoMovil_i").empty();
    selectMotivosEstadoMovil('txtMotivoMovil_i', idEstado, '', modal.substring(1));
});

/* ------------------------------- */

$(document).on('click', '.datos-movil', function(e) 
{
    const fechaActual = moment();
    const fechaFormateada = fechaActual.format("YYYY-MM-DD");
    
    var idMovil = $(this).data('id');
    var accion = $(this).data('accion');
    var modal = $(this).data('bs-target');
    var formulario = $(this).data('form');
    
    $('#btnEjecutarMovil').addClass("d-none");
    $('#ctnEstadosMovil').addClass("d-none");
    
    $(formulario + ' input[type=checkbox]').attr("disabled","disabled");
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' input[type=date]').attr("disabled","disabled");
    $(formulario + ' input[type=number]').attr("disabled","disabled");
    $(formulario + ' select').attr("disabled","disabled");
    
    $(formulario + ' input[type=checkbox]').prop("checked", false);
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' input[type=date]').val("");
    $(formulario + ' input[type=number]').val("");
    $(formulario + ' .select2-dinamico').empty();
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == "crear")
    {
        Swal.close();
        
        $('#exampleinformacionMovil').text("Crear móvil");
        $('#formInformacionMovil').attr('action', baseUrl + '/grabar-movil');
        $('#btnEjecutarMovil').removeClass("d-none");
        $('#btnEjecutarMovil').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Guardar');
        
        $(formulario + ' input[type=checkbox]').removeAttr("disabled");
        $(formulario + ' input[type=text]').removeAttr("disabled");
        $(formulario + ' input[type=date]').removeAttr("disabled");
        $(formulario + ' input[type=number]').removeAttr("disabled");
        $(formulario + ' select').removeAttr("disabled");
        
        selectMarcas("txtMarca_i",'',modal.substring(1));
        $('#ctnEstadosMovil').removeClass("d-none");

        $('#txtFechaCompra_i').val(fechaFormateada);
        
        $('#txtProveedor_i').select2({
            dropdownParent: $(modal+' .modal-body')
        });
        
        $('#txtEstadoMovil_i').select2({
            dropdownParent: $(modal+' .modal-body')
        });
        
        $(modal).modal("show");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-movil', 
        {         
            idMovil : idMovil
        }, 
        function(response) 
        {
            Swal.close();
        
            if (response.sesion === 0) 
            {
                Swal.fire({
                    title: 'Por favor, actualice la página para buscar la información.',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionMovil').text("Información de móvil");
                    $('#btnEjecutarMovil').addClass("d-none");
                    $('#formInformacionMovil').attr('action', '');
                    
                    $(formulario + ' input[type=checkbox]').attr("disabled","disabled");
                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' input[type=date]').attr("disabled","disabled");
                    $(formulario + ' input[type=number]').attr("disabled","disabled");
                    $(formulario + ' select').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionMovil').text("Actualizar móvil");
                    $('#formInformacionMovil').attr('action', baseUrl + '/actualizar-movil/' + idMovil);
                    $('#formInformacionMovil').removeClass("d-none");
                    $('#btnEjecutarMovil').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Guardar');

                    $(formulario + ' input[type=checkbox]').removeAttr("disabled");
                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' input[type=date]').removeAttr("disabled");
                    $(formulario + ' input[type=number]').removeAttr("disabled");
                    $(formulario + ' select').removeAttr("disabled");
                    
                    if(accion == 'editar-basic')
                    {
                        //alert("full");
                        $('#txtIMEI_i').attr("disabled","disabled");
                        $('#txtFechaCompra_i').attr("disabled","disabled");
                        $('#txtMarca_i').attr("disabled","disabled");
                        $('#txtModeloComercial_i').attr("disabled","disabled");
                    }
                }

                $('#txtIDMovil_i').val(response.idmovil);
                selectMarcas("txtMarca_i",response.marca, modal.substring(1));
                selectDispositivos('txtModeloComercial_i', response.marca, response.modelo, $("#txtMarca_i").data("categoria"), modal.substring(1));
                
                $('#txtProveedor_i').val(response.proveedor);
                $('#txtIMEI_i').val(response.imei);
                $('#txtFechaCompra_i').val(response.fecha_compra);
                $('#txtPrecioCompra_i').val(response.precio_compra);
                $('#txtPrecioLista_i').val(response.precio_lista);
                
                var estadostock = response.stock == 'N' ? '' : 'checked';
                
                $('#chkEquipoStock_i').prop("checked", estadostock);
                
                $('#txtProveedor_i').select2({
                    dropdownParent: $(modal+' .modal-body')
                });
                
                $('#txtEstadoMovil_i').select2({
                    dropdownParent: $(modal+' .modal-body')
                });
                
                
                $(modal).modal("show");
            }
        }, 'json'); 
    }
    
});

/* ------------------------------- */

$(document).on('click', '.historico-asignaciones-moviles', function(e)
{
    var idMovil = $(this).data("id");
    var modal = $(this).data('bs-target');
    
    var parametros = {
        "idMovil"   : idMovil
	};
	
    $.ajax({        
        url: baseUrl + '/historico-asignaciones-moviles',
        type: "POST",
        data: parametros,
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            $('#ctnHistoricoAsignacionesModel').html(response);
            $(modal).modal("show");
            $('[data-tooltip="tooltip"]').tooltip();
            $('[data-toggle="tooltip"]').tooltip();
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    return false;
    
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES LINEA */

/* ------------------------------- */

$(document).on('click', '.datos-linea', function(e) 
{
    var idLinea     = $(this).data('id');
    var accion      = $(this).data('accion');
    var modal       = $(this).data('bs-target');
    var formulario  = $(this).data('form');
    
    $('#btnEjecutarLinea').addClass("d-none");
    
    $(formulario + ' input[type=number]').attr("disabled","disabled");
    
    $(formulario + ' input[type=number]').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    $.post(baseUrl + '/obtener-datos-linea', 
    {         
        idLinea : idLinea
    }, 
    function(response) 
    {
        Swal.close();
    
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, actualice la página para buscar la información.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else 
        {
            if(accion == 'ver')
            {
                $('#exampleinformacionLinea').text("Información de Línea");
                $('#btnEjecutarLinea').addClass("d-none");
                $('#formInformacionLinea').attr('action', '');
                
                $(formulario + ' input[type=number]').attr("disabled","disabled");
            }
            else
            {
                $('#exampleinformacionLinea').text("Actualizar Línea");
                $('#formInformacionLinea').attr('action', baseUrl + '/actualizar-linea/' + idLinea);
                $('#btnEjecutarLinea').removeClass("d-none");
                $('#btnEjecutarLinea').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Guardar');

                $(formulario + ' input[type=number]').removeAttr("disabled");
            }

            $('#txtIDLinea_i').val(response.idlinea);
            
            $('#txtNumero').val(response.numero);
            $('#txtICCID').val(response.iccid);
            
            $(modal).modal("show");
        }
    }, 'json');
    
});

/* ------------------------------- */

$(document).on('submit', '.formularioImportarCSVLinea', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondImportarCSVLinea.getFiles();
    
    if (pondFiles.length === 0) {
        Swal.fire({
            text: "Debe adjuntar la plantilla a subir.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('itemsFile', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('click', '.historico-asignaciones-lineas', function(e)
{
    var idLinea = $(this).data("id");
    var modal = $(this).data('bs-target');
    
    var parametros = {
        "idLinea"   : idLinea
	};
	
    $.ajax({        
        url: baseUrl + '/historico-asignaciones-lineas',
        type: "POST",
        data: parametros,
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            $('#ctnHistoricoAsignacionesModel').html(response);
            $(modal).modal("show");
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    return false;
    
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES CONTRATOS LINEA  */

/* ------------------------------- */

$(document).on('click', '.datos-contrato', function(e) 
{
    var idContrato  = $(this).data('id');
    var accion      = $(this).data('accion');
    var modal       = $(this).data('bs-target');
    var formulario  = $(this).data('form');
    
    $('#btnEjecutarContrato').addClass("d-none");
    
    $(formulario + ' input[type=date]').attr("disabled","disabled");
    $(formulario + ' input[type=number]').attr("disabled","disabled");
    $(formulario + ' select').attr("disabled","disabled");
    
    $(formulario + ' input[type=date]').prop("checked", false);
    $(formulario + ' input[type=number]').val("");
    $(formulario + ' .select2-dinamico').empty();
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
      
    $.post(baseUrl + '/obtener-datos-contrato', 
    {         
        idContrato : idContrato
    }, 
    function(response) 
    {
        Swal.close();
        
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else 
        {
            if(accion == 'ver')
            {
                $('#exampleinformacionContrato').text("Información de contrato");
                $('#btnEjecutarContrato').addClass("d-none");
                $('#formInformacionContrato').attr('action', '');

                $(formulario + ' input[type=date]').attr("disabled","disabled");
                $(formulario + ' input[type=number]').attr("disabled","disabled");
                $(formulario + ' select').attr("disabled","disabled");
            }
            else
            {
                $('#exampleinformacionContrato').text("Actualizar contrato");
                $('#formInformacionContrato').attr('action', baseUrl + '/actualizar-contrato/' + idContrato);
                $('#btnEjecutarContrato').removeClass("d-none");
                $('#btnEjecutarContrato').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Actualizar');

                $(formulario + ' input[type=date]').removeAttr("disabled");
                $(formulario + ' input[type=number]').removeAttr("disabled");
                $(formulario + ' select').removeAttr("disabled");
            }

            $('#txtInicioContrato_i').attr("disabled","disabled");
            
            $('#txtIDContrato_i').val(response.idcontrato);
            
            selectOperadores("txtOperador_i", response.idoperador, modal.substring(1));
            selectPlanes("txtPlan_i", response.idoperador, response.idplan, modal.substring(1));
            
            $('#txtDiaFacturacion_i').val(response.diafacturacion);
            $('#txtInicioContrato_i').val(response.iniciocontrato);
            $('#txtPeriodoPermanencia_i').val(response.periodo).trigger("change");
            $('#txtValorCuota_i').val(response.montocuota);
            
            $(modal).modal("show");
        }
    }, 'json'); 
});

/* ------------------------------- */

$(document).on('click', '#btnRegistrarContratoLinea', function(e) 
{
    $("#ctnPenalidadContratoVigente").empty();
    
    var idLinea = $(this).attr("data-linea");
    var modal       = $(this).data('bs-target');
    var formulario  = $(this).data('form');
    
    var parametros = {
        "idLinea"  : idLinea
	};
	
    $.ajax({        
        url: baseUrl + '/validar-contrato-linea-actual',
        type: "POST",
        data: parametros,
        dataType: 'json',
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            
            if(response.sesion === 0)
            {
                Swal.fire({
                    title: 'Por favor, vuelva a iniciar sesión.',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            }
            else
            {
                Swal.fire({
                    title: "Mensaje: "+response.mensaje,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#282e38',
                    cancelButtonColor: '#f35d5d',
                    confirmButtonText: 'Confirmar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        const fechaActual = moment();
                        const fechaFormateada = fechaActual.format("YYYY-MM-DD");
                        
                        selectOperadores("txtOperador_rcl",'', modal.substring(1));
                        
                        $('#txtPlan_rcl').empty();
                        
                		$('#txtPlan_rcl').select2({
                            dropdownParent: $(modal+' .modal-body')
                        });
                        
                        $('#txtPeriodoPermanencia_rcl').val("").trigger("change");
                        $('#txtInicioContrato_rcl').val(fechaFormateada);
                        $('#txtDiaFacturacion_rcl').val("");
                        $('#txtValorCuota_rcl').val("");
                        
                        $(".contrato-movil").prop("disabled", "disabled");
                        
                        $("#chkContratoMovil_rcl").prop("checked", false);
                        
                        selectMarcas("txtMarcaMovil_rcl",'',modal.substring(1));
                        
                        $('#txtModeloMovil_rcl').empty();
                		
                		$('#txtModeloMovil_rcl').select2({
                            dropdownParent: $('#registroContratoLinea .modal-body')
                        });
                        
                        $('#txtProveedor_rcl').val("").trigger("change");
                        
                        $('#txtFechaCompra_rcl').val(fechaFormateada);
                        $('#txtIMEI_rcl').val("");
                        $('#txtPrecioCompra_rcl').val("");
                        $('#txtPrecioLista_rcl').val("");
                        $("#chkEquipoStock_rcl").prop("checked", false);
                        
                        selectMotivosEstadoMovil("txtMotivoMovil_rcl", "ACT", "", "registroContratoLinea");
                        
                        $('#txtEstadoMovil_rcl').next('.select2').addClass('select2-container--locked');
                        
                        if(response.form=='PEN')
                        {
                            $("#ctnPenalidadContratoVigente").html('<label for="txtMontoDeducible" class="form-label">Monto Penalidad:</label>\n\
                                <div class="input-group">\n\
                                    <input type="number" min="1" step="0.01" class="form-control" aria-label="Monto Penalidad" id="txtMontoDeducible" name="txtMontoDeducible">\n\
                                </div>');
                        }
                        
                        $(modal).modal("show");
                    }
                });
            }
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES HARDWARE */

/* ------------------------------- */

$(document).on('click', '.datos-hardware', function(e) 
{
    $('#btnEjecutarHardware').addClass("d-none");
    var idHardware = $(this).data('id');
    var accion = $(this).data('accion');
    var formulario = $(this).data('form');
    var modal = $(this).data('bs-target');
    //var formulario=$(this).closest('form').attr("id");
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' input[type=date]').attr("disabled","disabled");
    $(formulario + ' input[type=number]').attr("disabled","disabled");
    $(formulario + ' select').attr("disabled","disabled");
    
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' input[type=date]').val("");
    $(formulario + ' input[type=number]').val("");
    $(formulario + ' .select2-dinamico').empty();
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
      
    if(accion == 'crear')
    {
        Swal.close();
        
        selectMarcas("txtMarca_i",'',modal.substring(1));
        
        $('#exampleinformacionHardware').text("Registrar hardware");
        $('#formInformacionHardware').attr('action', baseUrl + '/registrar-hardware');
        $('#btnEjecutarHardware').removeClass("d-none");
        // $('#btnEjecutarHardware').html('<i class="mdi mdi-content-save"></i> Guardar');

        $(formulario + ' input[type=text]').removeAttr("disabled");
        $(formulario + ' input[type=date]').removeAttr("disabled");
        $(formulario + ' input[type=number]').removeAttr("disabled");
        $(formulario + ' select').removeAttr("disabled");
        
        $(formulario + ' select').val("").trigger('change');
        
        $("#txtCategoriaHardware_i").attr("disabled","disabled");
        $("#txtTipoHardware_i").attr("disabled","disabled");
        $("#txtSubtipoHardware_i").attr("disabled","disabled");
        $('#txtMonedaCompraHardware_i').val("PEN").trigger('change');
        
        selectDireccionEstructura("txtDireccionReserva_i", '',modal.substring(1));
        selectDireccionesSUNAT("txtUbicacionHardware_i", '',modal.substring(1));
        
        $(modal).modal("show");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-hardware', 
        {         
            idHardware : idHardware
        }, 
        function(response) 
        {
            Swal.close();
        
            if (response.sesion === 0) 
            {
                Swal.fire({
                    title: 'Por favor, vuelva a iniciar sesión.',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionHardware').text("Información del hardware");
                    $('#btnEjecutarHardware').addClass("d-none");
                    $('#formInformacionHardware').attr('action', '');

                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' input[type=date]').attr("disabled","disabled");
                    $(formulario + ' input[type=number]').attr("disabled","disabled");
                    $(formulario + ' select').attr("disabled","disabled");
                    
                }
                else
                {
                    $('#exampleinformacionHardware').text("Actualizar hardware");
                    $('#formInformacionHardware').attr('action', baseUrl + '/actualizar-hardware/' + idHardware);
                    $('#btnEjecutarHardware').removeClass("d-none");

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' input[type=date]').removeAttr("disabled");
                    $(formulario + ' input[type=number]').removeAttr("disabled");
                    $(formulario + ' select').removeAttr("disabled");
                    
                }

                $("#txtCategoriaHardware_i").attr("disabled","disabled");
                $("#txtTipoHardware_i").attr("disabled","disabled");
                $("#txtSubtipoHardware_i").attr("disabled","disabled");
                
                selectMarcas("txtMarca_i",response.idmarca,modal.substring(1));
                selectDispositivos('txtModeloComercial_i', response.idmarca, response.idmodelo, $("#txtMarca_i").data("categoria"),modal.substring(1));
                selectDireccionesSUNAT("txtUbicacionHardware_i", response.idubicacion, modal.substring(1));
                
                $('#txtIDHardware_i').val(response.idhardware);
                $('#txtHostnameHardware_i').val(response.hostnamehardware);
                $('#txtSerieHardware_i').val(response.serie);
                $('#txtTAGHardware_i').val(response.tag);
                $('#txtProcesadorHardware_i').val(response.procesador).trigger('change');
                $('#txtGenProcesadorHardware_i').val(response.generacion).trigger('change');
                $('#txtRamHardware_i').val(response.ram).trigger('change');
                $('#txtTipoRAMHardware_i').val(response.tiporam);
                $('#txtHDDHardware_i').val(response.hdd).trigger('change');
                $('#txtSSDHardware_i').val(response.ssd).trigger('change');
                $('#txtPulgadasHardware_i').val(response.pulgadas).trigger('change');
                $('#txtInicioGarantia_i').val(response.iniciogarantia);
                $('#txtFinalGarantia_i').val(response.finalgarantia);
                $('#txtFinalVidaUtil_i').val(response.finalvidautil);
                $('#txtDetalleHardware_i').val(response.detalle);
                
                selectDireccionEstructura("txtDireccionReserva_i", response.iddireccion,modal.substring(1));
                selectAreaEstructura('txtAreaReserva_i', response.iddireccion, response.idarea, modal.substring(1));
                selectSubareaEstructura('txtSubareaReserva_i', response.idarea, response.idsubarea, modal.substring(1));
                
                if(response.iddireccion!='' && response.iddireccion!=null && response.idarea!= '' && response.idarea!=null && response.idsubarea!='' && response.idsubarea!=null)
                {
                    $("#txtDireccionReserva_i").attr("disabled","disabled");
                    $("#txtAreaReserva_i").attr("disabled","disabled");
                    $("#txtSubareaReserva_i").attr("disabled","disabled");
                }
                
                $('#txtAlbaranHardware_i').val(response.albaran);
                $('#txtFacturaHardware_i').val(response.factura);
                $('#txtOCHardware_i').val(response.ordencompra);
                $('#txtFechaCompra_i').val(response.fechacompra);
                $('#txtPrecioCompra_i').val(response.preciocompra);
                $('#txtMonedaCompraHardware_i').val(response.monedacompra).trigger('change');
                
                $("#txtCategoriaHardware_i").val(response.categoria);
                $("#txtTipoHardware_i").val(response.tipo);
                $("#txtSubtipoHardware_i").val(response.subtipo);
                
                response.procesador == '' || $('#txtProcesadorHardware_i').val() > 0 ? '' : $("#txtProcesadorHardware_i").append($('<option>', {value: response.procesador,text: response.procesador,selected: true}));
                response.generacion == '' || $('#txtGenProcesadorHardware_i').val() > 0 ? '' : $("#txtGenProcesadorHardware_i").append($('<option>', {value: response.generacion,text: response.generacion+" generación",selected: true}));
                response.ram == '' || $('#txtRamHardware_i').val() > 0 ? '' : $("#txtRamHardware_i").append($('<option>', {value: response.ram,text: response.ram+" GB",selected: true}));
                response.hdd == '' || $('#txtHDDHardware_i').val() > 0 ? '' : $("#txtHDDHardware_i").append($('<option>', {value: response.hdd,text: response.hdd+" GB",selected: true}));
                response.ssd == '' || $('#txtSSDHardware_i').val() > 0 ? '' : $("#txtSSDHardware_i").append($('<option>', {value: response.ssd,text: response.ssd+" GB",selected: true}));
                response.pulgadas == '' || $('#txtPulgadasHardware_i').val() > 0 ? '' : $("#txtPulgadasHardware_i").append($('<option>', {value: response.pulgadas,text: response.pulgadas+"''",selected: true}));
            
                $(modal).modal("show");
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '.historico-asignaciones-hardware', function(e)
{
    var idHardware = $(this).data("id");
    var modal = $(this).data('bs-target');
    
    var parametros = {
        "idHardware"   : idHardware
	};
	
    $.ajax({        
        url: baseUrl + '/historico-asignaciones-hardware',
        type: "POST",
        data: parametros,
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            $('#ctnHistoricoAsignacionesModel').html(response);
            $(modal).modal("show");
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    return false;
    
});

/* ------------------------------- */

$(document).on('click', '#btnGestionNavisionHardware', function(e) 
{
    let modal = $(this).data("bs-target");
    pondGestionHardwareNavision.removeFiles();
    $(modal).modal("show");
});

/* ------------------------------- */

$(document).on('submit', '.formularioGestionNavisionHardware', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondGestionHardwareNavision.getFiles();
    
    if (pondFiles.length === 0) {
        Swal.fire({
            text: "Debe adjuntar el csv para registrar el movimiento que hubo en navisión del hardware.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('itemsFile', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('submit', '.formularioImportarCSVHardware', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondImportarCSVHardware.getFiles();
    
    if (pondFiles.length === 0) {
        Swal.fire({
            text: "Debe adjuntar la plantilla a subir.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('itemsFile', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES TARJETA DE ACCESO */

/* ------------------------------- */

$(document).on('click', '.datos-tarjeta-acceso', function(e) 
{
    var idTarjetaAcceso = $(this).data('id');
    var accion = $(this).data('accion');
    var modal = $(this).data('bs-target');
    
    $('#btnEjecutarTarjetaAcceso').addClass("d-none");
        
    $('#txtSerieTarjetaAcceso_i').attr("disabled","disabled");
    $('#txtPrecioCompra_i').attr("disabled","disabled");
    $('#txtObservacionTarjetaAcceso_i').attr("disabled","disabled");
    
    $('#txtSerieTarjetaAcceso_i').val("");
    $('#txtPrecioCompra_i').val("");
    $('#txtObservacionTarjetaAcceso_i').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
      
    if(accion == 'crear')
    {
        Swal.close();
        
        $('#exampleinformacionTarjetaAcceso').text("Registrar tarjeta de acceso");
        $('#formInformacionTarjetaAcceso').attr('action', baseUrl + '/registrar-tarjeta-acceso');
        $('#btnEjecutarTarjetaAcceso').removeClass("d-none");
        $('#btnEjecutarTarjetaAcceso').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Guardar');

        $('#txtSerieTarjetaAcceso_i').removeAttr("disabled");
        $('#txtPrecioCompra_i').removeAttr("disabled");
        $('#txtObservacionTarjetaAcceso_i').removeAttr("disabled");
        
        $('#txtSerieTarjetaAcceso_i').focus();
        
        $(modal).modal("show");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-tarjeta-acceso', 
        {         
            idTarjetaAcceso : idTarjetaAcceso
        }, 
        function(response) 
        {
            Swal.close();
            
            if (response.sesion === 0) 
            {
                Swal.fire({
                    title: 'Por favor, vuelva a iniciar sesión.',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionTarjetaAcceso').text("Información de la tarjeta de acceso");
                    $('#btnEjecutarTarjetaAcceso').addClass("d-none");
                    $('#formInformacionTarjetaAcceso').attr('action', '');

                    $('#txtSerieTarjetaAcceso_i').attr("disabled","disabled");
                    $('#txtPrecioCompra_i').attr("disabled","disabled");
                    $('#txtObservacionTarjetaAcceso_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionTarjetaAcceso').text("Actualizar tarjeta de acceso");
                    $('#formInformacionTarjetaAcceso').attr('action', baseUrl + '/actualizar-tarjeta-acceso/' + idTarjetaAcceso);
                    $('#btnEjecutarTarjetaAcceso').removeClass("d-none");
                    $('#btnEjecutarTarjetaAcceso').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Actualizar');

                    $('#txtSerieTarjetaAcceso_i').removeAttr("disabled");
                    $('#txtPrecioCompra_i').removeAttr("disabled");
                    $('#txtObservacionTarjetaAcceso_i').removeAttr("disabled");
                }

                $('#txtIDTarjetaAcceso_i').val(response.idtarjetaacceso);
                $('#txtSerieTarjetaAcceso_i').val(response.serie);
                $('#txtPrecioCompra_i').val(response.precio);
                $('#txtObservacionTarjetaAcceso_i').val(response.observacion);
                
                $(modal).modal("show");
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '.historico-asignaciones-tarjeta-acceso', function(e)
{
    var idTarjetaAcceso = $(this).data("id");
    var modal = $(this).data('bs-target');
    
    var parametros = {
        "idTarjetaAcceso"   : idTarjetaAcceso
	};
	
    $.ajax({        
        url: baseUrl + '/historico-asignaciones-tarjeta-acceso',
        type: "POST",
        data: parametros,
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            $('#ctnHistoricoAsignacionesModel').html(response);
            $(modal).modal("show");
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    return false;
    
});

/* ------------------------------- */

$(document).on('submit', '.formularioImportarCSVTarjetaAcceso', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondImportarCSVTarjetaAcceso.getFiles();
    
    if (pondFiles.length === 0) {
        Swal.fire({
            text: "Debe adjuntar la plantilla a subir.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('itemsFile', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('click', '#editar-direcciones-tarjeta-acceso', function(e) 
{
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
      
    $("#ctnDireccionesTarjetaAcceso").empty();
    $("#txtIDTarjetaAcceso").val('');
    
    var idTarjetaAcceso = $(this).data('id');
    var modal = $(this).data('bs-target');
    
    $.post(baseUrl + '/listado-direcciones-tarjeta-acceso', 
    {         
        idTarjetaAcceso : idTarjetaAcceso
    }, 
    function(response) 
    {
        Swal.close();
            
        if (response.sesion === 0) 
        {
            Swal.fire({
                title: 'Por favor, vuelva a iniciar sesión.',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else if (response.descripcion === 0) 
        {
            Swal.fire({
                title: 'No se encontró la información solicitada',
                icon: 'warning',
                showCancelButton: false,
                confirmButtonColor: '#282E38',
                confirmButtonText: 'Confirmar'
            });
        } 
        else 
        {
            var direcciones = $.parseJSON(response.listadoDirecciones);
            
            var opc = '';
            
            for(var i = 0; i < direcciones.length; i++)
            {
                opc += '<div class="col-xxl-12 col-md-12 col-12 my-2 px-3">\n\
					<div class="form-check form-switch d-flex">\n\
						<input class="form-check-input" type="checkbox" role="switch" name="direcciones['+direcciones[i].iddireccion+']" id="chkDireccion'+direcciones[i].iddireccion+'" '+(direcciones[i].activo == 1 ? "checked" : "")+' >\n\
						<label class="form-check-label col-12" style="text-align: right;" for="chkDireccion'+direcciones[i].iddireccion+'">'+direcciones[i].direccion+'</label>\n\
					</div>\n\
					<input type="hidden" name="nombre['+direcciones[i].iddireccion+']" value="'+direcciones[i].direccion+'">\n\
				</div><hr>';
            }
            
            $('#formEditarDireccionesTarjetaAcceso').attr('action', baseUrl + '/grabar-direcciones-tarjeta-acceso/' + idTarjetaAcceso);
            $("#txtIDTarjetaAcceso").val(idTarjetaAcceso);
            $("#ctnDireccionesTarjetaAcceso").html(opc);
            
            $(modal).modal("show");
        }
    }, 'json'); 
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES ACCESORIOS IT */

/* ------------------------------- */

$(document).on('click', '.datos-accesorio-it', function(e) 
{
    var idAccesorio = $(this).data('id');
    var accion = $(this).data('accion');
    var formulario = $(this).data('form');
    var modal = $(this).data('bs-target');
    
    $('#btnEjecutarAccesorioIT').addClass("d-none");
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' input[type=number]').attr("disabled","disabled");
    $(formulario + ' select').attr("disabled","disabled");
    $(formulario + ' textarea').attr("disabled","disabled");
    $(formulario + ' input[type=checkbox]').attr("disabled","disabled");

    $(formulario + ' input[type=number]').val(0);
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' select').val("").trigger('change');
    $(formulario + ' textarea').val("");
    $(formulario + ' input[type=checkbox]').prop("checked",false);
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
            
    if(accion == 'crear')
    {
        Swal.close();
        
        $('#exampleinformacionAccesorio').text("Registrar Accesorio");
        $('#formInformacionAccesorioIT').attr('action', baseUrl + '/registrar-accesorio-it');
        $('#btnEjecutarAccesorioIT').removeClass("d-none");
        $('#btnEjecutarAccesorioIT').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Guardar');
        
        $(formulario + ' input[type=text]').removeAttr("disabled");
        $(formulario + ' input[type=number]').removeAttr("disabled");
        $(formulario + ' select').removeAttr("disabled");
        $(formulario + ' textarea').removeAttr("disabled");
        $(formulario + ' input[type=checkbox]').removeAttr("disabled");
        
        selectMarcas("txtMarca_i",'',modal.substring(1));
        
        $(modal).modal("show");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-accesorio-it', 
        {         
            idAccesorio : idAccesorio
        }, 
        function(response) 
        {
            Swal.close();
            
            if (response.sesion === 0) 
            {
                Swal.fire({
                    title: 'Por favor, vuelva a iniciar sesión.',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionAccesorio').text("Ver Accesorio");
                    $('#btnEjecutarAccesorioIT').addClass("d-none");
                    $('#formInformacionAccesorioIT').attr('action', '');
                    
                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' input[type=number]').attr("disabled","disabled");
                    $(formulario + ' select').attr("disabled","disabled");
                    $(formulario + ' textarea').attr("disabled","disabled");
                    $(formulario + ' input[type=checkbox]').attr("disabled","disabled");
    
                }
                else
                {
                    $('#exampleinformacionAccesorio').text("Actualizar Accesorio");
                    $('#formInformacionAccesorioIT').attr('action', baseUrl + '/actualizar-accesorio-it/' + idAccesorio);
                    $('#btnEjecutarAccesorioIT').removeClass("d-none");

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' input[type=number]').removeAttr("disabled");
                    $(formulario + ' select').removeAttr("disabled");
                    $(formulario + ' textarea').removeAttr("disabled");
                    $(formulario + ' input[type=checkbox]').removeAttr("disabled");
                    
                }
                
                $('#txtIDAccesorioIT').val(response.idaccesorio);
                $('#txtAccesorioIT').val(response.accesorio);
                $('#txtCodNavisionAccesorioIT').val(response.navision);
                $('#txtObservacionAccesorio_i').val(response.observacion);
                $('#txtInicialAccesorioIT').val(response.cantidad);
                $('#txtPrecioNuevoAccesorioIT').val(response.nuevo);
                $('#txtPrecioReutilizadoAccesorioIT').val(response.reutilizado);
                
                if(response.generacobro == "Y")
                {
                    $("#chkGeneraCobroAccesorioIT_i").prop("checked", true);
                }
                else
                {
                    $("#chkGeneraCobroAccesorioIT_i").prop("checked", false);
                }
                
                selectMarcas("txtMarca_i",response.idmarca,modal.substring(1));
                selectDispositivos('txtModeloComercial_i', response.idmarca, response.idmodelo, $("#txtMarca_i").data("categoria"),modal.substring(1));
                $('#txtInicialAccesorioIT').attr("disabled","disabled");
                
                $(modal).modal("show");
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '#btnKardexAccesoriosIT', function(e) 
{
    let modal = $(this).data("bs-target");
    
    selectAccesorioIT("txtAccesorioIT_k", "", modal.substring(1));
    
    $("#ctnRegistrosKardexAccesoriosIT").empty();
    
    $("#txtCantidadAccesorioIT_k").val("1");
    $("#txtObservacionAccesorioIT_k").val("");
    
    $(modal).modal("show");
});

/* ------------------------------- */

$(document).on('click', '#btnAgregarElementoKardexAccesoriosIT', function(e) 
{
    var random = generarRandom(5);
    
    var tipoRegistro    = $("#cboTipoRegistro_k").val();
    var imputado        = $("#txtUsuarioImputado_k").val();
    var accesorio       = $("#txtAccesorioIT_k").val();
    var concepto        = $("#txtConceptoAccesorioIT_k").val();
    var cantidad        = $("#txtCantidadAccesorioIT_k").val();
    var observacion     = $("#txtObservacionAccesorioIT_k").val();
    
    var lblaccesorio    = $('select[id="txtAccesorioIT_k"] option:selected').text();
    var lbltiporegistro = $('select[id="cboTipoRegistro_k"] option:selected').text();
    var lblimputado     = $('select[id="txtUsuarioImputado_k"] option:selected').text();
    
    let registroEv = tipoRegistro == "SAL" ? tipoRegistro+"-"+accesorio+"-"+imputado : tipoRegistro+"-"+accesorio;
        
    var elementosSeleccionados = [];
    $(document).find("input[name='registrokardex[]']").each(function() {
        elementosSeleccionados.push($(this).val());
    });
    
    if(elementosSeleccionados.includes(registroEv))
    {
        Swal.fire({
            html: 'No puede seleccionar el mismo TIPO DE REGISTRO-ACCESORIO-IMPUTADO 2 veces',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(tipoRegistro == 'SAL' && imputado == '')
    {
        Swal.fire({
            html: 'Debe seleccionar un imputado.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(concepto == '')
    {
        Swal.fire({
            html: 'Debe ingresar un concepto.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(accesorio == '')
    {
        Swal.fire({
            html: 'Debe seleccionar un Accesorio.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(cantidad <= 0)
    {
        Swal.fire({
            html: 'Debe registrar una cantidad mayor a cero.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        let contenedor = `<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="kardexEntrada${random}" style="border-radius: 10px;">
            <div class="col-xxl-7 col-md-12 col-12 mb-2">
    			<div>
    				<input type="hidden" name="registrokardex[]" value="`+registroEv+`">
    				<label class="form-label">Tipo de Registro:</label>
    			    <input type="hidden" name="tiporegistroKardex[${random}]" value="`+tipoRegistro+`">
    				<input type="text" class="form-control" value="`+lbltiporegistro+`" disabled>
    			</div>
    		</div>`;
    		
    		if(tipoRegistro == "SAL")
    		{
    		    contenedor += `<div class="col-xxl-12 col-md-12 col-12 mb-2">
        			<div>
        				<label class="form-label">Imputado:</label>
        				<input type="hidden" name="imputadoKardex[${random}]" value="`+imputado+`">
        				<input type="text" class="form-control" value="`+lblimputado+`" disabled>
        			</div>
        		</div>`;
    		}
    		
    		contenedor += `<div class="col-xxl-9 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Accesorio IT:</label>
    			    <input type="hidden" name="idaccesorioitKardex[${random}]" value="`+accesorio+`">
    				<input type="text" class="form-control" value="`+lblaccesorio+`" disabled>
    			</div>
    		</div>
    		<div class="col-xxl-3 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Cantidad:</label>
    				<input type="number" step="1" min="1" class="form-control" name="cantidadKardex[${random}]" value="`+cantidad+`">
    			</div>
    		</div>
    		<div class="col-xxl-12 col-md-12 col-12 mb-2">
    			<div>
    				<label class="form-label">Concepto:</label>
    				<input type="text" class="form-control" name="conceptoKardex[${random}]" value="`+concepto+`">
    			</div>
    		</div>
    		<div class="col-xxl-10 col-md-10 col-10 ">
    		    <div class="form-floating">
                    <textarea class="form-control" id="observacion${random}" name="observacionKardex[${random}]" rows="2">`+observacion+`</textarea>
                    <label for="observacion${random}">Detalle</label>
                </div>
    		</div>
    		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
    			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico('kardexEntrada${random}');" data-tooltip="tooltip" aria-label="Eliminar Registro de Entrada">
                    <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                </button>
    		</div>
    	</div>`;
    
        $("#ctnRegistrosKardexAccesoriosIT").append(contenedor);
        
        $("#cboTipoRegistro_k").val("").trigger('change');
        $("#ctnImputadoKardexAccesoriosIT").addClass("d-none");
        $("#txtAccesorioIT_k").val("").trigger('change');
        $("#txtCantidadAccesorioIT_k").val("1");
        $("#txtConceptoAccesorioIT_k").val("");
        $("#txtObservacionAccesorioIT_k").val("");
        
    }
});

/* ------------------------------- */

$(document).on('click', '.listar-movimientos-kardex-accesorios-it', function(e) 
{
    let modal = $(this).data("bs-target");
    
    $("#txtIDAccesorioIT_lk").val($(this).data("accesorio"));
    
    // Asigna la fecha al campo input
    $('#dtInicio_lk').val(primerDiaMesActual());
    $('#dtFinal_lk').val(ultimoDiaMesActual());
    
    listarMovimientosKardexAccesoriosIT(primerDiaMesActual(), ultimoDiaMesActual(), $(this).data("accesorio"), "ctnListadoMovimientosKardexAccesoriosIT");

    $(modal).modal("show");
});

/* ------------------------------- */

$(document).on('click', '#btnBuscarMovimientosKardexAccesoriosIT', function(e) 
{
    let idAccesorio = $("#txtIDAccesorioIT_lk").val();
    let fechaInicio = $("#dtInicio_lk").val();
    let fechaFin = $("#dtFinal_lk").val();
    
    listarMovimientosKardexAccesoriosIT(fechaInicio, fechaFin, idAccesorio, "ctnListadoMovimientosKardexAccesoriosIT");
});

/* ------------------------------- */

function listarMovimientosKardexAccesoriosIT(fechaInicio, fechaFin, idAccesorioIT, contenedor)
{
    $("#"+contenedor).empty();
    
    if(fechaInicio == '')
    {
        Swal.fire({
            html: 'Debe seleccionar una fecha de inicio para mostrar la información',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(fechaFin == '')
    {
        Swal.fire({
            html: 'Debe seleccionar una fecha de fin para mostrar la información',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(idAccesorioIT == '')
    {
        Swal.fire({
            html: 'No hay accesorio IT para mostrar la información',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        var parametros = {
            "fechaInicio"   : fechaInicio,
            "fechaFin"      : fechaFin,
            'idAccesorioIT' : idAccesorioIT
    	};
    	
        $.ajax({        
            url: baseUrl + '/mostrar-movimientos-kardex-accesorios-it',
            type: "POST",
            data: parametros,
            beforeSend: function() {
                Swal.fire({
                    html: 'Un momento por favor...',
                    heightAuto: true,
                    showConfirmButton: false
                });
            },
            success: function(response) {
                Swal.close();
                $('#'+contenedor).append(response);
            }, 
            error: function(jqXHR, textStatus, errorThrown){
                
                Swal.close();
                
                Swal.fire({
                    title: 'Ha ocurrido un error interno',
                    text: errorThrown,
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#E4002B',
                    confirmButtonText: 'Confirmar'
                });
            }
        });
    }
}

/* ------------------------------- */

$(document).on('click', '#btnExportarKardexAccesoriosIT', function(e) 
{
    let modal = $(this).data("bs-target");
    
    $('#dtInicio_rka').val(primerDiaMesActual());
    $('#dtFinal_rka').val(ultimoDiaMesActual());
    
    $(modal).modal("show");
});

/* ------------------------------- */

$(document).on('click', '.validacion-kardex-accesorios-it', function(e) 
{
    let modal = $(this).data("bs-target");
    
    $("#txtIDRegistroKardexAccesoriosIT").val($(this).data("registro"));
    $("#txtNombreAdjunto_rkait").val("");
    pondValidacionKardexAccesorioIT.removeFiles();
    
    $(modal).modal("show");
});

/* ------------------------------- */

$(document).on('submit', '.formularioImportarValidacionKardexAccesoriosIT', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondValidacionKardexAccesorioIT.getFiles();
    
    if (pondFiles.length === 0) {
        Swal.fire({
            text: "Debe adjuntar el correo para la validación.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('itemsFile', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES ACTA ASIGNACIÓN */

/* ------------------------------- */

$(document).on('click', '#btnNuevaAsignacion', function(e) 
{
    var formulario = $(this).data('form');
    var modal = $(this).data('bs-target');
    
    $(formulario + ' #txtTipoAsignado').val("").trigger("change");
    $(formulario + ' #txtObservacionAsignacion').val("");
    $(formulario + ' #txtUsuarioAsignacion').val("");
    $(formulario + ' #txtNombreAsignado').val("");
    $(formulario + ' #txtApellidoAsignado').val("");
    $(formulario + ' #txtDocumentoAsignado').val("");
    $(formulario + ' #txtDireccionAsignado').val("");
    $(formulario + ' #txtAreaAsignado').val("");
    $(formulario + ' #txtCargoAsignado').val("");
    
    $(formulario + ' #ctnElementosAsignacion').empty();
    
    $(modal).modal("show");
});

/* ------------------------------- */

$(document).on('change', '#txtUsuarioAsignacion', function() 
{
    var idUsuario = $(this).val();
    var modal = $(this).data("modal");
    
    if(idUsuario != '')
    {
        var parametros = {
            "idUsuario"  : idUsuario
    	};
    	
        $.ajax({        
            url: baseUrl + '/obtener-datos-usuario',
            type: "POST",
            data: parametros,
            dataType: 'json',
            beforeSend: function() 
            {
                Swal.fire({
                    html: 'Un momento por favor...',
                    heightAuto: true,
                    showConfirmButton: false
                });
            },
            success: function(response) 
            {
                Swal.close();
                
                if (response.sesion === 0) 
                {
                    Swal.fire({
                        title: 'Por favor, vuelva a iniciar sesión.',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonColor: '#282E38',
                        confirmButtonText: 'Confirmar'
                    });
                    $(modal).modal("hide");
                } 
                else if (response.descripcion === 0 || response.descripcion === 2) 
                {
                    Swal.fire({
                        title: response.mensaje,
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonColor: '#282E38',
                        confirmButtonText: 'Confirmar'
                    });
                    $('#txtUsuarioAsignacion').val('').trigger('change');
                    $('#txtNombreAsignado').val('');
                    $('#txtApellidoAsignado').val('');
                    $('#txtDocumentoAsignado').val('');
                    $('#txtDireccionAsignado').val('');
                    $('#txtAreaAsignado').val('');
                    $('#txtCargoAsignado').val('');
                }
                else 
                {
                    $('#txtNombreAsignado').val(response.nombres);
                    $('#txtApellidoAsignado').val(response.apellidos);
                    $('#txtDocumentoAsignado').val(response.documento);
                    $('#txtDireccionAsignado').val(response.direccion);
                    $('#txtAreaAsignado').val(response.area);
                    $('#txtCargoAsignado').val(response.cargo);
                }
                
                $('.validarNextTab').blur();
            }, 
            error: function(jqXHR, textStatus, errorThrown){
                //$.unblockUI({});
                Swal.close();
                
                Swal.fire({
                    title: 'Ha ocurrido un error interno',
                    text: errorThrown,
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#E4002B',
                    confirmButtonText: 'Confirmar'
                });
            }
        });
    }
});

/* ------------------------------- */

$(document).on('change', '#txtTipoAsignado', function(event) 
{
    $('.validarNextTab').blur();
});

/* ------------------------------- */

function agregarItemAsignacion()
{
    var tipoElemento = $("#txtElementoNuevaAsignacion").val();
    var itemElemento = $("#txtItem").val();
    
    var elementosSeleccionados = [];
    $(document).find("input[name='itemAsignacion[]']").each(function() {
        elementosSeleccionados.push($(this).val());
    });
    
    if(elementosSeleccionados.includes(tipoElemento+"-"+itemElemento))
    {
        Swal.fire({
            html: 'No puede seleccionar el mismo item 2 veces',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(tipoElemento == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el elemento a asignar',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(itemElemento == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el item a asignar',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        var parametros = {
            "tipoElemento" : tipoElemento,
            "itemElemento" : itemElemento,
            'seleccionados': JSON.stringify(elementosSeleccionados)
    	};
    	
        $.ajax({        
            url: baseUrl + '/obtener-elemento-a-asignar',
            type: "POST",
            data: parametros,
            beforeSend: function() {
                Swal.fire({
                    html: 'Un momento por favor...',
                    heightAuto: true,
                    showConfirmButton: false
                });
            },
            success: function(response) {
                Swal.close();
                if(response == '')
                {
                    Swal.fire({
                        html: 'No se encontró el elemento.',
                        heightAuto: true,
                        showConfirmButton: true
                    });
                }
                else
                {
                    $('#ctnElementosAsignacion').append(response);
                    $('#txtItem').empty();
                }
            }, 
            error: function(jqXHR, textStatus, errorThrown){
                
                Swal.close();
                
                Swal.fire({
                    title: 'Ha ocurrido un error interno',
                    text: errorThrown,
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#E4002B',
                    confirmButtonText: 'Confirmar'
                });
            }
        });
    }
}

/* ------------------------------- */

$(document).on('change', '.precio-tipo-accesorio-asignacion', function(e) {
    
    var precio = $(this).data('precio');
    var aleatorio = $(this).data('aleatorio');
    
    $("#txtCostoReposicion"+aleatorio).val(precio);
});

/* ------------------------------- */

$(document).on('submit', '.formularioImportarCSVAsignacion', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondCSVAsignacion.getFiles();
    
    if (pondFiles.length === 0) {
        Swal.fire({
            text: "Debe adjuntar el CSV para la validación.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('fileCSVAsignacion', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('submit', '.formularioAdjuntarDocumentoAsignacion', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondAdjuntoAsignacion.getFiles();
    
    if (pondFiles.length === 0) {
        Swal.fire({
            text: "Debe adjuntar el archivo.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('itemsFile', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('click', '#btnEnviarCorreoAsignacion', function(e) {
    var idAsignacion = $(this).attr("data-id");
    
    var parametros = {
        "idAsignacion"  : idAsignacion
    };
    $.ajax({        
        url: baseUrl + '/enviar-correo-asignacion',
        type: "POST",
        data: parametros,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            $('.respuesta_global').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
});

/* ------------------------------- */

$(document).on('click', '#btnDescargarPDFActaAsignacion', function(e) 
{
    var idAsignacion    = $(this).attr("data-id");
    var codigo          = $(this).attr("data-cod");
    var accion          = $(this).attr("data-accion");
    
    Swal.fire({
        title: 'Un momento',
        text: 'Estamos procesando tu solicitud...',
        icon: 'info',
        showConfirmButton: false,
        allowOutsideClick: false,
        didOpen: () => {
            // Abrir la ventana emergente y no permitir cerrar mientras se procesa
            Swal.showLoading();
        }
    });
    
    window.location.href = baseUrl + '/verPDFActaAsignacion/'+idAsignacion+'/'+codigo+'/'+accion;
    
    setTimeout(function() {
        // Cuando el archivo empiece a descargarse, cierra el SweetAlert automáticamente
        Swal.close();
    }, 7000); 
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES ACTA DEVOLUCIÓN */

/* ------------------------------- */

$(document).on('click', '#btnRegistrarDevolucion', function(e) {
    
    var modal = $(this).data('bs-target');
    var formulario = $(this).data('form');
    
    // $(modal + ' #txtMotivoDevolucion').val("");
    $(formulario + ' #txtObservacion').val("");
    // $(modal + ' #txtUsuarioDevolucionModal').val("");
    $(formulario + ' #txtMatriculaDevolucion').val("");
    $(formulario + ' #txtNombreDevolucion').val("");
    $(formulario + ' #txtApellidoDevolucion').val("");
    $(formulario + ' #txtDocumentoDevolucion').val("");
    $(formulario + ' #txtDireccionDevolucion').val("");
    $(formulario + ' #txtAreaDevolucion').val("");
    $(formulario + ' #txtCargoDevolucion').val("");
    
    $(formulario + ' #txtMotivoDevolucion').val('').trigger('change');
    $(formulario + ' #txtUsuarioDevolucionModal').val('').trigger('change');
    
    $(formulario + ' #ctnElementosDevolucion').empty();
    
    $(modal).modal("show");
});

/* ------------------------------- */

function mostrarElementosDevolver(idUsuario, motivoDevolucion)
{
    if(idUsuario != '' && motivoDevolucion != '')
    {
        $.post(baseUrl + '/elementos-devolucion', 
        {
            idUsuario           : idUsuario,
            motivoDevolucion    : motivoDevolucion
        }, 
        function(response) 
        {
            $("#ctnElementosDevolucion").empty();
            $("#ctnElementosDevolucion").html(response.html);
        }, 'json');
    }
    else
    {
        $('#ctnElementosDevolucion').empty();
    }
}

/* ------------------------------- */

function agregarItemDevolucion()
{
    var idItem      = $("#txtItemDevolucion").val();
    var idUsuario   = $("#txtUsuarioDevolucionModal").val();
    var motivo      = $("#txtMotivoDevolucion").val();
    
    var elementosSeleccionados = [];
    $(document).find("input[name='itemDevolucion[]']").each(function() {
        elementosSeleccionados.push($(this).val());
    });
    
    if(elementosSeleccionados.includes(idItem))
    {
        Swal.fire({
            html: 'No puede seleccionar el mismo item 2 veces',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(idItem == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el item a reponer',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        var parametros = {
            "idItem"    : idItem,
            "idUsuario" : idUsuario,
            "motivo"    : motivo
    	};
    	
        $.ajax({        
            url: baseUrl + '/obtener-elemento-a-devolver',
            type: "POST",
            data: parametros,
            beforeSend: function() {
                Swal.fire({
                    html: 'Un momento por favor...',
                    heightAuto: true,
                    showConfirmButton: false
                });
            },
            success: function(response) {
                Swal.close();
                $('#ctnListadoElementosDevolucion').append(response);
                $("#txtItemDevolucion").val("").trigger('change');
            }, 
            error: function(jqXHR, textStatus, errorThrown){
                
                Swal.close();
                
                Swal.fire({
                    title: 'Ha ocurrido un error interno',
                    text: errorThrown,
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#E4002B',
                    confirmButtonText: 'Confirmar'
                });
            }
        });
    }
}

/* ------------------------------- */

$(document).on('change', 'input[name="txtPreguntaEmailDevolucion"]', function() 
{
    if ($('#rdbtnSiEmailPersonalDevolucion').is(':checked')) 
    {
        $('#ctnCorreoPersonalDevolucion').collapse('show');
        $('#ctnMotivoNoCorreoPersonalDevolucion').collapse('hide');
        
        $('#txtCorreoPersonalDevolucion').prop("disabled", false);
        $('#txtNroCelularPersonalDevolucion').prop("disabled", false);
        
        $('#txtCorreoPersonalDevolucion').val("");
        $('#txtNroCelularPersonalDevolucion').val("");
    } 
    else if ($('#rdbtnNoEmailPersonalDevolucion').is(':checked')) 
    {
        $('#ctnCorreoPersonalDevolucion').collapse('hide');
        $('#ctnMotivoNoCorreoPersonalDevolucion').collapse('show');
        
        $('#txtCorreoPersonalDevolucion').prop("disabled", true);
        $('#txtNroCelularPersonalDevolucion').prop("disabled", true);
        
        $('#txtCorreoPersonalDevolucion').val("");
        $('#txtNroCelularPersonalDevolucion').val("");
    }
});

/* ------------------------------- */

$(document).on('submit', '.formularioRegistrarDevolucion', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondDenunciaDevolucion.getFiles();
    
    var requiredDenuncia = false;
    
    if ($('.select2-situacionelementodevolucion').val() === "ROB" || $('.select2-situacionelementodevolucion').val() === "PER") {
        requiredDenuncia = true;
    }
    
    var formData = new FormData(this);
    
    if(requiredDenuncia)
    {
        if (pondFiles.length === 0) {
            Swal.fire({
                text: "Debe adjuntar el archivo.",
                icon: 'warning',
                showCancelButton: false,
                cancelButtonText: 'No',
                confirmButtonColor: '#282e38',
                confirmButtonText: 'OK'
            });
            return false;
        }
        
        for (var i = 0; i < pondFiles.length; i++) {
            formData.append('itemsFile', pondFiles[i].file);
        }
        
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('submit', '.formularioAdjuntarDocumentoDevolucion', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondAdjuntoDevolucion.getFiles();
    
    if (pondFiles.length === 0) {
        Swal.fire({
            text: "Debe adjuntar el archivo.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('itemsFile', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('click', '#btnEnviarCorreoDevolucion', function(e) 
{
    var idDevolucion = $(this).attr("data-id");
    
    var parametros = {
        "idDevolucion"  : idDevolucion
    };
    
    $.ajax({        
        url: baseUrl + '/enviar-correo-devolucion',
        type: "POST",
        data: parametros,
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            $('.respuesta_global').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
});

/* ------------------------------- */

$(document).on('click', '#btnDescargarPDFActaDevolucion', function(e) 
{
    var idDevolucion    = $(this).attr("data-id");
    var codigo          = $(this).attr("data-cod");
    var accion          = $(this).attr("data-accion");
    
    Swal.fire({
        title: 'Un momento',
        text: 'Estamos procesando tu solicitud...',
        icon: 'info',
        showConfirmButton: false,
        allowOutsideClick: false,
        didOpen: () => {
            // Abrir la ventana emergente y no permitir cerrar mientras se procesa
            Swal.showLoading();
        }
    });
    
    window.location.href = baseUrl + '/verPDFActaDevolucion/'+idDevolucion+'/'+codigo+'/'+accion;
    
    setTimeout(function() {
        // Cuando el archivo empiece a descargarse, cierra el SweetAlert automáticamente
        Swal.close();
    }, 7000); 
});

/* ------------------------------- */

function recargarDetalleElementosActaDevolucion(btnDetalle)
{
    let idDevolucion = $(btnDetalle).data("devolucion");
    
    recargarTablaDetalleElementosActaDevolucion(idDevolucion);
}

/* ------------------------------- */

function recargarTablaDetalleElementosActaDevolucion(idDevolucion)
{
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    let rutavista = window.location.href;
    let arrayrutavista = rutavista.split("/");
    
    $('#tblDetalleElementosDevolucion').DataTable().destroy();
    
    $("#tblDetalleElementosDevolucion").DataTable({
        "ajax": {
            "url": baseUrl + "/recargar-detalle-elementos-devolucion",
            "type": "POST",
            "data": {
                "idDevolucion"  : idDevolucion,
                "url_vista"     : arrayrutavista[arrayrutavista.length-3]
            },
            "dataSrc": function (json) 
            {
                // $("#lblSubtitulo").html(json.subtitulo);
                Swal.close();
                
                if(json.sesion === 0)
                {
                    Swal.fire({
                        title: 'Por favor, vuelva a iniciar sesión.',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonColor: '#282E38',
                        confirmButtonText: 'Confirmar'
                    });
                }
                
                return json.data;
            },
            "error": function (xhr, error, thrown) 
            {
                Swal.close();
            
                Swal.fire({
                    title: 'Ha ocurrido un error interno',
                    text: thrown.message,
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#E4002B',
                    confirmButtonText: 'Confirmar'
                });
            }
        },
        columnDefs: [
            { className: "text-center align-middle", targets: "_all" }
        ],
        columns: [
           { data: 'codigo' },
           { data: 'tipo_elemento' },
           { data: 'elemento' },
           { data: 'motivo' },
           { data: 'observacion' },
           { data: 'validacion' },
           { data: 'reposicion' }
        ],
		"lengthMenu": [[10, 25, 50], [10, 25, 50]],
		responsive: true,
		autoWidth: false,
		"pageLength": 10,
		"paging": true,
		"aaSorting": [[0, 'desc']],
    });
    
}

/* ------------------------------- */

$(document).on('click', '.validar-detalle-devolucion', function(e) 
{
    let idDetalleDevolucion = $(this).data("id");
    let idDevolucion        = $(this).data("devolucion");
    let tipo                = $(this).data("tipo");
    let elemento            = $(this).data("elemento");
    
//     var parametros = {
//         "idDetalleDevolucion"   : idDetalleDevolucion,
//         "idDevolucion"          : idDevolucion
// 	};
	
//     $.ajax({        
//         url: baseUrl + '/formulario-validacion-detalle-devolucion/'+idDetalleDevolucion,
//         type: "POST",
//         data: parametros,
//         beforeSend: function() 
//         {
//             Swal.fire({
//                 html: 'Un momento por favor...',
//                 heightAuto: true,
//                 showConfirmButton: false
//             });
//         },
//         success: function(response) 
//         {
//             Swal.close();
            
//             $('.respuesta_global').html(response.mensaje);
            
//             if(response.result == 1)
//             {
//                 recargarTablaDetalleElementosActaDevolucion(idDevolucion);
//             }
//         }, 
//         error: function(jqXHR, textStatus, errorThrown)
//         {
//             Swal.close();
    
//             Swal.fire({
//                 title: 'Ha ocurrido un error interno',
//                 text: errorThrown,
//                 icon: 'error',
//                 showCancelButton: false,
//                 confirmButtonColor: '#E4002B',
//                 confirmButtonText: 'Confirmar'
//             });
//         }
//     });









//     var mensaje = "";
//     var checkAnulacion = "";
    
//     mensaje = '';
    
//     checkRecibido = '<div class="col-12 col-md-12 my-2">\n\
// 		<div class="col-12 border-sistema-2px p-2 d-flex justify-content-between align-items-center" style="border-radius: 15px;">\n\
// 		    <h5 class="color-sistema m-0" for="chkRecibido_dev">¿Elemento Recibido?: <span id="spnEstadoChkRecibido_dev">NO</span></h5>\n\
// 		    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkRecibido_dev">\n\
// 				<input class="form-check-input form-check-input-green" type="checkbox" role="switch" name="chkRecibido_dev" id="chkRecibido_dev">\n\
// 				<label class="form-check-label m-0" for="chkRecibido_dev"></label>\n\
// 			</div>\n\
// 		</div>\n\
// 	</div>';

//     Swal.fire({
//         title: "VALIDACIÓN DE ELEMENTOS<br><br>El elemento '"+elemento+"' va a ser validado.",
//         // text: mensaje,
//         icon: 'warning',
//         html: checkRecibido,
//         showCancelButton: true,
//         confirmButtonColor: '#282e38',
//         cancelButtonColor: '#f35d5d',
//         confirmButtonText: 'Validar',
//         input: 'textarea',
//         inputAttributes: {
//             autocapitalize: 'on'
//         },
//         inputValidator: obs => {
//             // // Si el valor es válido, debes regresar undefined. Si no, una cadena
//             // if (!obs) {
//             //     return "Por favor escribe el motivo";
//             // } else {
//             //     return undefined;
//             // }
//         }
//     }).then((result) => {
//         if (result.isConfirmed) {

//             var motivo = result.value;
//             var recibido = "";
            
//             if ($('#chkRecibido_dev').length) 
//             {
//                 // Si existe, obtenemos si está seleccionado
//                 var recibido = $('#chkRecibido_dev').prop('checked');
//             }
            
//             var parametros = {
//                 "observacionValidacion" : motivo,
//                 "elementoRecibido"      : recibido
//     		};
//             $.ajax({        
//                 url: baseUrl + '/validacion-detalle-devolucion/'+idDetalleDevolucion,
//                 type: "POST",
//                 data: parametros,
//                 dataType: 'json',
//                 beforeSend: function() 
//                 {
//                     Swal.fire({
//                         html: 'Un momento por favor...',
//                         heightAuto: true,
//                         showConfirmButton: false
//                     });
//                 },
//                 success: function(response) 
//                 {
//                     Swal.close();
                    
//                     $('.respuesta_global').html(response.mensaje);
                    
//                     if(response.result == 1)
//                     {
//                         recargarTablaDetalleElementosActaDevolucion(idDevolucion);
//                     }
//                 }, 
//                 error: function(jqXHR, textStatus, errorThrown)
//                 {
//                     Swal.close();
            
//                     Swal.fire({
//                         title: 'Ha ocurrido un error interno',
//                         text: errorThrown,
//                         icon: 'error',
//                         showCancelButton: false,
//                         confirmButtonColor: '#E4002B',
//                         confirmButtonText: 'Confirmar'
//                     });
//                 }
//             });
//         }
//     });

//     return false;
});

/* ------------------------------- */

$(document).on('click', '#btnValidarActivosDevueltos', function(e) 
{
    let idDevolucion    = $(this).data("devolucion");
    let modal           = $(this).data("bs-target");
    
    var parametros = {
        "idDevolucion"  : idDevolucion
	};
	
    $.ajax({        
        url: baseUrl + '/validacion-activos-devolucion',
        type: "POST",
        data: parametros,
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            
            $('#ctnActivosValidarDevolucion').html(response);
            $(modal).modal("show");
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
    
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });









//     var mensaje = "";
//     var checkAnulacion = "";
    
//     mensaje = '';
    
//     checkRecibido = '<div class="col-12 col-md-12 my-2">\n\
// 		<div class="col-12 border-sistema-2px p-2 d-flex justify-content-between align-items-center" style="border-radius: 15px;">\n\
// 		    <h5 class="color-sistema m-0" for="chkRecibido_dev">¿Elemento Recibido?: <span id="spnEstadoChkRecibido_dev">NO</span></h5>\n\
// 		    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkRecibido_dev">\n\
// 				<input class="form-check-input form-check-input-green" type="checkbox" role="switch" name="chkRecibido_dev" id="chkRecibido_dev">\n\
// 				<label class="form-check-label m-0" for="chkRecibido_dev"></label>\n\
// 			</div>\n\
// 		</div>\n\
// 	</div>';

//     Swal.fire({
//         title: "VALIDACIÓN DE ELEMENTOS<br><br>El elemento '"+elemento+"' va a ser validado.",
//         // text: mensaje,
//         icon: 'warning',
//         html: checkRecibido,
//         showCancelButton: true,
//         confirmButtonColor: '#282e38',
//         cancelButtonColor: '#f35d5d',
//         confirmButtonText: 'Validar',
//         input: 'textarea',
//         inputAttributes: {
//             autocapitalize: 'on'
//         },
//         inputValidator: obs => {
//             // // Si el valor es válido, debes regresar undefined. Si no, una cadena
//             // if (!obs) {
//             //     return "Por favor escribe el motivo";
//             // } else {
//             //     return undefined;
//             // }
//         }
//     }).then((result) => {
//         if (result.isConfirmed) {

//             var motivo = result.value;
//             var recibido = "";
            
//             if ($('#chkRecibido_dev').length) 
//             {
//                 // Si existe, obtenemos si está seleccionado
//                 var recibido = $('#chkRecibido_dev').prop('checked');
//             }
            
//             var parametros = {
//                 "observacionValidacion" : motivo,
//                 "elementoRecibido"      : recibido
//     		};
//             $.ajax({        
//                 url: baseUrl + '/validacion-detalle-devolucion/'+idDetalleDevolucion,
//                 type: "POST",
//                 data: parametros,
//                 dataType: 'json',
//                 beforeSend: function() 
//                 {
//                     Swal.fire({
//                         html: 'Un momento por favor...',
//                         heightAuto: true,
//                         showConfirmButton: false
//                     });
//                 },
//                 success: function(response) 
//                 {
//                     Swal.close();
                    
//                     $('.respuesta_global').html(response.mensaje);
                    
//                     if(response.result == 1)
//                     {
//                         recargarTablaDetalleElementosActaDevolucion(idDevolucion);
//                     }
//                 }, 
//                 error: function(jqXHR, textStatus, errorThrown)
//                 {
//                     Swal.close();
            
//                     Swal.fire({
//                         title: 'Ha ocurrido un error interno',
//                         text: errorThrown,
//                         icon: 'error',
//                         showCancelButton: false,
//                         confirmButtonColor: '#E4002B',
//                         confirmButtonText: 'Confirmar'
//                     });
//                 }
//             });
//         }
//     });

//     return false;
});

/* ------------------------------- */

$(document).on('change', '#chkRecibido_dev', function() {
    if(this.checked)
    {
        $('#spnEstadoChkRecibido_dev').html("SI");
    }
    else
    {
        $('#spnEstadoChkRecibido_dev').html("NO");
    }
});

/* ------------------------------- */
/*
$(document).on('change', 'input[name="txtRecepcionElemento_vda"]', function() 
{
    if ($('#rdbtnActivoRecibido_vda').is(':checked')) 
    {
        $('#ctnEstadoRealDevolucion').collapse('show');
        $('#ctnInformeRecepcionActivo').collapse('hide');
        
        setOptionsCombobox('txtSituacionRealDevuelto', []);
    } 
    else if ($('#rdbtnActivoNoRecibido_vda').is(':checked')) 
    {
        $('#ctnEstadoRealDevolucion').collapse('hide');
        $('#ctnInformeRecepcionActivo').collapse('show');
        
        setOptionsCombobox('txtSituacionRealDevuelto', [
            { value: 'NOD', text: 'NO DEVOLUCIÓN' }
        ]);
    }
});

/* ------------------------------- 

$(document).on('change', 'input[name="txtEstadoRealDevolucionActivo_vda"]', function() 
{
    if ($('#rdbtnEstadoRealActivo_vda').is(':checked')) 
    {
        $('#ctnInformeRecepcionActivo').collapse('hide');
        // $('#ctnInformeRecepcionActivo').collapse('hide');
        setOptionsCombobox('txtSituacionRealDevuelto', []);
    } 
    else
    {
        $('#ctnInformeRecepcionActivo').collapse('show');
        // $('#ctnInformeRecepcionActivo').collapse('show');
        
        setOptionsCombobox('txtSituacionRealDevuelto', [
            { value: '', text: 'Seleccione una opción...' },
            { value: 'INO', text: 'INOPERATIVO' },
            { value: 'ROB', text: 'ROBO' },
            { value: 'PER', text: 'PÉRDIDA' },
            { value: 'NOD', text: 'NO DEVOLUCIÓN' },
            { value: 'FAL', text: 'FALLA' },
            { value: 'FVU', text: 'FIN DE VIDA ÚTIL' },
            { value: 'DEV', text: 'DEVOLUCIÓN OK' }
        ]);
    }
});
*/
/* ------------------------------- */

$(document).on('change', '.rdbtnActivoRecibidoDevolucion', function() 
{
    let idDetalleAsignacion = $(this).data("detalle-asignacion");
    
    if ($('#rdbtnActivoRecibido_vda'+idDetalleAsignacion).is(':checked')) 
    {
        $('#ctnEstadoRealDevolucion'+idDetalleAsignacion).collapse('show');
        $('#ctnInformeRecepcionActivo'+idDetalleAsignacion).collapse('hide');
        $('#ctnSelectEstadoRealDevolucion'+idDetalleAsignacion).collapse('hide');
        $('#ctnObservacionValidacionDevolucion'+idDetalleAsignacion).collapse('hide');
        
        $('#rdbtnEstadoRealActivo_vda'+idDetalleAsignacion).prop('checked', false);
        $('#rdbtnEstadoNoRealActivo_vda'+idDetalleAsignacion).prop('checked', false);
        
        setOptionsCombobox('txtSituacionRealDevuelto'+idDetalleAsignacion, []);
        
        $('#informe'+idDetalleAsignacion).val("NO");
    } 
    else if ($('#rdbtnActivoNoRecibido_vda'+idDetalleAsignacion).is(':checked')) 
    {
        $('#ctnEstadoRealDevolucion'+idDetalleAsignacion).collapse('hide');
        $('#ctnInformeRecepcionActivo'+idDetalleAsignacion).collapse('show');
        $('#ctnSelectEstadoRealDevolucion'+idDetalleAsignacion).collapse('show');
        $('#ctnObservacionValidacionDevolucion'+idDetalleAsignacion).collapse('hide');
        
        $('#rdbtnEstadoRealActivo_vda'+idDetalleAsignacion).prop('checked', false);
        $('#rdbtnEstadoNoRealActivo_vda'+idDetalleAsignacion).prop('checked', false);
        
        setOptionsCombobox('txtSituacionRealDevuelto'+idDetalleAsignacion, [
            { value: 'NOD', text: 'NO DEVOLUCIÓN', accion: 'BAJ' }
        ]);
        
        $('#informe'+idDetalleAsignacion).val("GENERA");
    }
});

/* ------------------------------- */

$(document).on('change', '.rdbtnEstadoRealDevolucion', function() 
{
    let idDetalleAsignacion = $(this).data("detalle-asignacion");
    let situacion           = $(this).data("situacion");
    
    if ($('#rdbtnEstadoRealActivo_vda'+idDetalleAsignacion).is(':checked')) 
    {
        $('#ctnSelectEstadoRealDevolucion'+idDetalleAsignacion).collapse('hide');
        setOptionsCombobox('txtSituacionRealDevuelto'+idDetalleAsignacion, []);
        
        if(situacion == "ACT")
        {
            $('#ctnInformeRecepcionActivo'+idDetalleAsignacion).collapse('hide');
            $('#ctnObservacionValidacionDevolucion'+idDetalleAsignacion).collapse('show');
            $('#informe'+idDetalleAsignacion).val("NO");
        }
        else
        {
            $('#ctnObservacionValidacionDevolucion'+idDetalleAsignacion).collapse('hide');
            $('#ctnInformeRecepcionActivo'+idDetalleAsignacion).collapse('show');
            $('#informe'+idDetalleAsignacion).val("GENERA");
        }
    } 
    else
    {
        $('#ctnObservacionValidacionDevolucion'+idDetalleAsignacion).collapse('hide');
        // $('#ctnInformeRecepcionActivo').collapse('show');
        $('#ctnSelectEstadoRealDevolucion'+idDetalleAsignacion).collapse('show');
        
        setOptionsCombobox('txtSituacionRealDevuelto'+idDetalleAsignacion, [
            { value: '', text: 'Seleccione una opción...', accion: '' },
            { value: 'INO', text: 'INOPERATIVO', accion: 'BAJ' },
            { value: 'ROB', text: 'ROBO', accion: 'BAJ' },
            { value: 'PER', text: 'PÉRDIDA', accion: 'BAJ' },
            { value: 'NOD', text: 'NO DEVOLUCIÓN', accion: 'BAJ' },
            { value: 'FAL', text: 'FALLA', accion: 'BAJ' },
            { value: 'FVU', text: 'FIN DE VIDA ÚTIL', accion: 'BAJ' },
            { value: 'DEV', text: 'DEVOLUCIÓN OK', accion: 'ACT' }
        ]);
        $('#ctnInformeRecepcionActivo'+idDetalleAsignacion).collapse('hide');
        $('#informe'+idDetalleAsignacion).val("NO");
    }
});

/* ------------------------------- */

$(document).on('change', '.cboSituacionRealActivoDevuelto', function() 
{
    let idDetalleAsignacion = $(this).data('detalle-asignacion');
    let selectedOption = $(this).find('option:selected');
    let accion = selectedOption.data('accion'); // obtiene data-accion
    
    if(accion == "ACT")
    {
        $('#ctnInformeRecepcionActivo'+idDetalleAsignacion).collapse('hide');
        $('#ctnObservacionValidacionDevolucion'+idDetalleAsignacion).collapse('show');
        $('#informe'+idDetalleAsignacion).val("NO");
    }
    else if(accion == "BAJ")
    {
        $('#ctnObservacionValidacionDevolucion'+idDetalleAsignacion).collapse('hide');
        $('#ctnInformeRecepcionActivo'+idDetalleAsignacion).collapse('show');
        $('#informe'+idDetalleAsignacion).val("GENERA");
    }
    else
    {
        $('#ctnObservacionValidacionDevolucion'+idDetalleAsignacion).collapse('hide');
        $('#ctnInformeRecepcionActivo'+idDetalleAsignacion).collapse('hide');
        $('#informe'+idDetalleAsignacion).val("NO");
    }
});

/* ------------------------------- */

$(document).on('submit', '.formularioValidarDevolucionActivo', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    var formData = new FormData(this);
    
    $('.statusInforme').each(function () 
    {
        var estado = $(this).val(); // "GENERA"
        if (estado !== 'GENERA') return;

        var idDetalle = $(this).data('id'); // Ej: 7901

        // === Imágenes ===
        var imgInput = document.querySelector('#fileImgEvaluacion' + idDetalle);
        
        if (imgInput) 
        {
            var pondImg = FilePond.find(imgInput);
            
            if (pondImg) 
            {
                var filesImg = pondImg.getFiles();
                
                filesImg.forEach(function (file) 
                {
                    formData.append('imagenesEvaluacion[' + idDetalle + '][]', file.file);
                });
            }
        }

        // === PDFs ===
        var pdfInput = document.querySelector('#fileDocEvaluacion' + idDetalle);
        
        if (pdfInput) 
        {
            var pondPdf = FilePond.find(pdfInput);
            
            if (pondPdf) 
            {
                var filesPdf = pondPdf.getFiles();
                
                filesPdf.forEach(function (file) 
                {
                    formData.append('pdfEvaluacion[' + idDetalle + '][]', file.file);
                });
            }
        }
    });
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES ACTA REPOSICIÓN */

/* ------------------------------- */

$(document).on('submit', '.formularioAdjuntarDocumentoReposicion', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondAdjuntoReposicion.getFiles();
    
    if (pondFiles.length === 0) {
        Swal.fire({
            text: "Debe adjuntar el archivo.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('itemsFile', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

$(document).on('click', '#btnEnviarCorreoReposicion', function(e) {
    var idReposicion = $(this).attr("data-id");
    
    var parametros = {
        "idReposicion"  : idReposicion
    };
    
    $.ajax({        
        url: baseUrl + '/enviar-correo-reposicion',
        type: "POST",
        data: parametros,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            $('.respuesta_global').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
});

/* ------------------------------- */

$(document).on('click', '#btnDescargarPDFActaReposicion', function(e) 
{
    var idReposicion    = $(this).attr("data-id");
    var codigo          = $(this).attr("data-cod");
    var accion          = $(this).attr("data-accion");
    
    Swal.fire({
        title: 'Un momento',
        text: 'Estamos procesando tu solicitud...',
        icon: 'info',
        showConfirmButton: false,
        allowOutsideClick: false,
        didOpen: () => {
            // Abrir la ventana emergente y no permitir cerrar mientras se procesa
            Swal.showLoading();
        }
    });
    
    window.location.href = baseUrl + '/verPDFActaReposicion/'+idReposicion+'/'+codigo+'/'+accion;
    
    setTimeout(function() {
        // Cuando el archivo empiece a descargarse, cierra el SweetAlert automáticamente
        Swal.close();
    }, 7000); 
});

/* ------------------------------- */

$(document).on('click', '#btnExcepcionReposicion', function(e) 
{
    var idReposicion    = $(this).attr("data-id");
    var modal           = $(this).data('bs-target');
    
    var parametros = {
        "idReposicion" : idReposicion
	};
    
    $.ajax({        
        url: baseUrl + '/mostrar-elementos-excepcion-reposicion',
        type: 'POST',
        data: parametros,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            $('#ctnExcepcionReposicion').html(response);
            
            $(modal).modal("show");
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
});

/* ------------------------------- */

$(document).on('change', '.rdbtnGenerarExcepcionReposicion', function() 
{
    let idDetalleReposicion = $(this).data("detalle-reposicion");
    
    if ($('#rdbtnGeneraExcepcion_exrep'+idDetalleReposicion).is(':checked')) 
    {
        $('#ctnGeneraExcepcionReposicion'+idDetalleReposicion).collapse('show');
    } 
    else if ($('#rdbtnNoGeneraExcepcion_exrep'+idDetalleReposicion).is(':checked')) 
    {
        $('#ctnGeneraExcepcionReposicion'+idDetalleReposicion).collapse('hide');
    }
});

/* ------------------------------- */

$(document).on('change', '.valorExcepcionReposicion', function() 
{
    let idDetalleReposicion = $(this).data("detalle-reposicion");
    const slider = document.getElementById("slideExcepcionReposicion" + idDetalleReposicion);
    
    let nuevoValor = parseFloat($(this).val());
    if (isNaN(nuevoValor)) return;

    // Obtener el rango permitido
    const min = slider.noUiSlider.options.range.min;
    const max = slider.noUiSlider.options.range.max;

    // Validar que esté dentro del rango
    if (nuevoValor < min || nuevoValor > max) 
    {
        Swal.fire({
            title: "Fuera de rango",
            text: "El valor debe estar entre " + min + " y " + max,
            icon: 'error',
            showCancelButton: false,
            confirmButtonColor: '#E4002B',
            confirmButtonText: 'Confirmar'
        });
        
        $(this).val("0").change();
        return;
    }

    // Actualiza el slider
    slider.noUiSlider.set(nuevoValor);
});

/* ------------------------------- */

$(document).on('submit', '.formularioExcepcionReposicion', function(event) 
{
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    // Validar si existe el input hidden con id txtNoItemsExcepcion dentro del formulario
    if (formulario.find('#txtNoItemsExcepcion').length > 0) 
    {
        Swal.fire({
            title: "No existen items",
            text: "No hay items para generar una excepción",
            icon: 'error',
            showCancelButton: false,
            confirmButtonColor: '#E4002B',
            confirmButtonText: 'Confirmar'
        });
        return; // detener el envío
    }
    
    let validacionExitosa = true; // Asumimos que todo está bien al inicio

    var formData = new FormData(this);
    
    $('.rdbtnGenerarExcepcionReposicion:checked').each(function () 
    {
        var estado = $(this).val(); // "GENERA"
        
        if (estado !== 'Y') return;

        var idDetalleReposicion = $(this).data('detalle-reposicion'); // Ej: 7901

        // === Correo Adjunto ===
        var correoInput = document.querySelector('#fileCorreoAutorizacionExcepcion' + idDetalleReposicion);
        console.log(correoInput);
        if (correoInput) 
        {
            var pondCorreo = FilePond.find(correoInput);
            
            if (pondCorreo) 
            {
                var filesCorreo = pondCorreo.getFiles();
                
                // Validar que al menos uno sea .msg o .eml
                var tieneCorreoOutlook = filesCorreo.some(function (file) 
                {
                    var nombre = file.file.name.toLowerCase();
                    return nombre.endsWith(".msg") || nombre.endsWith(".eml");
                });
    
                if (!tieneCorreoOutlook) 
                {
                    Swal.fire({
                        title: "No hay correo adjunto",
                        text: "Debe agregar el correo de aprobación de la excepción de los items que van a ser modificados",
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                    validacionExitosa = false;
                    return false; // Sale del .each
                }

                filesCorreo.forEach(function (file) 
                {
                    formData.append('correoExcepcion[' + idDetalleReposicion + '][]', file.file);
                });
            }
        }
    });
    console.log(validacionExitosa);
    // Si falló la validación, detén el proceso
    if (!validacionExitosa) 
    {
        return; // No continúes con el envío o procesamiento
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES DESCUENTOS REPOSICIÓN */

/* ------------------------------- */

function descargarDescuentosMensualPendiente()
{
    var mes = $("#MesDescuento").val();
    var anio = $("#AnioDescuento").val();
    window.open(baseUrl+"/exportar-descuento-mensual/"+mes+"/"+anio,'_blank');
}

/* ------------------------------- */

$(document).on('change', "input[name='txtImportarDescuentoCobrado']", function(e) 
{
    var myFile = $(this).prop('files')[0];
    
    var formData = new FormData();
    formData.append("file", myFile);
    
    $.ajax({        
        url: baseUrl+"/importar-descuento-mensual",
        type: "POST",
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() 
        {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) 
        {
            Swal.close();
            $('.respuesta_global').html(response);
        }, 
        error: function(jqXHR, textStatus, errorThrown)
        {
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    return false;
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES INFORME DEVOLUCIÓN */

/* ------------------------------- */

$(document).on('click', '#btnDescargarPDFInformeDevolucion', function(e) 
{
    var idInforme   = $(this).attr("data-id");
    var codigo      = $(this).attr("data-cod");
    var accion      = $(this).attr("data-accion");
    
    Swal.fire({
        title: 'Un momento',
        text: 'Estamos procesando tu solicitud...',
        icon: 'info',
        showConfirmButton: false,
        allowOutsideClick: false,
        didOpen: () => {
            // Abrir la ventana emergente y no permitir cerrar mientras se procesa
            Swal.showLoading();
        }
    });
    
    window.location.href = baseUrl + '/verPDFInformeDevolucion/'+idInforme+'/'+codigo+'/'+accion;
    
    setTimeout(function() {
        // Cuando el archivo empiece a descargarse, cierra el SweetAlert automáticamente
        Swal.close();
    }, 7000); 
});

/* ------------------------------- */

/* ------------------------------- */

/* ------------------------------- */

/* ------------------------------- */

/* ------------------------------- */

/* ------------------------------- */

/* ------------------------------- */

/* ------------------------------- */

/* ------------------------------- */

/* ------------------------------- */

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES INFORMACIÓN LEGAL */

/* ------------------------------- */

$(document).on('click', '.datos-informacion-legal', function(e) 
{
    var idInformacionLegal  = $(this).data('id');
    var accion              = $(this).data('accion');
    var formulario          = $(this).data('form');
    var modal               = $(this).data('bs-target');
    
    $('#btnEjecutarInfoLegal').addClass("d-none");
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' input[type=checkbox]').attr("disabled","disabled");
    $(formulario + ' select').attr("disabled","disabled");
              
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' input[type=checkbox]').prop("checked",false);
    $(formulario + ' select').val("");
    $(formulario + ' #txtPrevisualizacionTextoLegal_i').empty();
    
    destroy_editor("#txtTextoLegal_i");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
            
    if(accion == 'crear')
    {
        Swal.close();
        
        $('#exampleinformacionLegal').text("Registrar nueva información legal");
        $('#formInformacionLegal').attr('action', baseUrl + '/registrar-informacion-legal');
        $('#btnEjecutarInfoLegal').removeClass("d-none");
        $('#btnEjecutarInfoLegal').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Guardar');
        
        quillTextoLegal = new Quill('#txtTextoLegal_i', {
          modules: {
            toolbar: [
              ['bold', 'italic'],
              ['link', 'blockquote', 'code-block'],
              [{ list: 'ordered' }, { list: 'bullet' }],
            ],
          },
          theme: 'snow',
        });
        quillTextoLegal.setContents(initialDataQuill.about);
        
        $(formulario + ' input[type=text]').removeAttr("disabled");
        $(formulario + ' input[type=checkbox]').removeAttr("disabled");
        $(formulario + ' select').removeAttr("disabled");
        
        $(modal).modal("show");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-informacion-legal', 
        {         
            idInformacionLegal : idInformacionLegal
        }, 
        function(response) 
        {
            Swal.close();
            
            if (response.sesion === 0) 
            {
                Swal.fire({
                    title: 'Por favor, vuelva a iniciar sesión.',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionLegal').text("Ver información legal");
                    $('#btnEjecutarInfoLegal').addClass("d-none");
                    $('#formInformacionLegal').attr('action', '');
                    
                    quillTextoLegal = new Quill('#txtTextoLegal_i', {
                        readOnly: true,
                        modules: {
                            toolbar: [
                                ['bold', 'italic'],
                                ['link', 'blockquote', 'code-block'],
                                [{ list: 'ordered' }, { list: 'bullet' }],
                            ],
                        },
                        theme: 'snow',
                    });

                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' input[type=checkbox]').attr("disabled","disabled");
                    $(formulario + ' select').attr("disabled","disabled");
    
                }
                else
                {
                    $('#exampleinformacionLegal').text("Actualizar información legal");
                    $('#formInformacionLegal').attr('action', baseUrl + '/actualizar-informacion-legal/' + idInformacionLegal);
                    $('#btnEjecutarInfoLegal').removeClass("d-none");

                    quillTextoLegal = new Quill('#txtTextoLegal_i', {
                        modules: {
                            toolbar: [
                                ['bold', 'italic'],
                                ['link', 'blockquote', 'code-block'],
                                [{ list: 'ordered' }, { list: 'bullet' }],
                            ],
                        },
                        theme: 'snow',
                    });

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' input[type=checkbox]').removeAttr("disabled");
                    $(formulario + ' select').removeAttr("disabled");
                    
                }
                
                let arrayElementos = response.elementos.split('|');
                
                quillTextoLegal.setContents([
                    {
                    insert: response.texto
                    }
                ]);
                
                $('#txtIDLegal_i').val(response.idlegal);
                $('#txtTituloLegal_i').val(response.titulo);
                $('#txtActaAsociada_i').val(response.acta).trigger('change');
                $(formulario + ' #txtPrevisualizacionTextoLegal_i').html(response.texto);
                arrayElementos.forEach(function(valor) {
                    $(".form-check-input[value='" + valor + "']").prop("checked", true);
                });
                
                $(modal).modal("show");
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES SOLICITUD REPOSICIÓN */

/* ------------------------------- */

function agregarItemReposicion()
{
    var idItem = $("#txtItemReposicion").val();
    var idUsuario = $("#txtAdjudicadoReposicion").val();
    var situacion = $("#txtMotivoReposicion").val();
    
    var elementosSeleccionados = [];
    $(document).find("input[name='itemReposicion[]']").each(function() {
        elementosSeleccionados.push($(this).val());
    });
    
    if(elementosSeleccionados.includes(idItem))
    {
        Swal.fire({
            html: 'No puede seleccionar el mismo item 2 veces',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(idItem == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el item a reponer',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(idUsuario == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el usuario adjudicado',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else if(situacion == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el motivo de la reposición',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        var parametros = {
            "idItem"    : idItem,
            "idUsuario" : idUsuario,
            "situacion" : situacion
    	};
    	
        $.ajax({        
            url: baseUrl + '/obtener-elemento-a-reponer',
            type: "POST",
            data: parametros,
            beforeSend: function() {
                Swal.fire({
                    html: 'Un momento por favor...',
                    heightAuto: true,
                    showConfirmButton: false
                });
            },
            success: function(response) {
                Swal.close();
                $('#ctnElementosReposicion').append(response);
                $("#txtItemReposicion").val("").trigger('change');
            }, 
            error: function(jqXHR, textStatus, errorThrown){
                
                Swal.close();
                
                Swal.fire({
                    title: 'Ha ocurrido un error interno',
                    text: errorThrown,
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#E4002B',
                    confirmButtonText: 'Confirmar'
                });
            }
        });
    }
}

/* ------------------------------- */

$(document).on('click', '#btnFinalizarEvaluacionReposicion', function(e) 
{
    var modal = $(this).data('bs-target');
    
    $(modal + ' #txtDescargoEvaluacion_i').val("");
    $(modal + ' #chkGeneraReposicion_i').prop('checked', true);
    $(modal + ' #ctnCobroReposicionInformacion').removeClass("d-none");
    $(modal + ' #txtMotivoReposicionReal').val('').trigger('change');
    $(modal + ' input[type="radio"].chkTipoDescuentoReposicion[value="TOTAL"]').prop('checked', true);
    $(modal + ' #txtMontoParcialReposicion').val("1");
    $(modal + ' #txtMontoParcialReposicion').attr("disabled", "disabled");
    
    $(modal + ' #ctnElementosDevolucion').empty();
    
    $(modal).modal("show");
});

/* ------------------------------- */

function confirmarEstadoSolicitudReposicion(idSolicitudReposicion, estado)
{
    var mensaje = "";
    
    if(estado == 'INIC')
    {
        mensaje = '¿Todo listo para comenzar iniciar la evaluación?[INICIADO]';
    }
    else if(estado == 'RECI')
    {
        mensaje = '¿Recibiste el elemento?[RECIBIDO]';
    }
    else if(estado == 'COMP')
    {
        mensaje = '¿Deseas terminar la evaluación?[COMPLETADO]';
    }
    
    Swal.fire({
        title: mensaje,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // // Si el valor es válido, debes regresar undefined. Si no, una cadena
            // if (!obs) {
            //     return "Por favor escribe el motivo";
            // } else {
            //     return undefined;
            // }
        }
    }).then((result) => {
        if (result.isConfirmed) {

            var motivo = result.value;
            var parametros = {
                "txtEstadoSolicitudReposicion_i" : estado,
                "txtDescargoEvaluacion_i" : motivo,
                "chkGeneraReposicion_i" : ""
    		};
            $.ajax({        
                url: baseUrl + '/cambio-estado-solicitud-reposicion/'+idSolicitudReposicion,
                type: "POST",
                data: parametros,
                success: function(response) {
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    Swal.close();
                
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
}

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES KIT DE TRABAJO */

/* ------------------------------- */

$(document).on('click', '#btnNuevoKitTrabajo', function(e) 
{
    
    var formulario = $(this).data('form');
    var modal = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').val("");
    selectElementoTrabajo('cboElementoTrabajoKit', '', modal.substring(1));
    $("#ctnNuevosElementosKitTrabajo").empty();
    
    $(modal).modal("show");
});

/* ------------------------------- */

function agregarElementoTrabajoKit()
{
    var idElementoTrabajo = $("#cboElementoTrabajoKit").val();
    
    if(idElementoTrabajo == '')
    {
        Swal.fire({
            html: 'Debe seleccionar un ELEMENTO para agregarlo al formulario.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
        {
        var parametros = {
            "idElementoTrabajo"  : idElementoTrabajo
    	};
    
        $.ajax({
            url: baseUrl + '/obtener-nuevo-item-kit-trabajo',
            type: "POST",
            data: parametros,
            beforeSend: function() {
                Swal.fire({
                    html: 'Un momento por favor...',
                    heightAuto: true,
                    showConfirmButton: false
                });
            },
            success: function(response) {
                Swal.close();
                $('#ctnNuevosElementosKitTrabajo').append(response);
            }, 
            error: function(jqXHR, textStatus, errorThrown){
                Swal.close();
            
                Swal.fire({
                    title: 'Ha ocurrido un error interno',
                    text: errorThrown,
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#E4002B',
                    confirmButtonText: 'Confirmar'
                });
            }
        });
    }
};

/* ------------------------------- */

$(document).on('click', '#btnAgregarElementoKitTrabajo', function(e) 
{
    var idElementoTrabajo = $("#cboElementoTrabajo_kte").val();
    var idKitTrabajo = $(this).data("kit");
    
    var textElemento = $("#cboElementoTrabajo_kte").select2('data')[0]['text'].split("|");

    var elemento = textElemento[1];
    var sku = textElemento[0];

    if(idElementoTrabajo == '')
    {
        Swal.fire({
            html: 'Debe seleccionar el elemento a asociar.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
    {
        Swal.fire({
            title: '¿Estas seguro que deseas asociar el elemento '+elemento+' de SKU '+sku+' al Kit de Trabajo?',
            //text: "Recuerda que esta acción es permanente.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#282e38',
            cancelButtonColor: '#f35d5d',
            confirmButtonText: 'Confirmar'
        }).then((result) => {
            if (result.isConfirmed) {
                
                var parametros = {
                    "idElementoTrabajo" : idElementoTrabajo,
                    "idKitTrabajo"      : idKitTrabajo
        		};
                $.ajax({        
                    url: baseUrl + '/asociar-elemento-kit-trabajo',
                    type: "POST",
                    data: parametros,
                    beforeSend: function() {
                        Swal.fire({
                            html: 'Un momento por favor...',
                            heightAuto: true,
                            showConfirmButton: false
                        });
                    },
                    success: function(response) {
                        Swal.close();
                        $('.respuesta_global').html(response);
                    }, 
                    error: function(jqXHR, textStatus, errorThrown){
                        Swal.close();
            
                        Swal.fire({
                            title: 'Ha ocurrido un error interno',
                            text: errorThrown,
                            icon: 'error',
                            showCancelButton: false,
                            confirmButtonColor: '#E4002B',
                            confirmButtonText: 'Confirmar'
                        });
                    }
                });
            }
        });
    }
});

/* ------------------------------- */

$(document).on('click', '.eliminar-elemento-kit-trabajo', function() 
{
    var idElementoTrabajo   = $(this).data("elemento");
    var idKitTrabajo        = $(this).data("kit");
    
    Swal.fire({
        title: '¿Estas seguro que deseas eliminar el elemento del kit de trabajo?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar'
    }).then((result) => {
        if (result.isConfirmed) {
            
            var parametros = {
                "idElementoTrabajo" : idElementoTrabajo,
                "idKitTrabajo"      : idKitTrabajo
    		};
            $.ajax({        
                url: baseUrl + '/eliminar-elemento-kit-trabajo',
                type: "POST",
                data: parametros,
                beforeSend: function() {
                    Swal.fire({
                        html: 'Un momento por favor...',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                },
                success: function(response) {
                    Swal.close();
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown){
                    Swal.close();
            
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES KIT DEMO */

/* ------------------------------- */

$(document).on('click', '#btnNuevoKitDemo', function(e) {
    
    var formulario = $(this).data('bs-target');
    
    $(formulario + ' input[type=text]').val("");
    selectElementoDemo('cboElementoDemoKit', '', formulario.substring(1));
    $("#ctnNuevosElementosKitDemo").empty();
    
});

/* ------------------------------- */

$(document).on('click', '.datos-item-demo', function(e) {
    $('#btnEjecutarItemKitDemo').addClass("d-none");
    var idItemKitDemo = $(this).data('id');
    var accion = $(this).data('accion');
    var modal = $(this).data('bs-target');
    var formulario = $(this).data('form');
    //var formulario=$(this).closest('form').attr("id");
    
    $(formulario + ' input[type=text]').attr("disabled","disabled");
    $(formulario + ' input[type=date]').attr("disabled","disabled");
    $(formulario + ' textarea').attr("disabled","disabled");
    
    $(formulario + ' input[type=text]').val("");
    $(formulario + ' input[type=date]').val("");
    $(formulario + ' textarea').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
            
    if(accion == 'crear')
    {
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-item-kit-demo', 
        {         
            idItemKitDemo : idItemKitDemo
        }, 
        function(response) {
            Swal.close();
            if (response.descripcion === 0) {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } else {
                
                if(accion == 'ver')
                {
                    $('#exampleinformacionItemDemo').text("Ver información del item de kit demo");
                    $('#btnEjecutarItemKitDemo').addClass("d-none");
                    $('#formInformacionItemDemo').attr('action', '');

                    $(formulario + ' input[type=text]').attr("disabled","disabled");
                    $(formulario + ' input[type=date]').attr("disabled","disabled");
                    $(formulario + ' textarea').attr("disabled","disabled");
    
                }
                else
                {
                    $('#exampleinformacionItemDemo').text("Actualizar item de kit demo");
                    $('#formInformacionItemDemo').attr('action', baseUrl + '/actualizar-item-kit-demo/' + idItemKitDemo);
                    $('#btnEjecutarItemKitDemo').removeClass("d-none");

                    $(formulario + ' input[type=text]').removeAttr("disabled");
                    $(formulario + ' input[type=date]').removeAttr("disabled");
                    $(formulario + ' textarea').removeAttr("disabled");
                    
                    $('#txtSKUItemDemo_i').attr("disabled","disabled");
                    $('#txtNombreItemDemo_i').attr("disabled","disabled");
                }

                $('#txtIDItemKitDemo_i').val(response.iditemkitdemo);
                $('#txtCodigoKitDemo_i').val(response.codigo);
                $('#txtSKUItemDemo_i').val(response.sku);
                $('#txtNombreItemDemo_i').val(response.elemento);
                $('#txtSerieItemDemo_i').val(response.serie);
                $('#txtFechaCompraItemDemo_i').val(response.fechacompra);
                $('#txtDetalleItemDemo_i').val(response.detalle);
                
                $(modal).modal("show");
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

function agregarElementoDemoKit(){
    var idElementoDemo = $("#cboElementoDemoKit").val();
    
    if(idElementoDemo == '')
    {
        Swal.fire({
            html: 'Debe seleccionar un ELEMENTO para agregarlo al formulario.',
            heightAuto: true,
            showConfirmButton: true
        });
    }
    else
        {
        var parametros = {
            "idElementoDemo"  : idElementoDemo
    	};
    
        $.ajax({
            url: baseUrl + '/obtener-nuevo-item-kit-demo',
            type: "POST",
            data: parametros,
            beforeSend: function() {
                Swal.fire({
                    html: 'Un momento por favor...',
                    heightAuto: true,
                    showConfirmButton: false
                });
            },
            success: function(response) {
                Swal.close();
                $('#ctnNuevosElementosKitDemo').append(response);
            }, 
            error: function(jqXHR, textStatus, errorThrown){
                //$.unblockUI({});
                Swal.close();
                alert('Ha ocurrido un error interno.');
                console.log(jqXHR );
                console.log(textStatus);
                console.log(errorThrown);
            }
        });
    }
};

/* ------------------------------- */

$(document).on('submit', '.formularioImportarCSVKitsDemo', function(event) {
    event.preventDefault();
    var formulario = $(this);
    var metodoEnvio = formulario.attr('method');
    var idForm = formulario.attr('id');
    
    const pondFiles = pondImportarCSVKitDemo.getFiles();
    
    if (pondFiles.length === 0) {
        Swal.fire({
            text: "Debe adjuntar la plantilla a subir.",
            icon: 'warning',
            showCancelButton: false,
            cancelButtonText: 'No',
            confirmButtonColor: '#282e38',
            confirmButtonText: 'OK'
        });
        return false;
    }
    var formData = new FormData(this);
    
    for (var i = 0; i < pondFiles.length; i++) {
        formData.append('itemsFile', pondFiles[i].file);
    }
    
    $.ajax({        
        url: formulario.attr('action'),
        type: metodoEnvio,
        data: formulario.serialize(),
        data: formData,
        contentType: false,
        cache: false,
        processData: false,
        beforeSend: function() {
            Swal.fire({
                html: 'Un momento por favor...',
                heightAuto: true,
                showConfirmButton: false
            });
        },
        success: function(response) {
            Swal.close();
            
            formulario.find('.respuesta').html(response);
            
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
    
    return false;
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES REPORTES */

/* ------------------------------- */

$(document).on('click', '#btnExportarTotalCesados', function(e) {
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    window.open(baseUrl+"/exportar-asignados-cesados/",'_blank');
    
    Swal.close();
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES CATEGORÍAS */

/* ------------------------------- */

$(document).on('click', '.datos-categoria', function(e) 
{
    var idCategoria = $(this).data('id');
    var accion      = $(this).data('accion');    
    var modal       = $(this).data('bs-target');
    
    $('#btnEjecutarCategoria').addClass("d-none");
    
    $('#txtNombreCategoria_i').attr("disabled","disabled");
    $('#txtClaveCategoria_i').attr("disabled","disabled");
    $('#txtObservacionCategoria_i').attr("disabled","disabled");
    
    $('#txtNombreCategoria_i').val("");
    $('#txtClaveCategoria_i').val("");
    $('#txtObservacionCategoria_i').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == 'crear')
    {
        Swal.close();
        
        $('#exampleinformacionCategoria').text("Registrar categoría");
        $('#formInformacionCategoria').attr('action', baseUrl + '/registrar-categoria');
        $('#btnEjecutarCategoria').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Guardar');
        $('#btnEjecutarCategoria').removeClass("d-none");

        $('#txtNombreCategoria_i').removeAttr("disabled");
        $('#txtClaveCategoria_i').removeAttr("disabled");
        $('#txtObservacionCategoria_i').removeAttr("disabled");
        
        $('#txtNombreCategoria_i').focus();
        
        $(modal).modal("show");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-categoria', 
        {         
            idCategoria : idCategoria
        }, 
        function(response) 
        {
            Swal.close();
        
            if (response.sesion === 0) 
            {
                Swal.fire({
                    title: 'Por favor, vuelva a iniciar sesión.',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionCategoria').text("Información del categoria");
                    $('#btnEjecutarCategoria').addClass("d-none");
                    $('#formInformacionCategoria').attr('action', '');

                    $('#txtNombreCategoria_i').attr("disabled","disabled");
                    $('#txtClaveCategoria_i').attr("disabled","disabled");
                    $('#txtObservacionCategoria_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionCategoria').text("Actualizar categoria");
                    $('#formInformacionCategoria').attr('action', baseUrl + '/actualizar-categoria/' + idCategoria);
                    $('#btnEjecutarCategoria').removeClass("d-none");

                    $('#txtNombreCategoria_i').removeAttr("disabled");
                    $('#txtClaveCategoria_i').removeAttr("disabled");
                    $('#txtObservacionCategoria_i').removeAttr("disabled");
                    
                }

                $('#txtNombreCategoria_i').val(response.categoria);
                $('#txtClaveCategoria_i').val(response.clave);
                $('#txtObservacionCategoria_i').val(response.observacion);
                
                $(modal).modal("show");
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-categoria', function() 
{
    var idCategoria = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' la categoria?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idCategoria"   : idCategoria,
                "estado"        : estado,
                "motivo"        : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-categoria',
                type: "POST",
                data: parametros,
                beforeSend: function() 
                {
                    Swal.fire({
                        html: 'Un momento por favor...',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                },
                success: function(response) 
                {
                    Swal.close();
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown)
                {
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES TIPOS CATEGORÍA */

/* ------------------------------- */

$(document).on('click', '.datos-tipo-categoria', function(e) 
{
    var idTipo  = $(this).data('id');
    var accion  = $(this).data('accion');
    var modal   = $(this).data('bs-target');
    
    $('#btnEjecutarTipoCategoria').addClass("d-none");
    
    $('#txtNombreTipoCategoria_i').attr("disabled","disabled");
    $('#txtObservacionTipoCategoria_i').attr("disabled","disabled");
    
    $('#txtNombreTipoCategoria_i').val("");
    $('#txtObservacionTipoCategoria_i').val("");
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == 'crear')
    {
        Swal.close();
        
        $('#exampleinformacionTipoCategoria').text("Registrar tipo de categoría");
        $('#formInformacionTipoCategoria').attr('action', baseUrl + '/registrar-tipo-categoria');
        $('#btnEjecutarTipoCategoria').removeClass("d-none");
        $('#btnEjecutarTipoCategoria').html('<i class="mdi mdi-content-save mx-1 color-white" style="font-size: 14px;"></i> Guardar');

        $('#txtNombreTipoCategoria_i').removeAttr("disabled");
        $('#txtObservacionTipoCategoria_i').removeAttr("disabled");
        
        $('#txtNombreTipoCategoria_i').focus();
        
        $(modal).modal("show");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-tipo-categoria', 
        {         
            idTipo : idTipo
        }, 
        function(response) 
        {
            Swal.close();
        
            if (response.sesion === 0) 
            {
                Swal.fire({
                    title: 'Por favor, vuelva a iniciar sesión.',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionTipoCategoria').text("Información del tipo de categoria");
                    $('#btnEjecutarTipoCategoria').addClass("d-none");
                    $('#formInformacionTipoCategoria').attr('action', '');

                    $('#txtNombreTipoCategoria_i').attr("disabled","disabled");
                    $('#txtObservacionTipoCategoria_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionTipoCategoria').text("Actualizar el tipo de categoria");
                    $('#formInformacionTipoCategoria').attr('action', baseUrl + '/actualizar-tipo-categoria/' + idTipo);
                    $('#btnEjecutarTipoCategoria').removeClass("d-none");

                    $('#txtNombreTipoCategoria_i').removeAttr("disabled");
                    $('#txtObservacionTipoCategoria_i').removeAttr("disabled");
                }

                $('#txtNombreTipoCategoria_i').val(response.tipo);
                $('#txtObservacionTipoCategoria_i').val(response.observacion);
                
                $(modal).modal("show");
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-tipo-categoria', function() 
{
    var idTipo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el tipo de categoria?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idTipo"    : idTipo,
                "estado"    : estado,
                "motivo"    : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-tipo-categoria',
                type: "POST",
                data: parametros,
                beforeSend: function() 
                {
                    Swal.fire({
                        html: 'Un momento por favor...',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                },
                success: function(response) 
                {
                    Swal.close();
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown)
                {
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES SUBTIPOS CATEGORÍA */

/* ------------------------------- */

$(document).on('click', '.datos-subtipo-tipo-categoria', function(e) 
{
    var idSubtipo   = $(this).data('id');
    var accion      = $(this).data('accion');
    var modal       = $(this).data('bs-target');
    
    $('#btnEjecutarSubtipoCategoria').addClass("d-none");
    
    $('#txtNombreSubtipoCategoria_i').attr("disabled","disabled");
    $('#txtObservacionSubtipoCategoria_i').attr("disabled","disabled");
    $('#chkSubtipoHabilitadoNavision_i').attr("disabled","disabled");

    $('#txtNombreSubtipoCategoria_i').val("");
    $('#txtObservacionSubtipoCategoria_i').val("");
    $('#chkSubtipoHabilitadoNavision_i').prop("checked",false);
    
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
          
    if(accion == 'crear')
    {
        Swal.close();
        
        $('#exampleinformacionSubtipoCategoria').text("Registrar subtipo de categoría");
        $('#formInformacionSubtipoCategoria').attr('action', baseUrl + '/registrar-subtipo-tipo');
        $('#btnEjecutarSubtipoCategoria').removeClass("d-none");
        $('#btnEjecutarSubtipoCategoria').html('<i class="mdi mdi-content-save"></i> Guardar');

        $('#txtNombreSubtipoCategoria_i').removeAttr("disabled");
        $('#txtObservacionSubtipoCategoria_i').removeAttr("disabled");
        $('#chkSubtipoHabilitadoNavision_i').removeAttr("disabled");
        
        $('#txtNombreSubtipoCategoria_i').focus();
        
        $(modal).modal("show");
    }
    else
    {
        $.post(baseUrl + '/obtener-datos-subtipo-tipo', 
        {         
            idSubtipo : idSubtipo
        }, 
        function(response) 
        {
            Swal.close();
        
            if (response.sesion === 0) 
            {
                Swal.fire({
                    title: 'Por favor, vuelva a iniciar sesión.',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else if (response.descripcion === 0) 
            {
                Swal.fire({
                    title: 'No se encontró la información solicitada',
                    icon: 'warning',
                    showCancelButton: false,
                    confirmButtonColor: '#282E38',
                    confirmButtonText: 'Confirmar'
                });
            } 
            else 
            {
                if(accion == 'ver')
                {
                    $('#exampleinformacionSubtipoCategoria').text("Información del subtipo de categoría");
                    $('#btnEjecutarSubtipoCategoria').addClass("d-none");
                    $('#formInformacionSubtipoCategoria').attr('action', '');

                    $('#txtNombreSubtipoCategoria_i').attr("disabled","disabled");
                    $('#txtObservacionSubtipoCategoria_i').attr("disabled","disabled");
                    $('#chkSubtipoHabilitadoNavision_i').attr("disabled","disabled");
                }
                else
                {
                    $('#exampleinformacionSubtipoCategoria').text("Actualizar el subtipo de categoría");
                    $('#formInformacionSubtipoCategoria').attr('action', baseUrl + '/actualizar-subtipo-tipo/' + idSubtipo);
                    $('#btnEjecutarSubtipoCategoria').removeClass("d-none");

                    $('#txtNombreSubtipoCategoria_i').removeAttr("disabled");
                    $('#txtObservacionSubtipoCategoria_i').removeAttr("disabled");
                    $('#chkSubtipoHabilitadoNavision_i').removeAttr("disabled");
                }

                $('#txtNombreSubtipoCategoria_i').val(response.subtipo);
                $('#txtObservacionSubtipoCategoria_i').val(response.observacion);
                
                if(response.navision == "Y")
                {
                    $("#chkSubtipoHabilitadoNavision_i").prop("checked", true);
                }
                else
                {
                    $("#chkSubtipoHabilitadoNavision_i").prop("checked", false);
                }
                
                $(modal).modal("show");
            }
        }, 'json'); 
    }
});

/* ------------------------------- */

$(document).on('click', '.cambiar-estado-subtipo-tipo-categoria', function() 
{
    var idSubtipo = $(this).data("id");
    var estado = $(this).data("estado");
    
    if(estado == "A")
    {
        var msgEstado = 'DESACTIVAR';
        var estado = 'I';
    }
    else
    {
        var msgEstado = 'ACTIVAR';
        var estado = 'A';
    }

    Swal.fire({
        title: '¿Estas seguro que deseas '+msgEstado+' el subtipo de categoria?',
        //text: "Recuerda que esta acción es permanente.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#282e38',
        cancelButtonColor: '#f35d5d',
        confirmButtonText: 'Confirmar',
        input: 'textarea',
        inputAttributes: {
            autocapitalize: 'on'
        },
        inputValidator: obs => {
            // Si el valor es válido, debes regresar undefined. Si no, una cadena
            if (!obs) {
                return "Por favor escribe el motivo";
            } else {
                return undefined;
            }
        }
    }).then((result) => {
        if (result.isConfirmed) {
            
            var motivo = result.value;
            
            var parametros = {
                "idSubtipo" : idSubtipo,
                "estado"    : estado,
                "motivo"    : motivo
    		};
            $.ajax({        
                url: baseUrl + '/cambiar-estado-subtipo-tipo',
                type: "POST",
                data: parametros,
                beforeSend: function() 
                {
                    Swal.fire({
                        html: 'Un momento por favor...',
                        heightAuto: true,
                        showConfirmButton: false
                    });
                },
                success: function(response) 
                {
                    Swal.close();
                    $('.respuesta_global').html(response);
                }, 
                error: function(jqXHR, textStatus, errorThrown)
                {
                    Swal.close();
                    
                    Swal.fire({
                        title: 'Ha ocurrido un error interno',
                        text: errorThrown,
                        icon: 'error',
                        showCancelButton: false,
                        confirmButtonColor: '#E4002B',
                        confirmButtonText: 'Confirmar'
                    });
                }
            });
        }
    });

    return false;
    
});

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES DASHBOARD */

/* ------------------------------- */

function recargarGraficaAsignacionPendienteFirmaCreacion()
{
    let inicioGrafico   = $("#dtInicioAsignacionPendientesFirmaCreacionIT").val();
    let finalGrafico    = $("#dtFinalAsignacionPendientesFirmaCreacionIT").val();
    var activosGrafico = [];
    
    $('.chkActivosDashboard:checked').each(function() {
        activosGrafico.push($(this).val());
    });
    
    var parametros = {
        "inicioGrafico" : inicioGrafico,
        "finalGrafico"  : finalGrafico,
        "activosGrafico": activosGrafico
	};
	
	$.ajax({        
        url: baseUrl + '/grafica-asignacion-pendiente-firma-creacion',
        type: "POST",
        data: parametros,
        dataType: 'json',
        success: function(response) 
        {
            crearGraficaAsignacionPendienteFirmaCreacion(response, "cnvAsignacionPendienteFirmaCreacionIT");
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            //$.unblockUI({});
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
}

/* ------------------------------- */

function crearGraficaAsignacionPendienteFirmaCreacion(data, elemento) 
{
    let ctx = document.getElementById(elemento);
    
    // Si ya se creó la gráfica
    if(graficaAsignacionPendienteFirmaCreacion !== null) {
        // Destruir para poder crear nuevamente
        graficaAsignacionPendienteFirmaCreacion.destroy();
    }
    
    // Mapear los datos del eje X (fechas) y eje Y (totales)
    const labels = data.map(item => item.FechaCreacion);
    const valores = data.map(item => parseInt(item.TotalPendiente));

    // Crear la gráfica
    graficaAsignacionPendienteFirmaCreacion = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Total Pendiente',
                data: valores,
                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                borderColor: 'rgba(75, 192, 192, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false, // Esto evita conflictos de tamaño al redimensionar
            animation: {
                duration: 1000, // Elimina animaciones al redimensionar
            },
            resizeDelay: 300, // <-- Muy importante para evitar el bucle en redimensionamiento
            plugins: {
                legend: {
                    display: true,
                    position: 'top'
                },
                datalabels: {
                    anchor: 'end',
                    align: 'start',
                    color: '#000',
                    font: {
                        weight: 'bold',
                        size: 14 // Aumenta este valor según necesidad
                    },
                    formatter: function(value) {
                        return value;
                    }
                }
            },
            scales: {
                x: {
                    title: {
                        display: true,
                        text: 'Fecha de Creación'
                    }
                },
                y: {
                    beginAtZero: true,
                    title: {
                        display: true,
                        text: 'Total Pendiente'
                    }
                }
            },
            onClick: function (evt, elements) {
                if (elements.length > 0) {
                    const index = elements[0].index;
                    const fechaSeleccionada = labels[index];
                    recargarTablaDetalleAsignacionPendienteFirmaCreacion(fechaSeleccionada);
                    recargarGraficaDetalleAsignacionPendienteFirmaCreacion(fechaSeleccionada);
                    
                    $("#mdlDetalleFechaAsignacionPendienteFirmaCreacion").modal("show");
                    // abrirModalConDetalle(fechaSeleccionada);
                }
            }
        }
    });
}

/* ------------------------------- */

$(document).on('change', '#chkFiltroAsignacionPendientesFirmaCreacion', function() 
{
    if ($(this).is(':checked')) 
    {
        $('#ctnFiltrosAsignacionPendientesFirmaCreacion').collapse('show');
    } 
    else
    {
        $('#ctnFiltrosAsignacionPendientesFirmaCreacion').collapse('hide');
    }
});

/* ------------------------------- */

function recargarTablaDetalleAsignacionPendienteFirmaCreacion(fechaSeleccionada)
{
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    var activosGrafico = [];
    
    $('.chkActivosDashboard:checked').each(function() {
        activosGrafico.push($(this).val());
    });
    
    $('#tblDetalleFechaAsignacionPendienteFirmaCreacion').DataTable().destroy();
    
    $("#tblDetalleFechaAsignacionPendienteFirmaCreacion").DataTable({
        "ajax": {
            "url": baseUrl + "/recargar-detalle-asignacion-pendiente-firma-creacion",
            "type": "POST",
            "data": {
                "fechaSeleccionada"  : fechaSeleccionada,
                "activosGrafico"     : activosGrafico
            },
            "dataSrc": function (json) 
            {
                Swal.close();
                
                if(json.sesion === 0)
                {
                    Swal.fire({
                        title: 'Por favor, vuelva a iniciar sesión.',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonColor: '#282E38',
                        confirmButtonText: 'Confirmar'
                    });
                }
                
                return json.data;
            },
            "error": function (xhr, error, thrown) 
            {
                Swal.close();
            
                Swal.fire({
                    title: 'Ha ocurrido un error interno',
                    text: thrown.message,
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#E4002B',
                    confirmButtonText: 'Confirmar'
                });
            }
        },
        columnDefs: [
            { className: "text-center align-middle", targets: "_all" }
        ],
        columns: [
           { data: 'id_asignacion' },
           { data: 'fecha_asignacion' },
           { data: 'asignado' },
           { data: 'matricula' },
           { data: 'CC' },
           { data: 'dispositivos' },
           { data: 'acciones' }
        ]
    });
    
}

/* ------------------------------- */

function recargarGraficaDetalleAsignacionPendienteFirmaCreacion(fechaSeleccionada)
{
    let fechaGrafico    = fechaSeleccionada;
    var activosGrafico = [];
    
    $('.chkActivosDashboard:checked').each(function() {
        activosGrafico.push($(this).val());
    });
    
    var parametros = {
        "fechaGrafico"  : fechaGrafico,
        "activosGrafico": activosGrafico
	};
	
	$.ajax({        
        url: baseUrl + '/grafica-detalle-asignacion-pendiente-firma-creacion',
        type: "POST",
        data: parametros,
        dataType: 'json',
        success: function(response) 
        {
            crearGraficaDetalleAsignacionPendienteFirmaCreacion(response, "cnvDetalleFechaAsignacionPendienteFirmaCreacion");
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            //$.unblockUI({});
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
}

/* ------------------------------- */

function crearGraficaDetalleAsignacionPendienteFirmaCreacion(data, elemento) 
{
    let ctx = document.getElementById(elemento);
    
    // Si ya se creó la gráfica
    if(graficaDetalleAsignacionPendienteFirmaCreacion !== null) {
        // Destruir para poder crear nuevamente
        graficaDetalleAsignacionPendienteFirmaCreacion.destroy();
    }
    
    // Mapear los datos del eje X (fechas) y eje Y (totales)
    const labels = data.map(item => item.CCAsignado);
    const valores = data.map(item => parseInt(item.TotalPendiente));

    // Crear la gráfica
    graficaDetalleAsignacionPendienteFirmaCreacion = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Total Pendiente',
                data: valores,
                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                borderColor: 'rgba(75, 192, 192, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false, // Esto evita conflictos de tamaño al redimensionar
            animation: {
                duration: 1000, // Elimina animaciones al redimensionar
            },
            resizeDelay: 300, // <-- Muy importante para evitar el bucle en redimensionamiento
            plugins: {
                legend: {
                    display: true,
                    position: 'top'
                },
                datalabels: {
                    anchor: 'end',
                    align: 'start',
                    color: '#000',
                    font: {
                        weight: 'bold',
                        size: 14 // Aumenta este valor según necesidad
                    },
                    formatter: function(value) {
                        return value;
                    }
                }
            },
            scales: {
                x: {
                    title: {
                        display: true,
                        text: 'Delegaciones'
                    }
                },
                y: {
                    beginAtZero: true,
                    title: {
                        display: true,
                        text: 'Total Pendiente'
                    }
                }
            }
        }
    });
}

/* ------------------------------- */

function recargarGraficaAsignacionPendienteFirmaActivo()
{
    let inicioGrafico   = $("#dtInicioAsignacionPendientesFirmaCreacionIT").val();
    let finalGrafico    = $("#dtFinalAsignacionPendientesFirmaCreacionIT").val();
    var activosGrafico = [];
    
    $('.chkActivosDashboard:checked').each(function() {
        activosGrafico.push($(this).val());
    });
    
    var parametros = {
        "inicioGrafico" : inicioGrafico,
        "finalGrafico"  : finalGrafico,
        "activosGrafico": activosGrafico
	};
	
	$.ajax({        
        url: baseUrl + '/grafica-asignacion-pendiente-firma-activo',
        type: "POST",
        data: parametros,
        dataType: 'json',
        success: function(response) 
        {
            crearGraficaAsignacionPendienteFirmaActivo(response, "cnvAsignacionPendienteFirmaActivo");
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            //$.unblockUI({});
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
}

/* ------------------------------- */

function crearGraficaAsignacionPendienteFirmaActivo(data, elemento) 
{
    let ctx = document.getElementById(elemento);
    
    // Si ya se creó la gráfica
    if(graficaAsignacionPendienteFirmaActivo !== null) {
        // Destruir para poder crear nuevamente
        graficaAsignacionPendienteFirmaActivo.destroy();
    }
    
    // Mapear los datos del eje X (fechas) y eje Y (totales)
    const labels = data.map(item => item.Activo);
    const valores = data.map(item => parseInt(item.TotalPendiente));

    // Crear la gráfica
    graficaAsignacionPendienteFirmaActivo = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Total Pendiente',
                data: valores,
                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                borderColor: 'rgba(75, 192, 192, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false, // Esto evita conflictos de tamaño al redimensionar
            animation: {
                duration: 1000, // Elimina animaciones al redimensionar
            },
            resizeDelay: 300, // <-- Muy importante para evitar el bucle en redimensionamiento
            plugins: {
                legend: {
                    display: true,
                    position: 'top'
                },
                datalabels: {
                    anchor: 'end',
                    align: 'start',
                    color: '#000',
                    font: {
                        weight: 'bold',
                        size: 14 // Aumenta este valor según necesidad
                    },
                    formatter: function(value) {
                        return value;
                    }
                }
            },
            scales: {
                x: {
                    title: {
                        display: true,
                        text: 'Activo'
                    }
                },
                y: {
                    beginAtZero: true,
                    title: {
                        display: true,
                        text: 'Total Pendiente'
                    }
                }
            },
            onClick: function (evt, elements) {
                if (elements.length > 0) {
                    const index = elements[0].index;
                    const tipoElemento = data[index].TipoElemento;
                    recargarTablaDetalleAsignacionPendienteFirmaActivo(tipoElemento);
                    recargarGraficaDetalleAsignacionPendienteFirmaActivo(tipoElemento);
                    
                    $("#mdlDetalleFechaAsignacionPendienteFirmaActivos").modal("show");
                    
                    console.log("index: "+index+" Tipo Elemento: "+tipoElemento);
                }
            }
        }
    });
}

/* ------------------------------- */

function recargarTablaDetalleAsignacionPendienteFirmaActivo(tipoElemento)
{
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    let inicioGrafico   = $("#dtInicioAsignacionPendientesFirmaCreacionIT").val();
    let finalGrafico    = $("#dtFinalAsignacionPendientesFirmaCreacionIT").val();
    
    $('#tblDetalleFechaAsignacionPendienteFirmaActivo').DataTable().destroy();
    
    $("#tblDetalleFechaAsignacionPendienteFirmaActivo").DataTable({
        "ajax": {
            "url": baseUrl + "/recargar-detalle-asignacion-pendiente-firma-activo",
            "type": "POST",
            "data": {
                "inicioGrafico" : inicioGrafico,
                "finalGrafico"  : finalGrafico,
                "tipoElemento"  : tipoElemento
            },
            "dataSrc": function (json) 
            {
                Swal.close();
                
                if(json.sesion === 0)
                {
                    Swal.fire({
                        title: 'Por favor, vuelva a iniciar sesión.',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonColor: '#282E38',
                        confirmButtonText: 'Confirmar'
                    });
                }
                
                return json.data;
            },
            "error": function (xhr, error, thrown) 
            {
                Swal.close();
            
                Swal.fire({
                    title: 'Ha ocurrido un error interno',
                    text: thrown.message,
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#E4002B',
                    confirmButtonText: 'Confirmar'
                });
            }
        },
        columnDefs: [
            { className: "text-center align-middle", targets: "_all" }
        ],
        columns: [
           { data: 'id_asignacion' },
           { data: 'fecha_asignacion' },
           { data: 'asignado' },
           { data: 'matricula' },
           { data: 'CC' },
           { data: 'dispositivos' },
           { data: 'acciones' }
        ]
    });
    
}

/* ------------------------------- */

function recargarGraficaDetalleAsignacionPendienteFirmaActivo(tipoElemento)
{
    let inicioGrafico   = $("#dtInicioAsignacionPendientesFirmaCreacionIT").val();
    let finalGrafico    = $("#dtFinalAsignacionPendientesFirmaCreacionIT").val();
    
    var parametros = {
        "inicioGrafico" : inicioGrafico,
        "finalGrafico"  : finalGrafico,
        "tipoElemento"  : tipoElemento
	};
	
	$.ajax({        
        url: baseUrl + '/grafica-detalle-asignacion-pendiente-firma-activo',
        type: "POST",
        data: parametros,
        dataType: 'json',
        success: function(response) 
        {
            crearGraficaDetalleAsignacionPendienteFirmaActivo(response, "cnvDetalleFechaAsignacionPendienteFirmaActivos");
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            //$.unblockUI({});
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
}

/* ------------------------------- */

function crearGraficaDetalleAsignacionPendienteFirmaActivo(data, elemento) 
{
    let ctx = document.getElementById(elemento);
    
    // Si ya se creó la gráfica
    if(graficaDetalleAsignacionPendienteFirmaActivo !== null) {
        // Destruir para poder crear nuevamente
        graficaDetalleAsignacionPendienteFirmaActivo.destroy();
    }
    
    // Mapear los datos del eje X (fechas) y eje Y (totales)
    const labels = data.map(item => item.CCAsignado);
    const valores = data.map(item => parseInt(item.TotalPendiente));

    // Crear la gráfica
    graficaDetalleAsignacionPendienteFirmaActivo = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Total Pendiente',
                data: valores,
                backgroundColor: 'rgba(75, 192, 192, 0.6)',
                borderColor: 'rgba(75, 192, 192, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false, // Esto evita conflictos de tamaño al redimensionar
            animation: {
                duration: 1000, // Elimina animaciones al redimensionar
            },
            resizeDelay: 300, // <-- Muy importante para evitar el bucle en redimensionamiento
            plugins: {
                legend: {
                    display: true,
                    position: 'top'
                },
                datalabels: {
                    anchor: 'end',
                    align: 'start',
                    color: '#000',
                    font: {
                        weight: 'bold',
                        size: 14 // Aumenta este valor según necesidad
                    },
                    formatter: function(value) {
                        return value;
                    }
                }
            },
            scales: {
                x: {
                    title: {
                        display: true,
                        text: 'Delegaciones'
                    }
                },
                y: {
                    beginAtZero: true,
                    title: {
                        display: true,
                        text: 'Total Pendiente'
                    }
                }
            }
        }
    });
}

/* ------------------------------- */

function recargarGraficaPendientesValidar()
{
    let inicioGrafico   = $("#dtInicioAsignacionPendientesFirmaCreacionIT").val();
    let finalGrafico    = $("#dtFinalAsignacionPendientesFirmaCreacionIT").val();
    var activosGrafico = [];
    
    $('.chkActivosDashboard:checked').each(function() {
        activosGrafico.push($(this).val());
    });
    
    var parametros = {
        "inicioGrafico" : inicioGrafico,
        "finalGrafico"  : finalGrafico,
        "activosGrafico": activosGrafico
	};
	
	$.ajax({        
        url: baseUrl + '/grafica-pendientes-validar',
        type: "POST",
        data: parametros,
        dataType: 'json',
        success: function(response) 
        {
            crearGraficaPendientesValidar(response, "cnvActivosPendientesValidar");
        }, 
        error: function(jqXHR, textStatus, errorThrown){
            //$.unblockUI({});
            Swal.close();
            
            Swal.fire({
                title: 'Ha ocurrido un error interno',
                text: errorThrown,
                icon: 'error',
                showCancelButton: false,
                confirmButtonColor: '#E4002B',
                confirmButtonText: 'Confirmar'
            });
        }
    });
}

/* ------------------------------- */

function crearGraficaPendientesValidar(data, elemento) 
{
    let ctx = document.getElementById(elemento);
    
    // Si ya se creó la gráfica
    if(graficaPendientesValidar !== null) {
        // Destruir para poder crear nuevamente
        graficaPendientesValidar.destroy();
    }
    
    // Mapear etiquetas (TipoElemento) y valores de cada dataset
    const labels = data.map(item => item.TipoElemento);
    const mas10dias = data.map(item => parseInt(item.Mas10dias));
    const menos10dias = data.map(item => parseInt(item.Menos10dias));

    // Crear la gráfica
    graficaPendientesValidar = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [
                {
                    label: 'Más de 10 días',
                    data: mas10dias,
                    backgroundColor: 'rgba(255, 99, 132, 0.6)',
                    borderColor: 'rgba(255, 99, 132, 1)',
                    borderWidth: 1,
                    validacion: 'mas10'
                },
                {
                    label: '10 días o menos',
                    data: menos10dias,
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1,
                    validacion: 'menos10'
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false, // Esto evita conflictos de tamaño al redimensionar
            animation: {
                duration: 1000, // Elimina animaciones al redimensionar
            },
            resizeDelay: 300, // <-- Muy importante para evitar el bucle en redimensionamiento
            plugins: {
                legend: {
                    display: true,
                    position: 'top'
                },
                datalabels: {
                    anchor: 'end',
                    align: 'start',
                    color: '#000',
                    font: {
                        weight: 'bold',
                        size: 14 // Aumenta este valor según necesidad
                    },
                    formatter: function(value) {
                        return value;
                    }
                }
            },
            scales: {
                x: {
                    title: {
                        display: true,
                        text: 'Tipo de Elemento'
                    }
                },
                y: {
                    beginAtZero: true,
                    title: {
                        display: true,
                        text: 'Cantidad'
                    }
                }
            },
            onClick: function(evt, elements) 
            {
                if (elements.length > 0) {
                    const chart = this;
                    const elementIndex = elements[0].index;
                    const datasetIndex = elements[0].datasetIndex;
            
                    const tipoElemento = chart.data.labels[elementIndex];
                    const dataset = chart.data.datasets[datasetIndex];
            
                    const rangoValidacion = dataset.validacion; // 👈 Recuperar el valor corto (mas10 / menos10)
                    
                    recargarTablaDetallePendientesValidacion(tipoElemento, rangoValidacion);
                    // recargarGraficaDetalleAsignacionPendienteFirmaCreacion(tipoElemento, rangoValidacion);
                    
                    $("#mdlDetallePendientesValidacion").modal("show");
                    console.log(tipoElemento+"<br>");
                    console.log(rangoValidacion)
                    // Llamar una función que abre el modal y carga la tabla
                    // mostrarModalConDatos(tipoElemento, tipoRango);
                }
            }
        },
        plugins: [ChartDataLabels]
    });
}

/* ------------------------------- */

function recargarTablaDetallePendientesValidacion(tipoElemento, rangoValidacion)
{
    Swal.fire({
        html: 'Un momento por favor...',
        heightAuto: true,
        showConfirmButton: false
    });
    
    let inicioGrafico   = $("#dtInicioAsignacionPendientesFirmaCreacionIT").val();
    let finalGrafico    = $("#dtFinalAsignacionPendientesFirmaCreacionIT").val();
    
    $('#tblDetallePendientesValidar').DataTable().destroy();
    
    $("#tblDetallePendientesValidar").DataTable({
        "ajax": {
            "url": baseUrl + "/recargar-detalle-pendientes-validacion",
            "type": "POST",
            "data": {
                "inicioGrafico"     : inicioGrafico,
                "finalGrafico"      : finalGrafico,
                "tipoElemento"      : tipoElemento,
                "rangoValidacion"   : rangoValidacion
            },
            "dataSrc": function (json) 
            {
                Swal.close();
                
                if(json.sesion === 0)
                {
                    Swal.fire({
                        title: 'Por favor, vuelva a iniciar sesión.',
                        icon: 'warning',
                        showCancelButton: false,
                        confirmButtonColor: '#282E38',
                        confirmButtonText: 'Confirmar'
                    });
                }
                
                return json.data;
            },
            "error": function (xhr, error, thrown) 
            {
                Swal.close();
            
                Swal.fire({
                    title: 'Ha ocurrido un error interno',
                    text: thrown.message,
                    icon: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#E4002B',
                    confirmButtonText: 'Confirmar'
                });
            }
        },
        columnDefs: [
            { className: "text-center align-middle", targets: "_all" }
        ],
        columns: [
           { data: 'id_devolucion' },
           { data: 'fecha_devolucion' },
           { data: 'activo' },
           { data: 'marca' },
           { data: 'modelo' },
           { data: 'serie' },
           { data: 'acciones' }
        ]
    });
    
}

/* ------------------------------- */

/* ------------------------------- */

/* ------------------------------- */

/* ------------------------------- */

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES KIT DEMO */

/* ------------------------------- */

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES KIT DEMO */

/* ------------------------------- */

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES KIT DEMO */

/* ------------------------------- */

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES KIT DEMO */

/* ------------------------------- */

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES KIT DEMO */

/* ------------------------------- */

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */

/* FUNCIONES KIT DEMO */

/* ------------------------------- */

/* ------------------------------- */

/* ----------------------------------------------------------------------------------------------------------------------------------------------------------- */
