<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("CSVKIT", $permisos)) 
								{
								?>
								<button class="btn bg-info d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#subirCSVKitDemo">
									<i class="mdi mdi-file-upload me-1" style="font-size: 14px;"></i>Importar
								</button>
								<?php
								}

								if (in_array("ADDKIT", $permisos)) 
								{
								?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#nuevoKitDemo" data-form="#formNuevoKit" data-id="0" data-accion="crear" id="btnNuevoKitDemo">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblKitDemo" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">

							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE LISTADO DE KITS DEMOS***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblKitDemo').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/kit-demo-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						}
					},
					"columns": [
						{"title": "ID", "data": "IDItemKitDemo", "class": "text-center", "searchable": true },
						{"title": "Código Kit", "data": "CodigoKitDemo", "class": "text-center", "searchable": true },
						{"title": "Elemento", "data": "Nombre", "class": "text-center", "searchable": true },
						{"title": "SKU", "data": "SKU", "class": "text-center", "searchable": true },
						{"title": "Detalle", "data": "Detalle", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Matrícula Asignado", "data": "MatriculaAsignado", "class": "text-center", "searchable": true },
						{"title": "Usuario Asignado", "data": "UsuarioAsignado", "class": "text-center", "searchable": true },
						{"title": "Nombre Asignado", "data": "NombreAsignado", "class": "text-center", "searchable": false, "orderable": true },
						{"title": "Fecha Asignado", "data": "FechaAsignado", "class": "text-center", "searchable": false, "orderable": true },
						{"title": "Estado", "data": "EstadoElementoKitDemo", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE LISTADO DE KITS DEMOS****/
		
        pondImportarCSVKitDemo = FilePond.create(
            document.querySelector("#fileCSVKitDemo"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/csv'],
                onaddfile: (file) => {
                    // Validación manual por extensión
                    const allowedExtensions = /(\.xml)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser CSV.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondImportarCSVKitDemo.removeFile(file.id);
                        return false; // Detener el envío del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
	});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
        <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
        <!--        <div class="simplebar-height-auto-observer-wrapper">-->
        <!--            <div class="simplebar-height-auto-observer">-->
                        
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-mask">-->
        <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
        <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
        <!--                    <div class="simplebar-content" style="padding: 0px;">-->
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
        <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
        <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Nuevo Kit Demo -->
<div class="modal fade zoomIn" id="nuevoKitDemo" data-bs-backdrop="static" role="dialog" aria-labelledby="examplenuevoKitDemo" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplenuevoKitDemo">Registrar Nuevo Kit Demo</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formNuevoKit" class="formulario form-steps" action="<?= $baseUrl ?>/registrar-kit-demo" method="POST" autocomplete="off" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
                    <div class="row col-12 m-0 p-0 mb-3 d-flex">
						<div class="col-xxl-6 col-md-12 col-12 p-0 mb-2">
							<div>
								<label for="txtCodigoKitDemo" class="form-label" style="color: #0A497B;">Código Kit</label>
								<input type="text" class="form-control" style="color: #0A497B; border-color: #0A497B;" id="txtCodigoKitDemo" name="txtCodigoKitDemo">
							</div>
						</div>
				    </div>
				    <div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-3 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px; font-size: 15px;">
					    Elementos del Kit
					</div>
                    <div class="row col-12 m-0 p-0 mb-3 d-flex">
                        <div class="col-xxl-12 col-md-12 col-12 p-0 m-0 mb-3 d-flex justify-content-between align-items-center">
						    <select class="form-select me-3" aria-label="Elemento Demo" id="cboElementoDemoKit" name="cboElementoDemoKit">
								<option selected="" value="">Seleccione un elemento</option>
							</select>
						    <button type="button" class="btn bg-success px-2 py-1 ms-3" onclick="return agregarElementoDemoKit();" data-tooltip="tooltip" aria-label="Agregar Elemento Demo Kit">
                                <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i>
                            </button>
						</div>
						<div class="row col-12 m-0 p-0 d-flex" id="ctnNuevosElementosKitDemo">
				        </div>
				    </div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Registrar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Información Item Kit Demo -->
<div class="modal fade zoomIn" id="informacionItemDemo" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionItemDemo" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionItemDemo">Item asociado al Kit Demo</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionItemDemo" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDItemKitDemo_i" name="txtIDItemKitDemo_i">
					<div class="row">
						<div class="col-xxl-6 col-md-12 col-12 mb-3">
							<div>
								<label for="txtCodigoKitDemo_i" class="form-label" style="color: #0A497B;">Código Kit</label>
								<input type="text" class="form-control" style="color: #0A497B; border-color: #0A497B;" id="txtCodigoKitDemo_i" name="txtCodigoKitDemo_i">
							</div>
						</div>
						<div class="col-xxl-6 col-md-12 col-12 mb-3">
							<label class="form-label">SKU Elemento</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="SKU" id="txtSKUItemDemo_i" disabled>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label class="form-label">Elemento</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Descripción" id="txtNombreItemDemo_i" disabled>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                			<div>
                				<label for="txtSerieItemDemo_i" class="form-label">Serie:</label>
                				<input type="text" class="form-control" id="txtSerieItemDemo_i" name="txtSerieItemDemo_i">
                			</div>
                		</div>
                		
                		<div class="col-xxl-12 col-md-12 col-12 mb-3">
                			<div>
                				<label for="txtFechaCompraItemDemo_i" class="form-label">Fecha Compra:</label>
                				<input type="date" class="form-control" id="txtFechaCompraItemDemo_i" name="txtFechaCompraItemDemo_i">
                			</div>
                		</div>
					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
							<div>
								<label for="txtDetalleItemDemo_i" class="form-label">Detalle</label>
								<textarea class="form-control" id="txtDetalleItemDemo_i" name="txtDetalleItemDemo_i" rows="4"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" id="btnEjecutarItemKitDemo" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Subir CSV -->
<div class="modal fade zoomIn" id="subirCSVKitDemo" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplesubirCSVKitDemo" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplesubirCSVKitDemo">Importar CSV de Kits Demo</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioImportarCSVKitsDemo" id="formSubirCSVKitsDemo" autocomplete="off" action="<?= $baseUrl ?>/subir-csv-kits-demo" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<ol>
						    <li>Información de columna [SKU]: Debe colocarse el SKU exacto del elemento para que se pueda asociar correctamente.</li>
						    <li>Información de columna [SERIE]: Si el elemento no tiene serie alguna, dejar el campo vacío.</li>
						    <li>Información de columna [DETALLE]: Si no desea agregar algún tipo de detalle, dejar el campo vacío.</li>
						    <li>Información de columna [FECHA COMPRA]: Ingresar la fecha de la compra</li>
						    <li>Información de columna [PRECIO COMPRA]: Considerar colocar el precio de compra para tenerlo como referencia en la asignación y/o reposición.</li>
						    <li>Información de columna [USUARIO]: Considerar el usuario asignado al trabajador.</li>
						    <li>Información de columna [TIPO ASIGNADO]: [ASIGNADO, TEMPORAL].</li>
						</ol>
						<ul>
						    <li style="color: blue;">Las fechas deben contar con el formato "YYYY-MM-DD".</li>
						    <li style="color: blue;">Los valores de monedas deben ser enteros (no 3,999 para indicar 3999) y solo usar punto(.) para separar enteros de decimales (3999.99).</li>
						    <li style="color: blue;">Evitar espacios en blanco al inicio y al final del campo</li>
						    <li style="color: red;">Si deja vacío la columna [USUARIO ASIGNADO], no se va a realizar la asignación</li>
						</ul>
					</div>
					<hr>
					<h4 class="mb-3">Plantillas:</h4>
					<div class="row col-12 m-0 p-0">
					    <div class="col-lg-12 col-12 d-flex justify-content-center align-items-center">
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea descargar la <strong class="fw-medium">Plantilla de Importación CSV de Kits Demo</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <a class="text-body" href='<?= base_url().'/'.$basePublic.'/docs/Plantillas/plantilla csv kits demos.csv' ?>' download='Plantilla CSV Kits Demo'>Descargar Plantilla <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                    </div>
                                </div>
                            </div>
					    </div>
					</div>
					<hr>
					<h4 class="mb-3">Importar archivo:</h4>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-7 m-0 p-0">
					        <input type="file" id="fileCSVKitDemo" class="filepond" name="fileCSVKitDemo" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Importar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>