<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content min-vh-100 h-100">
	<div class="page-content min-vh-100 h-100 d-flex flex-column">
		<div class="container-fluid flex-fill ">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row h-100">
				<div class="col">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
                                <!--<button type="button" class="btn bg-success color-white px-2 py-1 mx-1" id="btnGuardarComprobantesValidados">-->
                                <!--    <i class="mdi mdi-content-save me-1" style="font-size: 14px;"></i>Guardar-->
                                <!--</button>-->
                                <button type="button" class="btn bg-sistema color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblReporteActivosTotal" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<?= $this->section('js'); ?>
<script>
	$(function () {
	    /***SERVERSIDE REPORTE ACTIVOS TOTAL***/
		assetListVM = {
			dt: null,
			params: {},  // Para almacenar parámetros adicionales de filtro
			init: function () {
				this.dt = $('#tblReporteActivosTotal').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/recargar-reporte-activos-total",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						    
						    // Agregar los parámetros adicionales de filtro a la solicitud
                            $.each(assetListVM.params, function(key, value) {
                                d[key] = value;
                            });
						}
					},
					"columns": [
						{"title": "Documento", "data": "Documento", "class": "text-center", "searchable": true },
						{"title": "Matrícula", "data": "Matricula", "class": "text-center", "searchable": true },
						{"title": "Usuario", "data": "Usuario", "class": "text-center", "searchable": true },
						{"title": "Nombre y Apellidos", "data": "NOMBRE", "class": "text-center", "searchable": true },
						{"title": "Subárea", "data": "Subarea", "class": "text-center", "searchable": true },
						{"title": "Área", "data": "Area", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Dirección", "data": "Direccion", "class": "text-center", "searchable": true },
						{"title": "CC", "data": "CC", "class": "text-center", "searchable": true },
						{"title": "LN", "data": "LN", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Costo Reposición", "data": "CostoReposicion", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Elemento", "data": "ELEMENTO", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Tipo", "data": "TIPO", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Marca", "data": "MARCA", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Modelo", "data": "MODELO", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Serie", "data": "SERIE", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Tipo de Asignación", "data": "Tipo de Asignación", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Código Asignación", "data": "IDAsignacion", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Fecha Asignación", "data": "Fecha de Asignación", "class": "text-center", "searchable": true, "orderable": true },
					],
                    "drawCallback": function(settings) {
                        // Re-inicializar tooltips después de que los datos son cargados
                        $('[data-tooltip="tooltip"]').tooltip();
                        $('[data-toggle="tooltip"]').tooltip();
                    },
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 25,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			},
			// Método para aplicar filtros adicionales
            applyFilters: function(filters) {
                this.params = filters;  // Actualiza los parámetros de filtro
                
                if (this.dt) {
                    this.dt.clear();  // Limpia los datos previos
                    this.dt.destroy();  // Destruye la instancia actual de DataTable
                }
            
                // Reinicia DataTable con los nuevos filtros
                this.init();
            }
		}
		
		assetListVM.init();
		/****FIN SERVERSIDE REPORTE****/
		
        $("#txtColaboradorFiltro_i").select2({
            minimumInputLength: 2,
            placeholder: 'Seleccione Colaborador',
            dropdownParent: $('#ctnFiltro'),
            allowClear: true,
            language: {
                errorLoading: function() {
                    return "La carga falló";
                },
                noResults: function() {
                    return "No hay resultado";
                },
                searching: function() {
                    return "Buscando..";
                }
            },
            ajax: {
                url: baseUrl + '/listado-usuarios-select',
                dataType: 'json',
                type: "POST",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data
                    };
                }
            }
        });
        
        $('#chkTodoColaboradorFiltro_i').change(function() {
            if(this.checked)
            {
                $('#txtColaboradorFiltro_i').val("").trigger("change");
                $('#txtColaboradorFiltro_i').attr("disabled", "disabled");
            }
            else
            {
                $('#txtColaboradorFiltro_i').removeAttr("disabled");
            }
            
        });

        $('#chkTodoActivosFiltro_i').change(function() {
            $('.chkFiltroActivos').prop('checked', this.checked);
        });

        // Desactivar el toggle si algún checkbox es desmarcado
        $('.chkFiltroActivos').change(function() {
            if (!this.checked) {
                $('#chkTodoActivosFiltro_i').prop('checked', false);
            }
            // Si todos los checkboxes están marcados, activar el toggle
            if ($('.chkFiltroActivos:checked').length === $('.chkFiltroActivos').length) {
                $('#chkTodoActivosFiltro_i').prop('checked', true);
            }
        });
        
        $("#btnLimpiar").click(function() {
            $('#txtColaboradorFiltro_i').val("").trigger("change");
            $('#txtColaboradorFiltro_i').removeAttr("disabled");
            $('#chkTodoColaboradorFiltro_i').prop('checked', false);
            $('#chkTodoActivosFiltro_i').prop('checked', false);
            $('.chkFiltroActivos').prop('checked', false);
        });
        
        // $(document).on('click', "#btnBuscarFiltros", function(e) 
        // {
        //     Swal.fire({
        //         html: 'Un momento por favor...',
        //         heightAuto: true,
        //         showConfirmButton: false
        //     });
            
        //     let colaborador;
        //     var activos = [];
            
        //     if ($('#chkTodoColaboradorFiltro_i').is(':checked')) 
        //     {
        //         colaborador = ""; // Asignar un valor si está activo
        //     } 
        //     else 
        //     {
        //         colaborador = $("#txtColaboradorFiltro_i").val(); // Asignar un valor diferente si no está activo
        //     }
            
        //     $('.chkFiltroActivos:checked').each(function() {
        //         activos.push($(this).val()); // Agregar el valor al array
        //     });
            
        //     $('#tblReporteActivosTotal').DataTable().destroy();
            
        //     $("#tblReporteActivosTotal").DataTable({
        //         "ajax": {
        //             "url": baseUrl + "/recargar-reporte-activos-total",
        //             "type": "POST",
        //             "data": {
        //                 "colaborador"   : colaborador,
        //                 "activos"       : activos
        //             },
        //             "error": function (xhr, error, thrown) {
        //                 Swal.close();
        //                 Swal.fire({
        //                     title: 'Ha ocurrido un error interno',
        //                     text: thrown.message,
        //                     icon: 'error',
        //                     showCancelButton: false,
        //                     confirmButtonColor: '#E4002B',
        //                     confirmButtonText: 'Confirmar'
        //                 });
        //             }
        //         },
        //         columnDefs: [
        //             { className: "text-center align-middle", targets: "_all" }
        //         ],
        //         columns: [
        //           { data: 'documento' },
        //           { data: 'matricula' },
        //           { data: 'usuario' },
        //           { data: 'nombre' },
        //           { data: 'direccion' },
        //           { data: 'area' },
        //           { data: 'subarea' },
        //           { data: 'cc' },
        //           { data: 'ln' },
        //           { data: 'costo_reposicion' },
        //           { data: 'elemento' },
        //           { data: 'tipo' },
        //           { data: 'marca' },
        //           { data: 'modelo' },
        //           { data: 'serie' },
        //           { data: 'tipo_asignacion' },
        //           { data: 'codigo_asignacion' },
        //           { data: 'fecha_asignacion' }
        //         ]
        //     });
            
        //     $("#btnCerrarFiltros").click();
        //     Swal.close();
        // });
        
        
        
	});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<form class="filtro" autocomplete="off" action="" method="POST" accept-charset="utf-8">
    <div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
        <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
            <h5 class="m-0 me-2 text-white">Filtros</h5>
    
            <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body p-0">
            <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
            <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
            <!--        <div class="simplebar-height-auto-observer-wrapper">-->
            <!--            <div class="simplebar-height-auto-observer">-->
                            
            <!--            </div>-->
            <!--        </div>-->
            <!--        <div class="simplebar-mask">-->
            <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
            <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
            <!--                    <div class="simplebar-content" style="padding: 0px;">-->
                <div id="ctnFiltro" class="p-3">
    				<div class="panel">
                        <div class="panel-heading">
                            <h4>Búsqueda</h4>
                        </div>
                        <div class="panel-content">
                            <div class="row">
                                <div class="col-12 col-md-12 p-0">
                					<div class="col-xxl-12 col-md-12 col-12 border-sistema-2px p-2 my-2 d-flex justify-content-between align-items-center" style="border-radius: 7px;">
                					    <h5 class="color-sistema m-0" for="chkTodoColaboradorFiltro_i">Colaborador</h5>
                					    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkTodoColaboradorFiltro_i">
                							<input class="form-check-input form-check-input-sistema" type="checkbox" role="switch" name="chkTodoColaboradorFiltro_i" id="chkTodoColaboradorFiltro_i">
                							<label class="form-check-label m-0" for="chkTodoColaboradorFiltro_i"></label>
                						</div>
                					</div>
                					<div class="col-xxl-12 col-md-12 col-12 my-2">
                						<div>
                							<select class="form-select" aria-label="Tipo" id="txtColaboradorFiltro_i" name="txtColaboradorFiltro_i" placeholder="Colaborador">
                								<option selected="" value="">Seleccione una opción</option>
                								
                							</select>
                						</div>
                					</div>
                				</div>
                				<div class="col-12 col-md-12 p-0 my-3">
                					<div class="col-xxl-12 col-md-12 col-12 border-sistema-2px p-2 my-2 d-flex justify-content-between align-items-center" style="border-radius: 7px;">
                					    <h5 class="color-sistema m-0" for="txtColaboradorFiltro_i">Activos</h5>
                					    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkTodoActivosFiltro_i">
                							<input class="form-check-input form-check-input-sistema" type="checkbox" role="switch" name="chkTodoActivosFiltro_i" id="chkTodoActivosFiltro_i">
                							<label class="form-check-label m-0" for="chkTodoActivosFiltro_i"></label>
                						</div>
                					</div>
                					<div class="row col-xxl-12 col-md-12 col-12 p-0 m-0 my-2">
                						<div class="col-6 m-0 p-0">
                						    <div class="form-check form-switch form-switch-lg">
                								<input class="form-check-input chkFiltroActivos" type="checkbox" role="switch" name="elementosFiltro[]" id="chkFiltroLINEA" value="LINEA">
                								<label class="form-check-label" for="chkFiltroLINEA">Línea</label>
                							</div>
                						</div>
                						<div class="col-6 m-0 p-0">
                						    <div class="form-check form-switch form-switch-lg">
                								<input class="form-check-input chkFiltroActivos" type="checkbox" role="switch" name="elementosFiltro[]" id="chkFiltroMOVIL" value="MOVIL">
                								<label class="form-check-label" for="chkFiltroMOVIL">Móvil</label>
                							</div>
                						</div>
                						<div class="col-6 m-0 p-0">
                						    <div class="form-check form-switch form-switch-lg">
                								<input class="form-check-input chkFiltroActivos" type="checkbox" role="switch" name="elementosFiltro[]" id="chkFiltroACCESORIOIT" value="ACCESORIOIT">
                								<label class="form-check-label" for="chkFiltroACCESORIOIT">Accesorio IT</label>
                							</div>
                						</div>
                						<div class="col-6 m-0 p-0">
                						    <div class="form-check form-switch form-switch-lg">
                								<input class="form-check-input chkFiltroActivos" type="checkbox" role="switch" name="elementosFiltro[]" id="chkFiltroHARDWARE" value="HARDWARE">
                								<label class="form-check-label" for="chkFiltroHARDWARE">Hardware</label>
                							</div>
                						</div>
                						<div class="col-6 m-0 p-0">
                						    <div class="form-check form-switch form-switch-lg">
                								<input class="form-check-input chkFiltroActivos" type="checkbox" role="switch" name="elementosFiltro[]" id="chkFiltroKITDEMO" value="KITDEMO">
                								<label class="form-check-label" for="chkFiltroKITDEMO">Kit Demo</label>
                							</div>
                						</div>
                						<div class="col-6 m-0 p-0">
                						    <div class="form-check form-switch form-switch-lg">
                								<input class="form-check-input chkFiltroActivos" type="checkbox" role="switch" name="elementosFiltro[]" id="chkFiltroTARJETA" value="TARJETA">
                								<label class="form-check-label" for="chkFiltroTARJETA">Tarjeta de Acceso</label>
                							</div>
                						</div>
                					</div>
                				</div>
                            </div>
                        </div>
                    </div>
                </div>
            <!--                    </div>-->
            <!--                </div>-->
            <!--            </div>-->
            <!--        </div>-->
            <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
            <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
            <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->
        </div>
        <div class="offcanvas-footer border-top p-3 text-center">
            <div class="row">
                <div class="col-4">
                    <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
                </div>
                <div class="col-4">
                    <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
                </div>
                <div class="col-4">
                    <button type="submit" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
                </div>
            </div>
        </div>
    </div>
</form>




<?php $this->endSection(); ?>