<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								
								<button type="button" class="btn bg-warning d-flex justify-content-center align-items-center mx-1 color-white" data-bs-target="#exportarKardexAccesoriosIT" id="btnExportarKardexAccesoriosIT">
        							<i class="mdi mdi-download-box me-1" style="font-size: 14px;"></i>Exportar
        						</button>
								<a href="<?= $baseUrl.'/'.$previo ?>" class="btn bg-red-verisure color-white px-2 py-1 mx-1 d-flex justify-content-center align-items-center">
								    <i class="mdi mdi-arrow-left-circle" style="font-size: 18px;"></i>
								</a>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblAccesoriosIT" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Correlativo</th>
										<th class="text-center align-middle">Fecha Exportable</th>
										<th class="text-center align-middle">Tipo</th>
										<th class="text-center align-middle">Fecha Inicio</th>
										<th class="text-center align-middle">Fecha Final</th>
										<th class="text-center align-middle">Correo Validación</th>
										<th class="text-center align-middle">Descargar Periodo</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaDescargas as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDRegistro'] ?></td>
										<td class="text-center align-middle">
										    <span class="d-none"><?= date("YmdHis", strtotime($items['FechaCrea'])) ?></span>
										    <?= date("d-m-Y", strtotime($items['FechaCrea'])) ?><br><?= date("H:i:s", strtotime($items['FechaCrea'])) ?>
										</td>
										<td class="text-center align-middle"><?= $items['TipoExportable'] ?></td>
										<td class="text-center align-middle">
										    <span class="d-none"><?= date("YmdHis", strtotime($items['FechaInicioExportable'])) ?></span>
										    <?= date("d-m-Y", strtotime($items['FechaInicioExportable'])) ?>
										</td>
										<td class="text-center align-middle">
										    <span class="d-none"><?= date("YmdHis", strtotime($items['FechaFinalExportable'])) ?></span>
										    <?= date("d-m-Y", strtotime($items['FechaFinalExportable'])) ?>
										</td>
										<td class="text-center align-middle">
										    <?php 
										    if(empty($items['NombreAdjuntoValidacion']) || $items['NombreAdjuntoValidacion'] == NULL)
										    {
										    ?>
										    <button type="button" class="btn bg-warning color-white mx-1 validacion-kardex-accesorios-it" data-bs-target="#adjuntarValidacionRegistro" data-registro="<?= $items['IDRegistro'] ?>">
                    							<i class="mdi mdi-upload me-1" style="font-size: 14px;"></i>Adjuntar
                    						</button>
										    <?php
										    }
										    else
										    {
										    ?>
										    <a class='btn btn-success border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/'.$basePublic.'/docs/Kardex/AccesoriosIT/Validacion/'.date("Y", strtotime($items["FechaCrea"])).'/'.date("m", strtotime($items["FechaCrea"])).'/'.$items["IDRegistro"].'.'.$items["ExtensionAdjuntoValidacion"] ?>' download='<?= $items["NombreAdjuntoValidacion"].".".$items["ExtensionAdjuntoValidacion"] ?>'>
										        <i class="mdi mdi-tray-arrow-down me-1" style="font-size: 14px;"></i><?= $items["NombreAdjuntoValidacion"] ?>
										    </a>
										    <?php
										    }
										    ?>
										</td>
										<td class="text-center align-middle">
										    <a href='<?= base_url().'/exportar-traspaso-accesorios-it/'.date("Y-m-d", strtotime($items['FechaInicioExportable'])).'/'.date("Y-m-d", strtotime($items['FechaFinalExportable'])).'/'.$items['TipoExportable'].'/HISTORICO' ?>' class="btn text-muted bg-info px-2 py-2 color-white" target="_blank">
										        <i class="mdi mdi-file-download color-white me-1" style="font-size: 15px;"></i>Exportar
										    </a>
										</td>
									</tr>
									<?php
									}
									?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<?= $this->section('js'); ?>
<script>
	$(function () {
		pondValidacionKardexAccesorioIT = FilePond.create(
            document.querySelector("#txtCorreoValidacion_rkait"), {
                labelIdle: 'Arrastra y suelta el CORREO de validación o <span class="filepond--label-action">explora</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                // acceptedFileTypes: [
                //   'application/vnd.ms-outlook',   // Common MIME type for .msg files
                //   'application/octet-stream',       // Generic MIME type for binary files
                //   'application/x-msg'               // Alternative MIME type
                // ]
            }
        );
	});
</script>
<?php $this->endSection(); ?>


<!-- Modal Adjuntar Validación -->
<div class="modal fade zoomIn" id="adjuntarValidacionRegistro" data-bs-backdrop="static" role="dialog" aria-labelledby="exampleadjuntarValidacionRegistro" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-md" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleadjuntarValidacionRegistro">Importar Validación</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formImportarValidacionKardexAccesoriosIT" class="formularioImportarValidacionKardexAccesoriosIT" action="<?= $baseUrl ?>/importar-validacion-kardex-accesorio-it" method="POST" enctype="multipart/form-data" autocomplete="off" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="row modal-body">
				    <input type="hidden" id="txtIDRegistroKardexAccesoriosIT" name="txtIDRegistroKardexAccesoriosIT">
    				<!--<h4 class="mb-3">Importar Correo de Validación:</h4>-->
					<div class="col-xxl-12 col-md-12 col-12 mb-3">
						<label class="form-label">Nombre</label>
						<div class="input-group">
							<input type="text" class="form-control" aria-label="Nombre de Adjunto" id="txtNombreAdjunto_rkait" name="txtNombreAdjunto_rkait">
						</div>
					</div>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-12 m-0 p-0">
					        <input type="file" id="txtCorreoValidacion_rkait" class="filepond" name="txtCorreoValidacion_rkait" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
    				<hr class="m-0">
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-file-upload me-2 color-white" style="font-size: 14px;"></i>Importar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Exportar -->
<div class="modal fade zoomIn" id="exportarKardexAccesoriosIT" data-bs-backdrop="static" role="dialog" aria-labelledby="exampleexportarKardexAccesoriosIT" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-md" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleexportarKardexAccesoriosIT">Exportar Kardex</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formExportarKardexAccesoriosIT" class="formulario" action="<?= $baseUrl ?>/exportar-kardex-accesorio-it" method="POST" autocomplete="off" accept-charset="utf-8">
				<div class="row modal-body">
				    <h5 class="m-0">01.- Seleccione fecha de inicio: </h5>
				    <div class="col-xxl-12 col-md-12 col-12 p-3 d-flex justify-content-center align-items-center">
                        <div class="input-group">
                            <span class="input-group-text" id="basic-addon1">Inicio</span>
                            <input type="date" class="form-control" placeholder="Fecha de Inicio" id="dtInicio_rka" name="dtInicio_rka" aria-label="Fecha de Inicio" aria-describedby="basic-addon1">
                        </div>
                    </div>
				    <h5 class="m-0">02.- Seleccione fecha Final: </h5>
			        <div class="col-xxl-12 col-md-12 col-12 p-3 d-flex justify-content-center align-items-center">
                        <div class="input-group">
                            <span class="input-group-text" id="basic-addon1">Final</span>
                            <input type="date" class="form-control" placeholder="Fecha de Fin" max="<?= date("Y-m-d", strtotime("-1 day")) ?>" id="dtFinal_rka" name="dtFinal_rka" aria-label="Fecha de Fin" aria-describedby="basic-addon1">
                        </div>
                    </div>
				    <h5 class="m-0">03.- Reporte a exportar: </h5>
				    <div class="col-xxl-12 col-md-12 col-12 d-flex p-3">
				        <div class="row col-6 m-0 p-0">
							<div class="form-check form-switch form-switch-lg">
								<input class="form-check-input form-check-input-orange" type="checkbox" role="switch" name="reporte_rka[]" value="TRASPASO" id="chkTraspasoReporte">
								<label class="form-check-label" for="chkTraspasoReporte">Traspaso</label>
							</div>
						</div>
				    </div>
				    <hr class="m-0 my-2">
				    <span class="respuesta"></span>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-download-box me-2 color-white" style="font-size: 14px;"></i>Exportar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<?php $this->endSection(); ?>