<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<style>
    .select2-container--locked{
        pointer-events: none;  /* Bloquea la interacción con el select */
        background-color: #d3d3d3; /* Gris claro */
    }
</style>
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("CSVTAC", $permisos)) 
								{
								?>
								<button class="btn bg-info d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#importarCSVTarjetasAcceso">
									<i class="mdi mdi-file-upload me-1" style="font-size: 14px;"></i>Importar
								</button>
								<?php
								}

								if (in_array("ADDTAC", $permisos)) 
								{
								?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white datos-tarjeta-acceso" data-bs-target="#informacionTarjetaAcceso" data-form="#formInformacionTarjetaAcceso" data-id="0" data-accion="crear" id="crear-tarjeta-acceso" data-tooltip="tooltip" title="Crear Tarjeta de Acceso">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblTarjetasAcceso" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE LISTADO DE TARJETAS DE ACCESO***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblTarjetasAcceso').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/tarjetas-acceso-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						}
					},
					"columns": [
						{"title": "Código", "data": "IDTarjetaAcceso", "class": "text-center", "searchable": true },
						{"title": "Serie", "data": "Serie", "class": "text-center", "searchable": true },
						{"title": "Precio", "data": "PrecioTarjetaAcceso", "class": "text-center", "searchable": true },
						{"title": "Observación", "data": "Observacion", "class": "text-center", "searchable": true },
						{"title": "Estado Tarjeta", "data": "EstadoTarjetaAcceso", "class": "text-center", "searchable": true },
						{"title": "Asignado", "data": "Asignado", "class": "text-center", "searchable": false, "orderable": true },
						{"title": "Nombre Asignado", "data": "NombreAsignado", "class": "text-center", "searchable": false, "orderable": true },
						{"title": "Matrícula", "data": "MatriculaAsignado", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE LISTADO DE TARJETAS DE ACCESO****/
		
        /***********************************/
        
        pondImportarCSVTarjetaAcceso = FilePond.create(
            document.querySelector("#fileCSVTarjetaAcceso"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/csv'],
                onaddfile: (file) => {
                    // Validación manual por extensión
                    const allowedExtensions = /(\.xml)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser CSV.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondImportarCSVTarjetaAcceso.removeFile(file.id);
                        return false; // Detener el envío del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
	});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
        <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
        <!--        <div class="simplebar-height-auto-observer-wrapper">-->
        <!--            <div class="simplebar-height-auto-observer">-->
                        
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-mask">-->
        <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
        <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
        <!--                    <div class="simplebar-content" style="padding: 0px;">-->
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
        <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
        <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Información Tarjeta de Acceso -->
<div class="modal fade zoomIn" id="informacionTarjetaAcceso" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionTarjetaAcceso" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionLinea">Información de Tarjeta de Acceso</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formInformacionTarjetaAcceso" autocomplete="off" action="" method="POST" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDTarjetaAcceso_i" name="txtIDTarjetaAcceso_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 my-2">
							<label for="txtSerieTarjetaAcceso_i" class="form-label">Serie</label>
                            <div class="input-group">
                                <input type="number" class="form-control" aria-label="Serie" id="txtSerieTarjetaAcceso_i" name="txtSerieTarjetaAcceso_i">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 my-2">
						    <label for="txtPrecioCompra_i" class="form-label">Precio Compra</label>
							<div class="input-group">
								<span class="input-group-text">S/.</span>
								<input type="number" class="form-control" step="0.01" id="txtPrecioCompra_i" name="txtPrecioCompra_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 my-2">
							<div>
								<label for="txtObservacionTarjetaAcceso_i" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacionTarjetaAcceso_i" name="txtObservacionTarjetaAcceso_i" rows="3"></textarea>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" id="btnEjecutarTarjetaAcceso" class="btn bg-success color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Importar CSV -->
<div class="modal fade zoomIn" id="importarCSVTarjetasAcceso" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleimportarCSVTarjetasAcceso" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleimportarCSVTarjetasAcceso">importar CSV de Tarjetas de Acceso</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioImportarCSVTarjetaAcceso" id="formSubirCSVTarjetasAcceso" autocomplete="off" action="<?= $baseUrl ?>/subir-csv-tarjeta-acceso" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<ol>
						    <li>Información de columna [4TO XXX]: ACCESOS DE SEDE GERENS - 4TO PISO. Colocar 1 si la tarjeta tiene acceso a esa ubicación o dejar vacío si no lo tiene.</li>
						    <li>Información de columna [5TO XXX]: ACCESOS DE SEDE GERENS - 5TO PISO. Colocar 1 si la tarjeta tiene acceso a esa ubicación o dejar vacío si no lo tiene.</li>
						    <li>Información de columna [JP XXX]: ACCESOS DE SEDE JAVIER PRADO. Colocar 1 si la tarjeta tiene acceso a esa ubicación o dejar vacío si no lo tiene.</li>
						</ol>
						<ul>
						    <li style="color: blue;">Los valores de monedas deben ser enteros (no 3,999 para indicar 3999) y solo usar punto(.) para separar enteros de decimales (3999.99).</li>
						    <li style="color: blue;">Evitar espacios en blanco al inicio y al final del campo.</li>
						</ul>
					</div>
					<hr>
					<h4 class="mb-3">Plantillas:</h4>
					<div class="row col-12 m-0 p-0">
					    <div class="col-lg-12 col-12 d-flex justify-content-center align-items-center">
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea descargar la <strong class="fw-medium">Plantilla de Importación CSV de Tarjetas de Acceso</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <a class="text-body" href='<?= base_url().'/'.$basePublic.'/docs/Plantillas/plantilla csv tarjeta acceso.csv' ?>' download='Plantilla CSV Tarjeta Acceso'>Descargar Plantilla <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                    </div>
                                </div>
                            </div>
					    </div>
					</div>
					<hr>
    				<h4 class="mb-3">Importar archivo:</h4>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-7 m-0 p-0">
					        <input type="file" id="fileCSVTarjetaAcceso" class="filepond" name="fileCSVTarjetaAcceso" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Importar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Direcciones Tarjeta Usuario -->
<div class="modal fade zoomIn" id="editarDireccionesTarjetaAcceso" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleEditarDireccionesTarjetaAcceso" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleEditarDireccionesTarjetaAcceso">Editar Direcciones</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formEditarDireccionesTarjetaAcceso" class="formulario" autocomplete="off" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body d-flex justify-content-center">
					<input type="hidden" id="txtIDTarjetaAcceso" name="txtIDTarjetaAcceso">
					<div class="card text-dark col-10 bg-info" style="border: 1px solid #299CDB;">
						<div class="card-header" style="background-color: transparent; color: #FFF;">Direcciones</div>
						<div class="card-body" style="background-color: #FFF;" id="ctnDireccionesTarjetaAcceso">
							
					
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Histórico Asignaciones -->
<div class="modal fade zoomIn" id="mdlHistoricoAsignacionesTarjetaAcceso" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlHistoricoAsignacionesTarjetaAcceso" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlHistoricoAsignacionesTarjetaAcceso">Histórico de Asignaciones de Tarjeta de Acceso</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
			    <div class="row col-12 m-0 p-0 justify-content-center align-items-center" id="ctnHistoricoAsignacionesModel">
				    
				</div>
			</div>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>