<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<style>
    .select2-container--locked{
        pointer-events: none;  /* Bloquea la interacción con el select */
        background-color: #d3d3d3; /* Gris claro */
    }
</style>
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
                                <button class="btn bg-warning d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#exportarLineas">
									<i class="mdi mdi-file-export me-1" style="font-size: 14px;"></i>Exportar
								</button>
								<?php
								if (in_array("CSVLIN", $permisos)) 
								{
								?>
								<button class="btn bg-info d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#importarCSVLineas">
									<i class="mdi mdi-file-upload me-1" style="font-size: 14px;"></i>Importar
								</button>
								<?php
								}

								if (in_array("ADDLIN", $permisos)) 
								{
								?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#registroLinea" data-form="#formRegistroLinea" id="btnRegistroLinea">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblLineas" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE LISTADO DE LINEAS***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblLineas').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/lineas-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						}
					},
					"columns": [
						{"title": "Código", "data": "IDLinea", "class": "text-center", "searchable": true },
						{"title": "Línea", "data": "Numero", "class": "text-center", "searchable": true },
						{"title": "ICCID", "data": "ICCID", "class": "text-center", "searchable": true },
						{"title": "Operador", "data": "Operador", "class": "text-center", "searchable": true },
						{"title": "Plan", "data": "Plan", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Estado Contrato", "data": "EstadoContrato", "class": "text-center", "searchable": true },
						{"title": "Estado", "data": "EstadoLinea", "class": "text-center", "searchable": true },
						{"title": "Asignado", "data": "UsuarioAsignado", "class": "text-center", "searchable": false, "orderable": true },
						{"title": "Nombre Asignado", "data": "NombreAsignado", "class": "text-center", "searchable": false, "orderable": true },
						{"title": "Matrícula", "data": "MatriculaAsignado", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE LISTADO LINEAS****/
		
		/***********************************/
		selectEstadosLinea("txtEstadoLinea", "ACT", "registroLinea");
		selectMotivosEstadoLinea('txtMotivoLinea', "ACT", '', "registroLinea");
		
		$('#txtEstadoLinea').next('.select2').addClass('select2-container--locked');
		/***********************************/
		
		/***********************************/
		selectOperadores("txtOperador", "TOTAL", "registroLinea");
		
		$('#txtPlan').select2({
            dropdownParent: $('#registroLinea .modal-body')
        });
        
        $(document).on('change', '#txtOperador', function() 
        {
            var modal = $(this).attr("data-modal");
            var idOperador = $(this).val();
            
            $("#txtPlan").empty();
            
            selectPlanes("txtPlan", idOperador, "", modal.substring(1));
        });
        /***********************************/
        
        $(document).on('change', '#chkContratoMovil', function() 
        {
            if(this.checked)
            {
                $(".contrato-movil").removeAttr("disabled");
                
                selectMarcas("txtMarcaMovil_rl",'',"registroLinea");
                
        		$('#txtModeloMovil_rl').select2({
                    dropdownParent: $('#registroLinea .modal-body')
                });
                
                $('#txtProveedor_i').select2({
                    dropdownParent: $('#registroLinea .modal-body')
                });
                
                selectEstadosMovil("txtEstadoMovil_rl", "ACT", "registroLinea");
                selectMotivosEstadoMovil("txtMotivoMovil_rl", "ACT", "", "registroLinea");
                
                $('#txtEstadoMovil_rl').next('.select2').addClass('select2-container--locked');
                
            }
            else
            {
                $(".contrato-movil").prop("disabled", "disabled");
            }
        });
        
        /***********************************/
        
        $(document).on('change', '#txtMarcaMovil_rl', function() 
        {
            var modal       = $(this).attr("data-modal");
            var categoria   = $(this).attr("data-categoria");
            var idMarca     = $(this).val();
            
            $("#txtModeloMovil_rl").empty();
            
            selectDispositivos("txtModeloMovil_rl", idMarca, "", categoria, modal.substring(1));
        });
        
        /***********************************/
        
		$('#txtPeriodoPermanencia').select2({
            dropdownParent: $('#registroLinea .modal-body')
        });
        
		$('#txtEstado_contrato').select2({
            dropdownParent: $('#registroLinea .modal-body')
        });
        
        $('#txtEstado_contrato').next('.select2').addClass('select2-container--locked');
        
        /***********************************/
        
        pondImportarCSVLinea = FilePond.create(
            document.querySelector("#fileCSVLinea"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/csv'],
                onaddfile: (file) => {
                    // Validación manual por extensión
                    const allowedExtensions = /(\.xml)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser CSV.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondImportarCSVLinea.removeFile(file.id);
                        return false; // Detener el envío del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
	});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
        <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
        <!--        <div class="simplebar-height-auto-observer-wrapper">-->
        <!--            <div class="simplebar-height-auto-observer">-->
                        
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-mask">-->
        <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
        <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
        <!--                    <div class="simplebar-content" style="padding: 0px;">-->
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
        <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
        <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Registro Línea -->
<div class="modal fade zoomIn" id="registroLinea" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleregistrarOperador" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleregistrarOperador">Registrar Línea</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formRegistroLinea" class="formulario form-steps" autocomplete="off" action="<?= $baseUrl ?>/grabar-linea" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
                    <div class="step-arrow-nav mb-3">
                        <ul class="nav nav-pills custom-nav nav-border-top nav-justified" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="tabInformacionLinea" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionLinea" type="button" role="tab" aria-controls="tabcontentInformacionLinea" aria-selected="true" data-position="0">Información de Línea</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tabInformacionLineaContrato" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionLineaContrato" type="button" role="tab" aria-controls="tabcontentInformacionLineaContrato" aria-selected="false" data-position="1">Información de Contrato</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tabInformacionLineaContratoMovil" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionLineaContratoMovil" type="button" role="tab" aria-controls="tabcontentInformacionLineaContratoMovil" aria-selected="false" data-position="2">Información de Móvil</button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="tabcontentInformacionLinea" role="tabpanel" aria-labelledby="tabInformacionLinea">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
                                    <div class="col-xxl-12 col-md-12 col-12 mb-3">
            							<label for="txtNumeroLinea_rl" class="form-label">Número</label>
                                        <div class="input-group">
                                            <input type="number" class="form-control" aria-label="Número" id="txtNumeroLinea_rl" name="txtNumeroLinea_rl">
                                        </div>
                                    </div>
            						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                                        <div>
                                            <label for="txtICCID_rl" class="form-label">ICCID</label>
                                            <input type="number" class="form-control" id="txtICCID_rl" name="txtICCID_rl">
                                        </div>
                                    </div>
                                    <div class="col-xxl-6 col-md-12 col-12 mb-3">
        								<label for="txtEstadoLinea" class="form-label">Estado</label>
        								<select class="form-select select2-container--locked" aria-label="Estado" id="txtEstadoLinea" name="txtEstadoLinea" data-modal="#registroLinea">
        									<option selected="" value="">Seleccione una opción</option>
        								</select>
        							</div>
        							<div class="col-xxl-6 col-md-12 col-12 mb-3">
        								<label for="txtMotivoLinea" class="form-label">Motivo</label>
        								<select class="form-select" aria-label="Situación" id="txtMotivoLinea" name="txtMotivoLinea" data-modal="#registroLinea">
        									<option selected="" value="">Seleccione una opción</option>
        								</select>
        							</div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabInformacionLineaContrato">
                                    <i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Registrar Contrato
                                </button>
                            </div>
                        </div>
                         <!--end tab pane -->
                        <div class="tab-pane fade" id="tabcontentInformacionLineaContrato" role="tabpanel" aria-labelledby="tabInformacionLineaContrato">
                            <div>
                                <div class="row col-12 m-0 p-0 d-flex">
                                    <div class="col-xxl-6 col-md-12 col-12 mb-3">
        								<label for="txtOperador" class="form-label">Operador</label>
        								<select class="form-select" aria-label="Operador" id="txtOperador" name="txtOperador" data-modal="#registroLinea">
        									<option selected="" value="">Seleccione una opción</option>
        								</select>
        							</div>
            						<div class="col-xxl-6 col-md-12 col-12 mb-3">
            							<label for="txtPlan" class="form-label">Plan</label>
                                        <select class="form-select" aria-label="Plan" id="txtPlan" name="txtPlan" data-modal="#registroLinea">
            								<option selected="" value="">Seleccione una opción</option>
            							</select>
                                    </div>
            						<div class="col-xxl-12 col-md-12 col-12 px-3 mb-3">
            							<label for="txtInicioContrato" class="form-label">Inicio Contrato</label>
                                        <div class="input-group">
                                            <input type="date" class="form-control" aria-label="Inicio de contrato" id="txtInicioContrato" name="txtInicioContrato">
                                        </div>
                                    </div>
            						<div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
            							<label for="txtDiaFacturacion" class="form-label">Día facturación</label>
                                        <div class="input-group">
                                            <input type="number" min="1" max="31" class="form-control" aria-label="Día de facturación" id="txtDiaFacturacion" name="txtDiaFacturacion">
                                        </div>
                                    </div>
            						<div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
            						    <label for="txtPeriodoPermanencia" class="form-label">Permanencia</label>
            						    <select class="form-select" aria-label="Periodo de permanencia" id="txtPeriodoPermanencia" name="txtPeriodoPermanencia" data-modal="#registroLinea">
            								<option selected="" value="">Seleccione una opción</option>
            								<option value="SP">SIN PERMANENCIA</option>
            								<option value="12">12 Meses</option>
            								<option value="18">18 Meses</option>
            								<option value="24">24 Meses</option>
            							</select>
                                    </div>
            						<div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
            							<label for="txtValorCuota">Cuota de equipo</label>
                                        <div class="input-group">
                                            <span class="input-group-text">S/.</span>
                                            <input type="number" step="0.01" class="form-control" aria-label="Valor de cuota de equipo" id="txtValorCuota" name="txtValorCuota" placeholder="Valor de cuota de equipo">
                                        </div>
                                    </div>
            						<div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
            							<label for="txtEstado_contrato" class="form-label">Estado</label>
                                        <select class="form-select" aria-label="Estado" id="txtEstado_contrato" name="txtEstado_contrato"  data-modal="#registroLinea">
            								<option value="VIGENTE">VIGENTE</option>
                                        </select>
                                    </div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionLinea"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a información de línea</button>
                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabInformacionLineaContratoMovil">
                                    <i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Registrar Móvil
                                </button>
                            </div>
                        </div>
                         <!--end tab pane -->
                        <div class="tab-pane fade" id="tabcontentInformacionLineaContratoMovil" role="tabpanel" aria-labelledby="tabInformacionLineaContratoMovil">
                            <div>
                                <div class="row col-12 m-0 p-0 d-flex">
                                    <div class="col-12 mb-4 justify-content-center">
										<div class="col-xxl-12 col-md-12 col-12 border-sistema-2px p-2 d-flex justify-content-between align-items-center" style="border-radius: 15px;">
                						    <h5 class="color-sistema m-0" for="chkContratoMovil">¿El contrato incluye equipo?</h5>
                						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkContratoMovil">
                								<input class="form-check-input form-check-input-sistema" type="checkbox" role="switch" id="chkContratoMovil" name="chkContratoMovil">
                								<label class="form-check-label m-0" for="chkContratoMovil"></label>
                							</div>
                						</div>
									</div>
            						<div class="col-xxl-6 col-md-12 col-12 my-2">
            							<div>
            								<label for="txtMarcaMovil_rl" class="form-label">Marca</label>
            								<select class="form-select select2-dinamico contrato-movil" aria-label="Marca" id="txtMarcaMovil_rl" name="txtMarcaMovil_rl" data-categoria="MOVIL" data-modal="#registroLinea" disabled>
            									<option selected="" value="">Seleccione una opción</option>
            									
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-6 col-md-12 col-12 my-2">
            							<div>
            								<label for="txtModeloMovil_rl" class="form-label">Modelo</label>
            								<select class="form-select select2-dinamico contrato-movil" aria-label="Tipo" id="txtModeloMovil_rl" name="txtModeloMovil_rl" data-modal="#registroLinea" disabled>
            									<option selected="" value="">Seleccione una opción</option>
            									
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-12 col-md-12 col-12 my-2">
            							<label for="txtProveedor_i" class="form-label">Proveedor</label>
            							<select class="form-select contrato-movil" aria-label="Proveedor" id="txtProveedor_i" name="txtProveedor_i" data-modal="#registroLinea" disabled>
            								<option selected="" value="">Seleccione una opción</option>
            								<option value="ENTEL">ENTEL</option>
            								<option value="LOGÍSTICA">LOGÍSTICA</option>
            							</select>
            						</div>
            						<div class="col-xxl-12 col-md-12 col-12 my-2">
            							<div>
            								<label for="txtIMEI_i" class="form-label">IMEI</label>
            								<input type="number" class="form-control contrato-movil" id="txtIMEI_i" name="txtIMEI_i" disabled>
            							</div>
            						</div>
            						<div class="col-xxl-12 col-md-12 col-12 my-2">
            							<div>
            								<label for="txtFechaCompra_i" class="form-label">Fecha Compra</label>
            								<input type="date" class="form-control contrato-movil" id="txtFechaCompra_i" name="txtFechaCompra_i" value="<?= date("Y-m-d") ?>" disabled>
            							</div>
            						</div>
            						<div class="col-xxl-6 col-md-12 col-12 my-2">
            							<label for="txtPrecioCompra_i" class="form-label">Precio Compra</label>
            							<div class="input-group">
            							    <span class="input-group-text">S/.</span>
            								<input type="number" class="form-control contrato-movil" step="0.01" id="txtPrecioCompra_i" name="txtPrecioCompra_i" disabled>
            							</div>
            						</div>
            						<div class="col-xxl-6 col-md-12 col-12 my-2">
									    <label for="txtPrecioLista_i" class="form-label">Precio Lista</label>
                                        <div class="input-group">
                                            <span class="input-group-text">S/.</span>
                                            <input type="number" class="form-control contrato-movil" step="0.01" id="txtPrecioLista_i" name="txtPrecioLista_i" disabled>
                                        </div>
                                    </div>
									<div class="col-12 my-3  justify-content-center">
                						<div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-2 d-flex justify-content-between align-items-center" style="border-radius: 10px;" disabled>
                						    <h5 class="color-white m-0">¿Equipo Stock?</h5>
                						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center">
                								<input class="form-check-input form-check-input-green contrato-movil" type="checkbox" role="switch" name="chkEquipoStock_i" id="chkEquipoStock_i" disabled>
                								<label class="form-check-label" for="chkEquipoStock_i"></label>
                							</div>
                						</div>
                					</div>
            						<div class="row col-12 p-0 m-0" id="ctnEstadosMovil">
            							<div class="col-xxl-6 col-md-12 col-12 my-2">
            								<label for="txtEstadoMovil_rl" class="form-label">Estado</label>
            								<select class="form-select contrato-movil" aria-label="Estado" id="txtEstadoMovil_rl" name="txtEstadoMovil_rl" data-modal="#registroLinea" disabled>
            									
            								</select>
            							</div>
            							<div class="col-xxl-6 col-md-12 col-12 my-2">
            								<label for="txtMotivoMovil_rl" class="form-label">Motivo</label>
            								<select class="form-select select2-dinamico contrato-movil" aria-label="Motivo" id="txtMotivoMovil_rl" name="txtMotivoMovil_rl" data-modal="#registroLinea" disabled>
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            							</div>
            						</div>
								</div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionLineaContrato"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a información del contrato</button>
                                <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                            </div>
                        </div>
                         <!--end tab pane -->
                    </div>
                     <!--end tab content -->
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Información Linea -->
<div class="modal fade zoomIn" id="informacionLinea" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionLinea" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionLinea">Información de Línea</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formInformacionLinea" autocomplete="off" action="" method="POST" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDLinea_i" name="txtIDLinea_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtNumero" class="form-label">Número</label>
                            <div class="input-group">
                                <input type="number" class="form-control" aria-label="Número" id="txtNumero" name="txtNumero">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtICCID" class="form-label">ICCID</label>
                                <input type="number" class="form-control" id="txtICCID" name="txtICCID">
                            </div>
                        </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" id="btnEjecutarLinea" class="btn bg-success color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Exportar Líneas -->
<div class="modal fade zoomIn" id="exportarLineas" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleexportarLineas" aria-hidden="true">
	<div class="modal-dialog modal-xl modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleexportarLineas">Exportar Líneas</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
			    <div class="row col-12 m-0 p-0 justify-content-center align-items-center">
				    <div class="col-lg-4 col-12 d-flex justify-content-center align-items-center">
				        <div class="card card-light">
				            <div class="card-header">
                                <h6 class="card-title mb-0">Líneas No Asignadas</h6>
                            </div>
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <div class="flex-shrink-0">
                                        <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <p class="card-text">Para descargar las <strong>Líneas No Asignadas</strong> presione el enlace de abajo.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <div class="text-center">
                                    <a href='<?= base_url().'/exportar-linea/noasignado' ?>' class="text-body" style="cursor: pointer;" target="_blank">
								        Exportar No Asignados <i class="ri-arrow-right-s-line align-middle lh-1"></i>
								    </a>
                                </div>
                            </div>
                        </div>
				    </div>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- Modal Importar CSV -->
<div class="modal fade zoomIn" id="importarCSVLineas" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleimportarCSVLineas" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleimportarCSVLineas">importar CSV de Lineas</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioImportarCSVLinea" id="formSubirCSVLinea" autocomplete="off" action="<?= $baseUrl ?>/subir-csv-linea" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<ol>
						    <li>Información de columna [PLAN]: Debe ser un plan registrado previamente en el sistema.</li>
						    <li>Información de columna [DIA FACTURACION]: Solo colocar día, no mes ni año.</li>
						    <li>Información de columna [PERMANENCIA]: [SP, 12, 18]</li>
						    <li>Información de columna [MODELO]: Debe ser un modelo registrado previamente en el sistema.</li>
						    <li>Información de columna [PROVEEDOR]: [ENTEL, LOGISTICA]</li>
						    <li>Información de columna [USUARIO]: Considerar el usuario (NO MATRÍCULA) asignado del trabajador.</li>
						    <li>Información de columna [TIPO ASIGNADO]: [ASIGNADO, TEMPORAL, RESPONSABLE]</li>
						</ol>
						<ul>
						    <li style="color: blue;">Las fechas deben contar con el formato "YYYY-MM-DD".</li>
						    <li style="color: blue;">Los valores de monedas deben ser enteros (no 3,999 para indicar 3999) y solo usar punto(.) para separar enteros de decimales (3999.99).</li>
						    <li style="color: blue;">Evitar espacios en blanco al inicio y al final del campo</li>
						    <li style="color: red;">Si deja vacío la columna [MODELO], no se va a agregar el móvil.</li>
						    <li style="color: red;">Si deja vacío la columna [USUARIO ASIGNADO], no se va a realizar la asignación</li>
						</ul>
					</div>
					<hr>
					<h4 class="mb-3">Plantillas:</h4>
					<div class="row col-12 m-0 p-0">
					    <div class="col-lg-12 col-12 d-flex justify-content-center align-items-center">
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea descargar la <strong class="fw-medium">Plantilla de Importación CSV de Líneas</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <a class="text-body" href='<?= base_url().'/'.$basePublic.'/docs/Plantillas/plantilla csv linea.csv' ?>' download='Plantilla CSV Línea'>Descargar Plantilla <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                    </div>
                                </div>
                            </div>
					    </div>
					</div>
					<hr>
    				<h4 class="mb-3">Importar archivo:</h4>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-7 m-0 p-0">
					        <input type="file" id="fileCSVLinea" class="filepond" name="fileCSVLinea" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Importar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Histórico Asignaciones -->
<div class="modal fade zoomIn" id="mdlHistoricoAsignacionesLineas" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlHistoricoAsignacionesLineas" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlHistoricoAsignacionesLineas">Histórico de Asignaciones de Líneas</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
			    <div class="row col-12 m-0 p-0 justify-content-center align-items-center" id="ctnHistoricoAsignacionesModel">
				    
				</div>
			</div>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>