<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("CSVKHA", $permisos)) 
								{
								?>
								<button class="btn bg-morado d-flex justify-content-center align-items-center mx-1 color-white" data-bs-target="#gestionNavisionHardware" id="btnGestionNavisionHardware">
									<i class="mdi mdi-tray-arrow-up me-1" style="font-size: 14px;"></i>Kardex
								</button>
								<?php
								}
								
								if (in_array("CSVHAR", $permisos)) 
								{
								?>
								<button class="btn bg-info d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#importarCSVHardware">
									<i class="mdi mdi-file-upload me-1" style="font-size: 14px;"></i>Importar
								</button>
								<?php
								}

								if (in_array("ADDHAR", $permisos)) 
								{
								?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white datos-hardware" data-bs-target="#informacionHardware" data-form="#formInformacionHardware" data-id="0" data-accion="crear" id="crear-hardware">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblHardware" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE LISTADO DE HARDWARE***/
		assetListVM = {
			dt: null,
			params: {},  // Para almacenar parámetros adicionales de filtro
			init: function () {
				this.dt = $('#tblHardware').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/hardware-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						    
						    // Agregar los parámetros adicionales de filtro a la solicitud
                            $.each(assetListVM.params, function(key, value) {
                                d[key] = value;
                            });
						}
					},
					"columns": [
						{"title": "Código", "data": "IDHardware", "class": "text-center", "searchable": true },
						{"title": "Hostname", "data": "Hostname", "class": "text-center", "searchable": true },
						{"title": "Estado", "data": "EstadoHardware", "class": "text-center", "searchable": true },
						{"title": "Marca", "data": "Marca", "class": "text-center", "searchable": true },
						{"title": "Modelo", "data": "Modelo", "class": "text-center", "searchable": true, "orderable": false },
						{"title": "Serie", "data": "Serie", "class": "text-center", "searchable": true },
						{"title": "Matrícula Asignado", "data": "MatriculaAsignado", "class": "text-center", "searchable": true },
						{"title": "Nombre Asignado", "data": "NombreAsignado", "class": "text-center", "searchable": true },
						{"title": "Asignado", "data": "Asignado", "class": "text-center", "searchable": false, "orderable": false },
						{"title": "Subárea Reserva", "data": "SubareaReserva", "class": "text-center", "searchable": true, "orderable": true },
						{"title": "Ubicación Almacen", "data": "UbicacionAlmacen", "class": "text-center", "searchable": true },
						{"title": "Detalle", "data": "Detalle", "class": "text-center", "searchable": true },
						{"title": "Nav", "data": "Navision", "class": "text-center", "searchable": true },
						{"title": "Fin Garantía", "data": "FechaFinalGarantia", "class": "text-center", "searchable": true },
						{"title": "Precio", "data": "PrecioHardware", "class": "text-center", "searchable": true },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],
                    "drawCallback": function(settings) {
                        // Re-inicializar tooltips después de que los datos son cargados
                        $('[data-tooltip="tooltip"]').tooltip();
                        $('[data-toggle="tooltip"]').tooltip();
                    },
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			},
			// Método para aplicar filtros adicionales
            applyFilters: function(filters) {
                this.params = filters;  // Actualiza los parámetros de filtro
                
                if (this.dt) {
                    this.dt.clear();  // Limpia los datos previos
                    this.dt.destroy();  // Destruye la instancia actual de DataTable
                }
            
                // Reinicia DataTable con los nuevos filtros
                this.init();
            }
		}

// 		assetListVM.init();
		/****FIN SERVERSIDE LISTADO HARDWARE****/
		
        $(document).on('change', '#txtDireccionReserva_i', function() {
            var idDireccion = $(this).val();
            $("#txtAreaReserva_i").empty();
            $("#txtSubareaReserva_i").empty();
            var formulario=$(this).closest('form').attr("id");
            
            selectAreaEstructura('txtAreaReserva_i', idDireccion, '', formulario);
        });
        
        $(document).on('change', '#txtAreaReserva_i', function() {
            var idArea = $(this).val();
            $("#txtSubareaReserva_i").empty();
            var formulario=$(this).closest('form').attr("id");
            
            selectSubareaEstructura('txtSubareaReserva_i', idArea, '', formulario);
        });
        
		$('#txtProcesadorHardware_i').select2({
            dropdownParent: $('#informacionHardware .modal-body')
        });
        
		$('#txtGenProcesadorHardware_i').select2({
            dropdownParent: $('#informacionHardware .modal-body')
        });
        
		$('#txtRamHardware_i').select2({
            dropdownParent: $('#informacionHardware .modal-body')
        });
        
		$('#txtHDDHardware_i').select2({
            dropdownParent: $('#informacionHardware .modal-body')
        });
        
		$('#txtSSDHardware_i').select2({
            dropdownParent: $('#informacionHardware .modal-body')
        });
        
		$('#txtPulgadasHardware_i').select2({
            dropdownParent: $('#informacionHardware .modal-body')
        });
        
		$('#txtMonedaCompraHardware_i').select2({
            dropdownParent: $('#informacionHardware .modal-body')
        });
        
        /***********************************/
        
        pondImportarCSVHardware = FilePond.create(
            document.querySelector("#fileCSVHardware"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/csv'],
                onaddfile: (file) => {
                    // Validación manual por extensión
                    const allowedExtensions = /(\.xml)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser CSV.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondImportarCSVHardware.removeFile(file.id);
                        return false; // Detener el envío del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
        
        pondGestionHardwareNavision = FilePond.create(
            document.querySelector("#fileGestionHardwareNavision"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false,
                acceptedFileTypes: ['text/csv'],
                onaddfile: (file) => {
                    // Validación manual por extensión
                    const allowedExtensions = /(\.xml)$/i;
                    if (!allowedExtensions.exec(file.name)) {
                        Swal.fire({
                            text: "El formato del archivo debe ser CSV.",
                            icon: 'warning',
                            showCancelButton: false,
                            cancelButtonText: 'No',
                            confirmButtonColor: '#282e38',
                            confirmButtonText: 'OK'
                        });
                        // Remover el archivo
                        pondGestionHardwareNavision.removeFile(file.id);
                        return false; // Detener el envío del archivo
                    }
                    return true; // Permitir el archivo
                }
            }
        );
        
        /***********************************/
        /*  INPUTS DE FILTRO */
        /***********************************/
        
        selectMarcas("cboMarcaFiltro", "", "");
        
		$('#cboModeloFiltro').select2({
            dropdownParent: $('#ctnFiltro')
        });
        
        $(document).on('change', '#cboMarcaFiltro', function() {
            var idMarca = $(this).val();
            $("#cboModeloFiltro").empty();
            
            selectDispositivos("cboModeloFiltro", idMarca, "", "", "");
        });
        
        /*---------------------------*/
        
        selectDireccionEstructura("cboDireccionFiltro", "", "");
        
		$('#cboAreaFiltro').select2({
            dropdownParent: $('#ctnFiltro')
        });
        
		$('#cboSubareaFiltro').select2({
            dropdownParent: $('#ctnFiltro')
        });
        
        $(document).on('change', '#cboDireccionFiltro', function() {
            var idDireccion = $(this).val();
            $("#cboAreaFiltro").empty();
            $("#cboSubareaFiltro").empty();
            
            selectAreaEstructura("cboAreaFiltro", idDireccion, "", "");
        });
        
        $(document).on('change', '#cboAreaFiltro', function() {
            var idArea = $(this).val();
            $("#cboSubareaFiltro").empty();
            
            selectSubareaEstructura("cboSubareaFiltro", idArea, "", "");
        });
        
        $(document).on('click', '#btnLimpiar', function() {
            $('#cboMarcaFiltro').val('').trigger('change');
            $('#cboDireccionFiltro').val('').trigger('change');
            
            $('#rdbtnTodoAsignadosFiltro').prop("checked", true);
            $('#chkEstadoActivoFiltro').prop("checked", true);
            
            $('.filtro').trigger('submit');
        });
        
        // Disparar el submit del formulario al cargar la página
        $('.filtro').trigger('submit');
        /*---------------------------*/
        
	});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<form class="filtro" autocomplete="off" action="" method="POST" accept-charset="utf-8">
    <div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
        <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
            <h5 class="m-0 me-2 text-white">Filtros</h5>
    
            <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body p-0">
            <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
            <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
            <!--        <div class="simplebar-height-auto-observer-wrapper">-->
            <!--            <div class="simplebar-height-auto-observer">-->
                            
            <!--            </div>-->
            <!--        </div>-->
            <!--        <div class="simplebar-mask">-->
            <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
            <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
            <!--                    <div class="simplebar-content" style="padding: 0px;">-->
                <div id="ctnFiltro" class="p-3">
    				<div class="panel">
                        <div class="panel-heading">
                            <h4>Marca - Modelo</h4>
                        </div>
                        <div class="panel-content">
                            <div class="row">
                                <div class="col-xxl-12 col-md-12 col-12 p-2">
                					<div class="col-xxl-12 col-md-12 col-12 my-2">
                						<div>
                						    <label class="form-label fw-bold text-start">Marca</label>
                							<select class="form-select" aria-label="Marca" id="cboMarcaFiltro" name="marcaFiltro" placeholder="Marca">
                								<option selected="" value="">Seleccione una opción</option>
                								
                							</select>
                						</div>
                					</div>
                        		</div>
                                <div class="col-xxl-12 col-md-12 col-12 p-2">
                        		    <div class="col-xxl-12 col-md-12 col-12 my-2">
                						<div>
                						    <label class="form-label fw-bold text-start">Modelo</label>
                							<select class="form-select" aria-label="Modelo" id="cboModeloFiltro" name="modeloFiltro" placeholder="Modelo">
                								<option selected="" value="">Seleccione una opción</option>
                								
                							</select>
                						</div>
                					</div>
                        		</div>
                            </div>
                        </div>
                    </div>
    				<div class="panel">
                        <div class="panel-heading">
                            <h4>Estado</h4>
                        </div>
                        <div class="panel-content">
                            <div class="row">
                                <div class="col-xxl-4 col-md-12 col-12 p-1 m-0">
                                    <div class="d-flex justify-content-left">
                                        <center class="content-left" style="position: relative; height: 40px;">
                                            <input type="checkbox" id="chkEstadoActivoFiltro" name="estadosFiltro[]" class="chk-basico chk-activo chkEstadoFiltro" value="ACT" checked>
                                            <label for="chkEstadoActivoFiltro"></label>
                            			</center>
                            			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="chkEstadoActivoFiltro">Activo</label>
                            		</div>
                            	</div>
                                <div class="col-xxl-4 col-md-12 col-12 p-1 m-0">
                                    <div class="d-flex justify-content-left">
                                        <center class="content-left" style="position: relative; height: 40px;">
                                            <input type="checkbox" id="chkEstadoAveriadoFiltro" name="estadosFiltro[]" class="chk-basico chk-averiado chkEstadoFiltro" value="AVE">
                                            <label for="chkEstadoAveriadoFiltro"></label>
                            			</center>
                            			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="chkEstadoAveriadoFiltro">Averiado</label>
                            		</div>
                            	</div>
                                <div class="col-xxl-4 col-md-12 col-12 p-1 m-0">
                                    <div class="d-flex justify-content-left">
                                        <center class="content-left" style="position: relative; height: 40px;">
                                            <input type="checkbox" id="chkEstadoBajaFiltro" name="estadosFiltro[]" class="chk-basico chk-baja chkEstadoFiltro" value="BAJ">
                                            <label for="chkEstadoBajaFiltro"></label>
                            			</center>
                            			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="chkEstadoBajaFiltro">Baja</label>
                            		</div>
                            	</div>
                            </div>
                        </div>
                    </div>
    				<div class="panel">
                        <div class="panel-heading">
                            <h4>Subárea de Reserva</h4>
                        </div>
                        <div class="panel-content">
                            <div class="row">
                                <div class="col-xxl-12 col-md-12 col-12 p-2">
                					<div class="col-xxl-12 col-md-12 col-12 my-2">
                						<div>
                						    <label class="form-label fw-bold text-start">Dirección</label>
                							<select class="form-select" aria-label="Dirección" id="cboDireccionFiltro" name="direccionFiltro" placeholder="Dirección">
                								<option selected="" value="">Seleccione una opción</option>
                								
                							</select>
                						</div>
                					</div>
                        		</div>
                                <div class="col-xxl-12 col-md-12 col-12 p-2">
                        		    <div class="col-xxl-12 col-md-12 col-12 my-2">
                						<div>
                						    <label class="form-label fw-bold text-start">Área</label>
                							<select class="form-select" aria-label="Área" id="cboAreaFiltro" name="areaFiltro" placeholder="Área">
                								<option selected="" value="">Seleccione una opción</option>
                								
                							</select>
                						</div>
                					</div>
                        		</div>
                                <div class="col-xxl-12 col-md-12 col-12 p-2">
                        		    <div class="col-xxl-12 col-md-12 col-12 my-2">
                						<div>
                						    <label class="form-label fw-bold text-start">Subárea</label>
                							<select class="form-select" aria-label="Subárea" id="cboSubareaFiltro" name="subareaFiltro" placeholder="Subárea">
                								<option selected="" value="">Seleccione una opción</option>
                								
                							</select>
                						</div>
                					</div>
                        		</div>
                            </div>
                        </div>
                    </div>
    				<div class="panel">
                        <div class="panel-heading">
                            <h4>Asignados</h4>
                        </div>
                        <div class="panel-content">
                            <div class="row">
                                <div class="col-xxl-12 col-md-12 col-12 p-1 m-0">
                                    <div class="d-flex justify-content-center">
                                        <center class="content-left" style="position: relative; height: 40px;">
                                            <input type="radio" id="rdbtnTodoAsignadosFiltro" name="asignadosFiltro" class="rb-basico rb-filtro rdbtnAsignadoFiltro" value="TODO" checked>
                                            <label for="rdbtnTodoAsignadosFiltro"></label>
                            			</center>
                            			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="rdbtnTodoAsignadosFiltro">Todos los registros</label>
                            		</div>
                            	</div>
                                <div class="col-xxl-6 col-md-12 col-12 p-1 m-0">
                                    <div class="d-flex justify-content-left">
                                        <center class="content-left" style="position: relative; height: 40px;">
                                            <input type="radio" id="rdbtnAsignadosFiltro" name="asignadosFiltro" class="rb-basico rb-filtro rdbtnAsignadoFiltro" value="Y">
                                            <label for="rdbtnAsignadosFiltro"></label>
                            			</center>
                            			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="rdbtnAsignadosFiltro">Asignado</label>
                            		</div>
                            	</div>
                                <div class="col-xxl-6 col-md-12 col-12 p-1 m-0">
                                    <div class="d-flex justify-content-left">
                                        <center class="content-left" style="position: relative; height: 40px;">
                                            <input type="radio" id="rdbtnNoAsignadoFiltro" name="asignadosFiltro" class="rb-basico rb-filtro rdbtnAsignadoFiltro" value="N">
                                            <label for="rdbtnNoAsignadoFiltro"></label>
                            			</center>
                            			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="rdbtnNoAsignadoFiltro">No Asignado</label>
                            		</div>
                            	</div>
                            </div>
                        </div>
                    </div>
                </div>
            <!--                    </div>-->
            <!--                </div>-->
            <!--            </div>-->
            <!--        </div>-->
            <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
            <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
            <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                        
            <!--        </div>-->
            <!--    </div>-->
            <!--</div>-->
        </div>
        <div class="offcanvas-footer border-top p-3 text-center">
            <div class="row">
                <div class="col-4">
                    <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
                </div>
                <div class="col-4">
                    <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
                </div>
                <div class="col-4">
                    <button type="submit" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
                </div>
            </div>
        </div>
    </div>
</form>

<!-- Modal Información Hardware -->
<div class="modal fade zoomIn" id="informacionHardware" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionHardware" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionHardware">Información de hardware</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionHardware" class="formulario form-steps" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDHardware_i" name="txtIDHardware_i">
                    <div class="step-arrow-nav mb-4">
                        <ul class="nav nav-pills custom-nav nav-justified" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="tabInformacionHardware" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionHardware" type="button" role="tab" aria-controls="tabcontentInformacionHardware" aria-selected="true" data-position="0">Información del Hardware</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tabInformacionCompraHardware" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionCompraHardware" type="button" role="tab" aria-controls="tabcontentInformacionCompraHardware" aria-selected="false" data-position="1">Información de Compra</button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="tabcontentInformacionHardware" role="tabpanel" aria-labelledby="tabInformacionHardware">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtCategoriaHardware_i" class="form-label" >Categoría</label>
            								<input type="text" class="form-control" id="txtCategoriaHardware_i" name="txtCategoriaHardware_i" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtTipoHardware_i" class="form-label">Tipo</label>
            								<input type="text" class="form-control" id="txtTipoHardware_i" name="txtTipoHardware_i" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtSubtipoHardware_i" class="form-label">Subtipo</label>
            								<input type="text" class="form-control" id="txtSubtipoHardware_i" name="txtSubtipoHardware_i" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtHostnameHardware_i" class="form-label" style="color: #0A497B;">Hostname</label>
            								<input type="text" class="form-control" style="color: #0A497B; border-color: #0A497B;" id="txtHostnameHardware_i" name="txtHostnameHardware_i">
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtTAGHardware_i" class="form-label">TAG</label>
            								<input type="text" class="form-control" id="txtTAGHardware_i" name="txtTAGHardware_i">
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtSerieHardware_i" class="form-label">Serie</label>
            								<input type="text" class="form-control" id="txtSerieHardware_i" name="txtSerieHardware_i">
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtMarca_i" class="form-label">Marca</label>
            								<select class="form-select select2-dinamico" aria-label="Marca" id="txtMarca_i" name="txtMarca_i" data-categoria="HARDWARE" data-modal="#informacionHardware">
            									<option selected="" value="">Seleccione una opción</option>
            									
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtModeloComercial_i" class="form-label">Modelo</label>
            								<select class="form-select select2-dinamico" aria-label="Modelo" id="txtModeloComercial_i" name="txtModeloComercial_i" data-modal="#informacionHardware">
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtProcesadorHardware_i" class="form-label">Procesador</label>
            								<select class="form-select" aria-label="Procesador" id="txtProcesadorHardware_i" name="txtProcesadorHardware_i" data-modal="#informacionHardware">
            									<option selected="" value="">Seleccione una opción</option>
                								<option value="I5">I5</option>
                								<option value="I7">I7</option>
            								</select>
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtGenProcesadorHardware_i" class="form-label">Generación Procesador</label>
            								<select class="form-select" aria-label="HDD" id="txtGenProcesadorHardware_i" name="txtGenProcesadorHardware_i" data-modal="#informacionHardware">
            									<option selected="" value="">Seleccione una opción</option>
                								<option value="4">4ta Generación</option>
                								<option value="5">5ta Generación</option>
                								<option value="6">6ta Generación</option>
                								<option value="7">7ma Generación</option>
                								<option value="8">8va Generación</option>
                								<option value="9">9na Generación</option>
                								<option value="10">10ma Generación</option>
                								<option value="11">11va Generación</option>
                								<option value="12">12va Generación</option>
                								<option value="13">13va Generación</option>
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtRamHardware_i" class="form-label">RAM</label>
            								<select class="form-select" aria-label="RAM" id="txtRamHardware_i" name="txtRamHardware_i" data-modal="#informacionHardware">
            									<option selected="" value="">Seleccione una opción</option>
                								<option value="8">8 GB</option>
                								<option value="16">16 GB</option>
                								<option value="32">32 GB</option>
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtTipoRAMHardware_i" class="form-label">Tipo RAM</label>
            								<input type="text" class="form-control" id="txtTipoRAMHardware_i" name="txtTipoRAMHardware_i" >
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtHDDHardware_i" class="form-label">HDD</label>
            								<select class="form-select" aria-label="HDD" id="txtHDDHardware_i" name="txtHDDHardware_i" data-modal="#informacionHardware">
            									<option selected="" value="">Seleccione una opción</option>
                								<option value="256">256 GB</option>
                								<option value="500">500 GB</option>
                								<option value="512">512 GB</option>
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtSSDHardware_i" class="form-label">SSD</label>
            								<select class="form-select" aria-label="SSD" id="txtSSDHardware_i" name="txtSSDHardware_i" data-modal="#informacionHardware">
            									<option selected="" value="">Seleccione una opción</option>
                								<option value="256">256 GB</option>
                								<option value="500">500 GB</option>
                								<option value="512">512 GB</option>
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtPulgadasHardware_i" class="form-label">Pulgadas</label>
            								<select class="form-select" aria-label="Pulgadas" id="txtPulgadasHardware_i" name="txtPulgadasHardware_i" data-modal="#informacionHardware">
            									<option selected="" value="">Seleccione una opción</option>
                								<option value="12" data-cat="LAPTOP">12''</option>
                								<option value="14" data-cat="LAPTOP">14''</option>
                								<option value="20" data-cat="MONITOR">20''</option>
                								<option value="22" data-cat="MONITOR">22''</option>
                								<option value="24" data-cat="MONITOR">24''</option>
                								<option value="27" data-cat="MONITOR">27''</option>
            								</select>
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtInicioGarantia_i" class="form-label">Inicio Garantía</label>
            								<input type="date" class="form-control" id="txtInicioGarantia_i" name="txtInicioGarantia_i" value="<?= date("Y-m-d") ?>">
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtFinalGarantia_i" class="form-label">Final Garantía</label>
            								<input type="date" class="form-control" id="txtFinalGarantia_i" name="txtFinalGarantia_i">
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtFinalVidaUtil_i" class="form-label">Final Vida Útil</label>
            								<input type="date" class="form-control" id="txtFinalVidaUtil_i" name="txtFinalVidaUtil_i" style="pointer-events: none; background:#AAA; color:#F5F5F5;">
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 mb-3">
            							<div>
            								<label for="txtDetalleHardware_i" class="form-label">Detalle</label>
            								<textarea class="form-control" id="txtDetalleHardware_i" name="txtDetalleHardware_i" rows="4"></textarea>
            							</div>
            						</div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabInformacionCompraHardware"><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Ingresar información de compra</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                        <div class="tab-pane fade" id="tabcontentInformacionCompraHardware" role="tabpanel" aria-labelledby="tabInformacionCompraHardware">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-6 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtAlbaranHardware_i" class="form-label" style="color: #F03687;">Código Albarán</label>
            								<input type="text" class="form-control" style="color: #F03687; border-color: #F03687;" id="txtAlbaranHardware_i" name="txtAlbaranHardware_i">
            							</div>
            						</div>
        					        <div class="col-xxl-6 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtDireccionReserva_i" class="form-label">Dirección Reserva</label>
            								<select class="form-select select2-dinamico" aria-label="Dirección Reserva" id="txtDireccionReserva_i" name="txtDireccionReserva_i" data-modal="#informacionHardware">
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-6 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtAreaReserva_i" class="form-label">Área Reserva</label>
            								<select class="form-select select2-dinamico" aria-label="Área Reserva" id="txtAreaReserva_i" name="txtAreaReserva_i" data-modal="#informacionHardware">
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            							</div>
            						</div>
        					        <div class="col-xxl-6 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtSubareaReserva_i" class="form-label">Subárea Reserva</label>
            								<select class="form-select select2-dinamico" aria-label="Subárea Reserva" id="txtSubareaReserva_i" name="txtSubareaReserva_i" data-modal="#informacionHardware">
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-6 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtFacturaHardware_i" class="form-label">Nro Factura</label>
            								<input type="text" class="form-control" id="txtFacturaHardware_i" name="txtFacturaHardware_i">
            							</div>
            						</div>
        					        <div class="col-xxl-6 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtOCHardware_i" class="form-label">Nro OC</label>
            								<input type="text" class="form-control" id="txtOCHardware_i" name="txtOCHardware_i">
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-5 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtFechaCompra_i" class="form-label">Fecha Compra</label>
            								<input type="date" class="form-control" id="txtFechaCompra_i" name="txtFechaCompra_i" value="<?= date("Y-m-d") ?>">
            							</div>
            						</div>
            						<div class="col-xxl-2 col-md-12 col-12 px-3">
                            		    <label class="form-label" for="txtMonedaCompraHardware_i">Moneda Compra</label>
                            			<select class="form-select" aria-label="Moneda de Compra" id="txtMonedaCompraHardware_i" name="txtMonedaCompraHardware_i" data-modal="#informacionHardware">
        									<option value="PEN" >Soles (S/)</option>
        									<option value="EUR" >Euros (€)</option>
        									<option value="USD" >Dólares americanos ($)</option>
        								</select>
                            		</div>
            						<div class="col-xxl-5 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtPrecioCompra_i" class="form-label">Precio Compra</label>
            								<input type="number" class="form-control" step="0.01" id="txtPrecioCompra_i" name="txtPrecioCompra_i">
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-12 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtUbicacionHardware_i" class="form-label">Ubicación</label>
            								<select class="form-select select2-dinamico" aria-label="Ubicación" id="txtUbicacionHardware_i" name="txtUbicacionHardware_i" data-modal="#informacionHardware">
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            							</div>
            						</div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionHardware"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a información del hardware</button>
                                <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                    </div>
                    <!-- end tab content -->
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Importar CSV -->
<div class="modal fade zoomIn" id="importarCSVHardware" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleimportarCSVHardware" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleimportarCSVHardware">importar CSV de Hardware</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioImportarCSVHardware" id="formSubirCSVHardware" autocomplete="off" action="<?= $baseUrl ?>/subir-csv-hardware" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<ol>
						    <li>Información de columna [MODELO]: Debe ser un modelo registrado previamente en el sistema.</li>
						    <li>Información de columna [GENERACIÓN PROCESADOR]: Solo colocar el número de la generación (5, 7, 10, etc).</li>
						    <li>Información de columna [PERMANENCIA]: Solo colocar el valor número de la capacidad de la RAM (4, 8, 16, 32, etc).</li>
						    <li>Información de columna [RAM]: Debe ser un modelo registrado previamente en el sistema.</li>
						    <li>Información de columna [UNIDAD RAM]: [MB, GB, TB]</li>
						    <li>Información de columna [PULGADAS]: Si es un equipo ALL IN ONE y/o LAPTOP, debe considerar colocar este campo.</li>
						    <li>Información de columna [PRECIO COMPRA]: Considerar colocar el precio de compra para tenerlo como referencia en la asignación y/o reposición.</li>
						    <li>Información de columna [USUARIO]: Considerar el usuario asignado al trabajador.</li>
						    <li>Información de columna [TIPO ASIGNADO]: [ASIGNADO, TEMPORAL].</li>
						</ol>
						<ul>
						    <li style="color: blue;">Las fechas deben contar con el formato "YYYY-MM-DD".</li>
						    <li style="color: blue;">Los valores de monedas deben ser enteros (no 3,999 para indicar 3999) y solo usar punto(.) para separar enteros de decimales (3999.99).</li>
						    <li style="color: blue;">Evitar espacios en blanco al inicio y al final del campo</li>
						    <li style="color: red;">Si deja vacío la columna [USUARIO ASIGNADO], no se va a realizar la asignación</li>
						</ul>
					</div>
					<hr>
					<h4 class="mb-3">Plantillas:</h4>
					<div class="row col-12 m-0 p-0">
					    <div class="col-lg-12 col-12 d-flex justify-content-center align-items-center">
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea descargar la <strong class="fw-medium">Plantilla de Importación CSV de Hardware</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <a class="text-body" href='<?= base_url().'/'.$basePublic.'/docs/Plantillas/plantilla csv hardware.csv' ?>' download='Plantilla CSV Hardware'>Descargar Plantilla <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>
                                    </div>
                                </div>
                            </div>
					    </div>
					</div>
					<hr>
    				<h4 class="mb-3">Importar archivo:</h4>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-7 m-0 p-0">
					        <input type="file" id="fileCSVHardware" class="filepond" name="fileCSVHardware" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-import mx-1" style="font-size: 14px;"></i>Importar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Importar Movimiento Navision -->
<div class="modal fade zoomIn" id="gestionNavisionHardware" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplegestionNavisionHardware" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h4 class="modal-title color-white" id="examplegestionNavisionHardware">Gestión de Hardware Navision</h4>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formularioGestionNavisionHardware" id="formGestionNavisionHardware" autocomplete="off" action="<?= $baseUrl ?>/importar-movimiento-navision-hardware" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="row col-12 m-0 mb-3">
						<h4>Consideraciones:</h4>
						<ol>
						    <li>Información de columna [Movido Navision]: [SI, Y, YES, 1]. Cualquier otro valor, se considerará como "No Movido"</li>
						</ol>
						<ul>
						    <li style="color: blue;">Solo se descargarán los elementos cuyo subtipo está HABILITADO en navision y no haya sido movido en el mismo.</li>
						    <li style="color: blue;">Si desea HABILITAR o DESHABILITAR un subtipo, debe hacerse desde el módulo "Categoría".</li>
						    <li style="color: blue;">Los elementos exportados mostrarán solo la primera asignación realizada al elemento.</li>
						    <li style="color: blue;">Si algún elemento no ha sido asignado nunca, no aparecerá en el archivo exportado.</li>
						    
						    <li style="color: red;">El archivo a importar debe ser formato CSV.</li>
						    <li style="color: red;">Si hay algún error o no cuenta con el formato adecuado, se va a mostrar un mensaje de error indicando el problema.</li>
						</ul>
					</div>
    				<hr>
    				<h4 class="mb-3">Plantilla:</h4>
					<div class="row col-12 m-0 p-0 justify-content-center align-items-center">
					    <div class="col-lg-8 col-12 d-flex justify-content-center align-items-center">
					        <div class="card card-light">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-shrink-0">
                                            <span class="mdi mdi-download color-sistema" style="font-size: 48px;"></span>
                                        </div>
                                        <div class="flex-grow-1 ms-3">
                                            <p class="card-text">Si desea descargar los <strong>Elementos de Gestión Navision</strong> presione el enlace de abajo.</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="text-center">
                                        <!--<a onclick="return descargarEstructuraDepartamental();" class="text-body" style="cursor: pointer;">Descargar Información <i class="ri-arrow-right-s-line align-middle lh-1"></i></a>-->
                                        <a href='<?= base_url().'/pendientes-mover-navision-hardware' ?>' class="text-body" style="cursor: pointer;" target="_blank">
									        Descargar Información <i class="ri-arrow-right-s-line align-middle lh-1"></i>
									    </a>
                                    </div>
                                </div>
                            </div>
					    </div>
					</div>
    				<hr>
    				<h4 class="mb-3">Importar archivo:</h4>
					<div class="col-12 mb-0 d-flex justify-content-center">
					    <div class="col-7 m-0 p-0">
					        <input type="file" id="fileGestionHardwareNavision" class="filepond" name="fileGestionHardwareNavision" data-max-file-size="100MB" data-max-files="1" />
					    </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger d-flex justify-content-center" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" class="btn btn-success d-flex justify-content-center"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Histórico Asignaciones -->
<div class="modal fade zoomIn" id="mdlHistoricoAsignacionesHardware" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlHistoricoAsignacionesHardware" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlHistoricoAsignacionesHardware">Histórico de Asignaciones de Hardware</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
			    <div class="row col-12 m-0 p-0 justify-content-center align-items-center" id="ctnHistoricoAsignacionesModel">
				    
				</div>
			</div>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>