<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<style>
    .select2-container--locked{
        pointer-events: none;  /* Bloquea la interacción con el select */
        background-color: #d3d3d3; /* Gris claro */
    }
</style>
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
			    <div class="col-xxl-12">
                    <div class="card">
                        <div class="card-body p-4">
                            <div class="d-flex justify-content-center">
                                <div class="flex-shrink-0 avatar-md mx-4">
                                    <div class="avatar-title bg-light rounded">
                                        <img src="<?= $baseUrl ?>/<?= $basePublic ?>/images/favicon.ico" alt="" height="50">
                                    </div>
                                </div>
                                <div class="d-flex text-center align-items-center">
                                    <div>
                                        <p class="text-muted m-0">Línea</p>
                                        <h5 class="mb-0"><?= !empty($linea) ? $linea["Numero"] : "TOTAL DE CONTRATOS" ?></h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--end card-body-->
                    </div>
                    <!--end card-->
                </div>
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("ADDCON", $permisos)) 
								{
								?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white" data-bs-target="#registroContratoLinea" data-form="#formRegistroContratoLinea" data-linea="<?= $idLinea ?>" id="btnRegistrarContratoLinea">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
								<a href="<?= $baseUrl.'/'.$previo ?>" class="btn bg-red-verisure color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn">
								    <i class="mdi mdi-arrow-left" style="font-size: 18px;"></i>
								</a>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblContratosLinea" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE LISTADO DE CONTRATOS DE LINEA***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblContratosLinea').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/contratos-linea-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    //arrayrutavista.length-2 para devolver la ruta del controller
						    d.url_vista = arrayrutavista[arrayrutavista.length-2];
						    //arrayrutavista.length-2 para devolver el parámetro de la url
						    d.idLinea = arrayrutavista[arrayrutavista.length-1];
						}
					},
					"columns": [
						{"title": "Código", "data": "IDContrato", "class": "text-center", "searchable": true },
						{"title": "Linea", "data": "Numero", "class": "text-center", "searchable": true },
						{"title": "Operador", "data": "Operador", "class": "text-center", "searchable": true },
						{"title": "Plan", "data": "Plan", "class": "text-center", "searchable": false },
						{"title": "Inicio de Contrato", "data": "FechaInicioContrato", "class": "text-center", "searchable": true },
						{"title": "Tiempo de Permanencia", "data": "TiempoPermanencia", "class": "text-center", "searchable": false, "orderable": false },
						{"title": "Tiempo Transcurrido", "data": "TiempoTranscurrido", "class": "text-center", "searchable": false, "orderable": false },
						{"title": "Equipo Comprado", "data": "EquipoComprado", "class": "text-center", "searchable": true, "orderable": false },
						{"title": "Penalidad", "data": "Penalidad", "class": "text-center", "searchable": true, "orderable": false },
						{"title": "Estado", "data": "EstadoContrato", "class": "text-center", "searchable": true },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE LISTADO DE CONTRATOS DE LINEA****/
		
        /***********************************/
        
		$('#txtPeriodoPermanencia_rcl').select2({
            dropdownParent: $('#registroContratoLinea .modal-body')
        });
        
		$('#txtEstado_contrato_rcl').select2({
            dropdownParent: $('#informacionContrato .modal-body')
        });
        
        $('#txtEstado_contrato_rcl').next('.select2').addClass('select2-container--locked');
        
        $(document).on('change', '#txtOperador_rcl', function() 
        {
            var modal = $(this).attr("data-modal");
            var idOperador = $(this).val();
            
            $("#txtPlan_rcl").empty();
            
            selectPlanes("txtPlan_rcl", idOperador, "", modal.substring(1));
        });
        
        $(document).on('change', '#chkContratoMovil_rcl', function() 
        {
            if(this.checked)
            {
                $(".contrato-movil").removeAttr("disabled");
                
                selectMarcas("txtMarcaMovil_rcl",'',"registroContratoLinea");
                
        		$('#txtModeloMovil_rcl').select2({
                    dropdownParent: $('#registroContratoLinea .modal-body')
                });
                
                $('#txtProveedor_rcl').select2({
                    dropdownParent: $('#registroContratoLinea .modal-body')
                });
                
                selectEstadosMovil("txtEstadoMovil_rcl", "ACT", "registroContratoLinea");
                selectMotivosEstadoMovil("txtMotivoMovil_rcl", "ACT", "", "registroContratoLinea");
                
                $('#txtEstadoMovil_rcl').next('.select2').addClass('select2-container--locked');
                
            }
            else
            {
                $(".contrato-movil").prop("disabled", "disabled");
            }
        });
        
        $(document).on('change', '#txtMarcaMovil_rcl', function() 
        {
            var modal       = $(this).attr("data-modal");
            var categoria   = $(this).attr("data-categoria");
            var idMarca     = $(this).val();
            
            $("#txtModeloMovil_rcl").empty();
            
            selectDispositivos("txtModeloMovil_rcl", idMarca, "", categoria, modal.substring(1));
        });
        
        /***********************************/
        
		$('#txtPeriodoPermanencia_i').select2({
            dropdownParent: $('#informacionContrato .modal-body')
        });
        
        $(document).on('change', '#txtOperador_i', function() 
        {
            var modal = $(this).attr("data-modal");
            var idOperador = $(this).val();
            
            $("#txtPlan_i").empty();
            
            selectPlanes("txtPlan_i", idOperador, "", modal.substring(1));
        });
        
        /***********************************/
        
	});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
        <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
        <!--        <div class="simplebar-height-auto-observer-wrapper">-->
        <!--            <div class="simplebar-height-auto-observer">-->
                        
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-mask">-->
        <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
        <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
        <!--                    <div class="simplebar-content" style="padding: 0px;">-->
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
        <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
        <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Registro Contrato -->
<div class="modal fade zoomIn" id="registroContratoLinea" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleregistroContratoLinea" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleregistroContratoLinea">Registrar Contrato</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formRegistroContratoLinea" class="formulario form-steps" autocomplete="off" action="<?= $baseUrl ?>/grabar-contrato" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
                    <div class="step-arrow-nav mb-3">
                        <ul class="nav nav-pills custom-nav nav-border-top nav-justified" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="tabInformacionLineaContrato" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionLineaContrato" type="button" role="tab" aria-controls="tabcontentInformacionLineaContrato" aria-selected="true" data-position="0">Información de Contrato</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tabInformacionLineaContratoMovil" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionLineaContratoMovil" type="button" role="tab" aria-controls="tabcontentInformacionLineaContratoMovil" aria-selected="false" data-position="1">Información de Móvil</button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="tabcontentInformacionLineaContrato" role="tabpanel" aria-labelledby="tabInformacionLineaContrato">
                            <div>
                                <div class="row col-12 m-0 p-0 d-flex">
                                    <input type="hidden" name="txtIdLinea" id="txtIdLinea" value="<?= $idLinea ?>">
                                    <div class="col-xxl-12 col-md-12 col-12 mb-3" id="ctnPenalidadContratoVigente">
					        
					                </div>
                                    <div class="col-xxl-6 col-md-12 col-12 mb-3">
        								<label for="txtOperador_rcl" class="form-label">Operador</label>
        								<select class="form-select" aria-label="Operador" id="txtOperador_rcl" name="txtOperador_rcl" data-modal="#registroContratoLinea">
        									<option selected="" value="">Seleccione una opción</option>
        								</select>
        							</div>
            						<div class="col-xxl-6 col-md-12 col-12 mb-3">
            							<label for="txtPlan_rcl" class="form-label">Plan</label>
                                        <select class="form-select" aria-label="Plan" id="txtPlan_rcl" name="txtPlan_rcl" data-modal="#registroContratoLinea">
            								<option selected="" value="">Seleccione una opción</option>
            							</select>
                                    </div>
            						<div class="col-xxl-12 col-md-12 col-12 px-3 mb-3">
            							<label for="txtInicioContrato_rcl" class="form-label">Inicio Contrato</label>
                                        <div class="input-group">
                                            <input type="date" class="form-control" aria-label="Inicio de contrato" id="txtInicioContrato_rcl" name="txtInicioContrato_rcl">
                                        </div>
                                    </div>
            						<div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
            							<label for="txtDiaFacturacion_rcl" class="form-label">Día facturación</label>
                                        <div class="input-group">
                                            <input type="number" min="1" max="31" class="form-control" aria-label="Día de facturación" id="txtDiaFacturacion_rcl" name="txtDiaFacturacion_rcl">
                                        </div>
                                    </div>
            						<div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
            						    <label for="txtPeriodoPermanencia_rcl" class="form-label">Permanencia</label>
            						    <select class="form-select" aria-label="Periodo de permanencia" id="txtPeriodoPermanencia_rcl" name="txtPeriodoPermanencia_rcl" data-modal="#registroContratoLinea">
            								<option selected="" value="">Seleccione una opción</option>
            								<option value="SP">SIN PERMANENCIA</option>
            								<option value="12">12 Meses</option>
            								<option value="18">18 Meses</option>
            								<option value="24">24 Meses</option>
            							</select>
                                    </div>
            						<div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
            							<label for="txtValorCuota_rcl">Cuota de equipo</label>
                                        <div class="input-group">
                                            <span class="input-group-text">S/.</span>
                                            <input type="number" step="0.01" class="form-control" aria-label="Valor de cuota de equipo" id="txtValorCuota_rcl" name="txtValorCuota_rcl" placeholder="Valor de cuota de equipo">
                                        </div>
                                    </div>
            						<div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
            							<label for="txtEstado_contrato_rcl" class="form-label">Estado</label>
                                        <select class="form-select" aria-label="Estado" id="txtEstado_contrato_rcl" name="txtEstado_contrato_rcl"  data-modal="#registroContratoLinea">
            								<option value="VIGENTE" selected>VIGENTE</option>
                                        </select>
                                    </div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabInformacionLineaContratoMovil">
                                    <i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Registrar Móvil
                                </button>
                            </div>
                        </div>
                         <!--end tab pane -->
                        <div class="tab-pane fade" id="tabcontentInformacionLineaContratoMovil" role="tabpanel" aria-labelledby="tabInformacionLineaContratoMovil">
                            <div>
                                <div class="row col-12 m-0 p-0 d-flex">
                                    <div class="col-12 mb-4 justify-content-center">
										<div class="col-xxl-12 col-md-12 col-12 border-sistema-2px p-2 d-flex justify-content-between align-items-center" style="border-radius: 15px;">
                						    <h5 class="color-sistema m-0" for="chkContratoMovil_rcl">¿El contrato incluye equipo?</h5>
                						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkContratoMovil_rcl">
                								<input class="form-check-input form-check-input-sistema" type="checkbox" role="switch" id="chkContratoMovil_rcl" name="chkContratoMovil_rcl">
                								<label class="form-check-label m-0" for="chkContratoMovil_rcl"></label>
                							</div>
                						</div>
									</div>
            						<div class="col-xxl-6 col-md-12 col-12 my-2">
            							<div>
            								<label for="txtMarcaMovil_rcl" class="form-label">Marca</label>
            								<select class="form-select select2-dinamico contrato-movil" aria-label="Marca" id="txtMarcaMovil_rcl" name="txtMarcaMovil_rcl" data-categoria="MOVIL" data-modal="#registroContratoLinea" disabled>
            									<option selected="" value="">Seleccione una opción</option>
            									
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-6 col-md-12 col-12 my-2">
            							<div>
            								<label for="txtModeloMovil_rcl" class="form-label">Modelo</label>
            								<select class="form-select select2-dinamico contrato-movil" aria-label="Tipo" id="txtModeloMovil_rcl" name="txtModeloMovil_rcl" data-modal="#registroContratoLinea" disabled>
            									<option selected="" value="">Seleccione una opción</option>
            									
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-12 col-md-12 col-12 my-2">
            							<label for="txtProveedor_rcl" class="form-label">Proveedor</label>
            							<select class="form-select contrato-movil" aria-label="Proveedor" id="txtProveedor_rcl" name="txtProveedor_rcl" data-modal="#registroContratoLinea" disabled>
            								<option selected="" value="">Seleccione una opción</option>
            								<option value="ENTEL">ENTEL</option>
            								<option value="LOGÍSTICA">LOGÍSTICA</option>
            							</select>
            						</div>
            						<div class="col-xxl-12 col-md-12 col-12 my-2">
            							<div>
            								<label for="txtIMEI_rcl" class="form-label">IMEI</label>
            								<input type="number" class="form-control contrato-movil" id="txtIMEI_rcl" name="txtIMEI_rcl" disabled>
            							</div>
            						</div>
            						<div class="col-xxl-12 col-md-12 col-12 my-2">
            							<div>
            								<label for="txtFechaCompra_rcl" class="form-label">Fecha Compra</label>
            								<input type="date" class="form-control contrato-movil" id="txtFechaCompra_rcl" name="txtFechaCompra_rcl" value="<?= date("Y-m-d") ?>" disabled>
            							</div>
            						</div>
            						<div class="col-xxl-6 col-md-12 col-12 my-2">
            							<label for="txtPrecioCompra_rcl" class="form-label">Precio Compra</label>
            							<div class="input-group">
            							    <span class="input-group-text">S/.</span>
            								<input type="number" class="form-control contrato-movil" step="0.01" id="txtPrecioCompra_rcl" name="txtPrecioCompra_rcl" disabled>
            							</div>
            						</div>
            						<div class="col-xxl-6 col-md-12 col-12 my-2">
									    <label for="txtPrecioLista_rcl" class="form-label">Precio Lista</label>
                                        <div class="input-group">
                                            <span class="input-group-text">S/.</span>
                                            <input type="number" class="form-control contrato-movil" step="0.01" id="txtPrecioLista_rcl" name="txtPrecioLista_rcl" disabled>
                                        </div>
                                    </div>
									<div class="col-12 my-3  justify-content-center">
                						<div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-2 d-flex justify-content-between align-items-center" style="border-radius: 10px;" disabled>
                						    <h5 class="color-white m-0">¿Equipo Stock?</h5>
                						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center">
                								<input class="form-check-input form-check-input-green contrato-movil" type="checkbox" role="switch" name="chkEquipoStock_rcl" id="chkEquipoStock_rcl" disabled>
                								<label class="form-check-label" for="chkEquipoStock_rcl"></label>
                							</div>
                						</div>
                					</div>
            						<div class="row col-12 p-0 m-0" id="ctnEstadosMovil">
            							<div class="col-xxl-6 col-md-12 col-12 my-2">
            								<label for="txtEstadoMovil_rcl" class="form-label">Estado</label>
            								<select class="form-select contrato-movil" aria-label="Estado" id="txtEstadoMovil_rcl" name="txtEstadoMovil_rcl" data-modal="#registroContratoLinea" disabled>
            									
            								</select>
            							</div>
            							<div class="col-xxl-6 col-md-12 col-12 my-2">
            								<label for="txtMotivoMovil_rcl" class="form-label">Motivo</label>
            								<select class="form-select select2-dinamico contrato-movil" aria-label="Motivo" id="txtMotivoMovil_rcl" name="txtMotivoMovil_rcl" data-modal="#registroContratoLinea" disabled>
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            							</div>
            						</div>
								</div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionLineaContrato"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a información del contrato</button>
                                <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                            </div>
                        </div>
                         <!--end tab pane -->
                    </div>
                     <!--end tab content -->
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Información Contrato -->
<div class="modal fade zoomIn" id="informacionContrato" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionContrato" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionContrato">Información de Contrato</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionContrato" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDContrato_i" name="txtIDContrato_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtOperador_i" class="form-label">Operador</label>
							<select class="form-select select2-dinamico" aria-label="Operador" id="txtOperador_i" name="txtOperador_i" data-modal="#informacionContrato">
								<option selected="" value="">Seleccione una opción</option>
							</select>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtPlan_i" class="form-label">Plan</label>
                            <select class="form-select select2-dinamico" aria-label="Plan" id="txtPlan_i" name="txtPlan_i" data-modal="#informacionContrato">
								<option selected="" value="">Seleccione una opción</option>
							</select>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 px-3 mb-3">
							<label for="txtInicioContrato_i" class="form-label">Inicio Contrato</label>
                            <div class="input-group">
                                <input type="date" class="form-control" aria-label="Inicio de contrato" id="txtInicioContrato_i" name="txtInicioContrato_i">
                            </div>
                        </div>
						<div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
							<label for="txtDiaFacturacion_i" class="form-label">Día facturación</label>
                            <div class="input-group">
                                <input type="number" min="1" max="31" class="form-control" aria-label="Día de facturación" id="txtDiaFacturacion_i" name="txtDiaFacturacion_i">
                            </div>
                        </div>
						<div class="col-xxl-6 col-md-12 col-12 px-3 mb-3">
							<label for="txtValorCuota_i">Cuota de equipo</label>
                            <div class="input-group">
                                <span class="input-group-text">S/.</span>
                                <input type="number" step="0.01" class="form-control" aria-label="Valor de cuota de equipo" id="txtValorCuota_i" name="txtValorCuota_i" placeholder="Valor de cuota de equipo">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 px-3 mb-3">
						    <label for="txtPeriodoPermanencia_i" class="form-label">Permanencia</label>
						    <select class="form-select" aria-label="Periodo de permanencia" id="txtPeriodoPermanencia_i" name="txtPeriodoPermanencia_i" data-modal="#informacionContrato">
								<option selected="" value="">Seleccione una opción</option>
								<option value="SP">SIN PERMANENCIA</option>
								<option value="12">12 Meses</option>
								<option value="18">18 Meses</option>
								<option value="24">24 Meses</option>
							</select>
                        </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" id="btnEjecutarContrato" class="btn bg-success color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Información Movil -->
<div class="modal fade zoomIn" id="informacionMovil" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionMovil" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionMovil">Información de móvil</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionMovil" class="formulario" autocomplete="off" action="" method="POST" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDMovil_i" name="txtIDMovil_i">
					<div class="row">
					    <div class="row col-12 m-0">
    						<div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-2 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px;">
    						    <h5 class="color-white m-0">¿Equipo Stock?</h5>
    						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center">
    								<input class="form-check-input form-check-input-green" type="checkbox" role="switch" name="chkEquipoStock_i" id="chkEquipoStock_i" >
    								<label class="form-check-label" for="chkEquipoStock_i"></label>
    							</div>
    						</div>
    					</div>
						<div class="col-xxl-6 col-md-12 col-12 my-2">
							<div>
								<label for="txtMarca_i" class="form-label">Marca</label>
								<select class="form-select select2-dinamico" aria-label="Marca" id="txtMarca_i" name="txtMarca_i" data-categoria="MOVIL" data-modal="#informacionMovil">
									<option selected="" value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
						<div class="col-xxl-6 col-md-12 col-12 my-2">
							<div>
								<label for="txtModeloComercial_i" class="form-label">Modelo</label>
								<select class="form-select select2-dinamico" aria-label="Tipo" id="txtModeloComercial_i" name="txtModeloComercial_i" data-modal="#informacionMovil">
									<option selected="" value="">Seleccione una opción</option>
									
								</select>
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 my-2">
							<label for="txtProveedor_i" class="form-label">Proveedor</label>
							<select class="form-select" aria-label="Proveedor" id="txtProveedor_i" name="txtProveedor_i" data-modal="#informacionMovil">
								<option selected="" value="">Seleccione una opción</option>
								<option value="ENTEL">ENTEL</option>
								<option value="LOGÍSTICA">LOGÍSTICA</option>
							</select>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 my-2">
							<div>
								<label for="txtIMEI_i" class="form-label">IMEI</label>
								<input type="number" class="form-control" id="txtIMEI_i" name="txtIMEI_i">
							</div>
						</div>
						<div class="col-xxl-12 col-md-12 col-12 my-2">
							<div>
								<label for="txtFechaCompra_i" class="form-label">Fecha Compra</label>
								<input type="date" class="form-control" id="txtFechaCompra_i" name="txtFechaCompra_i" value="<?= date("Y-m-d") ?>">
							</div>
						</div>
						<div class="col-xxl-6 col-md-12 col-12 my-2">
							<div>
								<label for="txtPrecioCompra_i" class="form-label">Precio Compra</label>
								<input type="number" class="form-control" step="0.01" id="txtPrecioCompra_i" name="txtPrecioCompra_i">
							</div>
						</div>
						<div class="col-xxl-6 col-md-12 col-12 my-2">
							<div>
								<label for="txtPrecioLista_i" class="form-label">Precio Lista</label>
								<input type="number" class="form-control" step="0.01" id="txtPrecioLista_i" name="txtPrecioLista_i">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>