<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								<button class="btn bg-morado d-flex justify-content-center align-items-center mx-1 color-white" data-bs-target="#kardexAccesoriosIT" data-form="#formKardexAccesoriosIT" id="btnKardexAccesoriosIT">
									<i class="mdi mdi-tray-arrow-up me-1" style="font-size: 14px;"></i>Kardex
								</button>
								<a href="<?= $baseUrl.'/registros-descargas-kardex' ?>" class="btn bg-warning d-flex justify-content-center align-items-center mx-1 color-white">
									<i class="mdi mdi-file-export me-1" style="font-size: 14px;"></i>Exportar
								</a>
								<?php
								if (in_array("ADDAIT", $permisos)) 
								{
								?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white datos-accesorio-it" data-bs-target="#informacionAccesorio" data-form="#formInformacionAccesorioIT" data-id="0" data-accion="crear" id="crear-accesorio-it">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblAccesoriosIT" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE LISTADO DE ACCESORIOS IT***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblAccesoriosIT').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/accesorios-it-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						}
					},
					"columns": [
						{"title": "Código", "data": "IDAccesorio", "class": "text-center", "searchable": true },
						{"title": "Accesorio", "data": "Accesorio", "class": "text-center", "searchable": true },
						{"title": "Navision", "data": "CodigoNavision", "class": "text-center", "searchable": true },
						{"title": "Marca", "data": "Marca", "class": "text-center", "searchable": true },
						{"title": "Modelo", "data": "Modelo", "class": "text-center", "searchable": true, "orderable": false },
						{"title": "Cantidad", "data": "CantidadTotal", "class": "text-center", "searchable": true },
						{"title": "¿Genera Cobro?", "data": "GeneraCobroAccesorio", "class": "text-center", "searchable": true },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE LISTADO DE ACCESORIOS IT****/
		
        /***********************************/
        
		$('#txtModeloComercial_i').select2({
            dropdownParent: $('#informacionAccesorio .modal-body')
        });
        
        /***********************************/
        
		$('#cboTipoRegistro_k').select2({
            dropdownParent: $('#kardexAccesoriosIT .modal-body')
        });
        
        $(document).on('change', '#cboTipoRegistro_k', function() {
            var tipoRegistro = $(this).val();
            
            if(tipoRegistro == "SAL")
            {
                $("#ctnImputadoKardexAccesoriosIT").removeClass("d-none");
            }
            else
            {
                $("#ctnImputadoKardexAccesoriosIT").addClass("d-none");
            }
            
        });

        $("#txtUsuarioImputado_k").select2({
            minimumInputLength: 2,
            placeholder: 'Seleccione Usuario',
            dropdownParent: $('#kardexAccesoriosIT .modal-body'),
            allowClear: true,
            language: {
                errorLoading: function() {
                    return "La carga falló";
                },
                noResults: function() {
                    return "No hay resultado";
                },
                searching: function() {
                    return "Buscando..";
                }
            },
            ajax: {
                url: baseUrl + '/listado-usuarios-select',
                dataType: 'json',
                type: "POST",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data
                    };
                }
            }
        });
        /***********************************/
        
	});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
        <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
        <!--        <div class="simplebar-height-auto-observer-wrapper">-->
        <!--            <div class="simplebar-height-auto-observer">-->
                        
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-mask">-->
        <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
        <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
        <!--                    <div class="simplebar-content" style="padding: 0px;">-->
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
        <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
        <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Información Accesorio -->
<div class="modal fade zoomIn" id="informacionAccesorio" data-bs-backdrop="static" role="dialog" aria-labelledby="exampleinformacionAccesorio" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-md" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionAccesorio">Registrar Accesorio</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionAccesorioIT" class="formulario" action="" method="POST" autocomplete="off" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="row modal-body">
				    <input type="hidden" name="txtIDAccesorioIT" id="txtIDAccesorioIT" >
					<div class="col-xxl-8 col-md-12 col-12 mb-3">
						<div>
							<label for="txtAccesorioIT" class="form-label" style="color: #0A497B;">Accesorio</label>
							<input type="text" class="form-control" style="color: #0A497B; border-color: #0A497B;" id="txtAccesorioIT" name="txtAccesorioIT">
						</div>
					</div>
					<div class="col-xxl-4 col-md-12 col-12 mb-3">
						<div>
							<label for="txtCodNavisionAccesorioIT" class="form-label">Código Navision</label>
							<input type="text" class="form-control" id="txtCodNavisionAccesorioIT" name="txtCodNavisionAccesorioIT">
						</div>
					</div>
				    <div class="col-xxl-6 col-md-12 col-12 mb-3">
						<div>
							<label for="txtMarca_i" class="form-label">Marca</label>
							<select class="form-select" aria-label="Marca" id="txtMarca_i" name="txtMarca_i" data-categoria="HARDWARE" data-modal="#informacionAccesorio">
								<option selected="" value="">Seleccione una opción</option>
								
							</select>
						</div>
					</div>
					<div class="col-xxl-6 col-md-12 col-12 mb-3">
						<div>
							<label for="txtModeloComercial_i" class="form-label">Modelo</label>
							<select class="form-select" aria-label="Tipo" id="txtModeloComercial_i" name="txtModeloComercial_i" data-modal="#informacionAccesorio">
								<option selected="" value="">Seleccione una opción</option>
								
							</select>
						</div>
					</div>
				    <div class="col-xxl-12 col-md-12 col-12 mb-3">
						<div>
							<label for="txtObservacionAccesorio_i" class="form-label">Observación</label>
							<textarea class="form-control" id="txtObservacionAccesorio_i" name="txtObservacionAccesorio_i" rows="4"></textarea>
						</div>
					</div>
					<div class="col-xxl-12 col-md-12 col-12 mb-3">
						<div>
							<label for="txtInicialAccesorioIT" class="form-label" >Cantidad</label>
							<input type="number" step="1" min="0" class="form-control" value="0" id="txtInicialAccesorioIT" name="txtInicialAccesorioIT">
						</div>
					</div>
					<div class="col-xxl-6 col-md-12 col-12 mb-3">
						<label for="txtPrecioNuevoAccesorioIT" class="form-label" >Precio Nuevo (S/)</label>
						<div class="input-group">
						    <span class="input-group-text">S/.</span>
							<input type="number" step="1" min="1" class="form-control" value="1" id="txtPrecioNuevoAccesorioIT" name="txtPrecioNuevoAccesorioIT">
						</div>
					</div>
					<div class="col-xxl-6 col-md-12 col-12 mb-3">
						<label for="txtPrecioReutilizadoAccesorioIT" class="form-label" >Precio Reutilizado (S/)</label>
						<div class="input-group">
						    <span class="input-group-text">S/.</span>
							<input type="number" step="1" min="1" class="form-control" value="1" id="txtPrecioReutilizadoAccesorioIT" name="txtPrecioReutilizadoAccesorioIT">
						</div>
					</div>
					<div class="col-12 col-md-12 px-3">
						<div class="col-xxl-12 col-md-12 col-12 border-sistema-2px p-2 d-flex justify-content-between align-items-center" style="border-radius: 15px;">
						    <h5 class="color-sistema m-0" for="chkGeneraCobroAccesorioIT_i">¿Genera cobro?</h5>
						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="chkGeneraCobroAccesorioIT_i">
								<input class="form-check-input form-check-input-sistema" type="checkbox" role="switch" name="chkGeneraCobroAccesorioIT_i" id="chkGeneraCobroAccesorioIT_i">
								<label class="form-check-label m-0" for="chkGeneraCobroAccesorioIT_i"></label>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-center align-items-center color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" id="btnEjecutarAccesorioIT" class="btn bg-success d-flex justify-content-center align-items-center color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i> Registrar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Registro Movimientos Kardex Accesorios -->
<div class="modal fade zoomIn" id="kardexAccesoriosIT" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplekardexAccesoriosIT" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplekardexAccesoriosIT">Registro de Entradas y Salidas de Kardex</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formKardexAccesoriosIT" class="formulario" autocomplete="off" action="<?= $baseUrl ?>/registrar-kardex-accesorio-it" method="POST" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
				    <h3 class="mb-3">Elementos</h3>
					<div class="row mb-3">
				        <div class="col-xxl-7 col-md-12 col-12 mb-3">
    						<div>
    							<label for="cboTipoRegistro_k" class="form-label">Tipo Registro:</label>
    							<select class="form-select" aria-label="Marca" id="cboTipoRegistro_k" name="cboTipoRegistro_k" data-modal="#kardexAccesoriosIT">
    								<option selected="" value="">Seleccione una opción</option>
    								<option value="ENT">Entrada</option>
    								<option value="SAL">Salida</option>
    							</select>
    						</div>
    					</div>
				        <div class="col-xxl-12 col-md-12 col-12 mb-3 d-none" id="ctnImputadoKardexAccesoriosIT">
    						<div>
    							<label for="txtUsuarioImputado_k" class="form-label">Imputado:</label>
    							<select class="form-select" aria-label="Imputado" id="txtUsuarioImputado_k" name="txtUsuarioImputado_k" data-modal="kardexAccesoriosIT">
    								<option selected="" value="">Seleccione una opción</option>
    								
    							</select>
    						</div>
    					</div>
				        <div class="col-xxl-9 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtAccesorioIT_k" class="form-label">Accesorio IT:</label>
    							<select class="form-select" aria-label="Accesorio" id="txtAccesorioIT_k" name="txtAccesorioIT_k" data-modal="kardexAccesoriosIT">
    								<option selected="" value="">Seleccione una opción</option>
    								
    							</select>
    						</div>
    					</div>
    					<div class="col-xxl-3 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtCantidadAccesorioIT_k" class="form-label" >Cantidad</label>
    							<input type="number" step="1" min="1" class="form-control" value="1" id="txtCantidadAccesorioIT_k" name="txtCantidadAccesorioIT_k">
    						</div>
    					</div>
    					<div class="col-xxl-12 col-md-12 col-12 mb-3">
    						<div>
    							<label for="txtConceptoAccesorioIT_k" class="form-label" >Concepto</label>
    							<input type="text" class="form-control" id="txtConceptoAccesorioIT_k" name="txtConceptoAccesorioIT_k">
    						</div>
    					</div>
					    <div class="col-xxl-9 col-md-12 col-12">
							<div>
								<label for="txtObservacionAccesorioIT_k" class="form-label">Observación</label>
								<textarea class="form-control" id="txtObservacionAccesorioIT_k" name="txtObservacionAccesorioIT_k" rows="2"></textarea>
							</div>
						</div>
    				    <div class="col-xxl-3 col-md-12 col-12 p-3 d-flex justify-content-end align-items-end">
    				        <button type="button" class="btn bg-info d-flex align-items-center color-white" id="btnAgregarElementoKardexAccesoriosIT">
								<i class="mdi mdi-plus-thick me-1" style="font-size: 14px;"></i>Agregar
							</button>
    				    </div>
					</div>
					<hr>
					<h3 class="mb-3">Registros</h3>
					<div class="row col-12 m-0" id="ctnRegistrosKardexAccesoriosIT">
					    
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
					<button type="submit" class="btn bg-success d-flex justify-content-end align-items-center color-white"><i class="mdi mdi-content-save me-2 color-white" style="font-size: 14px;"></i>Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Listado Movimientos Kardex Accesorios -->
<div class="modal fade zoomIn" id="movimientosKardexAccesoriosIT" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemovimientosKardexAccesoriosIT" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemovimientosKardexAccesoriosIT">Listado de Entradas y Salidas de Kardex</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
			    <div class="row col-12 m-0 p-0">
			        <input type="hidden" id="txtIDAccesorioIT_lk">
			        <div class="col-xxl-5 col-md-12 col-12 p-3 d-flex justify-content-center align-items-center">
                        <div class="input-group">
                            <span class="input-group-text" id="basic-addon1">Inicio</span>
                            <input type="date" class="form-control" placeholder="Fecha de Inicio" id="dtInicio_lk" aria-label="Fecha de Inicio" aria-describedby="basic-addon1">
                        </div>
                    </div>
			        <div class="col-xxl-5 col-md-12 col-12 p-3 d-flex justify-content-center align-items-center">
                        <div class="input-group">
                            <span class="input-group-text" id="basic-addon1">Fin</span>
                            <input type="date" class="form-control" placeholder="Fecha de Fin" id="dtFinal_lk" aria-label="Fecha de Fin" aria-describedby="basic-addon1">
                        </div>
                    </div>
			        <div class="col-xxl-2 col-md-12 col-12 p-3 d-flex justify-content-end align-items-end">
			            <button type="button" class="btn bg-info d-flex align-items-center color-white" id="btnBuscarMovimientosKardexAccesoriosIT" >
							<i class="mdi mdi-magnify me-1" style="font-size: 14px;"></i>Buscar
						</button>
                    </div>
			    </div>
			    <div id="ctnListadoMovimientosKardexAccesoriosIT" class="col-12 m-0 p-0 d-flex justify-content-center align-items-center">
    			    
                </div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn bg-danger d-flex justify-content-end align-items-center color-white" data-bs-dismiss="modal"><span class="mdi mdi-close-thick me-2" style="font-size: 14px;"></span>Cerrar</button>
			</div>
		</div>
	</div>
</div>

<?php $this->endSection(); ?>