<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
                                <button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
					</div>
				</div>
			</div>
            <div class="row">
                <?php
                    // Obtener la fecha actual
                    $hoy = new \DateTime();
            
                    // Calcular el lunes (ISO-8601: 1=lunes, 7=domingo)
                    $lunes = clone $hoy;
                    $lunes->modify('Monday this week');
            
                    // Calcular el domingo
                    $domingo = clone $hoy;
                    $domingo->modify('Sunday this week');
                ?>
                <div class="col-xl-4 col-lg-6">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1">Asignación pendientes por firmar | Fecha de creación</h4>
                        </div><!-- end card header -->
                        <div class="row card-body m-0 p-0">
                            <div class="col-12">
                                <canvas id="cnvAsignacionPendienteFirmaCreacionIT" width="500" height="200" aria-label="Asignación pendientes por firmar por Fecha de Creación" role="img"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Asignación pendientes por firmar | Activo</h4>
                        </div>
                        <div class="card-body">
                            <canvas id="cnvAsignacionPendienteFirmaActivo" width="500" height="200" aria-label="Asignación pendientes por firmar por Activo" role="img"></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-6">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">Activos pendientes por Validar | Devolución</h4>
                        </div>
                        <div class="card-body">
                            <canvas id="cnvActivosPendientesValidar" width="500" height="200" aria-label="Activos pendientes por validar" role="img"></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 d-none">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1">Asignación pendientes por firmar | Fecha de creación</h4>
                            <div class="flex-shrink-0">
                                <div data-tooltip="tooltip" title="Filtrar">
                                    <div class="form-check card-radio">
                                        <input id="chkFiltroAsignacionPendientesFirmaCreacion" name="chkFiltroAsignacionPendientesFirmaCreacion" type="checkbox" class="form-check-input">
                                        <label class=" btn bg-filtros px-2 py-1" for="chkFiltroAsignacionPendientesFirmaCreacion" data-tooltip="tooltip" title="Filtrar">
                                            <i class="mdi mdi-filter" style="font-size: 18px; color: #FFF"></i>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div><!-- end card header -->
                        <div class="row card-body m-0 p-0">
                            <div class="row col-12 m-0 p-0">
                                <div class="collapse m-0 p-0" id="asdasdasdads" style="">
                                    <div class="row col-12 m-0 p-0 mb-3 d-flex">
                                        <div class="col-xxl-5 col-md-12 col-12 p-2">
                                		    <label class="form-label">Inicio Búsqueda</label>
                                			<div class="input-group">
                                                <span class="input-group-text mdi mdi-calendar-text-outline" style="font-size: 15px;"></span>
                                                <input type="date" class="form-control" id="asdasdasd" value="<?= $lunes->format('Y-m-d') ?>">
                                            </div>
                                		</div>
                                        <div class="col-xxl-5 col-md-12 col-12 p-2">
                                		    <label class="form-label">Final Búsqueda</label>
                                			<div class="input-group">
                                                <span class="input-group-text mdi mdi-calendar-text-outline" style="font-size: 15px;"></span>
                                                <input type="date" class="form-control" id="sdadasdasd" value="<?= $domingo->format('Y-m-d') ?>">
                                            </div>
                                		</div>
                                        <div class="col-xxl-2 col-md-12 col-12 p-2 d-flex justify-content-center align-items-center">
                                            <button type="button" class="btn bg-primary px-2 py-1" data-tooltip="tooltip" title="Actualizar Gráfica">
                                                <i class="mdi mdi-refresh" style="font-size: 18px; color: #FFF"></i>
                                            </button>
                                		</div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-12">
                                <canvas id="asdasdasdasads" width="500" height="200" aria-label="Asignación pendientes por firmar por Fecha de Creación" role="img"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<?= $this->section('js'); ?>
<script>
	$(function () {
	    
        $(document).on('click', '#btnBuscarFiltrosDashboard', function() 
        {
            recargarGraficaAsignacionPendienteFirmaCreacion();
            recargarGraficaAsignacionPendienteFirmaActivo();
            recargarGraficaPendientesValidar();
        });
	    
        recargarGraficaAsignacionPendienteFirmaCreacion();
        recargarGraficaAsignacionPendienteFirmaActivo();
        recargarGraficaPendientesValidar();

    // $.ajax({        
    //     url: baseUrl + '/grafica-modelo-moviles-direccion',
    //     type: "POST",
    //     dataType: 'json',
    //     success: function(response) {
    //         crearGraficaModeloMovilesDireccion(response, "cnvModeloMovilesDireccion");
    //     }, 
    //     error: function(jqXHR, textStatus, errorThrown){
    //         //$.unblockUI({});
    //         Swal.close();
            
    //         Swal.fire({
    //             title: 'Ha ocurrido un error interno',
    //             text: errorThrown,
    //             icon: 'error',
    //             showCancelButton: false,
    //             confirmButtonColor: '#E4002B',
    //             confirmButtonText: 'Confirmar'
    //         });
    //     }
    // });

    // $.ajax({        
    //     url: baseUrl + '/grafica-modelo-moviles',
    //     type: "POST",
    //     dataType: 'json',
    //     success: function(response) {
    //         // console.log(response);
    //         crearGraficaModeloMoviles(response, "cnvModeloMoviles");
    //     }, 
    //     error: function(jqXHR, textStatus, errorThrown){
    //         //$.unblockUI({});
    //         Swal.close();
            
    //         Swal.fire({
    //             title: 'Ha ocurrido un error interno',
    //             text: errorThrown,
    //             icon: 'error',
    //             showCancelButton: false,
    //             confirmButtonColor: '#E4002B',
    //             confirmButtonText: 'Confirmar'
    //         });
    //     }
    // });
});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <div id="ctnFiltro" class="p-3">
			<div class="panel">
                <div class="panel-heading">
                    <h4>Fechas de búsqueda</h4>
                </div>
                <div class="panel-content">
                    <div class="row">
                        <div class="col-xxl-12 col-md-12 col-12 p-2">
                		    <label class="form-label">Inicio Búsqueda</label>
                			<div class="input-group">
                                <span class="input-group-text mdi mdi-calendar-text-outline" style="font-size: 15px;"></span>
                                <input type="date" class="form-control" id="dtInicioAsignacionPendientesFirmaCreacionIT" value="<?= $lunes->format('Y-m-d') ?>">
                            </div>
                		</div>
                        <div class="col-xxl-12 col-md-12 col-12 p-2">
                		    <label class="form-label">Final Búsqueda</label>
                			<div class="input-group">
                                <span class="input-group-text mdi mdi-calendar-text-outline" style="font-size: 15px;"></span>
                                <input type="date" class="form-control" id="dtFinalAsignacionPendientesFirmaCreacionIT" value="<?= $domingo->format('Y-m-d') ?>">
                            </div>
                		</div>
                    </div>
                </div>
            </div>
			<div class="panel">
                <div class="panel-heading">
                    <h4>Activos</h4>
                </div>
                <div class="panel-content">
                    <div class="row">
                        <div class="col-xxl-6 col-md-12 col-12 p-1 m-0">
                            <div class="d-flex justify-content-left">
                                <center class="content-left" style="position: relative; height: 40px;">
                                    <input type="checkbox" id="chkFiltroLINEA" name="activosdashboard" class="chk-basico chk-filtro chkActivosDashboard" value="LINEA">
                                    <label for="chkFiltroLINEA"></label>
                    			</center>
                    			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="chkFiltroLINEA">Línea</label>
                    		</div>
                    	</div>
                        <div class="col-xxl-6 col-md-12 col-12 p-1 m-0">
                            <div class="d-flex justify-content-left">
                                <center class="content-left" style="position: relative; height: 40px;">
                                    <input type="checkbox" id="chkFiltroMOVIL" name="activosdashboard" class="chk-basico chk-filtro chkActivosDashboard" value="MOVIL">
                                    <label for="chkFiltroMOVIL"></label>
                    			</center>
                    			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="chkFiltroMOVIL">Móvil</label>
                    		</div>
                    	</div>
                        <div class="col-xxl-6 col-md-12 col-12 p-1 m-0">
                            <div class="d-flex justify-content-left">
                                <center class="content-left" style="position: relative; height: 40px;">
                                    <input type="checkbox" id="chkFiltroHARDWARE" name="activosdashboard" class="chk-basico chk-filtro chkActivosDashboard" value="HARDWARE">
                                    <label for="chkFiltroHARDWARE"></label>
                    			</center>
                    			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="chkFiltroHARDWARE">Hardware</label>
                    		</div>
                    	</div>
                        <div class="col-xxl-6 col-md-12 col-12 p-1 m-0">
                            <div class="d-flex justify-content-left">
                                <center class="content-left" style="position: relative; height: 40px;">
                                    <input type="checkbox" id="chkFiltroTARJETA" name="activosdashboard" class="chk-basico chk-filtro chkActivosDashboard" value="TARJETA">
                                    <label for="chkFiltroTARJETA"></label>
                    			</center>
                    			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center  text-start" for="chkFiltroTARJETA">Tarjetas de Acceso</label>
                    		</div>
                    	</div>
                        <div class="col-xxl-6 col-md-12 col-12 p-1 m-0">
                            <div class="d-flex justify-content-left">
                                <center class="content-left" style="position: relative; height: 40px;">
                                    <input type="checkbox" id="chkFiltroACCESORIOIT" name="activosdashboard" class="chk-basico chk-filtro chkActivosDashboard" value="ACCESORIOIT">
                                    <label for="chkFiltroACCESORIOIT"></label>
                    			</center>
                    			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="chkFiltroACCESORIOIT">Accesorio IT</label>
                    		</div>
                    	</div>
                    	<div class="col-xxl-6 col-md-12 col-12 p-1 m-0">
                            <div class="d-flex justify-content-left">
                                <center class="content-left" style="position: relative; height: 40px;">
                                    <input type="checkbox" id="chkFiltroKITDEMO" name="activosdashboard" class="chk-basico chk-filtro chkActivosDashboard" value="KITDEMO">
                                    <label for="chkFiltroKITDEMO"></label>
                    			</center>
                    			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center  text-start" for="chkFiltroKITDEMO">Kits Demo</label>
                    		</div>
                    	</div>
                    	<div class="col-xxl-6 col-md-12 col-12 p-1 m-0">
                            <div class="d-flex justify-content-left">
                                <center class="content-left" style="position: relative; height: 40px;">
                                    <input type="checkbox" id="chkFiltroELEMENTOTRABAJO" name="activosdashboard" class="chk-basico chk-filtro chkActivosDashboard" value="ELEMENTOTRABAJO">
                                    <label for="chkFiltroELEMENTOTRABAJO"></label>
                    			</center>
                    			<label class="m-0 p-0 ms-1 d-flex justify-content-left align-items-center text-start" for="chkFiltroELEMENTOTRABAJO">Elementos de Trabajo</label>
                    		</div>
                    	</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltrosDashboard">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Detalle Fecha Asignacion Pendiente Firma Creacion -->
<div class="modal fade zoomIn" id="mdlDetalleFechaAsignacionPendienteFirmaCreacion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlDetalleFechaAsignacionPendienteFirmaCreacion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlDetalleFechaAsignacionPendienteFirmaCreacion">Detalle de Pendientes de Firma</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
			    <div class="col-12">
                    <table id="tblDetalleFechaAsignacionPendienteFirmaCreacion" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
                        <thead>
							<tr>
								<th class="text-center align-middle">ID Asignación</th>
								<th class="text-center align-middle">Fecha Asignación</th>
								<th class="text-center align-middle">Asignado</th>
								<th class="text-center align-middle">Matrícula</th>
								<th class="text-center align-middle">Delegación</th>
								<th class="text-center align-middle">Dispositivos Asignados</th>
								<th class="text-center align-middle">Acciones</th>
							</tr>
						</thead>
						<tbody>
						</tbody>
                    </table>
                </div>
				<div class="col-12">
                    <canvas id="cnvDetalleFechaAsignacionPendienteFirmaCreacion" width="500" height="200" aria-label="Asignación pendientes por firmar" role="img"></canvas>
                </div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn bg-danger color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
			</div>
		</div>
	</div>
</div>

<!-- Modal Detalle Fecha Asignacion Pendiente Firma Activos -->
<div class="modal fade zoomIn" id="mdlDetalleFechaAsignacionPendienteFirmaActivos" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlDetalleFechaAsignacionPendienteFirmaActivos" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlDetalleFechaAsignacionPendienteFirmaActivos">Detalle de Pendientes de Firma</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
			    <div class="col-12">
                    <table id="tblDetalleFechaAsignacionPendienteFirmaActivo" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
                        <thead>
							<tr>
								<th class="text-center align-middle">ID Asignación</th>
								<th class="text-center align-middle">Fecha Asignación</th>
								<th class="text-center align-middle">Asignado</th>
								<th class="text-center align-middle">Matrícula</th>
								<th class="text-center align-middle">Delegación</th>
								<th class="text-center align-middle">Dispositivos Asignados</th>
								<th class="text-center align-middle">Acciones</th>
							</tr>
						</thead>
						<tbody>
						</tbody>
                    </table>
                </div>
				<div class="col-12">
                    <canvas id="cnvDetalleFechaAsignacionPendienteFirmaActivos" width="500" height="200" aria-label="Asignación pendientes por firmar" role="img"></canvas>
                </div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn bg-danger color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
			</div>
		</div>
	</div>
</div>

<!-- Modal Detalle activos pendientes por validar -->
<div class="modal fade zoomIn" id="mdlDetallePendientesValidacion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="examplemdlDetallePendientesValidacion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplemdlDetallePendientesValidacion">Detalle de Pendientes de Validar recepción</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
			    <div class="col-12">
                    <table id="tblDetallePendientesValidar" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
                        <thead>
							<tr>
								<th class="text-center align-middle">ID Devolución</th>
								<th class="text-center align-middle">Fecha devolución</th>
								<th class="text-center align-middle">Activo</th>
								<th class="text-center align-middle">Marca</th>
								<th class="text-center align-middle">Modelo</th>
								<th class="text-center align-middle">Serie</th>
								<th class="text-center align-middle">Acciones</th>
							</tr>
						</thead>
						<tbody>
						</tbody>
                    </table>
                </div>
			</div>
			<div class="modal-footer">
				<button type="button" class="btn bg-danger color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
			</div>
		</div>
	</div>
</div>

<!-- end main content-->
<?php $this->endSection(); ?>