<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
                                <a href="<?= $baseUrl ?>/listar-dispositivos/TOTAL" class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white">
									<i class="mdi mdi-devices me-1" style="font-size: 14px;"></i>Dispositivos
								</a>
								<?php
								if (in_array("ADDMAR", $permisos)) 
								{
								?>
                                <button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white" data-bs-toggle="modal" data-bs-target="#registrarMarca" id="btnRegistrarMarca">
									<i class="mdi mdi-plus-circle me-1" style="font-size: 14px;"></i>Nuevo
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblMarcas" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
	$(function () {
		/***SERVERSIDE LISTADO DE MARCAS***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblMarcas').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/marcas-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    //arrayrutavista.length-1 para obtener la ruta del controller
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						}
					},
					"columns": [
						{"title": "Código", "data": "IDMarca", "class": "text-center", "searchable": true },
						{"title": "Marca", "data": "Marca", "class": "text-center", "searchable": true },
						{"title": "Estado", "data": "EstadoMarca", "class": "text-center", "searchable": true },
						{"title": "Acciones", "data": "acciones", "class": "text-center", "searchable": false, "orderable": false },
					],
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
					autoWidth: false,
					"pageLength": 10,
					"paging": true,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		/****FIN SERVERSIDE LISTADO MARCAS****/
		
		selectCategorias("categoriaDispositivo", "TOTAL", "registrarMarca");
		
		$('#tipoDispositivo').select2({
            dropdownParent: $('#registrarMarca .modal-body')
        });
        
        $('#subtipoDispositivo').select2({
            dropdownParent: $('#registrarMarca .modal-body')
        });
        
        $(document).on('change', '#categoriaDispositivo', function() 
        {
            var modal = $(this).attr("data-modal");
            var idCategoria = $(this).val();
            
            $("#tipoDispositivo").empty();
            $("#subtipoDispositivo").empty();
            selectTipos('tipoDispositivo', idCategoria, '', modal);
        });
        
        $(document).on('change', '#tipoDispositivo', function() 
        {
            var modal = $(this).attr("data-modal");
            var idTipo = $(this).val();
            
            $("#subtipoDispositivo").empty();
            selectSubtipos('subtipoDispositivo', idTipo, '', modal);
        });
        
	});
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
        <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
        <!--        <div class="simplebar-height-auto-observer-wrapper">-->
        <!--            <div class="simplebar-height-auto-observer">-->
                        
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-mask">-->
        <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
        <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
        <!--                    <div class="simplebar-content" style="padding: 0px;">-->
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
        <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
        <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Registro Marca -->
<!--<div class="modal fade zoomIn" id="registrarMarca" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleregistrarMarca" aria-hidden="true">-->
<!--	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">-->
<!--		<div class="modal-content" style="border: none;">-->
<!--			<div class="modal-header bg-sistema p-3">-->
<!--				<h5 class="modal-title color-white" id="exampleregistrarMarca">Registrar Marca</h5>-->
<!--				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>-->
<!--			</div>-->
<!--			<form id="formRegistrarMarca" class="formulario form-steps" autocomplete="off" action="<?= $baseUrl ?>/registrar-marca" method="POST">-->
<!--				<span class="respuesta"></span>-->
<!--				<div class="modal-body">-->
<!--				</div>-->
<!--				<div class="modal-footer">-->
<!--					<button type="button" class="btn bg-danger color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>-->
<!--					<button type="submit" class="btn bg-success color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Registrar</button>-->
<!--				</div>-->
<!--			</form>-->
<!--		</div>-->
<!--	</div>-->
<!--</div>-->
<div class="modal fade zoomIn" id="registrarMarca" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleregistrarMarca" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleregistrarMarca">Registrar Marca</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formRegistrarMarca" class="formulario form-steps" autocomplete="off" action="<?= $baseUrl ?>/registrar-marca" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
                    <div class="step-arrow-nav mb-3">
                        <ul class="nav nav-pills custom-nav nav-border-top nav-justified" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="tabInformacionMarca" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionMarca" type="button" role="tab" aria-controls="tabcontentInformacionMarca" aria-selected="true" data-position="0">Información de la Marca</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tabInformacionDispositivosMarca" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionDispositivosMarca" type="button" role="tab" aria-controls="tabcontentInformacionDispositivosMarca" aria-selected="false" data-position="1">Información de Dispositivos</button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="tabcontentInformacionMarca" role="tabpanel" aria-labelledby="tabInformacionMarca">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
                                    <div class="col-xxl-12 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtMarca_rm" class="form-label" >Marca</label>
            								<input type="text" class="form-control" id="txtMarca_rm" name="txtMarca_rm">
            							</div>
            						</div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabInformacionDispositivosMarca">
                                    <i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Registrar Dispositivos
                                </button>
                            </div>
                        </div>
                         <!--end tab pane -->
                        <div class="tab-pane fade" id="tabcontentInformacionDispositivosMarca" role="tabpanel" aria-labelledby="tabInformacionDispositivosMarca">
                            <div>
                                <h3 class="mb-3">Agregar Dispositivos</h3>
                                <div class="card-text mb-3">
									<div class="form-group row">
										<div class="col-12">
											<label for="modeloDispositivo">Modelo de Dispositivo</label>
											<input type="text" class="form-control" id="modeloDispositivo" placeholder="Modelo de Dispositivo">
										</div>
									</div>
								</div>
								<div class="card-text mb-4">
									<div class="form-group row">
										<div class="col-4">
											<label for="categoriaDispositivo">Categoría</label>
											<select class="form-select select2-dinamico" id="categoriaDispositivo" data-modal="registrarMarca">
											</select>
										</div>
										<div class="col-4">
											<label for="tipoDispositivo">Tipo</label>
											<select class="form-select select2-dinamico" id="tipoDispositivo" data-modal="registrarMarca">
											</select>
										</div>
										<div class="col-4">
											<label for="subtipoDispositivo">Subtipo</label>
											<select class="form-select select2-dinamico" id="subtipoDispositivo" data-modal="registrarMarca">
											</select>
										</div>
									</div>
								</div>
								<div class="card-text mb-3">
									<div class="form-group row">
										<div class="col-8 justify-content-center">
											<div class="col-xxl-12 col-md-12 col-12 border-sistema-2px p-2 d-flex justify-content-between align-items-center" style="border-radius: 15px;">
                    						    <h5 class="color-sistema m-0" for="descontinuadoDispositivo">¿Modelo descontinuado?</h5>
                    						    <div class="form-check form-switch form-switch-lg d-flex justify-content-start align-items-center" for="descontinuadoDispositivo">
                    								<input class="form-check-input form-check-input-sistema" type="checkbox" role="switch" id="descontinuadoDispositivo">
                    								<label class="form-check-label m-0" for="descontinuadoDispositivo"></label>
                    							</div>
                    						</div>
										</div>
										<div class="col-4 d-flex justify-content-end align-items-center">
										    <button type="button" class="btn bg-info px-2 py-1 ms-3 color-white d-flex justify-content-end align-items-center" onclick="return agregarDispositivo('ctnDispositivosMarcaRegistro');" data-tooltip="tooltip" aria-label="Agregar Dispositivo">
                                                <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i> Agregar Dispositivo
                                            </button>
										</div>
									</div>
								</div>
								<hr class="my-4">
								<h3 class="mb-3">Dispositivos</h3>
								<div class="row col-12 m-0 p-0 d-flex" id="ctnDispositivosMarcaRegistro">
								    
        				        </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionMarca"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a información del hardware</button>
                                <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                            </div>
                        </div>
                         <!--end tab pane -->
                    </div>
                     <!--end tab content -->
				</div>
			</form>
		</div>
	</div>
</div>


<!-- Modal Información Marca -->
<div class="modal fade zoomIn" id="informacionMarca" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleinformacionMarca" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="exampleinformacionMarca">Información de marca</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionMarca" class="formulario" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDMarca_i" name="txtIDMarca_i">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtMarca_i" class="form-label">Marca</label>
							<div class="input-group">
								<input type="text" class="form-control" aria-label="Marca" id="txtMarca_i" name="txtMarca_i">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn bg-danger color-white" data-bs-dismiss="modal"><i class="mdi mdi-close-thick mx-1" style="font-size: 14px;"></i>Cerrar</button>
					<button type="submit" id="btnEjecutarMarca" class="btn bg-success color-white"><i class="mdi mdi-content-save mx-1" style="font-size: 14px;"></i>Actualizar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>