<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $elementoSeleccionadoModulo ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $subtitulo ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("ADDDEV", $permisos)) 
								{
								?>
								<button class="btn bg-sistema d-flex justify-content-center align-items-center mx-1 color-white" data-bs-target="#registrarDevolucion" data-form="#formRegistrarDevolucion" id="btnRegistrarDevolucion" data-placement="top" title="Registrar Nueva Devolución" aria-label="Registrar Nueva Devolución">
									<i class="mdi mdi-arrow-u-right-bottom-bold me-1" style="font-size: 14px;"></i>Devolver
								</button>
								<?php
								}
								?>
								<button type="button" class="btn bg-filtros color-white px-2 py-1 mx-1 waves-effect waves-light layout-rightside-btn" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas" aria-controls="theme-settings-offcanvas">
                                    <i class="mdi mdi-filter" style="font-size: 18px;"></i>
                                </button>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblDevoluciones" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://www.verisure.pe/">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<?= $this->section('js'); ?>
<script>
    $(function () {
	    /***SERVERSIDE DEVOLUCIONES***/
		assetListVM = {
			dt: null,
			init: function () {
				dt = $('#tblDevoluciones').DataTable({
					"serverSide": true,
					"processing": true,
					"ajax": {
						"url": baseUrl + "/devoluciones-serverside",
						type: 'POST',
						data: function(d) {
						    let rutavista = window.location.href;
						    let arrayrutavista = rutavista.split("/");
						    d.url_vista = arrayrutavista[arrayrutavista.length-1];
						}
					},
					"columns": [
						{"title": "Código", "data": "IDDevolucion", "class": "text-center", "searchable": true },
						{"title": "Matrícula", "data": "MatriculaUsuario", "class": "text-center", "searchable": true },
						{"title": "Usuario Devolución", "data": "NombreUsuario", "class": "text-center", "searchable": true },
						{"title": "Fecha Devolución", "data": "FechaDevolucion", "class": "text-center", "searchable": true },
						{"title": "Usuarip Receptor", "data": "NombreReceptor", "class": "text-center", "searchable": true },
						{"title": "Observación", "data": "Observacion", "class": "text-center", "searchable": true },
						{"title": "¿Firmado?", "data": "Firma", "class": "text-center", "searchable": true },
						{"title": "Acciones", "data": "Acciones", "class": "text-center", "searchable": true }
					],
                    "drawCallback": function(settings) {
                        // Re-inicializar tooltips después de que los datos son cargados
                        $('[data-tooltip="tooltip"]').tooltip();
                        $('[data-toggle="tooltip"]').tooltip();
                    },
					"lengthMenu": [[10, 25, 50], [10, 25, 50]],
					responsive: true,
                    columnDefs: [
                        { responsivePriority: 1, targets: 0 },
                        { responsivePriority: 1, targets: 1 },
                        { responsivePriority: 1, targets: 2 },
                        { responsivePriority: 6, targets: 3 },
                        { responsivePriority: 6, targets: 4 },
                        { responsivePriority: 10, targets: 5 },
                        { responsivePriority: 1, targets: 6 },
                        { responsivePriority: 1, targets: 7 }
                    ],
					autoWidth: false,
					"aaSorting": [[0, 'desc']],
				});
			}
		}

		assetListVM.init();
		
    	$("#txtUsuarioDevolucionModal").select2({
            minimumInputLength: 2,
            placeholder: 'Seleccione Usuario',
            dropdownParent: $('#registrarDevolucion .modal-body'),
            allowClear: true,
            language: {
                errorLoading: function() {
                    return "La carga falló";
                },
                noResults: function() {
                    return "No hay resultado";
                },
                searching: function() {
                    return "Buscando..";
                }
            },
            ajax: {
                url: baseUrl + '/listado-usuarios-select',
                dataType: 'json',
                type: "POST",
                quietMillis: 50,
                data: function (term) {
                    return {
                        term: term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data
                    };
                }
            }
        });
        
        $(document).on('change', '#txtUsuarioDevolucionModal', function() {
            var idUsuario           = $(this).val();
            var motivoDevolucion    = $("#txtMotivoDevolucion").val();
            
            if(idUsuario != '')
            {
                /* MOSTRAR INFORMACIÓN DE USUARIO SELECCIONADO */
                
                var parametros = {
                    "idUsuario"  : idUsuario
            	};
            	
                $.ajax({        
                    url: baseUrl + '/obtener-datos-usuario',
                    type: "POST",
                    data: parametros,
                    dataType: 'json',
                    beforeSend: function() {
                        Swal.fire({
                            html: 'Un momento por favor...',
                            heightAuto: true,
                            showConfirmButton: false
                        });
                    },
                    success: function(response) {
                        Swal.close();
                        if (response.descripcion === 0 || response.descripcion === 2) 
                        {
                            Swal.fire({
                                title: response.mensaje,
                                icon: 'warning',
                                showCancelButton: false,
                                confirmButtonColor: '#282E38',
                                confirmButtonText: 'Confirmar'
                            });
                            $('#txtUsuarioDevolucionModal').val('').trigger('change');
                            $('#txtMatriculaDevolucion').val('');
                            $('#txtNombreDevolucion').val('');
                            $('#txtApellidoDevolucion').val('');
                            $('#txtDocumentoDevolucion').val('');
                            $('#txtDireccionDevolucion').val('');
                            $('#txtAreaDevolucion').val('');
                            $('#txtCargoDevolucion').val('');
                        }
                        else 
                        {
                            $('#txtMatriculaDevolucion').val(response.matricula);
                            $('#txtNombreDevolucion').val(response.nombres);
                            $('#txtApellidoDevolucion').val(response.apellidos);
                            $('#txtDocumentoDevolucion').val(response.documento);
                            $('#txtDireccionDevolucion').val(response.direccion);
                            $('#txtAreaDevolucion').val(response.area);
                            $('#txtCargoDevolucion').val(response.cargo);
                        }
                        
                        $('.validarNextTab').blur();
                    }, 
                    error: function(jqXHR, textStatus, errorThrown){
                        //$.unblockUI({});
                        Swal.close();
                        
                        Swal.fire({
                            title: 'Ha ocurrido un error interno',
                            text: errorThrown,
                            icon: 'error',
                            showCancelButton: false,
                            confirmButtonColor: '#E4002B',
                            confirmButtonText: 'Confirmar'
                        });
                    }
                });
                
                if(motivoDevolucion != '')
                {
                    /* CARGAR ELEMENTOS A DEVOLVER */
                    mostrarElementosDevolver(idUsuario, motivoDevolucion);
                }
                
            }
        });

    	$("#txtMotivoDevolucion").select2({
            dropdownParent: $('#registrarDevolucion .modal-body')
        });
        
    	$("#txtMotivoNegativa").select2({
            dropdownParent: $('#registrarDevolucion .modal-body')
        });
        
        
        $(document).on('change', '#txtMotivoDevolucion', function(e) 
        {
            var idUsuario           = $("#txtUsuarioDevolucionModal").val();
            var motivoDevolucion    = $(this).val();
            
            if(idUsuario != '' && motivoDevolucion != '')
            {
                /* CARGAR ELEMENTOS A DEVOLVER */
                mostrarElementosDevolver(idUsuario, motivoDevolucion);
            }
            
            if(motivoDevolucion == "CESE")
            {
                $("#ctnPreguntaEmailDevolucion").removeClass("d-none");
                $('input[name="txtPreguntaEmailDevolucion"]').prop("checked", false);
                $('#ctnMotivoNoCorreoPersonalDevolucion').collapse('hide');
                $('#ctnCorreoPersonalDevolucion').collapse('hide');
                $('#txtCorreoPersonalDevolucion').val("");
                $('#txtNroCelularPersonalDevolucion').val("");
                $('#txtCorreoPersonalDevolucion').prop("disabled", true);
                $('#txtNroCelularPersonalDevolucion').prop("disabled", true);
                $('#txtMotivoNegativa').val("").trigger('change');
            }
            else
            {
                $("#ctnPreguntaEmailDevolucion").addClass("d-none");
                $('input[name="txtPreguntaEmailDevolucion"]').prop("checked", false);
                $('#ctnMotivoNoCorreoPersonalDevolucion').collapse('hide');
                $('#ctnCorreoPersonalDevolucion').collapse('hide');
                $('#txtCorreoPersonalDevolucion').val("");
                $('#txtNroCelularPersonalDevolucion').val("");
                $('#txtCorreoPersonalDevolucion').prop("disabled", true);
                $('#txtNroCelularPersonalDevolucion').prop("disabled", true);
                $('#txtMotivoNegativa').val("").trigger('change');
            }
        });
        
        pondDenunciaDevolucion = FilePond.create(
            document.querySelector("#fileDenunciaDevolucion"), {
                labelIdle: 'Arrastre y suelte el archivo a subir o <span class="filepond--label-action">explore</span>',
                allowMultiple: false,
                instantUpload: false,
                allowProcess: false
            }
        );
    });
</script>
<?php $this->endSection(); ?>

<!-- Filtros -->
<div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas" aria-modal="true" role="dialog">
    <div class="d-flex align-items-center bg-filtros bg-gradient p-3 offcanvas-header">
        <h5 class="m-0 me-2 text-white">Filtros</h5>

        <button type="button" class="btn-close btn-close-white ms-auto" id="customizerclose-btn" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body p-0">
        <!--<div data-simplebar="init" class="h-100 simplebar-scrollable-y">-->
        <!--    <div class="simplebar-wrapper" style="margin: 0px;">-->
        <!--        <div class="simplebar-height-auto-observer-wrapper">-->
        <!--            <div class="simplebar-height-auto-observer">-->
                        
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-mask">-->
        <!--            <div class="simplebar-offset" style="right: 0px; bottom: 0px;">-->
        <!--                <div class="simplebar-content-wrapper" tabindex="0" role="region" aria-label="scrollable content" style="height: 100%; overflow: hidden scroll;">-->
        <!--                    <div class="simplebar-content" style="padding: 0px;">-->
            <div id="ctnFiltro" class="p-3">
				<div class="card border" style="border-top: 3px #536878 solid!important;">
					<div class="card-header">
                        <div class="d-flex align-items-center">
                            <div class="flex-grow-1">
                                <h6 class="card-title mb-0">Columnas</h6>
                            </div>
                            <div class="flex-shrink-0">
                                <ul class="list-inline card-toolbar-menu d-flex align-items-center mb-0">
                                    <li class="list-inline-item">
                                        <a class="align-middle minimize-card" data-bs-toggle="collapse" href="#collapseColumnasFiltros" role="button" aria-expanded="true" aria-controls="collapseColumnasFiltros">
                                            <i class="mdi mdi-plus align-middle plus"></i>
                                            <i class="mdi mdi-minus align-middle minus"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
					<div class="card-body collapse show" id="collapseColumnasFiltros" style="">
						cxcvcxxvxcxcv
					</div>
				</div>
				<div class="panel">
                    <div class="panel-heading">
                        <h4>Columnas</h4>
                    </div>
                    <div class="panel-content">
                        <div class="row">
                            adasasads
                        </div>
                    </div>
                </div>
            </div>
        <!--                    </div>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--        <div class="simplebar-placeholder" style="width: 400px; height: 1978px;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-horizontal" style="visibility: hidden;">-->
        <!--        <div class="simplebar-scrollbar" style="width: 0px; display: none;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--    <div class="simplebar-track simplebar-vertical" style="visibility: visible;">-->
        <!--        <div class="simplebar-scrollbar" style="height: 314px; transform: translate3d(0px, 0px, 0px); display: block;">-->
                    
        <!--        </div>-->
        <!--    </div>-->
        <!--</div>-->
    </div>
    <div class="offcanvas-footer border-top p-3 text-center">
        <div class="row">
            <div class="col-4">
                <button type="button" class="btn btn-light w-100" id="btnLimpiar">Limpiar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-danger w-100" id="btnCerrarFiltros" data-bs-dismiss="offcanvas" aria-label="Close">Cerrar</button>
            </div>
            <div class="col-4">
                <button type="button" class="btn btn-primary w-100" id="btnBuscarFiltros">Buscar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Registrar Devolución -->
<div class="modal fade zoomIn" id="registrarDevolucion" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="exampleregistrarDevolucion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema d-flex justify-content-start align-items-center p-3">
				<h5 class="modal-title color-white" id="exampleregistrarDevolucion">Solicitar Devolución</h5>
                <button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close" id="close-modal"></button>
			</div>
			<form id="formRegistrarDevolucion" class="formularioRegistrarDevolucion form-steps" autocomplete="off" action="<?= $baseUrl ?>/guardar-devolucion" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
                    <div class="step-arrow-nav mb-4">
                        <ul class="nav nav-pills custom-nav nav-border-top nav-justified" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="tabSolicitudDevolucion" data-bs-toggle="pill" data-bs-target="#tabcontentSolicitudDevolucion" type="button" role="tab" aria-controls="tabcontentSolicitudDevolucion" aria-selected="true" data-position="0">Información de Usuario</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tabDetalleDevolucion" data-bs-toggle="pill" data-bs-target="#tabcontenDetalleDevolucion" type="button" role="tab" aria-controls="tabcontenDetalleDevolucion" aria-selected="false" data-position="1">Elementos a devolver</button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="tabcontentSolicitudDevolucion" role="tabpanel" aria-labelledby="tabSolicitudDevolucion">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-8 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Usuario Solicitante</label>
            								<input type="text" class="form-control" style="color: #0000FF" value="<?= $nombres.' '.$apellidos ?>" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Matrícula Solicitante</label>
            								<input type="text" class="form-control" style="color: #0000FF" value="<?= $matriculaLog ?>" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
                                    <div class="col-xxl-8 col-md-12 col-12 px-3">
                                        <div>
                                            <label for="txtUsuarioDevolucionModal" class="form-label">Usuario a devolver</label>
                                            <select class="form-select" aria-label="Usuario a devolver" id="txtUsuarioDevolucionModal" name="txtUsuarioDevolucion" data-modal="#registrarDevolucion">
                                                <option selected="" value="">Seleccione una opción</option>
                                            </select>
                                        </div>
                                    </div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtMatriculaDevolucion" class="form-label" >Matrícula</label>
            								<input type="text" class="form-control validarNextTab" id="txtMatriculaDevolucion" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtNombreDevolucion" class="form-label" >Nombre</label>
            								<input type="text" class="form-control validarNextTab" id="txtNombreDevolucion" name="txtNombreDevolucion" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtApellidoDevolucion" class="form-label">Apellido</label>
            								<input type="text" class="form-control validarNextTab" id="txtApellidoDevolucion" name="txtApellidoDevolucion" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtDocumentoDevolucion" class="form-label">Documento</label>
            								<input type="text" class="form-control validarNextTab" id="txtDocumentoDevolucion" name="txtDocumentoDevolucion" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtDireccionDevolucion" class="form-label" >Dirección</label>
            								<input type="text" class="form-control validarNextTab" id="txtDireccionDevolucion" name="txtDireccionDevolucion" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtAreaDevolucion" class="form-label">Área</label>
            								<input type="text" class="form-control validarNextTab" id="txtAreaDevolucion" name="txtAreaDevolucion" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtCargoDevolucion" class="form-label">Cargo</label>
            								<input type="text" class="form-control validarNextTab" id="txtCargoDevolucion" name="txtCargoDevolucion" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 px-3">
            						    <div>
                                            <label for="txtMotivoDevolucion" class="form-label">Motivo de devolución</label>
                                            <select class="form-select validarNextTab" aria-label="Motivo" id="txtMotivoDevolucion" name="txtMotivoDevolucion" data-modal="#registrarDevolucion">
                                                <option selected="" value="">Seleccione una opción</option>
                                                <option value="CESE">CESE</option>
                                                <option value="USUARIO NO INGRESÓ">USUARIO NO INGRESÓ</option>
                                                <option value="OTROS">OTROS MOTIVOS</option>
                                            </select>
                                        </div>
            						</div>
        					    </div>
        					    <div id="ctnPreguntaEmailDevolucion" class="row col-12 m-0 p-0 mb-3 d-none">
            					    <div>
                                        <p class="color-red m-0">¿El usuario cuenta con email personal?:</p>
                                    </div>
                                    <div class="row g-4 m-0 p-0">
                                        <div class="col-lg-6 col-sm-6 px-3 mt-3">
                                            <div>
                                                <div class="form-check card-radio">
                                                    <input id="rdbtnSiEmailPersonalDevolucion" name="txtPreguntaEmailDevolucion" type="radio" class="form-check-input" value="Y">
                                                    <label class="form-check-label" for="rdbtnSiEmailPersonalDevolucion">
                                                        <span class="fs-16 text-muted me-2"><i class="mdi mdi-thumb-up align-bottom"></i></span>
                                                        <span class="fs-14 text-wrap">SI</span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-sm-6 px-3 mt-3">
                                            <div>
                                                <div class="form-check card-radio">
                                                    <input id="rdbtnNoEmailPersonalDevolucion" name="txtPreguntaEmailDevolucion" type="radio" class="form-check-input" value="N">
                                                    <label class="form-check-label" for="rdbtnNoEmailPersonalDevolucion">
                                                        <span class="fs-16 text-muted me-2"><i class="mdi mdi-thumb-down align-bottom"></i></span>
                                                        <span class="fs-14 text-wrap">NO</span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div id="ctnCorreoPersonalDevolucion" class="collapse m-0 p-0">
                                    <div class="row col-12 m-0 p-0 mb-3 d-flex">
                						<div class="col-xxl-6 col-md-12 col-12 px-3">
                							<div>
                								<label for="txtCorreoPersonalDevolucion" class="form-label">Email Personal (Usuario a devolver)</label>
                								<input type="email" class="form-control validarNextTab" id="txtCorreoPersonalDevolucion" name="txtCorreoPersonalDevolucion">
                							</div>
                						</div>
                						<div class="col-xxl-6 col-md-12 col-12 px-3">
                							<div>
                								<label for="txtNroCelularPersonalDevolucion" class="form-label">Nro Celular Personal (Usuario a devolver)</label>
                								<input type="number" class="form-control validarNextTab" id="txtNroCelularPersonalDevolucion" name="txtNroCelularPersonalDevolucion">
                							</div>
                						</div>
            					    </div>
            					</div>
            					<div id="ctnMotivoNoCorreoPersonalDevolucion" class="collapse m-0 p-0">
                                    <div class="row col-12 m-0 p-0 mb-3 d-flex">
                						<div class="col-xxl-12 col-md-12 col-12 px-3">
                						    <div>
                                                <label for="txtMotivoNegativa" class="form-label">Motivo de la negativa</label>
                                                <select class="form-select validarNextTab" aria-label="Motivo" id="txtMotivoNegativa" name="txtMotivoNegativa" data-modal="#registrarDevolucion">
                                                    <option selected="" value="">Seleccione una opción</option>
                                                    <option value="NO TIENE CORREO PERSONAL">NO TIENE CORREO PERSONAL</option>
                                                    <option value="NO DESEA DAR SU CORREO PERSONAL">NO DESEA DAR SU CORREO PERSONAL</option>
                                                    <option value="OTROS MOTIVOS">OTROS MOTIVOS</option>
                                                </select>
                                            </div>
                						</div>
            					    </div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtObservacion" class="form-label">Observación</label>
            								<textarea class="form-control validarNextTab" id="txtObservacion" name="txtObservacion" rows="4"></textarea>
            							</div>
            						</div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabDetalleDevolucion" id="btnNextTab" disabled><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Ingresar elementos</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                        <div class="tab-pane fade" id="tabcontenDetalleDevolucion" role="tabpanel" aria-labelledby="tabDetalleDevolucion">
                            <div>
        					    <div class="row col-12 m-0 p-0 mb-0 d-flex">
        					        <div class="alert alert-warning border-0" role="alert">
                                        <li>Si la situación de algún elemento no es DEVOLUCIÓN OK, se generará el ACTA DE REPOSICIÓN automáticamente.</li>
                                        <li>Si la situación de algún elemento es ROBO o PÉRDIDA, deberá adjuntar la DENUNCIA POLICIAL para validar dichas reposiciones.</li>
                                    </div>
        					    </div>
                                <div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-3 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px; font-size: 15px;">
            					    Elementos a devolver
            					</div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex" id="ctnElementosDevolucion">
            						
        					    </div>
        					    <div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-3 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px; font-size: 15px;">
            					    Denuncia policial
            					</div>
            					<div class="row col-12 m-0 p-0 d-flex justify-content-center">
            						<div class="col-10 m-0 p-0">
            					        <input type="file" id="fileDenunciaDevolucion" class="filepond" name="fileDenunciaDevolucion" data-max-file-size="100MB" data-max-files="1" />
            					    </div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-light btn-label previestab" data-previous="tabSolicitudDevolucion"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a la asignación</button>
                                <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                    </div>
                    <!-- end tab content -->
				</div>
			</form>
		</div>
	</div>
</div>

<?php $this->endSection(); ?>